/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.orbit.automation.experimental.SpringForce;
import java.util.ArrayList;

public class SpringModel {

    static class MicroAdjustment<T> {
        InterfaceMicroAdjustment<T> myInterface;
        protected ArrayList<T> collection = new ArrayList();
        protected ArrayList<ArrayList<SpringForce>> springs = new ArrayList();
        double minForce;
        long stepLength;
        long minStep;
        double minFitnessChange;

        public MicroAdjustment(InterfaceMicroAdjustment<T> microInterface, ArrayList<T> list) {
            this.myInterface = microInterface;
            this.collection = list;
            this.minForce = this.myInterface.getMinForce();
            this.stepLength = this.myInterface.getStepDistance();
            this.minStep = this.myInterface.getMinDistance();
            this.minFitnessChange = this.myInterface.getMinFitnessChange();
            for (int i = 0; i < this.collection.size(); ++i) {
                ArrayList newList = new ArrayList();
                this.springs.add(newList);
            }
        }

        public void createSpringForce(T obj1, T obj2, double springConstant, long ancPointXObj1, long ancPointYObj1, long ancPointXObj2, long ancPointYObj2) {
            SpringForce force = new SpringForce(obj1, obj2, springConstant, ancPointXObj1, ancPointYObj1, ancPointXObj2, ancPointYObj2);
            SpringForce oppositeForce = force.getForceFromOtherObj();
            int obj1Index = this.collection.indexOf(obj1);
            int obj2Index = this.collection.indexOf(obj2);
            this.springs.get(obj1Index).add(force);
            this.springs.get(obj2Index).add(oppositeForce);
        }

        public double findTotalSpringForceX(T obj) {
            double totalForce = 0.0;
            for (SpringForce s : this.springs.get(this.collection.indexOf(obj))) {
                totalForce += s.getX();
            }
            return totalForce;
        }

        public double findTotalSpringForceY(T obj) {
            double totalForce = 0.0;
            for (SpringForce s : this.springs.get(this.collection.indexOf(obj))) {
                totalForce += s.getY();
            }
            return totalForce;
        }

        public void moveObjUpdateSpring(T obj, long x, long y) {
            this.myInterface.move(x, y, obj);
            for (SpringForce s : this.springs.get(this.collection.indexOf(obj))) {
                s.move(obj, x, y);
                s.getOpposite().move(obj, x, y);
            }
        }

        public void sortCollection() {
            this.myInterface.sortObjects(this.collection);
        }

        public boolean contactHoriz(T obj) {
            long left = this.myInterface.getLeft(obj);
            long right = this.myInterface.getRight(obj);
            for (T o : this.collection) {
                if (o == obj) continue;
                long leftObj = this.myInterface.getLeft(o);
                long rightObj = this.myInterface.getRight(o);
                if (!(leftObj + this.myInterface.findGap(o, obj) < left & right < rightObj - this.myInterface.findGap(o, obj) | left + this.myInterface.findGap(o, obj) < leftObj & rightObj < right - this.myInterface.findGap(o, obj))) continue;
                return true;
            }
            return false;
        }

        public boolean contactVert(T obj) {
            long top = this.myInterface.getTop(obj);
            long bottom = this.myInterface.getBottom(obj);
            for (T o : this.collection) {
                if (AUtil.equals((Object)this.myInterface.getName(o), (Object)this.myInterface.getName(obj))) continue;
                long bottomObj = this.myInterface.getBottom(o);
                long topObj = this.myInterface.getTop(o);
                if (!(bottomObj + this.myInterface.findGap(o, obj) < bottom & top < topObj - this.myInterface.findGap(o, obj) | bottom + this.myInterface.findGap(o, obj) < bottomObj & topObj < top - this.myInterface.findGap(o, obj))) continue;
                return true;
            }
            return false;
        }

        public void adjustT(T obj) {
            double forceY;
            double forceX;
            double forceY2;
            long stepX = this.stepLength;
            long stepY = this.stepLength;
            double forceXDir = Math.signum(this.findTotalSpringForceX(obj));
            double forceYDir = Math.signum(this.findTotalSpringForceY(obj));
            long moveXPrev = 0L;
            long moveYPrev = 0L;
            double forcePrev = Double.MAX_VALUE;
            long totalMovement = Long.MAX_VALUE;
            if (String.valueOf(this.myInterface.getName(obj)).equals(String.valueOf("J1"))) {
                ALog.logDebug((String)"");
            }
            long moveX = Long.MAX_VALUE;
            long moveY = Long.MAX_VALUE;
            while (Math.abs(moveX) > this.minStep & Math.abs(moveY) > this.minStep) {
                double forceX2 = this.findTotalSpringForceX(obj);
                forceY2 = this.findTotalSpringForceY(obj);
                double force = Math.pow(forceX2, 2.0) + Math.pow(forceY2, 2.0);
                Boolean changeX = Math.signum(forceXDir) != Math.signum(forceX2) & !(forceXDir == 0.0 | forceX2 == 0.0);
                Boolean changeY = Math.signum(forceYDir) != Math.signum(forceY2) & !(forceYDir == 0.0 | forceY2 == 0.0);
                if (changeX & changeY) {
                    this.moveObjUpdateSpring(obj, -moveXPrev, -moveYPrev);
                    stepX /= 2L;
                    stepY /= 2L;
                    continue;
                }
                if (changeX.booleanValue()) {
                    this.moveObjUpdateSpring(obj, -moveXPrev, -moveYPrev);
                    stepX /= 2L;
                    continue;
                }
                if (changeY.booleanValue()) {
                    this.moveObjUpdateSpring(obj, -moveXPrev, -moveYPrev);
                    stepY /= 2L;
                    continue;
                }
                forceXDir = Math.signum(forceX2);
                forceYDir = Math.signum(forceY2);
                double forceAngle = Math.signum(forceY2) * Math.acos(forceX2 / Math.sqrt(Math.pow(forceX2, 2.0) + Math.pow(forceY2, 2.0)));
                moveX = (long)Math.floor(Math.cos(forceAngle) * (double)stepX);
                moveY = (long)Math.floor(Math.sin(forceAngle) * (double)stepY);
                this.moveObjUpdateSpring(obj, moveX, moveY);
                moveXPrev = moveX;
                moveYPrev = moveY;
                totalMovement = (long)Math.ceil(Math.sqrt(Math.pow(moveX, 2.0) + Math.pow(moveY, 2.0)));
                if (!this.myInterface.overlapsWithGap(obj, this.collection)) continue;
                Boolean contactVertical = this.contactVert(obj);
                Boolean contactHorizontal = this.contactHoriz(obj);
                if (contactVertical & contactHorizontal == false) {
                    this.moveObjUpdateSpring(obj, -moveX, -moveY);
                    stepX /= 2L;
                } else if (contactHorizontal & contactVertical == false) {
                    this.moveObjUpdateSpring(obj, -moveX, -moveY);
                    stepY /= 2L;
                } else {
                    this.moveObjUpdateSpring(obj, -moveX, -moveY);
                    double moveAngle = (double)Math.signum(moveY) * Math.acos((double)moveX / Math.sqrt(Math.pow(moveX, 2.0) + Math.pow(moveY, 2.0)));
                    if (Math.abs(moveAngle) % Math.PI < 0.7853981633974483 & Math.abs(moveAngle) % Math.PI > 2.356194490192345) {
                        stepY /= 2L;
                    } else {
                        stepX /= 2L;
                    }
                }
                if (!this.myInterface.withinBoundsWithGap(obj)) {
                    this.moveObjUpdateSpring(obj, -moveX, -moveY);
                    stepX /= 2L;
                    stepY /= 2L;
                }
                moveXPrev = 0L;
                moveYPrev = 0L;
            }
            if (Math.abs(moveX) <= this.minStep & Math.abs(moveY) > this.minStep) {
                long step = this.stepLength;
                while (step > this.minStep) {
                    forceX = this.findTotalSpringForceX(obj);
                    forceY = this.findTotalSpringForceY(obj);
                    double forceAngle = Math.signum(forceY) * Math.acos(forceX / Math.sqrt(Math.pow(forceX, 2.0) + Math.pow(forceY, 2.0)));
                    Boolean changeY = Math.signum(forceYDir) != Math.signum(forceY) & !(forceYDir == 0.0 | forceY == 0.0);
                    if (changeY.booleanValue()) {
                        this.moveObjUpdateSpring(obj, -moveXPrev, -moveYPrev);
                        step /= 2L;
                        continue;
                    }
                    forceXDir = Math.signum(forceX);
                    forceYDir = Math.signum(forceY);
                    moveY = (long)forceYDir * step;
                    this.moveObjUpdateSpring(obj, 0L, moveY);
                    moveXPrev = 0L;
                    moveYPrev = moveY;
                    totalMovement = (long)Math.ceil(Math.sqrt(Math.pow(0.0, 2.0) + Math.pow(moveY, 2.0)));
                    if (this.myInterface.overlapsWithGap(obj, this.collection)) {
                        this.moveObjUpdateSpring(obj, 0L, -moveY);
                        step /= 2L;
                        moveXPrev = 0L;
                        moveYPrev = 0L;
                    }
                    if (this.myInterface.withinBoundsWithGap(obj)) continue;
                    this.moveObjUpdateSpring(obj, 0L, -moveY);
                    step /= 2L;
                }
            } else if (Math.abs(moveY) <= this.minStep & Math.abs(moveX) > this.minStep) {
                long step = this.stepLength;
                while (step > this.minStep) {
                    forceX = this.findTotalSpringForceX(obj);
                    forceY = this.findTotalSpringForceY(obj);
                    double forceAngle = Math.signum(forceY) * Math.acos(forceX / Math.sqrt(Math.pow(forceX, 2.0) + Math.pow(forceY, 2.0)));
                    Boolean changeX = Math.signum(forceXDir) != Math.signum(forceX) & !(forceXDir == 0.0 | forceX == 0.0);
                    if (changeX.booleanValue()) {
                        this.moveObjUpdateSpring(obj, -moveXPrev, -moveYPrev);
                        step /= 2L;
                        continue;
                    }
                    forceXDir = Math.signum(forceX);
                    forceYDir = Math.signum(forceY);
                    moveX = (long)forceXDir * step;
                    this.moveObjUpdateSpring(obj, moveX, 0L);
                    moveXPrev = moveX;
                    moveYPrev = 0L;
                    totalMovement = (long)Math.ceil(Math.sqrt(Math.pow(0.0, 2.0) + Math.pow(moveX, 2.0)));
                    if (this.myInterface.overlapsWithGap(obj, this.collection)) {
                        this.moveObjUpdateSpring(obj, -moveX, 0L);
                        step /= 2L;
                        moveXPrev = 0L;
                        moveYPrev = 0L;
                    }
                    if (this.myInterface.withinBoundsWithGap(obj)) continue;
                    this.moveObjUpdateSpring(obj, -moveX, 0L);
                    step /= 2L;
                }
            }
            double forceX3 = this.findTotalSpringForceX(obj);
            forceY2 = this.findTotalSpringForceY(obj);
        }

        public void adjustDesign() {
            double currentFitness;
            double fitnessChange = currentFitness = this.myInterface.fitness(this.collection);
            while (fitnessChange > this.minFitnessChange) {
                for (T o : this.collection) {
                    this.adjustT(o);
                }
                fitnessChange = currentFitness - this.myInterface.fitness(this.collection);
            }
        }

        public ArrayList<T> getCollection() {
            return this.collection;
        }

        public void setCollection(ArrayList<T> list) {
            this.collection = list;
        }
    }

    static interface InterfaceMicroAdjustment<T> {
        public String getName(T var1);

        public long getLeft(T var1);

        public long getBottom(T var1);

        public long getRight(T var1);

        public long getTop(T var1);

        public boolean overlaps(T var1, ArrayList<T> var2);

        public boolean overlapsWithGap(T var1, ArrayList<T> var2);

        public boolean withinBoundsWithGap(T var1);

        public void move(long var1, long var3, T var5);

        public long findGap(T var1, T var2);

        public double getMinForce();

        public long getStepDistance();

        public long getMinDistance();

        public double fitness(ArrayList<T> var1);

        public long getMinFitnessChange();

        public void sortObjects(ArrayList<T> var1);
    }
}

