/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental.layerOptimizer;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import com.sigrity.orbit.automation.experimental.layerOptimizer.AbstractConnection;
import com.sigrity.orbit.automation.experimental.layerOptimizer.ConnectionsOnLayerList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;

public class ConnectionList<O, L>
extends ArrayList<ConnectionsOnLayerList<O, L>>
implements Chromosome {
    double fitness;

    @Override
    public String toString() {
        String result = this.stream().map(col -> col.toString()).reduce(" ", (accum, curCount) -> accum + curCount);
        return result;
    }

    protected LinkedList<AbstractConnection<O, L>> getLayerList(L l) {
        Optional<ConnectionsOnLayerList> any = this.stream().filter(col -> col.layer.equals(l)).findFirst();
        if (any.isPresent()) {
            return any.get().connections;
        }
        ConnectionsOnLayerList cl = new ConnectionsOnLayerList();
        cl.layer = l;
        cl.connections = new LinkedList();
        this.add(cl);
        return cl.connections;
    }

    public void addConnection(APoint2D a0, APoint2D b0, L layer, HashSet<L> validLayers, O reference, O altReference) {
        AbstractConnection<O, L> ac = new AbstractConnection<O, L>(a0, b0, layer, validLayers, reference, altReference);
        this.getLayerList(layer).add(ac);
    }

    @Override
    public void endOfEpoch() {
    }

    @Override
    public ConnectionList<O, L> mutate() {
        Chromosome mutant = this.deepCopy();
        int numLayers = ((ArrayList)((Object)mutant)).size();
        int randomFromLayer = (int)(Math.random() * (double)numLayers);
        int randomToLayer = (int)(Math.random() * (double)numLayers);
        int randomFromIndex = (int)(Math.random() * (double)((ConnectionsOnLayerList)((ArrayList)((Object)mutant)).get((int)randomFromLayer)).connections.size());
        AbstractConnection movingConnection = ((ConnectionsOnLayerList)((ArrayList)((Object)mutant)).get((int)randomFromLayer)).connections.get(randomFromIndex);
        ((ConnectionsOnLayerList)((ArrayList)((Object)mutant)).get((int)randomFromLayer)).connections.remove(randomFromIndex);
        ((ConnectionsOnLayerList)((ArrayList)((Object)mutant)).get((int)randomToLayer)).connections.add(movingConnection);
        movingConnection.layer = ((ConnectionsOnLayerList)this.get((int)randomToLayer)).layer;
        return mutant;
    }

    @Override
    public Chromosome mate(Chromosome c) {
        return c;
    }

    @Override
    public ConnectionList<O, L> deepCopy() {
        ConnectionList<O, L> clone = new ConnectionList<O, L>();
        int numLayers = this.size();
        for (int i = 0; i < numLayers; ++i) {
            ConnectionsOnLayerList list = (ConnectionsOnLayerList)this.get(i);
            ConnectionsOnLayerList coll = new ConnectionsOnLayerList();
            coll.layer = list.layer;
            coll.connections = new LinkedList();
            clone.add(coll);
            for (AbstractConnection abstractConnection : list.connections) {
                AbstractConnection copy = new AbstractConnection(abstractConnection.a0, abstractConnection.b0, abstractConnection.layer, abstractConnection.validLayers, abstractConnection.reference, abstractConnection.altReference);
                coll.connections.add(copy);
            }
        }
        clone.fitness = this.fitness;
        return clone;
    }

    @Override
    public double fitness() {
        int totalOnAllLayers = ((Stream)this.stream().parallel()).map(l -> this.totalIntersectionsOnLayer(l.connections)).reduce(0, (accum, curCount) -> accum + curCount);
        return totalOnAllLayers;
    }

    protected int totalIntersectionsOnLayer(LinkedList<AbstractConnection<O, L>> listForThislayer) {
        int sum = 0;
        int len = listForThislayer.size();
        ArrayList array = AUtil.arrayList(listForThislayer);
        for (int i = 0; i < len; ++i) {
            int thisConnectionSum = 0;
            for (int j = i + 1; j < len; ++j) {
                boolean intersection = this.intersects((AbstractConnection)array.get(i), (AbstractConnection)array.get(j));
                if (!intersection) continue;
                ++sum;
                ++thisConnectionSum;
            }
            ((AbstractConnection)array.get((int)i)).intersections = thisConnectionSum;
        }
        return sum;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public void updateCondition(String owner, long time) {
    }

    boolean intersects(AbstractConnection<O, L> a, AbstractConnection<O, L> b) {
        ALine al = new ALine(a.a0, a.b0);
        ALine bl = new ALine(b.a0, b.b0);
        return al.crossIntersects(bl);
    }
}

