/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental.layerOptimizer;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.experimental.layerOptimizer.AbstractConnection;
import com.sigrity.orbit.automation.experimental.layerOptimizer.ConnectionList;
import com.sigrity.orbit.automation.experimental.layerOptimizer.ConnectionsOnLayerList;
import java.util.ArrayList;
import java.util.HashSet;

public class LayerOptimizer<O, L> {
    AGeneticOptimizer mAgo;

    public AGeneticOptimizer go(int time, int maxPopulation, ConnectionList<O, L> starter) {
        this.mAgo = new AGeneticOptimizer(true, true);
        this.mAgo.setMaxPopulation(maxPopulation);
        this.mAgo.addChromosome(starter.deepCopy(), null);
        this.mAgo.evolveForTime(time);
        return this.mAgo;
    }

    public static boolean isConnectionSignificant(Connection c) {
        ARect r2;
        ARect r1 = c.getDPPA().getWorldBounds();
        return !r1.intersects(r2 = c.getDPPB().getWorldBounds());
    }

    public static void selectLayeredConnections() {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (Connection c : db.getObjects(Connection.class)) {
            if (c.getValue("layer") == null) continue;
            s.add((DbObject)c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void testMe(String devicePathString, int sec, int maxPopulation) {
        int numSingles = 0;
        int numDiffPairs = 0;
        int numAbsent = 0;
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)"'%s' is not a valid device path", (Object[])new Object[]{devicePathString});
            return;
        }
        LayerOptimizer lo = new LayerOptimizer();
        HashSet<Layer> validLayers = new HashSet<Layer>();
        for (Layer l : db.getObjects(Layer.class)) {
            if (!l.getType().equals((Object)Layer.LayerType.Signal)) continue;
            validLayers.add(l);
        }
        ArrayList randomLayers = new ArrayList();
        randomLayers = AUtil.arrayList(validLayers);
        ConnectionList<Object, Layer> starter = new ConnectionList<Object, Layer>();
        HashSet<void> seen = new HashSet<void>();
        for (Connection c : db.getObjects(Connection.class)) {
            Layer randomLayer;
            ALine line;
            if (seen.contains(c) || !LayerOptimizer.isConnectionSignificant(c)) continue;
            Net net = NetMap.getTopmostNet((Net)c.getNet(), (DevicePath)c.getPathA());
            String name = net.getName();
            ALog.logInfo((String)name);
            if (net.getDeviceTemplate() != devicePath.getDevice().getTemplate()) {
                ALog.logInfo((String)name);
            }
            Net mate = Net.getDiffPairMate((Net)net, (DevicePath)devicePath);
            Object var18_20 = null;
            if (mate != null) {
                void var18_19;
                for (HierInst hp : NetMap.getConnectedHierPins((DevicePath)devicePath, (Net)mate)) {
                    PinInstance pi = PinInstance.getPinInstance((HierInst)hp);
                    for (Connection testConnection : pi.getConnections()) {
                        if (!LayerOptimizer.isConnectionSignificant(testConnection)) continue;
                        Connection connection = testConnection;
                        break;
                    }
                    if (var18_19 == null) continue;
                    break;
                }
                if (var18_19 != null) {
                    line = c.getLine();
                    randomLayer = (Layer)randomLayers.get((int)(Math.random() * (double)randomLayers.size()));
                    starter.addConnection(line.getP0(), line.getP1(), randomLayer, validLayers, c, var18_19);
                    ++numDiffPairs;
                    seen.add(var18_19);
                    continue;
                }
                ++numAbsent;
                continue;
            }
            line = c.getLine();
            randomLayer = (Layer)randomLayers.get((int)(Math.random() * (double)randomLayers.size()));
            starter.addConnection(line.getP0(), line.getP1(), randomLayer, validLayers, c, null);
            ++numSingles;
        }
        ALog.logInfo((String)("singles: " + numSingles + " diff pairs: " + numDiffPairs + " absent: " + numAbsent));
        starter.fitness = starter.fitness();
        AGeneticOptimizer go = lo.go(sec, maxPopulation, starter);
        ConnectionList best = (ConnectionList)go.getBestIndividual();
        numSingles = 0;
        numDiffPairs = 0;
        numAbsent = 0;
        for (int i = 0; i < best.size(); ++i) {
            Layer l = (Layer)((ConnectionsOnLayerList)best.get((int)i)).layer;
            for (AbstractConnection abstractConnection : ((ConnectionsOnLayerList)best.get((int)i)).connections) {
                Connection c = (Connection)abstractConnection.reference;
                c.setValue("layer", (Object)l);
                Connection c1 = (Connection)abstractConnection.altReference;
                if (c1 != null) {
                    ++numDiffPairs;
                    c1.setValue("layer", (Object)l);
                    continue;
                }
                ++numSingles;
            }
        }
        ALog.logInfo((String)("singles: " + numSingles + " diff pairs: " + numDiffPairs + " absent: " + numAbsent));
    }
}

