/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.iocellplacement.IllegalDirectionException;
import java.util.Comparator;
import java.util.LinkedList;

class DriverBallPair {
    HierInst<Device> mDriver = null;
    HierPin mBall = null;
    double mConnAngle = 0.0;

    public static DriverOrderComparator getDriverOrderComparator(AGeomUtil.CompassDir side) {
        return new DriverOrderComparator(side);
    }

    public static boolean isBumpPad(PinTemplate pin) {
        return pin.getType() == PinTemplate.Type.BUMPPAD;
    }

    public static boolean isBallPad(PinTemplate pin) {
        return pin.getType() == PinTemplate.Type.BALLPAD;
    }

    public static boolean isBumpBall(PinTemplate pin) {
        return DriverBallPair.isBumpPad(pin) || DriverBallPair.isBallPad(pin);
    }

    public static boolean isDriverBallPair(HierPin first, HierPin second) {
        return first.getPin().getDevice().isDriver() && DriverBallPair.isBumpBall(second.getPin().getPinTemplate());
    }

    public static boolean isDriverDriverPair(HierPin first, HierPin second) {
        return first.getPin().getDevice().isDriver() && second.getPin().getDevice().isDriver();
    }

    public static boolean isOuterCol(APoint2D pos, APoint2D prevPos, AGeomUtil.CompassDir side) {
        boolean isOuterPos = false;
        if (side == AGeomUtil.CompassDir.W) {
            isOuterPos = pos.getY() < prevPos.getY();
        } else if (side == AGeomUtil.CompassDir.S) {
            isOuterPos = pos.getX() > prevPos.getX();
        } else if (side == AGeomUtil.CompassDir.E) {
            isOuterPos = pos.getY() > prevPos.getY();
        } else if (side == AGeomUtil.CompassDir.N) {
            isOuterPos = pos.getX() < prevPos.getX();
        } else {
            throw new IllegalDirectionException();
        }
        return isOuterPos;
    }

    public static boolean isOuterRow(APoint2D pos, APoint2D prevPos, AGeomUtil.CompassDir side) {
        boolean isOuterPos = false;
        if (side == AGeomUtil.CompassDir.W) {
            isOuterPos = pos.getX() > prevPos.getX();
        } else if (side == AGeomUtil.CompassDir.S) {
            isOuterPos = pos.getY() < prevPos.getY();
        } else if (side == AGeomUtil.CompassDir.E) {
            isOuterPos = pos.getX() < prevPos.getX();
        } else if (side == AGeomUtil.CompassDir.N) {
            isOuterPos = pos.getY() > prevPos.getY();
        } else {
            throw new IllegalDirectionException();
        }
        return isOuterPos;
    }

    public static Long getBallRowVal(HierPin ball, AGeomUtil.CompassDir side) {
        Long rowVal;
        if (side == AGeomUtil.CompassDir.W) {
            rowVal = ball.getWorldLoc().getX();
        } else if (side == AGeomUtil.CompassDir.S) {
            rowVal = ball.getWorldLoc().getY();
        } else if (side == AGeomUtil.CompassDir.E) {
            rowVal = -1L * ball.getWorldLoc().getX();
        } else if (side == AGeomUtil.CompassDir.N) {
            rowVal = -1L * ball.getWorldLoc().getY();
        } else {
            throw new IllegalDirectionException();
        }
        return rowVal;
    }

    public static boolean isCloserBall(HierPin thisBall, HierPin thatBall, AGeomUtil.CompassDir side, long epsilon) {
        return 0 > DriverBallPair.compareToBall(thisBall, thatBall, side, epsilon);
    }

    public static boolean isNeighborBall(HierPin thisBall, HierPin thatBall, AGeomUtil.CompassDir side, long epsilon) {
        return 0 == DriverBallPair.compareToBall(thisBall, thatBall, side, epsilon);
    }

    public static boolean isFurtherBall(HierPin thisBall, HierPin thatBall, AGeomUtil.CompassDir side, long epsilon) {
        return 0 < DriverBallPair.compareToBall(thisBall, thatBall, side, epsilon);
    }

    public static int compareToBall(HierPin thisBall, HierPin thatBall, AGeomUtil.CompassDir side, long epsilon) {
        epsilon = Math.abs(epsilon);
        Long thisRowVal = DriverBallPair.getBallRowVal(thisBall, side);
        Long thatRowVal = DriverBallPair.getBallRowVal(thatBall, side);
        Long diff = Math.abs(thisRowVal - thatRowVal);
        if (diff <= epsilon) {
            return 0;
        }
        if (thisRowVal > thatRowVal) {
            return 1;
        }
        return -1;
    }

    public static HierPin getSameNetBall(Device driver, DevicePath diePath) {
        LinkedList<HierPin> balls = new LinkedList<HierPin>();
        if (!driver.isDriver()) {
            throw new IllegalArgumentException();
        }
        Net net = driver.getNet();
        Net topMostNet = NetMap.getTopmostNet((Net)net, (DevicePath)diePath);
        if (topMostNet == null) {
            throw new IllegalArgumentException();
        }
        for (HierInst hPinT : NetMap.getConnectedHierPins((DevicePath)diePath.getParent(), (Net)topMostNet)) {
            if (!DriverBallPair.isBumpBall((PinTemplate)hPinT.getDbObject())) continue;
            HierPin hPin = HierPin.forHPinT((HierInst)hPinT);
            balls.add(hPin);
        }
        if (balls.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return (HierPin)balls.get(0);
    }

    public static DriverBallPair create(HierPin hPinA, HierPin hPinB, APoint2D dieCenter) {
        DriverBallPair pair = null;
        if (DriverBallPair.isDriverBallPair(hPinA, hPinB)) {
            pair = new DriverBallPair(hPinA, hPinB);
            pair.setConnAngle(dieCenter);
        } else if (DriverBallPair.isDriverBallPair(hPinB, hPinA)) {
            pair = new DriverBallPair(hPinB, hPinA);
            pair.setConnAngle(dieCenter);
        }
        return pair;
    }

    public DriverBallPair(HierPin driver, HierPin ball) {
        this((HierInst<Device>)new HierInst(driver.getPath(), (DbObject)driver.getPin().getDevice()), ball);
    }

    public DriverBallPair(HierInst<Device> driver, HierPin ball) {
        this.mDriver = driver;
        this.mBall = ball;
    }

    public void setConnAngle(APoint2D dieCenter) {
        double degree = dieCenter.getAngle(this.mBall.getWorldBounds().center());
        this.mConnAngle = AGeomUtil.normDeg((double)(degree - 315.0));
    }

    public HierInst<Device> getDriver() {
        return this.mDriver;
    }

    public HierPin getBall() {
        return this.mBall;
    }

    public double getConnAngle() {
        return this.mConnAngle;
    }

    public APoint2D getBallLoc() {
        return this.mBall.getWorldLoc();
    }

    public APoint2D getDriverLoc() {
        return ((Device)this.mDriver.getDbObject()).getLoc(this.mDriver.getPath(), "IOpad center");
    }

    public static class DriverOrderComparator
    implements Comparator<DriverBallPair> {
        boolean mUseX;
        boolean mIsAscend;

        public DriverOrderComparator(AGeomUtil.CompassDir side) {
            this.mUseX = side.equals((Object)AGeomUtil.CompassDir.N) || side.equals((Object)AGeomUtil.CompassDir.S);
            this.mIsAscend = side.equals((Object)AGeomUtil.CompassDir.S) || side.equals((Object)AGeomUtil.CompassDir.E);
        }

        public long getPrimaryLoc(HierInst<Device> d) {
            return this.mUseX ? ((Device)d.getDbObject()).getLoc().getX() : ((Device)d.getDbObject()).getLoc().getY();
        }

        public long getSecondaryLoc(HierInst<Device> d) {
            return this.mUseX ? ((Device)d.getDbObject()).getLoc().getY() : ((Device)d.getDbObject()).getLoc().getX();
        }

        public long getPrimaryLength(HierInst<Device> d) {
            return this.mUseX ? ((Device)d.getDbObject()).getBounds().width() : ((Device)d.getDbObject()).getBounds().height();
        }

        public long getSecondaryLength(HierInst<Device> d) {
            return this.mUseX ? ((Device)d.getDbObject()).getBounds().height() : ((Device)d.getDbObject()).getBounds().width();
        }

        public int comparePrimary(HierInst<Device> a, HierInst<Device> b) {
            long d = this.getPrimaryLoc(a) - this.getPrimaryLoc(b);
            int ret = d < 0L ? -1 : (d > 0L ? 1 : 0);
            return this.mIsAscend ? ret : -ret;
        }

        public int compareSecondary(HierInst<Device> a, HierInst<Device> b) {
            int ret = this.comparePrimary(a, b);
            return this.mUseX ? ret : -ret;
        }

        @Override
        public int compare(DriverBallPair a, DriverBallPair b) {
            int ret = this.comparePrimary(a.getDriver(), b.getDriver());
            return ret != 0 ? ret : this.compareSecondary(a.getDriver(), b.getDriver());
        }
    }
}

