/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.LineUnCrosser;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DriverOptimizer {
    protected Db mDb = null;
    protected Map<Device, DriverInfo> driversSortInGroup = new HashMap<Device, DriverInfo>();
    protected int isIgnoredPin = 0;
    protected int isFixedPin = 0;
    protected DevicePath substratePath = null;
    protected List<DevicePath> optimizedDrivers = new LinkedList<DevicePath>();

    public static DriverOptimizer create(Db db, Set<Connection> connections, DevicePath refPath) {
        DriverOptimizer driverRepositioner = new DriverOptimizer(db, refPath);
        HashSet existingDevices = new HashSet();
        Device refLast = refPath.getLast();
        connections.stream().sorted().forEach(connection -> {
            HierPin hPinA = connection.getDPPA();
            HierPin hPinB = connection.getDPPB();
            if (DriverOptimizer.isPinAPadOnDie(hPinA, refLast).booleanValue()) {
                Device deviceA = hPinA.getDbObject().getDevice();
                if (!existingDevices.contains(deviceA)) {
                    driverRepositioner.add(hPinB, hPinA);
                    existingDevices.add(deviceA);
                }
            } else if (DriverOptimizer.isPinAPadOnDie(hPinB, refLast).booleanValue()) {
                Device deviceB = hPinB.getDbObject().getDevice();
                if (!existingDevices.contains(deviceB)) {
                    driverRepositioner.add(hPinA, hPinB);
                    existingDevices.add(deviceB);
                }
            } else {
                ++driverRepositioner.isIgnoredPin;
            }
        });
        return driverRepositioner;
    }

    protected static boolean isFixed(HierPin hPin) {
        Device device = hPin.getPin().getDevice();
        DevicePath pathToDevice = hPin.getPath().find(device);
        Device parentToDevice = pathToDevice.getParent().getLast();
        boolean isFixed = device.getIsFixed();
        if (parentToDevice != null && parentToDevice.isPersonality()) {
            isFixed = isFixed || parentToDevice.getIsFixed();
        }
        return isFixed;
    }

    protected static Boolean isPinAPadOnDie(HierPin hPin, Device refDie) {
        return hPin.getDbObject().getDevice().isDriver() && hPin.getPath().pathToLowestOfType(DeviceTemplate.Type.DIE) != null && hPin.getPath().pathToLowestOfType(DeviceTemplate.Type.DIE).getLast() == refDie;
    }

    public DriverOptimizer(Db db, DevicePath refPath) {
        this.mDb = db;
        this.substratePath = refPath.pathToLowestDie();
    }

    public void add(HierPin fixed, HierPin free) {
        Device parent;
        if (DriverOptimizer.isFixed(free)) {
            ++this.isFixedPin;
            return;
        }
        if (this.substratePath == null) {
            this.substratePath = free.getPath().pathToLowestDie();
        }
        if (!this.driversSortInGroup.containsKey(parent = this.getGroupParentOrNull(free))) {
            this.driversSortInGroup.put(parent, new DriverInfo());
        }
        DriverInfo driverInfo = this.driversSortInGroup.get(parent);
        driverInfo.add(fixed, free);
    }

    public List<DevicePath> getOptimizedDrivers() {
        return this.optimizedDrivers;
    }

    public void action() {
        this.optimizedDrivers.clear();
        this.driversSortInGroup.values().stream().forEach(this::repositionDriver);
    }

    public void report() {
        if (this.isFixedPin > 0) {
            ALog.logInfo((String)(this.isFixedPin + " pins are fixed and though cannot be moved."));
        }
        if (this.isIgnoredPin > 0) {
            ALog.logInfo((String)(this.isIgnoredPin + " connections are ignored."));
        }
    }

    protected void addConnection(DriverInfo driverInfos) {
        List<HierPin> freePins = driverInfos.getFreePins();
        List<HierPin> fixedPins = driverInfos.getFixedPins();
        for (int i = 0; i < freePins.size(); ++i) {
            Connection connection = new Connection(fixedPins.get(i), freePins.get(i), false);
            this.mDb.add((DbObject)connection);
            Selection.getCurrentSelectionForDb((Db)this.mDb).add((DbObject)connection);
        }
    }

    protected void repositionDriver(DriverInfo driverInfos) {
        ArrayList<HierPin> pinsInNewOrder = this.optimizeConnection(driverInfos);
        List<HierPin> pins = driverInfos.getFreePins();
        List<ARect> driverCorners = driverInfos.getSelectedCorners();
        List<Float> driverRotates = driverInfos.getSelectedRotate();
        List<Boolean> driverMirrors = driverInfos.getSelectedMirror();
        List<AGeomUtil.CompassDir> driverSides = driverInfos.getSelectedSides();
        for (int i = 0; i < pins.size(); ++i) {
            HierPin pinDest;
            HierPin pinSrc = pins.get(i);
            if (pinSrc != (pinDest = (HierPin)pinsInNewOrder.get(i))) {
                int indexSrc = pins.indexOf(pinSrc);
                int indexDest = pins.indexOf(pinDest);
                AGeomUtil.CompassDir newSide = driverSides.get(indexDest);
                Float newRotate = driverRotates.get(indexDest);
                Boolean newMirror = driverMirrors.get(indexDest);
                APoint2D newLoc = this.getCenterLoc(driverCorners.get(indexSrc), driverCorners.get(indexDest), newSide);
                this.moveDriverToDest(pinSrc, newLoc, newRotate, newMirror);
            }
            this.optimizedDrivers.add(pinSrc.getPath());
        }
    }

    protected APoint2D getCenterLoc(ARect cornerSrc, ARect cornerDest, AGeomUtil.CompassDir side) {
        long width = cornerSrc.width() / 2L;
        long height = cornerSrc.height() / 2L;
        if (side == AGeomUtil.CompassDir.N) {
            return cornerDest.getUR().add(-width, -height);
        }
        if (side == AGeomUtil.CompassDir.W) {
            return cornerDest.getUL().add(width, -height);
        }
        if (side == AGeomUtil.CompassDir.S) {
            return cornerDest.getLL().add(width, height);
        }
        if (side == AGeomUtil.CompassDir.E) {
            return cornerDest.getLR().add(-width, height);
        }
        throw new IllegalArgumentException("Invalid side.");
    }

    protected ArrayList<HierPin> optimizeConnection(DriverInfo drivers) {
        LineUnCrosser lu = new LineUnCrosser();
        return lu.uncross(drivers.getFixedPinsPoints(), drivers.getFreePins(), p -> p, q -> q.getWorldBounds().center());
    }

    protected void moveDriverToDest(HierPin pinSrc, APoint2D newLoc, Float newRotate, Boolean newMirror) {
        Device driver = pinSrc.getPath().getDevice();
        DevicePath parentPath = pinSrc.getPath().getParent();
        driver.setRotate(ATransformUtil.normRot((float)(newRotate.floatValue() - parentPath.getRot())));
        driver.setMirror(newMirror ^ parentPath.getMirror());
        AffineTransform parentXInv = parentPath.getInverseTransform();
        newLoc = newLoc.transform(parentXInv);
        driver.moveCenterTo(newLoc.getX(), newLoc.getY());
    }

    protected Device getGroupParentOrNull(HierPin hPin) {
        Device parent = hPin.getPath().getParent().getLast();
        if (!parent.isPersonality()) {
            parent = null;
        }
        return parent;
    }

    protected class DriverInfo {
        List<HierPin> fixedPins = new LinkedList<HierPin>();
        List<HierPin> freePins = new LinkedList<HierPin>();
        List<HierInst<Device>> selectedDrivers = new LinkedList<HierInst<Device>>();

        protected DriverInfo() {
        }

        public void add(HierPin fixed, HierPin free) {
            this.fixedPins.add(fixed);
            this.freePins.add(free);
            this.selectedDrivers.add((HierInst<Device>)new HierInst(free.getPath().copy(), (DbObject)free.getDbObject().getDevice()));
        }

        public List<HierPin> getFixedPins() {
            return this.fixedPins;
        }

        public List<HierPin> getFreePins() {
            return this.freePins;
        }

        public List<APoint2D> getFixedPinsPoints() {
            return this.fixedPins.stream().map(HierPin::getWorldLoc).collect(Collectors.toList());
        }

        public List<APoint2D> getFreePinsPoints() {
            return this.freePins.stream().map(d -> d.getWorldBounds().center()).collect(Collectors.toList());
        }

        public List<Net> getNets() {
            return this.fixedPins.stream().map(HierPin::getTopMostNet).collect(Collectors.toList());
        }

        public List<HierInst<Device>> getSelectedDrivers() {
            return this.selectedDrivers;
        }

        public List<ARect> getSelectedCorners() {
            return this.selectedDrivers.stream().map(d -> d.getPath().getBB()).collect(Collectors.toList());
        }

        public List<Float> getSelectedRotate() {
            return this.selectedDrivers.stream().map(d -> Float.valueOf(d.getPath().getRot())).collect(Collectors.toList());
        }

        public List<Boolean> getSelectedMirror() {
            return this.selectedDrivers.stream().map(d -> d.getPath().getMirror()).collect(Collectors.toList());
        }

        public List<AGeomUtil.CompassDir> getSelectedSides() {
            return this.selectedDrivers.stream().map(d -> AGeomUtil.getEminatingDir((double)d.getPath().getRot())).collect(Collectors.toList());
        }
    }
}

