/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.iocellplacement.DriverRespacerSerializer;
import com.sigrity.orbit.automation.iocellplacement.FixedOrderTable;
import com.sigrity.orbit.automation.iocellplacement.PlaceableDriver;
import com.sigrity.orbit.automation.iocellplacement.RuleTable;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DriverRespacer {
    public static final String SINGLE_INSTANCE_TABLE = "Respacer.SingleInstanceTable";
    public static final String DEFAULT_SPACING = "Respace.DefaultSpacing";
    public static final String DOMAIN_SPACING = "Respace.DomainSpacing";
    public static final String HEIGHT_SPACING = "Respace.SizeSpacing";
    Device refDriver = null;
    DevicePath refDriverPath = null;
    boolean leaveIfMoreThanSpacing = false;
    long defaultSpacing = 0L;
    RuleTable ruleTable = new RuleTable();
    FixedOrderTable fixedOrderTable = new FixedOrderTable();
    SpacingDeck spacingDeck = new SpacingDeck();
    boolean readSavedConstraints = true;

    protected static long fixedCount(List<HierInst<Device>> devices) {
        return devices.stream().map(HierInst::getDbObject).filter(Device::getIsFixed).count();
    }

    public DriverRespacer() {
    }

    public DriverRespacer(DevicePath pathToRef) {
        this.setRefDriver(pathToRef);
    }

    public void setReadSavedConstraints(boolean readSavedConstraints) {
        this.readSavedConstraints = readSavedConstraints;
    }

    public void initContraints(List<HierInst<Device>> drivers) {
        DriverRespacerSerializer.SingleInstanceTable table;
        this.spacingDeck = this.getOrCreateSpacingDeck(this.refDriverPath);
        this.ruleTable.setSpacing(new RuleTable.RuleEntry(this.spacingDeck.defaultSpacing, 0L, 0L, 0L));
        if (this.readSavedConstraints && (table = this.getSingleInstanceTable(this.refDriverPath)) != null) {
            this.ruleTable.merge(table.getRuleTable(drivers, this.spacingDeck));
            this.fixedOrderTable = table.getFixedOrderTable();
        }
    }

    private DriverRespacerSerializer.SingleInstanceTable getSingleInstanceTable(DevicePath path) {
        Device substrateDevice = path.pathToSubstrate().getDevice();
        String filePath = (String)substrateDevice.getValue(SINGLE_INSTANCE_TABLE);
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        DriverRespacerSerializer.SingleInstanceTableParser parser2 = new DriverRespacerSerializer.SingleInstanceTableParser(filePath);
        return parser2.parse(path.getParent());
    }

    private SpacingDeck getOrCreateSpacingDeck(DevicePath path) {
        long def = this.getDefaultSpacing(path, this.defaultSpacing);
        long domain = this.getDomainSpacing(path, 0L);
        long height = this.getHeightSpacing(path, 0L);
        return new SpacingDeck(def, domain, height);
    }

    private long getDefaultSpacing(DevicePath path, long defVal) {
        Device device = path.pathToSubstrate().getDevice();
        String value = (String)device.getValue(DEFAULT_SPACING);
        if (value == null) {
            return defVal;
        }
        return Long.valueOf(value);
    }

    private long getDomainSpacing(DevicePath path, long defVal) {
        Device device = path.pathToSubstrate().getDevice();
        String value = (String)device.getValue(DOMAIN_SPACING);
        if (value == null) {
            return defVal;
        }
        return Long.valueOf(value);
    }

    private long getHeightSpacing(DevicePath path, long defVal) {
        Device device = path.pathToSubstrate().getDevice();
        String value = (String)device.getValue(HEIGHT_SPACING);
        if (value == null) {
            return defVal;
        }
        return Long.valueOf(value);
    }

    protected long getSpacing(PlaceableDriver fromPd, PlaceableDriver toPd) {
        Device fromDriver = (Device)fromPd.getDriver().getDbObject();
        Device toDriver = (Device)toPd.getDriver().getDbObject();
        return this.ruleTable.getSpacing((Device)fromDriver, (Device)toDriver).mS2S;
    }

    protected HierInst<Device> getRefHierInst() {
        return HierInst.create((DevicePath)this.refDriverPath, (DbObject)this.refDriver);
    }

    public void setRefDriver(DevicePath path) {
        this.refDriver = path.getDevice();
        this.refDriverPath = path;
    }

    public void setDefaultSpacing(long defaultSpacing) {
        this.defaultSpacing = defaultSpacing;
    }

    public void setLeaveIfMoreThanSpacing(boolean leaveIfMoreThanSpacing) {
        this.leaveIfMoreThanSpacing = leaveIfMoreThanSpacing;
    }

    public void process(List<HierInst<Device>> drivers, boolean xAsRef) {
        if (this.refDriver == null || this.refDriverPath == null) {
            throw new IllegalArgumentException("reference driver is not set.");
        }
        this.initContraints(drivers);
        long fixedCount = DriverRespacer.fixedCount(drivers);
        if (fixedCount > 0L) {
            ALog.logWarn((String)(fixedCount + " of the drivers are fixed. Cannot space fixed drivers."));
            return;
        }
        List<HierInst<Device>> unifiedDrivers = this.unifyFixedOrder(drivers);
        APair<List<HierInst<Device>>, List<HierInst<Device>>> sortedLists = this.getNeighborsOfRef(unifiedDrivers, xAsRef);
        this.addFixedOrder((List)sortedLists.first, true);
        this.addFixedOrder((List)sortedLists.second, false);
        this.spaceIODrivers((List)sortedLists.first, xAsRef, true);
        this.spaceIODrivers((List)sortedLists.second, xAsRef, false);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public void processAll(List<HierInst<Device>> drivers) {
        if (this.refDriver == null || this.refDriverPath == null) {
            throw new IllegalArgumentException("reference driver is not set.");
        }
        this.initContraints(drivers);
        this.addFixedOrder(drivers, true);
        Map<AGeomUtil.CompassDir, ARect> optimizedAreas = this.getDriverAreas(drivers);
        DevicePath refPath = drivers.get(0).getPath().getParent();
        for (Map.Entry<AGeomUtil.CompassDir, ARect> entry : optimizedAreas.entrySet()) {
            AGeomUtil.CompassDir side = entry.getKey();
            ARect area = entry.getValue();
            List<HierInst<Device>> children = refPath.getDeviceTemplate().getChildDevices((AGeom)area, false).stream().filter(Device::isDriver).map(d -> HierInst.create((DevicePath)refPath.withChild(d), (DbObject)d)).collect(Collectors.toList());
            boolean xAsRef = side == AGeomUtil.CompassDir.N || side == AGeomUtil.CompassDir.S;
            boolean increasing = side == AGeomUtil.CompassDir.S || side == AGeomUtil.CompassDir.E;
            Collections.sort(children, new Device.DriverSort(increasing, xAsRef, 0L));
            this.setRefDriver(((HierInst)children.get(0)).getPath());
            HierInst<Device> refHierInst = this.getRefHierInst();
            List refDriverOrder = (List)this.fixedOrderTable.get(refHierInst);
            if (refDriverOrder != null) {
                HierInst head = (HierInst)refDriverOrder.get(refDriverOrder.size() - 1);
                APoint2D newLoc = this.getCenterLoc((HierInst<Device>)head, refHierInst);
                DevicePath parentPath = head.getPath().getParent();
                AffineTransform parentXInv = parentPath.getInverseTransform();
                newLoc = newLoc.transform(parentXInv);
                ((Device)head.getDbObject()).moveCenterTo(newLoc.getX(), newLoc.getY());
                Collections.swap(children, children.indexOf(refHierInst), children.indexOf(head));
            }
            this.setRefDriver(((HierInst)children.get(0)).getPath());
            this.process(children, xAsRef);
        }
    }

    private Map<AGeomUtil.CompassDir, ARect> getDriverAreas(List<HierInst<Device>> drivers) {
        return drivers.stream().map(HierInst::getPath).collect(Collectors.toMap(dp -> AGeomUtil.getEminatingDir((double)dp.getRot()), dp -> dp.getDevice().getBB(), (o1, o2) -> {
            ARect r1 = o1;
            ARect r2 = o2;
            return r1.expandBy(r2);
        }));
    }

    private APoint2D getCenterLoc(HierInst<Device> driverSrc, HierInst<Device> driverDst) {
        ARect cornerSrc = driverSrc.getPath().getBB();
        ARect cornerDest = driverDst.getPath().getBB();
        AGeomUtil.CompassDir side = AGeomUtil.getEminatingDir((double)driverDst.getPath().getRot());
        long width = cornerSrc.width() / 2L;
        long height = cornerSrc.height() / 2L;
        if (side == AGeomUtil.CompassDir.N) {
            return cornerDest.getUR().add(-width, -height);
        }
        if (side == AGeomUtil.CompassDir.W) {
            return cornerDest.getUL().add(width, -height);
        }
        if (side == AGeomUtil.CompassDir.S) {
            return cornerDest.getLL().add(width, height);
        }
        if (side == AGeomUtil.CompassDir.E) {
            return cornerDest.getLR().add(-width, height);
        }
        throw new IllegalArgumentException("Invalid side.");
    }

    private List<HierInst<Device>> unifyFixedOrder(List<HierInst<Device>> drivers) {
        HierInst<Device> refHierInst = this.getRefHierInst();
        List refDriverOrder = (List)this.fixedOrderTable.get(refHierInst);
        HashMap<HierInst, HierInst<Device>> fixedOrderhead2Ref = new HashMap<HierInst, HierInst<Device>>();
        if (refDriverOrder != null) {
            fixedOrderhead2Ref.put((HierInst)refDriverOrder.get(0), refHierInst);
        }
        return drivers.stream().filter(d -> {
            Device device = (Device)d.getDbObject();
            DevicePath path = d.getPath();
            return device != this.refDriver && path.pathToSubstrate().equals((Object)this.refDriverPath.pathToSubstrate());
        }).filter(d -> {
            List order = (List)this.fixedOrderTable.get(d);
            if (order == null) {
                return true;
            }
            if (fixedOrderhead2Ref.containsKey(order.get(0))) {
                return false;
            }
            fixedOrderhead2Ref.put((HierInst)order.get(0), (HierInst<Device>)d);
            return true;
        }).collect(Collectors.toList());
    }

    private APair<List<HierInst<Device>>, List<HierInst<Device>>> getNeighborsOfRef(List<HierInst<Device>> drivers, boolean xAsRef) {
        long refStableCoord;
        LinkedList<HierInst<Device>> posSideList = new LinkedList<HierInst<Device>>();
        LinkedList<HierInst<Device>> negSideList = new LinkedList<HierInst<Device>>();
        APoint2D refLoc = this.refDriverPath.getBB().center();
        for (HierInst<Device> driver : drivers) {
            boolean isPosSide;
            boolean bl = xAsRef ? refLoc.getX() <= driver.getPath().getBB().centerX() : (isPosSide = refLoc.getY() <= driver.getPath().getBB().centerY());
            if (isPosSide) {
                posSideList.add(driver);
                continue;
            }
            negSideList.add(driver);
        }
        long l = refStableCoord = xAsRef ? refLoc.getY() : refLoc.getX();
        if (posSideList.size() > 1) {
            Collections.sort(posSideList, new Device.DriverSort(true, xAsRef, refStableCoord));
        }
        if (negSideList.size() > 1) {
            Collections.sort(negSideList, new Device.DriverSort(false, xAsRef, refStableCoord));
        }
        return new APair(posSideList, negSideList);
    }

    private void addFixedOrder(List<HierInst<Device>> drivers, boolean posSide) {
        int index = 0;
        while (index < drivers.size()) {
            HierInst<Device> driver = drivers.get(index);
            ArrayList inOrder = (ArrayList)this.fixedOrderTable.get(driver);
            if (inOrder != null) {
                drivers.remove(index);
                if (!posSide) {
                    inOrder = new ArrayList(inOrder);
                    Collections.reverse(inOrder);
                }
                drivers.addAll(index, inOrder);
                index += inOrder.size();
                continue;
            }
            ++index;
        }
        HierInst<Device> refHierInst = this.getRefHierInst();
        List refDriverOrder = (List)this.fixedOrderTable.get(refHierInst);
        if (refDriverOrder != null) {
            List inOrder;
            int refIndex = refDriverOrder.indexOf(refHierInst);
            if (posSide) {
                inOrder = refDriverOrder.subList(refIndex + 1, refDriverOrder.size());
            } else {
                inOrder = refDriverOrder.subList(0, refIndex);
                inOrder = new ArrayList(inOrder);
                Collections.reverse(inOrder);
            }
            drivers.addAll(0, inOrder);
        }
    }

    private void spaceIODrivers(List<HierInst<Device>> sortedList, boolean xAsRef, boolean posDir) {
        if (sortedList.isEmpty()) {
            return;
        }
        LinkedList<PlaceableDriver> driversToPlace = new LinkedList<PlaceableDriver>();
        HierInst<Device> hRef = this.getRefHierInst();
        driversToPlace.add(PlaceableDriver.create(hRef));
        PositionHelper helper = new PositionHelper(xAsRef, posDir);
        for (HierInst<Device> hDev : sortedList) {
            if (!((Device)hDev.getDbObject()).isDriver()) continue;
            PlaceableDriver fromPd = (PlaceableDriver)driversToPlace.getLast();
            PlaceableDriver toPd = PlaceableDriver.create(hDev);
            long dist = helper.getEdgeDist(fromPd, toPd);
            long spacing = this.getSpacing(fromPd, toPd);
            if (!this.leaveIfMoreThanSpacing || dist < spacing) {
                toPd.setPosToPlace(helper.getNextValidPos(fromPd, toPd, spacing));
            }
            toPd.place();
            driversToPlace.add(toPd);
        }
    }

    private class PositionHelper {
        boolean xAsRef;
        boolean posDir;

        public PositionHelper(boolean xAsRef, boolean posDir) {
            this.xAsRef = xAsRef;
            this.posDir = posDir;
        }

        private APoint2D getCenter(PlaceableDriver pd) {
            return pd.getPosToPlace();
        }

        private long getLengthSum(PlaceableDriver fromPd, PlaceableDriver toPd) {
            return this.xAsRef ? fromPd.getWorldBound().width() + toPd.getWorldBound().width() : fromPd.getWorldBound().height() + toPd.getWorldBound().height();
        }

        private long getRefPos(PlaceableDriver pd) {
            APoint2D center = this.getCenter(pd);
            return this.xAsRef ? center.getX() : center.getY();
        }

        private long getEdgeDist(PlaceableDriver fromPd, PlaceableDriver toPd) {
            long fromPos = this.getRefPos(fromPd);
            long toPos = this.getRefPos(toPd);
            long halfLengthSum = this.getLengthSum(fromPd, toPd) / 2L;
            return this.posDir ? toPos - fromPos - halfLengthSum : fromPos - toPos - halfLengthSum;
        }

        private APoint2D getNextValidPos(PlaceableDriver fromPd, PlaceableDriver toPd, long spacing) {
            long offset = spacing + this.getLengthSum(fromPd, toPd) / 2L;
            long newPos = this.posDir ? this.getRefPos(fromPd) + offset : this.getRefPos(fromPd) - offset;
            return new APoint2D(this.xAsRef ? newPos : this.getCenter(toPd).getX(), this.xAsRef ? this.getCenter(toPd).getY() : newPos);
        }
    }

    protected class SpacingDeck {
        long defaultSpacing = 0L;
        long domainSpacing = 0L;
        long heightSpacing = 0L;

        public SpacingDeck() {
        }

        public SpacingDeck(long defaultSpacing, long domainSpacing, long heightSpacing) {
            this.defaultSpacing = defaultSpacing;
            this.domainSpacing = domainSpacing;
            this.heightSpacing = heightSpacing;
        }
    }
}

