/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.iocellplacement.DriverRespacer;
import com.sigrity.orbit.automation.iocellplacement.FixedOrderTable;
import com.sigrity.orbit.automation.iocellplacement.RuleTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.math.NumberUtils;

public class DriverRespacerSerializer {
    private DriverRespacerSerializer() {
    }

    static class SingleInstanceTableParser {
        CSVDocument doc = null;
        String[] headers = new String[]{"Instance", "Spacing", "IODomain", "FixedOrder"};
        Unit unit = null;

        public SingleInstanceTableParser(String filePath) {
            this.doc = this.parseCSVDocument(filePath, this.headers);
            if (this.doc == null) {
                throw new IllegalArgumentException();
            }
            this.unit = OrbitIO.getCurView().getUnit();
        }

        public SingleInstanceTable parse(DevicePath parent) {
            SingleInstanceTable table = new SingleInstanceTable();
            for (int i = 0; i < this.doc.getItemCount(); ++i) {
                try {
                    Device driver = this.getDriver(i, this.headers[0], parent.getDeviceTemplate());
                    long spacing = this.getUnsignedLongValue(i, this.headers[1], this.unit);
                    String domainName = this.getString(i, this.headers[2]);
                    String orderName = this.getString(i, this.headers[3]);
                    table.insert((HierInst<Device>)HierInst.create((DevicePath)parent.withChild(driver), (DbObject)driver), spacing, domainName, orderName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ALog.logWarn((String)"Skip line %d", (Object[])new Object[]{i + 1});
                }
            }
            return table;
        }

        protected CSVDocument parseCSVDocument(String filePath, String[] header) {
            if (filePath == null) {
                return null;
            }
            File file = new File(filePath);
            CSVDocument csv = null;
            try (BOMInputStream fis = new BOMInputStream((InputStream)new FileInputStream(file));){
                CSVDOMParser parser2 = new CSVDOMParser(true, header);
                csv = parser2.parse((InputStream)fis);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Unable to read '%s'.", (Object[])new Object[]{filePath});
                return null;
            }
            catch (CSVDOMParser.CSVDOMException e) {
                ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
                return null;
            }
            return csv;
        }

        protected Device getDriver(int i, String header, DeviceTemplate parent) {
            if (this.doc == null) {
                throw new IllegalArgumentException();
            }
            String name = this.doc.getItemValue(i, header);
            Device driver = Device.getChildDevice((DeviceTemplate)parent, (String)name);
            if (driver == null) {
                ALog.logWarn((String)"Driver %s is not found.", (Object[])new Object[]{name});
                throw new IllegalArgumentException();
            }
            return driver;
        }

        protected Long getUnsignedLongValue(int i, String header, Unit unit) {
            if (this.doc == null) {
                throw new IllegalArgumentException();
            }
            String str = this.doc.getItemValue(i, header);
            Long value = unit.fromUserString(str);
            if (value == null) {
                ALog.logWarn((String)"Header %s has incorrect value of %s.", (Object[])new Object[]{header, str});
                throw new IllegalArgumentException();
            }
            if (value < 0L) {
                ALog.logWarn((String)"Value(%d) of %s should be larger than zero.", (Object[])new Object[]{header, str});
                throw new IllegalArgumentException();
            }
            return value;
        }

        protected String getString(int i, String header) {
            if (this.doc == null) {
                throw new IllegalArgumentException();
            }
            return this.doc.getItemValue(i, header);
        }
    }

    static class SingleInstanceTable {
        Map<HierInst<Device>, Long> instanceSpacings = new HashMap<HierInst<Device>, Long>();
        Map<HierInst<Device>, String> domains = new HashMap<HierInst<Device>, String>();
        Map<String, List<HierInst<Device>>> fixedOrders = new HashMap<String, List<HierInst<Device>>>();

        SingleInstanceTable() {
        }

        public void insert(HierInst<Device> driver, long spacing, String domainName, String orderName) {
            if (spacing > 0L) {
                this.instanceSpacings.put(driver, spacing);
            }
            if (!domainName.isEmpty()) {
                this.domains.put(driver, domainName);
            }
            if (!orderName.isEmpty()) {
                this.fixedOrders.computeIfAbsent(orderName, k -> new LinkedList()).add(driver);
            }
        }

        public RuleTable getRuleTable(List<HierInst<Device>> drivers, DriverRespacer.SpacingDeck spacingDeck) {
            RuleTable table = new RuleTable();
            for (HierInst<Device> fromDriver : drivers) {
                for (HierInst<Device> toDriver : drivers) {
                    long spacing = this.getSpacing(fromDriver, toDriver, spacingDeck);
                    if (spacing <= 0L) continue;
                    table.setSpacing((Device)fromDriver.getDbObject(), (Device)toDriver.getDbObject(), new RuleTable.RuleEntry(spacing, 0L, 0L, 0L));
                }
                table.setSpacing((Device)fromDriver.getDbObject(), new RuleTable.RuleEntry(this.getInstanceSpacing(fromDriver), 0L, 0L, 0L));
            }
            return table;
        }

        public FixedOrderTable getFixedOrderTable() {
            FixedOrderTable table = new FixedOrderTable();
            for (Map.Entry<String, List<HierInst<Device>>> order : this.fixedOrders.entrySet()) {
                table.register(order.getValue(), FixedOrderTable.REGISTER_MODE.ALL_AS_KEY);
            }
            return table;
        }

        private long getSpacing(HierInst<Device> fromDriver, HierInst<Device> toDriver, DriverRespacer.SpacingDeck spacingDeck) {
            long fromSpacing = this.getInstanceSpacing(fromDriver);
            long toSpacing = this.getInstanceSpacing(toDriver);
            long domainSpacing = this.getDomainSpacing(fromDriver, toDriver, spacingDeck.domainSpacing);
            long heightSpacing = this.getHeightSpacing(fromDriver, toDriver, spacingDeck.heightSpacing);
            return NumberUtils.max((long[])new long[]{fromSpacing, toSpacing, domainSpacing, heightSpacing});
        }

        private long getInstanceSpacing(HierInst<Device> driver) {
            Long fromSpacing = this.instanceSpacings.get(driver);
            return fromSpacing != null ? fromSpacing : 0L;
        }

        private long getDomainSpacing(HierInst<Device> fromDriver, HierInst<Device> toDriver, long spacing) {
            String toDomain;
            String fromDomain = this.domains.get(fromDriver);
            if (!fromDomain.equals(toDomain = this.domains.get(toDriver))) {
                return spacing;
            }
            return 0L;
        }

        private long getHeightSpacing(HierInst<Device> fromDriver, HierInst<Device> toDriver, long spacing) {
            long toHeight;
            long fromHeight = ((Device)fromDriver.getDbObject()).getBounds().height();
            if (fromHeight != (toHeight = ((Device)toDriver.getDbObject()).getBounds().height())) {
                return spacing;
            }
            return 0L;
        }
    }
}

