/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.iocellplacement.IOCellPlacer;
import com.sigrity.orbit.automation.iocellplacement.IOCellSerializer;
import com.sigrity.orbit.automation.iocellplacement.IllegalDirectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IOCellEntry
implements HConnEngine.ShowConnectionFunction {
    static final String POWERDOMAIN = "PowerDomain";
    boolean mUpdateOnly = false;
    DevicePath mDiePath = null;
    Set<Personality> mCoreDomains = null;
    Set<Personality> mIODomains = null;
    Map<CellType, List<HierInst<Device>>> mDevices = new EnumMap<CellType, List<HierInst<Device>>>(CellType.class);
    Map<HierInst<Device>, List<HierInst<Device>>> mFixedOrderDevices = new HashMap<HierInst<Device>, List<HierInst<Device>>>();

    public static IOCellEntry importCsv(String diePathString, String csvPath, boolean updateOnly) {
        IOCellSerializer iovs = new IOCellSerializer();
        HashSet<Personality> coreDomains = new HashSet<Personality>();
        HashSet<Personality> ioDomains = new HashSet<Personality>();
        Optional<APair<Map<String, List<Device>>, Map<Device, String>>> r = iovs.importCSV(diePathString, csvPath, Collections.emptyList(), updateOnly ? IOCellSerializer.OVERWRITE.EXISTING_INSTANCES_REUSE_TRANSFORM : IOCellSerializer.OVERWRITE.EXISTING_INSTANCES, true, coreDomains, ioDomains);
        if (!r.isPresent()) {
            throw new IllegalArgumentException("Failed to import io cell csv");
        }
        Map devicesBySide = (Map)r.get().first;
        Map fixedOrderDevices = (Map)r.get().second;
        IOCellEntry csvEntry = new IOCellEntry();
        csvEntry.mUpdateOnly = updateOnly;
        csvEntry.mDiePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)diePathString);
        csvEntry.mCoreDomains = coreDomains;
        csvEntry.mIODomains = ioDomains;
        csvEntry.addDevices(devicesBySide);
        csvEntry.addFixedOrderDevice(devicesBySide, fixedOrderDevices);
        return csvEntry;
    }

    public static void exportCsv(String diePathString, String csvPath) {
        IOCellSerializer iovs = new IOCellSerializer();
        IOCellEntry entry = IOCellEntry.getExistingIOCell(diePathString);
        iovs.exportCsv(entry, csvPath);
    }

    public static IOCellEntry getExistingIOCell(String diePathString) {
        IOCellEntry entry = new IOCellEntry();
        entry.mUpdateOnly = true;
        entry.mDiePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)diePathString);
        entry.mCoreDomains = new HashSet<Personality>();
        entry.mIODomains = new HashSet<Personality>();
        entry.mDevices = new EnumMap<CellType, List<HierInst<Device>>>(CellType.class);
        Device startDevice = entry.mDiePath.getDevice();
        for (Device child : startDevice.getChildren()) {
            Personality core;
            if (!IOCellEntry.isDriver(child) && !IOCellEntry.isCorner(child)) continue;
            DevicePath childPath = entry.mDiePath.withChild(child);
            CellType childType = IOCellEntry.getType(childPath);
            HierInst<Device> hInst = entry.createHierInst(child);
            Personality io = IOCellEntry.getIODomainDb(hInst);
            if (io != null) {
                entry.mIODomains.add(io);
            }
            if ((core = IOCellEntry.getCoreDomainDb(hInst)) != null) {
                entry.mCoreDomains.add(core);
            }
            List<Object> list = null;
            if (entry.mDevices.containsKey((Object)childType)) {
                list = entry.mDevices.get((Object)childType);
            } else {
                list = new LinkedList();
                entry.mDevices.put(childType, list);
            }
            list.add(hInst);
        }
        return entry;
    }

    public static boolean isCorner(Device d) {
        return d.getType() == DeviceTemplate.Type.ENDCAP;
    }

    public static boolean isDriver(Device d) {
        return d.isDriver();
    }

    public static boolean isIODomain(HierInst<Device> hierD) {
        return PersonalityMap.getPersonalities(IOCellEntry.getCompactHierInst(hierD)).map(PersonalityMap::getPersonality).anyMatch(p -> p.getValue(POWERDOMAIN).toString().equalsIgnoreCase("io"));
    }

    public static boolean isCoreDomain(HierInst<Device> hierD) {
        return PersonalityMap.getPersonalities(IOCellEntry.getCompactHierInst(hierD)).map(PersonalityMap::getPersonality).anyMatch(p -> p.getValue(POWERDOMAIN).toString().equalsIgnoreCase("core"));
    }

    public static Personality getIODomainDb(HierInst<Device> hierD) {
        return PersonalityMap.getPersonalities(IOCellEntry.getCompactHierInst(hierD)).map(PersonalityMap::getPersonality).filter(p -> p.getValue(POWERDOMAIN).toString().equalsIgnoreCase("io")).findFirst().orElse(null);
    }

    public static Personality getCoreDomainDb(HierInst<Device> hierD) {
        return PersonalityMap.getPersonalities(IOCellEntry.getCompactHierInst(hierD)).map(PersonalityMap::getPersonality).filter(p -> p.getValue(POWERDOMAIN).toString().equalsIgnoreCase("core")).findFirst().orElse(null);
    }

    public static HierInst<Device> regainDeviceFromDb(String dPathStr) {
        DevicePath dPath = DevicePath.fromEscapedString((Db)OrbitIO.getCurDb(), (String)dPathStr);
        if (dPath == null) {
            throw new IllegalArgumentException();
        }
        return HierInst.create((DevicePath)dPath, (DbObject)dPath.getLast());
    }

    public static CellType getTypeBySide(AGeomUtil.CompassDir side, boolean isCorner) {
        CellType type;
        if (side == AGeomUtil.CompassDir.W) {
            type = isCorner ? CellType.UL : CellType.LEFT;
        } else if (side == AGeomUtil.CompassDir.S) {
            type = isCorner ? CellType.LL : CellType.BOTTOM;
        } else if (side == AGeomUtil.CompassDir.E) {
            type = isCorner ? CellType.LR : CellType.RIGHT;
        } else if (side == AGeomUtil.CompassDir.N) {
            type = isCorner ? CellType.UR : CellType.TOP;
        } else {
            throw new IllegalDirectionException();
        }
        return type;
    }

    public static CellType getType(DevicePath d) {
        HierInst hInst = HierInst.create((DevicePath)d.getParent(), (DbObject)d.getLast());
        if (IOCellEntry.isIODomain((HierInst<Device>)hInst) || IOCellEntry.isCoreDomain((HierInst<Device>)hInst)) {
            return CellType.ANY;
        }
        return IOCellEntry.getTypeBySide(AGeomUtil.getEminatingDir((double)d.getRot()), IOCellEntry.isCorner((Device)hInst.getDbObject()));
    }

    private static HierInst<Device> getCompactHierInst(HierInst<Device> hInst) {
        if (hInst.getPath().getDevice() != hInst.getDbObject()) {
            return hInst;
        }
        return HierInst.create((DevicePath)hInst.getPath().getParent(), (DbObject)((Device)hInst.getDbObject()));
    }

    public boolean isUpdateOnly() {
        return this.mUpdateOnly;
    }

    public boolean isEmpty() {
        return this.mDevices.isEmpty() || this.mDevices.entrySet().isEmpty();
    }

    public Personality getIODomain(HierInst<Device> hierD) {
        return PersonalityMap.getPersonalities(IOCellEntry.getCompactHierInst(hierD)).map(PersonalityMap::getPersonality).filter(this.mIODomains::contains).findFirst().orElse(null);
    }

    public Personality getCoreDomain(HierInst<Device> hierD) {
        return PersonalityMap.getPersonalities(IOCellEntry.getCompactHierInst(hierD)).map(PersonalityMap::getPersonality).filter(this.mCoreDomains::contains).findFirst().orElse(null);
    }

    public List<HierInst<Device>> getDeviceByType(CellType type) {
        List<HierInst<Device>> devices = this.mDevices.get((Object)type);
        return devices == null ? Collections.emptyList() : devices;
    }

    public List<HierInst<Device>> getIOBySide(AGeomUtil.CompassDir side) {
        List<HierInst<Device>> io = null;
        if (side == AGeomUtil.CompassDir.W) {
            io = this.getDeviceByType(CellType.LEFT);
        } else if (side == AGeomUtil.CompassDir.S) {
            io = this.getDeviceByType(CellType.BOTTOM);
        } else if (side == AGeomUtil.CompassDir.E) {
            io = this.getDeviceByType(CellType.RIGHT);
        } else if (side == AGeomUtil.CompassDir.N) {
            io = this.getDeviceByType(CellType.TOP);
        } else {
            throw new IllegalDirectionException();
        }
        return io;
    }

    public HierInst<Device> getCornerBySide(AGeomUtil.CompassDir side) {
        HierInst<Device> corner = null;
        if (side == AGeomUtil.CompassDir.W) {
            corner = this.getDeviceByType(CellType.UL).get(0);
        } else if (side == AGeomUtil.CompassDir.S) {
            corner = this.getDeviceByType(CellType.LL).get(0);
        } else if (side == AGeomUtil.CompassDir.E) {
            corner = this.getDeviceByType(CellType.LR).get(0);
        } else if (side == AGeomUtil.CompassDir.N) {
            corner = this.getDeviceByType(CellType.UR).get(0);
        } else {
            throw new IllegalDirectionException();
        }
        return corner;
    }

    public List<HierInst<Device>> getSelectedIODevices() {
        ArrayList<HierInst<Device>> selected = new ArrayList<HierInst<Device>>();
        Db db = OrbitIO.getCurDb();
        Selection selection = Design.getSelection((Db)db);
        Selection.SelSet selSet = selection.getSelSet(db.getDbClass(Device.class));
        List<HierInst<Device>> ioDevices = this.getIODevices();
        for (APair thePair : selSet.getElements()) {
            HierInst<Device> hDev;
            Device device = (Device)thePair.second;
            if (!this.mDiePath.getLast().hasChild(device) || !ioDevices.contains(hDev = this.createHierInst(device))) continue;
            selected.add(hDev);
        }
        return selected;
    }

    public List<HierInst<Device>> getIODevices() {
        return CellType.getIOType().stream().map(this::getDeviceByType).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<HierInst<Device>> getPGDevices() {
        return CellType.getPGType().stream().map(this::getDeviceByType).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<HierInst<Device>> getFlattenFixedOrderDeivces() {
        return this.mFixedOrderDevices.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<HierInst<Device>> getFixedOrderDevicesByHead(HierInst<Device> head) {
        return this.mFixedOrderDevices.get(head);
    }

    public boolean isHeadOfFixedOrder(HierInst<Device> driver) {
        return this.mFixedOrderDevices.containsKey(driver);
    }

    private List<Device> removeDup(List<Device> devices) {
        return devices.stream().collect(Collectors.toCollection(LinkedHashSet::new)).stream().collect(Collectors.toList());
    }

    private HierInst<Device> createHierInst(Device d) {
        DevicePath diePath;
        DevicePath devicePath = diePath = this.mDiePath == null ? new DevicePath(d) : this.mDiePath.copy();
        if (diePath.getLast() != d) {
            diePath.add(d);
        }
        return HierInst.create((DevicePath)diePath, (DbObject)d);
    }

    private void addDevices(Map<String, List<Device>> devicesBySide) {
        for (Map.Entry<String, List<Device>> entry : devicesBySide.entrySet()) {
            String type = entry.getKey().toUpperCase();
            List<Device> devices = this.removeDup(entry.getValue());
            this.mDevices.put(CellType.valueOf(type), devices.stream().map(this::createHierInst).collect(Collectors.toList()));
        }
    }

    private void addFixedOrderDevice(Map<String, List<Device>> devicesBySide, Map<Device, String> fixedOrderDevices) {
        Stream flatten = devicesBySide.values().stream().map(this::removeDup).flatMap(Collection::stream);
        Map<String, List<Device>> map = flatten.filter(d -> fixedOrderDevices.get(d) != null).collect(Collectors.groupingBy(fixedOrderDevices::get));
        IOCellPlacer.createConnections(this);
        for (Map.Entry<String, List<Device>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<Device> group = entry.getValue();
            Device head = group.stream().filter(d -> !IOCellPlacer.getDriverBallConns(d, this.mDiePath.getLast()).isEmpty()).findFirst().orElse(null);
            if (head == null) {
                ALog.logWarn((String)"No outward connection exists in fixed order group %s", (Object[])new Object[]{key});
                continue;
            }
            List hierGroup = group.stream().map(this::createHierInst).collect(Collectors.toList());
            this.mFixedOrderDevices.put((HierInst<Device>)((HierInst)hierGroup.get(group.indexOf(head))), hierGroup);
        }
        IOCellPlacer.removeConnections();
    }

    public void update(IOCellEntry newEntry) {
        this.mUpdateOnly = newEntry.mUpdateOnly;
        this.mDiePath = newEntry.mDiePath;
        this.mCoreDomains = newEntry.mCoreDomains;
        this.mIODomains = newEntry.mIODomains;
        this.mDevices = newEntry.mDevices;
        this.mFixedOrderDevices = newEntry.mFixedOrderDevices;
    }

    private IOCellEntry() {
    }

    public boolean show(Connection c) {
        HierPin hp1 = c.getDPPA();
        HierPin hp2 = c.getDPPB();
        return this.getIODevices().stream().anyMatch(hDev -> {
            DevicePath path = hDev.getPath();
            return path.equals((Object)hp1.getPath()) || path.equals((Object)hp2.getPath());
        });
    }

    public String getDescription() {
        return "";
    }

    static enum CellType {
        RIGHT("RIGHT"),
        TOP("TOP"),
        LEFT("LEFT"),
        BOTTOM("BOTTOM"),
        LR("LR"),
        UR("UR"),
        UL("UL"),
        LL("LL"),
        ANY("Any");

        static final Set<CellType> ioTypes;
        static final Set<CellType> cornerTypes;
        static final Set<CellType> pgTypes;
        String typeName;

        public static Set<CellType> getIOType() {
            return ioTypes;
        }

        public static Set<CellType> getCornerType() {
            return cornerTypes;
        }

        public static Set<CellType> getPGType() {
            return pgTypes;
        }

        private CellType(String name) {
            this.typeName = name;
        }

        public boolean isIO() {
            return CellType.getIOType().contains((Object)this);
        }

        public boolean isCorner() {
            return CellType.getCornerType().contains((Object)this);
        }

        public boolean isPG() {
            return CellType.getPGType().contains((Object)this);
        }

        public String toString() {
            return this.typeName;
        }

        static {
            ioTypes = Set.of(RIGHT, TOP, LEFT, BOTTOM);
            cornerTypes = Set.of(LR, UR, UL, LL);
            pgTypes = Set.of(ANY);
        }
    }
}

