/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.LineUnCrosser;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.iocellplacement.DriverBallPair;
import com.sigrity.orbit.automation.iocellplacement.IOCellEntry;
import com.sigrity.orbit.automation.iocellplacement.IllegalDirectionException;
import com.sigrity.orbit.automation.iocellplacement.PlaceableDriver;
import com.sigrity.orbit.automation.iocellplacement.RuleTable;
import com.sigrity.orbit.factory.PartFactory;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class IOCellPlacer {
    static final String PLACECOMMAND = "Place IO Cell";
    static final String UNCROSSCOMMAND = "Uncross IO Cell";
    static final String PREPAREPGCOMMAND = "Prepare PG Cell";
    static final String PLACEPGCOMMAND = "Place PG Cell";
    static final String PLACEPADCOMMAND = "Place Pad";
    static final String PADPREFIX = "Pad";
    static final String PLACECANVASCOMMAND = "Place IO Cell from Canvas";
    static final List<AGeomUtil.CompassDir> PlaceOrder = ImmutableList.of((Object)AGeomUtil.CompassDir.E, (Object)AGeomUtil.CompassDir.N, (Object)AGeomUtil.CompassDir.W, (Object)AGeomUtil.CompassDir.S);
    private static WeakHashMap<APair<Db, DeviceTemplate>, IOCellPlacer> placerToDb = new WeakHashMap();
    Db mDb = null;
    Device mDevice = null;
    DevicePath mDevicePath = null;
    ARect mDeviceBB = null;
    List<PlaceableDriver> mPdPlaced = null;
    boolean mSilent = false;
    int mUncrossTimes = 10;
    int mGroupWindowSize = 40;
    RuleTable mRuleTable = new RuleTable();
    IOCellEntry mEntry = null;
    PlacePattern mPlacePattern = PlacePattern.SQUARE;
    UncrossPattern mUncrossPattern = UncrossPattern.ONE_SIDE;
    Strategy mStrategy = Strategy.FULL;

    public static IOCellPlacer getOrCreatePlacer(Db db, String devPathStr) {
        DevicePath dPath = DevicePath.fromEscapedString((Db)db, (String)devPathStr);
        APair key = APair.create((Object)db, (Object)dPath.getDeviceTemplate());
        IOCellPlacer placer = null;
        if (placerToDb.containsKey(key)) {
            placer = placerToDb.get(key);
        } else {
            placer = new IOCellPlacer(db, dPath);
            IOCellEntry entry = IOCellEntry.getExistingIOCell(devPathStr);
            if (!entry.isEmpty()) {
                placer.setEntry(entry);
                placer.reEntry();
            }
            placerToDb.put((APair<Db, DeviceTemplate>)key, placer);
        }
        return placer;
    }

    public static List<Connection> getDriverBallConns(Device driver, Device substrate) {
        return driver.getConnections().stream().filter(c -> {
            HierPin hPinB;
            HierPin hPinA = c.getDPPA();
            boolean predA = DriverBallPair.isDriverBallPair(hPinA, hPinB = c.getDPPB()) && hPinA.getPath().pathToSubstrate().getLast() == substrate;
            boolean predB = DriverBallPair.isDriverBallPair(hPinB, hPinA) && hPinB.getPath().pathToSubstrate().getLast() == substrate;
            return predA || predB;
        }).sorted().collect(Collectors.toList());
    }

    static void createConnections(HConnEngine.ShowConnectionFunction scf) {
        Db db = OrbitIO.getCurDb();
        HConnEngine ce = new HConnEngine(db);
        ce.setShowConnectionFunction(scf);
        ce.createConnections();
    }

    static void removeConnections() {
        Db db = OrbitIO.getCurDb();
        Connection.removeAll((Db)db);
    }

    static boolean isConnInSide(double connAngle, AGeomUtil.CompassDir side) {
        boolean isInSide = false;
        isInSide = side == AGeomUtil.CompassDir.E ? connAngle >= 0.0 && connAngle < 90.0 : (side == AGeomUtil.CompassDir.N ? connAngle >= 90.0 && connAngle < 180.0 : (side == AGeomUtil.CompassDir.W ? connAngle >= 180.0 && connAngle < 270.0 : (side == AGeomUtil.CompassDir.S ? connAngle >= 270.0 && connAngle < 360.0 : true)));
        return isInSide;
    }

    static <T> Set<T> toSet(Stream<T> s) {
        return s.collect(Collectors.toSet());
    }

    static <T> List<T> toList(Stream<T> s) {
        return s.collect(Collectors.toList());
    }

    static <T> T getTail(List<T> l) {
        return l.get(l.size() - 1);
    }

    private IOCellPlacer(Db db, DevicePath dPath) {
        this.mDb = db;
        this.mDevice = dPath.getLast();
        this.mDevicePath = dPath;
        this.mDeviceBB = this.mDevicePath.getBB();
    }

    public void setEntry(IOCellEntry entry) {
        if (this.mEntry == null) {
            this.mEntry = entry;
        } else {
            this.mEntry.update(entry);
        }
    }

    public void reEntry() {
        if (this.mEntry != null && this.mEntry.isUpdateOnly()) {
            this.regainDevices();
        } else {
            this.clearPdPlaced();
        }
    }

    public void setRowRule(long numRowR, long numRowT, long numRowL, long numRowD) {
        this.mRuleTable.setNumOfRow(AGeomUtil.CompassDir.E, numRowR);
        this.mRuleTable.setNumOfRow(AGeomUtil.CompassDir.N, numRowT);
        this.mRuleTable.setNumOfRow(AGeomUtil.CompassDir.W, numRowL);
        this.mRuleTable.setNumOfRow(AGeomUtil.CompassDir.S, numRowD);
    }

    public void setPlacePattern(String patternStr) {
        this.mPlacePattern = PlacePattern.valueOf(patternStr);
    }

    public void setUncrossPattern(String patternStr) {
        this.mUncrossPattern = UncrossPattern.valueOf(patternStr);
    }

    public void setPad(String padKeyStr, long padOffset, long padChange) {
        DeviceTemplate padT = (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, padKeyStr);
        this.mRuleTable.setPad(padT);
        this.mRuleTable.setPadOffset(padOffset);
        this.mRuleTable.setPadSpacing(padChange);
    }

    public void setSilent(boolean silent) {
        this.mSilent = silent;
    }

    public void setUncrossTimes(long uncrossTimes) {
        this.mUncrossTimes = (int)uncrossTimes;
    }

    public void setGroupWindowSize(long groupWindowSize) {
        this.mGroupWindowSize = (int)groupWindowSize;
    }

    public void setBallProx(long ballProx) {
        this.mRuleTable.setBallProx(ballProx);
    }

    public void setCloserBallFirst(boolean closerBallFirst) {
        this.setStrategy(closerBallFirst ? Strategy.CBF : Strategy.FULL);
    }

    public void setStrategy(Strategy strategy) {
        this.mStrategy = strategy;
    }

    public Strategy getStrategy() {
        if (this.mStrategy == Strategy.CBF && !this.hasPdPlaced()) {
            return Strategy.FULL;
        }
        return this.mStrategy;
    }

    public void updateSpacing(long padChange, long heightChange, long domainChange, long rowChange) {
        if (this.mEntry == null) {
            return;
        }
        List<HierInst<Device>> ioDevices = this.mEntry.getIODevices();
        List<HierInst<Device>> pgDevices = this.mEntry.getPGDevices();
        this.updateSpacingUtil(ioDevices, ioDevices, padChange, heightChange, domainChange, rowChange);
        this.updateSpacingUtil(ioDevices, pgDevices, padChange, 0L, 0L, rowChange);
        this.updateSpacingUtil(pgDevices, ioDevices, padChange, 0L, 0L, rowChange);
        this.updateSpacingUtil(pgDevices, pgDevices, padChange, 0L, 0L, rowChange);
    }

    public void place() {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Die is null");
        }
        if (this.mEntry == null) {
            ALog.logWarn((String)"Entry is null. Import csv to create cells or set information by \"Update Cell Only\" option");
            return;
        }
        try (DbHistory.DbTransaction t = this.mDb.getHistory().newDbTransaction(PLACECOMMAND);){
            this.removePad();
            this.preparePG();
            IOCellPlacer.createConnections(this.mEntry);
            this.placeStrategy();
        }
        catch (RuntimeException e) {
            ALog.logWarn((String)"Exception when placing IO cell");
            throw e;
        }
    }

    public void preparePG() {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Die is null");
        }
        if (this.mEntry == null) {
            ALog.logWarn((String)"Entry is null. Import csv to create cells or set information by \"Update Cell Only\" option");
            return;
        }
        this.setSilent(true);
        Map<Personality, List<HierInst>> map = this.mEntry.getPGDevices().stream().collect(Collectors.groupingBy(d -> ((Device)d.getDbObject()).getPersonality()));
        try (DbHistory.DbTransaction t = this.mDb.getHistory().newDbTransaction(PREPAREPGCOMMAND);){
            this.placeOutOfDie(map.values(), AGeomUtil.CompassDir.N);
        }
        if (!this.isSilent()) {
            ALog.logInfo((String)"There were %d PG cells placed at the top", (Object[])new Object[]{this.mEntry.getPGDevices().size()});
        }
    }

    public void placePG() {
        if (!this.hasPdPlaced()) {
            ALog.logWarn((String)"Execute place before placing P/G");
            return;
        }
        try (DbHistory.DbTransaction t = this.mDb.getHistory().newDbTransaction(PLACEPGCOMMAND);){
            this.preparePG();
            this.removePad();
            List<HierInst<Device>> pgDevices = this.mEntry.getPGDevices();
            List<PlaceableDriver> flattenRow = PlaceableDriver.getFlattenRowPd(this.mPdPlaced);
            this.getPdsIsPG(flattenRow, null).forEach(pg -> pgDevices.remove(pg.getDriver()));
            List<HierInst<Device>> ioPower = IOCellPlacer.toList(pgDevices.stream().filter(hierD -> this.mEntry.getIODomain((HierInst<Device>)hierD) != null));
            List<HierInst<Device>> corePower = IOCellPlacer.toList(pgDevices.stream().filter(hierD -> this.mEntry.getCoreDomain((HierInst<Device>)hierD) != null));
            this.setSilent(true);
            this.setPlacePattern(PlacePattern.SQUARE.toString());
            this.mPdPlaced = this.placeIOPowerPG(this.mPdPlaced, ioPower);
            this.mPdPlaced = this.placeCorePowerPG(this.mPdPlaced, corePower);
        }
    }

    public void placePad() {
        if (!this.hasPad()) {
            ALog.logWarn((String)"No pad is selected. Create one and try again");
            return;
        }
        if (!this.hasPdPlaced()) {
            ALog.logWarn((String)"Execute place before placing pad");
            return;
        }
        try (DbHistory.DbTransaction t = this.mDb.getHistory().newDbTransaction(PLACEPADCOMMAND);){
            this.removePad();
            IOCellPlacer.createConnections(this.mEntry);
            ArrayList<PlaceableDriver> pdToPut = new ArrayList<PlaceableDriver>();
            for (PlaceableDriver pd2 : this.mPdPlaced) {
                this.addFixedOrderDriver(pd2);
                pdToPut.addAll(pd2.getFlatten());
            }
            pdToPut.removeIf(pd -> pd.isIO() && this.getDriverBallConns((PlaceableDriver)pd) == null);
            this.placePad(pdToPut);
        }
        catch (RuntimeException e) {
            ALog.logWarn((String)"Exception when placing pad");
            throw e;
        }
        finally {
            IOCellPlacer.removeConnections();
        }
    }

    public void uncross() {
        if (!this.hasPdPlaced()) {
            ALog.logWarn((String)"Execute place before uncross");
            return;
        }
        try (DbHistory.DbTransaction t = this.mDb.getHistory().newDbTransaction(UNCROSSCOMMAND);){
            this.removePad();
            IOCellPlacer.createConnections(this.mEntry);
            this.uncrossByTimes();
        }
        catch (RuntimeException e) {
            ALog.logWarn((String)"Exception when uncrossing IO cell");
            throw e;
        }
    }

    public void removePad() {
        if (!this.hasPdPlaced()) {
            return;
        }
        if (!this.hasPad()) {
            return;
        }
        this.mRuleTable.getPad().deleteAllTemplateInsts();
    }

    private boolean isSilent() {
        return this.mSilent;
    }

    private boolean hasPdPlaced() {
        return this.mPdPlaced != null && !this.mPdPlaced.isEmpty();
    }

    private boolean hasPad() {
        return this.mRuleTable.getPad() != null;
    }

    private void regainDevices() {
        if (!this.hasPdPlaced()) {
            this.regainDevicesFromCanvas();
        } else {
            this.regainDevicesFromDb();
        }
    }

    private void regainDevicesFromCanvas() {
        IOCellPlacer.createConnections(this.mEntry);
        List<HierInst<Device>> drivers = IOCellPlacer.toList(Stream.of(this.mEntry.getIODevices(), this.mEntry.getPGDevices()).flatMap(Collection::stream).filter(d -> this.mDeviceBB.intersects(d.getPath().getBB())));
        List<DriverBallPair> pairs = this.getDriverPallPairs(drivers, false);
        this.setSilent(true);
        this.mPdPlaced = this.placeCanvas(pairs);
        IOCellPlacer.removeConnections();
    }

    private void regainDevicesFromDb() {
        try {
            PlaceableDriver.getFlattenRowPd(this.mPdPlaced).stream().forEach(PlaceableDriver::regainDevicesFromDb);
        }
        catch (IllegalArgumentException e) {
            this.clearPdPlaced();
            ALog.logWarn((String)"Failed to recover new devices from the placement.");
        }
    }

    private void clearPdPlaced() {
        if (!this.hasPdPlaced()) {
            return;
        }
        this.mPdPlaced.clear();
    }

    private void updateSpacingUtil(List<HierInst<Device>> fromDevices, List<HierInst<Device>> toDevices, long padChange, long heightChange, long domainChange, long rowChange) {
        for (int from = 0; from < fromDevices.size(); ++from) {
            for (int to = 0; to < toDevices.size(); ++to) {
                HierInst<Device> fromHierD = fromDevices.get(from);
                HierInst<Device> toHierD = toDevices.get(to);
                long padSpacing = this.getPadSpacing(fromHierD, toHierD, padChange);
                long heightSpacing = this.getHeightSpacing(fromHierD, toHierD, heightChange);
                long domainSpacing = this.getDomainSpacing(fromHierD, toHierD, domainChange);
                long s2s = Math.max(padSpacing, Math.max(heightSpacing, domainSpacing));
                long e2e = rowChange;
                long s2e = Math.max(s2s, e2e);
                long e2s = Math.max(s2s, e2e);
                this.mRuleTable.setSpacing((Device)fromHierD.getDbObject(), (Device)toHierD.getDbObject(), RuleTable.createEntry(s2s, e2e, s2e, e2s));
            }
        }
    }

    private long getPadSpacing(HierInst<Device> fromHierD, HierInst<Device> toHierD, long spacing) {
        Net fromNet = ((Device)fromHierD.getDbObject()).getNet();
        Net toNet = ((Device)toHierD.getDbObject()).getNet();
        if (fromNet == null || toNet == null || fromNet == toNet) {
            return 0L;
        }
        ARect fromBB = ((Device)fromHierD.getDbObject()).getUntransformedShape().getBounds();
        ARect toBB = ((Device)toHierD.getDbObject()).getUntransformedShape().getBounds();
        ARect padBB = this.mRuleTable.getPadBB();
        return padBB.width() - (fromBB.width() + toBB.width()) / 2L + spacing;
    }

    private long getHeightSpacing(HierInst<Device> fromHierD, HierInst<Device> toHierD, long spacing) {
        ARect fromBB = ((Device)fromHierD.getDbObject()).getUntransformedShape().getBounds();
        ARect toBB = ((Device)toHierD.getDbObject()).getUntransformedShape().getBounds();
        return fromBB.height() == toBB.height() ? 0L : spacing;
    }

    private long getDomainSpacing(HierInst<Device> fromHierD, HierInst<Device> toHierD, long spacing) {
        Personality toDomain;
        Personality fromDomain = this.mEntry.getIODomain(fromHierD);
        return fromDomain == (toDomain = this.mEntry.getIODomain(toHierD)) ? 0L : spacing;
    }

    private void placeStrategy() {
        Strategy strategy = this.getStrategy();
        if (strategy == Strategy.FULL) {
            this.placeByBehavior();
            this.setUncrossPattern(UncrossPattern.ONE_SIDE.name());
            this.uncrossByTimes();
            this.groupByWindow();
            this.setUncrossPattern(UncrossPattern.ONE_ROW_ONE_DOMAIN.name());
            this.uncrossByTimes();
        } else if (strategy == Strategy.CBF) {
            this.partitionToRowByBallProx();
            this.setUncrossPattern(UncrossPattern.ONE_BALLROW.name());
            this.uncrossByTimes();
            this.partitionToRowByBallProx();
        }
    }

    private void placeByBehavior() {
        List<PlaceableDriver> driversPlaced = null;
        List<HierInst<Device>> selected = this.mEntry.getSelectedIODevices();
        this.setSilent(false);
        this.setPlacePattern(PlacePattern.SQUARE.name());
        if (selected.isEmpty() || !this.hasPdPlaced()) {
            List<DriverBallPair> pairs = this.getDriverPallPairs(this.mEntry.getIODevices(), true);
            driversPlaced = this.placeImported(pairs);
        } else {
            driversPlaced = this.placeSelected(selected);
        }
        this.mPdPlaced = driversPlaced;
    }

    private void uncrossByTimes() {
        List<HierInst<Device>> selected = this.mEntry.getSelectedIODevices();
        if (!selected.isEmpty()) {
            return;
        }
        this.setSilent(true);
        this.setPlacePattern(PlacePattern.REMAIN.name());
        for (int i = 0; i < this.mUncrossTimes; ++i) {
            List<DriverBallPair> pairs = this.getDriverBallPairs(this.uncross(this.mPdPlaced), false);
            this.mPdPlaced = this.placeImported(pairs);
        }
    }

    private void groupByWindow() {
        List<HierInst<Device>> selected = this.mEntry.getSelectedIODevices();
        this.setSilent(true);
        this.setPlacePattern(PlacePattern.SQUARE.name());
        if (selected.isEmpty()) {
            List<DriverBallPair> pairs = this.getDriverBallPairs(this.group(this.mPdPlaced), false);
            this.mPdPlaced = this.placeImported(pairs);
        } else {
            this.mPdPlaced = this.placePrepared(this.groupSelected(this.mPdPlaced, selected));
        }
    }

    private void partitionToRowByBallProx() {
        if (this.mStrategy != Strategy.CBF) {
            return;
        }
        List<PlaceableDriver> flattenRowPd = PlaceableDriver.getFlattenRowPd(this.mPdPlaced);
        flattenRowPd.forEach(PlaceableDriver::clearNextRow);
        this.setSilent(true);
        this.mPdPlaced = this.placeBallRow(flattenRowPd);
    }

    private List<PlaceableDriver> placeImported(List<DriverBallPair> pairs) {
        ArrayList<PlaceableDriver> driversPlaced = new ArrayList<PlaceableDriver>();
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            this.placeCorner(side, driversPlaced);
            List<DriverBallPair> pairAtSide = IOCellPlacer.toList(this.getPairsAtSideByConn(pairs, side));
            this.unifyFixedOrderPair(pairAtSide);
            for (PlaceableDriver pd : this.getPlacementByOption(pairAtSide, side, true)) {
                this.place(pd, driversPlaced);
            }
        }
        return this.placePostAction(driversPlaced);
    }

    private List<PlaceableDriver> placeSelected(List<HierInst<Device>> selected) {
        ArrayList<PlaceableDriver> driversPlaced = new ArrayList<PlaceableDriver>();
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            for (PlaceableDriver pd : this.getSelectedPlacement(selected, side)) {
                this.place(pd, driversPlaced);
            }
        }
        return this.placePostAction(driversPlaced);
    }

    private List<PlaceableDriver> placePrepared(List<PlaceableDriver> pds) {
        ArrayList<PlaceableDriver> driversPlaced = new ArrayList<PlaceableDriver>();
        for (PlaceableDriver pd : pds) {
            if (pd.isDummy()) {
                driversPlaced.add(pd);
                continue;
            }
            List<PlaceableDriver> flattenOrder = pd.getFlattenOrder();
            pd.clearOrder();
            for (PlaceableDriver curPd : flattenOrder) {
                this.place(curPd, driversPlaced);
            }
        }
        return this.placePostAction(driversPlaced);
    }

    private List<PlaceableDriver> placeBallRow(List<PlaceableDriver> pds) {
        LinkedList<PlaceableDriver> driversPlaced = new LinkedList<PlaceableDriver>();
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            this.placeCorner(side, driversPlaced);
            List<PlaceableDriver> ioCells = IOCellPlacer.toList(this.getPdsIsIO(pds, side));
            List<List<PlaceableDriver>> pdInBallRows = this.getPdsInBallRow(ioCells, side);
            for (List<PlaceableDriver> row : pdInBallRows) {
                row.forEach(PlaceableDriver::clearNextRow);
            }
            for (PlaceableDriver pd : this.getBallRowPlacement(pdInBallRows, side)) {
                this.addAllSameNetDrivers(pd);
                this.place(pd, driversPlaced);
            }
        }
        return this.placePostAction(driversPlaced);
    }

    private List<PlaceableDriver> placeCanvas(List<DriverBallPair> pairs) {
        ArrayList<PlaceableDriver> driversPlaced = new ArrayList<PlaceableDriver>();
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            this.placeCorner(side, driversPlaced);
            List<DriverBallPair> pairAtSide = IOCellPlacer.toList(this.getPairsAtSideByDriver(pairs, side).sorted(DriverBallPair.getDriverOrderComparator(side)));
            this.unifyFixedOrderPair(pairAtSide);
            for (PlaceableDriver pd : this.getPlacementByOption(pairAtSide, side, true)) {
                this.place(pd, driversPlaced);
            }
        }
        return this.placePostAction(driversPlaced);
    }

    private List<PlaceableDriver> placePostAction(List<PlaceableDriver> driversPlaced) {
        this.center(driversPlaced);
        this.placeUnconnected(driversPlaced);
        if (!this.isSilent()) {
            ALog.logInfo((String)"There were %d IO drivers placed", (Object[])new Object[]{driversPlaced.stream().mapToLong(PlaceableDriver::getNumOfDriver).sum()});
        }
        this.checkDRC(driversPlaced);
        this.unifyFixedOrderPd(driversPlaced);
        return driversPlaced;
    }

    private List<PlaceableDriver> getPlacementByOption(List<DriverBallPair> pairAtSide, AGeomUtil.CompassDir side, boolean innerBall) {
        List<PlaceableDriver> placement = null;
        if (this.mPlacePattern.isSquare()) {
            placement = this.getSquare(pairAtSide, side);
        } else if (this.mPlacePattern.isRemain()) {
            placement = this.getRemain(pairAtSide, side);
        } else {
            throw new IllegalArgumentException("Unknown place pattern");
        }
        return innerBall ? this.getInnerBall(placement, side) : placement;
    }

    private List<PlaceableDriver> getSquare(List<DriverBallPair> pairAtSide, AGeomUtil.CompassDir side) {
        LinkedList<PlaceableDriver> pdAtSide = new LinkedList<PlaceableDriver>();
        boolean isLastPdHasOrder = false;
        for (int i = 0; i < pairAtSide.size(); ++i) {
            DriverBallPair pair = pairAtSide.get(i);
            PlaceableDriver newPd = this.addDriver(pair, side);
            if (newPd.hasOrder() || pdAtSide.isEmpty()) {
                pdAtSide.addAll(newPd.getFlattenOrder());
            } else {
                PlaceableDriver headPd = IOCellPlacer.getTail(pdAtSide);
                boolean isRowAvail = this.mRuleTable.checkRowAvailability(headPd.getNumOfRow(), side);
                if (isLastPdHasOrder || !isRowAvail) {
                    pdAtSide.add(newPd);
                } else {
                    this.addCellToFirstRow(newPd, headPd);
                }
            }
            isLastPdHasOrder = newPd.clearOrder();
        }
        return pdAtSide;
    }

    private List<PlaceableDriver> getRemain(List<DriverBallPair> pairAtSide, AGeomUtil.CompassDir side) {
        if (!this.hasPdPlaced()) {
            return this.getSquare(pairAtSide, side);
        }
        ArrayList<PlaceableDriver> pdAtSide = new ArrayList<PlaceableDriver>();
        int start = 0;
        for (Integer colSize : this.colifyPdSize(this.mPdPlaced, side)) {
            PlaceableDriver headPd = null;
            int end = start + colSize;
            while (start < end) {
                PlaceableDriver newPd = this.addDriver(pairAtSide.get(start), side);
                if (headPd == null) {
                    headPd = newPd;
                } else {
                    this.addCellToFirstRow(newPd, headPd);
                }
                ++start;
            }
            if (headPd == null) continue;
            pdAtSide.add(headPd);
        }
        return pdAtSide;
    }

    private List<PlaceableDriver> getInnerBall(List<PlaceableDriver> placement, AGeomUtil.CompassDir side) {
        for (int i = 0; i < placement.size(); ++i) {
            PlaceableDriver pd = placement.get(i);
            PlaceableDriver sortedPd = this.getPdRowSortByBall(pd, side);
            if (sortedPd == null) continue;
            this.addAllSameNetDrivers(sortedPd);
            this.replaceCellInFirstRow(placement, pd, sortedPd);
        }
        return placement;
    }

    private List<PlaceableDriver> getSelectedPlacement(List<HierInst<Device>> selected, AGeomUtil.CompassDir side) {
        List<PlaceableDriver> result = IOCellPlacer.toList(this.getPdsAtSide(this.mPdPlaced, side));
        result.forEach(this::addFixedOrderDriver);
        try {
            List<PlaceableDriver> seg = this.getSelectedSegment(result, selected);
            List<DriverBallPair> pairs = this.getDriverBallPairs(PlaceableDriver.getFlattenRowPd(seg), false);
            List<PlaceableDriver> newSeg = this.getPlacementByOption(pairs, side, true);
            int index = result.indexOf(seg.get(0));
            seg.clear();
            result.addAll(index, newSeg);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private List<PlaceableDriver> getSelectedSegment(List<PlaceableDriver> pdAtSide, List<HierInst<Device>> selected) {
        int start = -1;
        int end = -1;
        for (int i = 0; i < pdAtSide.size(); ++i) {
            List<PlaceableDriver> flattenRow = pdAtSide.get(i).getFlattenRow();
            boolean isSelected = flattenRow.stream().anyMatch(pd -> selected.contains(pd.getDriver()));
            if (!isSelected) continue;
            start = start == -1 ? i : start;
            end = i + 1;
        }
        return pdAtSide.subList(start, end);
    }

    private List<PlaceableDriver> getBallRowPlacement(List<List<PlaceableDriver>> pdInBallRows, AGeomUtil.CompassDir side) {
        LinkedList<PlaceableDriver> newPlacement = new LinkedList<PlaceableDriver>();
        if (pdInBallRows.isEmpty()) {
            return newPlacement;
        }
        List<PlaceableDriver> firstRow = pdInBallRows.get(0);
        int fixOrderCount = 0;
        for (int col = 0; col < firstRow.size(); ++col) {
            PlaceableDriver head = firstRow.get(col);
            if (this.mEntry.isHeadOfFixedOrder(head.getDriver())) {
                this.addFixedOrderDriver(head);
                ++fixOrderCount;
            } else {
                int newCol = col - fixOrderCount;
                for (int row = 1; row < pdInBallRows.size(); ++row) {
                    if (newCol >= pdInBallRows.get(row).size()) continue;
                    head.addNextRow(pdInBallRows.get(row).get(newCol));
                }
            }
            newPlacement.addAll(head.getFlattenOrder());
            head.clearOrder();
        }
        return this.appendOutsider(newPlacement, pdInBallRows, side);
    }

    private List<PlaceableDriver> appendOutsider(List<PlaceableDriver> basePlacement, List<List<PlaceableDriver>> pdInBallRows, AGeomUtil.CompassDir side) {
        if (basePlacement.isEmpty()) {
            return basePlacement;
        }
        List<List<PlaceableDriver>> curPlacement = this.rowifyPd(basePlacement, side);
        LinkedList<PlaceableDriver> appendPlacement = new LinkedList<PlaceableDriver>();
        for (int rowId = 1; rowId < curPlacement.size(); ++rowId) {
            List<PlaceableDriver> baseRow = curPlacement.get(rowId);
            List<PlaceableDriver> curRow = pdInBallRows.get(rowId);
            if (baseRow.size() >= curRow.size()) continue;
            List<PlaceableDriver> remainPds = curRow.subList(baseRow.size(), curRow.size());
            for (int i = 0; i < remainPds.size(); ++i) {
                PlaceableDriver remain = remainPds.get(i);
                if (appendPlacement.size() > i) {
                    ((PlaceableDriver)appendPlacement.get(i)).addNextRow(remain);
                    continue;
                }
                appendPlacement.add(remain);
            }
        }
        basePlacement.addAll(appendPlacement);
        return basePlacement;
    }

    private List<List<PlaceableDriver>> getPdsInBallRow(List<PlaceableDriver> ioCells, AGeomUtil.CompassDir side) {
        ArrayList<List<PlaceableDriver>> pdInRows = new ArrayList<List<PlaceableDriver>>();
        this.sortPdsByBall(ioCells, side);
        int nextHead = 0;
        int head = 0;
        while (head < ioCells.size()) {
            LinkedList<PlaceableDriver> curRow = new LinkedList<PlaceableDriver>();
            PlaceableDriver startPd = ioCells.get(head);
            for (int cur = head; cur < ioCells.size(); ++cur) {
                PlaceableDriver curPd = ioCells.get(cur);
                boolean isNeighbor = DriverBallPair.isNeighborBall(startPd.getBall(), curPd.getBall(), side, this.mRuleTable.getBallProx());
                boolean isFixed = this.mEntry.isHeadOfFixedOrder(curPd.getDriver());
                if (pdInRows.isEmpty() && isFixed || isNeighbor && !isFixed) {
                    curRow.add(curPd);
                }
                if (isNeighbor || nextHead != head) continue;
                nextHead = cur;
            }
            pdInRows.add(curRow);
            if (nextHead == head) break;
            head = nextHead;
        }
        return pdInRows;
    }

    private void placeUnconnected(List<PlaceableDriver> driversPlaced) {
        List<HierInst<Device>> unconnected = this.mEntry.getIODevices();
        for (PlaceableDriver pd : driversPlaced) {
            for (PlaceableDriver flatten : pd.getFlatten()) {
                unconnected.remove(flatten.getDriver());
            }
        }
        ArrayList<List<HierInst<Device>>> list = new ArrayList<List<HierInst<Device>>>();
        list.add(unconnected);
        this.placeOutOfDie(list, AGeomUtil.CompassDir.S);
        if (!this.isSilent() && !unconnected.isEmpty()) {
            ALog.logWarn((String)"There were %d unconnected IO drivers placed at the bottom", (Object[])new Object[]{unconnected.size()});
        }
    }

    private void placeOutOfDie(Collection<List<HierInst<Device>>> drivers, AGeomUtil.CompassDir side) {
        int row = 0;
        for (List<HierInst<Device>> driverInRow : drivers) {
            PlaceableDriver dummyPd;
            PlaceableDriver lastPd = dummyPd = new PlaceableDriver(null, this.getOutOfDiePos(side, 500000000L * (long)(++row)), side);
            for (HierInst<Device> deivce : driverInRow) {
                PlaceableDriver pd = new PlaceableDriver(deivce, side);
                if (lastPd.isDummy()) {
                    pd.setPosToPlace(lastPd.getPosToPlace());
                } else {
                    long s2s = this.mRuleTable.getSpacing((Device)((Device)pd.getDriver().getDbObject()), (Device)((Device)lastPd.getDriver().getDbObject())).mS2S;
                    long pitch = s2s + (lastPd.getWidth() + pd.getWidth()) / 2L;
                    APoint2D newPos = this.getNextPos(lastPd.getPosToPlace(), side, pitch);
                    pd.setPosToPlace(newPos);
                }
                pd.place();
                lastPd = pd;
            }
        }
    }

    private APoint2D getOutOfDiePos(AGeomUtil.CompassDir side, long offset) {
        APoint2D pos = this.getCornerPosByDir(side);
        if (side == AGeomUtil.CompassDir.W) {
            pos = pos.add(-offset, 0L);
        } else if (side == AGeomUtil.CompassDir.S) {
            pos = pos.add(0L, -offset);
        } else if (side == AGeomUtil.CompassDir.E) {
            pos = pos.add(offset, 0L);
        } else if (side == AGeomUtil.CompassDir.N) {
            pos = pos.add(0L, offset);
        } else {
            throw new IllegalDirectionException();
        }
        return pos;
    }

    private void center(List<PlaceableDriver> driversPlaced) {
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            List<PlaceableDriver> pdAtSide = IOCellPlacer.toList(this.getPdsAtSide(driversPlaced, side).filter(pd -> !pd.isCorner()));
            if (pdAtSide.isEmpty()) continue;
            PlaceableDriver headPd = pdAtSide.get(0).getHeadOrderPd();
            PlaceableDriver tailPd = IOCellPlacer.getTail(pdAtSide).getTailOrderPd();
            APoint2D centerOfPd = headPd.getPosToPlace().add(tailPd.getPosToPlace()).multiply(0.5);
            APoint2D offsetToSideCenter = this.getOffsetToSideCenter(side, centerOfPd);
            for (PlaceableDriver pd2 : pdAtSide) {
                pd2.move(offsetToSideCenter);
            }
        }
    }

    private List<PlaceableDriver> placeIOPowerPG(List<PlaceableDriver> driverPlaced, List<HierInst<Device>> ioPower) {
        class IOPGCellPlacer
        implements PGCellPlacer {
            IOPGCellPlacer() {
            }

            @Override
            public Personality collect(HierInst<Device> hierD) {
                return IOCellPlacer.this.mEntry.getIODomain(hierD);
            }

            @Override
            public Map<AGeomUtil.CompassDir, Integer> proportion(List<PlaceableDriver> pds, Personality domain, int numOfPG) {
                return IOCellPlacer.this.getIOPowerPGProportion(pds, domain, numOfPG);
            }

            @Override
            public void place(List<PlaceableDriver> pdsToAdd, Personality domain, List<HierInst<Device>> pgCells, AGeomUtil.CompassDir side) {
                IOCellPlacer.this.addIOPower(pdsToAdd, domain, pgCells, side);
            }
        }
        return this.placePowerPGUtil(driverPlaced, ioPower, new IOPGCellPlacer());
    }

    private List<PlaceableDriver> placeCorePowerPG(List<PlaceableDriver> driverPlaced, List<HierInst<Device>> corePower) {
        class CorePGCellPlacer
        implements PGCellPlacer {
            CorePGCellPlacer() {
            }

            @Override
            public Personality collect(HierInst<Device> hierD) {
                return IOCellPlacer.this.mEntry.getCoreDomain(hierD);
            }

            @Override
            public Map<AGeomUtil.CompassDir, Integer> proportion(List<PlaceableDriver> pds, Personality domain, int numOfPG) {
                return IOCellPlacer.this.getCorePowerPGProportion(pds, domain, numOfPG);
            }

            @Override
            public void place(List<PlaceableDriver> pdsToAdd, Personality domain, List<HierInst<Device>> pgCells, AGeomUtil.CompassDir side) {
                IOCellPlacer.this.addCorePower(pdsToAdd, pgCells, side);
            }
        }
        return this.placePowerPGUtil(driverPlaced, corePower, new CorePGCellPlacer());
    }

    private List<PlaceableDriver> placePowerPGUtil(List<PlaceableDriver> driverPlaced, List<HierInst<Device>> power, PGCellPlacer pgCellPlacer) {
        ArrayList<PlaceableDriver> newPlacement = new ArrayList<PlaceableDriver>(driverPlaced);
        newPlacement.forEach(this::addFixedOrderDriver);
        Map<Personality, List<HierInst>> pgGroupByDomain = power.stream().collect(Collectors.groupingBy(pgCellPlacer::collect));
        for (Map.Entry<Personality, List<HierInst>> entry : pgGroupByDomain.entrySet()) {
            Personality domain = entry.getKey();
            List<HierInst<Device>> pgCells = entry.getValue();
            for (List<HierInst<Device>> group : this.getEquivPGCell(pgCells).values()) {
                Map<AGeomUtil.CompassDir, Integer> prop = pgCellPlacer.proportion(this.mPdPlaced, domain, group.size());
                int startIndex = 0;
                for (AGeomUtil.CompassDir side : PlaceOrder) {
                    int endIndex = startIndex + prop.get(side);
                    pgCellPlacer.place(newPlacement, domain, group.subList(startIndex, endIndex), side);
                    startIndex = endIndex;
                }
            }
        }
        return this.placePrepared(newPlacement);
    }

    private Map<String, List<HierInst<Device>>> getEquivPGCell(List<HierInst<Device>> pgCells) {
        return pgCells.stream().collect(Collectors.groupingBy(d -> {
            String entryName = ((Device)d.getDbObject()).getName();
            int index = entryName.lastIndexOf(95);
            if (index != -1) {
                entryName = entryName.substring(0, index);
            }
            return entryName;
        }));
    }

    private Map<AGeomUtil.CompassDir, Integer> getIOPowerPGProportion(List<PlaceableDriver> pds, Personality domain, int numOfPG) {
        return this.getPGProportionUtil(this.getPdsInIODomain(pds, domain), numOfPG);
    }

    private Map<AGeomUtil.CompassDir, Integer> getCorePowerPGProportion(List<PlaceableDriver> pds, Personality domain, int numOfPG) {
        return this.getPGProportionUtil(this.getPdsInCoreDomain(pds, domain), numOfPG);
    }

    private List<APair<AGeomUtil.CompassDir, Integer>> getPdsInIODomain(List<PlaceableDriver> pds, Personality domain) {
        ArrayList<APair<AGeomUtil.CompassDir, Integer>> ioCount = new ArrayList<APair<AGeomUtil.CompassDir, Integer>>();
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            long count = this.getPdsInIODomain(pds, side, domain, true).count();
            ioCount.add((APair<AGeomUtil.CompassDir, Integer>)APair.create((Object)side, (Object)((int)count)));
        }
        return ioCount;
    }

    private List<APair<AGeomUtil.CompassDir, Integer>> getPdsInCoreDomain(List<PlaceableDriver> pds, Personality domain) {
        ArrayList<APair<AGeomUtil.CompassDir, Integer>> ioCount = new ArrayList<APair<AGeomUtil.CompassDir, Integer>>();
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            long count = this.getPdsInCoreDomain(pds, side, domain, true).count();
            ioCount.add((APair<AGeomUtil.CompassDir, Integer>)APair.create((Object)side, (Object)((int)count)));
        }
        return ioCount;
    }

    private Map<AGeomUtil.CompassDir, Integer> getPGProportionUtil(List<APair<AGeomUtil.CompassDir, Integer>> ioCount, int numOfPG) {
        EnumMap<AGeomUtil.CompassDir, Integer> prop = new EnumMap<AGeomUtil.CompassDir, Integer>(AGeomUtil.CompassDir.class);
        PlaceOrder.forEach(side -> prop.put((AGeomUtil.CompassDir)side, 0));
        ioCount.sort((a, b) -> (Integer)b.getSecond() - (Integer)a.getSecond());
        boolean hasCount = ioCount.stream().mapToInt(APair::getSecond).anyMatch(i -> i > 0);
        if (hasCount) {
            long remain = numOfPG;
            while (remain > 0L) {
                for (APair<AGeomUtil.CompassDir, Integer> count : ioCount) {
                    if (remain <= 0L || (Integer)count.getSecond() <= 0) continue;
                    prop.put((AGeomUtil.CompassDir)count.getFirst(), 1 + (Integer)prop.get(count.getFirst()));
                    --remain;
                }
            }
        }
        return prop;
    }

    private void addIOPower(List<PlaceableDriver> pdsToAdd, Personality domain, List<HierInst<Device>> pgCells, AGeomUtil.CompassDir side) {
        if (pgCells.isEmpty()) {
            return;
        }
        for (int i = 0; i < pgCells.size(); ++i) {
            int indexToAdd;
            int index;
            PlaceableDriver pgCell = new PlaceableDriver(pgCells.get(i), side);
            pgCell.setPGType();
            List<PlaceableDriver> pdsInSearch = this.excludeFixedOrder(pdsToAdd);
            List<PlaceableDriver> ioCells = IOCellPlacer.toList(this.getPdsInIODomain(pdsInSearch, side, domain, true));
            if (ioCells.isEmpty()) {
                List<PlaceableDriver> allCells = IOCellPlacer.toList(this.getPdsInIODomain(pdsInSearch, side, domain, false));
                index = allCells.size() - 1;
                indexToAdd = 1 + pdsToAdd.indexOf(allCells.get(index));
                pdsToAdd.add(indexToAdd, pgCell);
                continue;
            }
            float prop = (float)(1 + i) / (float)(1 + pgCells.size());
            index = (int)((float)ioCells.size() * prop);
            indexToAdd = 1 + pdsToAdd.indexOf(ioCells.get(index));
            pdsToAdd.add(indexToAdd, pgCell);
        }
    }

    private void addCorePower(List<PlaceableDriver> pdsToAdd, List<HierInst<Device>> pgCells, AGeomUtil.CompassDir side) {
        if (pgCells.isEmpty()) {
            return;
        }
        List<DriverBallPair> pairs = IOCellPlacer.toList(pgCells.stream().map(cell -> new DriverBallPair((HierInst<Device>)cell, null)));
        List<PlaceableDriver> pdCorePower = this.getPlacementByOption(pairs, side, false);
        PlaceableDriver.getFlattenRowPd(pdCorePower).forEach(PlaceableDriver::setPGType);
        List<PlaceableDriver> pdsInSearch = this.excludeFixedOrder(pdsToAdd);
        List<PlaceableDriver> allCells = IOCellPlacer.toList(this.getPdsAtSide(pdsInSearch, side));
        for (int i = 0; i < pdCorePower.size(); ++i) {
            float prop = (float)(1 + i) / (float)(1 + pdCorePower.size());
            int index = (int)((float)allCells.size() * prop);
            int indexToAdd = 1 + pdsToAdd.indexOf(allCells.get(index));
            pdsToAdd.add(indexToAdd, pdCorePower.get(i));
        }
    }

    private PlaceableDriver getPdRowSortByBall(PlaceableDriver headPd, AGeomUtil.CompassDir side) {
        if (!headPd.hasNextRow()) {
            return headPd;
        }
        List<PlaceableDriver> flattenRow = headPd.getFlattenRow();
        this.sortPdsByBall(flattenRow, side);
        headPd.clearNextRow();
        PlaceableDriver newHead = null;
        for (PlaceableDriver pd : flattenRow) {
            if (newHead == null) {
                newHead = pd;
                continue;
            }
            this.addCellToFirstRow(pd, newHead);
        }
        return newHead;
    }

    private void sortPdsByBall(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        pds.removeIf(p -> p.getBall() == null);
        pds.sort((a, b) -> -1 * DriverBallPair.compareToBall(a.getBall(), b.getBall(), side, this.mRuleTable.getBallProx()));
    }

    private void addCellToFirstRow(PlaceableDriver oldFstRow, PlaceableDriver newFstRow) {
        if (oldFstRow == newFstRow) {
            return;
        }
        oldFstRow.getFlattenRow().forEach(newFstRow::addNextRow);
        oldFstRow.clearNextRow();
    }

    private void replaceCellInFirstRow(List<PlaceableDriver> pdsToAdd, PlaceableDriver oldFstRow, PlaceableDriver newFstRow) {
        if (oldFstRow == newFstRow || newFstRow == null) {
            return;
        }
        int indexToAdd = pdsToAdd.indexOf(oldFstRow);
        if (indexToAdd != -1) {
            pdsToAdd.remove(indexToAdd);
            pdsToAdd.add(indexToAdd, newFstRow);
        }
    }

    private void placePad(List<PlaceableDriver> pdToPut) {
        DeviceTemplate padT = this.mRuleTable.getPad();
        long padOffsetRule = this.mRuleTable.getPadOffset();
        for (PlaceableDriver pd : pdToPut) {
            long padOffset = padOffsetRule;
            for (NetMap nm : NetMap.getParentMappings((Device)((Device)pd.getDriver().getDbObject()))) {
                Device pad = this.createPad(padT, nm.getParentNet());
                pad.setRotate(((Device)pd.getDriver().getDbObject()).getRotate());
                pad.setMirror(((Device)pd.getDriver().getDbObject()).getMirror());
                pad.putCenterAt(this.getPadLoc(pd, pad, padOffset));
                padOffset = padOffset + padT.getBB().height() + this.mRuleTable.getPadSpacing();
            }
        }
    }

    private Device getOrCreatePad(DeviceTemplate padT, Net net) {
        Optional<NetMap> r = this.findPad(padT, net);
        Device pad = r.isPresent() ? r.get().getDevice() : this.createPad(padT, net);
        return pad;
    }

    private Optional<NetMap> findPad(DeviceTemplate padT, Net net) {
        Net topMostNet = NetMap.getTopmostNet((Net)net, (DevicePath)this.mDevicePath);
        if (topMostNet == null) {
            Optional.empty();
        }
        return NetMap.getDescendantNets((Net)topMostNet).stream().filter(nm -> nm.getDevice().getTemplate() == padT).findFirst();
    }

    private Device createPad(DeviceTemplate padT, Net net) {
        Device parentDev = this.mDevicePath.getLast();
        String uniqueName = Device.getUniqueName((DeviceTemplate)parentDev.getTemplate(), (String)PADPREFIX);
        Device pad = Device.create((Db)this.mDb, (String)uniqueName, (DeviceTemplate)padT, (DeviceTemplate)parentDev.getTemplate());
        PinTemplate padPinT = this.addPadPin(pad);
        Net pinNet = this.addPinNet(pad, padPinT);
        NetMap.mapChildNet((Device)pad, (Net)pinNet, (Net)net);
        return pad;
    }

    private PinTemplate addPadPin(Device pad) {
        PinTemplate pinT = pad.getTemplate().getPin1();
        if (pinT == null) {
            pinT = PartFactory.makeIOPadPinTemplate(pad.getTemplate(), pad.getName(), true, null, true);
            pinT.getLayerShapes().forEach(ls -> ls.setGeom(pad.getTemplate().getBounds()));
            pinT.setLoc(APoint2D.Zero());
        }
        pinT.setType(PinTemplate.Type.BUMPPAD);
        PinInstance.getPinInstance((Device)pad, (PinTemplate)pinT);
        return pinT;
    }

    private Net addPinNet(Device pad, PinTemplate padPinT) {
        PinInstance padPin = pad.getPin(padPinT);
        if (padPin == null) {
            ALog.logError((String)"Could not find pin instance of %s", (Object[])new Object[]{padPinT});
            throw new IllegalArgumentException();
        }
        Net pinNet = padPin.getNet();
        if (pinNet == null || pinNet.isUnused()) {
            pinNet = Net.create((DeviceTemplate)pad.getTemplate(), (String)padPinT.getName());
            if (pinNet == null) {
                pinNet = pad.getTemplate().getNet(padPinT.getName());
            }
            padPin.setNet(pinNet);
        }
        return pinNet;
    }

    private APoint2D getPadLoc(PlaceableDriver pd, Device pad, Long offsetFromEnd) {
        long offsetToPadCenter = (pd.getHeight() - pad.getBB().height()) / 2L - offsetFromEnd;
        APoint2D localCenter = ((Device)pd.getDriver().getDbObject()).center();
        AGeomUtil.CompassDir side = AGeomUtil.getEminatingDir((double)((Device)pd.getDriver().getDbObject()).getRotate());
        APoint2D padLoc = null;
        if (side == AGeomUtil.CompassDir.W) {
            padLoc = localCenter.add(-offsetToPadCenter, 0L);
        } else if (side == AGeomUtil.CompassDir.S) {
            padLoc = localCenter.add(0L, -offsetToPadCenter);
        } else if (side == AGeomUtil.CompassDir.E) {
            padLoc = localCenter.add(offsetToPadCenter, 0L);
        } else if (side == AGeomUtil.CompassDir.N) {
            padLoc = localCenter.add(0L, offsetToPadCenter);
        } else {
            throw new IllegalDirectionException();
        }
        return padLoc;
    }

    private List<PlaceableDriver> uncross(List<PlaceableDriver> driverPlaced) {
        List<PlaceableDriver> result = PlaceableDriver.getFlattenRowPd(driverPlaced);
        Map<PlaceableDriver, Integer> indexMap = IntStream.range(0, result.size()).boxed().collect(Collectors.toMap(result::get, i -> i));
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            for (List<PlaceableDriver> uncrossee : this.getUncrosseeByOption(driverPlaced, side)) {
                this.uncrossPds(uncrossee, indexMap, result);
            }
        }
        return result;
    }

    private List<List<PlaceableDriver>> getUncrosseeByOption(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        List<Object> result = new LinkedList();
        if (this.mUncrossPattern.isOneSide()) {
            result.add(IOCellPlacer.toList(this.colifyPd(pds, side).stream().flatMap(Collection::stream)));
        } else if (this.mUncrossPattern.isOneRow()) {
            result = this.rowifyPd(pds, side);
        } else if (this.mUncrossPattern.isOneRowOneDomain()) {
            for (List<PlaceableDriver> row : this.rowifyPd(pds, side)) {
                result.addAll(this.getGroupsIODomain(row));
            }
        } else if (this.mUncrossPattern.isOneBallRow()) {
            List<PlaceableDriver> pdAtSide = IOCellPlacer.toList(this.getPdsAtSide(PlaceableDriver.getFlattenRowPd(pds), side));
            result = this.getPdsInBallRow(pdAtSide, side);
        } else if (this.mUncrossPattern.isOneBallRowOneDomain()) {
            List<PlaceableDriver> pdAtSide = IOCellPlacer.toList(this.getPdsAtSide(PlaceableDriver.getFlattenRowPd(pds), side));
            for (List<PlaceableDriver> row : this.getPdsInBallRow(pdAtSide, side)) {
                result.addAll(this.getGroupsIODomain(row));
            }
        } else {
            throw new IllegalArgumentException("Unknown uncross pattern");
        }
        return result;
    }

    private void uncrossPds(List<PlaceableDriver> list, Map<PlaceableDriver, Integer> indexMap, List<PlaceableDriver> uncrossResult) {
        List<PlaceableDriver> pds = this.excludeFixedOrder(list);
        List<DriverBallPair> pairs = this.getDriverBallPairs(pds, false);
        List<DriverBallPair> uncrossPairs = this.uncrossUtil(pairs);
        for (int i = 0; i < pairs.size(); ++i) {
            PlaceableDriver swapFrom = pds.get(i);
            PlaceableDriver swapTo = pds.get(pairs.indexOf(uncrossPairs.get(i)));
            Integer index = indexMap.get(swapFrom);
            uncrossResult.set(index, swapTo);
        }
    }

    private List<DriverBallPair> uncrossUtil(List<DriverBallPair> pairs) {
        LineUnCrosser lu = new LineUnCrosser();
        ArrayList ballLocs = pairs.stream().map(DriverBallPair::getBallLoc).collect(Collectors.toCollection(ArrayList::new));
        ArrayList uncrossResult = lu.uncross((List)ballLocs, pairs, p -> p, DriverBallPair::getDriverLoc);
        List uncrossIndex = uncrossResult.stream().map(pairs::indexOf).collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < pairs.size(); ++i) {
            DriverBallPair pairSrc = pairs.get(i);
            uncrossResult.set((Integer)uncrossIndex.get(i), pairSrc);
        }
        return uncrossResult;
    }

    private List<PlaceableDriver> group(List<PlaceableDriver> pds) {
        return this.groupUtil(pds, this.mGroupWindowSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PlaceableDriver> groupSelected(List<PlaceableDriver> pds, List<HierInst<Device>> selected) {
        ArrayList<PlaceableDriver> newPlacement = new ArrayList<PlaceableDriver>();
        newPlacement.forEach(this::addFixedOrderDriver);
        for (AGeomUtil.CompassDir side : PlaceOrder) {
            List<PlaceableDriver> pdAtSide = IOCellPlacer.toList(this.getPdsAtSide(pds, side));
            try {
                List<PlaceableDriver> seg = this.getSelectedSegment(pdAtSide, selected);
                List<DriverBallPair> pairs = this.getDriverBallPairs(this.groupUtil(seg, this.mGroupWindowSize, true), false);
                List<PlaceableDriver> newSeg = this.getPlacementByOption(pairs, side, true);
                int index = pdAtSide.indexOf(seg.get(0));
                seg.clear();
                pdAtSide.addAll(index, newSeg);
            }
            catch (Exception exception) {}
            continue;
            finally {
                newPlacement.addAll(pdAtSide);
            }
        }
        return newPlacement;
    }

    private List<PlaceableDriver> groupUtil(List<PlaceableDriver> pds, int windowSize, boolean uncrossGroup) {
        List<PlaceableDriver> flattenPds = PlaceableDriver.getFlattenRowPd(pds);
        flattenPds.forEach(PlaceableDriver::clearNextRow);
        if (windowSize <= 1) {
            return flattenPds;
        }
        ArrayList<PlaceableDriver> newPlacement = new ArrayList<PlaceableDriver>();
        int start = 0;
        int end = Math.min(start + windowSize, flattenPds.size());
        while (start < end) {
            List<PlaceableDriver> window = flattenPds.subList(start, end);
            for (List<PlaceableDriver> group : this.getGroupsIODomain(window)) {
                if (uncrossGroup) {
                    newPlacement.addAll(this.uncross(group));
                    continue;
                }
                newPlacement.addAll(group);
            }
            start = end;
            end = Math.min(start + windowSize, flattenPds.size());
        }
        return newPlacement;
    }

    List<List<PlaceableDriver>> getGroupsIODomain(List<PlaceableDriver> window) {
        LinkedList<List<PlaceableDriver>> result = new LinkedList<List<PlaceableDriver>>();
        LinkedHashSet allDomains = window.stream().map(pd -> this.mEntry.getIODomain(pd.getDriver())).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Personality domain : allDomains) {
            List<PlaceableDriver> group = IOCellPlacer.toList(this.getPdsInIODomain(window, null, domain, false));
            result.add(group);
        }
        return result;
    }

    private List<List<PlaceableDriver>> rowifyPd(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        ArrayList<List<PlaceableDriver>> pdInRows = new ArrayList<List<PlaceableDriver>>();
        for (List<PlaceableDriver> flattenRow : this.colifyPd(pds, side)) {
            for (int i = 0; i < flattenRow.size(); ++i) {
                if (i >= pdInRows.size()) {
                    pdInRows.add(new ArrayList());
                }
                ((List)pdInRows.get(i)).add(flattenRow.get(i));
            }
        }
        return pdInRows;
    }

    private List<List<PlaceableDriver>> colifyPd(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        ArrayList<List<PlaceableDriver>> cntedRow = new ArrayList<List<PlaceableDriver>>();
        List<PlaceableDriver> pdAtSide = IOCellPlacer.toList(this.getPdsAtSide(pds, side));
        for (PlaceableDriver pd : pdAtSide) {
            List<PlaceableDriver> flattenRow = pd.getFlattenRow();
            flattenRow.removeIf(p -> this.getDriverBallConns((PlaceableDriver)p) == null);
            if (flattenRow.isEmpty()) continue;
            cntedRow.add(flattenRow);
        }
        return cntedRow;
    }

    private List<Integer> colifyPdSize(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        return IOCellPlacer.toList(this.colifyPd(pds, side).stream().map(List::size));
    }

    private Stream<DriverBallPair> getPairsAtSideByDriver(List<DriverBallPair> pairs, AGeomUtil.CompassDir side) {
        return pairs.stream().filter(p -> AGeomUtil.getEminatingDir((double)p.getDriver().getPath().getRot()) == side);
    }

    private Stream<DriverBallPair> getPairsAtSideByConn(List<DriverBallPair> pairs, AGeomUtil.CompassDir side) {
        return pairs.stream().filter(p -> IOCellPlacer.isConnInSide(p.getConnAngle(), side));
    }

    private Stream<PlaceableDriver> getPdsAtSide(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        return pds.stream().filter(pd -> side == null || pd.getSide() == side);
    }

    private Stream<PlaceableDriver> getPdsInIODomain(List<PlaceableDriver> pds, AGeomUtil.CompassDir side, Personality domain, boolean ioOnly) {
        return this.getPdsAtSide(pds, side).filter(pd -> !ioOnly || pd.isIO()).filter(pd -> domain == this.mEntry.getIODomain(pd.getDriver()));
    }

    private Stream<PlaceableDriver> getPdsInCoreDomain(List<PlaceableDriver> pds, AGeomUtil.CompassDir side, Personality domain, boolean ioOnly) {
        return this.getPdsAtSide(pds, side).filter(pd -> !ioOnly || pd.isIO()).filter(pd -> domain == this.mEntry.getCoreDomain(pd.getDriver()));
    }

    private Stream<PlaceableDriver> getPdsIsIO(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        return this.getPdsAtSide(pds, side).filter(PlaceableDriver::isIO);
    }

    private Stream<PlaceableDriver> getPdsIsPG(List<PlaceableDriver> pds, AGeomUtil.CompassDir side) {
        return this.getPdsAtSide(pds, side).filter(PlaceableDriver::isPG);
    }

    private void unifyFixedOrderPair(List<DriverBallPair> pairs) {
        List<HierInst<Device>> fixedOrderDevices = this.mEntry.getFlattenFixedOrderDeivces();
        pairs.removeIf(pair -> {
            HierInst<Device> driver = pair.getDriver();
            return !this.mEntry.isHeadOfFixedOrder(driver) && fixedOrderDevices.contains(driver);
        });
    }

    private void unifyFixedOrderPd(List<PlaceableDriver> pds) {
        List<HierInst<Device>> fixedOrderDevices = this.mEntry.getFlattenFixedOrderDeivces();
        pds.removeIf(pd -> {
            HierInst<Device> driver = pd.getDriver();
            return !this.mEntry.isHeadOfFixedOrder(driver) && fixedOrderDevices.contains(driver);
        });
    }

    private List<PlaceableDriver> excludeFixedOrder(List<PlaceableDriver> pds) {
        List<HierInst<Device>> fixedOrderDevices = this.mEntry.getFlattenFixedOrderDeivces();
        ArrayList<PlaceableDriver> pdsWithOutFixedOrder = new ArrayList<PlaceableDriver>(pds);
        pdsWithOutFixedOrder.removeIf(pd -> fixedOrderDevices.contains(pd.getDriver()));
        return pdsWithOutFixedOrder;
    }

    private List<DriverBallPair> getDriverPallPairs(List<HierInst<Device>> list, boolean sortByAngle) {
        Set allConns = list.stream().map(d -> this.getFirstDriverBallConns((HierInst<Device>)d, this.mDevice)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        return this.getDriverBallPairs(allConns, sortByAngle);
    }

    private List<DriverBallPair> getDriverBallPairs(List<PlaceableDriver> list, boolean sortByAngle) {
        Set conns = list.stream().map(this::getDriverBallConns).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        return this.getDriverBallPairs(conns, sortByAngle);
    }

    private List<DriverBallPair> getDriverBallPairs(Set<Connection> allConns, boolean sortByAngle) {
        List<DriverBallPair> list = new LinkedList<DriverBallPair>();
        for (Connection c : allConns) {
            DriverBallPair pair = DriverBallPair.create(c.getDPPA(), c.getDPPB(), this.mDeviceBB.center());
            if (pair == null) continue;
            list.add(pair);
        }
        if (sortByAngle) {
            list = IOCellPlacer.toList(list.stream().sorted((p1, p2) -> Double.compare(p1.getConnAngle(), p2.getConnAngle())));
        }
        return list;
    }

    private APoint2D getCornerPosByDir(AGeomUtil.CompassDir initSide) {
        APoint2D initPos = null;
        if (initSide == AGeomUtil.CompassDir.W) {
            initPos = new APoint2D(this.mDeviceBB.left(), this.mDeviceBB.top());
        } else if (initSide == AGeomUtil.CompassDir.S) {
            initPos = new APoint2D(this.mDeviceBB.left(), this.mDeviceBB.bottom());
        } else if (initSide == AGeomUtil.CompassDir.E) {
            initPos = new APoint2D(this.mDeviceBB.right(), this.mDeviceBB.bottom());
        } else if (initSide == AGeomUtil.CompassDir.N) {
            initPos = new APoint2D(this.mDeviceBB.right(), this.mDeviceBB.top());
        } else {
            throw new IllegalDirectionException();
        }
        return initPos;
    }

    private APoint2D getOffsetToSideCenter(AGeomUtil.CompassDir side, APoint2D centerOfPd) {
        APoint2D offsetToSideCenter = null;
        if (side == AGeomUtil.CompassDir.W) {
            offsetToSideCenter = new APoint2D(0L, this.mDeviceBB.centerY() - centerOfPd.getY());
        } else if (side == AGeomUtil.CompassDir.S) {
            offsetToSideCenter = new APoint2D(this.mDeviceBB.centerX() - centerOfPd.getX(), 0L);
        } else if (side == AGeomUtil.CompassDir.E) {
            offsetToSideCenter = new APoint2D(0L, this.mDeviceBB.centerY() - centerOfPd.getY());
        } else if (side == AGeomUtil.CompassDir.N) {
            offsetToSideCenter = new APoint2D(this.mDeviceBB.centerX() - centerOfPd.getX(), 0L);
        } else {
            throw new IllegalDirectionException();
        }
        return offsetToSideCenter;
    }

    private PlaceableDriver addDriver(DriverBallPair pair, AGeomUtil.CompassDir side) {
        PlaceableDriver pd = new PlaceableDriver(pair.getDriver(), side);
        if (pair.getBall() != null) {
            pd.setBall(pair.getBall());
            this.addFixedOrderDriver(pd);
        }
        return pd;
    }

    private void addFixedOrderDriver(PlaceableDriver pd) {
        HierInst<Device> driver = pd.getDriver();
        if (!this.mEntry.isHeadOfFixedOrder(driver)) {
            return;
        }
        Set<HierInst> exist = IOCellPlacer.toSet(pd.getFlattenOrder().stream().map(PlaceableDriver::getDriver));
        List<HierInst<Device>> group = this.mEntry.getFixedOrderDevicesByHead(driver);
        int indexOfDriver = group.indexOf(driver);
        for (int i = 0; i < group.size(); ++i) {
            if (exist.contains(group.get(i))) continue;
            PlaceableDriver orderPd = new PlaceableDriver(group.get(i), pd.getSide());
            this.addSameNetDrivers(orderPd);
            if (i < indexOfDriver) {
                pd.addLastOrder(orderPd);
                continue;
            }
            if (i <= indexOfDriver) continue;
            pd.addNextOrder(orderPd);
        }
    }

    private void addSameNetDrivers(PlaceableDriver pd) {
        HierInst<Device> driver = pd.getDriver();
        if (((Device)driver.getDbObject()).getNet() == null) {
            return;
        }
        DevicePath parentPath = driver.getPath().getParent();
        List sameNetDrivers = ((Device)driver.getDbObject()).getSameNetDrivers(parentPath);
        if (sameNetDrivers.isEmpty()) {
            return;
        }
        Set<HierInst> exist = IOCellPlacer.toSet(pd.getFlattenRow().stream().map(PlaceableDriver::getDriver));
        List<HierInst<Device>> fixedOrderDevices = this.mEntry.getFlattenFixedOrderDeivces();
        List<HierInst<Device>> ioDevices = this.mEntry.getIODevices();
        for (Device other : sameNetDrivers) {
            DevicePath path = parentPath.addPath(new DevicePath(other));
            HierInst hDev = HierInst.create((DevicePath)path, (DbObject)other);
            if (exist.contains(hDev) || fixedOrderDevices.contains(hDev) || !ioDevices.contains(hDev)) continue;
            pd.addNextRow(new PlaceableDriver((HierInst<Device>)hDev, pd.getSide()));
        }
    }

    private void addAllSameNetDrivers(PlaceableDriver head) {
        for (PlaceableDriver pd : Lists.reverse(head.getFlattenRow())) {
            this.addSameNetDrivers(pd);
            if (pd == head) continue;
            pd.getNextRow().forEach(head::addNextRow);
            pd.clearNextRow();
        }
    }

    private Connection getFirstDriverBallConns(HierInst<Device> hierInst, Device substrate) {
        List<Connection> list;
        Connection c = null;
        c = this.mEntry.isHeadOfFixedOrder(hierInst) ? this.getDriverBallConnByNet(hierInst) : ((list = IOCellPlacer.getDriverBallConns((Device)hierInst.getDbObject(), substrate)).isEmpty() ? null : list.get(0));
        return c;
    }

    private Connection getDriverBallConnByNet(HierInst<Device> hierInst) {
        Connection c = null;
        try {
            HierPin ball = DriverBallPair.getSameNetBall((Device)hierInst.getDbObject(), this.mDevicePath);
            HierPin driver = HierPin.forPin((DevicePath)hierInst.getPath(), (PinInstance)((Device)hierInst.getDbObject()).getAnyPin());
            c = new Connection(ball, driver, false);
        }
        catch (IllegalArgumentException e) {
            ALog.logWarn((String)"Cannot get correspoing ball of %s", (Object[])new Object[]{hierInst.toString()});
        }
        return c;
    }

    private Connection getDriverBallConns(PlaceableDriver pd) {
        HierPin ball = pd.getBall();
        HierInst<Device> hDriver = pd.getDriver();
        Connection c = null;
        if (ball != null) {
            HierPin driver = HierPin.forPin((DevicePath)hDriver.getPath(), (PinInstance)((Device)hDriver.getDbObject()).getAnyPin());
            c = new Connection(ball, driver, false);
        }
        return c;
    }

    private void placeCorner(AGeomUtil.CompassDir side, List<PlaceableDriver> driversPlaced) {
        try {
            PlaceableDriver corner = new PlaceableDriver(this.mEntry.getCornerBySide(side), this.getCornerPosByDir(side), side);
            corner.setCornerType();
            this.place(corner, driversPlaced);
        }
        catch (IndexOutOfBoundsException e) {
            this.placeDummy(side, driversPlaced);
        }
    }

    private void placeDummy(AGeomUtil.CompassDir side, List<PlaceableDriver> driversPlaced) {
        if (driversPlaced.isEmpty()) {
            PlaceableDriver dummyCorner = new PlaceableDriver(null, this.getCornerPosByDir(side), side);
            dummyCorner.setCornerType();
            driversPlaced.add(dummyCorner);
        } else {
            PlaceableDriver tail = IOCellPlacer.getTail(driversPlaced);
            if (tail.isDummy()) {
                tail.setSide(side);
                tail.setPosToPlace(this.getCornerPosByDir(side));
            }
        }
    }

    private PlaceableDriver place(PlaceableDriver pd, List<PlaceableDriver> driversPlaced) {
        this.setAllDriversPos(pd, driversPlaced);
        pd.place();
        driversPlaced.add(pd);
        return pd;
    }

    private void setAllDriversPos(PlaceableDriver pd, List<PlaceableDriver> driversPlaced) {
        PlaceableDriver lastPd = pd.isCorner() ? pd : IOCellPlacer.getTail(driversPlaced).getTailOrderPd();
        for (PlaceableDriver curPd : pd.getFlattenOrder()) {
            lastPd = this.setDriverPos(curPd, lastPd, driversPlaced);
            this.setDriverRowPos(curPd, driversPlaced);
        }
    }

    private PlaceableDriver setDriverPos(PlaceableDriver pd, PlaceableDriver lastPd, List<PlaceableDriver> driversPlaced) {
        if (lastPd.isDummy() || pd.isCorner()) {
            APoint2D newPos = this.alignEndToEdge(lastPd.getPosToPlace(), pd.getSide(), pd.getHeight() / 2L);
            pd.setPosToPlace(this.alignSideToEdge(newPos, pd.getSide(), pd.getWidth() / 2L));
        } else if (lastPd.isIO() || lastPd.isPG()) {
            APoint2D newPos = this.getNextRowPos(pd, lastPd, lastPd, pd.getHeight() / 2L, pd.getSide());
            pd.setPosToPlace(newPos);
        } else if (lastPd.isCorner()) {
            APoint2D newPos = this.getNextTurningPos(pd, driversPlaced, pd.getSide());
            pd.setPosToPlace(newPos);
        }
        return pd;
    }

    public void setDriverRowPos(PlaceableDriver pd, List<PlaceableDriver> driversPlaced) {
        if (!pd.hasNextRow()) {
            return;
        }
        Optional<PlaceableDriver> r = this.getPdsAtSide(Lists.reverse(driversPlaced), pd.getSide()).filter(PlaceableDriver::hasNextRow).findFirst();
        PlaceableDriver lastPd = IOCellPlacer.getTail(driversPlaced).getTailOrderPd();
        PlaceableDriver lastPdWithRow = r.isPresent() ? r.get() : lastPd;
        long offset = pd.getHeight() / 2L;
        PlaceableDriver lastRowPd = pd;
        for (PlaceableDriver curRowPd : pd.getNextRow()) {
            long e2e = this.mRuleTable.getSpacing((Device)((Device)lastRowPd.getDriver().getDbObject()), (Device)((Device)curRowPd.getDriver().getDbObject())).mE2E;
            offset = offset + e2e + (lastRowPd.getHeight() + curRowPd.getHeight()) / 2L;
            APoint2D posFirst = this.getNextRowPos(curRowPd, lastPdWithRow, lastPd, offset, pd.getSide());
            APoint2D posSecond = this.getNextRowPos(curRowPd, lastPd, lastPd, offset, pd.getSide());
            APoint2D posThird = this.getNextAlignedPos(pd.getPosToPlace(), pd.getSide(), 0L, offset);
            APoint2D outerPos = DriverBallPair.isOuterCol(posFirst, posSecond, pd.getSide()) ? posFirst : posSecond;
            outerPos = DriverBallPair.isOuterCol(posThird, outerPos, pd.getSide()) ? posThird : outerPos;
            curRowPd.setPosToPlace(outerPos);
            lastRowPd = curRowPd;
        }
    }

    private APoint2D getNextAlignedPos(APoint2D lastPos, AGeomUtil.CompassDir newSide, long pitch, long offset) {
        APoint2D newPos = this.getNextPos(lastPos, newSide, pitch);
        return this.alignEndToEdge(newPos, newSide, offset);
    }

    private APoint2D getNextTurningPos(PlaceableDriver pd, List<PlaceableDriver> driversPlaced, AGeomUtil.CompassDir newSide) {
        PlaceableDriver lastPd;
        if (driversPlaced.isEmpty()) {
            return null;
        }
        long maxPitch = 0L;
        PlaceableDriver maxPd = IOCellPlacer.getTail(driversPlaced);
        ARect checkBB = this.getCheckTurningBB(pd, newSide);
        Iterator iterator = Lists.reverse(driversPlaced).iterator();
        while (iterator.hasNext() && !(lastPd = (PlaceableDriver)iterator.next()).isDummy() && (!lastPd.inside(this.mDeviceBB) || lastPd.intersects(checkBB))) {
            long s2e = this.mRuleTable.getSpacing((Device)((Device)pd.getDriver().getDbObject()), (Device)((Device)lastPd.getDriver().getDbObject())).mS2E;
            long pitch = s2e + ((lastPd = lastPd.getTailOrderPd()).getHeight() + pd.getWidth()) / 2L;
            if (pitch <= maxPitch) continue;
            maxPitch = pitch;
            maxPd = lastPd;
        }
        return this.getNextAlignedPos(maxPd.getPosToPlace(), newSide, maxPitch, pd.getHeight() / 2L);
    }

    private APoint2D getNextRowPos(PlaceableDriver pd, PlaceableDriver lastPd, PlaceableDriver initPd, long offset, AGeomUtil.CompassDir side) {
        APoint2D initPos = this.alignEndToEdge(initPd.getPosToPlace(), initPd.getSide(), offset);
        ARect checkBB = this.getCheckRowBB(pd, initPos, side);
        APoint2D maxPos = this.getNextAlignedPos(initPd.getPosToPlace(), side, 0L, offset);
        for (PlaceableDriver lastNRPd : lastPd.getFlattenRow()) {
            if (lastNRPd.isDummy() || pd == lastNRPd || !lastNRPd.intersects(checkBB)) continue;
            long s2s = this.mRuleTable.getSpacing((Device)((Device)pd.getDriver().getDbObject()), (Device)((Device)lastNRPd.getDriver().getDbObject())).mS2S;
            long pitch = s2s + (lastNRPd.getWidth() + pd.getWidth()) / 2L;
            APoint2D pos = this.getNextAlignedPos(lastNRPd.getPosToPlace(), side, pitch, offset);
            if (!DriverBallPair.isOuterCol(pos, maxPos, side)) continue;
            maxPos = pos;
        }
        return maxPos;
    }

    private ARect getCheckTurningBB(PlaceableDriver pd, AGeomUtil.CompassDir newSide) {
        long height = pd.getHeight();
        ARect checkBB = this.mDeviceBB.copy();
        if (newSide == AGeomUtil.CompassDir.W) {
            checkBB.setRight(this.mDeviceBB.left() + height);
        } else if (newSide == AGeomUtil.CompassDir.S) {
            checkBB.setTop(this.mDeviceBB.bottom() + height);
        } else if (newSide == AGeomUtil.CompassDir.E) {
            checkBB.setLeft(this.mDeviceBB.right() - height);
        } else if (newSide == AGeomUtil.CompassDir.N) {
            checkBB.setBottom(this.mDeviceBB.top() - height);
        } else {
            throw new IllegalDirectionException();
        }
        return checkBB;
    }

    private ARect getCheckRowBB(PlaceableDriver pd, APoint2D pos, AGeomUtil.CompassDir newSide) {
        AffineTransform t = ATransformUtil.createTransform((double)0.0, (double)0.0, (float)pd.getSide().getDirRotation(), (boolean)((Device)pd.getDriver().getDbObject()).getMirror());
        ARect checkBB = pd.getBounds().transform(t).getBounds();
        checkBB.moveCenterTo(pos);
        if (newSide == AGeomUtil.CompassDir.W) {
            checkBB.setBottom(this.mDeviceBB.bottom());
        } else if (newSide == AGeomUtil.CompassDir.E) {
            checkBB.setTop(this.mDeviceBB.top());
        } else if (newSide == AGeomUtil.CompassDir.S) {
            checkBB.setRight(this.mDeviceBB.right());
        } else if (newSide == AGeomUtil.CompassDir.N) {
            checkBB.setLeft(this.mDeviceBB.left());
        } else {
            throw new IllegalDirectionException();
        }
        return checkBB;
    }

    private APoint2D getNextPos(APoint2D pos, AGeomUtil.CompassDir side, long pitch) {
        APoint2D nextPos = null;
        if (side == AGeomUtil.CompassDir.W) {
            nextPos = pos.add(0L, -pitch);
        } else if (side == AGeomUtil.CompassDir.S) {
            nextPos = pos.add(pitch, 0L);
        } else if (side == AGeomUtil.CompassDir.E) {
            nextPos = pos.add(0L, pitch);
        } else if (side == AGeomUtil.CompassDir.N) {
            nextPos = pos.add(-pitch, 0L);
        } else {
            throw new IllegalDirectionException();
        }
        return nextPos;
    }

    private APoint2D alignEndToEdge(APoint2D pos, AGeomUtil.CompassDir side, long offset) {
        APoint2D newPos = pos.copy();
        if (side == AGeomUtil.CompassDir.W) {
            newPos.setX(this.mDeviceBB.left() + offset);
        } else if (side == AGeomUtil.CompassDir.S) {
            newPos.setY(this.mDeviceBB.bottom() + offset);
        } else if (side == AGeomUtil.CompassDir.E) {
            newPos.setX(this.mDeviceBB.right() - offset);
        } else if (side == AGeomUtil.CompassDir.N) {
            newPos.setY(this.mDeviceBB.top() - offset);
        } else {
            throw new IllegalDirectionException();
        }
        return newPos;
    }

    private APoint2D alignSideToEdge(APoint2D pos, AGeomUtil.CompassDir side, long offset) {
        APoint2D newPos = pos.copy();
        if (side == AGeomUtil.CompassDir.W) {
            newPos.setY(this.mDeviceBB.top() - offset);
        } else if (side == AGeomUtil.CompassDir.S) {
            newPos.setX(this.mDeviceBB.left() + offset);
        } else if (side == AGeomUtil.CompassDir.E) {
            newPos.setY(this.mDeviceBB.bottom() + offset);
        } else if (side == AGeomUtil.CompassDir.N) {
            newPos.setX(this.mDeviceBB.right() - offset);
        } else {
            throw new IllegalDirectionException();
        }
        return newPos;
    }

    private boolean isValidPos(PlaceableDriver pd) {
        if (pd == null) {
            return false;
        }
        return pd.inside(this.mDeviceBB);
    }

    private boolean checkDRC(List<PlaceableDriver> driversPlaced) {
        return this.checkSpacing(driversPlaced) && this.checkOutOfBound(driversPlaced);
    }

    private boolean checkSpacing(List<PlaceableDriver> driversPlaced) {
        return driversPlaced != null && !driversPlaced.isEmpty();
    }

    private boolean checkOutOfBound(List<PlaceableDriver> driversPlaced) {
        long numOut = driversPlaced.parallelStream().map(PlaceableDriver::getFlattenOrder).flatMap(Collection::stream).filter(pd -> !this.isValidPos((PlaceableDriver)pd)).count();
        if (!this.isSilent() && numOut > 0L) {
            ALog.logWarn((String)"%d drivers are out of bound", (Object[])new Object[]{numOut});
            return false;
        }
        return true;
    }

    public static enum Strategy {
        FULL,
        CBF;

    }

    public static enum UncrossPattern {
        ONE_SIDE,
        ONE_ROW,
        ONE_ROW_ONE_DOMAIN,
        ONE_BALLROW,
        ONE_BALLROW_ONE_DOMAIN;


        public boolean isOneSide() {
            return this == ONE_SIDE;
        }

        public boolean isOneRow() {
            return this == ONE_ROW;
        }

        public boolean isOneRowOneDomain() {
            return this == ONE_ROW_ONE_DOMAIN;
        }

        public boolean isOneBallRow() {
            return this == ONE_BALLROW;
        }

        public boolean isOneBallRowOneDomain() {
            return this == ONE_BALLROW_ONE_DOMAIN;
        }
    }

    public static enum PlacePattern {
        SQUARE,
        REMAIN;


        public boolean isSquare() {
            return this == SQUARE;
        }

        public boolean isRemain() {
            return this == REMAIN;
        }
    }

    public static interface PGCellPlacer {
        public Personality collect(HierInst<Device> var1);

        public Map<AGeomUtil.CompassDir, Integer> proportion(List<PlaceableDriver> var1, Personality var2, int var3);

        public void place(List<PlaceableDriver> var1, Personality var2, List<HierInst<Device>> var3, AGeomUtil.CompassDir var4);
    }
}

