/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.ATransform;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitRunTimeRules;
import com.sigrity.orbit.automation.iocellplacement.IOCellEntry;
import com.sigrity.orbit.factory.PartFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.io.input.BOMInputStream;

public class IOCellSerializer {
    public static final long CATEGORY_PAD = 0L;
    public static final long CATEGORY_CORNER_CELL = 1L;
    public static final long CATEGORY_PG_CELL = 2L;
    static final String CELLINSTANCENAME = "CellInstanceName";
    static final String NETNAME = "NetName";
    static final String SIDE = "Side";
    static final String WIDTH = "Width";
    static final String HEIGHT = "Height";
    static final String TEMPLATENAME = "TemplateName";
    static final String PINNAME = "PinName";
    static final String COREDOMAIN = "CoreDomain";
    static final String IODOMAIN = "IODomain";
    static final String FIXEDORDER = "FixedOrder";
    static final String PGCELLCOUNT = "PGCellCount";
    static final String DEVICETYPE = "DeviceType";
    static final String PARENTNET = "ParentNet";
    DevicePath rootDevicePath;
    Unit.Distance unit = OrbitIO.getCurDesign().getUnit();

    public Optional<APair<Map<String, List<Device>>, Map<Device, String>>> importCSV(String diePathString, String filePath, final List<Long> ignore, final OVERWRITE overwrite, final boolean toOverwriteExistingTemplates, Set<Personality> coreDomains, Set<Personality> ioDomains) {
        Db db = OrbitIO.getCurDb();
        this.rootDevicePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (this.rootDevicePath == null) {
            ALog.logError((String)(diePathString + " does not exist"));
            return Optional.empty();
        }
        File file = new File(filePath);
        BOMInputStream fis = null;
        try {
            fis = new BOMInputStream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to read '%s'.", (Object[])new Object[]{filePath});
            return Optional.empty();
        }
        class CSVtoDevices {
            static final String FLDNAME_IMPORTID = "CSVtoDevices.ImportID";
            private Map<String, List<Device>> mDevicesBySide = new HashMap<String, List<Device>>();
            private Map<Device, String> mFixedOrderDevices = new HashMap<Device, String>();
            private Set<Personality> mCoreDomains = new HashSet<Personality>();
            private Set<Personality> mIODomains = new HashSet<Personality>();
            UUID mImportID;
            private CSVDocument mDocument;
            1CSVtoDevices.CSVFileRuleChecker mChecker = new 1CSVtoDevices.CSVFileRuleChecker();
            int mRow;
            private int goodRows;
            String mInstanceName;
            String mNetName;
            String mSideName;
            String mWidthName;
            String mHeightName;
            String templateName;
            String mPinName;
            String mCoreDomainName;
            String mIODomainName;
            String mFixedOrderName;
            String mPGCellCountName;
            String mDeviceTypeName;
            String mParentNetName;
            private final String DEFAULT_PIN_NAME = "PAD";
            private final String CORNER_CELL_TYPE_NAME = "ENDCAP";
            private final String DEFAULT_SIDE_NAME = "Any";
            private List<String> mErrorMsg = new LinkedList<String>();
            1CSVtoDevices.TemplateDefinitionManager defManager = new 1CSVtoDevices.TemplateDefinitionManager();

            Map<String, List<Device>> getDevicesBySide() {
                return this.mDevicesBySide;
            }

            Map<Device, String> getFixedOrderDevices() {
                return this.mFixedOrderDevices;
            }

            Set<Personality> getCoreDomains() {
                return this.mCoreDomains;
            }

            Set<Personality> getIODomains() {
                return this.mIODomains;
            }

            CSVtoDevices(BOMInputStream fis) {
                this.mImportID = UUID.randomUUID();
                try {
                    CSVDOMParser parser2 = new CSVDOMParser(true, null);
                    this.mDocument = parser2.parse((InputStream)fis);
                }
                catch (CSVDOMParser.CSVDOMException e) {
                    ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
                }
            }

            private boolean isIgnored() {
                return this.mDeviceTypeName.equalsIgnoreCase("PAD") && ignore.contains(0L) || this.mDeviceTypeName.equalsIgnoreCase("ENDCAP") && ignore.contains(1L) || !this.mPGCellCountName.isEmpty() && ignore.contains(2L);
            }

            List<Device> process() {
                this.createAllTemplates();
                LinkedList<Device> devices = new LinkedList<Device>();
                for (int i = 0; i < this.mDocument.getItemCount(); ++i) {
                    this.mRow = i;
                    this.getRow(i);
                    if (this.isIgnored()) continue;
                    try {
                        this.mChecker.updateDevice(this.mInstanceName);
                        List<Device> ds = this.addIOPad();
                        this.mChecker.updatePin(this.mPinName);
                        if (ds.isEmpty()) continue;
                        ++this.goodRows;
                        devices.addAll(ds);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ALog.logInfo((String)("There were " + this.goodRows + " device(s) read"));
                return devices;
            }

            private String getColumnData(int row, String colName) {
                try {
                    return this.mDocument.getItemValue(row, colName);
                }
                catch (Exception e) {
                    ALog.logError((String)e.getMessage());
                    return "";
                }
            }

            private void getRow(int i) {
                this.mInstanceName = this.getColumnData(i, IOCellSerializer.CELLINSTANCENAME);
                this.mNetName = this.getColumnData(i, IOCellSerializer.NETNAME);
                this.mSideName = this.getColumnData(i, IOCellSerializer.SIDE);
                this.mWidthName = this.getColumnData(i, IOCellSerializer.WIDTH);
                this.mHeightName = this.getColumnData(i, IOCellSerializer.HEIGHT);
                this.templateName = this.getColumnData(i, IOCellSerializer.TEMPLATENAME);
                this.mPinName = this.getColumnData(i, IOCellSerializer.PINNAME);
                this.mCoreDomainName = this.getColumnData(i, IOCellSerializer.COREDOMAIN);
                this.mIODomainName = this.getColumnData(i, IOCellSerializer.IODOMAIN);
                this.mFixedOrderName = this.getColumnData(i, IOCellSerializer.FIXEDORDER);
                this.mPGCellCountName = this.getColumnData(i, IOCellSerializer.PGCELLCOUNT);
                this.mDeviceTypeName = this.getColumnData(i, IOCellSerializer.DEVICETYPE);
                this.mParentNetName = this.getColumnData(i, IOCellSerializer.PARENTNET);
                this.templateName = this.templateName.replace(" ", "");
                this.mInstanceName = this.mInstanceName.replace(" ", "");
                this.mPinName = this.mPinName.replace(" ", "");
                this.mNetName = this.mNetName.replace(" ", "");
                this.mParentNetName = this.mParentNetName.replace(" ", "");
                if (this.mSideName.isEmpty()) {
                    this.mSideName = "Any";
                }
            }

            private void addNet(Device instance, PinTemplate pin) {
                Net parentNet;
                DeviceTemplate parentT;
                DeviceTemplate devT;
                Net devNet;
                PinInstance port = instance.getPin(pin);
                if (port == null) {
                    this.log(ALog.LVL_ERR, "Could not find pin instance of %s", pin);
                    throw new IllegalArgumentException();
                }
                Net pinNet = port.getNet();
                if (pinNet == null || pinNet.isUnused()) {
                    pinNet = Net.create((DeviceTemplate)instance.getTemplate(), (String)pin.getName());
                    if (pinNet == null) {
                        pinNet = instance.getTemplate().getNet(pin.getName());
                    }
                    port.setNet(pinNet);
                }
                if ((devNet = (devT = IOCellSerializer.this.rootDevicePath.getDevice().getTemplate()).getNet(this.mNetName)) == null || devNet.isUnused()) {
                    devNet = Net.create((DeviceTemplate)devT, (String)this.mNetName);
                }
                NetMap.mapChildNet((Device)instance, (Net)pinNet, (Net)devNet);
                DevicePath parentDevicePath = IOCellSerializer.this.rootDevicePath.getParent();
                DeviceTemplate deviceTemplate = parentT = parentDevicePath != null ? parentDevicePath.getDevice().getTemplate() : null;
                if (parentT != null && !this.mParentNetName.isEmpty() && (parentNet = parentT.getNet(this.mParentNetName)) != null) {
                    NetMap.mapChildNet((Device)IOCellSerializer.this.rootDevicePath.getDevice(), (Net)devNet, (Net)parentNet);
                }
            }

            private List<Device> getListBySide(String side) {
                return this.mDevicesBySide.computeIfAbsent(side, k -> new LinkedList());
            }

            private List<Device> addIOPad() {
                DeviceTemplate dt = this.getDeviceTemplate();
                if (dt == null) {
                    this.log(ALog.LVL_ERR, "Failed to add device template:'%s' width:%s height:%s", this.templateName, this.mWidthName, this.mHeightName);
                    return Collections.emptyList();
                }
                List<Device> list = this.addDevices(dt, overwrite);
                list.stream().forEach(device -> {
                    PinTemplate pin = null;
                    if (!this.mPinName.isEmpty()) {
                        pin = this.addDevicePin((Device)device);
                    }
                    if (!this.mNetName.isEmpty()) {
                        if (pin == null) {
                            pin = dt.getPinByName("PAD");
                            if (pin == null) {
                                pin = dt.getPin1();
                            }
                            if (pin == null) {
                                this.log(ALog.LVL_ERR, "No pin in template %s to connect to net %s", dt.getName(), this.mNetName);
                                throw new IllegalArgumentException();
                            }
                        }
                        this.addNet((Device)device, pin);
                    }
                    Optional<Object> coreDomainPsn = Optional.empty();
                    if (!this.mCoreDomainName.isEmpty()) {
                        coreDomainPsn = this.getOrCreatePsn(this.mCoreDomainName, Personality.Type.DEVICE, "PowerDomain", "core");
                    }
                    if (coreDomainPsn.isPresent()) {
                        device.assignToPersonality((Personality)coreDomainPsn.get(), false);
                        this.mCoreDomains.add((Personality)coreDomainPsn.get());
                    }
                    Optional<Object> ioDomainPsn = Optional.empty();
                    if (!this.mIODomainName.isEmpty()) {
                        ioDomainPsn = this.getOrCreatePsn(this.mIODomainName, Personality.Type.DEVICE, "PowerDomain", "io");
                    }
                    if (ioDomainPsn.isPresent()) {
                        device.assignToPersonality((Personality)ioDomainPsn.get(), false);
                        this.mIODomains.add((Personality)ioDomainPsn.get());
                    }
                    this.getListBySide(this.mSideName).add((Device)device);
                    if (!this.mFixedOrderName.isEmpty()) {
                        this.mFixedOrderDevices.put((Device)device, this.mFixedOrderName);
                    }
                });
                return list;
            }

            private boolean isCreatedByThisImport(DbObject p) {
                Object v = p.getValue(FLDNAME_IMPORTID);
                if (v != null) {
                    UUID id = (UUID)v;
                    return id.equals(this.mImportID);
                }
                return false;
            }

            private Optional<Personality> getOrCreatePsn(String psn, Personality.Type pType, String softField, String value) {
                Optional p = Personality.getPersonality((DeviceTemplate)IOCellSerializer.this.rootDevicePath.getDeviceTemplate(), (Personality.Type)pType, (String)psn);
                if (p.isPresent()) {
                    if (this.isCreatedByThisImport((DbObject)p.get())) {
                        return p;
                    }
                    ((Personality)p.get()).deleteFromDb();
                }
                if ((p = Personality.create((DeviceTemplate)IOCellSerializer.this.rootDevicePath.getDeviceTemplate(), (Personality.Type)pType, (String)psn)).isPresent()) {
                    ((Personality)p.get()).setValue(FLDNAME_IMPORTID, (Object)this.mImportID);
                    ((Personality)p.get()).setValue(softField, (Object)value);
                    Color c = AUtil.colorFromString((String)Personality.nextColor());
                    ((Personality)p.get()).setColor(c);
                }
                return p;
            }

            private String getErrorMsg() {
                if (!this.mErrorMsg.isEmpty()) {
                    return this.mErrorMsg.stream().collect(Collectors.joining("\n"));
                }
                return "";
            }

            private void createAllTemplates() {
                String instance = "";
                for (int i = 0; i < this.mDocument.getItemCount(); ++i) {
                    this.mRow = i;
                    this.getRow(i);
                    if (!instance.equals(this.mInstanceName) || this.defManager.getTemplateDef() == null) {
                        String actualTemplateName = this.defManager.handleInstanceNameChange(instance, this.templateName, this.mWidthName, this.mHeightName);
                        instance = this.mInstanceName;
                        if (!actualTemplateName.equals(this.templateName)) {
                            this.log(ALog.LVL_WARN, "Template '%s' is specified with different dimension. A new one '%s' would be created!", this.templateName, actualTemplateName);
                        }
                    }
                    if (this.defManager.addPin(this.mPinName)) continue;
                    this.log(ALog.LVL_WARN, "New pin '%s' defined for template '%s' which has completed at row: %d, of instance '%s'", this.mPinName, this.templateName, this.defManager.getDefCompleteAt(), this.defManager.getDefCompleteInstance());
                }
                this.defManager.createTemplates();
            }

            private List<Device> addDevices(DeviceTemplate template, OVERWRITE overwrite2) {
                LinkedList<Device> list = new LinkedList<Device>();
                Db db = IOCellSerializer.this.rootDevicePath.getDb();
                Device die = IOCellSerializer.this.rootDevicePath.getDevice();
                DeviceTemplate parentTemplate = die.getTemplate();
                if (this.mPGCellCountName.isEmpty()) {
                    Device instance = this.addDevice(db, template, parentTemplate, this.mInstanceName, overwrite2);
                    if (!list.contains(instance)) {
                        list.add(instance);
                    }
                } else {
                    String instanceNameBase = this.mInstanceName.isEmpty() ? String.format("%s/%s/", this.mCoreDomainName.isEmpty() ? this.mIODomainName : this.mCoreDomainName, this.mNetName) : this.mInstanceName;
                    long suffix = Long.valueOf(this.mPGCellCountName) - 1L;
                    do {
                        String pgInstanceName;
                        Device instance;
                        if (list.contains(instance = this.addDevice(db, template, parentTemplate, pgInstanceName = String.format("%s_%d", instanceNameBase, suffix--), overwrite2))) continue;
                        list.add(instance);
                    } while (suffix >= 0L);
                }
                return list;
            }

            private Device addDevice(Db db, DeviceTemplate template, DeviceTemplate parentTemplate, String instanceName, OVERWRITE overwrite2) {
                String desiredName;
                Device existing = Device.getChildDevice((DeviceTemplate)parentTemplate, (String)instanceName);
                if (existing != null) {
                    if (!this.isCreatedByThisImport((DbObject)existing)) {
                        if (overwrite2 == OVERWRITE.EXISTING_INSTANCES || overwrite2 == OVERWRITE.EXISTING_INSTANCES_REUSE_TRANSFORM) {
                            existing.deleteFromDb();
                        }
                    } else {
                        return existing;
                    }
                }
                if (!(desiredName = Device.getUniqueName((DeviceTemplate)parentTemplate, (String)instanceName)).equals(instanceName)) {
                    this.log(ALog.LVL_WARN, "DUPLICATE DEVICE NAME '%s'. Create new instance under: '%s'", instanceName, desiredName);
                }
                Device instance = new Device(desiredName, parentTemplate, template);
                if (overwrite2 == OVERWRITE.EXISTING_INSTANCES_REUSE_TRANSFORM) {
                    ATransform lastTransform = this.defManager.getInstanceLastTransform(desiredName);
                    if (lastTransform != null) {
                        instance.setTransform(lastTransform);
                    } else {
                        this.log(ALog.LVL_WARN, "Failed to get last transform! template:%s, instance:%s", template.getName(), desiredName);
                    }
                }
                db.add((DbObject)instance);
                instance.setValue(FLDNAME_IMPORTID, (Object)this.mImportID);
                return instance;
            }

            private DeviceTemplate getDeviceTemplate() {
                long width = IOCellSerializer.this.unit.fromUserString(this.mWidthName);
                long height = IOCellSerializer.this.unit.fromUserString(this.mHeightName);
                return this.defManager.getTemplate(this.templateName, width, height);
            }

            private DeviceTemplate addDeviceTemplate(int i) {
                long width = IOCellSerializer.this.unit.fromUserString(this.mWidthName);
                long height = IOCellSerializer.this.unit.fromUserString(this.mHeightName);
                DeviceTemplate.Type dType = this.mDeviceTypeName.equalsIgnoreCase("ENDCAP") ? DeviceTemplate.Type.ENDCAP : DeviceTemplate.Type.PAD;
                DeviceTemplate t = this.templateName.isEmpty() ? PartFactory.makeIOPadTemplate(IOCellSerializer.this.rootDevicePath.getDevice(), width, height, "PAD", false, null, true, null, dType) : this.getOrCreateTemplateWithDimension(dType, width, height);
                t.setValue(FLDNAME_IMPORTID, (Object)this.mImportID);
                return t;
            }

            private void log(ALog.ALogLevel lvl, String format, Object ... args) {
                String row = String.format("Row %d", this.mRow);
                ALog.log((ALog.ALogLevel)lvl, (String)row);
                ALog.log((ALog.ALogLevel)lvl, (String)format, (Object[])args);
                String msg = ALog.formatString((String)format, (Object[])args);
                msg = msg.replaceAll("%", "%%");
                this.mErrorMsg.add(row);
                this.mErrorMsg.add(msg);
            }

            private DeviceTemplate getOrCreateTemplateWithDimension(DeviceTemplate.Type dType, long width, long height) {
                String desiredTemplateName = this.templateName;
                DeviceTemplate t = DeviceTemplate.getDeviceTemplate((Substrate)IOCellSerializer.this.rootDevicePath.getSubstrate(), (String)this.templateName);
                if (t != null) {
                    if (toOverwriteExistingTemplates && !this.isCreatedByThisImport((DbObject)t)) {
                        t.deleteAllTemplateInsts();
                        t.deleteFromDb();
                    } else {
                        ARect bb = t.getBB();
                        if (bb.width() == width && bb.height() == height) {
                            return t;
                        }
                        desiredTemplateName = String.format("%s_%dx%d", this.templateName, width, height);
                    }
                }
                return PartFactory.makeIOPadTemplate(IOCellSerializer.this.rootDevicePath.getDevice(), width, height, "PAD", false, null, true, desiredTemplateName, dType);
            }

            private PinTemplate addDevicePin(Device d) {
                PinTemplate dtp = d.getTemplate().getPinByName(this.mPinName);
                if (dtp == null) {
                    dtp = PartFactory.makeIOPadPinTemplate(d.getTemplate(), this.mPinName, true, null, true);
                }
                dtp.setType(PinTemplate.Type.IOPAD);
                return dtp;
            }

            class 1CSVtoDevices.TemplateDefinitionManager {
                Set<1CSVtoDevices.TemplateDefinition> templateDefs = new HashSet<1CSVtoDevices.TemplateDefinition>();
                private 1CSVtoDevices.TemplateDefinition td = null;

                1CSVtoDevices.TemplateDefinitionManager() {
                }

                1CSVtoDevices.TemplateDefinition getTemplateDef() {
                    return this.td;
                }

                ATransform getInstanceLastTransform(String instanceName) {
                    return this.templateDefs.stream().map(e -> e.getInstanceLastTransform(instanceName)).filter(Objects::nonNull).findFirst().orElse(null);
                }

                void createTemplates() {
                    Substrate sub = IOCellSerializer.this.rootDevicePath.getSubstrate();
                    this.templateDefs.stream().forEach(e -> e.createDeviceTemplate(sub));
                }

                DeviceTemplate getTemplate(String tName, long w, long h) {
                    Optional<DeviceTemplate> t = this.templateDefs.stream().filter(e -> e.sameNameAndDim(tName, w, h)).map(e -> e.devT).findAny();
                    if (!t.isPresent()) {
                        String actualTemplateName = this.getActualName(tName, w, h);
                        t = this.templateDefs.stream().filter(e -> e.sameNameAndDim(actualTemplateName, w, h)).map(e -> e.devT).findAny();
                    }
                    return t.isPresent() ? t.get() : null;
                }

                String handleInstanceNameChange(String lastInstance, String tName, String wName, String hName) {
                    long h;
                    long w;
                    String actualTemplateName;
                    Optional<1CSVtoDevices.TemplateDefinition> def;
                    if (this.td != null) {
                        this.td.setComplete(mRow, lastInstance);
                    }
                    if ((def = this.getDefined(actualTemplateName = this.getActualName(tName, w = IOCellSerializer.this.unit.fromUserString(wName).longValue(), h = IOCellSerializer.this.unit.fromUserString(hName).longValue()), w, h)).isPresent()) {
                        this.td = def.get();
                    } else {
                        this.td = new 1CSVtoDevices.TemplateDefinition(actualTemplateName, mDeviceTypeName, w, h);
                        this.templateDefs.add(this.td);
                    }
                    return actualTemplateName;
                }

                boolean addPin(String pName) {
                    if (pName.isEmpty()) {
                        pName = "PAD";
                    }
                    return this.td.addPin(pName);
                }

                long getDefCompleteAt() {
                    return this.td.getCompleteAtRow();
                }

                String getDefCompleteInstance() {
                    return this.td.getCompleteInstance();
                }

                private Optional<1CSVtoDevices.TemplateDefinition> getDefined(String t, long w, long h) {
                    return this.templateDefs.stream().filter(e -> e.sameNameAndDim(t, w, h)).findAny();
                }

                private String getActualName(String tName, long w, long h) {
                    Optional<1CSVtoDevices.TemplateDefinition> def = this.templateDefs.stream().filter(e -> e.template.equals(tName)).findAny();
                    if (def.isPresent() && !def.get().sameNameAndDim(tName, w, h)) {
                        return String.format("%s_%dx%d", tName, w, h);
                    }
                    return tName;
                }
            }

            class 1CSVtoDevices.TemplateDefinition {
                String template;
                DeviceTemplate.Type dType;
                long width;
                long height;
                private long completeAtRow;
                String completeInstance;
                Set<String> pins;
                Map<String, ATransform> instanceLastTransform;
                DeviceTemplate devT;

                1CSVtoDevices.TemplateDefinition(String name, String type, long width, long height) {
                    this.template = name;
                    this.dType = type.equalsIgnoreCase("ENDCAP") ? DeviceTemplate.Type.ENDCAP : DeviceTemplate.Type.PAD;
                    this.pins = new HashSet<String>();
                    this.width = width;
                    this.height = height;
                    this.completeAtRow = -1L;
                }

                ATransform getInstanceLastTransform(String instanceName) {
                    return this.instanceLastTransform.get(instanceName);
                }

                private void removeExistingTemplate(DeviceTemplate t) {
                    t.deleteAllTemplateInsts();
                    t.deleteFromDb();
                }

                private void saveInstanceTransform(DeviceTemplate t) {
                    this.instanceLastTransform = t.getDeviceInstances().stream().collect(Collectors.toMap(Device::getName, Device::getTransform));
                }

                DeviceTemplate createDeviceTemplate(Substrate sub) {
                    String dbName;
                    DeviceTemplate t = DeviceTemplate.getDeviceTemplate((Substrate)sub, (String)this.template);
                    if (t != null) {
                        if (this.isCreatedByThisImport((DbObject)t)) {
                            ALog.logError((String)"Template '%s' has more than one defintion!", (Object[])new Object[]{this.template});
                            throw new IllegalArgumentException();
                        }
                        this.saveInstanceTransform(t);
                        if (toOverwriteExistingTemplates) {
                            this.removeExistingTemplate(t);
                            dbName = this.template;
                        } else {
                            dbName = DeviceTemplate.getUniqueName((Substrate)sub, (String)this.template);
                        }
                    } else {
                        dbName = this.template;
                    }
                    LinkedList<String> pinNames = new LinkedList<String>();
                    pinNames.addAll(this.pins);
                    this.devT = PartFactory.makeIOPadTemplate(IOCellSerializer.this.rootDevicePath.getDevice(), this.width, this.height, pinNames, false, pinNames, true, dbName, this.dType);
                    return this.devT;
                }

                boolean sameNameAndDim(String name, long w, long h) {
                    return this.template.equals(name) && this.width == w && this.height == h;
                }

                void setComplete(long row, String instance) {
                    this.completeAtRow = row;
                    this.completeInstance = instance;
                }

                private boolean isComplete() {
                    return this.completeAtRow >= 0L;
                }

                long getCompleteAtRow() {
                    return this.completeAtRow;
                }

                String getCompleteInstance() {
                    return this.completeInstance;
                }

                boolean addPin(String pin) {
                    if (!this.pins.contains(pin)) {
                        if (!this.isComplete()) {
                            this.pins.add(pin);
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            }

            class 1CSVtoDevices.CSVFileRuleChecker {
                String mCurrentDeviceName = "";
                Set<String> mCurrentDevicePins = new HashSet<String>();
                Set<String> mProcessedDeviceNames = new HashSet<String>();

                1CSVtoDevices.CSVFileRuleChecker() {
                }

                public void updateDevice(String deviceName) {
                    if (!this.isCurrentDevice(deviceName)) {
                        this.changeCurrentDevice(deviceName);
                    }
                }

                public void updatePin(String pinName) {
                    if (!pinName.isEmpty()) {
                        this.recordNewPin(pinName);
                    }
                }

                private boolean hadProcessed(String deviceName) {
                    return this.mProcessedDeviceNames.contains(deviceName);
                }

                private boolean isCurrentDevice(String deviceName) {
                    return this.mCurrentDeviceName.equals(deviceName);
                }

                private void changeCurrentDevice(String deviceName) {
                    this.mCurrentDeviceName = deviceName;
                    this.mCurrentDevicePins.clear();
                    if (this.hadProcessed(deviceName)) {
                        this.log(ALog.LVL_ERR, "Device '%s' appeared before, discontinously.", deviceName);
                        throw new IllegalArgumentException();
                    }
                }

                private boolean isNewPin(String pName) {
                    return !this.mCurrentDevicePins.contains(pName);
                }

                private void recordNewPin(String pName) {
                    if (!this.isNewPin(pName)) {
                        this.log(ALog.LVL_ERR, "Pin '%s' appeared more than once.", pName);
                        throw new IllegalArgumentException();
                    }
                    this.mCurrentDevicePins.add(pName);
                }
            }
        }
        CSVtoDevices builder = new CSVtoDevices(fis);
        builder.process();
        Map<String, List<Device>> devicesBySide = builder.getDevicesBySide();
        Map<Device, String> fixedOrderDevices = builder.getFixedOrderDevices();
        String errMsg = builder.getErrorMsg();
        this.rootDevicePath.getDeviceTemplate().setSourceFile(filePath);
        this.rootDevicePath.getDeviceTemplate().setSourceFileModifiedTime(file.lastModified());
        OrbitRunTimeRules ortr = new OrbitRunTimeRules();
        ortr.updateAllDevices(db);
        OrbitIO.getApp().refreshCurrentView(false);
        if (!errMsg.isEmpty()) {
            try {
                Window activeWindow = FocusManager.getCurrentManager().getActiveWindow();
                JTextArea textArea = new JTextArea(errMsg);
                JScrollPane scrollPane = new JScrollPane(textArea);
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                scrollPane.setPreferredSize(new Dimension(500, 500));
                JOptionPane pane = new JOptionPane(scrollPane, 2);
                JDialog dialog = pane.createDialog(activeWindow, "Warning");
                dialog.setModal(false);
                dialog.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (coreDomains != null) {
            coreDomains.addAll(builder.getCoreDomains());
        }
        if (ioDomains != null) {
            ioDomains.addAll(builder.getIODomains());
        }
        return Optional.of(new APair(devicesBySide, fixedOrderDevices));
    }

    public void exportCsv(final IOCellEntry cellEntry, String filePath) {
        class DevicesToCSV
        implements AutoCloseable {
            IOCellEntry mCellEntry;
            ACsvWriter mWriter;

            public DevicesToCSV(IOCellEntry cellEntry2, String filePath) {
                this.mCellEntry = cellEntry2;
                this.mWriter = ACsvWriter.open((String)filePath);
            }

            public void process() {
                if (this.mWriter == null) {
                    throw new IllegalArgumentException("Write is null.");
                }
                this.writeHeader();
                this.writeRows();
            }

            private void writeHeader() {
                this.mWriter.header(new String[]{IOCellSerializer.WIDTH, IOCellSerializer.HEIGHT, IOCellSerializer.NETNAME, IOCellSerializer.PINNAME, IOCellSerializer.TEMPLATENAME, IOCellSerializer.DEVICETYPE, IOCellSerializer.CELLINSTANCENAME, IOCellSerializer.COREDOMAIN, IOCellSerializer.IODOMAIN, IOCellSerializer.PARENTNET, IOCellSerializer.SIDE, IOCellSerializer.FIXEDORDER, IOCellSerializer.PGCELLCOUNT});
            }

            private void writeRows() {
                for (IOCellEntry.CellType type : this.mCellEntry.mDevices.keySet()) {
                    for (HierInst<Device> hInst : this.mCellEntry.mDevices.get((Object)type)) {
                        Device device = (Device)hInst.getDbObject();
                        DeviceTemplate devT = device.getTemplate();
                        IterableIterator pins = devT.getPins();
                        if (!pins.hasNext()) {
                            this.writeRow(type, hInst, null);
                            continue;
                        }
                        for (PinTemplate pinT : pins) {
                            this.writeRow(type, hInst, pinT);
                        }
                    }
                }
            }

            private void writeRow(IOCellEntry.CellType type, HierInst<Device> hInst, PinTemplate pinT) {
                this.writeBound(((Device)hInst.getDbObject()).getTemplate());
                this.writePin(pinT);
                this.writeDevice(hInst);
                this.mWriter.colObj((Object)type);
                this.mWriter.endRow();
            }

            private void writeBound(DeviceTemplate devT) {
                ARect bound = devT.getBounds().getBounds();
                String widthStr = IOCellSerializer.this.unit.toUserStr(bound.width());
                String heightStr = IOCellSerializer.this.unit.toUserStr(bound.height());
                this.mWriter.colsData(new String[]{widthStr, heightStr});
            }

            private void writePin(PinTemplate pinT) {
                String netName = "";
                String pinName = "";
                if (pinT != null) {
                    Net net = pinT.getNet();
                    if (net != null && !net.isUnused()) {
                        netName = net.getName();
                    }
                    pinName = pinT.getName();
                }
                this.mWriter.colsData(new String[]{netName, pinName});
            }

            private void writeDevice(HierInst<Device> hInst) {
                Device device = (Device)hInst.getDbObject();
                DeviceTemplate devT = device.getTemplate();
                String templateName = devT.getName();
                String deviceType = device.getType().toString().toUpperCase();
                String instanceName = device.getName();
                Personality ioDomain = cellEntry.getIODomain(hInst);
                Personality coreDomain = cellEntry.getCoreDomain(hInst);
                String ioDomainName = ioDomain == null ? "" : ioDomain.getName();
                String coreDomainName = coreDomain == null ? "" : coreDomain.getName();
                Net parentNet = device.getNet();
                String parentNetName = parentNet == null || parentNet.isUnused() ? "" : parentNet.getName();
                this.mWriter.colsData(new String[]{templateName, deviceType, instanceName, ioDomainName, coreDomainName, parentNetName});
            }

            @Override
            public void close() throws Exception {
                this.mWriter.close();
            }
        }
        try (DevicesToCSV builder = new DevicesToCSV(cellEntry, filePath);){
            builder.process();
        }
        catch (Exception e) {
            ALog.logInfo((String)"Error in exporting to %s", (Object[])new Object[]{filePath});
            return;
        }
        ALog.logInfo((String)"Finish exporting to %s", (Object[])new Object[]{filePath});
    }

    public static void testImportCSVGeneral(String diePathString, String filePath) {
        IOCellSerializer iovs = new IOCellSerializer();
        HashSet<Personality> coreDomains = new HashSet<Personality>();
        HashSet<Personality> ioDomains = new HashSet<Personality>();
        Optional<APair<Map<String, List<Device>>, Map<Device, String>>> r = iovs.importCSV(diePathString, filePath, Collections.emptyList(), OVERWRITE.EXISTING_INSTANCES_REUSE_TRANSFORM, true, coreDomains, ioDomains);
        if (r.isPresent()) {
            Map devicesBySide = (Map)r.get().first;
            Map fixedOrderDevices = (Map)r.get().second;
            devicesBySide.entrySet().stream().forEach(e -> {
                ALog.logInfo((String)"Side %s - %d", (Object[])new Object[]{e.getKey(), ((List)e.getValue()).size()});
                ((List)e.getValue()).stream().forEach(d -> {
                    String fixedOrder = (String)fixedOrderDevices.get(d);
                    if (fixedOrder == null) {
                        fixedOrder = "";
                    }
                    ALog.logInfo((String)" %s %s", (Object[])new Object[]{d.getName(), fixedOrder});
                });
            });
            ALog.logInfo((String)"Core Domains:");
            coreDomains.stream().forEach(p -> ALog.logInfo((String)" %s", (Object[])new Object[]{p}));
            ALog.logInfo((String)"IO Domains:");
            ioDomains.stream().forEach(p -> ALog.logInfo((String)" %s", (Object[])new Object[]{p}));
        } else {
            ALog.logError((String)"FAILED TO importCSV_General");
        }
    }

    public static enum OVERWRITE {
        NONE,
        EXISTING_INSTANCES,
        EXISTING_INSTANCES_REUSE_TRANSFORM;

    }
}

