/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.google.common.collect.Lists;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.iocellplacement.IOCellEntry;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

class PlaceableDriver {
    String mDriverPathStr = "";
    HierInst<Device> mDriver = null;
    HierPin mBall = null;
    APoint2D mPosToPlace = null;
    AGeomUtil.CompassDir mSide = null;
    DriverType type = DriverType.IO;
    LinkedList<PlaceableDriver> mNextRow = null;
    LinkedList<PlaceableDriver> mNextOrder = null;
    LinkedList<PlaceableDriver> mLastOrder = null;

    public static PlaceableDriver create(HierInst<Device> driver) {
        DevicePath path;
        PlaceableDriver pd = new PlaceableDriver(driver, AGeomUtil.getEminatingDir((double)driver.getPath().getRot()));
        Device device = (Device)driver.getDbObject();
        if (device != (path = driver.getPath()).getLast()) {
            path.add(device);
        }
        pd.setPosToPlace(path.getBB().center());
        return pd;
    }

    public static List<PlaceableDriver> getFlattenRowPd(List<PlaceableDriver> pds) {
        return pds.stream().map(PlaceableDriver::getFlattenRow).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<PlaceableDriver> getFlatten(PlaceableDriver root) {
        if (root.isDummy()) {
            return Collections.emptyList();
        }
        LinkedList<PlaceableDriver> toFlatten = new LinkedList<PlaceableDriver>();
        toFlatten.addAll(root.getLastOrder());
        toFlatten.add(root);
        toFlatten.addAll(root.getNextRow());
        toFlatten.addAll(root.getNextOrder());
        LinkedList<PlaceableDriver> flatten = new LinkedList<PlaceableDriver>();
        for (PlaceableDriver pd : toFlatten) {
            if (pd == root) {
                flatten.add(pd);
                continue;
            }
            flatten.addAll(PlaceableDriver.getFlatten(pd));
        }
        return flatten;
    }

    public PlaceableDriver(HierInst<Device> driver, APoint2D posToPlace) {
        this(driver, posToPlace, null);
    }

    public PlaceableDriver(HierInst<Device> driver, AGeomUtil.CompassDir side) {
        this(driver, null, side);
    }

    public PlaceableDriver(HierInst<Device> driver, APoint2D posToPlace, AGeomUtil.CompassDir side) {
        this.mDriver = driver;
        this.mPosToPlace = posToPlace;
        this.mSide = side;
        if (this.mDriver != null) {
            this.mDriverPathStr = driver.getPath().escapedString();
        }
    }

    public void regainDevicesFromDb() {
        for (PlaceableDriver pd : this.getFlatten()) {
            pd.mDriver = IOCellEntry.regainDeviceFromDb(pd.mDriverPathStr);
        }
    }

    public boolean clearNextRow() {
        boolean hasClear = false;
        if (this.hasNextRow()) {
            this.mNextRow.clear();
            hasClear = true;
        }
        return hasClear;
    }

    public boolean clearOrder() {
        boolean hasClear = false;
        if (this.hasLastOrder()) {
            this.mLastOrder.clear();
            hasClear = true;
        }
        if (this.hasNextOrder()) {
            this.mNextOrder.clear();
            hasClear = true;
        }
        return hasClear;
    }

    public void addNextRow(PlaceableDriver nextRow) {
        if (nextRow == null) {
            return;
        }
        if (this.mNextRow == null) {
            this.mNextRow = new LinkedList();
        }
        this.mNextRow.add(nextRow);
    }

    public void addNextOrder(PlaceableDriver nextOrder) {
        if (nextOrder == null) {
            return;
        }
        if (this.mNextOrder == null) {
            this.mNextOrder = new LinkedList();
        }
        this.mNextOrder.addLast(nextOrder);
    }

    public void addLastOrder(PlaceableDriver lastOrder) {
        if (lastOrder == null) {
            return;
        }
        if (this.mLastOrder == null) {
            this.mLastOrder = new LinkedList();
        }
        this.mLastOrder.addFirst(lastOrder);
    }

    public void setBall(HierPin ball) {
        this.mBall = ball;
    }

    public void setPosToPlace(APoint2D posToPlace) {
        this.mPosToPlace = posToPlace;
    }

    public void setSide(AGeomUtil.CompassDir side) {
        this.mSide = side;
    }

    public void setIOType() {
        this.type = DriverType.IO;
    }

    public void setCornerType() {
        this.type = DriverType.CORNER;
    }

    public void setPGType() {
        this.type = DriverType.PG;
    }

    public HierPin getBall() {
        return this.mBall;
    }

    public APoint2D getPosToPlace() {
        return this.mPosToPlace;
    }

    public AGeomUtil.CompassDir getSide() {
        return this.mSide;
    }

    public HierInst<Device> getDriver() {
        return this.mDriver;
    }

    public String getDriverPathStr() {
        return this.mDriverPathStr;
    }

    public List<PlaceableDriver> getNextRow() {
        if (this.hasNextRow()) {
            return this.mNextRow;
        }
        return Collections.emptyList();
    }

    public List<PlaceableDriver> getNextOrder() {
        if (this.hasNextOrder()) {
            return this.mNextOrder;
        }
        return Collections.emptyList();
    }

    public List<PlaceableDriver> getLastOrder() {
        if (this.hasLastOrder()) {
            return this.mLastOrder;
        }
        return Collections.emptyList();
    }

    public long getWidth() {
        return this.getBounds().getBounds().width();
    }

    public long getHeight() {
        return this.getBounds().getBounds().height();
    }

    public boolean intersects(ARect other) {
        return this.getWorldBound().intersects(other);
    }

    public boolean inside(ARect other) {
        return other.contains((AGeom)this.getWorldBound());
    }

    public ARect getBounds() {
        return (ARect)((Device)this.getDriver().getDbObject()).getUntransformedShape();
    }

    public ARect getWorldBound() {
        return this.getDriver().getPath().getBB();
    }

    public APoint2D getOrigin() {
        APoint2D origin;
        DevicePath dPath = this.mDriver.getPath();
        Device driver = (Device)this.mDriver.getDbObject();
        APoint2D center = driver.getWorldBound(dPath.getParent()).center();
        APoint2D loc = driver.getWorldLoc(dPath.getParent());
        APoint2D centerOffset = center.sub(loc);
        float rotDelta = Device.rotationDelta((AGeomUtil.CompassDir)AGeomUtil.getEminatingDir((double)dPath.getRot()), (AGeomUtil.CompassDir)this.getSide());
        AffineTransform t = AffineTransform.getRotateInstance((double)(-1.0f * rotDelta) / 180.0 * Math.PI);
        driver.getCenterOffset().transform(dPath.getTransform()).transform(t);
        try {
            origin = this.getPosToPlace().sub(centerOffset);
        }
        catch (NullPointerException e) {
            origin = this.getDriver().getPathWithoutObject().getLoc();
        }
        return origin;
    }

    public PlaceableDriver getHeadOrderPd() {
        if (!this.hasLastOrder()) {
            return this;
        }
        return this.mLastOrder.getLast();
    }

    public PlaceableDriver getTailOrderPd() {
        if (this.hasNextOrder()) {
            return this.mNextOrder.getLast();
        }
        return this;
    }

    public PlaceableDriver getTailRowPd() {
        if (this.hasNextRow()) {
            return this.mNextRow.getLast();
        }
        return this;
    }

    public long getNumOfRow() {
        return (this.isDummy() ? 0L : 1L) + (long)this.getNextRow().size();
    }

    public long getNumOfDriver() {
        long lastOrderSum = this.getLastOrder().stream().mapToLong(PlaceableDriver::getNumOfDriver).sum();
        long nextRowSum = this.getNextRow().stream().mapToLong(PlaceableDriver::getNumOfDriver).sum();
        long nextOrderSum = this.getNextOrder().stream().mapToLong(PlaceableDriver::getNumOfDriver).sum();
        return (this.isDummy() ? 0L : 1L) + lastOrderSum + nextRowSum + nextOrderSum;
    }

    public List<PlaceableDriver> getFlatten() {
        if (this.isDummy()) {
            return Collections.emptyList();
        }
        return PlaceableDriver.getFlatten(this);
    }

    public List<PlaceableDriver> getFlattenOrder() {
        if (this.isDummy()) {
            return Collections.emptyList();
        }
        LinkedList<PlaceableDriver> flatten = new LinkedList<PlaceableDriver>();
        flatten.addAll(Lists.reverse(this.getLastOrder()));
        flatten.add(this);
        flatten.addAll(this.getNextOrder());
        return flatten;
    }

    public List<PlaceableDriver> getFlattenRow() {
        if (this.isDummy()) {
            return Collections.emptyList();
        }
        LinkedList<PlaceableDriver> flatten = new LinkedList<PlaceableDriver>();
        flatten.add(this);
        flatten.addAll(this.getNextRow());
        return flatten;
    }

    public boolean isDummy() {
        return this.mDriver == null;
    }

    public boolean isIO() {
        return this.type == DriverType.IO;
    }

    public boolean isCorner() {
        return this.type == DriverType.CORNER;
    }

    public boolean isPG() {
        return this.type == DriverType.PG;
    }

    public boolean hasNextRow() {
        return this.mNextRow != null && !this.mNextRow.isEmpty();
    }

    public boolean hasOrder() {
        return this.hasLastOrder() || this.hasNextOrder();
    }

    public boolean hasNextOrder() {
        return this.mNextOrder != null && !this.mNextOrder.isEmpty();
    }

    public boolean hasLastOrder() {
        return this.mLastOrder != null && !this.mLastOrder.isEmpty();
    }

    public void move(APoint2D offset) {
        if (this.isDummy()) {
            return;
        }
        if (this.getPosToPlace() == null) {
            return;
        }
        this.setPosToPlace(this.getPosToPlace().add(offset));
        this.placeSelf();
        this.getLastOrder().stream().forEach(pd -> pd.move(offset));
        this.getNextRow().stream().forEach(pd -> pd.move(offset));
        this.getNextOrder().stream().forEach(pd -> pd.move(offset));
    }

    public void place() {
        if (this.isDummy()) {
            return;
        }
        this.placeSelf();
        this.getNextRow().stream().forEach(PlaceableDriver::place);
    }

    private void placeSelf() {
        Device driver = (Device)this.mDriver.getDbObject();
        DevicePath dPath = this.mDriver.getPath();
        driver.setPosition(dPath, this.getOrigin(), "", (float)this.getSide().getDirRotation(), dPath.getMirror());
    }

    public int hashCode() {
        return this.mDriver.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlaceableDriver pd = (PlaceableDriver)obj;
        return this.mDriver.equals(pd.mDriver);
    }

    static enum DriverType {
        IO,
        CORNER,
        PG;

    }
}

