/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ARect;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class RuleTable {
    DeviceTemplate mPad = null;
    long mPadOffset = 0L;
    long mPadSpacing = 7500000L;
    long mBallProx = 80000000L;
    EnumMap<AGeomUtil.CompassDir, Long> mRowTable = new EnumMap(AGeomUtil.CompassDir.class);
    Map<Device, RuleChain> mSpacingTable = new HashMap<Device, RuleChain>();
    RuleEntry mDefaultSpacing = RuleEntry.zero();

    public static RuleEntry createEntry(long s2s, long e2e, long s2e, long e2s) {
        return new RuleEntry(s2s, e2e, s2e, e2s);
    }

    public void setPad(DeviceTemplate padT) {
        this.mPad = padT;
        if (this.mPad != null) {
            this.mPad.getBounds().moveCenterTo(0L, 0L);
        }
    }

    public void setPadOffset(Long padOffset) {
        this.mPadOffset = padOffset;
    }

    public void setPadSpacing(Long padSpacing) {
        this.mPadSpacing = padSpacing;
    }

    public void setNumOfRow(AGeomUtil.CompassDir dir, Long numOfRow) {
        this.mRowTable.put(dir, numOfRow > 0L ? numOfRow : 1L);
    }

    public void setBallProx(Long ballProx) {
        this.mBallProx = ballProx;
    }

    public void setSpacing(RuleEntry entry) {
        this.mDefaultSpacing = entry;
    }

    public void setSpacing(Device fromDriver, RuleEntry entry) {
        RuleChain chain;
        if (this.mSpacingTable.containsKey(fromDriver)) {
            chain = this.mSpacingTable.get(fromDriver);
        } else {
            chain = new RuleChain();
            this.mSpacingTable.put(fromDriver, chain);
        }
        chain.mDefaultRule = entry;
    }

    public void setSpacing(Device fromDriver, Device toDriver, RuleEntry entry) {
        RuleChain chain;
        if (this.mSpacingTable.containsKey(fromDriver)) {
            chain = this.mSpacingTable.get(fromDriver);
        } else {
            chain = new RuleChain();
            this.mSpacingTable.put(fromDriver, chain);
        }
        chain.put(toDriver, entry);
    }

    public DeviceTemplate getPad() {
        return this.mPad;
    }

    public long getPadOffset() {
        return this.mPadOffset;
    }

    public long getPadSpacing() {
        return this.mPadSpacing;
    }

    public ARect getPadBB() {
        return this.getPad() != null ? this.getPad().getBB() : ARect.zero();
    }

    public long getNumOfRow(AGeomUtil.CompassDir dir) {
        if (!this.mRowTable.containsKey(dir)) {
            return 1L;
        }
        return this.mRowTable.get(dir);
    }

    public long getBallProx() {
        return this.mBallProx;
    }

    public RuleEntry getSpacing(Device fromDriver, Device toDriver) {
        if (!this.mSpacingTable.containsKey(fromDriver)) {
            return this.mDefaultSpacing;
        }
        RuleChain chain = this.mSpacingTable.get(fromDriver);
        if (!chain.containsKey(toDriver)) {
            return chain.mDefaultRule;
        }
        return (RuleEntry)chain.get(toDriver);
    }

    public boolean hasSpacing(Device fromDriver, Device toDriver) {
        return this.mSpacingTable.containsKey(fromDriver) && this.mSpacingTable.get(fromDriver).containsKey(toDriver);
    }

    public boolean checkRowAvailability(Long num, AGeomUtil.CompassDir side) {
        return num < this.getNumOfRow(side);
    }

    public void merge(RuleTable newTable) {
        this.mPadOffset = Math.max(this.mPadOffset, newTable.mPadOffset);
        this.mPadSpacing = Math.max(this.mPadSpacing, newTable.mPadSpacing);
        this.mBallProx = Math.max(this.mBallProx, newTable.mBallProx);
        this.mDefaultSpacing.merge(newTable.mDefaultSpacing);
        for (Map.Entry<Device, RuleChain> entry : newTable.mSpacingTable.entrySet()) {
            Device device = entry.getKey();
            RuleChain newChain = entry.getValue();
            RuleChain chain = this.mSpacingTable.get(device);
            if (chain == null) {
                this.mSpacingTable.put(device, newChain);
                continue;
            }
            chain.merge(newChain);
        }
    }

    static class RuleChain
    extends HashMap<Device, RuleEntry> {
        RuleEntry mDefaultRule = RuleEntry.zero();

        RuleChain() {
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.mDefaultRule.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.mDefaultRule.hashCode();
        }

        public void merge(RuleChain newChain) {
            this.mDefaultRule.merge(newChain.mDefaultRule);
            for (Map.Entry pair : newChain.entrySet()) {
                Device key = (Device)pair.getKey();
                RuleEntry newEntry = (RuleEntry)pair.getValue();
                RuleEntry entry = (RuleEntry)this.get(key);
                if (entry == null) {
                    this.put(key, newEntry);
                    continue;
                }
                entry.merge(newEntry);
            }
        }
    }

    static class RuleEntry {
        long mS2S = 0L;
        long mE2E = 0L;
        long mS2E = 0L;
        long mE2S = 0L;

        public static RuleEntry zero() {
            return new RuleEntry(0L, 0L, 0L, 0L);
        }

        public RuleEntry(long s2s, long e2e, long s2e, long e2s) {
            this.mS2S = s2s;
            this.mE2E = e2e;
            this.mS2E = s2e;
            this.mE2S = e2s;
        }

        public void merge(RuleEntry newEntry) {
            this.mS2S = Math.max(this.mS2S, newEntry.mS2S);
            this.mE2E = Math.max(this.mE2E, newEntry.mE2E);
            this.mS2E = Math.max(this.mS2E, newEntry.mS2E);
            this.mE2S = Math.max(this.mE2S, newEntry.mE2S);
        }
    }
}

