/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class DriverRespacerUI
extends DbDialog {
    static final String DIALOG_TITLE = "Driver Placement Rule";
    private Unit unit;
    private DevicePath refPath;
    private JCheckBox cbSingleInstanceTable;
    private AFileChooserControl fcSingleInstanceTable;
    private JTextField txtDefSpacing;
    private JTextField txtDomainSpacing;
    private JTextField txtHeightSpacing;
    private JButton btnOK;
    private JButton btnCancel;
    private boolean status = true;
    private ActionListener okListener = ae -> {
        if (!this.validateParam()) {
            return;
        }
        String spacingPath = this.fcSingleInstanceTable.getPath();
        long defaultSpacing = this.unit.fromUserString(this.txtDefSpacing.getText());
        long domainSpacing = this.unit.fromUserString(this.txtDomainSpacing.getText());
        long heightSpacing = this.unit.fromUserString(this.txtHeightSpacing.getText());
        if (defaultSpacing < 0L || domainSpacing < 0L || heightSpacing < 0L) {
            ALog.logError((String)"Spacing should be larger than zero.");
            return;
        }
        Device device = this.refPath.pathToSubstrate().getDevice();
        Cp.exec((String)"_dev = curDb().getByKeyStr(Device.class, \"%s\")", (Object[])new Object[]{device.getKeyStr()});
        String setValue = "_dev.setValue(\"%s\", \"%s\")";
        String unsetValue = "_dev.unsetSoftValue(\"%s\")";
        if (this.cbSingleInstanceTable.isSelected()) {
            Cp.exec((String)setValue, (Object[])new Object[]{"Respacer.SingleInstanceTable", spacingPath});
        } else {
            Cp.exec((String)unsetValue, (Object[])new Object[]{"Respacer.SingleInstanceTable"});
        }
        Cp.exec((String)setValue, (Object[])new Object[]{"Respace.DefaultSpacing", defaultSpacing});
        Cp.exec((String)setValue, (Object[])new Object[]{"Respace.DomainSpacing", domainSpacing});
        Cp.exec((String)setValue, (Object[])new Object[]{"Respace.SizeSpacing", heightSpacing});
        Cp.exec((String)"unset(\"_dev\")", (Object[])new Object[0]);
        UIUtil.closeWindow((Window)((Object)this));
    };
    private ActionListener cancelListener = ae -> {
        this.status = false;
        UIUtil.closeWindow((Window)((Object)this));
    };

    public static boolean showMe(Db db, String pathString) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return false;
        }
        DriverRespacerUI ui = new DriverRespacerUI(db, OrbitIO.getMainWindow(), DevicePath.fromEscapedString((Db)db, (String)pathString));
        ui.setVisible(true);
        return ui.getStatus();
    }

    public DriverRespacerUI(Db db, Window window, DevicePath dPath) {
        super(db, (Component)window, DIALOG_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.unit = OrbitIO.getCurView().getUnit();
        this.refPath = dPath;
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        this.addRules(l);
        this.addParameters(l);
        this.addActions(l);
        this.setSavedParam(dPath);
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.btnCancel, (JButton)this.btnOK);
        this.pack();
        UIUtil.center((Component)((Object)this));
    }

    private void addRules(GridBagManager l) {
        l.pushFillX();
        this.cbSingleInstanceTable = (JCheckBox)l.add((Component)new JCheckBox(), (GridBagConstraints)GridBagManager.LEFT);
        this.cbSingleInstanceTable.addActionListener(ae -> this.fcSingleInstanceTable.setEnabled(this.cbSingleInstanceTable.isSelected()));
        this.fcSingleInstanceTable = this.addFileChooser(l, "Rule CSV:");
        this.fcSingleInstanceTable.setEnabled(false);
        l.popNl();
    }

    private void addParameters(GridBagManager l) {
        l.push("<html><b><i>Parameters", (GridBagConstraints)GridBagManager.FILLX);
        this.txtDefSpacing = this.addTxtField(l, "Default Spacing:");
        l.newline();
        this.txtDomainSpacing = this.addTxtField(l, "Domain Change Spacing:");
        l.newline();
        this.txtHeightSpacing = this.addTxtField(l, "Height Change Spacing:");
        l.popNl();
    }

    private AFileChooserControl addFileChooser(GridBagManager l, String title) {
        l.add(title);
        AFileChooserControl chooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        chooser.setChoosableFileFilter(AFileFilter.CSV);
        return chooser;
    }

    private void addActions(GridBagManager l) {
        l.pushFillXRemainX();
        l.addFillX();
        this.btnOK = (JButton)l.add((Component)new JButton("OK"));
        this.btnOK.addActionListener(this.okListener);
        this.btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        this.btnCancel.addActionListener(this.cancelListener);
        l.pop();
    }

    private JTextField addTxtField(GridBagManager l, String title) {
        l.add(title);
        return (JTextField)l.add((Component)new JTextField("0.00", 5), (GridBagConstraints)GridBagManager.FILLX);
    }

    public boolean getStatus() {
        return this.status;
    }

    private void setSavedParam(DevicePath dPath) {
        String heightSpacingStr;
        String domainSpacingStr;
        String defSpacingStr;
        Device device = dPath.pathToSubstrate().getDevice();
        String singleInstanceTableStr = (String)device.getValue("Respacer.SingleInstanceTable");
        if (singleInstanceTableStr != null) {
            this.cbSingleInstanceTable.setSelected(true);
            this.fcSingleInstanceTable.setEnabled(true);
            this.fcSingleInstanceTable.setPath(singleInstanceTableStr);
        }
        if ((defSpacingStr = (String)device.getValue("Respace.DefaultSpacing")) != null) {
            this.txtDefSpacing.setText(this.unit.toUserStr(Long.valueOf(defSpacingStr).longValue()));
        }
        if ((domainSpacingStr = (String)device.getValue("Respace.DomainSpacing")) != null) {
            this.txtDomainSpacing.setText(this.unit.toUserStr(Long.valueOf(domainSpacingStr).longValue()));
        }
        if ((heightSpacingStr = (String)device.getValue("Respace.SizeSpacing")) != null) {
            this.txtHeightSpacing.setText(this.unit.toUserStr(Long.valueOf(heightSpacingStr).longValue()));
        }
    }

    private boolean validateParam() {
        boolean ret = true;
        try {
            if (this.cbSingleInstanceTable.isSelected()) {
                AFieldValidator.validateFileExists((JTextField)this.fcSingleInstanceTable.getTextField());
            }
            AFieldValidator.validateFloat((JTextField)this.txtDefSpacing);
            AFieldValidator.validateFloat((JTextField)this.txtDomainSpacing);
            AFieldValidator.validateFloat((JTextField)this.txtHeightSpacing);
        }
        catch (AFieldValidator.AFieldValidationException | NumberFormatException e) {
            ret = false;
        }
        return ret;
    }
}

