/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.iocellplacement.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.iocellplacement.IOCellEntry;
import com.sigrity.orbit.ui.wb_route.PinDeviceComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class IOCellPlacerUI
extends DbDialog {
    private Unit mUnit;
    private DevicePath mBasePath;
    private PinDeviceComboBox mPadCb;
    private JTextField mPadOffset;
    private JTextField mPadSpacing;
    private JTextField mHeightChange;
    private JTextField mDomainChange;
    private JTextField mRowChange;
    private JTextField mNumRowL;
    private JTextField mNumRowD;
    private JTextField mNumRowR;
    private JTextField mNumRowT;
    private JTextField mUncrossTime;
    private JTextField mGroupWindowsSize;
    private JTextField mBallProx;
    private JCheckBox mCloserBallFirst;
    private ParameterSetter mParamSetter;
    private CellListEditor mEditor;
    private IOCellEntry mEntry = null;
    ActionListener mCreatePadListener = ae -> Cp.exec((String)"new com.sigrity.orbit.ui.TemplateUI(OrbitIO.getMainWindow(),\"device\")", (Object[])new Object[0]);
    ActionListener mCloserBallFirstListener = ae -> {
        boolean selected = this.mCloserBallFirst.isSelected();
        this.mBallProx.setEnabled(selected);
        this.mNumRowL.setEnabled(!selected);
        this.mNumRowD.setEnabled(!selected);
        this.mNumRowR.setEnabled(!selected);
        this.mNumRowT.setEnabled(!selected);
    };
    PopupMenuListener mPadRefreshListener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            IOCellPlacerUI.this.mPadCb.populateDevices();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    };
    private ActionListener mExportCsvHandler = ae -> ExportCsvDlg.showMe(this.mBasePath.escapedString());
    private ActionListener mImportCsvHandler = ae -> {
        this.mEntry = ImportCsvDlg.showMe(this.mBasePath.escapedString());
        if (this.mEntry != null) {
            this.setEditor(this.mEntry);
            Cp.exec((String)"_placer.setEntry(_entry)", (Object[])new Object[0]);
            this.setParam();
            Cp.exec((String)"_placer.reEntry()", (Object[])new Object[0]);
        }
    };
    private ActionListener mPlaceHandler = ae -> {
        this.setParam();
        Cp.exec((String)"_placer.place();", (Object[])new Object[0]);
        OrbitIO.getApp().refreshCurrentView(false);
    };
    private ActionListener mPlacePGHandler = ae -> {
        this.setParam();
        Cp.exec((String)"_placer.placePG();", (Object[])new Object[0]);
        OrbitIO.getApp().refreshCurrentView(false);
    };
    private ActionListener mPlacePadHandler = ae -> {
        this.setParam();
        Cp.exec((String)"_placer.placePad()", (Object[])new Object[0]);
        OrbitIO.getApp().refreshCurrentView(false);
    };
    private ActionListener mCloseHandler = ae -> UIUtil.closeWindow((Window)((Object)this));

    public static IOCellPlacerUI showMe(Window owner, Db db, String basePath) {
        if (db == null) {
            return null;
        }
        IOCellPlacerUI dlg = new IOCellPlacerUI(owner, db, basePath);
        dlg.setVisible(true);
        return dlg;
    }

    private IOCellPlacerUI(Window owner, Db db, String basePath) {
        super(db, (Component)owner);
        this.mBasePath = DevicePath.fromString((Db)db, (String)basePath);
        this.mUnit = OrbitIO.getCurView().getUnit();
        this.initPlacer();
        this.initParamSetter();
        this.initDlg();
    }

    private void initPlacer() {
        Cp.exec((String)"_placer = com.sigrity.orbit.automation.iocellplacement.IOCellPlacer.getOrCreatePlacer(curDb(), \"%s\");", (Object[])new Object[]{this.mBasePath.escapedString()});
    }

    private void initParamSetter() {
        this.mParamSetter = new ParameterSetter();
    }

    private void initDlg() {
        this.setTitle("IO Cell Placement");
        GridBagManager lMain = GridBagManager.layout((JDialog)((Object)this));
        ASplitPane splitPane = (ASplitPane)lMain.add((Component)new ASplitPane(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        lMain.newline();
        this.addLeftPanel(splitPane);
        this.addRightPanel(splitPane);
        this.addActionButton(lMain);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    private void addLeftPanel(ASplitPane splitPane) {
        JPanel pnlLeft = new JPanel();
        splitPane.setLeftComponent(pnlLeft);
        GridBagManager lLeft = GridBagManager.layout((Container)pnlLeft);
        this.addInfoSection(lLeft);
        this.addParameterSection(lLeft);
    }

    private void addRightPanel(ASplitPane splitPane) {
        this.mEditor = new CellListEditor();
        splitPane.setRightComponent(this.mEditor);
    }

    private void addInfoSection(GridBagManager l) {
        l.push("<html><b><i>Devices", (GridBagConstraints)GridBagManager.LEFT);
        l.add("Die:");
        JTextField mDieInfo = (JTextField)l.add((Component)new JTextField());
        mDieInfo.setEditable(false);
        mDieInfo.setForeground(Color.BLUE);
        mDieInfo.setText(this.mBasePath.escapedString());
        l.pop();
        l.newline();
    }

    private void addParameterSection(GridBagManager l) {
        l.push("<html><b><i>Pad Parameters", (GridBagConstraints)GridBagManager.LEFT);
        l.add("Pad: ");
        this.mPadCb = (PinDeviceComboBox)l.add((Component)new PinDeviceComboBox(this.mBasePath), (GridBagConstraints)GridBagManager.LEFT);
        this.mPadCb.addPopupMenuListener(this.mPadRefreshListener);
        this.addButton(l, "Create", Color.black, this.mCreatePadListener);
        l.newline();
        this.mPadOffset = this.addParameterField(l, "Offset From Edge:", "47.5");
        this.mPadSpacing = this.addParameterField(l, "Spacing:", "7.5");
        l.pop();
        l.newline();
        l.push("<html><b><i>Driver Parameters", (GridBagConstraints)GridBagManager.LEFT);
        this.mHeightChange = this.addParameterField(l, "Height Change Spacing:", "36.2");
        this.mDomainChange = this.addParameterField(l, "Domain Change Spacing:", "36.2");
        l.newline();
        this.mRowChange = this.addParameterField(l, "Row Change Spacing:", "25");
        l.pop();
        l.newline();
        l.push("<html><b><i>Placement Parameters", (GridBagConstraints)GridBagManager.LEFT);
        this.mNumRowL = this.addParameterField(l, "Number of Rows(Left):", "1");
        this.mNumRowT = this.addParameterField(l, "Number of Rows(Top):", "1");
        l.newline();
        this.mNumRowR = this.addParameterField(l, "Number of Rows(Right):", "1");
        this.mNumRowD = this.addParameterField(l, "Number of Rows(Bottom):", "1");
        l.newline();
        this.mUncrossTime = this.addParameterField(l, "Times to Uncross", "10");
        this.mGroupWindowsSize = this.addParameterField(l, "Group Window Size", "40");
        l.newline();
        this.mCloserBallFirst = this.addCheckBoxLabelL(l, "Closer Ball in the Front Row", false, this.mCloserBallFirstListener);
        this.mBallProx = this.addParameterField(l, "Ball Proximity", "800");
        this.mBallProx.setEnabled(false);
        l.pop();
        l.newline();
    }

    protected void addActionButton(GridBagManager l) {
        l.pushFill();
        JButton mExportCsvButton = (JButton)l.add((Component)new JButton("Export CSV"), (GridBagConstraints)GridBagManager.CENTER);
        mExportCsvButton.setForeground(Color.BLUE);
        mExportCsvButton.addActionListener(this.mExportCsvHandler);
        JButton mImportCsvButton = (JButton)l.add((Component)new JButton("Import CSV"), (GridBagConstraints)GridBagManager.CENTER);
        mImportCsvButton.setForeground(Color.BLUE);
        mImportCsvButton.addActionListener(this.mImportCsvHandler);
        this.addButton(l, "Place", Color.red, this.mPlaceHandler);
        this.addButton(l, "Place PG", Color.red, this.mPlacePGHandler);
        this.addButton(l, "Place Pad", Color.red, this.mPlacePadHandler);
        this.addButton(l, "Close", Color.black, this.mCloseHandler);
        l.pop();
    }

    protected JButton addButton(GridBagManager l, String label, Color color, ActionListener ... als) {
        JButton btn = (JButton)l.add((Component)new JButton(label), (GridBagConstraints)GridBagManager.CENTER);
        btn.setBorderPainted(true);
        btn.setFont(new Font("Arial", 0, 13));
        btn.setForeground(color);
        for (ActionListener al : als) {
            btn.addActionListener(al);
        }
        return btn;
    }

    protected JTextField addParameterField(GridBagManager l, String label, String defaultValue) {
        l.add(label);
        JTextField field = (JTextField)l.add((Component)new JTextField(6));
        field.setHorizontalAlignment(4);
        field.setText(defaultValue);
        return field;
    }

    protected JCheckBox addCheckBoxLabelR(GridBagManager l, String label, boolean selected, ActionListener ... als) {
        JCheckBox cBox = (JCheckBox)l.add((Component)new JCheckBox(label, selected), (GridBagConstraints)GridBagManager.LEFT);
        for (ActionListener al : als) {
            cBox.addActionListener(al);
        }
        return cBox;
    }

    protected JCheckBox addCheckBoxLabelL(GridBagManager l, String label, boolean selected, ActionListener ... als) {
        l.add(label, (GridBagConstraints)GridBagManager.LEFT);
        JCheckBox cBox = (JCheckBox)l.add((Component)new JCheckBox("", selected), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
        for (ActionListener al : als) {
            cBox.addActionListener(al);
        }
        return cBox;
    }

    private void setEditor(IOCellEntry entry) {
    }

    private static <T> Long validateAndConvertField(JTextField field, T def, Unit unit) {
        String ret = def.toString();
        try {
            if (def instanceof Integer) {
                ret = AFieldValidator.validateInt((JTextField)field);
            } else if (def instanceof Float) {
                ret = AFieldValidator.validateFloat((JTextField)field);
            } else if (def instanceof Double) {
                ret = AFieldValidator.validateDouble((JTextField)field);
            }
        }
        catch (AFieldValidator.AFieldValidationException e) {
            ALog.logWarn((String)"Validation of %s is failed. Use default value (%s)", (Object[])new Object[]{field.getText(), def.toString()});
        }
        return unit == null ? Long.valueOf(ret) : unit.fromUserString(ret);
    }

    private void setParam() {
        this.mParamSetter.setAll();
    }

    public static class CellListEditor
    extends JPanel {
        protected PersonalityTree mTreePersonalities;

        public CellListEditor() {
            this.initEditor();
        }

        private void initEditor() {
            GridBagManager l = GridBagManager.layout((Container)this);
            ATreeModel tm = new ATreeModel();
            tm.setRoot((TreeNode)((Object)new RootNode(tm)));
            this.mTreePersonalities = new PersonalityTree(tm);
            this.mTreePersonalities.setRootVisible(false);
            l.add((Component)new JScrollPane(this.mTreePersonalities), (GridBagConstraints)GridBagManager.FILLALL);
        }

        protected class RootNode
        extends ALazyTreeNode {
            public RootNode(ATreeModel owner) {
                super(owner);
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                return null;
            }

            public String getText() {
                return null;
            }
        }

        protected static class PersonalityTree
        extends JTree {
            protected ATreeModel mTreeModel;

            public PersonalityTree(ATreeModel tm) {
                super((TreeModel)tm);
                this.mTreeModel = tm;
            }
        }
    }

    private class ParameterSetter {
        public ParameterSetter() {
            if (this.isPlacerNull()) {
                throw new IllegalArgumentException();
            }
        }

        protected boolean isPlacerNull() {
            return (Boolean)Cp.exec((boolean)false, (String)"_placer == void", (Object[])new Object[0]);
        }

        public String getPadKeyStrFromCb(PinDeviceComboBox padCb) {
            DeviceTemplate pad = (DeviceTemplate)padCb.getSelectedItem();
            return pad != null ? pad.getKeyStr() : "";
        }

        public void setRow() {
            Long numRowR = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mNumRowR, 2, null);
            Long numRowT = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mNumRowT, 2, null);
            Long numRowL = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mNumRowL, 2, null);
            Long numRowD = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mNumRowD, 2, null);
            Cp.exec((String)"_placer.setRowRule(%dL, %dL, %dL, %dL)", (Object[])new Object[]{numRowR, numRowT, numRowL, numRowD});
        }

        public void setOptimize() {
            Long uncrossTime = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mUncrossTime, 10, null);
            Long groupWindowSize = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mGroupWindowsSize, 40, null);
            Long ballProx = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mBallProx, 800, IOCellPlacerUI.this.mUnit);
            Boolean closerBallFirst = IOCellPlacerUI.this.mCloserBallFirst.isSelected();
            Cp.exec((String)"_placer.setUncrossTimes(%dL)", (Object[])new Object[]{uncrossTime});
            Cp.exec((String)"_placer.setGroupWindowSize(%dL)", (Object[])new Object[]{groupWindowSize});
            Cp.exec((String)"_placer.setBallProx(%dL)", (Object[])new Object[]{ballProx});
            Cp.exec((String)"_placer.setCloserBallFirst(%b)", (Object[])new Object[]{closerBallFirst});
        }

        public void setPad() {
            Long padOffset = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mPadOffset, 47.5, IOCellPlacerUI.this.mUnit);
            Long padSpacing = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mPadSpacing, 7.5, IOCellPlacerUI.this.mUnit);
            String pad = this.getPadKeyStrFromCb(IOCellPlacerUI.this.mPadCb);
            Cp.exec((String)"_placer.setPad(\"%s\", %dL, %dL)", (Object[])new Object[]{pad, padOffset, padSpacing});
        }

        public void setSpacing() {
            Long padSpacing = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mPadSpacing, 7.5, IOCellPlacerUI.this.mUnit);
            Long heightChange = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mHeightChange, 36.2, IOCellPlacerUI.this.mUnit);
            Long domainChange = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mDomainChange, 36.2, IOCellPlacerUI.this.mUnit);
            Long rowChange = IOCellPlacerUI.validateAndConvertField(IOCellPlacerUI.this.mRowChange, 25, IOCellPlacerUI.this.mUnit);
            Cp.exec((String)"_placer.updateSpacing(%dL, %dL, %dL, %dL)", (Object[])new Object[]{padSpacing, heightChange, domainChange, rowChange});
        }

        public void setAll() {
            this.setRow();
            this.setOptimize();
            this.setPad();
            this.setSpacing();
        }
    }

    static class ImportCsvDlg {
        public static IOCellEntry showMe(String basePathStr) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.CSV;
            OptionPanel options = new OptionPanel();
            fc.setAccessory((JComponent)options);
            fc.setFileFilter((FileFilter)filter);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return null;
            }
            File f = fc.getSelectedFile();
            Object csvPath = f.getPath();
            if (!f.getName().contains(".")) {
                csvPath = (String)csvPath + ".csv";
            }
            if (!options.getUpdateOnly()) {
                Cp.exec((String)"_placer.removePad()", (Object[])new Object[0]);
            }
            return (IOCellEntry)Cp.exec((String)"_entry = com.sigrity.orbit.automation.iocellplacement.IOCellEntry.importCsv(\"%s\", %s, %b)", (Object[])new Object[]{basePathStr, Cp.getFileAsArgument((String)csvPath), options.getUpdateOnly()});
        }

        private ImportCsvDlg() {
        }

        private static class OptionPanel
        extends JPanel {
            JCheckBox mUpdateOnly;

            public OptionPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Import Options"));
                GridBagManager l = new GridBagManager((Container)this);
                this.mUpdateOnly = (JCheckBox)l.add((Component)new JCheckBox("Update Cell Only"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            }

            public boolean getUpdateOnly() {
                return this.mUpdateOnly.isSelected();
            }
        }
    }

    static class ExportCsvDlg {
        public static void showMe(String basePathStr) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.CSV;
            OptionPanel options = new OptionPanel();
            fc.setAccessory((JComponent)options);
            fc.setFileFilter((FileFilter)filter);
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object csvPath = f.getPath();
            if (!f.getName().contains(".")) {
                csvPath = (String)csvPath + ".csv";
            }
            Cp.exec((String)"com.sigrity.orbit.automation.iocellplacement.IOCellEntry.exportCsv(\"%s\", %s)", (Object[])new Object[]{basePathStr, Cp.getFileAsArgument((String)csvPath)});
        }

        private ExportCsvDlg() {
        }

        private static class OptionPanel
        extends JPanel {
            public OptionPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Import Options"));
            }
        }
    }
}

