/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.pinMap;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.pinMap.PinMapConfiguration;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;

public class ExportPinMap {
    private final Db mDb;
    private List<ContactLayer> mContactLayers;
    private HashMap<DeviceTemplate, Boolean> mIsPinDeviceName = new HashMap();

    public ExportPinMap(Db db) {
        this.mDb = db;
    }

    public void addContactLayer(ContactLayer contactLayer) {
        if (this.mContactLayers == null) {
            this.mContactLayers = new LinkedList<ContactLayer>();
        }
        this.mContactLayers.add(contactLayer);
    }

    public void exportPinMapCsv(String fileName) {
        String baseFileName = fileName.replace(".csv", "");
        if (this.mContactLayers != null && this.mContactLayers.size() == 1) {
            String clFileName = String.format("%s.csv", baseFileName);
            this.exportPinMapCsv(this.mContactLayers.get(0), clFileName);
        } else {
            this.getContactLayers().forEach(contactLayer -> {
                String clFileName = String.format("%s_%s.csv", baseFileName, contactLayer.getSimpleString());
                this.exportPinMapCsv((ContactLayer)contactLayer, clFileName);
            });
        }
    }

    private void exportPinMapCsv(ContactLayer contactLayer, String fileName) {
        try (ACsvWriter out = ACsvWriter.open((String)fileName);){
            this.writePinMapCsv(contactLayer, out);
            ALog.logInfo((String)"Export pinMap csv for %s complete.", (Object[])new Object[]{contactLayer.toString()});
        }
        catch (Exception excep) {
            ALog.logError((Throwable)excep, (String)"There was an unexpected exception while writing file.", (Object[])new Object[0]);
        }
    }

    private void writePinMapCsv(ContactLayer contactLayer, ACsvWriter csvWriter) {
        this.writeDesignInfo(csvWriter);
        this.writeContactLayerInfo(contactLayer, csvWriter);
        this.writeHeader(csvWriter);
        this.writePinMap(contactLayer, csvWriter);
    }

    private void writeDesignInfo(ACsvWriter csvWriter) {
        assert (this.mDb != null && csvWriter != null);
        csvWriter.row(new String[]{String.format("#. %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion())});
        csvWriter.row(new String[]{String.format("#. Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp())});
        csvWriter.row(new String[]{String.format("#. User: %s", System.getProperty("user.name"))});
        csvWriter.row(new String[]{String.format("#. Time: %s", new Date())});
        String file = this.mDb.getCanonicalPath();
        csvWriter.row(new String[]{String.format("#. Source design: %s", file != null ? file : "<Unsaved Design>")});
        csvWriter.row(new String[]{"#."});
    }

    private void writeContactLayerInfo(ContactLayer contactLayer, ACsvWriter csvWriter) {
        csvWriter.row(new String[]{"#. Contact layer:"});
        String layerAName = contactLayer.getContactLayerA().getName();
        String layerBName = contactLayer.getContactLayerB().getName();
        contactLayer.getContactFullPaths().forEach(pathPair -> {
            csvWriter.row(new String[]{String.format("#.\t DevicePath A: %s, Layer: %s", pathPair.getFirst(), layerAName)});
            csvWriter.row(new String[]{String.format("#.\t DevicePath B: %s, Layer: %s", pathPair.getSecond(), layerBName)});
            csvWriter.row(new String[]{"#."});
        });
    }

    private void writeHeader(ACsvWriter csvWriter) {
        csvWriter.header(PinMapConfiguration.PinMapConfigHeader.getHeader());
    }

    private void writePinMap(ContactLayer contactLayer, ACsvWriter csvWriter) {
        PinMap.get((ContactLayer)contactLayer).stream().sorted().forEach(pinMap -> {
            this.writePin(csvWriter, pinMap.getPinAPathFromContactDev(), pinMap.getPinA());
            this.writeTerm(csvWriter, pinMap.getPinAPathFromContactDev(), pinMap.getPinA());
            this.writeNet(csvWriter, pinMap.getNetAtContactDevA());
            this.writePin(csvWriter, pinMap.getPinBPathFromContactDev(), pinMap.getPinB());
            this.writeTerm(csvWriter, pinMap.getPinBPathFromContactDev(), pinMap.getPinB());
            this.writeNet(csvWriter, pinMap.getNetAtContactDevB());
            csvWriter.endRow();
        });
    }

    private void writePin(ACsvWriter csvWriter, DevicePath pinPath, PinTemplate pinT) {
        if (this.usePinDeviceName(pinPath)) {
            csvWriter.colData(pinPath.getParent().toString());
            csvWriter.colData(pinPath.getDevice().getName());
        } else {
            csvWriter.colData(pinPath.toString());
            csvWriter.colData(pinT.getName());
        }
    }

    private void writeTerm(ACsvWriter csvWriter, DevicePath pinPath, PinTemplate pinT) {
        PinLabel pinLabel = PinLabel.get((DevicePath)pinPath, (PinTemplate)pinT, (boolean)false);
        if (pinLabel != null && pinLabel.getTerm() != null) {
            csvWriter.colData(pinLabel.getTerm().getName());
        } else {
            Net rootNet = (Net)AUtil.getIffOne((Collection)TermMap.getTopMostNet((Net)pinT.getNet(), (DevicePath)pinPath));
            Term term = rootNet == null ? null : (Term)AUtil.getIffOne((Iterator)rootNet.getTerms());
            String termStr = term == null ? "" : term.getName();
            csvWriter.colData(termStr);
        }
    }

    private boolean usePinDeviceName(DevicePath pinPath) {
        if (pinPath.isEmpty()) {
            return false;
        }
        DeviceTemplate devT = pinPath.getDeviceTemplate();
        Boolean isPinDeviceName = this.mIsPinDeviceName.get(devT);
        if (isPinDeviceName != null) {
            return isPinDeviceName;
        }
        if (devT.amIAPin() && AUtil.exactlyOne((Iterator)devT.getPins())) {
            this.mIsPinDeviceName.put(devT, true);
            return true;
        }
        this.mIsPinDeviceName.put(devT, false);
        return false;
    }

    private void writeNet(ACsvWriter csvWriter, Net netAtContactDev) {
        String netStr = netAtContactDev == null || netAtContactDev.isUnused() ? "" : netAtContactDev.getName();
        csvWriter.colData(netStr);
    }

    private Stream<ContactLayer> getContactLayers() {
        if (this.mContactLayers == null) {
            return ContactLayer.getValid((Db)this.mDb).stream();
        }
        return this.mContactLayers.stream();
    }
}

