/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.pinMap;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NetMapGenerator {
    protected Db mDb;
    private List<ContactLayer> mContactLayers;
    protected Set<PinMap> mCandidatePinMap;
    private boolean mHandleNetUnused = false;

    public static void execute(Db db, boolean handleNetUnused) {
        ALog.logDebug((String)"Auto-connect net mapping Start ...");
        NetMapGenerator generator = new NetMapGenerator(db);
        generator.setHandleNetUnused(handleNetUnused);
        generator.createNetMapFromPinMap();
        ALog.logInfo((String)"Auto-connect net mapping complete.");
    }

    public NetMapGenerator(Db db) {
        this.mDb = db;
    }

    public void addContactLayer(ContactLayer contactLayer) {
        if (this.mContactLayers == null) {
            this.mContactLayers = new LinkedList<ContactLayer>();
        }
        this.mContactLayers.add(contactLayer);
    }

    public void setHandleNetUnused(boolean b) {
        this.mHandleNetUnused = b;
    }

    public void createNetMapFromPinMap() {
        this.loadCandidatePinMap();
        this.createNetMaps();
    }

    private void loadCandidatePinMap() {
        ParentChildNetMapInfo parentChildNetMapInfo = new ParentChildNetMapInfo(this.mDb, this.mContactLayers);
        for (Map.Entry<HierInst<Net>, List<ContactInfo>> entry : parentChildNetMapInfo.getEntrySet()) {
            if (this.validContactInfo(entry.getValue())) continue;
            List disablePinMap = entry.getValue().stream().map(info -> info.pinMap).collect(Collectors.toList());
            this.getCandidatePinMap().removeAll(disablePinMap);
        }
    }

    private void createNetMaps() {
        ArrayList sortedPinMaps = AUtil.arrayList(this.getCandidatePinMap());
        Collections.sort(sortedPinMaps);
        for (PinMap pinMap : sortedPinMaps) {
            pinMap.createNetMapping(this.mHandleNetUnused);
        }
    }

    private boolean validContactInfo(List<ContactInfo> infoList) {
        Set contactNets = infoList.stream().map(info -> info.hierNet).collect(Collectors.toSet());
        if (contactNets.size() <= 1) {
            return true;
        }
        HierInst<Net> targetHierPin = infoList.get((int)0).hierNet;
        Net targetNet = (Net)targetHierPin.getDbObject();
        if (targetNet.isUnused()) {
            return false;
        }
        Net topNet = NetMap.getTopmostNet((Net)targetNet, (DevicePath)targetHierPin.getPath());
        return !topNet.isUnused() && contactNets.stream().allMatch(hierNet -> NetMap.isMapped((Net)topNet, (DevicePath)hierNet.getPath(), (Net)((Net)hierNet.getDbObject())));
    }

    private Set<PinMap> getCandidatePinMap() {
        if (this.mCandidatePinMap == null) {
            this.mCandidatePinMap = this.getContactLayerPinMaps();
        }
        return this.mCandidatePinMap;
    }

    private Set<PinMap> getContactLayerPinMaps() {
        if (this.mContactLayers == null) {
            return PinMap.getValid((Db)this.mDb).stream().collect(Collectors.toSet());
        }
        return this.mContactLayers.stream().flatMap(contactLayer -> PinMap.get((ContactLayer)contactLayer).stream()).collect(Collectors.toSet());
    }

    private static class ContactInfo {
        private HierInst<Net> hierNet;
        private PinMap pinMap;

        ContactInfo(HierInst<Net> hierNet, PinMap pinMap) {
            this.hierNet = hierNet;
            this.pinMap = pinMap;
        }
    }

    private static class ParentChildNetMapInfo {
        private Db db;
        private List<ContactLayer> contactLayers;
        private Map<HierInst<Net>, List<ContactInfo>> net2ContactInfo = new HashMap<HierInst<Net>, List<ContactInfo>>();

        public ParentChildNetMapInfo(Db db, List<ContactLayer> contactLayers) {
            this.db = db;
            this.contactLayers = contactLayers;
            this.init();
        }

        public Set<Map.Entry<HierInst<Net>, List<ContactInfo>>> getEntrySet() {
            return this.net2ContactInfo.entrySet();
        }

        private void init() {
            for (PinMap pinMap : this.getParentChildPinMaps()) {
                Net netA = pinMap.getNetAtContactDevA();
                Net netB = pinMap.getNetAtContactDevB();
                if (netA == null || netA.isUnused() || netB == null || netB.isUnused()) continue;
                HierInst hierNetA = HierInst.create((DevicePath)pinMap.getContactDevPathA(), (DbObject)netA);
                HierInst hierNetB = HierInst.create((DevicePath)pinMap.getContactDevPathB(), (DbObject)netB);
                this.addContactInfo((HierInst<Net>)hierNetA, new ContactInfo((HierInst<Net>)hierNetB, pinMap));
                this.addContactInfo((HierInst<Net>)hierNetB, new ContactInfo((HierInst<Net>)hierNetA, pinMap));
            }
        }

        private Set<PinMap> getParentChildPinMaps() {
            if (this.contactLayers == null) {
                return ContactLayer.getValid((Db)this.db).stream().flatMap(cl -> this.getParentChildPinMaps((ContactLayer)cl).stream()).collect(Collectors.toSet());
            }
            return this.contactLayers.stream().flatMap(cl -> this.getParentChildPinMaps((ContactLayer)cl).stream()).collect(Collectors.toSet());
        }

        private IterableIterator<PinMap> getParentChildPinMaps(ContactLayer contactLayer) {
            if (contactLayer.getDevicePathA().isEmpty() || contactLayer.getDevicePathB().isEmpty()) {
                return PinMap.get((ContactLayer)contactLayer);
            }
            return AEmptyItr.create();
        }

        private void addContactInfo(HierInst<Net> hierNet, ContactInfo contactInfo) {
            List infoList = this.net2ContactInfo.computeIfAbsent(hierNet, x -> new LinkedList());
            infoList.add(contactInfo);
        }
    }
}

