/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.pinMap;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.pinMap.ExportPinMap;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import java.util.ArrayList;

public class PinMapConfiguration {
    public static void exportPinMapCsv(String fileName) {
        Db curDb = OrbitIO.getCurDb();
        ExportPinMap exportPinMap = new ExportPinMap(curDb);
        exportPinMap.exportPinMapCsv(fileName);
    }

    public static void comparePinMapCsv(Db db) {
        ReferenceCsvCheck refCsvCheck = new ReferenceCsvCheck(db);
        for (ContactLayer contactLayer : ContactLayer.getValid((Db)db)) {
            String csvFile = (String)contactLayer.getValue("ReferenceCompareFile", String.class);
            if (csvFile == null || csvFile.isEmpty()) continue;
            refCsvCheck.addCsvFile(contactLayer, csvFile);
        }
        PinMapCheck engine = new PinMapCheck(db);
        engine.addCheck(refCsvCheck);
        engine.execute();
        engine.showResultUI();
    }

    public static enum PinMapConfigHeader {
        PINPATHA("PinPath A"),
        PINA("Pin A"),
        TERMA("Term A"),
        NETA("Net A"),
        PINPATHB("PinPath B"),
        PINB("Pin B"),
        TERMB("Term B"),
        NETB("Net B");

        private static final ArrayList<String> HEADER;
        String headerStr;
        String csvAttributeName;

        public static String[] getHeader() {
            String[] a = new String[]{};
            return HEADER.toArray(a);
        }

        private PinMapConfigHeader(String headerStr) {
            this.headerStr = headerStr;
            this.csvAttributeName = headerStr.toLowerCase().replace(" ", "");
        }

        public String getName() {
            return this.headerStr;
        }

        public String getCsvAttributeName() {
            return this.csvAttributeName;
        }

        static {
            HEADER = new ArrayList(PinMapConfigHeader.values().length);
            for (PinMapConfigHeader h : PinMapConfigHeader.values()) {
                HEADER.add(h.getName());
            }
        }
    }
}

