/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.pinMap;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.automation.pinMap.PinMapConfiguration;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class PinMapCsvReader {
    private final ContactLayer mContactLayer;
    private List<CsvPinMap> mCsvPinMaps = new LinkedList<CsvPinMap>();

    public PinMapCsvReader(ContactLayer contactLayer) {
        this.mContactLayer = contactLayer;
    }

    public void importCsvPinMap(String fileName) {
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(fileName);
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.importCsvPinMap(csvDoc, i);
            }
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)"Problems reading %s", (Object[])new Object[]{fileName});
        }
    }

    public List<CsvPinMap> getCsvPinMaps() {
        return this.mCsvPinMaps;
    }

    public CsvPinMap getCsvPinMapFromA(HierInst<PinTemplate> hierPinT) {
        return this.getCsvPinMapFromA(hierPinT.getPath(), (PinTemplate)hierPinT.getSecond());
    }

    public CsvPinMap getCsvPinMapFromB(HierInst<PinTemplate> hierPinT) {
        return this.getCsvPinMapFromB(hierPinT.getPath(), (PinTemplate)hierPinT.getSecond());
    }

    public CsvPinMap getCsvPinMapFromA(DevicePath pinPath, PinTemplate pin) {
        return this.getCsvPinMapFrom(pinPath, pin, true);
    }

    public CsvPinMap getCsvPinMapFromB(DevicePath pinPath, PinTemplate pin) {
        return this.getCsvPinMapFrom(pinPath, pin, false);
    }

    private CsvPinMap getCsvPinMapFrom(DevicePath pinPath, PinTemplate pin, boolean isFromA) {
        CsvPinMap csvPinMap = this.getCsvPinMapFromPin(pinPath, pin, isFromA);
        if (csvPinMap == null && pinPath.isPin()) {
            csvPinMap = this.getCsvPinMapFromDevice(pinPath, isFromA);
        }
        return csvPinMap;
    }

    private CsvPinMap getCsvPinMapFromPin(DevicePath pinPath, PinTemplate pin, boolean isFromA) {
        String pinPathStr = pinPath.toString();
        String pinStr = pin.getName();
        return this.getCsvPinMap(pinPathStr, pinStr, isFromA);
    }

    private CsvPinMap getCsvPinMapFromDevice(DevicePath pinPath, boolean isFromA) {
        String pinPathStr = pinPath.getParent().toString();
        String pinStr = pinPath.getDevice().getName();
        return this.getCsvPinMap(pinPathStr, pinStr, isFromA);
    }

    private CsvPinMap getCsvPinMap(String pinPathStr, String pinStr, boolean isFromA) {
        return this.mCsvPinMaps.stream().filter(csvPinMap -> isFromA ? this.matchCsvPinMapA(pinPathStr, pinStr, (CsvPinMap)csvPinMap) : this.matchCsvPinMapB(pinPathStr, pinStr, (CsvPinMap)csvPinMap)).findAny().orElse(null);
    }

    private boolean matchCsvPinMapA(String pinPathStr, String pinStr, CsvPinMap csvPinMap) {
        return this.matchCsvPinMap(pinPathStr, pinStr, csvPinMap.getPinPathA(), csvPinMap.getPinA());
    }

    private boolean matchCsvPinMapB(String pinPathStr, String pinStr, CsvPinMap csvPinMap) {
        return this.matchCsvPinMap(pinPathStr, pinStr, csvPinMap.getPinPathB(), csvPinMap.getPinB());
    }

    private boolean matchCsvPinMap(String pinPathStr, String pinStr, String csvPinPathStr, String csvPinStr) {
        return csvPinStr.equals(pinStr) && this.matchPinPath(pinPathStr, csvPinPathStr);
    }

    private boolean matchPinPath(String pinPathStr, String csvPinPathStr) {
        return csvPinPathStr == null || csvPinPathStr.isEmpty() || csvPinPathStr.equals(pinPathStr);
    }

    private void importCsvPinMap(CSVDocument csvDoc, int i) {
        Element item = csvDoc.getItem(i);
        String pinPathA = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.PINPATHA.getCsvAttributeName());
        String pinPathB = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.PINPATHB.getCsvAttributeName());
        String pinA = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.PINA.getCsvAttributeName());
        String pinB = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.PINB.getCsvAttributeName());
        String termA = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.TERMA.getCsvAttributeName());
        String termB = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.TERMB.getCsvAttributeName());
        String netA = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.NETA.getCsvAttributeName());
        String netB = item.getAttribute(PinMapConfiguration.PinMapConfigHeader.NETB.getCsvAttributeName());
        this.mCsvPinMaps.add(new CsvPinMap(this.mContactLayer, pinPathA, pinA, termA, netA, pinPathB, pinB, termB, netB));
    }

    public static class CsvPinMap {
        private final ContactLayer contactLayer;
        private final String pinPathA;
        private final String pinA;
        private final String termA;
        private final String netA;
        private final String pinPathB;
        private final String pinB;
        private final String termB;
        private final String netB;

        public CsvPinMap(ContactLayer contactLayer, String pinPathA, String pinA, String termA, String netA, String pinPathB, String pinB, String termB, String netB) {
            this.contactLayer = contactLayer;
            this.pinPathA = pinPathA;
            this.pinA = pinA;
            this.termA = termA;
            this.netA = netA;
            this.pinPathB = pinPathB;
            this.pinB = pinB;
            this.termB = termB;
            this.netB = netB;
        }

        public DevicePath getContactDevPathA() {
            return this.contactLayer.getDevicePathA();
        }

        public Layer getLayerA() {
            return this.contactLayer.getContactLayerA();
        }

        public DevicePath getContactDevPathB() {
            return this.contactLayer.getDevicePathB();
        }

        public Layer getLayerB() {
            return this.contactLayer.getContactLayerB();
        }

        public String getPinPathA() {
            return this.pinPathA;
        }

        public String getPinA() {
            return this.pinA;
        }

        public String getTermA() {
            return this.termA;
        }

        public String getNetA() {
            return this.netA;
        }

        public String getPinPathB() {
            return this.pinPathB;
        }

        public String getPinB() {
            return this.pinB;
        }

        public String getTermB() {
            return this.termB;
        }

        public String getNetB() {
            return this.netB;
        }
    }
}

