/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.pinMap;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.pinMap.NetMapGenerator;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import com.sigrity.orbit.ui.ImportContactLayerDlg;

public class PinMapGenerator {
    protected Db mDb;
    protected PinMapCheck mPinMapCheck;

    public static void createPinMapFromPhysicalContact(String contactLayerCsvFile) {
        ImportContactLayerDlg.importContactLayer(contactLayerCsvFile);
        PinMapGenerator.createPinMapFromPhysicalContact();
    }

    public static void createPinMapFromPhysicalContact() {
        Db db = OrbitIO.getApp().getCurrentDb();
        if (db == null) {
            ALog.logWarn((String)"Open an orbit design before runing this command.");
            return;
        }
        PinMapGenerator pinMapGenerator = new PinMapGenerator(db);
        pinMapGenerator.generatePinMaps();
        pinMapGenerator.executeChecking();
    }

    public static void createPinMapFromPhysicalContact(Db db, ContactLayer contactLayer) {
        PinMapGenerator pinMapGenerator = new PinMapGenerator(db);
        pinMapGenerator.createFromPinPhysicalContact(contactLayer);
    }

    public PinMapGenerator(Db db) {
        this.mDb = db;
    }

    public void deleteAllPinMap() {
        PinMap.deleteAll();
    }

    public void executeChecking() {
        this.mPinMapCheck = new PinMapCheck(this.mDb);
        this.mPinMapCheck.addCheck(PinMapCheck.CheckType.PORT_CONTACT);
        this.mPinMapCheck.addCheck(PinMapCheck.CheckType.NET_MAPPING);
        this.mPinMapCheck.addCheck(PinMapCheck.CheckType.PIN_DIRECTION);
        this.mPinMapCheck.addCheck(PinMapCheck.CheckType.PIN_COUNT_MISMATCH);
        this.mPinMapCheck.addCheck(PinMapCheck.CheckType.PIN_UNMAPPED);
        this.mPinMapCheck.execute();
    }

    public void showCheckingResultUI() {
        if (this.mPinMapCheck == null) {
            return;
        }
        this.mPinMapCheck.showResultUI();
    }

    public void generatePinMaps() {
        this.createFromPinPhysicalContact();
    }

    private void createFromPinPhysicalContact() {
        ContactLayer.getValid((Db)this.mDb).forEach(this::createFromPinPhysicalContact);
    }

    public void createFromPinPhysicalContact(ContactLayer contactLayer) {
        ALog.logDebug((String)"Create PinMap from physical contact for %s ...", (Object[])new Object[]{contactLayer});
        PortContactCheck.CandidateContactPortInfo candidateContactPortInfo = new PortContactCheck.CandidateContactPortInfo(contactLayer);
        for (PortContactCheck.PortWorldGeom portGeom1 : candidateContactPortInfo.getPortWorldGeom1()) {
            for (PortContactCheck.PortWorldGeom portGeom2 : candidateContactPortInfo.getIntersectGeom2(portGeom1)) {
                if (!portGeom1.intersects(portGeom2)) continue;
                PinMap.create((ContactLayer)contactLayer, (PinTemplate)portGeom1.getPinTemplate(), (DevicePath)portGeom1.getPinPath(), (PinTemplate)portGeom2.getPinTemplate(), (DevicePath)portGeom2.getPinPath());
            }
        }
        ALog.logInfo((String)"Create PinMap from physical contact for %s complete.", (Object[])new Object[]{contactLayer});
    }

    public void createNetMaps() {
        this.createNetMaps(false);
    }

    public void createNetMaps(boolean handleNetUnused) {
        NetMapGenerator.execute(this.mDb, handleNetUnused);
    }
}

