/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.placement;

import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.automation.BumpFactoryData;

public class LayerShapeParameters {
    protected AGeom mShape;
    protected String mLayerName = null;

    public LayerShapeParameters(AGeom shape) {
        this(shape, null);
    }

    public LayerShapeParameters(AGeom shape, String layerName) {
        this.setShape(shape);
        this.setLayerName(layerName);
    }

    public AGeom getShape() {
        return this.mShape;
    }

    public void setShape(AGeom shape) {
        this.mShape = shape;
    }

    public String getLayerName() {
        return this.mLayerName;
    }

    public void setLayerName(String name) {
        this.mLayerName = name;
    }

    public void store(BumpFactoryData bfd, Substrate s) {
        APath path;
        if (this.mLayerName != null) {
            bfd.setLayer(s.getLayer(this.mLayerName));
        }
        if (this.mShape instanceof ACircle) {
            bfd.setPadStyle(PadTemplate.PadShapeStyle.Circle);
            bfd.setBumpSize(((ACircle)this.mShape).getR());
        } else if (this.mShape instanceof ARect) {
            ARect r = (ARect)this.mShape;
            if (r.width() == r.height()) {
                bfd.setPadStyle(PadTemplate.PadShapeStyle.Square);
                bfd.setBumpSize(r.width());
            } else {
                bfd.setPadStyle(PadTemplate.PadShapeStyle.Rect);
                bfd.setBumpSize(r.width());
                bfd.setBumpSize2(r.height());
            }
        } else if (this.mShape instanceof AOctagon) {
            bfd.setPadStyle(PadTemplate.PadShapeStyle.Octagon);
            bfd.setBumpSize(((AOctagon)this.mShape).radius());
        } else if (this.mShape instanceof APath && (path = (APath)this.mShape).getPointCount() == 2) {
            bfd.setPadStyle(PadTemplate.PadShapeStyle.Oblong);
            bfd.setBumpSize(path.getBounds().width());
            bfd.setBumpSize2(path.getWidth());
        }
    }

    public void load(BumpFactoryData bfd) {
        this.mLayerName = bfd.getLayer() == null ? null : bfd.getLayer().getName();
        long s = bfd.getBumpSize();
        long hs = bfd.getBumpSize();
        long hs2 = bfd.getBumpSize2();
        switch (bfd.getPadStyle()) {
            case Circle: {
                this.mShape = new ACircle(0L, 0L, s);
                break;
            }
            case Square: {
                this.mShape = new ARect(-hs / 2L, -hs / 2L, hs / 2L, hs / 2L);
                break;
            }
            case Rect: {
                this.mShape = new ARect(-hs / 2L, -hs2 / 2L, hs / 2L, hs2 / 2L);
                break;
            }
            case Octagon: {
                this.mShape = new AOctagon(s);
                break;
            }
            case Oblong: {
                APath path = new APath(hs2, new APoint2D[]{new APoint2D(-hs / 2L + hs2 / 2L, 0L), new APoint2D(hs / 2L - hs2 / 2L, 0L)});
                path.setStyle(APath.ExtStyle.ROUND);
                this.mShape = path;
            }
        }
    }
}

