/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.placement;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.PadTemplateListRenderer;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.automation.placement.LayerShapeParameters;
import com.sigrity.orbit.automation.placement.PlaceableDevice;
import com.sigrity.orbit.automation.placement.PlaceablePin;
import com.sigrity.orbit.ui.LayerUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PlaceableDefinitionUI
extends JPanel {
    protected Substrate mTempSubstrate = null;
    protected Substrate mSubstrate = null;
    protected DeviceTemplate.Type mDevType = null;
    protected DeviceTemplate mPatternOwner = null;
    protected Unit mUnit;
    protected boolean mAllowLayerSelect;
    protected JComboBox<PlaceableType> mCboItemType = null;
    protected JComboBox<CreateFrom> mCboCreateFrom = null;
    protected JPanel mPnlFromTemplate;
    protected JCheckBox mCbLimitDevTemplates;
    protected JComboBox<DeviceTemplate> mCboDeviceTemplate;
    protected JComboBox<PadTemplate> mCboPadTemplate;
    protected JPanel mPnlFromParameters;
    protected JComboBox<PadTemplate.PadShapeStyle> mCboShape;
    protected JComboBox<Layer> mCboLayer;
    protected JLabel mLblPadSize;
    protected JTextField mTxtPadSize;
    protected JLabel mTxtPadSize2Label;
    protected JTextField mTxtPadSize2;
    protected JLabel mLabelDevT;
    protected JLabel mLabelPadT;
    protected JTextField mTxtDevTName;
    protected JTextField mTxtPadName;
    protected JLabel mLabelRotation;
    protected JTextField mTxtRotation;

    public PlaceableDefinitionUI(DeviceTemplate devT, boolean allowLayerSelect, Substrate substrate, DeviceTemplate.Type devType) {
        this.mPatternOwner = devT;
        this.mAllowLayerSelect = allowLayerSelect;
        this.mSubstrate = substrate;
        this.mTempSubstrate = substrate;
        this.mDevType = devType;
        if (this.mPatternOwner != null) {
            if (this.mSubstrate == null) {
                this.mSubstrate = this.mPatternOwner.getSubstrate();
            }
            if (this.mDevType == null) {
                this.mDevType = this.mPatternOwner.getType();
            }
        }
        this.mUnit = Design.getUnit((Db)(this.mSubstrate != null ? this.mSubstrate.getDb() : OrbitIO.getCurDb()));
        GridBagManager l = GridBagManager.layout((Container)this);
        JLabel la = new JLabel("Create");
        l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
        this.mCboItemType = new JComboBox<PlaceableType>(PlaceableType.values());
        this.mCboItemType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(value + "s");
                return this;
            }
        });
        la.setLabelFor(this.mCboItemType);
        l.add(this.mCboItemType, (GridBagConstraints)GridBagManager.LEFT);
        l.add("from", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboCreateFrom = (JComboBox)l.add((Component)new JComboBox<CreateFrom>(CreateFrom.values()){

            @Override
            public void setSelectedIndex(int idx) {
                if (this.getItemAt(idx) == CreateFrom.Template && PlaceableDefinitionUI.this.getTemplateCount() < 1) {
                    return;
                }
                super.setSelectedIndex(idx);
            }
        }, (GridBagConstraints)GridBagManager.FILLX);
        this.mCboCreateFrom.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == CreateFrom.Template) {
                    if (PlaceableDefinitionUI.this.getPlaceableType() == PlaceableType.Device) {
                        this.setText("Device Template");
                    } else {
                        this.setText("Pad Template");
                    }
                } else {
                    this.setText("Pin Parameters");
                }
                if (value == CreateFrom.Template && PlaceableDefinitionUI.this.getTemplateCount() < 1) {
                    this.setBackground(list.getBackground());
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
                return this;
            }
        });
        l.newline();
        this.mCboItemType.addActionListener(e -> this.enableControls());
        this.mPnlFromTemplate = l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().indent().indent());
        this.mCbLimitDevTemplates = (JCheckBox)l.add((Component)new JCheckBox("Limit to applicable device templates"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.newline();
        l.add("Template:");
        this.mCboDeviceTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboDeviceTemplate.setRenderer(new TemplateListRenderer());
        this.mCboDeviceTemplate.setPreferredSize(new Dimension(200, 24));
        this.mCboDeviceTemplate.setMinimumSize(new Dimension(200, 24));
        this.mCboPadTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboPadTemplate.setRenderer(new PadTemplateListRenderer());
        this.mCboPadTemplate.setMinimumSize(new Dimension(200, 24));
        this.mCboPadTemplate.setPreferredSize(new Dimension(200, 24));
        l.popNl();
        this.mPnlFromParameters = l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().indent().indent());
        l.add("Shape:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboShape = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX);
        this.mCboShape.removeAllItems();
        for (PadTemplate.PadShapeStyle shape : PadTemplate.PadShapeStyle.values()) {
            this.mCboShape.addItem(shape);
        }
        this.updateTemplates(this.mSubstrate, this.mDevType);
        this.mCboShape.addActionListener(e -> {
            this.enableControls();
            this.updatePadTemplateName();
        });
        this.mLblPadSize = l.add("Size:", (GridBagConstraints)GridBagManager.LEFT);
        l.pushFillX();
        this.mTxtPadSize = (JTextField)l.add((Component)new JTextField(5));
        this.mTxtPadSize.setText("200");
        this.mTxtPadSize2Label = l.add("x");
        this.mTxtPadSize2 = (JTextField)l.add((Component)new JTextField(5));
        this.mTxtPadSize2.setText("400");
        l.addFillX();
        l.pop();
        l.newline();
        if (this.mAllowLayerSelect) {
            l.add("Layer:");
            this.mCboLayer = (JComboBox)l.add(new JComboBox());
            this.mCboLayer.setRenderer(new LayerUI.LayerListCellRenderer());
            if (devT != null) {
                this.updateLayerList(devT);
            } else if (this.mSubstrate != null) {
                this.updateLayerList(this.mSubstrate);
            }
        }
        this.mLabelRotation = l.add("Rotation:");
        this.mTxtRotation = (JTextField)l.add((Component)new JTextField(10));
        this.mTxtRotation.setText("0.00");
        DocumentListener padSizeListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                PlaceableDefinitionUI.this.updatePadTemplateName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlaceableDefinitionUI.this.updatePadTemplateName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlaceableDefinitionUI.this.updatePadTemplateName();
            }
        };
        this.mTxtPadSize.getDocument().addDocumentListener(padSizeListener);
        this.mTxtPadSize2.getDocument().addDocumentListener(padSizeListener);
        l.pop();
        l.newline();
        l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().indent().indent());
        this.mLabelDevT = l.add("Device Template Name:", (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtDevTName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mTxtDevTName.setText("PatternDeviceTemplate");
        l.newline();
        this.mLabelPadT = l.add("Pad Template Name:", (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtPadName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mTxtPadName.setText(this.getPadTemplateName());
        l.popNl();
        this.mCboCreateFrom.addActionListener(e -> {
            this.enableControls();
            this.ownerNeedsResize();
        });
        this.mCbLimitDevTemplates.setSelected(true);
        this.mCbLimitDevTemplates.addActionListener(e -> this.updateTemplates(this.mSubstrate, this.mDevType));
        this.enableControls();
    }

    public void restrictPlaceableType(PlaceableType type) {
        this.mCboItemType.removeAll();
        this.mCboItemType.addItem(type);
    }

    public int updateTemplates(Substrate substrate, DeviceTemplate.Type devType) {
        int count = 0;
        this.mSubstrate = substrate;
        this.mDevType = devType;
        if (substrate == null) {
            return count;
        }
        switch (this.getPlaceableType()) {
            case Device: {
                Object selDevT = this.mCboDeviceTemplate.getSelectedItem();
                String limitTypeLabel = this.mCbLimitDevTemplates.getText();
                switch (this.mDevType) {
                    case DIE: 
                    case INTERPOSER: 
                    case COVER: {
                        this.mCbLimitDevTemplates.setText(limitTypeLabel.replaceFirst("to .* device", "to BUMP device"));
                        this.mCbLimitDevTemplates.setVisible(this.getCreateFrom() == CreateFrom.Template);
                        break;
                    }
                    default: {
                        this.mCbLimitDevTemplates.setVisible(false);
                    }
                }
                List<DeviceTemplate> devTs = new ArrayList();
                for (DeviceTemplate t : this.mSubstrate.getDeviceTemplates()) {
                    if (!this.includeDevT(t)) continue;
                    devTs.add(t);
                }
                devTs = AUtil.sort(devTs);
                this.mCboDeviceTemplate.setModel(new DefaultComboBoxModel<DeviceTemplate>(devTs.toArray(new DeviceTemplate[devTs.size()])));
                count = this.mCboDeviceTemplate.getItemCount();
                if (selDevT == null) break;
                this.mCboDeviceTemplate.setSelectedItem(selDevT);
                break;
            }
            case Pin: {
                Object selPadT = this.mCboPadTemplate.getSelectedItem();
                this.mCbLimitDevTemplates.setVisible(false);
                LinkedList<PadTemplate> padTemplates = new LinkedList<PadTemplate>();
                Db db = this.mPatternOwner != null ? this.mPatternOwner.getDb() : OrbitIO.getCurDb();
                for (PadTemplate t : db.getObjects(PadTemplate.class)) {
                    if (t.getSubstrate() != this.mSubstrate) continue;
                    padTemplates.add(t);
                }
                Collections.sort(padTemplates);
                this.mCboPadTemplate.setModel(new DefaultComboBoxModel<PadTemplate>(padTemplates.toArray(new PadTemplate[padTemplates.size()])));
                count = padTemplates.size();
                if (selPadT == null) break;
                this.mCboPadTemplate.setSelectedItem(selPadT);
            }
        }
        if (substrate == this.mTempSubstrate) {
            this.mCboCreateFrom.setSelectedItem((Object)CreateFrom.Params);
        }
        return count;
    }

    public void updateLayerList(DeviceTemplate devT) {
        if (!this.mAllowLayerSelect) {
            return;
        }
        this.mCboLayer.removeAllItems();
        this.mPatternOwner = devT;
        if (this.mPatternOwner == null) {
            return;
        }
        this.mSubstrate = this.mPatternOwner.getSubstrate();
        if (this.mSubstrate == null) {
            return;
        }
        LinkedList layers = AUtil.linkedList((Iterator)this.mSubstrate.getLayers());
        Collections.sort(layers);
        for (Layer layer : layers) {
            this.mCboLayer.addItem(layer);
        }
        if (this.mPatternOwner.getType() == DeviceTemplate.Type.INTERPOSER) {
            this.mCboLayer.setSelectedIndex(0);
        } else {
            this.mCboLayer.setSelectedIndex(this.mCboLayer.getItemCount() - 1);
        }
        UIUtil.setComponentEnabled(this.mCboLayer, (this.mCboLayer.getItemCount() > 0 ? 1 : 0) != 0);
    }

    public void updateLayerList(Substrate s) {
        this.mSubstrate = s;
        if (this.mCboLayer == null) {
            return;
        }
        this.mCboLayer.removeAllItems();
        if (this.mAllowLayerSelect) {
            if (s != null) {
                for (Layer l : s.getLayers(Layer.TopFirstSort)) {
                    this.mCboLayer.addItem(l);
                }
            }
            UIUtil.setComponentEnabled(this.mCboLayer, (this.mCboLayer.getItemCount() > 0 ? 1 : 0) != 0);
        }
    }

    public void updateLayerList(Substrate s, DeviceTemplate.Type type) {
        this.mSubstrate = s;
        if (this.mCboLayer != null && this.mSubstrate != null) {
            Layer prevLayer = (Layer)this.mCboLayer.getSelectedItem();
            String layerName = null;
            if (prevLayer != null) {
                layerName = prevLayer.getName();
            }
            this.mCboLayer.removeAllItems();
            if (this.mAllowLayerSelect) {
                prevLayer = null;
                for (Layer l : this.mSubstrate.getLayers(Layer.TopFirstSort)) {
                    this.mCboLayer.addItem(l);
                    if (layerName == null || layerName.compareTo(l.getName()) != 0) continue;
                    prevLayer = l;
                }
                UIUtil.setComponentEnabled(this.mCboLayer, (this.mCboLayer.getItemCount() > 0 ? 1 : 0) != 0);
                if (prevLayer != null) {
                    this.mCboLayer.setSelectedItem(prevLayer);
                }
            }
        }
    }

    public boolean includeDevT(DeviceTemplate devT) {
        if (this.mPatternOwner != null && !this.mPatternOwner.isValidParentFor(devT)) {
            return false;
        }
        switch (this.mDevType) {
            case DIE: 
            case INTERPOSER: 
            case COVER: 
            case PERSONALITY: {
                if (!this.mCbLimitDevTemplates.isSelected() || devT.getType() == DeviceTemplate.Type.BUMP) break;
                return false;
            }
        }
        return true;
    }

    public void load(BumpFactoryData bfd) {
        String strPlaceType = bfd.getPlaceableType();
        PlaceableType pt = (PlaceableType)AUtil.valueOf(PlaceableType.class, (String)strPlaceType);
        if (pt != null) {
            this.mCboItemType.setSelectedItem((Object)pt);
        }
        if (pt == PlaceableType.Pin) {
            String ptName;
            PadTemplate padT = bfd.getPadTemplate();
            if (padT == null && (ptName = bfd.getPadTemplateName()) != null && !ptName.isEmpty()) {
                padT = PadTemplate.get((Db)this.mPatternOwner.getDb(), (Substrate)this.mPatternOwner.getSubstrate(), (String)ptName);
            }
            if (padT == null) {
                this.mCboCreateFrom.setSelectedItem((Object)CreateFrom.Params);
            } else {
                this.mCboCreateFrom.setSelectedItem((Object)CreateFrom.Template);
                this.mCboPadTemplate.setSelectedItem(padT);
            }
        } else if (pt == PlaceableType.Device) {
            DeviceTemplate devT = bfd.getBumpTemplate();
            if (devT == null) {
                this.mCboCreateFrom.setSelectedItem((Object)CreateFrom.Params);
            } else {
                this.mCboCreateFrom.setSelectedItem((Object)CreateFrom.Template);
                this.mCboDeviceTemplate.setSelectedItem(devT);
            }
        }
        if (bfd.getBumpSize() != 0L) {
            if (bfd.getPadStyle().equals((Object)PadTemplate.PadShapeStyle.Circle) || bfd.getPadStyle().equals((Object)PadTemplate.PadShapeStyle.Octagon)) {
                this.mTxtPadSize.setText(this.mUnit.toUserStr(bfd.getBumpSize() * 2L));
            } else {
                this.mTxtPadSize.setText(this.mUnit.toUserStr(bfd.getBumpSize()));
            }
            if (bfd.getBumpSize2() != 0L) {
                this.mTxtPadSize2.setText(this.mUnit.toUserStr(bfd.getBumpSize2()));
            }
            if (bfd.getPadTemplateName() != null) {
                this.mTxtPadName.setText(bfd.getPadTemplateName());
            }
        }
        if (bfd.getPadStyle() != null) {
            this.setShape(bfd.getPadStyle());
        }
        if (bfd.getLayer() != null) {
            this.setLayer(bfd.getLayer());
        }
        if (bfd.getBumpTemplate() != null) {
            this.setTemplateName(bfd.getBumpTemplate().getName());
        }
        this.enableControls();
    }

    public void enableControls() {
        this.updateTemplates(this.mSubstrate, this.mDevType);
        if (this.getCreateFrom() == CreateFrom.Template && this.getTemplateCount() < 1) {
            this.setByParametric(true);
        }
        boolean placeDevices = this.getPlaceableType() == PlaceableType.Device;
        this.mCboDeviceTemplate.setVisible(placeDevices);
        boolean placePins = this.getPlaceableType() == PlaceableType.Pin;
        this.mCboPadTemplate.setVisible(placePins);
        this.mPnlFromTemplate.setVisible(this.getCreateFrom() == CreateFrom.Template);
        this.mPnlFromParameters.setVisible(this.getCreateFrom() == CreateFrom.Params);
        PadTemplate.PadShapeStyle padShapeStyle = this.getPadShapeStyle();
        boolean need2PadShapeSizes = padShapeStyle == PadTemplate.PadShapeStyle.Rect || padShapeStyle == PadTemplate.PadShapeStyle.Oblong;
        this.mTxtPadSize2Label.setVisible(need2PadShapeSizes);
        this.mTxtPadSize2.setVisible(need2PadShapeSizes);
        boolean needRot = padShapeStyle != PadTemplate.PadShapeStyle.Circle && !this.fromTemplate();
        this.mLabelRotation.setVisible(needRot);
        this.mTxtRotation.setVisible(needRot);
        if (padShapeStyle == PadTemplate.PadShapeStyle.Circle || padShapeStyle == PadTemplate.PadShapeStyle.Octagon) {
            this.mLblPadSize.setText("Diameter:");
        } else if (padShapeStyle == PadTemplate.PadShapeStyle.Rect || padShapeStyle == PadTemplate.PadShapeStyle.Oblong) {
            this.mLblPadSize.setText("Width");
            this.mTxtPadSize2Label.setText("Height");
        } else {
            this.mLblPadSize.setText("Size:");
        }
        this.mTxtDevTName.setVisible(this.getPlaceableType() == PlaceableType.Device && this.getCreateFrom() == CreateFrom.Params);
        this.mLabelDevT.setVisible(this.mTxtDevTName.isVisible());
        this.mTxtPadName.setVisible(this.getCreateFrom() == CreateFrom.Params);
        this.mLabelPadT.setVisible(this.mTxtPadName.isVisible());
    }

    public boolean hasValidBumpSetting() {
        boolean validBumpSetting = true;
        if (this.getCreateFrom() == CreateFrom.Template) {
            switch (this.getPlaceableType()) {
                case Device: {
                    if (this.mCboDeviceTemplate.getSelectedItem() instanceof DeviceTemplate) break;
                    validBumpSetting = false;
                    break;
                }
                case Pin: {
                    if (this.mCboPadTemplate.getSelectedItem() instanceof PadTemplate) break;
                    validBumpSetting = false;
                }
            }
        } else {
            if (!this.validDoubleGreaterThan0(this.mTxtPadSize)) {
                validBumpSetting = false;
            }
            if (this.getPadShapeStyle() == PadTemplate.PadShapeStyle.Rect && !this.validDoubleGreaterThan0(this.mTxtPadSize2)) {
                validBumpSetting = false;
            }
        }
        return validBumpSetting;
    }

    public void validateSettings() throws AFieldValidator.AFieldValidationException {
        if (this.getCreateFrom() == CreateFrom.Template) {
            switch (this.getPlaceableType()) {
                case Device: {
                    if (this.mCboDeviceTemplate.getSelectedItem() instanceof DeviceTemplate) break;
                    throw AFieldValidator.createException(null, (String)"Bump Template", null, this.mCboDeviceTemplate);
                }
                case Pin: {
                    if (this.mCboPadTemplate.getSelectedItem() instanceof PadTemplate) break;
                    throw AFieldValidator.createException(null, (String)"Pad Template", null, this.mCboPadTemplate);
                }
            }
        } else {
            AFieldValidator.validateDouble((JTextField)this.mTxtPadSize);
            if (this.getPadShapeStyle() == PadTemplate.PadShapeStyle.Rect && !this.validDoubleGreaterThan0(this.mTxtPadSize2)) {
                AFieldValidator.validateDouble((JTextField)this.mTxtPadSize2);
            }
            if (this.getPadShapeStyle() != PadTemplate.PadShapeStyle.Circle) {
                AFieldValidator.validateDouble((JTextField)this.mTxtRotation);
            }
            if (this.mAllowLayerSelect && this.mCboLayer.isEnabled() && !(this.mCboLayer.getSelectedItem() instanceof Layer)) {
                throw AFieldValidator.createException(null, (String)"Layer", null, this.mCboLayer);
            }
            if (!this.validPadTemplateName()) {
                throw AFieldValidator.createException((String)"a pad template with the specified name already exists", (String)"Pad Template Name", null, (Component)this.mTxtPadName);
            }
            if (!this.validDeviceTemplateName()) {
                throw AFieldValidator.createException((String)"a device template with the specified name already exists", (String)"Device Template Name", null, (Component)this.mTxtDevTName);
            }
        }
    }

    public CreateFrom getCreateFrom() {
        return (CreateFrom)((Object)this.mCboCreateFrom.getSelectedItem());
    }

    public boolean fromTemplate() {
        return (CreateFrom)((Object)this.mCboCreateFrom.getSelectedItem()) == CreateFrom.Template;
    }

    public PlaceableType getPlaceableType() {
        return (PlaceableType)((Object)this.mCboItemType.getSelectedItem());
    }

    public void setPlaceableType(PlaceableType type) {
        if (this.getPlaceableType() != type) {
            this.mCboItemType.setSelectedItem((Object)type);
        }
    }

    public Unit getUnit() {
        return this.mUnit;
    }

    public String getSizeStr(Unit unit) {
        return String.format("%dL", unit.fromUserString(this.mTxtPadSize.getText()));
    }

    public String getShapeName() {
        return this.getShape().name();
    }

    public void setShapeName(String val) {
        this.mCboShape.setSelectedItem(val);
    }

    public double getRotation() {
        double rot = 0.0;
        try {
            rot = AUtil.floatFromString((String)AFieldValidator.validateFloat((JTextField)this.mTxtRotation));
        }
        catch (AFieldValidator.AFieldValidationException ve) {
            ALog.logError((Throwable)ve);
        }
        return rot;
    }

    public PadTemplate.PadShapeStyle getShape() {
        return (PadTemplate.PadShapeStyle)this.mCboShape.getSelectedItem();
    }

    public String getSize2Str(Unit unit) {
        return String.format("%dL", unit.fromUserString(this.mTxtPadSize2.getText()));
    }

    public int getTemplateCount() {
        switch (this.getPlaceableType()) {
            case Device: {
                return this.mCboDeviceTemplate.getItemCount();
            }
            case Pin: {
                return this.mCboPadTemplate.getItemCount();
            }
        }
        assert (false);
        return 0;
    }

    public Substrate getTempSubstrate() {
        return this.mTempSubstrate;
    }

    public String getTemplateName() {
        switch (this.getPlaceableType()) {
            case Device: {
                DeviceTemplate bumpTmplt = (DeviceTemplate)this.mCboDeviceTemplate.getSelectedItem();
                return bumpTmplt.getName();
            }
            case Pin: {
                PadTemplate padTmplt = (PadTemplate)this.mCboPadTemplate.getSelectedItem();
                return padTmplt.getName();
            }
        }
        assert (false);
        return null;
    }

    public void setTemplateName(String val) {
        switch (this.getPlaceableType()) {
            case Device: {
                this.mCboDeviceTemplate.setSelectedItem(val);
                break;
            }
            case Pin: {
                this.mCboPadTemplate.setSelectedItem(val);
            }
        }
    }

    public String getPinDeviceTemplateName() {
        return this.mTxtDevTName.getText();
    }

    public String getPinPadTemplateName() {
        return this.mTxtPadName.getText();
    }

    public String getLayerName() {
        Layer layer = this.mAllowLayerSelect ? (Layer)this.mCboLayer.getSelectedItem() : null;
        return layer == null ? "null" : String.format("\"%s\"", layer.getName());
    }

    public void setLayer(Layer layer) {
        if (this.mAllowLayerSelect) {
            this.mCboLayer.setSelectedItem(layer);
        }
    }

    public PadTemplate.PadShapeStyle getPadShapeStyle() {
        return (PadTemplate.PadShapeStyle)this.mCboShape.getSelectedItem();
    }

    public void setShape(PadTemplate.PadShapeStyle val) {
        this.mCboShape.setSelectedItem(val);
    }

    public void setByParametric(boolean state) {
        this.mCboCreateFrom.setSelectedItem((Object)(state ? CreateFrom.Params : CreateFrom.Template));
    }

    public String getGeomParam() {
        long size = this.mUnit.fromUserString(this.mTxtPadSize.getText());
        long size2 = this.mUnit.fromUserString(this.mTxtPadSize2.getText()) / 2L;
        return PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)((PadTemplate.PadShapeStyle)this.mCboShape.getSelectedItem()), (Object[])new Object[]{size, size2}).getAsStringArg();
    }

    public String[] getFactoryCreationCmds() {
        switch (this.getPlaceableType()) {
            case Device: {
                if (this.getCreateFrom() == CreateFrom.Template) {
                    return new String[]{String.format("\tDeviceTemplate devT = curDb().getByKeyStr(DeviceTemplate.class, \"%s\");\n", ((DbObject)this.mCboDeviceTemplate.getSelectedItem()).getKeyStr()), String.format("\tnew %s(devT);", PlaceableDevice.DeviceFromTemplateFactory.class.getName())};
                }
                return new String[]{String.format("\tSubstrate subs = curDb().getByKeyStr(Substrate.class, \"%s\");\n", this.mPatternOwner.getSubstrate().getKeyStr()), String.format("\t%s lsp = new %s(%s, %s);\n", LayerShapeParameters.class.getName(), LayerShapeParameters.class.getName(), this.getGeomParam(), this.getLayerName()), String.format("\tnew %s(subs, lsp, \"%s\", \"%s\");", PlaceableDevice.DeviceFromParametersFactory.class.getName(), this.mTxtPadName.getText(), this.mTxtDevTName.getText())};
            }
            case Pin: {
                if (this.getCreateFrom() == CreateFrom.Template) {
                    return new String[]{String.format("\tPadTemplate padT = curDb().getByKeyStr(PadTemplate.class, \"%s\");\n", ((DbObject)this.mCboPadTemplate.getSelectedItem()).getKeyStr()), String.format("\tnew %s(padT);", PlaceablePin.PinFromTemplateFactory.class.getName())};
                }
                return new String[]{String.format("\tSubstrate subs = curDb().getByKeyStr(Substrate.class, \"%s\");\n", this.mPatternOwner.getSubstrate().getKeyStr()), String.format("\t%s lsp = new %s(%s, %s);\n", LayerShapeParameters.class.getName(), LayerShapeParameters.class.getName(), this.getGeomParam(), this.getLayerName()), String.format("\tnew %s(subs, lsp, \"%s\");", PlaceablePin.PinFromParametersFactory.class.getName(), this.mTxtPadName.getText())};
            }
        }
        assert (false);
        return null;
    }

    protected boolean validDoubleGreaterThan0(JTextField f) {
        String s = f.getText();
        try {
            NumberFormat nf = NumberFormat.getNumberInstance();
            Number n = nf.parse(s);
            if (n.doubleValue() <= 0.0) {
                if (f.isEnabled()) {
                    f.setBackground(Color.RED);
                } else {
                    f.setBackground(Color.pink);
                }
                return false;
            }
            f.setBackground(Color.WHITE);
            return true;
        }
        catch (ParseException e) {
            if (f.isEnabled()) {
                f.setBackground(Color.RED);
            } else {
                f.setBackground(Color.pink);
            }
            return false;
        }
    }

    protected void ownerNeedsResize() {
        Window w = UIUtil.getParentWindow((Component)this);
        if (w != null) {
            w.invalidate();
            w.pack();
        }
    }

    protected String getPadTemplateName() {
        String base;
        String name = base = String.format("%s%s%s", this.mCboShape.getSelectedItem().toString(), this.mTxtPadSize.getText(), this.getPadShapeStyle() == PadTemplate.PadShapeStyle.Rect ? "x" + this.mTxtPadSize2.getText() : "");
        long suffix = 1L;
        if (this.mPatternOwner != null) {
            while (PadTemplate.get((Db)this.mPatternOwner.getDb(), (Substrate)this.mPatternOwner.getSubstrate(), (String)name) != null) {
                name = String.format("%s-%d", base, suffix++);
            }
        }
        return name;
    }

    protected void updatePadTemplateName() {
        if (!AFieldValidator.isValidDouble((String)this.mTxtPadSize.getText())) {
            return;
        }
        if (this.getPadShapeStyle() == PadTemplate.PadShapeStyle.Rect && !AFieldValidator.isValidDouble((String)this.mTxtPadSize2.getText())) {
            return;
        }
        String name = this.getPadTemplateName();
        if (!this.mTxtPadName.getText().equals(name)) {
            this.mTxtPadName.setText(name);
        }
    }

    protected boolean validPadTemplateName() {
        Db db = this.mPatternOwner != null ? this.mPatternOwner.getDb() : OrbitIO.getCurDb();
        Substrate s = this.mPatternOwner != null ? this.mPatternOwner.getSubstrate() : null;
        return PadTemplate.get((Db)db, (Substrate)s, (String)this.mTxtPadName.getText()) == null;
    }

    protected boolean validDeviceTemplateName() {
        return DeviceTemplate.get((Db)(this.mPatternOwner != null ? this.mPatternOwner.getDb() : OrbitIO.getCurDb()), (String)(this.mSubstrate == null ? null : this.mSubstrate.getName()), (String)this.mTxtDevTName.getText()) == null;
    }

    protected static enum CreateFrom {
        Template,
        Params;

    }

    public static enum PlaceableType {
        Device,
        Pin;

    }
}

