/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.placement;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.automation.placement.LayerShapeParameters;
import com.sigrity.orbit.automation.placement.PlaceableFactory;
import com.sigrity.orbit.automation.placement.PlaceableItem;
import java.util.Collection;
import java.util.Iterator;

public class PlaceableDevice
implements PlaceableItem<Device> {
    protected Device mDevice;

    public PlaceableDevice(Device d) {
        this.mDevice = d;
    }

    @Override
    public void place(APoint2D loc, float rotation, boolean mirror) {
        this.mDevice.setLoc(loc);
        this.mDevice.setRotate(rotation);
        this.mDevice.setMirror(mirror);
    }

    @Override
    public APoint2D getLoc() {
        return this.mDevice.getLoc();
    }

    @Override
    public float getRot() {
        return this.mDevice.getRotate();
    }

    @Override
    public boolean getMirror() {
        return this.mDevice.getMirror();
    }

    @Override
    public Device getDbObject() {
        return this.mDevice;
    }

    @Override
    public PinTemplate getConnectionPin() {
        return (PinTemplate)AUtil.findBest((Collection)AUtil.linkedList((Iterator)this.mDevice.getTemplate().getPins()), (AUtil.BetterComparator)new AUtil.BetterComparator<PinTemplate>(){

            public boolean better(PinTemplate candidate, PinTemplate currentBest) {
                return candidate.getName().compareTo(currentBest.getName()) < 0;
            }
        });
    }

    @Override
    public String getName() {
        return this.mDevice.getName();
    }

    public static class DeviceFromTemplateFactory
    implements PlaceableFactory<Device> {
        protected DeviceTemplate mTemplate;

        public DeviceFromTemplateFactory(DeviceTemplate devT) {
            this.mTemplate = devT;
        }

        @Override
        public PlaceableItem<Device> create(DeviceTemplate parent, String name, DeviceTemplate.Type type) {
            String n = Device.getUniqueName((DeviceTemplate)parent, (String)name);
            Device device = Device.create((Db)this.mTemplate.getDb(), (String)n, (DeviceTemplate)this.mTemplate, (DeviceTemplate)parent);
            return new PlaceableDevice(device);
        }

        @Override
        public ARect getItemBounds() {
            return this.mTemplate.getBB();
        }

        @Override
        public String getItemDescription() {
            return "device";
        }

        @Override
        public void storeParameters(BumpFactoryData bfd) {
            bfd.setPlaceableType("Device");
            bfd.setBumpTemplate(this.mTemplate);
        }

        @Override
        public IterableIterator<PlaceableItem<Device>> getPlacedItems(DeviceTemplate parent) {
            return new ProcessingIterator<Device, PlaceableItem<Device>>((Iterator)parent.getChildren()){

                protected PlaceableItem<Device> process(Device d) {
                    if (Boolean.TRUE.equals(d.getValue("DeviceMatrixFactory.created", Boolean.class))) {
                        return new PlaceableDevice(d);
                    }
                    return null;
                }
            };
        }
    }

    public static class DeviceFromParametersFactory
    implements PlaceableFactory<Device> {
        protected Substrate mSubstrate;
        protected LayerShapeParameters mLayerShapeParams;
        protected DeviceTemplate mTemplate = null;
        protected String mPadTemplateName = null;
        protected String mDevTemplateName = null;

        public DeviceFromParametersFactory(Substrate substrate, LayerShapeParameters shapeParams) {
            this(substrate, shapeParams, null);
        }

        public DeviceFromParametersFactory(Substrate substrate, LayerShapeParameters shapeParams, String padName) {
            this(substrate, shapeParams, padName, "PatternDeviceTemplate");
        }

        public DeviceFromParametersFactory(Substrate substrate, LayerShapeParameters shapeParams, String padName, String devTName) {
            this.mSubstrate = substrate;
            this.mLayerShapeParams = shapeParams;
            this.mPadTemplateName = padName;
            this.mDevTemplateName = devTName;
        }

        @Override
        public PlaceableItem<Device> create(DeviceTemplate parent, String name, DeviceTemplate.Type type) {
            if (this.mTemplate == null) {
                PadTemplate padT = null;
                padT = this.mPadTemplateName == null ? PadTemplate.create((Db)this.mSubstrate.getDb(), (Substrate)this.mSubstrate, (String)String.format("Pad%s", this.mLayerShapeParams.getShape().getClass().getSimpleName())) : PadTemplate.create((Db)this.mSubstrate.getDb(), (Substrate)this.mSubstrate, (String)this.mPadTemplateName);
                Layer layer = this.mSubstrate.getLayer(this.mLayerShapeParams.getLayerName());
                LayerShape.create((Db)parent.getDb(), (Layer)layer, (DbObject)padT, (AGeom)this.mLayerShapeParams.getShape());
                this.mTemplate = DeviceTemplate.create((Substrate)this.mSubstrate, (String)this.mDevTemplateName, (boolean)true);
                this.mTemplate.setSourceType(DeviceTemplate.SourceType.USER);
                this.mTemplate.setBounds((AGeom)this.mLayerShapeParams.mShape.getBounds());
                this.mTemplate.setIsSynthesized(true);
                PinTemplate dtp = PinTemplate.create((Net)this.mTemplate.getNetUnused(), (String)"Pin");
                dtp.setPadTemplate(padT);
                dtp.setLoc(new APoint2D(0L, 0L));
                switch (type) {
                    case PACKAGE: {
                        dtp.setType(PinTemplate.Type.BALLPAD);
                        break;
                    }
                    default: {
                        this.mTemplate.setType(DeviceTemplate.Type.BUMP);
                        dtp.setType(PinTemplate.Type.BUMPPAD);
                    }
                }
            }
            Device d = Device.create((String)name, (DeviceTemplate)this.mTemplate, (DeviceTemplate)parent);
            return new PlaceableDevice(d);
        }

        @Override
        public ARect getItemBounds() {
            return this.mLayerShapeParams.mShape.getBounds();
        }

        @Override
        public String getItemDescription() {
            return "device";
        }

        @Override
        public void storeParameters(BumpFactoryData bfd) {
            bfd.setPlaceableType("Device");
            this.mLayerShapeParams.store(bfd, this.mSubstrate);
            bfd.setPadTemplateName(this.mPadTemplateName);
            bfd.setBumpTemplate(this.mTemplate);
        }

        @Override
        public IterableIterator<PlaceableItem<Device>> getPlacedItems(DeviceTemplate parent) {
            return new ProcessingIterator<Device, PlaceableItem<Device>>((Iterator)parent.getChildren()){

                protected PlaceableItem<Device> process(Device d) {
                    if (Boolean.TRUE.equals(d.getValue("DeviceMatrixFactory.created", Boolean.class))) {
                        return new PlaceableDevice(d);
                    }
                    return null;
                }
            };
        }
    }
}

