/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.placement;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.automation.placement.LayerShapeParameters;
import com.sigrity.orbit.automation.placement.PlaceableFactory;
import com.sigrity.orbit.automation.placement.PlaceableItem;
import java.util.Iterator;

public class PlaceablePin
implements PlaceableItem<PinTemplate> {
    protected PinTemplate mPin;

    public PlaceablePin(PinTemplate pin) {
        this.mPin = pin;
    }

    @Override
    public void place(APoint2D loc, float rotation, boolean mirror) {
        this.mPin.setLoc(loc);
        this.mPin.setRotate(rotation);
        this.mPin.setMirror(mirror);
    }

    @Override
    public APoint2D getLoc() {
        return this.mPin.getLoc();
    }

    @Override
    public float getRot() {
        return this.mPin.getRotate();
    }

    @Override
    public boolean getMirror() {
        return this.mPin.getMirror();
    }

    @Override
    public PinTemplate getDbObject() {
        return this.mPin;
    }

    @Override
    public PinTemplate getConnectionPin() {
        return this.mPin;
    }

    @Override
    public String getName() {
        return this.mPin.getName();
    }

    public static class PinFromTemplateFactory
    implements PlaceableFactory<PinTemplate> {
        protected PadTemplate mPadTemplate;

        public PinFromTemplateFactory(PadTemplate padT) {
            assert (padT != null);
            this.mPadTemplate = padT;
        }

        @Override
        public PlaceableItem<PinTemplate> create(DeviceTemplate parent, String name, DeviceTemplate.Type type) {
            PinTemplate pinT = PinTemplate.create((Net)parent.getNetUnused(), (String)name);
            assert (this.mPadTemplate != null);
            pinT.setPadTemplate(this.mPadTemplate);
            switch (type) {
                case PACKAGE: {
                    pinT.setType(PinTemplate.Type.BALLPAD);
                    break;
                }
                default: {
                    pinT.setType(PinTemplate.Type.BUMPPAD);
                }
            }
            pinT.createPinInstances();
            return new PlaceablePin(pinT);
        }

        @Override
        public ARect getItemBounds() {
            return this.mPadTemplate.getBB(null);
        }

        @Override
        public String getItemDescription() {
            return "pin";
        }

        @Override
        public void storeParameters(BumpFactoryData bfd) {
            bfd.setPlaceableType("Pin");
            bfd.setPadTemplate(this.mPadTemplate);
        }

        @Override
        public IterableIterator<PlaceableItem<PinTemplate>> getPlacedItems(DeviceTemplate parent) {
            return new ProcessingIterator<PinTemplate, PlaceableItem<PinTemplate>>((Iterator)parent.getPins()){

                protected PlaceableItem<PinTemplate> process(PinTemplate p) {
                    if (Boolean.TRUE.equals(p.getValue("DeviceMatrixFactory.created", Boolean.class))) {
                        return new PlaceablePin(p);
                    }
                    return null;
                }
            };
        }
    }

    public static class PinFromParametersFactory
    implements PlaceableFactory<PinTemplate> {
        protected Substrate mSubstrate;
        protected LayerShapeParameters mLayerShapeParams;
        protected PadTemplate mPadTemplate = null;
        protected String mPadTemplateName = null;

        public PinFromParametersFactory(Substrate substrate, LayerShapeParameters shapeParams) {
            this.mSubstrate = substrate;
            this.mLayerShapeParams = shapeParams;
        }

        public PinFromParametersFactory(Substrate substrate, LayerShapeParameters shapeParams, String padName) {
            this.mSubstrate = substrate;
            this.mLayerShapeParams = shapeParams;
            this.mPadTemplateName = padName;
        }

        @Override
        public PlaceableItem<PinTemplate> create(DeviceTemplate parent, String name, DeviceTemplate.Type type) {
            if (this.mPadTemplate == null) {
                this.mPadTemplate = this.mPadTemplateName == null ? PadTemplate.create((Db)this.mSubstrate.getDb(), (Substrate)this.mSubstrate, (String)String.format("Pad%s", this.mLayerShapeParams.getShape().getClass().getSimpleName())) : PadTemplate.create((Db)this.mSubstrate.getDb(), (Substrate)this.mSubstrate, (String)this.mPadTemplateName);
                Layer layer = this.mSubstrate.getLayer(this.mLayerShapeParams.getLayerName());
                if (layer == null) {
                    layer = Layer.create((Substrate)this.mSubstrate, (String)this.mLayerShapeParams.getLayerName());
                    ALog.logWarn((String)"Cannot find given layer name, create '%s' automatically", (Object[])new Object[]{layer});
                }
                LayerShape.create((Db)parent.getDb(), (Layer)layer, (DbObject)this.mPadTemplate, (AGeom)this.mLayerShapeParams.getShape());
            }
            PinTemplate pinT = PinTemplate.create((Net)parent.getNetUnused(), (String)name);
            pinT.setPadTemplate(this.mPadTemplate);
            switch (type) {
                case PACKAGE: {
                    pinT.setType(PinTemplate.Type.BALLPAD);
                    break;
                }
                default: {
                    pinT.setType(PinTemplate.Type.BUMPPAD);
                }
            }
            pinT.createPinInstances();
            return new PlaceablePin(pinT);
        }

        @Override
        public ARect getItemBounds() {
            return this.mLayerShapeParams.getShape().getBounds();
        }

        @Override
        public String getItemDescription() {
            return "pin";
        }

        @Override
        public void storeParameters(BumpFactoryData bfd) {
            bfd.setPlaceableType("Pin");
            this.mLayerShapeParams.store(bfd, this.mSubstrate);
            bfd.setPadTemplateName(this.mPadTemplateName);
        }

        @Override
        public IterableIterator<PlaceableItem<PinTemplate>> getPlacedItems(DeviceTemplate parent) {
            return new ProcessingIterator<PinTemplate, PlaceableItem<PinTemplate>>((Iterator)parent.getPins()){

                protected PlaceableItem<PinTemplate> process(PinTemplate p) {
                    if (Boolean.TRUE.equals(p.getValue("DeviceMatrixFactory.created", Boolean.class))) {
                        return new PlaceablePin(p);
                    }
                    return null;
                }
            };
        }
    }
}

