/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.BundleRakeUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.AbstractPin;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class BundleRakeFactory {
    static final String[] RAKE_PATTERN = new String[]{"External Side", "Internal Side", "Balance", "Left Side", "Right Side"};

    public static String[] getSorter(String name) {
        if (name.equals("External Side")) {
            return new String[]{"mirror", "center_first", "row_outside"};
        }
        if (name.equals("Internal Side")) {
            return new String[]{"mirror", "center_first", "row_inside"};
        }
        if (name.equals("Balance")) {
            return new String[]{"mirror", "center_first", "row_balance"};
        }
        if (name.equals("Left Side")) {
            return new String[]{"row_oneside_l"};
        }
        if (name.equals("Right Side")) {
            return new String[]{"row_oneside_r"};
        }
        return null;
    }

    public static void rake(Db db, String bundleKeyStr, boolean isFixedSide, String rakePatternName, boolean minRakeWidthFlag, String alignName) {
        InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        bundle.setOptimizedPattern(true);
        ibr.mBundle = bundle;
        ibr.loadPreSchedConnFromBundle();
        ibr.mFromPattern = bundle.getRakePattern(true);
        ibr.mToPattern = bundle.getRakePattern(false);
        ibr.mLayerList.clear();
        bundle.getLayers().stream().forEach(l -> ibr.mLayerList.add((Layer)l));
        ArrayList<AbstractPin> pins = new ArrayList<AbstractPin>();
        APair locs = bundle.getBundleFFPins(isFixedSide);
        ArrayList pts = bundle.getRakePattern(isFixedSide);
        if (pts == null || pts.size() < 2) {
            return;
        }
        ALine mySeqBar = BundleRakeUtil.getSeqBar((Bundle)bundle, (boolean)isFixedSide, (APoint2D)(isFixedSide ? bundle.getPath().getFirstPoint() : bundle.getPath().getLastPoint()), (List)((List)locs.first));
        String[] sortOrder = BundleRakeFactory.getSorter(rakePatternName);
        if (sortOrder != null) {
            BundleRakeFactory.activeSort(ibr.mActive, mySeqBar, sortOrder, isFixedSide);
        }
        for (InteractiveBundleCreator.PreSchedConn psc : ibr.mActive) {
            pins.add(isFixedSide ? psc.from : psc.to);
        }
        ArrayList pattern = BundleRakeUtil.derivePatternBySequence((Bundle)bundle, pins, (boolean)isFixedSide, (ALine)mySeqBar, (boolean)minRakeWidthFlag, (boolean)alignName.equals("Path Center"));
        if (isFixedSide) {
            ibr.mFromPattern = pattern;
        } else {
            ibr.mToPattern = pattern;
        }
        if (alignName.equals("Rake Center")) {
            long x = 0L;
            long y = 0L;
            for (APoint2D pt : pattern) {
                x += pt.getX();
                y += pt.getY();
            }
            x /= (long)pattern.size();
            y /= (long)pattern.size();
            APath path = ibr.mBundle.getPath().copy();
            if (isFixedSide) {
                path.setFirst(new APoint2D(x, y));
            } else {
                path.setLast(new APoint2D(x, y));
            }
            ibr.mBundle.setPath(path);
        }
        DbHistory history = db.getHistory();
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Editing Rake Pattern");){
            ibr.addBundleToDb();
        }
    }

    static APoint2D conserveProjectToLine(ALine line, APoint2D pt) {
        if (line.getP0().getX() == line.getP1().getX()) {
            return new APoint2D(line.getP0().getX(), pt.getY());
        }
        if (line.getP0().getY() == line.getP1().getY()) {
            return new APoint2D(pt.getX(), line.getP0().getY());
        }
        return line.shortest(pt, false).getP1();
    }

    static ALine conserveShortestSegment(ALine line, APoint2D pt) {
        if (line.getP0().getX() == line.getP1().getX()) {
            return new ALine(pt, new APoint2D(line.getP0().getX(), pt.getY()));
        }
        if (line.getP0().getY() == line.getP1().getY()) {
            return new ALine(pt, new APoint2D(pt.getX(), line.getP0().getY()));
        }
        return line.shortest(pt, false);
    }

    public static void activeSort(List<InteractiveBundleCreator.PreSchedConn> active, ALine mySeqBar, String[] types, boolean isFixedSide) {
        if (active == null || active.isEmpty()) {
            return;
        }
        long x = 0L;
        long y = 0L;
        active = active.stream().filter(preSc -> isFixedSide ? preSc.from != null : preSc.to != null).collect(Collectors.toCollection(ArrayList::new));
        for (InteractiveBundleCreator.PreSchedConn s : active) {
            AbstractPin pin = isFixedSide ? s.from : s.to;
            x += pin.loc.getX();
            y += pin.loc.getY();
        }
        APoint2D center = new APoint2D(x / (long)active.size(), y / (long)active.size());
        ALine centerLine = BundleRakeFactory.conserveShortestSegment(mySeqBar, center);
        ArrayList<Comparator<AbstractPin>> order = new ArrayList<Comparator<AbstractPin>>();
        int row_type = 0;
        boolean hasMirror = false;
        for (String s : types) {
            if (s.equals("mirror")) {
                hasMirror = true;
                order.add(new MirrorCompare(center, mySeqBar));
                continue;
            }
            if (s.equals("center_first")) {
                order.add(new CenterDistCompare(center, mySeqBar, true));
                continue;
            }
            if (s.equals("center_last")) {
                order.add(new CenterDistCompare(center, mySeqBar, false));
                continue;
            }
            if (s.equals("row_balance")) {
                row_type = 1;
                continue;
            }
            if (s.equals("row_outside") || s.equals("row_oneside_l")) {
                row_type = 0;
                continue;
            }
            if (!s.equals("row_inside") && !s.equals("row_oneside_r")) continue;
            row_type = 2;
        }
        if (order.size() == 0) {
            order.add(new DistCompare(center, mySeqBar));
        }
        CompositeCompare cmp = new CompositeCompare(order);
        Collections.sort(active, (o1, o2) -> isFixedSide ? cmp.compare(o1.from, o2.from) : cmp.compare(o1.to, o2.to));
        FarthestCompare distCmp = new FarthestCompare(mySeqBar);
        for (int i = 0; i < active.size(); ++i) {
            int k;
            int j;
            int r;
            AbstractPin pin = isFixedSide ? ((InteractiveBundleCreator.PreSchedConn)active.get((int)i)).from : ((InteractiveBundleCreator.PreSchedConn)active.get((int)i)).to;
            long dist = BundleRakeFactory.distanceToBar(pin.loc, centerLine);
            ArrayList<InteractiveBundleCreator.PreSchedConn> pins = new ArrayList<InteractiveBundleCreator.PreSchedConn>();
            pins.add((InteractiveBundleCreator.PreSchedConn)active.get(i));
            int l = i;
            for (r = i + 1; r < active.size(); ++r) {
                AbstractPin abstractPin = pin = isFixedSide ? ((InteractiveBundleCreator.PreSchedConn)active.get((int)r)).from : ((InteractiveBundleCreator.PreSchedConn)active.get((int)r)).to;
                if (dist != BundleRakeFactory.distanceToBar(pin.loc, centerLine)) break;
                pins.add((InteractiveBundleCreator.PreSchedConn)active.get(r));
            }
            Collections.sort(pins, (o1, o2) -> isFixedSide ? distCmp.compare(o1.from, o2.from) : distCmp.compare(o1.to, o2.to));
            if (row_type == 0) {
                if (hasMirror && dist < 0L) {
                    Collections.reverse(pins);
                }
                j = l;
                k = 0;
                while (j < r) {
                    active.set(j, (InteractiveBundleCreator.PreSchedConn)pins.get(k));
                    ++j;
                    ++k;
                }
            } else if (row_type == 1) {
                int head = 0;
                int tail = pins.size() - 1;
                int alter_flag = 0;
                if (hasMirror && dist < 0L) {
                    alter_flag = 1;
                }
                for (int k2 = 0; k2 < pins.size(); ++k2) {
                    if (alter_flag == 0) {
                        active.set(head + l, (InteractiveBundleCreator.PreSchedConn)pins.get(k2));
                        ++head;
                    } else {
                        active.set(tail + l, (InteractiveBundleCreator.PreSchedConn)pins.get(k2));
                        --tail;
                    }
                    alter_flag = 1 - alter_flag;
                }
            } else if (row_type == 2) {
                Collections.reverse(pins);
                if (hasMirror && dist < 0L) {
                    Collections.reverse(pins);
                }
                j = l;
                k = 0;
                while (j < r) {
                    active.set(j, (InteractiveBundleCreator.PreSchedConn)pins.get(k));
                    ++j;
                    ++k;
                }
            }
            i = r - 1;
        }
        if (!isFixedSide) {
            Collections.reverse(active);
        }
    }

    private static long distanceToBar(APoint2D pt, ALine line) {
        long dist = BundleRakeFactory.conserveShortestSegment(line, pt).getLength();
        if (APoint2D.winding((APoint2D)line.getP0(), (APoint2D)line.getP1(), (APoint2D)pt) < 0.0) {
            dist = -dist;
        }
        return dist;
    }

    private static class FarthestCompare
    implements Comparator<AbstractPin> {
        ALine mSeqbar;

        public FarthestCompare(ALine seqBar) {
            this.mSeqbar = seqBar;
        }

        @Override
        public int compare(AbstractPin o1, AbstractPin o2) {
            long d1 = BundleRakeFactory.conserveShortestSegment(this.mSeqbar, o1.loc).getLength();
            long d2 = BundleRakeFactory.conserveShortestSegment(this.mSeqbar, o2.loc).getLength();
            return Long.compare(d2, d1);
        }
    }

    private static class CenterDistCompare
    implements Comparator<AbstractPin> {
        ALine mCenterLine;
        boolean mCenterFirst;

        public CenterDistCompare(APoint2D center, ALine seqBar, boolean centerFirst) {
            this.mCenterLine = seqBar.shortest(center, false);
            this.mCenterFirst = centerFirst;
        }

        @Override
        public int compare(AbstractPin o1, AbstractPin o2) {
            APoint2D p1 = o1.loc;
            APoint2D p2 = o2.loc;
            long l1 = BundleRakeFactory.conserveShortestSegment(this.mCenterLine, p1).getLength();
            long l2 = BundleRakeFactory.conserveShortestSegment(this.mCenterLine, p2).getLength();
            int ret = Long.compare(l1, l2);
            if (this.mCenterFirst) {
                ret = -ret;
            }
            return ret;
        }
    }

    private static class DistCompare
    implements Comparator<AbstractPin> {
        ALine mCenterLine;

        public DistCompare(APoint2D center, ALine seqBar) {
            this.mCenterLine = BundleRakeFactory.conserveShortestSegment(seqBar, center);
        }

        @Override
        public int compare(AbstractPin o1, AbstractPin o2) {
            APoint2D p1 = o1.loc;
            APoint2D p2 = o2.loc;
            long d1 = BundleRakeFactory.distanceToBar(p1, this.mCenterLine);
            long d2 = BundleRakeFactory.distanceToBar(p2, this.mCenterLine);
            return -Long.compare(d1, d2);
        }
    }

    private static class MirrorCompare
    implements Comparator<AbstractPin> {
        ALine mCenterLine;

        public MirrorCompare(APoint2D center, ALine seqBar) {
            this.mCenterLine = BundleRakeFactory.conserveShortestSegment(seqBar, center);
        }

        @Override
        public int compare(AbstractPin o1, AbstractPin o2) {
            APoint2D p1 = o1.loc;
            APoint2D p2 = o2.loc;
            double c1 = APoint2D.winding((APoint2D)this.mCenterLine.getP0(), (APoint2D)this.mCenterLine.getP1(), (APoint2D)p1);
            double c2 = APoint2D.winding((APoint2D)this.mCenterLine.getP0(), (APoint2D)this.mCenterLine.getP1(), (APoint2D)p2);
            return -Double.compare(c1, c2);
        }
    }

    private static class CompositeCompare
    implements Comparator<AbstractPin> {
        ArrayList<Comparator<AbstractPin>> order;

        public CompositeCompare(ArrayList<Comparator<AbstractPin>> v) {
            assert (v.size() > 0);
            this.order = new ArrayList<Comparator<AbstractPin>>(v);
        }

        @Override
        public int compare(AbstractPin o1, AbstractPin o2) {
            for (Comparator<AbstractPin> cmp : this.order) {
                int ret = cmp.compare(o1, o2);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }
}

