/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.APair;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.BundleRakeUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.BundleRakeFactory;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.ui.BundleUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BundleRakeUI {
    static final String DEFAULT_PATTERN = "Default";
    static final String[] ALIGNMENT = new String[]{"Default", "Path Center", "Rake Center"};
    private static JPanel mPreferencePanel = null;
    protected static ButtonGroup mPatternBtnGroup;
    protected static ButtonGroup mAlignGroup;
    protected static JCheckBox mMinRakeWidth;
    static BundleRakeDlg mLastDialog;

    public static JPanel createBundleRakePanel(JDialog owner) {
        if (mPreferencePanel != null) {
            return mPreferencePanel;
        }
        mPreferencePanel = new JPanel();
        GridBagManager GB = new GridBagManager((Container)mPreferencePanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        GridBagConstraints gridFillCS = new GridBagConstraints();
        gridFillCS.fill = 2;
        gridFillCS.insets = new Insets(2, 4, 2, 4);
        GridBagConstraints gridFillCS2 = (GridBagConstraints)gridFillCS.clone();
        gridFillCS2.gridwidth = 2;
        GridBagConstraints gridLeft = new GridBagConstraints();
        gridLeft.anchor = 17;
        gridLeft.fill = 1;
        gridLeft.weightx = 0.1;
        GB.push(gbc);
        ArrayList<String> pattern = new ArrayList<String>();
        pattern.add(DEFAULT_PATTERN);
        pattern.addAll(Arrays.asList(BundleRakeFactory.RAKE_PATTERN));
        GB.pushFillX("Rake Pattern");
        mPatternBtnGroup = new ButtonGroup();
        int row = 2;
        for (int i = 0; i < pattern.size(); ++i) {
            String text = (String)pattern.get(i);
            JRadioButton btn = new JRadioButton(text);
            btn.setActionCommand(text);
            GB.add((Component)btn, gridLeft);
            if ((i + 1) % (pattern.size() / row) == 0) {
                GB.newline();
            }
            mPatternBtnGroup.add(btn);
        }
        mPatternBtnGroup.getElements().nextElement().setSelected(true);
        GB.popNl();
        GB.pushFillX("Alignment");
        mAlignGroup = new ButtonGroup();
        for (String text : ALIGNMENT) {
            JRadioButton btn = new JRadioButton(text);
            btn.setActionCommand(text);
            GB.addNl((Component)btn, gridLeft);
            mAlignGroup.add(btn);
        }
        mAlignGroup.getElements().nextElement().setSelected(true);
        GB.popNl();
        GB.pushFillX("Modifier");
        mMinRakeWidth = new JCheckBox("Minimum Rake Width");
        GB.add((Component)mMinRakeWidth, gridLeft);
        GB.popNl();
        GB.add((Component)new JLabel("<html><i>Only support for auto-bundle</i></html>"));
        return mPreferencePanel;
    }

    public static void deriveBestPattern(Db db, String bundleKeyStr) {
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        String[] patterns = BundleRakeFactory.RAKE_PATTERN;
        String alignment = ALIGNMENT[0];
        String patternFixed = patterns[0];
        String patternFree = patterns[0];
        BundleRakeUI.createBundleRakePanel(null);
        OrbitIO.getBundleMonitor().setActive(false);
        int minFixCrosses = Integer.MAX_VALUE;
        int minFreeCrosses = Integer.MAX_VALUE;
        for (int i = 0; i < patterns.length; ++i) {
            for (int j = 0; j < patterns.length; ++j) {
                BundleRakeFactory.rake(db, bundleKeyStr, false, patterns[j], false, alignment);
                BundleRakeFactory.rake(db, bundleKeyStr, true, patterns[i], false, alignment);
                int fixedCross = bundle.crosses(true);
                int freeCross = bundle.crosses(false);
                if (fixedCross >= minFixCrosses && (fixedCross != minFixCrosses || freeCross >= minFreeCrosses)) continue;
                minFixCrosses = fixedCross;
                minFreeCrosses = freeCross;
                patternFixed = patterns[i];
                patternFree = patterns[j];
            }
        }
        BundleRakeFactory.rake(db, bundleKeyStr, false, patternFree, false, alignment);
        BundleRakeFactory.rake(db, bundleKeyStr, true, patternFixed, false, alignment);
        OrbitIO.getBundleMonitor().setActive(true);
    }

    public static void derivePattern(String bundleKeyStr, boolean isFixedSide) {
        AbstractButton btn;
        String pattern = null;
        String alignment = null;
        BundleRakeUI.createBundleRakePanel(null);
        Enumeration<AbstractButton> btns = mPatternBtnGroup.getElements();
        while (btns.hasMoreElements()) {
            btn = btns.nextElement();
            if (!btn.isSelected()) continue;
            pattern = btn.getActionCommand();
        }
        btns = mAlignGroup.getElements();
        while (btns.hasMoreElements()) {
            btn = btns.nextElement();
            if (!btn.isSelected()) continue;
            alignment = btn.getActionCommand();
        }
        OrbitIO.getBundleMonitor().setActive(false);
        Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRakeFactory.rake(OrbitIO.getCurDb(), \"%s\", %b, \"%s\", %b, \"%s\")", (Object[])new Object[]{bundleKeyStr, isFixedSide, pattern, mMinRakeWidth.isSelected(), alignment});
        OrbitIO.getBundleMonitor().setActive(true);
    }

    public static void decideRake(Db db, String bundleKeyStr) {
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        BundleRakeDlg dlg = BundleRakeDlg.createDialog(db, OrbitIO.getMainWindow(), bundle);
        dlg.setVisible(true);
    }

    public static JMenu getRakePatternMenu(InteractiveBundleCreator ibr, boolean isFixedSide) {
        String name = isFixedSide ? "Fixed End" : "Free End";
        JMenu menu = new JMenu("Rake Pattern " + name);
        for (String pattern : BundleRakeFactory.RAKE_PATTERN) {
            menu.add(BundleRakeUI.getMenuItem(pattern, ibr, isFixedSide));
        }
        return menu;
    }

    public static JMenuItem getMenuItem(String name, InteractiveBundleCreator ibr, boolean isFixedSide) {
        RakeMenuAction rakeAction = new RakeMenuAction(name, ibr, isFixedSide);
        String[] sorter = BundleRakeFactory.getSorter(name);
        if (sorter == null) {
            return null;
        }
        rakeAction.setSorter(sorter);
        return new JMenuItem(rakeAction);
    }

    static {
        mLastDialog = null;
    }

    static class RakeMenuAction
    extends AbstractAction {
        InteractiveBundleCreator mIbr;
        boolean mIsFixedSide;
        String[] mSortOrder;

        public RakeMenuAction(String name, InteractiveBundleCreator ibr, boolean isFixedSide) {
            super(name);
            this.mIbr = ibr;
            this.mIsFixedSide = isFixedSide;
        }

        public void setSorter(String[] order) {
            this.mSortOrder = order;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            APoint2D curLoc;
            if (this.mIbr.mActive == null || this.mIbr.mBundle == null) {
                return;
            }
            ArrayList<APoint2D> pts = this.mIsFixedSide ? this.mIbr.mFromPattern : this.mIbr.mToPattern;
            if (pts == null || pts.size() < 2) {
                return;
            }
            Bundle bundle = this.mIbr.mBundle;
            APair locs = bundle.getBundleFFPins(this.mIsFixedSide);
            APoint2D aPoint2D = curLoc = this.mIsFixedSide ? bundle.getPath().getFirstPoint() : bundle.getPath().getLastPoint();
            if (curLoc == null) {
                curLoc = this.mIbr.mLastLoc;
            }
            ALine mySeqBar = BundleRakeUtil.getSeqBar((Bundle)bundle, (boolean)this.mIsFixedSide, (APoint2D)curLoc, (List)((List)locs.first));
            BundleRakeFactory.activeSort(this.mIbr.mActive, mySeqBar, this.mSortOrder, this.mIsFixedSide);
            BundleRakeFactory.activeSort(this.mIbr.mActiveBak, mySeqBar, this.mSortOrder, this.mIsFixedSide);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class BundleRakeDlg
    extends DbDialog {
        protected Bundle mBundle;
        protected ArrayList<APoint2D> mBakFixedEndRake;
        protected ArrayList<APoint2D> mBakFreeEndRake;
        protected ArrayList<InteractiveBundleCreator.PreSchedConn> mBakSchedConn;
        protected APath mBakPath;
        protected List<Layer> mBakLayers;
        protected ButtonGroup mPatternBtnGroup;
        protected ButtonGroup mEndBtnGroup;
        protected ButtonGroup mAlignGroup;
        protected JCheckBox mMinRakeWidth;
        protected JCheckBox mZoomTo;

        public static BundleRakeDlg createDialog(Db db, Component owner, Bundle bundle) {
            if (mLastDialog != null) {
                UIUtil.closeWindow((Window)((Object)mLastDialog));
            }
            mLastDialog = new BundleRakeDlg(db, owner, bundle);
            return mLastDialog;
        }

        public void backup(Bundle bundle) {
            this.mBakFixedEndRake = bundle.getRakePattern(true);
            this.mBakFreeEndRake = bundle.getRakePattern(false);
            this.mBakSchedConn = new ArrayList();
            for (SchedConn sc : bundle.getSchedConn()) {
                InteractiveBundleCreator.PreSchedConn psc = new InteractiveBundleCreator.PreSchedConn(sc.getDPPA(), sc.getDPPB(), bundle.getTemplate());
                this.mBakSchedConn.add(psc);
            }
            this.mBakLayers = bundle.getLayers();
            this.mBakPath = bundle.getPath();
        }

        public BundleRakeDlg(Db db, Component owner, final Bundle bundle) {
            super(db, owner);
            JRadioButton btn;
            this.backup(bundle);
            this.mBundle = bundle;
            this.setTitle(String.format("Edit Rake Pattern (%s)", bundle.getName()));
            GridBagManager l = new GridBagManager(this.getContentPane());
            GridBagConstraints gridFillCS = new GridBagConstraints();
            gridFillCS.fill = 2;
            gridFillCS.insets = new Insets(2, 4, 2, 4);
            GridBagConstraints gridFillCS2 = (GridBagConstraints)gridFillCS.clone();
            gridFillCS2.gridwidth = 2;
            GridBagConstraints gridLeft = new GridBagConstraints();
            gridLeft.anchor = 17;
            gridLeft.fill = 1;
            gridLeft.weightx = 0.1;
            String[] ends = new String[]{"Fixed", "Free"};
            l.pushNoFill("End");
            this.mEndBtnGroup = new ButtonGroup();
            for (String text : ends) {
                btn = new JRadioButton(text);
                btn.setActionCommand(text);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String actionCmd = e.getActionCommand();
                        if (!mZoomTo.isSelected()) {
                            return;
                        }
                        if (actionCmd.equals("Fixed")) {
                            BundleUI.ActionZoomBundle.zoomTo(bundle, mBakFixedEndRake);
                        } else if (actionCmd.equals("Free")) {
                            BundleUI.ActionZoomBundle.zoomTo(bundle, mBakFreeEndRake);
                        }
                    }
                });
                l.add((Component)btn);
                this.mEndBtnGroup.add(btn);
            }
            this.mEndBtnGroup.getElements().nextElement().setSelected(true);
            l.pop();
            this.mZoomTo = new JCheckBox("Zoom To");
            this.mZoomTo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!mZoomTo.isSelected()) {
                        return;
                    }
                    String end = this.getSelectedEnd();
                    if (end.equals("Fixed")) {
                        BundleUI.ActionZoomBundle.zoomTo(bundle, mBakFixedEndRake);
                    } else if (end.equals("Free")) {
                        BundleUI.ActionZoomBundle.zoomTo(bundle, mBakFreeEndRake);
                    }
                }
            });
            l.add((Component)this.mZoomTo);
            l.newline();
            ArrayList<String> pattern = new ArrayList<String>();
            pattern.add(BundleRakeUI.DEFAULT_PATTERN);
            pattern.addAll(Arrays.asList(BundleRakeFactory.RAKE_PATTERN));
            l.push(gridFillCS2);
            l.pushFillX("Rake Pattern");
            this.mPatternBtnGroup = new ButtonGroup();
            int row = 2;
            for (int i = 0; i < pattern.size(); ++i) {
                String text;
                text = (String)pattern.get(i);
                btn = new JRadioButton(text);
                btn.setActionCommand(text);
                l.add((Component)btn, gridLeft);
                if ((i + 1) % (pattern.size() / row) == 0) {
                    l.newline();
                }
                this.mPatternBtnGroup.add(btn);
            }
            this.mPatternBtnGroup.getElements().nextElement().setSelected(true);
            l.pop();
            l.newline();
            l.pushNoFill("Alignment");
            this.mAlignGroup = new ButtonGroup();
            for (String text : ALIGNMENT) {
                JRadioButton btn2 = new JRadioButton(text);
                btn2.setActionCommand(text);
                l.add((Component)btn2);
                this.mAlignGroup.add(btn2);
            }
            this.mAlignGroup.getElements().nextElement().setSelected(true);
            l.pop();
            l.pushFill("Modifier");
            this.mMinRakeWidth = new JCheckBox("Minimum Rake Width");
            l.add((Component)this.mMinRakeWidth, gridLeft);
            l.pop();
            l.newline();
            l.pushNoFill();
            JButton applyBtn = new JButton("Apply");
            applyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String end = this.getSelectedEnd();
                    String pattern = this.getSelectedPattern();
                    OrbitIO.getBundleMonitor().setActive(false);
                    Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRakeFactory.rake(OrbitIO.getCurDb(), \"%s\", %b, \"%s\", %b, \"%s\")", (Object[])new Object[]{mBundle.getKeyStr(), end.equals("Fixed"), pattern, mMinRakeWidth.isSelected(), this.getSelectedAlignment()});
                    OrbitIO.getBundleMonitor().setActive(true);
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            });
            JButton resetBtn = new JButton("Reset");
            resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrbitIO.getBundleMonitor().setActive(false);
                    Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRakeFactory.mLastDialog.recoverRake()", (Object[])new Object[0]);
                    OrbitIO.getBundleMonitor().setActive(true);
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            });
            l.add((Component)applyBtn, (GridBagConstraints)GridBagManager.RIGHT);
            l.add((Component)resetBtn, (GridBagConstraints)GridBagManager.RIGHT);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
        }

        public String getSelectedEnd() {
            Enumeration<AbstractButton> btns = this.mEndBtnGroup.getElements();
            while (btns.hasMoreElements()) {
                AbstractButton btn = btns.nextElement();
                if (!btn.isSelected()) continue;
                return btn.getActionCommand();
            }
            return null;
        }

        public String getSelectedPattern() {
            Enumeration<AbstractButton> btns = this.mPatternBtnGroup.getElements();
            while (btns.hasMoreElements()) {
                AbstractButton btn = btns.nextElement();
                if (!btn.isSelected()) continue;
                return btn.getActionCommand();
            }
            return null;
        }

        public String getSelectedAlignment() {
            Enumeration<AbstractButton> btns = this.mAlignGroup.getElements();
            while (btns.hasMoreElements()) {
                AbstractButton btn = btns.nextElement();
                if (!btn.isSelected()) continue;
                return btn.getActionCommand();
            }
            return null;
        }

        public void recoverRake() {
            Bundle bundle;
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            ibr.mBundle = bundle = this.mBundle;
            ibr.mActive = this.mBakSchedConn;
            ibr.mFromPattern = this.mBakFixedEndRake;
            ibr.mToPattern = this.mBakFreeEndRake;
            ibr.mLayerList.clear();
            bundle.getLayers().stream().forEach(l -> ibr.mLayerList.add((Layer)l));
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Editing Rake Pattern");){
                ibr.mBundle.setPath(this.mBakPath);
                ibr.addBundleToDb();
            }
            this.backup(bundle);
        }
    }
}

