/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.wb_route.RouteQueueDlg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BundleRoutePrep {
    private BundleRoutePrep() {
    }

    public static void prepareForRouting(Db db, boolean isFixed) {
        Selection s = Design.getSelection((Db)db);
        LinkedList<String> l = new LinkedList<String>();
        for (Bundle b : s.get(Bundle.class)) {
            l.add(b.getKeyStr());
        }
        BundleRoutePrep.prepareForRouting(db, l, isFixed, true);
    }

    public static void prepareForRouting(Db db, String bundleKeyStr, boolean isFixed) {
        BundleRoutePrep.prepareForRouting(db, bundleKeyStr, isFixed, false);
    }

    public static void showRouteQ(Db db, String bundleKeyStr, boolean isFixed) {
        BundleRoutePrep.prepareForRouting(db, bundleKeyStr, isFixed, true);
    }

    public static void prepareForRouting(Db db, String bundleKeyStr, boolean isFixed, boolean showDialog) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(bundleKeyStr);
        BundleRoutePrep.prepareForRouting(db, l, isFixed, showDialog);
    }

    public static void prepareForRouting(Db db, List<String> bundleKeyStrList, boolean isFixed, boolean showDialog) {
        if (bundleKeyStrList.isEmpty()) {
            return;
        }
        LinkedList<String> personalityStrList = new LinkedList<String>();
        for (String s : bundleKeyStrList) {
            Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, s);
            if (bundle == null) {
                ALog.logError((String)"Bundle does not exist");
                continue;
            }
            Personality personality = BundleRoutePrep.prepareForRoutingOneBundle(db, bundle, isFixed);
            if (personality == null) {
                ALog.logWarn((String)("Problem getting personality for bundle " + bundle.getName()));
                continue;
            }
            personalityStrList.add(personality.getKeyStr());
        }
        if (showDialog && !personalityStrList.isEmpty()) {
            String side = isFixed ? " Fixed Side" : " Free Side";
            Object ps = "";
            for (String s : personalityStrList) {
                ps = (String)ps + s;
            }
            RouteQueueDlg dlg = RouteQueueDlg.createDialog(OrbitIO.getMainWindow(), db, personalityStrList, "Route Queue for " + (String)ps + side, isFixed);
            if (dlg != null) {
                dlg.setVisible(true);
            }
        }
    }

    public static Personality.Type getFixedEndPersonalityType(Bundle bundle) {
        Personality.Type type = null;
        DeviceTemplate.Type t = bundle.getTemplate().getType();
        if (t.equals((Object)DeviceTemplate.Type.PACKAGE)) {
            type = Personality.Type.DIEESCAPE;
        } else if (t.equals((Object)DeviceTemplate.Type.INTERPOSER)) {
            type = Personality.Type.DIEESCAPE;
        } else if (t.equals((Object)DeviceTemplate.Type.BOARD)) {
            type = Personality.Type.PCBFixed;
        } else if (t.equals((Object)DeviceTemplate.Type.PACKAGEDDIE)) {
            for (SchedConn sc : bundle.getSchedConn()) {
                if (sc.getPathA() == null || sc.getPortA() == null) continue;
                try {
                    t = sc.getAbsDPPA().getPin().getDeviceTemplate().getType();
                    if (!t.equals((Object)DeviceTemplate.Type.DIE)) continue;
                    type = Personality.Type.DIEESCAPE;
                }
                catch (Exception e) {
                    ALog.logWarn((String)"Found invalid fixed end pins during perparing routing.");
                }
            }
            if (type == null) {
                ALog.logWarn((String)"Can not recognize the fixed end personality on PACKAGE DIE device. Use default value.");
                type = Personality.Type.DIEESCAPE;
            }
        } else {
            ALog.logWarn((String)"Can not recognize the fixed end personality on %s device. Use default value.", (Object[])new Object[]{t});
            type = Personality.Type.DIEESCAPE;
        }
        return type;
    }

    public static Personality prepareForRoutingOneBundle(Db db, Bundle bundle, boolean isFixed) {
        Optional personality;
        DeviceTemplate dt = bundle.getTemplate();
        DevicePath aPath = dt.getAnInstance().getADevicePath();
        aPath = aPath.getRelativePathFromAnchor(dt);
        Personality.Type type = null;
        type = isFixed ? BundleRoutePrep.getFixedEndPersonalityType(bundle) : (dt.getType().equals((Object)DeviceTemplate.Type.BOARD) ? Personality.Type.PCBFree : Personality.Type.PckFree);
        assert (type != null);
        if (!isFixed) {
            for (SchedConn sc : bundle.getSchedConn()) {
                if (sc.getPathB() != null && sc.getPortB() != null) continue;
                ALog.logWarn((String)"There does not appear to be a valid free side");
                return null;
            }
        }
        if (!(personality = Optional.ofNullable(isFixed ? bundle.getRouteGroup() : bundle.getRouteGroupFree())).isPresent() || personality.get().getType() == null) {
            personality = Personality.create((DeviceTemplate)dt, (Personality.Type)type, (String)bundle.getName());
            if (!personality.isPresent()) {
                personality = Personality.getPersonality((DeviceTemplate)dt, (Personality.Type)type, (String)bundle.getName());
            }
            assert (personality.isPresent());
            ((Personality)personality.get()).setColor(bundle.getColor());
            if (isFixed) {
                bundle.setRouteGroup((Personality)personality.get());
            } else {
                bundle.setRouteGroupFree((Personality)personality.get());
            }
        }
        assert (((Personality)personality.get()).getType() != null);
        BundleRoutePrep.makeBundleContactPadsForRouter(bundle, isFixed, (Personality)personality.get(), aPath);
        return personality.orElse(null);
    }

    public static void makeBundleContactPadsForRouter(Bundle bundle, boolean isFixed, Personality personality, DevicePath aPath) {
        boolean reuseSchedConn;
        ArrayList points = bundle.getRakePattern(isFixed);
        Db db = bundle.getDb();
        DeviceTemplate dt = bundle.getTemplate();
        Substrate s = dt.getSubstrate();
        LinkedList mySchedConn = bundle.getSchedConn();
        int i = 0;
        NameGenerator ng = new NameGenerator(bundle.getName() + "_");
        SchedConn[] oldSchedConn = (SchedConn[])personality.getSchedConns().stream().toArray(SchedConn[]::new);
        boolean bl = reuseSchedConn = oldSchedConn.length == mySchedConn.size();
        if (!reuseSchedConn) {
            for (SchedConn sc : oldSchedConn) {
                sc.deleteFromDb();
            }
        }
        String ptPrefix = bundle.getName() + "_";
        List topoPinTList = mySchedConn.stream().map(SchedConn::getNet).filter(Objects::nonNull).flatMap(net -> net.getPinTemplates().stream()).filter(pt -> pt.getType() == PinTemplate.Type.TOPOLOGYPOINT).filter(pt -> pt.getName().startsWith(ptPrefix)).collect(Collectors.toList());
        for (PinTemplate pt2 : topoPinTList) {
            pt2.deleteFromDb();
        }
        bundle.removeAllContacts(isFixed);
        PadTemplate pad = PadTemplate.create((Db)db, (Substrate)s, (String)"bundlePad");
        long w = bundle.getWireWidth();
        ARect r = new ARect(-w / 2L, -w / 2L, w / 2L, w / 2L);
        for (Layer l : s.getLayers()) {
            LayerShape.create((Db)db, (Layer)l, (DbObject)pad, (AGeom)r);
        }
        for (SchedConn sc : mySchedConn) {
            Net n = null;
            n = NetMap.getNetAt((Net)sc.getDPPA().getNet(), (DevicePath)sc.getDPPA().getPath(), (DeviceTemplate)dt);
            if (n.getDeviceTemplate() != dt) {
                String uniqueNetName = Net.findAUniqueNetName((DeviceTemplate)dt, (NameGenerator)ng);
                n = Net.create((DeviceTemplate)dt, (String)uniqueNetName);
            }
            SchedConn newSc = new SchedConn(sc);
            String qualifier = isFixed ? "fixed" : "free";
            PinTemplate pt3 = PinTemplate.create((Net)n, (String)(bundle.getName() + "_" + qualifier + "_" + i));
            pt3.setType(PinTemplate.Type.TOPOLOGYPOINT);
            pt3.setIsVirtual(true);
            PortTemplate portTemplate = PortTemplate.create((PinTemplate)pt3);
            portTemplate.setLoc((APoint2D)points.get(i));
            portTemplate.setPadTemplate(pad);
            pt3.createPinInstances();
            if (isFixed) {
                bundle.addFixedContact(pt3);
                newSc.setOwner((DbObject)personality);
                newSc.setPortB(aPath, portTemplate);
                if (!reuseSchedConn) {
                    db.add((DbObject)newSc);
                } else {
                    oldSchedConn[i].copy(newSc);
                }
            } else {
                bundle.addFreeContact(pt3);
                newSc.setOwner((DbObject)personality);
                newSc.setPortA(sc.getDevicePathB(), sc.getPortB());
                newSc.setPortB(aPath, portTemplate);
                if (!reuseSchedConn) {
                    db.add((DbObject)newSc);
                } else {
                    oldSchedConn[i].copy(newSc);
                }
            }
            ++i;
        }
    }

    public static void updateBundleRouteContacts(String bundleStr, boolean isFixed, String perStr) {
        if (bundleStr == null || perStr == null) {
            return;
        }
        Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, perStr);
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleStr);
        if (per != null && bundle != null) {
            BundleRoutePrep.updateBundleRouteContacts(bundle, isFixed, per);
        }
    }

    public static void updateBundleRouteContacts(Bundle bundle, boolean isFixed, Personality personality) {
        HashMap<SchedConn, SchedConn> bToR = new HashMap<SchedConn, SchedConn>();
        block0: for (SchedConn routeSC : personality.getSchedConns()) {
            if (routeSC.getPortB() == null || routeSC.getPortA() == null) continue;
            for (SchedConn sc : bundle.getSchedConn()) {
                if (isFixed) {
                    if (!sc.getDPPA().equals((Object)routeSC.getDPPA())) continue;
                    bToR.put(sc, routeSC);
                    continue block0;
                }
                if (!sc.getDPPB().equals((Object)routeSC.getDPPA())) continue;
                bToR.put(sc, routeSC);
                continue block0;
            }
        }
        bundle.setRakePtsList(isFixed, null);
        ArrayList points = bundle.getRakePattern(isFixed);
        int i = 0;
        for (SchedConn sc : bundle.getSchedConn()) {
            SchedConn bSC = (SchedConn)bToR.get(sc);
            if (bSC == null) continue;
            PortTemplate pt = ((PinInstance)bSC.getDPPB().second).getPinTemplate().getFirstPortTemplate();
            pt.setLoc((APoint2D)points.get(i));
            ++i;
        }
    }
}

