/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.router.OrthoWirePusher;
import java.util.ArrayList;
import java.util.Collections;

public class Compactor {
    ArrayList<OrthoWirePusher.TopologicalObject> rigidObjects = new ArrayList();
    ArrayList<OrthoWirePusher.TopologicalObject> flexibleObjects = new ArrayList();
    ArrayList<Segment> hSegments = new ArrayList();
    ArrayList<Segment> vSegments = new ArrayList();

    protected boolean compactVerticalSegment(Segment s, boolean positive) {
        Segment closestAbove = null;
        Long closestDist = null;
        for (Segment other : this.hSegments) {
            if (!other.yShadows(s) || (!positive || other.z <= s.z) && (positive || s.z <= other.z) || other.t.net == s.t.net && other.fixed) continue;
            long dist = Math.abs(other.z - s.z);
            if (closestAbove != null && dist >= closestDist) continue;
            closestAbove = other;
            closestDist = dist;
        }
        if (closestAbove == null) {
            return false;
        }
        APath p = s.t.current;
        int index = s.index;
        long newY = closestAbove.z;
        newY -= s.t.w.getWidth() / 2L;
        if ((newY -= s.t.clr) == s.z) {
            return false;
        }
        if (index == 0) {
            p.insertPoint(0, new APoint2D(p.getPoint(0)));
            ++index;
        }
        if (index == p.getPointCount() - 1) {
            p.addPoint(new APoint2D(p.getLastPoint()));
        }
        APoint2D newp0 = new APoint2D(s.s0, newY);
        APoint2D newp1 = new APoint2D(s.s1, newY);
        if (p.getPoint(index).getX() == s.s0) {
            p.setPoint(index, newp0);
            p.setPoint(index + 1, newp1);
        } else {
            p.setPoint(index, newp1);
            p.setPoint(index + 1, newp0);
        }
        return true;
    }

    protected boolean compactHorizontalSegmentUp(Segment s) {
        Segment closestAbove = null;
        Long closestDist = null;
        for (Segment other : this.hSegments) {
            if (!other.xShadows(s) || other.z <= s.z || other.t.net == s.t.net && other.fixed) continue;
            long dist = other.z - s.z;
            if (closestAbove != null && dist >= closestDist) continue;
            closestAbove = other;
            closestDist = dist;
        }
        if (closestAbove == null) {
            return false;
        }
        APath p = s.t.current;
        int index = s.index;
        long newY = closestAbove.z;
        newY -= s.t.w.getWidth() / 2L;
        if ((newY -= s.t.clr) == s.z) {
            return false;
        }
        if (index == 0) {
            p.insertPoint(0, new APoint2D(p.getPoint(0)));
            ++index;
        }
        if (index == p.getPointCount() - 1) {
            p.addPoint(new APoint2D(p.getLastPoint()));
        }
        APoint2D newp0 = new APoint2D(s.s0, newY);
        APoint2D newp1 = new APoint2D(s.s1, newY);
        if (p.getPoint(index).getX() == s.s0) {
            p.setPoint(index, newp0);
            p.setPoint(index + 1, newp1);
        } else {
            p.setPoint(index, newp1);
            p.setPoint(index + 1, newp0);
        }
        return true;
    }

    public void compact() {
        int maxPass = 100;
        block0: for (int pass = 0; pass < maxPass; ++pass) {
            this.rebuildAll();
            int free = 0;
            for (Segment s : this.hSegments) {
                if (s.fixed) continue;
                if (free <= pass && this.compactHorizontalSegmentUp(s)) continue block0;
                ++free;
            }
        }
    }

    protected void rebuild(OrthoWirePusher.TopologicalObject tw) {
        this.remove(tw);
        this.addFlexible(tw);
    }

    protected void remove(OrthoWirePusher.TopologicalObject to) {
        ArrayList<Segment> toBeRemoved = new ArrayList<Segment>();
        for (Segment s : this.hSegments) {
            if (!s.t.equals(to)) continue;
            toBeRemoved.add(s);
        }
        for (Segment r : toBeRemoved) {
            this.hSegments.remove(r);
        }
    }

    protected void rebuildAll() {
        for (OrthoWirePusher.TopologicalObject tw : this.flexibleObjects) {
            this.remove(tw);
            this.addFlexible(tw);
        }
        Collections.sort(this.hSegments);
    }

    public void setObjects(ArrayList<OrthoWirePusher.TopologicalObject> rigid, ArrayList<OrthoWirePusher.TopologicalObject> flexible) {
        this.rigidObjects.clear();
        this.flexibleObjects.clear();
        for (OrthoWirePusher.TopologicalObject tw : rigid) {
            this.rigidObjects.add(tw);
            if (tw.angleFace != 90.0 && tw.angleFace != 270.0) continue;
            Segment s = new Segment(tw.current.getFirstPoint().getX(), tw.current.getLastPoint().getX(), tw.current.getFirstPoint().getY(), true, tw);
            this.hSegments.add(s);
        }
        for (OrthoWirePusher.TopologicalObject tw : flexible) {
            this.flexibleObjects.add(tw);
            this.addFlexible(tw);
        }
    }

    protected void addFlexible(OrthoWirePusher.TopologicalObject tw) {
        APath p = tw.current;
        long pDx = p.getDx();
        long pDy = p.getDy();
        if (Math.abs(pDy) > Math.abs(pDx)) {
            int index = 0;
            for (ALine l : p.getLines()) {
                if (l.isHorizontal()) {
                    Segment s = new Segment(l.getP0().getX(), l.getP1().getX(), l.getP0().getY(), false, tw);
                    s.index = index;
                    this.hSegments.add(s);
                }
                ++index;
            }
        }
    }

    class Segment
    implements Comparable<Segment> {
        long s0;
        long s1;
        long z;
        boolean fixed;
        OrthoWirePusher.TopologicalObject t;
        int index;

        public Segment(long x0, long x1, long y, boolean fixed, OrthoWirePusher.TopologicalObject t) {
            this.s0 = Math.min(x0, x1);
            this.s1 = Math.max(x0, x1);
            this.z = y;
            this.fixed = fixed;
            this.t = t;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public ALine toLine() {
            return new ALine(this.s0, this.z, this.s1, this.z);
        }

        @Override
        public int compareTo(Segment o) {
            return Long.compare(this.z, o.z);
        }

        public boolean xShadows(Segment o) {
            ALine oLine;
            ALine thisLine = this.toLine();
            return thisLine.xShadows(oLine = o.toLine());
        }

        public boolean yShadows(Segment o) {
            ALine oLine;
            ALine thisLine = this.toLine();
            return thisLine.yShadows(oLine = o.toLine());
        }
    }
}

