/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.orbit.automation.router.ConstraintTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ConstraintClipboardUtil {
    public static void putConstraintOnClipboard(Constraint<?> constraint) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            cb.setContents(new ConstraintTransferable(constraint), null);
        }
        catch (IllegalStateException ise) {
            ALog.logWarn((Throwable)ise, (String)"Unable to update clipboard.", (Object[])new Object[0]);
        }
    }

    public static Constraint<?> getConstraintFromClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable cbContents = cb.getContents(null);
            if (cbContents == null) {
                return null;
            }
            if (!cbContents.isDataFlavorSupported(ConstraintTransferable.FLAVOR)) {
                return null;
            }
            Object data = cbContents.getTransferData(ConstraintTransferable.FLAVOR);
            return (Constraint)data;
        }
        catch (IllegalStateException ise) {
            ALog.logWarn((Throwable)ise, (String)"Unable to read from clipboard.", (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            ALog.logWarn((Throwable)ioe, (String)"Error reading from clipboard.", (Object[])new Object[0]);
            return null;
        }
        catch (UnsupportedFlavorException ufe) {
            assert (false);
            return null;
        }
    }
}

