/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Constraint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ConstraintTransferable
implements Transferable {
    static final String MimeType = String.format("%s;class=%s", "application/x-java-jvm-local-objectref", Constraint.class.getName());
    static DataFlavor FLAVOR = ConstraintTransferable.createFlavor();
    static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR, DataFlavor.stringFlavor};
    protected Constraint<?> mConstraint;

    static DataFlavor createFlavor() {
        try {
            return new DataFlavor(MimeType);
        }
        catch (ClassNotFoundException cnfe) {
            assert (false);
            ALog.logError((Throwable)cnfe, (String)"Error initializing ConstraintTransferable class.", (Object[])new Object[0]);
            return null;
        }
    }

    public ConstraintTransferable(Constraint<?> c) {
        this.mConstraint = c;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == FLAVOR) {
            return this.mConstraint;
        }
        if (flavor == DataFlavor.stringFlavor) {
            return this.mConstraint.toString();
        }
        assert (false);
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == FLAVOR || flavor == DataFlavor.stringFlavor;
    }
}

