/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.JComponent;

public class DebugOverlay {
    protected DesignView2D mView;
    protected Db mDb;
    protected Design mDesign;
    protected Overlay mOverlay;
    protected boolean mDrawing = false;
    protected SingleLayerRouter slr;
    protected static DebugOverlay theDebugOverlay = null;
    protected AffineTransform aT;
    private ArrayList<SingleLayerRouter.Aisle> as = new ArrayList();
    private ArrayList<Double> cs = new ArrayList();
    private ArrayList<FloodLine> mFloodLines = new ArrayList();
    private ArrayList<ColoredPath> mPaths = new ArrayList();

    public DebugOverlay(DesignView2D view, SingleLayerRouter pr) {
        DesignView2D v2;
        if (view == null) {
            return;
        }
        this.mView = view;
        if (theDebugOverlay != null) {
            v2 = view;
            v2.remove(DebugOverlay.theDebugOverlay.mOverlay);
        }
        this.slr = pr;
        this.mDb = view.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        if (!(view instanceof DesignView2D)) {
            return;
        }
        v2 = view;
        this.mOverlay = new Overlay();
        v2.addOverlay(this.mOverlay);
        theDebugOverlay = this;
        this.aT = pr.getParent().getDeviceTemplate().getAnInstance().getADevicePath().getTransform();
    }

    protected void remove(DesignView2D view) {
    }

    public void addFloodLine(ALine l, double c) {
        FloodLine fl = new FloodLine();
        fl.l = new ALine(l);
        fl.c = c;
        this.mFloodLines.add(fl);
    }

    public void add(SingleLayerRouter.Aisle a, double c) {
        this.as.add(a);
        this.cs.add(c);
    }

    public void resetAs() {
        this.as.clear();
        this.cs.clear();
    }

    public void drawPath(APath p, Color c) {
        if (p == null) {
            return;
        }
        ColoredPath cp = new ColoredPath();
        cp.c = c;
        cp.p = p.copy();
        cp.name = null;
        this.mPaths.add(cp);
    }

    public void deletePaths() {
        this.mPaths.clear();
    }

    public void drawPath(APath p, Color c, String name) {
        ColoredPath cp = new ColoredPath();
        cp.c = c;
        cp.name = name;
        cp.p = p.copy();
        this.mPaths.add(cp);
    }

    public void drawPath(APath p) {
        this.drawPath(p, Color.BLACK);
    }

    public class Overlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        Graphics2D g;

        public Overlay() {
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        protected void drawDT() {
            this.g.setColor(new Color(255, 0, 0, 64));
            for (PrettyRouter.DelaunayRegion dr : DebugOverlay.this.slr.regions) {
                Polygon p = new Polygon();
                APoint2D p1 = ((Topstacle)((FloodableNode)dr.get((int)0)).mChannel.getP1()).getPoint();
                Point screenPt = this.w2s.getScreenPt(p1);
                p.addPoint(screenPt.x, screenPt.y);
                APoint2D p2 = ((Topstacle)((FloodableNode)dr.get((int)0)).mChannel.getP2()).getPoint();
                screenPt = this.w2s.getScreenPt(p2);
                p.addPoint(screenPt.x, screenPt.y);
                p2 = ((Topstacle)((FloodableNode)dr.get((int)0)).mChannel.getP1()).getPoint().equals((Object)((Topstacle)((FloodableNode)dr.get((int)1)).mChannel.getP1()).getPoint()) ? ((Topstacle)((FloodableNode)dr.get((int)1)).mChannel.getP2()).getPoint() : ((Topstacle)((FloodableNode)dr.get((int)1)).mChannel.getP1()).getPoint();
                screenPt = this.w2s.getScreenPt(p2);
                p.addPoint(screenPt.x, screenPt.y);
                this.g.fillPolygon(p);
            }
        }

        protected void drawSpans() {
            if (DebugOverlay.this.slr == null) {
                return;
            }
            this.g.setColor(new Color(0, 0, 0, 128));
            for (FloodableNode fn : DebugOverlay.this.slr.mFloodableNodes) {
                fn.updateSpan();
                ALine span = fn.span;
                if (span == null) continue;
                if (fn.endsAreMatchedPairs) {
                    this.g.setColor(new Color(0, 255, 0, 128));
                } else if (!fn.routeable) {
                    this.g.setColor(new Color(255, 0, 0, 128));
                } else {
                    this.g.setColor(new Color(0, 0, 0, 128));
                }
                Point screenPt = this.w2s.getScreenPt(span.getP0().transform(DebugOverlay.this.aT));
                GeneralPath screenPath = new GeneralPath();
                screenPath.moveTo(screenPt.x, screenPt.y);
                Point screenPt2 = this.w2s.getScreenPt(span.getP1().transform(DebugOverlay.this.aT));
                screenPath.lineTo(screenPt2.x, screenPt2.y);
                this.g.draw(screenPath);
                this.g.fillOval(screenPt.x - 5, screenPt.y - 5, 10, 10);
                Long capacity = span.getLength();
                Object s = Long.toString(fn.mId);
                s = (String)s + " " + capacity;
                s = (String)s + " " + fn.mLoad;
                this.g.drawString((String)s, (screenPt.x + screenPt2.x) / 2, (screenPt.y + screenPt2.y) / 2);
                this.g.drawString((String)s, screenPt.x, screenPt.y);
                this.g.drawString((String)s, screenPt2.x, screenPt2.y);
            }
        }

        protected void drawEdges() {
            if (DebugOverlay.this.slr == null) {
                return;
            }
            this.g.setColor(new Color(0, 0, 255, 120));
            for (FloodableNode fn : DebugOverlay.this.slr.mFloodableNodes) {
                if (!fn.isChannel) continue;
                APoint2D p1 = ((Topstacle)fn.mChannel.getP1()).getPoint();
                APoint2D p2 = ((Topstacle)fn.mChannel.getP2()).getPoint();
                Point screenPt = this.w2s.getScreenPt(p1);
                GeneralPath screenPath = new GeneralPath();
                screenPath.moveTo(screenPt.x, screenPt.y);
                Point screenPt2 = this.w2s.getScreenPt(p2);
                screenPath.lineTo(screenPt2.x, screenPt2.y);
                this.g.draw(screenPath);
                String s = Integer.toString(fn.mId) + "(" + fn.mNumLoads + ")";
                if (fn.mId <= 0) continue;
                this.g.drawString(s, (screenPt.x + screenPt2.x) / 2, (screenPt.y + screenPt2.y) / 2);
            }
        }

        protected void drawOrder() {
            if (DebugOverlay.this.slr == null) {
                return;
            }
            this.g.setColor(Color.RED);
            for (SingleLayerRouter.RouteInformation ri : DebugOverlay.this.slr.mRouteInfo) {
                if (ri.iTh == -1) continue;
                Topstacle tf = ri.getFrom();
                Topstacle tt = ri.getTo();
                APoint2D p1 = tf.getPoint();
                APoint2D p2 = tt.getPoint();
                Point screenPt = this.w2s.getScreenPt(p1);
                String s = Integer.toString(ri.iTh);
                this.g.drawString(s, screenPt.x, screenPt.y);
                screenPt = this.w2s.getScreenPt(p2);
                this.g.drawString(s, screenPt.x, screenPt.y);
            }
        }

        protected void drawFloodLines() {
            this.g.setColor(Color.DARK_GRAY);
            for (FloodLine fl : DebugOverlay.this.mFloodLines) {
                APoint2D p1 = fl.l.getP0();
                APoint2D p2 = fl.l.getP1();
                Point screenPt = this.w2s.getScreenPt(p1);
                GeneralPath screenPath = new GeneralPath();
                screenPath.moveTo(screenPt.x, screenPt.y);
                Point screenPt2 = this.w2s.getScreenPt(p2);
                screenPath.lineTo(screenPt2.x, screenPt2.y);
                this.g.draw(screenPath);
                String s = Double.toString(fl.c);
                this.g.drawString(s, (screenPt.x + screenPt2.x) / 2, (screenPt.y + screenPt2.y) / 2);
            }
        }

        protected void drawFlood() {
            this.g.setColor(Color.DARK_GRAY);
            for (SingleLayerRouter.Aisle a : DebugOverlay.this.as) {
                FloodableNode fn = a.fn;
                if (fn == null || fn.span == null) continue;
                APoint2D p1 = fn.span.getP0();
                APoint2D p2 = fn.span.getP1();
                Point screenPt = this.w2s.getScreenPt(p1);
                GeneralPath screenPath = new GeneralPath();
                screenPath.moveTo(screenPt.x, screenPt.y);
                Point screenPt2 = this.w2s.getScreenPt(p2);
                screenPath.lineTo(screenPt2.x, screenPt2.y);
                this.g.draw(screenPath);
                String s = "" + DebugOverlay.this.cs.get(DebugOverlay.this.as.indexOf(a));
                this.g.drawString(s, (screenPt.x + screenPt2.x) / 2, (screenPt.y + screenPt2.y) / 2);
            }
        }

        public void drawPaths() {
            for (ColoredPath cp : DebugOverlay.this.mPaths) {
                this.g.setColor(cp.c);
                APath path = cp.p;
                if (path.getPointCount() <= 1) continue;
                APoint2D p = path.getFirstPoint();
                Point screenPt = this.w2s.getScreenPt(p);
                GeneralPath screenPath = new GeneralPath();
                screenPath.moveTo(screenPt.x, screenPt.y);
                this.g.fillOval(screenPt.x - 5, screenPt.y - 5, 10, 10);
                Point screenPt2 = new Point(screenPt);
                for (int i = 1; i < path.getPointCount(); ++i) {
                    screenPt2 = this.w2s.getScreenPt(path.getPoint(i));
                    screenPath.lineTo(screenPt2.x, screenPt2.y);
                }
                this.g.draw(screenPath);
                this.g.drawOval(screenPt2.x - 5, screenPt2.y - 5, 10, 10);
                if (cp.name == null) continue;
                APoint2D p2 = path.getLastPoint();
                Point sp2 = this.w2s.getScreenPt(p2);
                String s = cp.name;
                this.g.drawString(s, sp2.x, sp2.y);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!AUtil.getAclDebugMode()) {
                return;
            }
            if (DebugOverlay.this.mDrawing) {
                return;
            }
            DebugOverlay.this.mDrawing = true;
            this.g = (Graphics2D)graphics;
            DesignView2D v2 = DebugOverlay.this.mView;
            this.w2s = v2.getCanvas().getXForm();
            if (DbExplorerPanel.enableExtendedUI()) {
                // empty if block
            }
            DebugOverlay.this.mDrawing = false;
        }
    }

    protected class ColoredPath {
        APath p;
        Color c;
        String name;

        protected ColoredPath() {
        }
    }

    protected class FloodLine {
        ALine l;
        double c;

        protected FloodLine() {
        }
    }
}

