/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.automation.router.WireMap;
import java.util.ArrayList;
import java.util.LinkedList;

public class FloodableNode
implements Comparable<FloodableNode> {
    static int floodableNodeId = 0;
    final int mId = floodableNodeId++;
    boolean isChannel = false;
    SingleLayerRouter.Channel mChannel;
    APoint2D mP;
    protected int mNumLoads = 0;
    protected long mLoad = 0L;
    Topstacle special = null;
    ALine span = null;
    boolean mStartBlocked = false;
    boolean mEndBlocked = false;
    boolean mBothBlocked = false;
    boolean mHardWireBetween = false;
    boolean endsAreMatchedPairs = false;
    int numEndsAreBumps = 0;
    boolean routeable = true;
    LinkedList<Wire> startWires = new LinkedList();
    LinkedList<Wire> endWires = new LinkedList();
    ArrayList<WireMap> wireMaps = new ArrayList();

    public static void resetID() {
        floodableNodeId = 0;
    }

    public void updateSpan() {
        this.span = this.deriveSpan();
    }

    public boolean getIsChannel() {
        return this.isChannel;
    }

    public SingleLayerRouter.Channel getChannel() {
        return this.mChannel;
    }

    protected ALine deriveSpan() {
        ALine span;
        HierPin dpp;
        if (!this.isChannel) {
            return null;
        }
        if (((Topstacle)this.mChannel.getP1()).owner instanceof HierPin && (dpp = (HierPin)((Topstacle)this.mChannel.getP1()).owner).getPin().getType().equals((Object)PinTemplate.Type.CONTACT)) {
            ++this.numEndsAreBumps;
        }
        if (((Topstacle)this.mChannel.getP2()).owner instanceof HierPin && (dpp = (HierPin)((Topstacle)this.mChannel.getP2()).owner).getPin().getType().equals((Object)PinTemplate.Type.CONTACT)) {
            ++this.numEndsAreBumps;
        }
        AGeom shape1 = ((Topstacle)this.mChannel.getP1()).shape;
        AGeom shape2 = ((Topstacle)this.mChannel.getP2()).shape;
        if (shape1 == null) {
            shape1 = new ACircle(this.mChannel.getV1(), 0L);
        }
        if (shape2 == null) {
            shape2 = new ACircle(this.mChannel.getV2(), 0L);
        }
        if ((span = AGeomUtil.minSpan((APoint2D)this.mChannel.getV1(), (APoint2D)this.mChannel.getV2(), (AGeom)shape1, (AGeom)shape2)) == null) {
            span = new ALine(this.mChannel.getV1(), this.mChannel.getV2());
        }
        return span;
    }

    public boolean wireLocked(Wire w) {
        int index = this.getWireIndex(w);
        return this.wireMaps.get((int)index).locked;
    }

    public void setWireLocked(Wire w) {
        int index = this.getWireIndex(w);
        this.wireMaps.get((int)index).locked = true;
    }

    public boolean hasWire(Wire w) {
        int index = this.getWireIndex(w);
        return index >= 0;
    }

    public long getLength() {
        return this.span.getLength();
    }

    public long getCapacity() {
        return this.span.getLength();
    }

    public void clearBlocked() {
        this.mStartBlocked = false;
        this.mEndBlocked = false;
        this.mBothBlocked = false;
        this.startWires.clear();
        this.endWires.clear();
    }

    public int numWires() {
        return this.wireMaps.size();
    }

    public FloodableNode next(Wire w) {
        int index = this.getWireIndex(w);
        if (index >= 0) {
            return this.wireMaps.get((int)index).next;
        }
        return null;
    }

    public FloodableNode prev(Wire w) {
        int index = this.getWireIndex(w);
        if (index >= 0) {
            return this.wireMaps.get((int)index).prev;
        }
        return null;
    }

    public int getWireIndex(Wire w) {
        for (int i = 0; i < this.wireMaps.size(); ++i) {
            if (this.wireMaps.get((int)i).wire != w) continue;
            return i;
        }
        return -1;
    }

    public ArrayList<Wire> getWires() {
        return this.getWires(false);
    }

    public ArrayList<Wire> getWires(boolean reverse) {
        int i;
        ArrayList<Wire> ret = new ArrayList<Wire>();
        if (reverse) {
            for (i = this.wireMaps.size() - 1; i >= 0; --i) {
                ret.add(this.wireMaps.get((int)i).wire);
            }
        }
        for (i = 0; i < this.wireMaps.size(); ++i) {
            ret.add(this.wireMaps.get((int)i).wire);
        }
        return ret;
    }

    public long deriveLoad(SingleLayerRouter.RouteInformation ri, int more) {
        long avgLoad = 0L;
        long curLoad = 0L;
        curLoad = this.mLoad;
        if (this.mNumLoads > 0) {
            avgLoad = this.mLoad / (long)this.mNumLoads;
        }
        if (this.mStartBlocked) {
            curLoad -= avgLoad;
        }
        if (this.mEndBlocked) {
            curLoad -= avgLoad;
        }
        if (more == 1) {
            curLoad += 2L * ri.getTraceToPad();
        }
        curLoad += ri.getWidth();
        if (this.mNumLoads > 0) {
            curLoad += (long)this.mNumLoads * ri.getClear();
        }
        return curLoad;
    }

    protected String printNode() {
        SingleLayerRouter.Channel c = this.mChannel;
        if (c == null) {
            return "";
        }
        return this.mId + " " + ((Topstacle)this.mChannel.getP1()).toString() + "->" + ((Topstacle)this.mChannel.getP2()).toString();
    }

    public void addWire(Wire w, int index, FloodableNode prev, FloodableNode next, APoint2D p) {
        if (this.mId == 65) {
            ALog.logInfo((String)"");
        }
        WireMap wm = new WireMap();
        wm.wire = w;
        wm.point = new APoint2D(p);
        wm.prev = prev;
        wm.next = next;
        if (index <= this.wireMaps.size()) {
            this.wireMaps.add(index, wm);
        }
        this.mLoad += w.getWidth();
        ++this.mNumLoads;
    }

    public FloodableNode(SingleLayerRouter.Channel c, APoint2D p) {
        this.clearBlocked();
        this.mP = new APoint2D(p);
        this.mChannel = c;
        this.isChannel = c != null;
    }

    public String toString() {
        return this.printNode();
    }

    @Override
    public int compareTo(FloodableNode other) {
        long compare = this.mP.getX() - other.mP.getX();
        if (compare == 0L) {
            compare = this.mP.getY() - other.mP.getY();
        }
        if (compare > 0L) {
            return 1;
        }
        if (compare < 0L) {
            return -1;
        }
        return 0;
    }

    public ALine line(Topstacle from) {
        APoint2D p1 = this.mChannel.getV1();
        APoint2D p2 = this.mChannel.getV2();
        ALine r = new ALine(p1, p2);
        if (this.mChannel.getP2() == from) {
            r.swap();
        }
        return r;
    }

    public ALine line() {
        APoint2D p1 = this.mChannel.getV1();
        APoint2D p2 = this.mChannel.getV2();
        ALine r = new ALine(p1, p2);
        return r;
    }

    public APoint2D optimumPoint(ALine bisector, SingleLayerRouter.RouteInformation ri) {
        long p1Dist;
        ALine l = new ALine(this.span);
        if ((l = l.shrink(ri.getClear() + ri.getWidth() / 2L, ri.getClear() + ri.getWidth() / 2L)).crossIntersects(bisector)) {
            APoint2D p = l.getIntersectLines(bisector);
            return p;
        }
        long p0Dist = bisector.distance(l.getP0());
        APoint2D p = p0Dist < (p1Dist = bisector.distance(l.getP1())) ? l.getP0() : l.getP1();
        return p;
    }
}

