/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.BundleRakeUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.PinPairConnectionFactory;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.ui.ACanvasInfo;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.AbstractPin;
import com.sigrity.orbit.CandidatePairs;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairFinder;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPinHull;
import com.sigrity.orbit.HierPinT;
import com.sigrity.orbit.LineUnCrosser;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.ConnectivityMgmt;
import com.sigrity.orbit.automation.PinSpreadOptimizer;
import com.sigrity.orbit.automation.router.BundleRakeUI;
import com.sigrity.orbit.cmd.BundleCommands;
import com.sigrity.orbit.ui.BundleCreationDlg;
import com.sigrity.orbit.ui.FixedFreePinSelection;
import com.sigrity.orbit.ui.PersonalityMappingMgmt;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.route_edit.EditRouteMode;
import com.sigrity.orbit.ui.route_edit.InteractiveWireCreator;
import com.sigrity.orbit.ui.wb_route.LayerSelectorDlg;
import com.sigrity.orbit.ui.wb_route.RouteQueueDlg;
import com.sigrity.orbit.util.PinUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InteractiveBundleCreator
extends InteractiveWireCreator {
    public static boolean useDiffPairFinder = true;
    private static boolean isVerifyContactSync = true;
    protected long WireEndCount = 0L;
    protected static final double[] mXSquishCost = new double[]{1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 1.1, 1.25, 1.42, 1.66, 2.0};
    protected static final String CreateBundleCommand = "Create Bundle";
    protected static final String EditBundleCommand = "Edit Bundle";
    protected static final String OptimizeBundleCommand = "Optimize Free End";
    protected static final String UntangleStartCommand = "Untangle Start";
    private static final String[] optAlgos = DiffPairFinder.CostFunctionCatalog;
    private static InteractiveBundleCreator theInteractiveBundleCreator;
    boolean mSimpleDraw = false;
    boolean mProjectOutPoint = false;
    protected ArrayList<APoint2D> mFixedPinsLocs = new ArrayList();
    protected ArrayList<APoint2D> mFreePinsLocs = new ArrayList();
    protected ArrayList<APoint2D> mFromPattern = new ArrayList();
    protected ArrayList<APoint2D> mToPattern = new ArrayList();
    protected ArrayList<AbstractPin> mToFiltered = new ArrayList();
    protected ArrayList<AbstractPin> mFromCandidates = new ArrayList();
    protected ArrayList<AbstractPin> mToCandidates = new ArrayList();
    protected ArrayList<PreSchedConn> mActive = new ArrayList();
    protected ArrayList<PreSchedConn> mActiveBak = new ArrayList();
    protected ArrayList<AbstractPin> mFilteredToCandidates = new ArrayList();
    protected int mCostDir = 0;
    protected UseMode mMode = UseMode.Unknown;
    protected DevicePath mCommonPath = null;
    protected boolean mLock = false;
    protected HashSet<HierPin> mLockSet = new HashSet();
    protected HashSet<KeyStroke> mMappedKeyStrokes = new HashSet();
    protected LinkedList<DevicePath> mInstancesOfTemplate = new LinkedList();
    protected DesignView2D.ViewMode oldViewMode = null;
    protected String oldName = null;
    protected Color oldColor = null;
    protected APath oldPath = null;
    protected String oldAlgo = DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])optAlgos);
    protected String mOptDescription = "";
    protected boolean mRestart = false;
    boolean uninstallingNow = false;
    protected static String mDeleteOpt;
    APair<LinkedList<CandidatePairs>, LinkedList<AbstractPin>> mLastFreeSide = null;
    Set<Layer> mLayerList = new HashSet<Layer>();
    protected DbHistory.DbTransaction mTransaction = null;
    protected Bundle mBundle;
    protected String mCurrentName;
    protected APoint2D mLastLoc = null;
    protected ACanvasInfo ci = new ACanvasInfo();
    protected Graphics2D mGraphics;
    protected ALine mDynamicLine = new ALine();
    protected JMenuItem mLayers;
    protected JCheckBoxMenuItem mSnap45Deg;
    protected JCheckBoxMenuItem mOptimize;
    protected JCheckBoxMenuItem mUseOnlyUnused;
    protected JCheckBoxMenuItem mUseOnlyUnBundled;
    protected JCheckBoxMenuItem mShowHull;
    protected long mWireWidth;
    protected long mWireClear;
    protected boolean mOptimizeFreeEndFlag;
    protected PinSpreadOptimizer.PinSpreadAlgo mSpreadAlgo;
    protected long mSpreadPins;
    protected Object mSpreadUserData;
    protected Constraint.RouteAngle mRouteAngle;
    protected String mOptAlgorithm = "";
    protected BundleCreationDlg.MessageReceiver myMessageReceiver = null;
    protected Color mColorHint = null;
    protected String mNameHint = null;
    protected boolean mOptDiff = true;
    protected Interface mInterfaceHint = null;
    protected Action toZoom = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
            ARect rc = InteractiveBundleCreator.this.getToRect();
            if (rc == null) {
                return;
            }
            if (rc.width() == 0L && rc.height() == 0L) {
                long min = Design.micronToInternal((Db)OrbitIO.getCurDb(), (double)1.0);
                rc.grow(min);
            }
            rc.expand(1.5);
            dv2d.zoomTo(rc);
        }
    };
    protected Action changeCost = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ++InteractiveBundleCreator.this.mCostDir;
            if (InteractiveBundleCreator.this.mCostDir >= mXSquishCost.length) {
                InteractiveBundleCreator.this.mCostDir = 0;
            }
            InteractiveBundleCreator.this.mParent.repaintOverlay();
        }
    };
    protected Action lock = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!InteractiveBundleCreator.this.mLock) {
                InteractiveBundleCreator.this.mLockSet.clear();
                for (PreSchedConn hpp : InteractiveBundleCreator.this.mActive) {
                    InteractiveBundleCreator.this.mLockSet.add(hpp.to.pin);
                }
            }
            InteractiveBundleCreator.this.mLock = !InteractiveBundleCreator.this.mLock;
            InteractiveBundleCreator.this.filterAvailableCandidates();
        }
    };
    protected Action changeDiffAlgorithm = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InteractiveBundleCreator.this.mBundle == null) {
                return;
            }
            String oa = InteractiveBundleCreator.this.mOptAlgorithm;
            int idx = DiffPairFinder.indexOfAlgo((String[])optAlgos, (String)oa);
            if (++idx >= optAlgos.length) {
                idx = 0;
            }
            InteractiveBundleCreator.this.mOptAlgorithm = optAlgos[idx];
            InteractiveBundleCreator.this.mOptDescription = DiffPairFinder.costToFunction((String)InteractiveBundleCreator.this.mOptAlgorithm).getName();
            InteractiveBundleCreator.this.mLastFreeSide = null;
            InteractiveBundleCreator.this.showMessage();
            InteractiveBundleCreator.this.optimizeFreeEnd();
            InteractiveBundleCreator.this.mParent.repaintOverlay();
        }
    };
    protected Action simpleToggle = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator.this.mSimpleDraw = !InteractiveBundleCreator.this.mSimpleDraw;
            InteractiveBundleCreator.this.optimizeFreeEnd();
            InteractiveBundleCreator.this.mParent.repaintOverlay();
        }
    };
    protected Action projectToggle = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator.this.mProjectOutPoint = !InteractiveBundleCreator.this.mProjectOutPoint;
            InteractiveBundleCreator.this.optimizeFreeEnd();
            InteractiveBundleCreator.this.mParent.repaintOverlay();
        }
    };
    protected Action commit = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            OrbitIO.getBundleMonitor().setActive(false);
            InteractiveBundleCreator.this.mouseClicked(1, InteractiveBundleCreator.this.mLastLoc);
            Cp.exec((String)"_ibr.commit()", (Object[])new Object[0]);
            OrbitIO.getBundleMonitor().setActive(true);
        }
    };
    protected Action fromZoom = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
            ARect rc = InteractiveBundleCreator.this.getFromRect();
            if (rc == null) {
                return;
            }
            if (rc.width() == 0L && rc.height() == 0L) {
                long min = Design.micronToInternal((Db)OrbitIO.getCurDb(), (double)1.0);
                rc.grow(min);
            }
            rc.expand(1.5);
            dv2d.zoomTo(rc);
        }
    };
    protected Action allZoom = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
            ARect rc1 = InteractiveBundleCreator.this.getToRect();
            if (rc1 == null) {
                return;
            }
            ARect rc2 = InteractiveBundleCreator.this.getFromRect();
            if (rc2 == null) {
                return;
            }
            rc1.expand(rc2);
            if (rc1.width() == 0L && rc1.height() == 0L) {
                long min = Design.micronToInternal((Db)OrbitIO.getCurDb(), (double)1.0);
                rc1.grow(min);
            }
            dv2d.zoomTo(rc1);
        }
    };
    protected Timer mUpdateTimer;
    protected boolean mUpdatePending = false;
    protected Runnable mActionHandler = null;
    protected DocumentListener mTextChanged = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            InteractiveBundleCreator.this.scheduleUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            InteractiveBundleCreator.this.scheduleUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            InteractiveBundleCreator.this.scheduleUpdate();
        }
    };
    protected ActionListener mUpdateTask = e -> this.callAction();
    protected ArrayList<InteractiveBundleListener> mListeners = new ArrayList();

    public static void setIsVerifyContactSync(boolean b) {
        isVerifyContactSync = b;
    }

    protected InteractiveBundleCreator() {
        this.setOptAlgorithm(DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), (DbObject)this.mBundle, (String[])optAlgos));
    }

    public static InteractiveBundleCreator show() {
        if (theInteractiveBundleCreator == null) {
            theInteractiveBundleCreator = new InteractiveBundleCreator();
        }
        return theInteractiveBundleCreator;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    protected int filterChoice(int full, int overlap) {
        Object[] options = new String[]{"Ignore Pins", "Cancel"};
        String selOpt = options[1];
        if (OrbitIO.getCurDb() != null) {
            String msg = String.format("<html>You have selected a total of " + full + " pins. " + overlap + " of these belong to other bundles. <br>Do you want to ignore these " + overlap + " pins and create a bundle of " + (full - overlap) + " pins?", new Object[0]);
            JOptionPane op = new JOptionPane(msg, 3);
            op.setOptions(options);
            JDialog dlg = op.createDialog(OrbitIO.getMainWindow(), "Pins in use");
            dlg.setVisible(true);
            selOpt = (String)op.getValue();
        }
        if (selOpt.equals(options[0])) {
            return 0;
        }
        if (selOpt.equals(options[1])) {
            return 1;
        }
        return 2;
    }

    public void setColorHint(String string) {
        this.setColorHint(AUtil.colorFromString((String)string));
    }

    public void setColorHint(Color hint) {
        this.mColorHint = hint;
    }

    public void setNameHint(String hint) {
        this.mNameHint = hint;
    }

    public void setInterfaceHint(String interfaceKeyStr) {
        Db db = OrbitIO.getCurDb();
        Interface intf = (Interface)db.getByKeyStr(Interface.class, interfaceKeyStr);
        this.setInterfaceHint(intf);
    }

    public void setInterfaceHint(Interface intrface) {
        this.mInterfaceHint = intrface;
    }

    public void setOptimizeFreeEndFlag(boolean hint) {
        this.mOptimizeFreeEndFlag = hint;
    }

    public void setSpreadAlgo(PinSpreadOptimizer.PinSpreadAlgo algo) {
        this.mSpreadAlgo = algo;
    }

    public void setSpreadPins(long extraPins) {
        this.mSpreadPins = extraPins;
    }

    public void setSpreadUserData(Object userData) {
        this.mSpreadUserData = userData;
    }

    public DevicePath getCommonPath() {
        return this.mCommonPath;
    }

    public void start(String bundleKeyStr, String mode) {
        PortPairOpt ppo;
        Db db = OrbitIO.getCurDb();
        Bundle bundle = null;
        if (bundleKeyStr != null) {
            bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        }
        if ((ppo = PortPairOpt.getActive(db)) != null && mode != null) {
            this.start(bundle, ppo.getAPorts(), ppo.getBPorts(), UseMode.valueOf(mode));
        }
    }

    public void start(Bundle bundle, List<HierPin> createFromArray, List<HierPin> createToArray, UseMode mode) {
        Db db = OrbitIO.getCurDb();
        this.mLastFreeSide = null;
        this.mRestart = false;
        this.mLayerList = BundleCreationDlg.getLayers();
        this.showDiffPairStatus(true);
        if (mode == UseMode.Create || mode == UseMode.AutoCreate) {
            PortPairOpt ppo;
            int n;
            HierPin hPin;
            PinInstance pin;
            HierInst hPinT;
            if (this.mMode != UseMode.Unknown && this.mMode != UseMode.BeginEdit && this.mMode != UseMode.BeginEditOptPath && this.mMode != UseMode.Create) {
                return;
            }
            if (createFromArray.isEmpty()) {
                ALog.logWarn((String)"Nothing to bundle");
                return;
            }
            if (mode == UseMode.AutoCreate && createToArray.isEmpty()) {
                ALog.logWarn((String)"Missing free pins for bundling");
                return;
            }
            if (mode == UseMode.AutoCreate && this.mSpreadPins > 0L && this.mSpreadAlgo != null) {
                createToArray = this.mSpreadAlgo.filter(createToArray, this.mSpreadPins, this.mSpreadUserData);
            }
            LinkedHashSet<HierPin> fromSet = new LinkedHashSet<HierPin>();
            LinkedHashSet<HierPin> toSet = new LinkedHashSet<HierPin>();
            int numPins = 0;
            for (HierPin hierPin : createFromArray) {
                hPinT = PinUtil.getBundlePin((HierPin)hierPin, (boolean)true);
                pin = PinInstance.getPinInstance((HierInst)hPinT, (boolean)true);
                if (pin == null) continue;
                hPin = new HierPin((DevicePath)hPinT.first, pin);
                fromSet.add(hPin);
                if (++numPins != createToArray.size()) continue;
                break;
            }
            for (HierPin hierPin : createToArray) {
                hPinT = PinUtil.getBundlePin((HierPin)hierPin, (boolean)true);
                pin = PinInstance.getPinInstance((HierInst)hPinT, (boolean)true);
                if (pin == null) continue;
                hPin = new HierPin((DevicePath)hPinT.first, pin);
                toSet.add(hPin);
            }
            if (this.mTransaction != null) {
                this.mTransaction.close();
                this.mTransaction = null;
            }
            this.mTransaction = DbHistory.newDbTransaction((Db)db, (String)CreateBundleCommand);
            this.mCommonPath = FixedFreePinSelection.deriveLeastCommonDevicePath(createFromArray, createToArray);
            if (this.mCommonPath.isEmpty() && this.mCommonPath.getRoot() == null) {
                ALog.logWarn((String)"There does not seem to be a common substrate joining the fixed and free pins.");
                return;
            }
            if (!this.mCommonPath.getDeviceTemplate().amIASubstrate()) {
                this.mCommonPath = this.mCommonPath.pathToSubstrate();
            }
            HashSet alreadyBundledPins = new HashSet();
            for (HierPin pin2 : fromSet) {
                if (Bundle.bundlesUsingHierPin((HierPin)pin2).isEmpty()) continue;
                alreadyBundledPins.add(pin2);
            }
            if (!alreadyBundledPins.isEmpty()) {
                int n2 = this.filterChoice(fromSet.size(), alreadyBundledPins.size());
                if (n2 == 0) {
                    createFromArray.removeAll(alreadyBundledPins);
                    fromSet.removeAll(alreadyBundledPins);
                } else {
                    return;
                }
            }
            if ((n = createFromArray.size()) == 0) {
                ALog.logWarn((String)"Nothing to bundle");
                return;
            }
            if (createToArray.isEmpty() && this.mCommonPath.size() > 1) {
                this.mCommonPath = this.mCommonPath.getParent();
            }
            DeviceTemplate deviceTemplate = this.mCommonPath.getDeviceTemplate();
            this.loadPreSchedConn(fromSet, toSet, deviceTemplate);
            Color c = Color.orange;
            String name = "bundle.0";
            if (this.mMode.equals((Object)UseMode.BeginEdit) || this.mMode.equals((Object)UseMode.BeginEditOptPath)) {
                c = this.oldColor;
                name = this.oldName;
            } else {
                if (this.mNameHint != null) {
                    name = this.mNameHint;
                }
                if (this.mColorHint != null) {
                    c = this.mColorHint;
                } else {
                    for (HierPin pin3 : createFromArray) {
                        if (((PinInstance)pin3.second).getPersonality() == null) continue;
                        c = ((PinInstance)pin3.second).getPersonality().getColor();
                        break;
                    }
                }
            }
            this.mBundle = InteractiveBundleCreator.makeABundle(name, deviceTemplate.getKeyStr(), n, this.mWireClear, this.mWireWidth, AUtil.colorToString((Color)c));
            if (this.mInterfaceHint != null) {
                this.mBundle.setInterface(this.mInterfaceHint);
                this.mInterfaceHint = null;
            }
            if (this.oldAlgo != null && this.mOptAlgorithm.isEmpty()) {
                this.mBundle.setAlignmentAlgo(this.oldAlgo);
                this.mOptAlgorithm = this.oldAlgo;
                this.oldAlgo = null;
            }
            if (this.oldPath != null) {
                this.mBundle.setPath(this.oldPath);
                this.mBundle.getPath().setWidth(this.mBundle.bundleWidth());
                this.oldPath = null;
                this.mAnchor = this.mBundle.getPath().getLastPoint();
                AffineTransform t = this.getADevicePath().getTransform();
                this.mAnchor = this.mAnchor.transform(t);
                OrbitIO.getApp().refreshCurrentView(true);
            }
            if ((ppo = PortPairOpt.getActive(db)) != null) {
                this.mBundle.setFixedExpansion(ppo.getExpansion());
                ppo.setExpansion(1.0);
            }
            this.mMode = this.mMode == UseMode.BeginEdit || this.mMode == UseMode.BeginEditOptPath ? UseMode.DoingEdit : (mode == UseMode.AutoCreate ? UseMode.AutoCreate : UseMode.Create);
            this.start();
        }
        if (mode == UseMode.BeginEditOptPath) {
            this.mMode = UseMode.BeginEditOptPath;
            if (this.mTransaction != null) {
                this.mTransaction.close();
                this.mTransaction = null;
            }
            this.mTransaction = DbHistory.newDbTransaction((Db)db, (String)EditBundleCommand);
            this.mBundle = bundle;
            this.mBundle.setBreakoutStatus(Bundle.BreakoutStatus.Unknown);
            PortPairOpt ppo = PortPairOpt.getActive(db);
            if (ppo == null) {
                ppo = new PortPairOpt();
            }
            ArrayList<HierPin> fromArray = new ArrayList<HierPin>();
            ArrayList<HierPin> toArray = new ArrayList<HierPin>();
            for (SchedConn schedConn : bundle.getSchedConn()) {
                fromArray.add(schedConn.getDPPA());
                if (schedConn.getDPPB() == null) continue;
                toArray.add(schedConn.getDPPB());
            }
            ppo.setAPorts(fromArray);
            ppo.setBPorts(toArray);
            ppo.setExpansion(bundle.getFixedExpansion());
            this.oldName = bundle.getName();
            this.oldColor = bundle.getColor();
            this.oldPath = bundle.getPath().copy();
            this.oldAlgo = DiffPairFinder.getInitialDiffPairAlgo((Db)db, (DbObject)bundle, (String[])optAlgos);
            this.mInterfaceHint = bundle.getInterface();
            this.mWireWidth = bundle.getWireWidth();
            this.mWireClear = bundle.getWireClr();
            this.mOptimizeFreeEndFlag = true;
            InteractiveBundleCreator.delete(null, bundle, false, true);
            this.start(bundle, fromArray, toArray, UseMode.Create);
        }
        if (mode == UseMode.BeginEdit) {
            this.mMode = UseMode.BeginEdit;
            if (this.mTransaction != null) {
                this.mTransaction.close();
                this.mTransaction = null;
            }
            this.mTransaction = DbHistory.newDbTransaction((Db)db, (String)EditBundleCommand);
            this.mBundle = bundle;
            this.mBundle.setBreakoutStatus(Bundle.BreakoutStatus.Unknown);
            BundleCreationDlg bundleDlg = BundleCreationDlg.showMeOnTab(OrbitIO.getMainWindow(), 0, "Change Contents " + this.mBundle.getName(), this.mBundle.getKeyStr());
            this.myMessageReceiver = new MyMessageReceiverFromBundleCreation();
            BundleCreationDlg.addLoadListener(this.myMessageReceiver);
            PortPairOpt ppo = PortPairOpt.getActive(db);
            if (ppo == null) {
                ppo = new PortPairOpt();
            }
            ArrayList<HierPin> fromArray = new ArrayList<HierPin>();
            ArrayList<HierPin> toArray = new ArrayList<HierPin>();
            for (SchedConn sc : bundle.getSchedConn()) {
                fromArray.add(sc.getDPPA());
                if (sc.getDPPB() == null) continue;
                toArray.add(sc.getDPPB());
            }
            ppo.setAPorts(fromArray);
            ppo.setBPorts(toArray);
            ppo.setExpansion(bundle.getFixedExpansion());
            this.oldName = bundle.getName();
            this.oldColor = bundle.getColor();
            this.oldPath = new APath(bundle.getPath());
            this.oldAlgo = DiffPairFinder.getInitialDiffPairAlgo((Db)db, (DbObject)bundle, (String[])optAlgos);
            this.mInterfaceHint = bundle.getInterface();
            bundleDlg.updateCounts();
            InteractiveBundleCreator.delete(null, bundle, false, true);
        } else if (mode == UseMode.Optimize) {
            this.optimizeStateStart(bundle);
        }
    }

    public void editContents(String bundleKeyStr) {
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            return;
        }
        this.editContents(bundle);
    }

    public void editContents(Bundle bundle) {
        long wireWidth = bundle != null && bundle.getWireWidth() != 0L ? bundle.getWireWidth() : 10000L;
        long wireClr = bundle != null && bundle.getWireClr() != 0L ? bundle.getWireClr() : 10000L;
        this.setConstraints(wireWidth, wireClr, Constraint.RouteAngle.FortyFive);
        this.start(bundle, null, null, UseMode.BeginEdit);
    }

    public void optimizeFreeEndPath(String bundleKeyStr) {
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            return;
        }
        this.optimizeFreeEndPath(bundle);
    }

    public void optimizeFreeEndPath(Bundle bundle) {
        long wireWidth = bundle != null && bundle.getWireWidth() != 0L ? bundle.getWireWidth() : 10000L;
        long wireClr = bundle != null && bundle.getWireClr() != 0L ? bundle.getWireClr() : 10000L;
        this.setConstraints(wireWidth, wireClr, Constraint.RouteAngle.FortyFive);
        this.start(bundle, null, null, UseMode.BeginEditOptPath);
    }

    public void optimizeFreeEnd(String bundleKeyStr) {
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            return;
        }
        this.optimizeFreeEnd(bundle);
    }

    public void optimizeFreeEnd(Bundle bundle) {
        long wireWidth = bundle != null && bundle.getWireWidth() != 0L ? bundle.getWireWidth() : 10000L;
        long wireClr = bundle != null && bundle.getWireClr() != 0L ? bundle.getWireClr() : 10000L;
        this.setConstraints(wireWidth, wireClr, Constraint.RouteAngle.FortyFive);
        this.setOptAlgorithm("x");
        this.start(bundle, null, null, UseMode.Optimize);
    }

    protected void optimizeStateStart(Bundle bundle) {
        Db db = OrbitIO.getCurDb();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)OptimizeBundleCommand);){
            this.mMode = UseMode.Optimize;
            this.mBundle = bundle;
            this.mOptAlgorithm = DiffPairFinder.getInitialDiffPairAlgo((Db)db, (DbObject)this.mBundle, (String[])optAlgos);
            this.loadPreSchedConnFromBundle();
            this.mFromPattern = bundle.getRakePattern(true);
            this.mToPattern = bundle.getRakePattern(false);
            if (this.mToPattern == null || this.mToPattern.isEmpty()) {
                return;
            }
            ArrayList<APoint2D> last = new ArrayList<APoint2D>(this.mToPattern);
            int maxPass = 1;
            boolean gettingBetter = true;
            for (int pass = 0; gettingBetter && pass < maxPass; ++pass) {
                this.optimizeFreeEnd();
                this.filterSchedConns();
                this.changeAfterOpt();
                bundle.setRakePtsList(false, null);
                this.mToPattern = bundle.getRakePattern(false);
                gettingBetter = false;
                int size = this.mActive.size();
                for (int i = 0; i < size; ++i) {
                    if (this.mToPattern.get(i).equals((Object)last.get(i))) continue;
                    gettingBetter = true;
                    break;
                }
                last.clear();
                last.addAll(this.mToPattern);
            }
            bundle.setRakePts(this.mFromPattern, this.mToPattern);
            Bundle.fixUpBundles((Db)bundle.getDb());
            Bundle.bundleChanged((String)"optimize");
            BundleCommands.updateBundleAfterSwap(this.mBundle, true);
            OrbitIO.getApp().refreshCurrentView(true);
            theInteractiveBundleCreator = null;
        }
    }

    public static void delete() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        int i = 0;
        Set toDelete = s.get(Bundle.class).stream().collect(Collectors.toSet());
        for (Bundle o : toDelete) {
            InteractiveBundleCreator.delete(o, ++i > 1);
            s.clear();
        }
    }

    public static void deleteWithTrans(Bundle bundle) {
        if (RouteQueueDlg.getLastDialog() != null) {
            RouteQueueDlg.getLastDialog().removeNotify();
        }
        Db db = OrbitIO.getCurDb();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Delete Bundle");){
            InteractiveBundleCreator.delete(bundle, false);
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void delete(Bundle bundle, boolean rememberLast) {
        InteractiveBundleCreator.delete(OrbitIO.getMainWindow(), bundle, rememberLast);
    }

    public static void delete(Window uiOwner, Bundle bundle, boolean rememberLast) {
        InteractiveBundleCreator.delete(uiOwner, bundle, rememberLast, false);
    }

    public static void delete(Window uiOwner, Bundle bundle, boolean rememberLast, boolean forceDelete) {
        Personality routeGroup = bundle.getRouteGroup();
        Object[] options = new String[]{"Keep Nets", "Remove Nets", "Cancel"};
        SchedConn sc = bundle.getNth(0);
        if (sc != null && sc.getDevicePathB() != null) {
            String selOpt;
            if (forceDelete) {
                selOpt = mDeleteOpt = options[1];
                rememberLast = true;
            }
            if (!rememberLast) {
                String msg = "Would you like to remove the nets on the free pins of selected bundle(s) after deleting?";
                JOptionPane op = new JOptionPane(msg, 3);
                op.setOptions(options);
                JDialog dlg = op.createDialog(uiOwner, "Delete Bundles");
                dlg.setVisible(true);
                selOpt = (String)op.getValue();
            } else {
                selOpt = mDeleteOpt;
            }
            mDeleteOpt = selOpt;
            if (selOpt.equals(options[2])) {
                if (BundleCreationDlg.getCurrent() != null) {
                    UIUtil.closeWindow((Window)((Object)BundleCreationDlg.getCurrent()));
                }
                return;
            }
            if (selOpt.equals(options[1])) {
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.commandSetFreePinsToUnused(\"%s\");", (Object[])new Object[]{bundle.getKeyStr()});
            }
        }
        Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.deletePotentialContacts(\"%s\");", (Object[])new Object[]{bundle.getKeyStr()});
        if (routeGroup != null) {
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.deleteStrategy (\"%s\")", (Object[])new Object[]{routeGroup.getKeyStr()});
        }
        Cp.exec((String)"com.sigrity.acl.db.std.Bundle.deleteFromDb(OrbitIO.getCurDb(), \"%s\");", (Object[])new Object[]{bundle.getKeyStr()});
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void commandSetFreePinsToUnused(String bundleKeyStr) {
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            return;
        }
        for (SchedConn sc : bundle.getSchedConn()) {
            PinTemplate pt;
            if (sc.getDevicePathB() == null || sc.getHierPortB() == null || (pt = sc.getDPPB().getPinTemplate()) == null) continue;
            PinInstance pi = (PinInstance)sc.getDPPB().second;
            for (PinInstance contact : pi.getExternallyConnected()) {
                ConnectivityMgmt.unHookPin((DevicePath)contact.getDevice().getADevicePath(), (PinTemplate)contact.getPinTemplate());
            }
            ConnectivityMgmt.unHookPin((DevicePath)sc.getDevicePathB(), (PinTemplate)sc.getPortB().getPinTemplate());
        }
    }

    public static void deletePotentialContacts(String bundleKeyStr) {
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            return;
        }
        Personality routeGroup = bundle.getRouteGroup();
        if (routeGroup == null) {
            return;
        }
        HashSet<PinTemplate> toBeDeleted = new HashSet<PinTemplate>();
        for (SchedConn sc : routeGroup.getSchedConns()) {
            PinTemplate contact;
            if (!sc.getHierPortB().complete() || !(contact = sc.getHierPortB().getPinTemplate()).getType().equals((Object)PinTemplate.Type.CONTACT)) continue;
            toBeDeleted.add(contact);
        }
        for (PinTemplate pt : toBeDeleted) {
            pt.deleteFromDb();
        }
    }

    protected void returnEditedBundle() {
        DbHistory history = OrbitIO.getCurDb().getHistory();
        if (this.mTransaction != null) {
            this.mTransaction.close();
            this.mTransaction = null;
        }
        if (this.mMode == UseMode.BeginEdit) {
            history.undo();
        }
        if (this.mMode == UseMode.DoingEdit) {
            history.undo();
            history.undo();
        }
        if (this.mParent != null) {
            this.mParent.endSubmode();
        }
        OrbitIO.getApp().refreshCurrentView(false);
        this.mMode = UseMode.Unknown;
    }

    public void start() {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        EditRouteMode erm = new EditRouteMode();
        DevicePath dp = this.mBundle.getTemplate().getAnInstance().getADevicePath();
        erm.setBundle(dp);
        v.setMode(erm);
        this.mLastLoc = null;
        this.ci.show((DesignView2D)OrbitIO.getCurView());
        this.createKeyBindings();
        erm.startBundle(this);
        v.getCanvas().requestFocus();
    }

    protected void removeKeyBindings() {
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        if (v2 == null) {
            return;
        }
        InputMap inputMap = v2.getInputMap(2);
        for (KeyStroke keyStroke : this.mMappedKeyStrokes) {
            inputMap.put(keyStroke, "none");
        }
    }

    protected void createKeyBindings() {
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        v2.getActionMap().put("toZoom", this.toZoom);
        this.bindKey("T", "toZoom", true);
        v2.getActionMap().put("allZoom", this.allZoom);
        this.bindKey("A", "allZoom", true);
        v2.getActionMap().put("fromZoom", this.fromZoom);
        this.bindKey("F", "fromZoom", true);
        v2.getActionMap().put("squish", this.changeCost);
        this.bindKey("S", "squish", true);
        v2.getActionMap().put("commit", this.commit);
        this.bindKey("E", "commit", true);
        v2.getActionMap().put("lock", this.lock);
        this.bindKey("L", "lock", true);
        v2.getActionMap().put("diff", this.changeDiffAlgorithm);
        this.bindKey("O", "diff", true);
        v2.getActionMap().put("simple", this.simpleToggle);
        this.bindKey("Q", "simple", true);
        v2.getActionMap().put("project", this.projectToggle);
        this.bindKey("W", "project", true);
    }

    /*
     * WARNING - void declaration
     */
    public void commit() {
        APoint2D curLoc;
        if (this.mBundle == null) {
            theInteractiveBundleCreator = null;
            if (this.mParent != null) {
                this.mParent.endSubmode();
            }
            return;
        }
        APoint2D lastCurLoc = this.mParent != null && this.mParent.getCursorLoc() != null ? this.mParent.getCursorLoc() : null;
        APoint2D lastBundleLoc = this.mBundle.getPath() != null ? this.mBundle.getPath().getLastPoint() : null;
        APoint2D aPoint2D = curLoc = lastCurLoc != null ? lastCurLoc : lastBundleLoc;
        if (curLoc == null) {
            return;
        }
        AffineTransform t = this.getADevicePath().getTransform();
        AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
        APoint2D bundleLoc = lastCurLoc != null ? curLoc.transform(tI) : lastBundleLoc;
        int loop = 0;
        this.mActive.clear();
        this.mActive.addAll(this.mActiveBak);
        int maxLoop = Math.min(20, this.mActive.size());
        boolean reseq = true;
        while (loop <= maxLoop && reseq) {
            this.mFromCandidates.clear();
            for (PreSchedConn preSchedConn : this.mActive) {
                this.mFromCandidates.add(preSchedConn.from);
            }
            this.mFromPattern = BundleRakeUtil.deriveOptimizedPattern((Bundle)this.mBundle, (boolean)true, this.mFixedPinsLocs, this.mFromCandidates, (APoint2D)bundleLoc, (APoint2D)this.getFromCenter());
            reseq = this.untangleStart();
            if (!reseq || loop > maxLoop) continue;
            ++loop;
        }
        reseq = true;
        for (loop = 0; loop <= maxLoop && reseq; ++loop) {
            this.mFreePinsLocs.clear();
            this.mToFiltered.clear();
            for (PreSchedConn preSchedConn : this.mActive) {
                if (preSchedConn.to == null) continue;
                this.mFreePinsLocs.add(preSchedConn.to.loc);
                this.mToFiltered.add(preSchedConn.to);
            }
            this.mToPattern = BundleRakeUtil.deriveOptimizedPattern((Bundle)this.mBundle, (boolean)false, this.mFreePinsLocs, this.mToFiltered, (APoint2D)bundleLoc, (APoint2D)this.getToCenter());
            if (this.mOptimizeFreeEndFlag) {
                void var12_16;
                ArrayList<AbstractPin> mBackup = new ArrayList<AbstractPin>();
                for (PreSchedConn preSchedConn : this.mActive) {
                    mBackup.add(preSchedConn.to);
                }
                this.findClosest();
                this.optimizeFreeEnd();
                ArrayList<AbstractPin> arrayList = new ArrayList<AbstractPin>();
                for (PreSchedConn p : this.mActive) {
                    arrayList.add(p.to);
                }
                boolean bl = false;
                while (var12_16 < mBackup.size() && (mBackup.get((int)var12_16) == null || arrayList.get((int)var12_16) == null || ((AbstractPin)mBackup.get((int)var12_16)).pin == ((AbstractPin)arrayList.get((int)var12_16)).pin)) {
                    ++var12_16;
                }
                if (var12_16 != mBackup.size()) continue;
                reseq = false;
                continue;
            }
            reseq = false;
        }
        this.addBundleToDb();
        DiffPairFinder.setInitialDiffPairAlog((Db)this.mBundle.getDb(), (String)this.mBundle.getAlignmentAlgo());
        this.ci.hide();
        this.showDiffPairStatus(false);
        BundleCreationDlg.resetStatus();
        theInteractiveBundleCreator = null;
        this.mParent.endSubmode();
    }

    protected void showDiffPairStatus(boolean show) {
        if (show) {
            OrbitIO.getApp().getWorkspace().setStatus(this.mOptDescription);
        } else {
            OrbitIO.getApp().getWorkspace().setStatus("");
        }
    }

    public void bindKey(String key, String action, boolean global) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        InputMap inputMap = v2.getInputMap(global ? 2 : 1);
        inputMap.put(keyStroke, action);
        this.mMappedKeyStrokes.add(keyStroke);
    }

    public ARect getToRect() {
        ARect r = new ARect();
        int size = this.mActive.size();
        if (size > 0) {
            int i;
            for (i = 0; i < size && this.mActive.get((int)i).to == null; ++i) {
            }
            if (i == size) {
                return null;
            }
            r.setBounds(this.mActive.get((int)i).to.pin.getWorldBounds());
            for (PreSchedConn hpp : this.mActive) {
                if (hpp == null || hpp.to == null || hpp.to.pin == null) continue;
                r.expand(hpp.to.pin.getWorldBounds());
            }
            return r;
        }
        return null;
    }

    protected APoint2D worldLocOnABundle(APoint2D p) {
        DevicePath dp = this.getADevicePath();
        dp = dp.getRelativePath(this.mBundle.getTemplate());
        AffineTransform t = dp.getTransform();
        return p.transform(t);
    }

    public ARect getFromRect() {
        ARect r = new ARect();
        if (!this.mActive.isEmpty()) {
            r.setBounds(this.mActive.get((int)0).from.pin.getWorldBounds());
            for (PreSchedConn hpp : this.mActive) {
                r.expand(hpp.from.pin.getWorldBounds());
            }
            return r;
        }
        return null;
    }

    public DevicePath deriveLeastCommonTemplate(List<HierPin> staticSet, List<HierPin> dynamicSet) {
        DevicePath common = null;
        for (HierPin dpp : staticSet) {
            common = dpp.getPath().commonParent(common);
        }
        for (HierPin dpp : dynamicSet) {
            common = dpp.getPath().commonParent(common);
        }
        if (common == null || common.isEmpty() && common.getRoot() == null) {
            ALog.logInfo((String)"There is no common template");
        } else {
            common = new DevicePath(common);
        }
        return common;
    }

    protected void loadPreSchedConnFromBundle() {
        this.mActive.clear();
        for (SchedConn sc : this.mBundle.getSchedConn()) {
            PreSchedConn psc = new PreSchedConn(sc.getDPPA(), sc.getDPPB(), this.mBundle.getTemplate());
            this.mActive.add(psc);
        }
    }

    protected void loadPreSchedConn(HashSet<HierPin> inFromSet, HashSet<HierPin> inToSet, DeviceTemplate common) {
        LinkedHashSet<HierPin> fromSet = new LinkedHashSet<HierPin>(inFromSet);
        LinkedHashSet<HierPin> toSet = new LinkedHashSet<HierPin>(inToSet);
        HashMap<HierPin, HierPin> originalMapping = new HashMap<HierPin, HierPin>();
        this.mFixedPinsLocs.clear();
        this.mFreePinsLocs.clear();
        this.mToFiltered.clear();
        this.mActive.clear();
        this.mActiveBak.clear();
        LinkedHashSet<HierPin> candidateTo = new LinkedHashSet<HierPin>();
        candidateTo.addAll(toSet);
        for (HierPin from : fromSet) {
            for (HierPin candidate : NetMap.getConnectedDevicePathPorts((Net)((PinInstance)from.second).getNet(), (DevicePath)((DevicePath)from.first))) {
                if (!candidateTo.contains(candidate)) continue;
                originalMapping.put(from, candidate);
                candidateTo.remove(candidate);
            }
        }
        for (HierPin hp : toSet) {
            if (hp == null || hp.getPath() == null) continue;
            HierPin z = new HierPin(hp.getPath().getRelativePathFromAnchor(common), (PinInstance)hp.second);
            if (z.first == null) {
                ALog.logWarn((String)"Found that pin %s is out of DeviceTemplate %s. Please check the physical connections of Wire/VIAs.\n", (Object[])new Object[]{hp.getPin(), common.getName()});
                continue;
            }
            this.mToCandidates.add(new AbstractPin(z));
        }
        candidateTo.clear();
        candidateTo.addAll(toSet);
        for (HierPin from : fromSet) {
            HierPin to = (HierPin)originalMapping.get(from);
            if (to == null && !candidateTo.isEmpty()) {
                to = (HierPin)candidateTo.iterator().next();
            }
            if (to != null) {
                candidateTo.remove(to);
            }
            HierPin f = new HierPin(from.getPath().getRelativePathFromAnchor(common), (PinInstance)from.second);
            HierPin t = null;
            if (to != null && to.second != null) {
                t = new HierPin(to.getPath().getRelativePathFromAnchor(common), (PinInstance)to.second);
            }
            PreSchedConn psc = new PreSchedConn(f, t, common);
            this.mActiveBak.add(psc);
        }
        if (!this.mMode.equals((Object)UseMode.BeginEdit) || this.mOptimizeFreeEndFlag) {
            long lowestX = Long.MAX_VALUE;
            long highestX = Long.MIN_VALUE;
            long lowestY = Long.MAX_VALUE;
            long highestY = Long.MIN_VALUE;
            long sumX = 0L;
            long sumY = 0L;
            boolean horizontal = true;
            for (PreSchedConn p : this.mActiveBak) {
                long ptX = p.from.pin.getWorldLoc().getX();
                long ptY = p.from.pin.getWorldLoc().getY();
                lowestX = Math.min(lowestX, ptX);
                lowestY = Math.min(lowestY, ptY);
                highestX = Math.max(highestX, ptX);
                highestY = Math.max(highestY, ptY);
                sumX += ptX;
                sumY += ptY;
            }
            long skewX = highestX - lowestX;
            long skewY = highestY - lowestY;
            horizontal = skewX > skewY;
            APoint2D meanPt = new APoint2D(sumX / (long)this.mActiveBak.size(), sumY / (long)this.mActiveBak.size());
            ARect deviceBound = ((PinInstance)this.mActiveBak.get((int)0).from.pin.second).getDevice().getBounds();
            long midDevX = deviceBound.centerX();
            long midDevY = deviceBound.centerY();
            APoint2D midDevPt = new APoint2D(midDevX, midDevY);
            int dir = 110;
            if (meanPt.getX() > midDevPt.getX() && skewY > skewX) {
                dir = 101;
            } else if (meanPt.getY() > midDevPt.getY() && skewX > skewY) {
                dir = 115;
            } else if (meanPt.getX() < midDevPt.getX() && skewY > skewX) {
                dir = 119;
            }
            Collections.sort(this.mActiveBak, new ActiveSorter(horizontal, (char)dir));
        }
        for (PreSchedConn p : this.mActiveBak) {
            this.mFixedPinsLocs.add(p.from.loc);
        }
        this.mActive.addAll(this.mActiveBak);
    }

    public void setConstraints(long width, long clr, String ra) {
        this.setConstraints(width, clr, Constraint.RouteAngle.valueOf((String)ra));
    }

    public void setConstraints(long width, long clr, Constraint.RouteAngle ra) {
        this.mWireWidth = width;
        this.mWireClear = clr;
        this.mRouteAngle = ra;
    }

    public void setOptAlgorithm(String algorithm) {
        this.mOptAlgorithm = algorithm;
        this.mOptDescription = DiffPairFinder.costToFunction((String)this.mOptAlgorithm).getName();
    }

    protected boolean getOptimize() {
        return this.mOptimize.isSelected();
    }

    protected void setOptimize(boolean b) {
        this.mOptimize.setSelected(b);
    }

    protected void createOptionMenus() {
        this.mLayers = new JMenuItem(new AbstractAction("Select layers..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet<Layer> preSelected = new HashSet<Layer>();
                preSelected.addAll(InteractiveBundleCreator.this.mLayerList);
                LayerSelectorDlg layerDialog = LayerSelectorDlg.showMe(OrbitIO.getCurView(), BundleCreationDlg.getSubstrate(), preSelected);
                if (layerDialog.getUserOked()) {
                    InteractiveBundleCreator.this.mLayerList.clear();
                    layerDialog.getSelected().stream().forEach(l -> InteractiveBundleCreator.this.mLayerList.add((Layer)l));
                }
            }
        });
        this.mSnap45Deg = new JCheckBoxMenuItem(new AbstractAction("Snap 45 Degree"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InteractiveBundleCreator.this.mSnap45Deg.isSelected()) {
                    InteractiveBundleCreator.this.constrainAngle45();
                } else {
                    InteractiveBundleCreator.this.constrainAngleAny();
                }
            }
        });
        this.mOptimize = new JCheckBoxMenuItem(new AbstractAction(OptimizeBundleCommand){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveBundleCreator.this.mOptimizeFreeEndFlag = InteractiveBundleCreator.this.mOptimize.isSelected();
                BundleCreationDlg.setOptimizeFreeEnd(OrbitIO.getCurDb(), InteractiveBundleCreator.this.mOptimizeFreeEndFlag);
            }
        });
        this.mUseOnlyUnused = new JCheckBoxMenuItem(new AbstractAction("Optimize to Unconnected Pins Only"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveBundleCreator.this.filterAvailableCandidates();
            }
        });
        this.mUseOnlyUnBundled = new JCheckBoxMenuItem(new AbstractAction("Optimize to UnBundled Pins Only"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveBundleCreator.this.filterAvailableCandidates();
            }
        });
        this.mShowHull = new JCheckBoxMenuItem(new AbstractAction("Show Dynamic Hull"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractiveBundleCreator.this.filterAvailableCandidates();
            }
        });
        this.mUseOnlyUnBundled.setSelected(true);
        this.mOptimize.setSelected(this.mOptimizeFreeEndFlag);
        this.mShowHull.setSelected(true);
        this.mSnap45Deg.setSelected(true);
    }

    protected DevicePath getADevicePath() {
        return this.mBundle.getTemplate().getAnInstance().getADevicePath();
    }

    protected void foldBack() {
        APoint2D curLoc = this.mParent.getCursorLoc();
        if (curLoc == null) {
            return;
        }
        this.foldBack(curLoc);
    }

    protected void foldBack(APoint2D curPt) {
        if (this.mBundle != null && this.mBundle.getTemplate() != null) {
            APath p = this.mBundle.getPath();
            AffineTransform t = this.getADevicePath().getTransform();
            AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
            curPt = curPt.transform(tI);
            for (int i = 0; i < p.getSize() - 1; ++i) {
                APolygon poly = p.getPoly(i);
                if (!poly.pointInside(curPt)) continue;
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.undoSegment(\"%s\", %d);", (Object[])new Object[]{this.mBundle.getKeyStr(), i + 1});
                this.mAnchor = this.mBundle.getPath().getLastPoint();
                this.mAnchor = this.mAnchor.transform(t);
            }
        }
    }

    @Override
    public boolean install(EditRouteMode erm) {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        this.oldViewMode = v.getPriorMode();
        this.mParent = erm;
        this.mAnchor = null;
        this.createOptionMenus();
        this.constrainAngle45();
        return this.filterAvailableCandidates();
    }

    @Override
    public void uninstall() {
        if (this.uninstallingNow) {
            return;
        }
        this.uninstallingNow = true;
        boolean inTheMiddleOfBundleCreation = false;
        if (theInteractiveBundleCreator != null) {
            theInteractiveBundleCreator.cancelCreatingBundle();
            inTheMiddleOfBundleCreation = true;
        }
        this.removeKeyBindings();
        Db db = OrbitIO.getCurDb();
        if (db != null && this.mTransaction != null) {
            this.mTransaction.close();
            this.mTransaction = null;
        }
        this.ci.hide();
        this.showDiffPairStatus(false);
        super.uninstall();
        if (this.oldViewMode != null) {
            DesignView2D v = (DesignView2D)OrbitIO.getCurView();
            if (!inTheMiddleOfBundleCreation) {
                v.setMode(this.oldViewMode);
            }
        }
        this.uninstallingNow = false;
    }

    @Override
    public LinkedList<Component> getContextMenu(Point loc) {
        if (this.mContextMenu == null) {
            this.mContextMenu = new LinkedList();
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(this.mLayers);
            this.mContextMenu.add(this.mSnap45Deg);
            this.mContextMenu.add(this.mOptimize);
            this.mContextMenu.add(this.mUseOnlyUnused);
            this.mContextMenu.add(this.mUseOnlyUnBundled);
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(this.mShowHull);
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(BundleRakeUI.getRakePatternMenu(this, true));
            this.mContextMenu.add(BundleRakeUI.getRakePatternMenu(this, false));
            this.mContextMenu.add(new JMenuItem(new AbstractAction("End & Commit Bundle"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveBundleCreator.this.mouseClicked(1, InteractiveBundleCreator.this.mLastLoc);
                    Cp.exec((String)"_ibr.commit()", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_ibr\");", (Object[])new Object[0]);
                }
            }));
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(new JMenuItem(new AbstractAction("Restart"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.undoSegment(\"%s\", %d);", (Object[])new Object[]{InteractiveBundleCreator.this.mBundle.getKeyStr(), -1});
                    InteractiveBundleCreator.this.mAnchor = InteractiveBundleCreator.this.mBundle.getPath().getLastPoint();
                    InteractiveBundleCreator.this.mRestart = true;
                    if (InteractiveBundleCreator.this.mAnchor != null) {
                        InteractiveBundleCreator.this.mAnchor = InteractiveBundleCreator.this.mAnchor.transform(InteractiveBundleCreator.this.getADevicePath().getTransform());
                    }
                    OrbitIO.getApp().refreshCurrentView(true);
                }
            }));
            this.mContextMenu.add(new JMenuItem(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InteractiveBundleCreator.this.cancelCreatingBundle();
                }
            }));
        }
        return this.mContextMenu;
    }

    public void cancelCreatingBundle() {
        this.ci.hide();
        this.showDiffPairStatus(false);
        theInteractiveBundleCreator = null;
        if (this.mBundle != null && this.mBundle.getTemplate() != null && OrbitIO.getCurDb() != null) {
            Cp.exec((String)"%s.deleteFromDb();", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mBundle)});
            this.returnEditedBundle();
        }
        this.mParent.endSubmode();
        OrbitIO.getApp().refreshCurrentView(true);
    }

    @Override
    public APoint2D mouseMoved(APoint2D oldLoc, APoint2D newLoc) {
        AbstractViewMode.ContextMenu cm = this.mParent.getContextPopUp();
        if (cm != null) {
            return newLoc;
        }
        APoint2D preSnap = new APoint2D(newLoc);
        newLoc = this.snap(newLoc);
        this.mLastLoc = new APoint2D(newLoc);
        this.mParent.repaintOverlay();
        this.scheduleUpdate();
        this.ci.hide();
        this.foldBack(preSnap);
        return newLoc;
    }

    @Override
    public APoint2D mouseClicked(int button, APoint2D location) {
        location = this.snap(location);
        if (button == 1) {
            this.mAnchor = location;
            if (this.getAnchor() == null) {
                this.mLastLoc = new APoint2D(location);
                this.createSegment(location);
            } else {
                this.createSegment(location);
            }
        }
        return location;
    }

    public static Bundle makeABundle(String name, String templateKeyStr, int numWires, long clr, long width, String colorString) {
        Bundle b = Bundle.createBundle((Db)OrbitIO.getCurDb(), (String)name, (String)templateKeyStr);
        b.setNumWires(numWires);
        b.setWireClr(clr);
        b.setWireWidth(width);
        b.getPath().setWidth(b.bundleWidth());
        b.setColor(AUtil.colorFromString((String)colorString));
        b.setRakeVersions("2.0");
        b.setOptimizedPattern(true);
        return b;
    }

    private void filterSchedConns() {
        ArrayList<PinInstance> fixedPropsA = new ArrayList<PinInstance>();
        ArrayList<PinInstance> fixedPropsB = new ArrayList<PinInstance>();
        ArrayList<AbstractPin> reassignA = new ArrayList<AbstractPin>();
        ArrayList<AbstractPin> reassignB = new ArrayList<AbstractPin>();
        ArrayList<PreSchedConn> mToDelete = new ArrayList<PreSchedConn>();
        for (SchedConn sc : this.mBundle.getSchedConn()) {
            PinInstance pinB = sc.getDPPB().getPin();
            if (!pinB.fixed()) continue;
            fixedPropsB.add(pinB);
            fixedPropsA.add(sc.getDPPA().getPin());
        }
        block1: for (PinInstance pinA : fixedPropsA) {
            for (PreSchedConn psc : this.mActive) {
                if (!psc.from.pin.getPin().equals(pinA)) continue;
                PinInstance pinB = psc.to.pin.getPin();
                if (pinB.fixed()) continue block1;
                reassignB.add(psc.to);
                continue block1;
            }
        }
        block3: for (PreSchedConn psc : this.mActive) {
            for (PinInstance pinA : fixedPropsA) {
                if (!psc.from.pin.getPin().equals(pinA)) continue;
                mToDelete.add(psc);
                continue block3;
            }
        }
        for (PreSchedConn psc : mToDelete) {
            this.mActive.remove(psc);
        }
        for (PinInstance pinB : fixedPropsB) {
            for (PreSchedConn psc : this.mActive) {
                if (!psc.to.pin.getPin().equals(pinB)) continue;
                reassignA.add(psc.from);
            }
        }
        int index = 0;
        block8: for (AbstractPin absPinA : reassignA) {
            for (PreSchedConn psc : this.mActive) {
                if (!psc.from.equals(absPinA)) continue;
                psc.to = (AbstractPin)reassignB.get(index++);
                continue block8;
            }
        }
    }

    public void changeAfterOpt() {
        PinPairConnectionFactory cf = new PinPairConnectionFactory();
        cf.setBaseName(this.mBundle.getName() + "_");
        cf.setConnectTemplate(this.mBundle.getTemplate());
        for (SchedConn sc : this.mBundle.getSchedConn()) {
            HierPin from = sc.getDPPA();
            boolean found = false;
            for (PreSchedConn psc : this.mActive) {
                if (!psc.from.pin.equals((Object)from)) continue;
                if (psc.to == null) break;
                sc.setPortB(psc.to.pin.getPath().getRelativePathFromAnchor(this.mBundle.getTemplate()), ((PinInstance)psc.to.pin.second).getPinTemplate().getFirstPortTemplate());
                cf.load(sc);
                found = true;
                break;
            }
            if (found) continue;
            ALog.logInfo((String)("not optimized from pin " + sc.getDPPA().getSecond().getName() + " to " + sc.getDPPB().getSecond().getName()));
        }
        cf.connect();
    }

    public void addBundleToDb() {
        if (this.mBundle == null) {
            return;
        }
        this.mBundle.clearLayers();
        for (Layer l : this.mLayerList) {
            this.mBundle.addLayer(l);
        }
        this.mBundle.removeSchedConns();
        int i = 0;
        PinPairConnectionFactory cf = new PinPairConnectionFactory();
        cf.setBaseName(this.mBundle.getName() + "_");
        DeviceTemplate bundleDevT = this.mBundle.getTemplate();
        cf.setConnectTemplate(bundleDevT);
        for (PreSchedConn psc : this.mActive) {
            DevicePath fromRelPath = psc.from.pin.getPath().getRelativePathFromAnchor(bundleDevT);
            PinTemplate fromPinT = ((PinInstance)psc.from.pin.second).getPinTemplate();
            SchedConn sc = SchedConn.create((DbObject)this.mBundle, (DevicePath)fromRelPath, (PortTemplate)fromPinT.getFirstPortTemplate(), null, null);
            if (psc.to != null) {
                DevicePath toRelPath = psc.to.pin.getPath().getRelativePathFromAnchor(bundleDevT);
                PinTemplate toPinT = ((PinInstance)psc.to.pin.second).getPinTemplate();
                sc.setPortB(toRelPath, toPinT.getFirstPortTemplate());
            }
            Bundle.setInOrder((SchedConn)sc, (int)i);
            cf.load(sc);
            ++i;
        }
        if (!this.mMode.equals((Object)UseMode.AutoCreate)) {
            InteractiveBundleCreator.removeFloorplanPins(this.mBundle);
        }
        cf.setIsVerifyContactSync(isVerifyContactSync);
        cf.connect();
        this.mBundle.setBreakoutStatus(Bundle.BreakoutStatus.Assigned);
        this.mBundle.setAlignmentAlgo(this.mOptAlgorithm);
        if (!this.mMode.equals((Object)UseMode.AutoCreate)) {
            InteractiveBundleCreator.setFloorplanPinsToFreePins(this.mBundle);
        }
        this.mBundle.update();
        int badCount = Bundle.fixUpBundle((Bundle)this.mBundle);
        if (badCount > 0) {
            ALog.logWarn((String)"Some connections were removed.");
        }
        BundleCommands.updateBundleAfterSwap(this.mBundle, true);
        this.mBundle.setRakePts(this.mFromPattern, this.mToPattern);
    }

    public static void removeFloorplanPins(Db db, String bundleKeyStr) {
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle != null) {
            InteractiveBundleCreator.removeFloorplanPins(bundle);
        }
    }

    public static void removeFloorplanPins(Bundle bundle) {
        Interface interface1 = bundle.getInterface();
        if (interface1 != null) {
            SchedConn aSchedConn = bundle.getNth(0);
            if (aSchedConn == null || aSchedConn.getPathB() == null) {
                return;
            }
            if (aSchedConn.getPathA() == aSchedConn.getPathB()) {
                return;
            }
            DeviceTemplate freeTemplate = aSchedConn.getDevicePathB().pathToSubstrate().getDeviceTemplate();
            Floorplan fp = interface1.getFloorplan(freeTemplate, true);
            if (fp != null) {
                fp.removePins(false);
            }
        }
    }

    public static void setFloorplanPinsToFreePins(Bundle bundle) {
        Interface interface1 = bundle.getInterface();
        if (interface1 != null) {
            SchedConn aSchedConn = bundle.getNth(0);
            if (aSchedConn.getPathB() == null) {
                return;
            }
            DeviceTemplate freeTemplate = aSchedConn.getDevicePathB().pathToSubstrate().getDeviceTemplate();
            Floorplan fp = interface1.getFloorplan(freeTemplate, false);
            if (fp != null) {
                for (SchedConn sc : bundle.getSchedConn()) {
                    if (sc.getPathB() == null) continue;
                    DevicePath devicePath = sc.getPathB().getDevicePath();
                    Device d = devicePath.getLast();
                    if (d == null) {
                        d = freeTemplate.getAnInstance();
                    }
                    devicePath = devicePath.getRelativePathFromAnchor(freeTemplate);
                    StoredPath relativePath = StoredPath.get((DevicePath)devicePath);
                    PinTemplate pt = sc.getPortB().getPinTemplate();
                    PinInstance pi = d.getPin(pt);
                    if (pi.isWireEnd()) continue;
                    fp.addPin(relativePath, pi);
                }
            }
        }
    }

    @Override
    public boolean createSegment(APoint2D loc) {
        long dist;
        AffineTransform t = this.getADevicePath().getTransform();
        AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
        APoint2D o = loc.transform(tI);
        if (this.mBundle.getPath().getPointCount() > 0 && (double)(dist = Math.abs(o.distance(this.mBundle.getPath().getLastPoint()))) < 0.25 * (double)this.mBundle.bundleWidth()) {
            return true;
        }
        Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.addSegment (\"%s\", %dL, %dL);", (Object[])new Object[]{this.mBundle.getKeyStr(), o.getX(), o.getY()});
        this.mParent.repaintView();
        return true;
    }

    public static void addSegment(String bundleKeyStr, long x, long y) {
        Db db = OrbitIO.getCurDb();
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle != null) {
            bundle.addBundlePoint(x, y);
        }
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        if (this.mBundle == null || this.mBundle.getTemplate() == null) {
            this.cancelCreatingBundle();
            return;
        }
        APoint2D curLoc = this.mParent.getCursorLoc();
        if (curLoc == null) {
            return;
        }
        AffineTransform t = this.getADevicePath().getTransform();
        AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
        APoint2D bundleLoc = curLoc.transform(tI);
        this.mGraphics = g;
        Color colorOld = g.getColor();
        Stroke strokeOld = g.getStroke();
        int screenWidth = this.mParent.getScreenLen(this.mBundle.bundleWidth());
        BasicStroke stroke = new BasicStroke(screenWidth, 0, 1);
        g.setColor(this.mBundle.getColor());
        g.setStroke(stroke);
        APoint2D anchor = this.getAnchor();
        if (anchor != null) {
            anchor = anchor.transform(this.getADevicePath().getTransform());
        }
        if (anchor != null) {
            Point p1 = this.mParent.getScreenPoint(anchor);
            Point p2 = this.mParent.getScreenPoint(curLoc);
            Line2D.Float line = new Line2D.Float(p1, p2);
            g.draw(line);
            if (this.mBundle.getPath().getPointCount() > 1) {
                g.fillOval(p1.x - screenWidth / 2, p1.y - screenWidth / 2, screenWidth, screenWidth);
            }
        }
        if (curLoc != null) {
            this.mFreePinsLocs.clear();
            this.mToFiltered.clear();
            this.mFromCandidates.clear();
            for (PreSchedConn con : this.mActive) {
                this.mFromCandidates.add(con.from);
                if (con.to == null) continue;
                this.mFreePinsLocs.add(con.to.loc);
                this.mToFiltered.add(con.to);
            }
            this.mFromPattern = BundleRakeUtil.deriveOptimizedPattern((Bundle)this.mBundle, (boolean)true, this.mFixedPinsLocs, this.mFromCandidates, (APoint2D)bundleLoc, (APoint2D)this.getFromCenter());
            this.mToPattern = BundleRakeUtil.deriveOptimizedPattern((Bundle)this.mBundle, (boolean)false, this.mFreePinsLocs, this.mToFiltered, (APoint2D)bundleLoc, (APoint2D)this.getToCenter());
            this.untangleStart();
            if (this.mOptimizeFreeEndFlag) {
                this.findClosest();
                this.optimizeFreeEnd();
            }
            this.drawFromSet(g);
            this.drawToSet(g);
            if (this.mShowHull.isSelected()) {
                this.drawToHull2(g);
            }
            if (this.mProjectOutPoint && this.mBundle.getPath().getPointCount() > 0) {
                APoint2D lastPoint = this.mBundle.getPath().getLastPoint();
                lastPoint = lastPoint.transform(t);
                ALine p = new ALine(lastPoint, curLoc);
                p.extendEnds(this.getBundleProjectionLength());
                int r = this.mParent.getScreenLen(this.mBundle.bundleWidth() / 2L);
                Point p1 = this.mParent.getScreenPoint(curLoc);
                Point p2 = this.mParent.getScreenPoint(p.getP1());
                Line2D.Float line = new Line2D.Float(p1, p2);
                g.setColor(new Color(255, 0, 0, 64));
                g.fillOval((int)((Line2D)line).getX2() - r / 2, (int)((Line2D)line).getY2() - r / 2, r, r);
            }
        }
        g.setStroke(strokeOld);
        g.setPaintMode();
        g.setColor(colorOld);
    }

    protected void setNets() {
        Db db = OrbitIO.getCurDb();
        Design stop = Design.getDesign((Db)db);
        for (PreSchedConn psc : this.mActive) {
            HierPin dpp = psc.from.pin;
            Net n = NetMap.getTopmostNet((Net)dpp.getNet(), (DevicePath)dpp.getPath());
            HierPin endDPP = psc.from.pin;
            endDPP.getPin().setNetFromHereToTemplate(n.getName(), (DeviceTemplate)stop);
        }
    }

    protected APoint2D getAnchor() {
        return this.mBundle.getPath().getLastPoint();
    }

    protected APoint2D getStart() {
        return this.mBundle.getPath().getFirstPoint();
    }

    public static void undoSegment(String bundleKeyStr) {
        Db db = OrbitIO.getCurDb();
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle != null) {
            APath path = bundle.getPath();
            if (path.getPointCount() == 0) {
                return;
            }
            if (path.getPointCount() > 1) {
                bundle.getPath().removeLast();
                OrbitIO.getApp().refreshCurrentView(true);
            }
        }
    }

    public static void undoSegment(String bundleKeyStr, int i) {
        Db db = OrbitIO.getCurDb();
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle != null) {
            APath path = bundle.getPath();
            if (path.getPointCount() == 0) {
                return;
            }
            if (i == -1) {
                bundle.getPath().removeAllPoints();
            }
            if (path.getPointCount() > 1) {
                int numToRemove = path.getPointCount() - i;
                for (int j = 0; j < numToRemove; ++j) {
                    bundle.getPath().removeLast();
                }
                OrbitIO.getApp().refreshCurrentView(true);
            }
        }
    }

    public void untangleStart(String bundleKeyStr) {
        Bundle bundle = (Bundle)OrbitIO.getCurDb().getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            return;
        }
        this.untangleStart(bundle);
    }

    public void untangleStart(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Db db = bundle.getDb();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)UntangleStartCommand);){
            this.mBundle = bundle;
            this.loadPreSchedConnFromBundle();
            bundle.setRakePtsList(true, null);
            this.mFromPattern = bundle.getRakePattern(true);
            this.untangleStart();
            bundle.setRakePtsList(true, null);
            this.moveActiveToSchedConn(bundle);
            OrbitIO.getApp().refreshCurrentView(true);
            theInteractiveBundleCreator = null;
        }
    }

    protected void moveActiveToSchedConn(Bundle bundle) {
        int i = 0;
        LinkedList list = new LinkedList(bundle.getSchedConn());
        block0: for (PreSchedConn psc : this.mActive) {
            for (SchedConn sc : list) {
                if (sc.getDPPA().second != psc.from.pin.second) continue;
                Cp.exec((String)"SchedConn _sc1 = OrbitIO.getCurDb().getByKeyStr(SchedConn.class, \"%s\");", (Object[])new Object[]{sc.getKeyStr()});
                Cp.exec((String)"Bundle.setInOrder(_sc1,  %d);", (Object[])new Object[]{i++});
                continue block0;
            }
        }
    }

    protected boolean untangleStart() {
        int size;
        boolean gettingBetter = true;
        int lastx = -1;
        int thisx = 0;
        int pass = 0;
        int maxPass = size = Math.min(this.mActive.size(), this.mFromPattern.size());
        boolean reseq = true;
        while (gettingBetter) {
            thisx = this.reseq(true);
            if (lastx == -1) {
                if (thisx == 0) {
                    gettingBetter = false;
                    reseq = false;
                } else {
                    gettingBetter = true;
                }
            } else if (thisx < lastx || thisx > lastx) {
                gettingBetter = true;
            } else if (thisx == 0) {
                gettingBetter = false;
            }
            lastx = thisx;
            if (++pass <= maxPass) continue;
            reseq = false;
            break;
        }
        if (this.mOptDiff) {
            this.optDiffPairOnRake();
            this.optDiffPairOnRake();
        }
        return reseq;
    }

    protected int reseq(boolean fixed) {
        int size = Math.min(this.mActive.size(), this.mFromPattern.size());
        DevicePath dp = this.getADevicePath();
        AffineTransform t = dp.getRelativePathFromAnchor(this.mBundle.getTemplate()).getTransform();
        int thisx = 0;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                APoint2D p0 = this.mActive.get((int)i).from.loc;
                APoint2D p1 = this.mFromPattern.get(i);
                p1 = p1.transform(t);
                ALine lI = new ALine(p0, p1);
                APoint2D p2 = this.mActive.get((int)j).from.loc;
                APoint2D p3 = this.mFromPattern.get(j);
                ALine lJ = new ALine(p2, p3 = p3.transform(t));
                if (!lI.intersects((AGeom)lJ)) continue;
                PreSchedConn temp = this.mActive.get(i);
                this.mActive.set(i, this.mActive.get(j));
                this.mActive.set(j, temp);
                ++thisx;
            }
        }
        return thisx;
    }

    protected void moveActive(int i, int j) {
        if (i > j) {
            PreSchedConn temp = this.mActive.get(i);
            for (int k = i - 1; k >= j; --k) {
                this.mActive.set(k + 1, this.mActive.get(k));
            }
            this.mActive.set(j, temp);
        } else {
            PreSchedConn temp = this.mActive.get(i);
            for (int k = i + 1; k <= j; ++k) {
                this.mActive.set(k - 1, this.mActive.get(k));
            }
            this.mActive.set(j, temp);
        }
    }

    protected boolean fixThisOne(int i, int j, Personality pI, HashSet<Personality> processed) {
        Personality pK;
        int k;
        int size = this.mActive.size();
        processed.add(pI);
        Long[] opt = new Long[4];
        opt[0] = null;
        opt[1] = null;
        if (i < size - 1) {
            k = i + 1;
            pK = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)k).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)k).from.pin.getPath());
            if (!processed.contains(pK)) {
                this.moveActive(j, k);
                opt[0] = this.crossesToStart();
                this.moveActive(k, j);
            }
        }
        if (j > 0) {
            k = j - 1;
            pK = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)k).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)k).from.pin.getPath());
            if (!processed.contains(pK)) {
                this.moveActive(i, k);
                opt[1] = this.crossesToStart();
                this.moveActive(k, i);
            }
        }
        Integer minOne = null;
        for (int m = 0; m < 2; ++m) {
            if (opt[m] == null) continue;
            minOne = m;
            break;
        }
        if (minOne != null) {
            int a;
            Long val = opt[minOne];
            for (int m = 0; m < 2; ++m) {
                if (opt[m] == null || opt[m] >= val) continue;
                minOne = m;
                val = opt[m];
            }
            if (minOne == 0) {
                a = j;
                int b = i + 1;
                this.moveActive(a, b);
            } else if (minOne == 1) {
                a = i;
                int b = j - 1;
                this.moveActive(a, b);
            }
            return true;
        }
        return false;
    }

    protected ArrayList<APoint2D> getDiffPairFreeEndNaturalPoints() {
        ArrayList<APoint2D> pts = new ArrayList<APoint2D>();
        int size = Math.min(this.mActive.size(), this.mToPattern.size());
        HashSet<Personality> seen = new HashSet<Personality>();
        block0: for (int i = 0; i < size; ++i) {
            Personality pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            Boolean matchLength = (Boolean)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)pI, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
            if (seen.contains(pI) || matchLength == null || !matchLength.booleanValue()) continue;
            seen.add(pI);
            for (int j = i + 0; j < size; ++j) {
                Personality pJ = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)j).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)j).from.pin.getPath());
                if (pI != pJ || this.mActive.get(i) == null || this.mActive.get((int)i).to == null) continue;
                APoint2D pointi = this.mActive.get((int)i).to.loc;
                APoint2D pointj = this.mActive.get((int)j).to.loc;
                ALine l = new ALine(pointi, pointj);
                pts.add(l.center());
                continue block0;
            }
        }
        return pts;
    }

    protected void optDiffPairOnRake() {
        int size = this.mActive.size();
        HashSet<Personality> toBeFixed = new HashSet<Personality>();
        HashSet<Personality> processed = new HashSet<Personality>();
        for (int i = 0; i < size; ++i) {
            Personality pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            Boolean matchLength = (Boolean)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)pI, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
            if (matchLength == null || !matchLength.booleanValue() || toBeFixed.contains(pI)) continue;
            toBeFixed.add(pI);
        }
        for (Personality pI : toBeFixed) {
            int i = -1;
            int j = -1;
            for (int m = 0; m < size; ++m) {
                Personality pM = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)m).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)m).from.pin.getPath());
                if (pM != pI) continue;
                if (i == -1) {
                    i = m;
                    continue;
                }
                j = m;
            }
            if (i == -1 || j == -1 || Math.abs(i - j) == 1) continue;
            this.fixThisOne(i, j, pI, processed);
        }
    }

    protected Long crossesToStart() {
        AffineTransform t = this.getADevicePath().getTransform();
        int size = Math.min(this.mActive.size(), this.mFromPattern.size());
        Long crosses = 0L;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                APoint2D p0 = this.mActive.get((int)i).from.loc;
                APoint2D p1 = this.mFromPattern.get(i);
                p1 = p1.transform(t);
                ALine lI = new ALine(p0, p1);
                APoint2D p2 = this.mActive.get((int)j).from.loc;
                APoint2D p3 = this.mFromPattern.get(j);
                ALine lJ = new ALine(p2, p3 = p3.transform(t));
                if (!lI.intersects((AGeom)lJ)) continue;
                Long l = crosses;
                Long l2 = crosses = Long.valueOf(crosses + 1L);
            }
        }
        return crosses;
    }

    protected boolean filterAvailableCandidates() {
        boolean useOnlyUnused = this.mUseOnlyUnused.isSelected();
        boolean useOnlyUnBundled = this.mUseOnlyUnBundled.isSelected();
        this.mFilteredToCandidates.clear();
        int unMappedCount = 0;
        int unUsedCount = 0;
        int bundledCount = 0;
        for (AbstractPin hpp : this.mToCandidates) {
            if (this.mLock && !this.mLockSet.contains(hpp.pin)) continue;
            Net netAtSubstrate = hpp.pin.getSubstrateNetOrNull();
            if (useOnlyUnused && !((PinInstance)hpp.pin.second).getNet().isUnused() && netAtSubstrate != null) {
                ++unUsedCount;
                continue;
            }
            if (useOnlyUnBundled) {
                if (hpp.pin == null) {
                    ALog.logInfo((String)"");
                }
                if (Bundle.isHierPinInvolvedInBundleOnTemplate((HierPin)hpp.pin, (DeviceTemplate)this.mBundle.getTemplate()) != null) {
                    ++bundledCount;
                    continue;
                }
            }
            this.mFilteredToCandidates.add(hpp);
        }
        if (this.mToCandidates.isEmpty()) {
            ALog.logInfo((String)"Starting single sided bundle");
            return true;
        }
        if (this.mFilteredToCandidates.size() != this.mToCandidates.size()) {
            Object buffer = "";
            if (unMappedCount > 0) {
                buffer = (String)buffer + " " + unMappedCount + " ignored because they were not mapped.";
            }
            if (unUsedCount > 0) {
                buffer = (String)buffer + " " + unUsedCount + " ignored because they were NetUnused.";
            }
            if (bundledCount > 0) {
                buffer = (String)buffer + " " + bundledCount + " ignored because they were already in a bundle.";
            }
            ALog.logInfo((String)("Of the original " + this.mToCandidates.size() + " free side pins" + (String)buffer + " Leaving " + this.mFilteredToCandidates.size() + " free pins."));
        }
        if (this.mFilteredToCandidates.isEmpty()) {
            ALog.logInfo((String)"No available free pins");
            return false;
        }
        return true;
    }

    protected long getBundleProjectionLength() {
        long w = this.mBundle.bundleWidth() * 4L;
        if (this.mToPattern != null && this.mToPattern.size() >= 2) {
            ALine l = new ALine(this.mToPattern.get(0), this.mToPattern.get(this.mToPattern.size() - 1));
            w = l.getLength() * 4L;
        }
        return w;
    }

    protected void findClosest() {
        AffineTransform t = this.getADevicePath().getRelativePathFromAnchor(this.mBundle.getTemplate()).getTransform();
        int size = Math.min(this.mActive.size(), this.mToPattern.size());
        if (useDiffPairFinder) {
            int i;
            APoint2D curLoc;
            APoint2D aPoint2D = curLoc = this.mParent != null && this.mParent.getCursorLoc() != null ? this.mParent.getCursorLoc() : this.mBundle.getPath().getLastPoint();
            if (curLoc == null) {
                return;
            }
            if (this.mProjectOutPoint && this.mBundle.getPath().getPointCount() > 0) {
                AffineTransform t1 = this.getADevicePath().getTransform();
                APoint2D lastPoint = this.mBundle.getPath().getLastPoint();
                lastPoint = lastPoint.transform(t1);
                ALine p = new ALine(lastPoint, curLoc);
                p.extendEnds(this.getBundleProjectionLength());
                curLoc = p.getP1();
            }
            AffineTransform tJ = this.getADevicePath().getTransform();
            AffineTransform tI = ATransformUtil.inverse((AffineTransform)tJ);
            APoint2D bundleLoc = this.mParent.getCursorLoc() != null ? curLoc.transform(tI) : this.mBundle.getPath().getLastPoint();
            APair<Integer, Integer> numPins = this.characterizeDiffPairs();
            DiffPairFinder.DistCostFunction costFunction = DiffPairFinder.costToFunction((String)this.mOptAlgorithm);
            ArrayList<APoint2D> pts = this.getDiffPairFreeEndNaturalPoints();
            this.mLastFreeSide = DiffPairFinder.find((APoint2D)bundleLoc, this.mFilteredToCandidates, (int)((Integer)numPins.first), (int)((Integer)numPins.second), (double)mXSquishCost[this.mCostDir], (DiffPairFinder.DistCostFunction)costFunction, pts);
            for (i = 0; i < size; ++i) {
                this.mActive.get((int)i).to = null;
            }
            i = 0;
            Iterator iterator = ((LinkedList)this.mLastFreeSide.second).iterator();
            while (iterator.hasNext()) {
                AbstractPin hp;
                this.mActive.get((int)i).to = hp = (AbstractPin)iterator.next();
                ++i;
            }
            for (CandidatePairs cp : (LinkedList)this.mLastFreeSide.first) {
                this.mActive.get((int)i).to = (AbstractPin)cp.first;
                this.mActive.get((int)(++i)).to = (AbstractPin)cp.second;
                ++i;
            }
        } else {
            HashSet<AbstractPin> usedA = new HashSet<AbstractPin>();
            for (int i = 0; i < size; ++i) {
                APoint2D p0 = this.mToPattern.get(i);
                p0 = p0.transform(t);
                this.mActive.get((int)i).to = null;
                Long bestDist = null;
                AbstractPin bestPin = null;
                for (AbstractPin hpp : this.mFilteredToCandidates) {
                    if (usedA.contains(hpp)) continue;
                    long xDist = Math.abs(p0.xDistance(hpp.loc));
                    long yDist = Math.abs(p0.yDistance(hpp.loc));
                    long dist = (long)((double)xDist * mXSquishCost[this.mCostDir]) + yDist;
                    if (bestPin == null) {
                        bestPin = hpp;
                        bestDist = dist;
                        continue;
                    }
                    if (dist >= bestDist) continue;
                    bestPin = hpp;
                    bestDist = dist;
                }
                if (bestPin == null) continue;
                this.mActive.get((int)i).to = bestPin;
                usedA.add(bestPin);
            }
        }
    }

    protected APair<Integer, Integer> characterizeDiffPairs() {
        int size;
        int numSingles = size = Math.min(this.mActive.size(), this.mToPattern.size());
        int numPairs = 0;
        HashSet<Integer> used = new HashSet<Integer>();
        block0: for (int i = 0; i < size; ++i) {
            if (this.mActive.get((int)i).to == null || used.contains(i)) continue;
            Personality pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            for (int j = i + 1; j < size; ++j) {
                if (this.mActive.get((int)i).to == null || used.contains(j)) continue;
                Personality pJ = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
                if (pI == null || pJ == null || pI != pJ) continue;
                used.add(i);
                used.add(j);
                ++numPairs;
                numSingles -= 2;
                continue block0;
            }
        }
        return new APair((Object)numPairs, (Object)numSingles);
    }

    protected void optimizeFreeEnd() {
        int i;
        int size = Math.min(this.mActive.size(), this.mToPattern.size());
        ArrayList<AbstractPin> fixed = new ArrayList<AbstractPin>();
        DiffPairFinder.DistCostFunction costFunction = DiffPairFinder.costToFunction((String)this.mOptAlgorithm);
        LineUnCrosser lus = new LineUnCrosser();
        for (PreSchedConn psc : this.mActive) {
            fixed.add(psc.to);
        }
        ArrayList answer = lus.uncross(this.mToPattern, fixed, p -> p, q -> q.loc);
        for (i = 0; i < this.mActive.size() && i < answer.size(); ++i) {
            this.mActive.get((int)i).to = (AbstractPin)answer.get(i);
        }
        if (costFunction instanceof DiffPairFinder.MinCross) {
            return;
        }
        fixed.clear();
        for (i = 0; i < size; ++i) {
            Personality p2 = null;
            if (this.mActive.get((int)i).to == null || this.mToPattern.get(i) == null) continue;
            p2 = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            AbstractPin ap = new AbstractPin(this.mToPattern.get(i), p2);
            fixed.add(ap);
            ap.index = i;
        }
        if (this.mLastFreeSide == null) {
            this.characterizeFreeEnd();
        }
        answer.clear();
        answer = DiffPairFinder.diffPairMatch(this.mLastFreeSide, fixed);
        if (!answer.isEmpty()) {
            int thisSize = Math.min(this.mActive.size(), answer.size());
            for (int i2 = 0; i2 < thisSize; ++i2) {
                this.mActive.get((int)i2).to = (AbstractPin)answer.get(i2);
            }
        }
    }

    protected void characterizeFreeEnd() {
        int i;
        AffineTransform t = this.getADevicePath().getRelativePathFromAnchor(this.mBundle.getTemplate()).getTransform();
        int size = this.mActive.size();
        APoint2D curLoc = this.mBundle.getPath().getLastPoint();
        if (curLoc == null && (curLoc = this.mParent.getCursorLoc()) == null) {
            return;
        }
        if ((curLoc = curLoc.transform(t)) == null) {
            return;
        }
        AffineTransform tJ = this.getADevicePath().getTransform();
        AffineTransform tI = ATransformUtil.inverse((AffineTransform)tJ);
        APoint2D bundleLoc = curLoc.transform(tI);
        APair<Integer, Integer> numPins = this.characterizeDiffPairs();
        DiffPairFinder.DistCostFunction costFunction = DiffPairFinder.costToFunction((String)this.mOptAlgorithm);
        ArrayList<AbstractPin> freePins = new ArrayList<AbstractPin>();
        for (PreSchedConn ap : this.mActive) {
            freePins.add(ap.to);
        }
        ArrayList<APoint2D> pts = this.getDiffPairFreeEndNaturalPoints();
        this.mLastFreeSide = DiffPairFinder.find((APoint2D)bundleLoc, freePins, (int)((Integer)numPins.first), (int)((Integer)numPins.second), (double)1.0, (DiffPairFinder.DistCostFunction)costFunction, pts);
        for (i = 0; i < size; ++i) {
            this.mActive.get((int)i).to = null;
        }
        i = 0;
        Iterator iterator = ((LinkedList)this.mLastFreeSide.second).iterator();
        while (iterator.hasNext()) {
            AbstractPin hp;
            this.mActive.get((int)i).to = hp = (AbstractPin)iterator.next();
            ++i;
        }
        for (CandidatePairs cp : (LinkedList)this.mLastFreeSide.first) {
            this.mActive.get((int)i).to = (AbstractPin)cp.first;
            this.mActive.get((int)(++i)).to = (AbstractPin)cp.second;
            ++i;
        }
    }

    public APoint2D getFromCenter() {
        if (this.mActive == null || this.mActive.isEmpty()) {
            return null;
        }
        long xSum = 0L;
        long ySum = 0L;
        for (PreSchedConn psc : this.mActive) {
            xSum += psc.from.loc.getX();
            ySum += psc.from.loc.getY();
        }
        return new APoint2D(xSum / (long)this.mActive.size(), ySum / (long)this.mActive.size());
    }

    public APoint2D getToCenter() {
        if (this.mActive == null || this.mActive.isEmpty()) {
            return null;
        }
        long xSum = 0L;
        long ySum = 0L;
        for (PreSchedConn psc : this.mActive) {
            if (psc.to == null || psc.to.loc == null) continue;
            xSum += psc.to.loc.getX();
            ySum += psc.to.loc.getY();
        }
        return new APoint2D(xSum / (long)this.mActive.size(), ySum / (long)this.mActive.size());
    }

    protected DevicePath makeFullPath(DevicePath full, DevicePath appendedPath) {
        if (full.getDeviceTemplate() == this.mBundle.getTemplate() && !full.isEmpty()) {
            return full.getParent();
        }
        return appendedPath;
    }

    protected void drawFromSet(Graphics2D g) {
        Point prevPoint = null;
        int i = 0;
        if (this.mInstancesOfTemplate.isEmpty()) {
            for (DevicePath dp : this.mBundle.getTemplate().getHierarchicalInstances()) {
                this.mInstancesOfTemplate.add(dp);
            }
        }
        for (PreSchedConn psc : this.mActive) {
            BasicStroke stroke;
            if (i >= this.mBundle.getDefinedArity()) break;
            if (i == 0) {
                stroke = new BasicStroke(3.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(Color.YELLOW);
            } else {
                stroke = new BasicStroke(1.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(Color.BLUE);
                Personality pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
                if (pI != null) {
                    g.setColor(pI.getColor());
                }
            }
            for (DevicePath dp : this.mInstancesOfTemplate) {
                APoint2D p = psc.from.loc;
                AffineTransform t = dp.getTransform();
                p = p.transform(t);
                Point p1 = this.mParent.getScreenPoint(p);
                APoint2D onPattern = this.mFromPattern.get(i);
                onPattern = onPattern.transform(dp.getTransform());
                Point p2 = this.mParent.getScreenPoint(onPattern);
                Line2D.Float line = new Line2D.Float(p1, p2);
                g.draw(line);
                if (prevPoint != null) {
                    BasicStroke stroke2 = new BasicStroke(3.0f, 1, 1);
                    Line2D.Float fromLine = new Line2D.Float(p2, prevPoint);
                    g.setStroke(stroke2);
                    g.setColor(Color.RED);
                    g.draw(fromLine);
                }
                prevPoint = p2;
            }
            ++i;
        }
    }

    protected void drawToHull2(Graphics2D g) {
        HierPinHull hph = new HierPinHull();
        for (PreSchedConn psc : this.mActive) {
            if (psc.to == null) continue;
            HierPin hp = psc.to.pin;
            DevicePath relPath = hp.getPath().getRelativePathFromAnchor(this.mBundle.getTemplate());
            hph.add(new HierPinT(relPath, (PinInstance)hp.second));
        }
        Color bundleColor = this.mBundle.getColor();
        Color c = new Color(bundleColor.getRed(), bundleColor.getGreen(), bundleColor.getBlue(), 128);
        g.setColor(c);
        BasicStroke stroke = new BasicStroke(3.0f, 1, 1);
        g.setStroke(stroke);
        for (DevicePath dp : this.mBundle.getTemplate().getHierarchicalInstances()) {
            DevicePath relPath = dp.getRelativePath(this.mBundle.getTemplate());
            AffineTransform t = relPath.getTransform();
            DefaultViewDrawer.paintGeom(g, hph.getGeom(t), this.mParent.getView().getCanvas().getXForm(), true, false);
        }
    }

    protected void drawToHull(Graphics2D g) {
        ArrayList<APoint2D> pts = new ArrayList<APoint2D>();
        for (PreSchedConn psc : this.mActive) {
            ARect r;
            if (psc.to == null || (r = psc.to.pin.getWorldBounds()) == null) continue;
            pts.add(r.getLL());
            pts.add(r.getUL());
            pts.add(r.getLR());
            pts.add(r.getUR());
        }
        APolygon hull = APolygon.makePrettyHull(pts);
        if (hull != null) {
            Color c = new Color(0.0f, 0.0f, 1.0f, 0.2f);
            g.setColor(c);
            Polygon screenPoly = this.mParent.getScreenPolygon(hull);
            g.fillPolygon(screenPoly);
        }
    }

    protected void drawDiffPairs(Graphics2D g) {
        BasicStroke stroke = new BasicStroke(10.0f, 1, 1);
        g.setStroke(stroke);
        g.setColor(Color.green);
        for (DevicePath dp : this.mInstancesOfTemplate) {
            DevicePath relPath = dp.getRelativePath(this.mBundle.getTemplate());
            AffineTransform t = relPath.getTransform();
            if (this.mLastFreeSide == null) continue;
            for (CandidatePairs cp : (LinkedList)this.mLastFreeSide.first) {
                APoint2D pp = ((AbstractPin)cp.first).loc;
                pp = pp.transform(t);
                APoint2D pn = ((AbstractPin)cp.second).loc;
                pn = pn.transform(t);
                Point p1 = this.mParent.getScreenPoint(pp);
                Point p2 = this.mParent.getScreenPoint(pn);
                Line2D.Float line = new Line2D.Float(p1, p2);
                g.draw(line);
            }
        }
    }

    protected void drawComplexDiffPairs(Graphics2D g) {
        int i = 0;
        int size = 0;
        Point prevPoint = null;
        if (this.mToPattern.isEmpty()) {
            return;
        }
        size = this.mToPattern.size();
        long xSum = 0L;
        long ySum = 0L;
        for (APoint2D pt : this.mToPattern) {
            if (pt == null) {
                --size;
                continue;
            }
            xSum += pt.getX();
            ySum += pt.getY();
        }
        if (size <= 0) {
            return;
        }
        APoint2D midSeqBar = new APoint2D(xSum / (long)size, ySum / (long)size);
        for (PreSchedConn psc : this.mActive) {
            BasicStroke stroke;
            if (i >= this.mBundle.getDefinedArity()) break;
            Personality pI = null;
            pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            if (i == 0) {
                stroke = new BasicStroke(3.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(Color.YELLOW);
            } else {
                stroke = new BasicStroke(1.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(Color.BLUE);
                if (pI != null) {
                    g.setColor(pI.getColor());
                }
            }
            if (psc.to == null) continue;
            for (DevicePath dp : this.mInstancesOfTemplate) {
                APoint2D onPattern;
                APoint2D p = psc.to.loc;
                AffineTransform t = dp.getTransform();
                p = p.transform(t);
                Point p1 = this.mParent.getScreenPoint(p);
                if (i >= this.mToPattern.size() || (onPattern = this.mToPattern.get(i)) == null) break;
                onPattern = onPattern.transform(dp.getTransform());
                Point p2 = this.mParent.getScreenPoint(onPattern);
                Line2D.Float line = new Line2D.Float(p1, p2);
                g.draw(line);
                if (prevPoint != null) {
                    BasicStroke strokeTo = new BasicStroke(3.0f, 1, 1);
                    Line2D.Float fromLine = new Line2D.Float(p2, prevPoint);
                    g.setStroke(strokeTo);
                    g.setColor(Color.GREEN);
                    g.draw(fromLine);
                }
                prevPoint = p2;
                Point midSeqBarScreenPt = this.mParent.getScreenPoint(midSeqBar.transform(dp.getTransform()));
                Point curPt = this.mParent.getScreenPoint(this.mParent.getCursorLoc());
                if (curPt != null && midSeqBarScreenPt != null) {
                    BasicStroke strokeTo = new BasicStroke(3.0f, 1, 1);
                    Line2D.Float fromLine = new Line2D.Float(midSeqBarScreenPt, curPt);
                    g.setStroke(strokeTo);
                    g.setColor(Color.MAGENTA);
                    g.draw(fromLine);
                }
                if (pI == null) continue;
                ARect r = psc.to.pin.getPinTemplate().getBounds();
                DevicePath full = (DevicePath)psc.to.pin.first;
                if (full.isEmpty()) {
                    full = full.getDeviceTemplate().getPathToPresentUser();
                }
                AffineTransform tp = full.getTransform();
                r = r.transform(tp).getBounds();
                Rectangle rs = this.mParent.getScreenRect(r);
                BasicStroke stroke2 = new BasicStroke(3.0f, 1, 1);
                g.setStroke(stroke2);
                g.setColor(pI.getColor());
                g.draw(rs);
            }
            ++i;
        }
    }

    protected void drawSimplePairs(Graphics2D g) {
        Point prevPoint = null;
        long xSum = 0L;
        long ySum = 0L;
        int size = 0;
        if (this.mToPattern.isEmpty()) {
            return;
        }
        size = this.mToPattern.size();
        for (APoint2D pt : this.mToPattern) {
            if (pt == null) {
                --size;
                continue;
            }
            xSum += pt.getX();
            ySum += pt.getY();
        }
        if (size <= 0) {
            return;
        }
        APoint2D midSeqBar = new APoint2D(xSum / (long)size, ySum / (long)size);
        for (int i = 0; i < this.mBundle.getDefinedArity(); ++i) {
            BasicStroke stroke;
            Personality pI = null;
            Personality pJ = null;
            PreSchedConn psc = this.mActive.get(i);
            if (psc.to == null) continue;
            pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            if (pI != null) {
                ARect r = psc.to.pin.getPinTemplate().getBounds();
                DevicePath full = (DevicePath)psc.to.pin.first;
                if (full.isEmpty()) {
                    full = full.getDeviceTemplate().getPathToPresentUser();
                }
                AffineTransform tp = full.getTransform();
                r = r.transform(tp).getBounds();
                Rectangle rs = this.mParent.getScreenRect(r);
                stroke = new BasicStroke(3.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(pI.getColor());
                g.draw(rs);
            }
            if (i >= this.mBundle.getDefinedArity() - 1) continue;
            PreSchedConn pscNext = this.mActive.get(i + 1);
            pJ = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)(i + 1)).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)(i + 1)).from.pin.getPath());
            Point lastPoint = null;
            for (DevicePath dp : this.mInstancesOfTemplate) {
                if (pI == null) {
                    stroke = new BasicStroke(1.0f, 1, 1);
                    g.setStroke(stroke);
                    g.setColor(Color.BLUE);
                    APoint2D p = psc.to.loc;
                    AffineTransform t = dp.getTransform();
                    p = p.transform(t);
                    Point p1 = this.mParent.getScreenPoint(p);
                    APoint2D onPattern = this.mToPattern.get(i);
                    onPattern = onPattern.transform(dp.getTransform());
                    Point p2 = this.mParent.getScreenPoint(onPattern);
                    Line2D.Float line = new Line2D.Float(p1, p2);
                    g.draw(line);
                    lastPoint = p2;
                } else if (pI == pJ) {
                    Point p2;
                    g.setColor(pI.getColor());
                    AffineTransform t = dp.getTransform();
                    APoint2D pFromA = psc.to.loc;
                    pFromA = pFromA.transform(t);
                    APoint2D pFromB = pscNext.to.loc;
                    pFromB = pFromB.transform(t);
                    ALine lineFrom = new ALine(pFromA, pFromB);
                    APoint2D pFrom = lineFrom.center();
                    Point p1 = this.mParent.getScreenPoint(pFrom);
                    APoint2D pToA = this.mToPattern.get(i);
                    pToA = pToA.transform(dp.getTransform());
                    APoint2D pToB = this.mToPattern.get(i + 1);
                    pToB = pToB.transform(dp.getTransform());
                    ALine lineTo = new ALine(pToA, pToB);
                    APoint2D pTo = lineTo.center();
                    lastPoint = p2 = this.mParent.getScreenPoint(pTo);
                    Line2D.Float line = new Line2D.Float(p1, p2);
                    g.draw(line);
                }
                if (prevPoint != null && lastPoint != null) {
                    BasicStroke strokeTo = new BasicStroke(3.0f, 1, 1);
                    Line2D.Float fromLine = new Line2D.Float(lastPoint, prevPoint);
                    g.setStroke(strokeTo);
                    g.setColor(Color.GREEN);
                    g.draw(fromLine);
                }
                prevPoint = lastPoint;
                Point midSeqBarScreenPt = this.mParent.getScreenPoint(midSeqBar.transform(dp.getTransform()));
                Point curPt = this.mParent.getScreenPoint(this.mParent.getCursorLoc());
                if (curPt == null || midSeqBarScreenPt == null) continue;
                BasicStroke strokeTo = new BasicStroke(3.0f, 1, 1);
                Line2D.Float fromLine = new Line2D.Float(midSeqBarScreenPt, curPt);
                g.setStroke(strokeTo);
                g.setColor(Color.GREEN);
                g.draw(fromLine);
            }
        }
    }

    protected void drawToSet(Graphics2D g) {
        Point prevPoint = null;
        int i = 0;
        if (this.mInstancesOfTemplate.isEmpty()) {
            for (DevicePath dp : this.mBundle.getTemplate().getHierarchicalInstances()) {
                this.mInstancesOfTemplate.add(dp);
            }
        }
        if (!this.mOptAlgorithm.equals("x")) {
            this.drawDiffPairs(g);
            if (this.mSimpleDraw) {
                this.drawSimplePairs(g);
            } else {
                this.drawComplexDiffPairs(g);
            }
            return;
        }
        long xSum = 0L;
        long ySum = 0L;
        int size = 0;
        if (this.mToPattern.isEmpty()) {
            return;
        }
        size = this.mToPattern.size();
        for (APoint2D pt : this.mToPattern) {
            if (pt == null) {
                --size;
                continue;
            }
            xSum += pt.getX();
            ySum += pt.getY();
        }
        if (size <= 0) {
            return;
        }
        APoint2D midSeqBar = new APoint2D(xSum / (long)size, ySum / (long)size);
        for (PreSchedConn psc : this.mActive) {
            BasicStroke stroke;
            if (i >= this.mBundle.getDefinedArity()) break;
            Personality pI = null;
            pI = PersonalityMappingMgmt.getConnectedPersonality((Net)((PinInstance)this.mActive.get((int)i).from.pin.second).getNet(), (DevicePath)this.mActive.get((int)i).from.pin.getPath());
            if (i == 0) {
                stroke = new BasicStroke(3.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(Color.YELLOW);
            } else {
                stroke = new BasicStroke(1.0f, 1, 1);
                g.setStroke(stroke);
                g.setColor(Color.BLUE);
                if (pI != null) {
                    g.setColor(pI.getColor());
                }
            }
            if (psc.to == null) continue;
            for (DevicePath dp : this.mInstancesOfTemplate) {
                APoint2D p = psc.to.loc;
                AffineTransform t = dp.getTransform();
                p = p.transform(t);
                Point p1 = this.mParent.getScreenPoint(p);
                APoint2D onPattern = this.mToPattern.get(i);
                onPattern = onPattern.transform(dp.getTransform());
                Point p2 = this.mParent.getScreenPoint(onPattern);
                Line2D.Float line = new Line2D.Float(p1, p2);
                g.draw(line);
                if (prevPoint != null) {
                    BasicStroke strokeTo = new BasicStroke(3.0f, 1, 1);
                    Line2D.Float fromLine = new Line2D.Float(p2, prevPoint);
                    g.setStroke(strokeTo);
                    g.setColor(Color.GREEN);
                    g.draw(fromLine);
                }
                prevPoint = p2;
                Point midSeqBarScreenPt = this.mParent.getScreenPoint(midSeqBar.transform(dp.getTransform()));
                Point curPt = this.mParent.getScreenPoint(this.mParent.getCursorLoc());
                if (curPt != null && midSeqBarScreenPt != null) {
                    BasicStroke strokeTo = new BasicStroke(3.0f, 1, 1);
                    Line2D.Float fromLine = new Line2D.Float(midSeqBarScreenPt, curPt);
                    g.setStroke(strokeTo);
                    g.setColor(Color.GREEN);
                    g.draw(fromLine);
                }
                if (pI == null) continue;
                ARect r = psc.to.pin.getPinTemplate().getBounds();
                DevicePath full = (DevicePath)psc.to.pin.first;
                if (full.isEmpty()) {
                    full = full.getDeviceTemplate().getPathToPresentUser();
                }
                AffineTransform tp = full.getTransform();
                r = r.transform(tp).getBounds();
                Rectangle rs = this.mParent.getScreenRect(r);
                BasicStroke stroke2 = new BasicStroke(3.0f, 1, 1);
                g.setStroke(stroke2);
                g.setColor(pI.getColor());
                g.draw(rs);
            }
            ++i;
        }
    }

    public void setActionHandler(Runnable r) {
        this.mActionHandler = r;
    }

    protected void scheduleUpdate() {
        if (this.mUpdateTimer == null) {
            this.mUpdateTimer = new Timer(1000, this.mUpdateTask);
            this.mUpdateTimer.setRepeats(false);
        }
        if (this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.restart();
        } else {
            this.mUpdateTimer.start();
        }
    }

    protected void callAction() {
        if (this.mUpdateTimer != null && this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.stop();
        }
        if (this.mUpdatePending) {
            return;
        }
        this.mUpdatePending = true;
        EventQueue.invokeLater(() -> {
            this.mUpdatePending = false;
        });
    }

    protected void showMessage() {
        String message = "Bundle: " + this.mBundle.getName() + "<br>";
        message = message + "Wires: " + this.mBundle.getDefinedArity() + "<br>";
        message = message + "Optimization: " + this.mOptDescription + "<br>";
        this.ci.message(this.mLastLoc, message);
        this.showDiffPairStatus(true);
    }

    public static void optimizeFreeEndOfSelected() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        for (Bundle b : s.get(Bundle.class)) {
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            long wireWidth = b.getWireWidth();
            long wireClr = b.getWireClr();
            ibr.setConstraints(wireWidth, wireClr, Constraint.RouteAngle.FortyFive);
            String oa = b.getAlignmentAlgo();
            ibr.setOptAlgorithm(oa);
            ibr.start(b, null, null, UseMode.Optimize);
        }
    }

    public void addCurrentDbListener(InteractiveBundleListener l) {
        this.mListeners.add(l);
    }

    public boolean removeCurrentDbListener(InteractiveBundleListener l) {
        return this.mListeners.remove(l);
    }

    protected void fireCurrentDbChanged(Db newDb) {
        for (InteractiveBundleListener l : this.mListeners) {
            l.update(newDb);
        }
    }

    static {
        mDeleteOpt = "";
    }

    public static interface InteractiveBundleListener {
        public void update(Db var1);
    }

    public static class ConnectFactory {
        protected PinPairConnectionFactory ppcf = new PinPairConnectionFactory();

        public void setIsVerifyContactSync(boolean b) {
            this.ppcf.setIsVerifyContactSync(b);
        }

        public void load(SchedConn sc) {
            this.ppcf.load(sc);
        }

        public void setConnectTemplate(String keyStr) {
            this.ppcf.setConnectTemplate(keyStr);
        }

        public void setConnectTemplate(DeviceTemplate dt) {
            this.ppcf.setConnectTemplate(dt);
        }

        public void setBaseName(String name) {
            this.ppcf.setBaseName(name);
        }

        public void load(String keyStr) {
            this.ppcf.load(keyStr);
        }

        public void connect() {
            this.ppcf.connect();
        }
    }

    private static class ActiveSorter
    implements Comparator<PreSchedConn> {
        boolean horiz = true;
        char dir = (char)110;

        public ActiveSorter(boolean horizontal, char direction) {
            this.horiz = horizontal;
            this.dir = direction;
        }

        @Override
        public int compare(PreSchedConn o1, PreSchedConn o2) {
            APoint2D pinLoc1 = o1.from.pin.getWorldLoc();
            APoint2D pinLoc2 = o2.from.pin.getWorldLoc();
            int x = 0;
            if (this.dir == 'n' && this.horiz) {
                x = Long.compare(pinLoc1.getX(), pinLoc2.getX());
                if (x == 0) {
                    return Long.compare(pinLoc2.getY(), pinLoc1.getY());
                }
                return x;
            }
            if (this.dir == 'e' && !this.horiz) {
                x = Long.compare(pinLoc2.getY(), pinLoc1.getY());
                if (x == 0) {
                    return Long.compare(pinLoc2.getX(), pinLoc1.getX());
                }
                return x;
            }
            if (this.dir == 's' && this.horiz) {
                x = Long.compare(pinLoc2.getX(), pinLoc1.getX());
                if (x == 0) {
                    return Long.compare(pinLoc1.getY(), pinLoc2.getY());
                }
                return x;
            }
            if (this.dir == 'w' && !this.horiz) {
                x = Long.compare(pinLoc1.getY(), pinLoc2.getY());
                if (x == 0) {
                    return Long.compare(pinLoc1.getX(), pinLoc2.getX());
                }
                return x;
            }
            return x;
        }
    }

    class MyMessageReceiverFromBundleCreation
    implements BundleCreationDlg.MessageReceiver {
        MyMessageReceiverFromBundleCreation() {
        }

        @Override
        public void stats(String data) {
            if (theInteractiveBundleCreator == null) {
                return;
            }
            if (InteractiveBundleCreator.this.mMode == UseMode.BeginEdit || InteractiveBundleCreator.this.mMode == UseMode.DoingEdit) {
                InteractiveBundleCreator.this.returnEditedBundle();
            }
        }
    }

    protected static class PreSchedConn {
        protected AbstractPin from;
        protected AbstractPin to;

        public PreSchedConn(HierPin from, HierPin to, DeviceTemplate common) {
            this.from = new AbstractPin(from, common);
            this.to = to != null ? new AbstractPin(to, common) : null;
        }

        public String toString() {
            return String.format("%s(%s-%s)", this.getClass().getSimpleName(), Objects.toString(this.from), Objects.toString(this.to));
        }
    }

    public static enum UseMode {
        Create("Create"),
        BeginEdit("BeginEdit"),
        DoingEdit("DoingEdit"),
        Optimize("Optimize"),
        BeginEditOptPath("BeginEditOptPath"),
        AutoCreate("AutoCreate"),
        Unknown("Unknown");

        private final String name;

        private UseMode(String s) {
            this.name = s;
        }

        public boolean equalsName(String otherName) {
            return otherName != null && this.name.equals(otherName);
        }

        public String toString() {
            return this.name;
        }
    }
}

