/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;

public class InteractiveFilteredPortSelectMode
extends AbstractViewMode {
    public static final String MODE_NAME = "InteractivePinSelectMode";
    Overlay myOverlay;
    ArrayList<HierPort> candidates;
    boolean outOfRect = true;
    HierPort chosenHPD = null;
    protected boolean mAddMode = false;
    protected Point mStartSel = null;
    protected Point mEndSel = null;
    protected Point mCurSel = null;
    protected boolean justBox = false;
    ArrayList<HierPortDesc> hierPortDescList = new ArrayList();
    ArrayList<HierPort> highlightedPorts = new ArrayList();
    protected DesignView2D.ViewMode mPriorViewMode = null;
    protected APoint2D mCursorPt = null;
    protected static LinkedList<LoadListener> sLoadListener = new LinkedList();

    protected InteractiveFilteredPortSelectMode(ArrayList<HierPort> candidates) {
        this.candidates = candidates;
    }

    public void setCandidates(ArrayList<HierPort> candidates) {
        this.hierPortDescList.clear();
        this.candidates = candidates;
        this.myOverlay.setCandidates(candidates);
        this.buildActiveRects();
        this.mOverlay.paintImmediately(this.mOverlay.getBounds());
    }

    public void addHightlighed(HierPort port) {
        this.highlightedPorts.add(port);
    }

    public ArrayList<HierPort> getSelectedPorts() {
        return this.highlightedPorts;
    }

    public static InteractiveFilteredPortSelectMode install(DesignView2D view, ArrayList<HierPort> candidates) {
        if (view == null) {
            return null;
        }
        InteractiveFilteredPortSelectMode ipsm = new InteractiveFilteredPortSelectMode(candidates);
        view.setMode(ipsm);
        return ipsm;
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
        this.informUser("Click a bump to select", new Object[0]);
        this.mPriorViewMode = view.getPriorMode();
        this.buildActiveRects();
        this.myOverlay = new Overlay();
        view.addOverlay(this.myOverlay);
        this.myOverlay.setCandidates(this.candidates);
        this.myOverlay.setCursor(this.getCursor());
    }

    @Override
    public void uninstallMode() {
        this.highlightedPorts.clear();
        if (this.candidates != null) {
            this.candidates.clear();
        }
        if (this.myOverlay != null) {
            this.myOverlay.updateUI();
        }
        InteractiveFilteredPortSelectMode.fireLeavingMode();
        if (this.myOverlay != null) {
            this.mView.removeOverlay(this.myOverlay);
            this.myOverlay = null;
        }
        sLoadListener.clear();
        super.uninstallMode();
    }

    protected HierPort getChosenHPD() {
        return this.chosenHPD;
    }

    public void iAmUninstallingMySelf() {
        if (this.mView != null) {
            this.mView.setMode(this.mPriorViewMode);
        }
    }

    protected void buildActiveRects() {
        for (HierPort hp : this.candidates) {
            PortTemplate pt = hp.getDPort();
            ARect r = pt.getBounds();
            ARect transformedR = ARect.create((APoint2D)hp.getPath().transformPt(r.getLL()), (APoint2D)hp.getPath().transformPt(r.getUR()));
            HierPortDesc hpd = new HierPortDesc();
            hpd.hp = hp;
            hpd.r = transformedR;
            this.hierPortDescList.add(hpd);
        }
    }

    protected void setCursorLoc(APoint2D worldLoc) {
        if (APoint2D.isEqualPoint((APoint2D)this.mCursorPt, (APoint2D)worldLoc)) {
            return;
        }
        this.mCursorPt = worldLoc;
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        this.mCurSel = e.getPoint();
        this.justBox = true;
        this.mOverlay.paintImmediately(this.mOverlay.getBounds());
        this.justBox = false;
    }

    @Override
    public void mouseEntered(DesignView2D.MouseAction e) {
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(DesignView2D.MouseAction e) {
        super.mouseExited(e);
    }

    protected HierPortDesc getPort(int x, int y) {
        DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
        Point cursorLoc = new Point(x, y);
        APoint2D worldCursorLoc = xform.getWorldPt(cursorLoc);
        this.mView.setCursor(Cursor.getPredefinedCursor(0));
        HierPortDesc inHPD = null;
        for (HierPortDesc hpd : this.hierPortDescList) {
            if (!hpd.r.contains(worldCursorLoc)) continue;
            inHPD = hpd;
            break;
        }
        return inHPD;
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        int x = e.getX();
        int y = e.getY();
        HierPortDesc inHPD = this.getPort(x, y);
        if (inHPD != null) {
            this.mView.setCursor(Cursor.getPredefinedCursor(12));
            InteractiveFilteredPortSelectMode.fireOverPin(inHPD.hp, false);
            this.outOfRect = false;
        } else if (!this.outOfRect) {
            InteractiveFilteredPortSelectMode.fireOverPin(null, false);
            this.outOfRect = true;
        }
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        super.mousePressed(e);
        int button = e.getButton();
        if (button == 1) {
            this.mAddMode = e.isShiftDown();
            this.mStartSel = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        if (this.mStartSel == null) {
            return;
        }
        this.mEndSel = e.getPoint();
        boolean justASingle = false;
        if (e.getButton() == 1) {
            if (this.mStartSel.equals(this.mEndSel) && this.mNavCurrent == null) {
                justASingle = true;
            }
            if (justASingle) {
                int y;
                int x = e.getX();
                HierPortDesc hpd = this.getPort(x, y = e.getY());
                if (hpd != null) {
                    if (!this.mAddMode) {
                        this.highlightedPorts.clear();
                    }
                    if (this.mAddMode) {
                        if (this.highlightedPorts.contains(hpd.hp)) {
                            this.highlightedPorts.remove(hpd.hp);
                        } else {
                            this.highlightedPorts.add(hpd.hp);
                        }
                    } else {
                        this.highlightedPorts.add(hpd.hp);
                    }
                    InteractiveFilteredPortSelectMode.fireOverPin(hpd.hp, true);
                }
            } else {
                DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
                APoint2D worldCursorLoc1 = xform.getWorldPt(this.mStartSel);
                APoint2D worldCursorLoc2 = xform.getWorldPt(this.mEndSel);
                ARect r = ARect.create((APoint2D)worldCursorLoc1, (APoint2D)worldCursorLoc2);
                this.mView.setCursor(Cursor.getPredefinedCursor(0));
                if (!this.mAddMode) {
                    this.highlightedPorts.clear();
                }
                HierPort one = null;
                for (HierPortDesc hpd : this.hierPortDescList) {
                    if (!hpd.r.intersects(r)) continue;
                    one = hpd.hp;
                    this.highlightedPorts.add(hpd.hp);
                }
                InteractiveFilteredPortSelectMode.fireOverPin(one, true);
            }
        }
        this.mOverlay.paintImmediately(this.mOverlay.getBounds());
        this.mStartSel = null;
        this.mEndSel = null;
        this.mCurSel = null;
        if (this.mView != null) {
            this.mView.getCanvas().refresh();
        }
    }

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    protected static void fireOverPin(HierPort hp, boolean choosen) {
        for (LoadListener l : AUtil.linkedList(sLoadListener)) {
            l.onOverPin(hp, choosen);
        }
    }

    protected static void fireLeavingMode() {
        for (LoadListener l : AUtil.linkedList(sLoadListener)) {
            l.leavingMode();
        }
    }

    public class Overlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        boolean mDrawing = false;
        Layer layer;
        ArrayList<HierPort> candidates = null;
        Graphics2D g;

        public Overlay() {
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        public void setCandidates(ArrayList<HierPort> candidates) {
            this.candidates = candidates;
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (InteractiveFilteredPortSelectMode.this.isNavigationInProgress()) {
                return;
            }
            if (this.mDrawing) {
                return;
            }
            this.mDrawing = true;
            this.g = (Graphics2D)graphics;
            if (InteractiveFilteredPortSelectMode.this.mStartSel != null && InteractiveFilteredPortSelectMode.this.mCurSel != null) {
                this.g.setColor(Color.MAGENTA);
                Rectangle r = new Rectangle(InteractiveFilteredPortSelectMode.this.mStartSel);
                r.add(InteractiveFilteredPortSelectMode.this.mCurSel);
                this.g.drawRect(r.x, r.y, r.width, r.height);
                String sign = InteractiveFilteredPortSelectMode.this.mAddMode ? "Select Bunmps (Add)" : "Select Bumps (Replace)";
                Rectangle2D tb = UIUtil.getTextBounds((Graphics2D)this.g, (String)sign);
                this.g.drawString(sign, InteractiveFilteredPortSelectMode.this.mCurSel.x - (int)tb.getWidth() - 3, InteractiveFilteredPortSelectMode.this.mCurSel.y - 1);
            }
            DesignView2D v2 = InteractiveFilteredPortSelectMode.this.mView;
            this.w2s = v2.getCanvas().getXForm();
            for (HierPort hp : this.candidates) {
                this.drawHierPort(this.g, hp, false);
            }
            for (HierPort hp : InteractiveFilteredPortSelectMode.this.highlightedPorts) {
                this.drawHierPort(this.g, hp, true);
            }
            this.mDrawing = false;
        }

        protected void drawHierPort(Graphics2D g, HierPort hp, boolean special) {
            PortTemplate pt = hp.getDPort();
            DevicePath devPath = hp.getPath();
            ARect r = pt.getBounds();
            if (r == null) {
                return;
            }
            ARect transformedR = ARect.create((APoint2D)devPath.transformPt(r.getLL()), (APoint2D)devPath.transformPt(r.getUR()));
            int screenWidth = InteractiveFilteredPortSelectMode.this.getScreenLen(transformedR.width());
            if (screenWidth == 0) {
                screenWidth = 1;
            }
            Rectangle screenRect = InteractiveFilteredPortSelectMode.this.getScreenRect(transformedR);
            Color color = g.getColor();
            if (special) {
                g.setColor(Color.orange);
                g.fillRect(screenRect.x, screenRect.y, screenRect.width, screenRect.height);
            } else {
                g.setColor(Color.yellow);
                g.draw(screenRect);
            }
            g.setColor(color);
        }
    }

    public static interface LoadListener {
        public void onOverPin(HierPort var1, boolean var2);

        public void leavingMode();
    }

    protected static class HierPortDesc {
        HierPort hp;
        ARect r;

        protected HierPortDesc() {
        }
    }
}

