/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.route_edit.EditRouteMode;
import com.sigrity.orbit.ui.route_edit.InteractiveWireCreator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JSeparator;

public class InteractiveSingleLayerRouter
extends InteractiveWireCreator {
    JCheckBoxMenuItem mFollowMode;
    APoint2D mLastLoc;
    Graphics2D mGraphics;

    public void start(Personality p) {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        DesignView2D.ViewMode vm = v.getMode("EditRouteMode");
        EditRouteMode erm = (EditRouteMode)vm;
        v.setMode(erm);
        this.mAnchor = null;
        erm.startSingleLayerRouter(this);
    }

    @Override
    public boolean install(EditRouteMode erm) {
        this.mParent = erm;
        this.mAnchor = null;
        this.createOptionMenus();
        this.constrainAngle45();
        return true;
    }

    protected void createOptionMenus() {
        this.mFollowMode = new JCheckBoxMenuItem(new AbstractAction("Channel Vision"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    @Override
    public LinkedList<Component> getContextMenu(Point loc) {
        if (this.mContextMenu == null) {
            this.mContextMenu = new LinkedList();
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(this.mFollowMode);
            this.mContextMenu.add(new JSeparator());
        }
        return this.mContextMenu;
    }

    @Override
    public APoint2D mouseMoved(APoint2D oldLoc, APoint2D newLoc) {
        newLoc = this.snap(newLoc);
        this.mLastLoc = new APoint2D(newLoc);
        this.mParent.repaintOverlay();
        return newLoc;
    }

    @Override
    public APoint2D mouseClicked(int button, APoint2D location) {
        location = this.snap(location);
        if (button == 1) {
            // empty if block
        }
        return location;
    }

    @Override
    public boolean createSegment(APoint2D loc) {
        return true;
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
        this.mGraphics = g;
        Color colorOld = g.getColor();
        Stroke strokeOld = g.getStroke();
        int screenWidth = this.mParent.getScreenLen(this.mWidth);
        BasicStroke stroke = new BasicStroke(screenWidth, 1, 1);
        g.setColor(new Color(255, 140, 0, 255));
        g.setStroke(stroke);
        g.setStroke(strokeOld);
        g.setPaintMode();
        g.setColor(colorOld);
    }
}

