/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.optimizer.genetic.GeneticFinishingFunction;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.connOpt.GeneticConnectionOptimizer;
import java.awt.EventQueue;
import java.util.ArrayList;

public class InterfaceConnectionOptimizer {
    ArrayList<SchedConn> schedConns = new ArrayList();

    public void loadSC(String keyStr) {
        Db db = OrbitIO.getCurDb();
        SchedConn sc = (SchedConn)db.getByKeyStr(SchedConn.class, keyStr);
        this.schedConns.add(sc);
    }

    public void go() {
        this.createIOPadToBumpNetlistEvolve(true, 100L, 2);
    }

    protected void createIOPadToBumpNetlistEvolve(boolean byTime, long stoppingNumber, int maxPopulation) {
        class RDLreateConnectionsEvolve
        implements GeneticFinishingFunction {
            GeneticConnectionOptimizer mCO;

            RDLreateConnectionsEvolve() {
            }

            protected void updateConnections(GeneticConnectionOptimizer co) {
                ArrayList<APair<HierPin, HierPin>> created = co.getConnected();
                for (APair<HierPin, HierPin> pair : created) {
                    boolean foundMatch = false;
                    for (SchedConn sc : InterfaceConnectionOptimizer.this.schedConns) {
                        HierPin dpp = sc.getDPPA();
                        if (!dpp.equals(pair.first)) continue;
                        foundMatch = true;
                        sc.setPortB(((HierPin)pair.second).getPath(), ((HierPin)pair.second).getPinTemplate().getFirstPortTemplate());
                        break;
                    }
                    if (foundMatch) continue;
                    ALog.logInfo((String)"Internal problem");
                }
            }

            @Override
            public void onGeneticOptimizationFinished() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updateConnections(mCO);
                    }
                });
            }

            public void start(boolean byTime, long stoppingNumber, int maxPopulation) {
                ArrayList<HierPin> from = new ArrayList<HierPin>();
                ArrayList<HierPin> to = new ArrayList<HierPin>();
                for (SchedConn sc : InterfaceConnectionOptimizer.this.schedConns) {
                    HierPin dppFrom = sc.getDPPA();
                    HierPin dppTo = sc.getDPPB();
                    if (dppFrom != null) {
                        from.add(dppFrom);
                    }
                    if (dppTo == null) continue;
                    to.add(dppTo);
                }
                this.mCO = new GeneticConnectionOptimizer();
                this.mCO.setASet(from);
                this.mCO.setBSet(to);
                this.mCO.optimizeGenetically(byTime, stoppingNumber, maxPopulation);
                GeneticOptimizerBroker.addFinishingFunction(OrbitIO.getCurDb().toString(), this);
            }
        }
        RDLreateConnectionsEvolve fcevolver = new RDLreateConnectionsEvolve();
        fcevolver.start(byTime, stoppingNumber, maxPopulation);
    }
}

