/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.AVector;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.PathSection;
import com.sigrity.orbit.automation.router.PathUtil;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Spring;
import com.sigrity.orbit.automation.router.SpringSet;
import com.sigrity.orbit.automation.router.Topstacle;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class NonMonotonicPusher {
    double mMinAngle = 90.0;
    ArrayList<TopologicalObject> mTopologicalSet = new ArrayList();
    ArrayList<TopologicalObject> mFlexibleTopologicalSet = new ArrayList();
    ArrayList<TopologicalObject> mRigidTopologicalSet = new ArrayList();
    HashMap<DbObject, TopologicalObject> mDbToMo = new HashMap();
    AGrid snapGrid = null;
    protected PrettyRouter pr;
    int debugCounter = 0;
    protected DirectedSparseGraph<PushNode, PushEdge> pushGraph = new DirectedSparseGraph();
    AHashCollection<TopologicalObject, SpringSet> wireToSpring = new AHashCollection();
    AHashCollection<Topstacle, SpringSet> topToSpring = new AHashCollection();

    protected PushDir fromAngle(double angle) {
        int a = (int)angle;
        switch (a) {
            case 0: {
                return PushDir.Right;
            }
            case 45: {
                return PushDir.UpRight;
            }
            case 90: {
                return PushDir.Up;
            }
            case 135: {
                return PushDir.UpLeft;
            }
            case 180: {
                return PushDir.Left;
            }
            case 225: {
                return PushDir.DnLeft;
            }
            case 270: {
                return PushDir.Dn;
            }
            case 315: {
                return PushDir.DnRight;
            }
        }
        return PushDir.Up;
    }

    protected void snapPath(APath p, double angle) {
        PushDir dir = this.fromAngle(angle);
        for (int i = 0; i < p.getPointCount(); ++i) {
            p.setPoint(i, this.snap(p.getPoint(i), dir));
        }
    }

    protected boolean isUp(PushDir dir) {
        return dir == PushDir.Up || dir == PushDir.UpLeft || dir == PushDir.UpRight;
    }

    protected boolean isDn(PushDir dir) {
        return dir == PushDir.Dn || dir == PushDir.DnLeft || dir == PushDir.DnRight;
    }

    protected boolean isLeft(PushDir dir) {
        return dir == PushDir.Left || dir == PushDir.UpLeft || dir == PushDir.DnLeft;
    }

    protected boolean isRight(PushDir dir) {
        return dir == PushDir.Right || dir == PushDir.UpRight || dir == PushDir.DnRight;
    }

    protected APoint2D snap(APoint2D p, PushDir dir) {
        APoint2D newP = new APoint2D(p);
        if (this.snapGrid != null) {
            long dx;
            long dy;
            if (this.isUp(dir)) {
                dy = AGridUtil.snapDS((long)p.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY(), (boolean)true);
                newP = newP.add(0L, dy);
            }
            if (this.isDn(dir)) {
                dy = AGridUtil.snapDS((long)p.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY(), (boolean)false);
                newP = newP.add(0L, dy);
            }
            if (this.isRight(dir)) {
                dx = AGridUtil.snapDS((long)p.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX(), (boolean)true);
                newP = newP.add(dx, 0L);
            }
            if (this.isLeft(dir)) {
                dx = AGridUtil.snapDS((long)p.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX(), (boolean)false);
                newP = newP.add(dx, 0L);
            }
        }
        return newP;
    }

    public void setMinAngle(double angle) {
        this.mMinAngle = angle;
    }

    public void setPrettyRouter(PrettyRouter pr) {
        this.pr = pr;
    }

    public void nonMonotonicPush() {
        this.determineGrid();
        this.convertDbToTopologicalObjects();
        this.developOrderedNearFlexibleObjects();
        this.buildPushGraph();
        this.relaxPushGraph(true);
        this.convertTopologicalObjectsToDb();
    }

    protected boolean adjustInRegion(APath p, FloodableNode from, FloodableNode to) {
        long d1;
        IntersectionIndex pFrom = this.getIntersectionOfPathAndFN(p, from);
        IntersectionIndex pTo = this.getIntersectionOfPathAndFN(p, to);
        if (pFrom == null || pTo == null) {
            return false;
        }
        ALine l = new ALine(pFrom.intersection, pTo.intersection);
        if (l.isHorizontal() || l.isVertical()) {
            return false;
        }
        Topstacle anchor = this.pr.anchor(from, to);
        APoint2D center = anchor.getPoint();
        APoint2D option0 = new APoint2D(pFrom.intersection.getX(), pTo.intersection.getY());
        APoint2D option1 = new APoint2D(pTo.intersection.getX(), pFrom.intersection.getY());
        long d0 = center.distance(option0);
        if (d0 > (d1 = center.distance(option1))) {
            p.insertPoint(pTo.idx + 1, option0);
            p.insertPoint(pTo.idx + 2, pTo.intersection);
        } else {
            p.insertPoint(pTo.idx + 1, option1);
            p.insertPoint(pTo.idx + 2, pTo.intersection);
        }
        return true;
    }

    protected IntersectionIndex getIntersectionOfPathAndFN(APath p, FloodableNode fn) {
        IntersectionIndex returnPt = new IntersectionIndex();
        ALine fnLine = new ALine(fn.span);
        fnLine.extendEnds(2L);
        for (int i = 0; i < p.getPointCount() - 1; ++i) {
            ALine l = new ALine(p.getPoint(i), p.getPoint(i + 1));
            l.extendEnds(2L);
            if (!l.intersects((AGeom)fnLine)) continue;
            returnPt.idx = i;
            APoint2D s = l.getIntersectLines(fnLine);
            long x = AGridUtil.snap((long)s.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX());
            long y = AGridUtil.snap((long)s.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY());
            returnPt.intersection = new APoint2D(x, y);
            return returnPt;
        }
        return null;
    }

    private void obstacleClear() {
        for (TopologicalObject w : this.mFlexibleTopologicalSet) {
            APath p = w.current;
            FloodableNode prev = null;
            int i = 0;
            for (FloodableNode fn : this.pr.mWireToOrderedNodes.getCollection((Object)w.w)) {
                ALine l = fn.span;
                if (prev != null) {
                    this.adjustInRegion(p, prev, fn);
                }
                prev = fn;
                ++i;
            }
        }
    }

    protected void cleanAll() {
        this.inGridAll();
        this.orthoAll();
    }

    protected void inGridAll() {
        for (TopologicalObject w : this.mFlexibleTopologicalSet) {
            APath path = w.current;
            APath newPath = new APath();
            for (int i = 0; i < path.getPointCount(); ++i) {
                APoint2D p = new APoint2D(path.getPoint(i));
                long x = AGridUtil.snap((long)p.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX());
                long y = AGridUtil.snap((long)p.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY());
                newPath.addPoint(new APoint2D(x, y));
            }
            w.current = newPath.cleanPath();
        }
    }

    protected void orthoAll() {
        for (TopologicalObject w : this.mFlexibleTopologicalSet) {
            APath path = w.current;
            APath newPath = new APath();
            for (int i = 0; i < path.getPointCount() - 1; ++i) {
                newPath.addPoint(path.getPoint(i));
                long dx = path.getPoint(i + 1).xDistance(path.getPoint(i));
                long dy = path.getPoint(i + 1).yDistance(path.getPoint(i));
                if (Math.abs(dx) == Math.abs(dy) && dx != 0L && dy != 0L) continue;
                newPath.addPoint(path.getPoint(i + 1).getX(), path.getPoint(i).getY());
            }
            newPath.addPoint(path.getLastPoint());
            w.current = newPath;
        }
    }

    protected void determineGrid() {
        NamedGrid ngGrid = NamedGrid.get((Substrate)this.pr.mParent.getSubstrate(), (String)"Manufacturing Grid");
        this.snapGrid = ngGrid != null ? ngGrid.getGrid() : new AGrid(5L, 5L, 0L, 0L);
    }

    protected void convertTopologicalObjectsToDb() {
        for (int i = 0; i < this.mTopologicalSet.size(); ++i) {
            TopologicalObject iMO = this.mTopologicalSet.get(i);
            if (iMO.w == null) continue;
            long w = iMO.w.getPath().getWidth();
            iMO.current.setWidth(w);
            iMO.w.setPath(iMO.current);
        }
    }

    protected LinkedList<SortedIntersection> cleanIntersections(LinkedList<SortedIntersection> intersections) {
        LinkedList<SortedIntersection> clean = new LinkedList<SortedIntersection>();
        HashSet<TopologicalObject> processed = new HashSet<TopologicalObject>();
        for (int i = 0; i < intersections.size(); ++i) {
            if (processed.contains(intersections.get((int)i).t)) continue;
            processed.add(intersections.get((int)i).t);
            Integer best = i;
            for (int j = i + i; j < intersections.size(); ++j) {
                if (!intersections.get((int)i).t.equals(intersections.get((int)j).t) || intersections.get((int)j).d >= intersections.get((int)best.intValue()).d) continue;
                best = j;
            }
            clean.add(intersections.get(best));
        }
        return clean;
    }

    protected void buildPushGraph() {
        for (TopologicalObject p0 : this.mRigidTopologicalSet) {
            Frontier frontier = p0.getFrontier();
            if (frontier == null) continue;
            PushNode pn0 = new PushNode(p0, frontier);
            frontier.pushNodes.add(pn0);
            this.pushGraph.addVertex((Object)pn0);
            TopologicalObject wireAttachedToPad = this.netToMonotonicWire(p0.net);
            wireAttachedToPad = null;
            Object pnw = null;
            boolean first = true;
            PushNode lastRigid = pn0;
            for (TopologicalObject p1 : frontier.getFlexibleFrontier()) {
                PushEdge e;
                PushNode pn = new PushNode(p1, frontier);
                this.pushGraph.addVertex((Object)pn);
                if (first) {
                    if (pnw != null) {
                        e = new PushEdge();
                        this.pushGraph.addEdge((Object)e, pnw, (Object)pn);
                    }
                    first = false;
                }
                e = new PushEdge();
                this.pushGraph.addEdge((Object)e, (Object)lastRigid, (Object)pn);
                lastRigid = pn;
            }
        }
    }

    protected void relaxPushGraph(boolean debug) {
        debug = false;
        boolean seen = false;
        Collections.sort(this.mRigidTopologicalSet);
        for (TopologicalObject p0 : this.mRigidTopologicalSet) {
            Frontier frontier = p0.getFrontier();
            if (frontier == null) continue;
            APath plunger = new APath();
            plunger.addPoint(frontier.frontier.getFirstPoint());
            plunger.addPoint(frontier.frontier.getLastPoint());
            if (frontier.angle() != 180.0 && frontier.angle() != 45.0 && frontier.angle() != 90.0 && frontier.angle() != 315.0 && frontier.angle() != 0.0) continue;
            for (PushNode pnFromPin : frontier.pushNodes) {
                Collection pushNodes = this.pushGraph.getNeighbors((Object)pnFromPin);
                for (PushNode pnPushed : pushNodes) {
                    pnFromPin.push(pnPushed, frontier, plunger, 0, debug);
                }
            }
        }
    }

    protected ObstacleRelation pinToWireRelation(Topstacle topstacle, TopologicalObject wireT) {
        if (topstacle == null) {
            return ObstacleRelation.DifferentNet;
        }
        if (topstacle.net != wireT.net) {
            return ObstacleRelation.DifferentNet;
        }
        Wire w = wireT.w;
        if (w.getPath() == null) {
            return ObstacleRelation.DifferentNet;
        }
        if (topstacle.point == null) {
            return ObstacleRelation.DifferentNet;
        }
        if (topstacle.point.equals((Object)w.getPath().getFirstPoint())) {
            return ObstacleRelation.Connected;
        }
        if (topstacle.point.equals((Object)w.getPath().getLastPoint())) {
            return ObstacleRelation.Connected;
        }
        return ObstacleRelation.SameNet;
    }

    protected ObstacleRelation pinToWireRelation(TopologicalObject pinT, TopologicalObject wireT) {
        return this.pinToWireRelation(pinT.t, wireT);
    }

    protected void developOrderedNearFlexibleObjects() {
        for (TopologicalObject pin : this.mRigidTopologicalSet) {
            Topstacle topstacle = pin.t;
            HierPin hp = (HierPin)topstacle.owner;
            ArrayList<FloodableNode> fns = this.pr.topstacleToFloodableNodes(topstacle);
            long maxLength = 0L;
            for (FloodableNode fn : fns) {
                for (APoint2D intersection : this.pr.intersectionPoints(fn)) {
                    long length = topstacle.point.distance(intersection) + 2L;
                    maxLength = Math.max(length, maxLength);
                }
            }
            LinkedList debugPins = new LinkedList();
            boolean debug = false;
            for (String dp : debugPins) {
                if (!pin.t.net.getName().contains(dp) || !hp.getPin().getName().equals("IOVia")) continue;
                debug = true;
                break;
            }
            if (!debug && debugPins.size() > 0) continue;
            double facetAngle = this.useRectangle(topstacle) ? 90.0 : 45.0;
            for (double angle = 0.0; angle < 360.0; angle += facetAngle) {
                if (pin.angleFace != angle) continue;
                long distanceToEdge = Math.max(topstacle.getBounds().height() / 2L, topstacle.getBounds().width() / 2L);
                ALine whisker = topstacle.point.makeVector(maxLength + distanceToEdge, angle);
                ALine whisker1 = null;
                ALine whisker2 = null;
                double halfAngle = 45.0;
                if (facetAngle == 90.0) {
                    ALine test2;
                    ALine test1;
                    if (angle == 0.0 || angle == 180.0) {
                        test1 = new ALine(topstacle.getBounds().center(), topstacle.getBounds().getUR());
                        test2 = new ALine(topstacle.getBounds().center(), topstacle.getBounds().getLR());
                        double angle1 = test1.getAngle();
                        double angle2 = test2.getAngle();
                        halfAngle = angle1 + (360.0 - angle2);
                        halfAngle /= 2.0;
                    } else {
                        test1 = new ALine(topstacle.getBounds().center(), topstacle.getBounds().getUR());
                        test2 = new ALine(topstacle.getBounds().center(), topstacle.getBounds().getUL());
                        double angle1 = test1.getAngle();
                        double angle2 = test2.getAngle();
                        halfAngle = angle2 - angle1;
                        halfAngle /= 2.0;
                    }
                } else {
                    halfAngle = 22.5;
                }
                whisker1 = topstacle.point.makeVector(maxLength + distanceToEdge, angle - halfAngle);
                whisker2 = topstacle.point.makeVector(maxLength + distanceToEdge, angle + halfAngle);
                Frontier frontierArea = new Frontier(whisker, halfAngle * 2.0, pin.original);
                frontierArea.from = pin;
                Intersections intersections = new Intersections();
                Intersections intersections1 = new Intersections();
                Intersections intersections2 = new Intersections();
                for (TopologicalObject wireObject : this.mFlexibleTopologicalSet) {
                    Wire w = wireObject.w;
                    if (this.pinToWireRelation(pin, wireObject) == ObstacleRelation.Connected) continue;
                    APath p = w.getPath();
                    Long minD = null;
                    Long minD1 = null;
                    Long minD2 = null;
                    for (ALine lOfPath : p.getLines()) {
                        long d;
                        APoint2D intersection;
                        lOfPath.extendEnds(2L);
                        if (whisker.intersects((AGeom)lOfPath)) {
                            intersection = whisker.getIntersectLines(lOfPath);
                            d = Math.abs(whisker.getP0().distance(intersection));
                            if (minD == null || d < minD) {
                                minD = d;
                            }
                        }
                        if (whisker1.intersects((AGeom)lOfPath)) {
                            intersection = whisker1.getIntersectLines(lOfPath);
                            d = Math.abs(whisker1.getP0().distance(intersection));
                            if (minD1 == null || d < minD1) {
                                minD1 = d;
                            }
                        }
                        if (!whisker2.intersects((AGeom)lOfPath)) continue;
                        intersection = whisker2.getIntersectLines(lOfPath);
                        d = Math.abs(whisker2.getP0().distance(intersection));
                        if (minD2 != null && d >= minD2) continue;
                        minD2 = d;
                    }
                    if (minD != null) {
                        intersections.add(new SortedIntersection(minD, wireObject));
                    }
                    if (minD1 != null) {
                        intersections1.add(new SortedIntersection(minD1, wireObject));
                    }
                    if (minD2 == null) continue;
                    intersections2.add(new SortedIntersection(minD2, wireObject));
                }
                Collections.sort(intersections);
                Collections.sort(intersections1);
                Collections.sort(intersections2);
                IntersectionSorter is = new IntersectionSorter();
                is.add(intersections);
                is.add(intersections1);
                is.add(intersections2);
                Intersections complete = is.sort();
                frontierArea.setFlexibleList(complete);
                pin.setFrontier(frontierArea);
            }
        }
    }

    protected void convertWiresToTopologicalObjects() {
        for (Wire w : this.pr.mWiretoLastFn.keySet()) {
            w.clean();
            TopologicalObject tObject = new TopologicalObject();
            tObject.original = w.getPath().copy();
            tObject.net = w.getNet();
            tObject.flexible = true;
            tObject.close();
            tObject.w = w;
            this.mFlexibleTopologicalSet.add(tObject);
            this.mTopologicalSet.add(tObject);
            this.mDbToMo.put((DbObject)w, tObject);
        }
        Collections.sort(this.mFlexibleTopologicalSet, new PathSorter());
    }

    protected boolean useRectangle(Topstacle topstacle) {
        boolean useRectangle = true;
        ARect r = topstacle.getBounds();
        if (this.mMinAngle == 45.0) {
            if (topstacle.getShape() instanceof AOctagon) {
                useRectangle = false;
            } else {
                APolygon poly = topstacle.getShape().toPoly();
                if (poly.getPointCount() >= 8 && r.width() == r.height()) {
                    useRectangle = false;
                }
            }
        }
        return useRectangle;
    }

    protected void convertPinsToTopologicalObjects() {
        HashSet<Topstacle> topstacles = new HashSet<Topstacle>();
        for (FloodableNode fn : this.pr.mFloodableNodes) {
            if (!fn.isChannel) continue;
            topstacles.add((Topstacle)fn.mChannel.getP1());
            topstacles.add((Topstacle)fn.mChannel.getP2());
        }
        for (Topstacle topstacle : topstacles) {
            Net n = topstacle.net;
            if (n == null) continue;
            ARect r = topstacle.getBounds();
            boolean useRectangle = this.useRectangle(topstacle);
            if (useRectangle) {
                for (int i = 0; i < 4; ++i) {
                    TopologicalObject tObject = new TopologicalObject();
                    tObject.net = n;
                    tObject.c = r.center();
                    tObject.flexible = false;
                    tObject.t = topstacle;
                    if (i == 0) {
                        tObject.original = r.rightEdge().toPath(0L);
                        tObject.angleFace = 0.0;
                    } else if (i == 1) {
                        tObject.original = r.topEdge().toPath(0L);
                        tObject.angleFace = 90.0;
                    } else if (i == 2) {
                        tObject.original = r.leftEdge().toPath(0L);
                        tObject.angleFace = 180.0;
                    } else if (i == 3) {
                        tObject.original = r.bottomEdge().toPath(0L);
                        tObject.angleFace = 270.0;
                    }
                    tObject.close();
                    this.mTopologicalSet.add(tObject);
                    this.mRigidTopologicalSet.add(tObject);
                }
                continue;
            }
            long radius = r.width() / 2L;
            AOctagon oct = new AOctagon(radius);
            oct.moveCenterTo(r.center());
            for (ALine side : oct.getLines()) {
                TopologicalObject tObject = new TopologicalObject();
                tObject.net = n;
                tObject.c = r.center();
                tObject.flexible = false;
                tObject.t = topstacle;
                tObject.original = side.toPath(0L);
                double normal = side.getAngle();
                tObject.angleFace = normal - 90.0;
                if (tObject.angleFace < 0.0) {
                    tObject.angleFace += 360.0;
                }
                tObject.close();
                this.mTopologicalSet.add(tObject);
                this.mRigidTopologicalSet.add(tObject);
            }
        }
        Collections.sort(this.mTopologicalSet, new UniqueGeomSorter());
        this.developSprings(topstacles);
    }

    protected LinkedList<SortedIntersection> findIntersections(Topstacle pin, ALine whisker) {
        LinkedList<SortedIntersection> intersections = new LinkedList<SortedIntersection>();
        for (TopologicalObject wireObject : this.mFlexibleTopologicalSet) {
            Wire w = wireObject.w;
            if (this.pinToWireRelation(pin, wireObject) == ObstacleRelation.Connected) continue;
            APath p = w.getPath();
            Long minD = null;
            int minIndex = 0;
            long minDistFromVertex = -1L;
            for (int i = 0; i < p.getPointCount() - 1; ++i) {
                ALine lOfpath = new ALine(p.getPoint(i), p.getPoint(i + 1));
                lOfpath.extendEnds(2L);
                if (!whisker.intersects((AGeom)lOfpath)) continue;
                APoint2D intersection = whisker.getIntersectLines(lOfpath);
                long d = Math.abs(whisker.getP0().distance(intersection));
                if (minD != null && d >= minD) continue;
                minD = d;
                minIndex = i;
                minDistFromVertex = intersection.distance(p.getPoint(i));
            }
            if (minD == null) continue;
            intersections.add(new SortedIntersection(minD, wireObject, minIndex, minDistFromVertex));
        }
        Collections.sort(intersections);
        return this.cleanIntersections(intersections);
    }

    protected APoint2D surface(APolygon p, ALine l) {
        ALine v = new ALine(l);
        v.extendEnds(2L);
        for (ALine pLine : p.getLines()) {
            pLine.extendEnds(2L);
            if (!pLine.intersects((AGeom)v)) continue;
            return pLine.getIntersectLines(v);
        }
        return null;
    }

    protected SpringSet createSpringsForWhisker(Topstacle topstacle, ALine whisker, long distanceToSurface, double angle) {
        LinkedList<SortedIntersection> intersections = this.findIntersections(topstacle, whisker);
        if (intersections.size() == 0) {
            return null;
        }
        SpringSet ms = SpringSet.create(whisker, topstacle);
        Wire lastWire = null;
        for (SortedIntersection si : intersections) {
            SingleLayerRouter.RouteInformation r1;
            Wire w = si.t.w;
            long c0 = 0L;
            long c1 = 0L;
            SingleLayerRouter.RouteInformation r0 = this.pr.mWireToRouteInformation.get(lastWire);
            if (r0 != null) {
                c0 = r0.getClear();
            }
            if ((r1 = this.pr.mWireToRouteInformation.get(w)) != null) {
                c1 = r1.getClear();
            }
            long clr = 0L;
            if (r0 == null) {
                ObstacleRelation r = this.pinToWireRelation(topstacle, si.t);
                if (r == ObstacleRelation.Connected) {
                    ALog.logInfo((String)"Problem");
                } else {
                    clr = r == ObstacleRelation.SameNet ? c1 : Math.max(c1, c0);
                }
            } else {
                clr = Math.max(c1, c0);
            }
            long separation = w.getWidth() / 2L;
            if (lastWire != null) {
                separation += lastWire.getWidth() / 2L;
            }
            separation += clr;
            if (angle % 90.0 != 0.0) {
                separation = (long)((double)separation * Math.sqrt(2.0));
            }
            if (lastWire == null) {
                separation += distanceToSurface;
            }
            ms.addSpring(separation, null, si);
            this.wireToSpring.add((Object)si.t, (Object)ms);
            lastWire = w;
        }
        return ms;
    }

    protected void developSprings(HashSet<Topstacle> topstacles) {
        SpringSet.restart();
        LinkedList<Topstacle> sortedTopstacles = new LinkedList<Topstacle>();
        sortedTopstacles.addAll(topstacles);
        Collections.sort(sortedTopstacles);
        for (Topstacle topstacle : sortedTopstacles) {
            ARect bound = topstacle.getBounds();
            if (topstacle.point.getX() != 5103650L || topstacle.point.getY() != 215650L) continue;
            ArrayList<FloodableNode> fns = this.pr.topstacleToFloodableNodes(topstacle);
            Collections.sort(fns, new FloodableNodeSorter());
            long maxLength = 0L;
            for (FloodableNode fn : fns) {
                for (APoint2D intersection : this.pr.intersectionPoints(fn)) {
                    long length = topstacle.point.distance(intersection) + 2L;
                    maxLength = Math.max(length, maxLength);
                }
            }
            if (maxLength == 0L) continue;
            for (double angle = 0.0; angle < 360.0; angle += this.mMinAngle / 2.0) {
                APoint2D start = new APoint2D(topstacle.point);
                long min = Math.min(bound.width(), bound.height());
                min /= 2L;
                if (angle == 45.0) {
                    start.setX(bound.getUR().getX() - min);
                    start.setY(bound.getUR().getY() - min);
                } else if (angle == 135.0) {
                    start.setX(bound.getUL().getX() + min);
                    start.setY(bound.getUL().getY() - min);
                } else if (angle == 225.0) {
                    start.setX(bound.getLL().getX() + min);
                    start.setY(bound.getLL().getY() + min);
                } else if (angle == 315.0) {
                    start.setX(bound.getLR().getX() - min);
                    start.setY(bound.getLR().getY() + min);
                }
                long distanceToEdge = topstacle.getBounds().height() / 2L;
                ALine whisker = start.makeVector(maxLength + distanceToEdge, angle);
                APoint2D onSurface = this.surface(topstacle.getShape().toPoly(), whisker);
                if (onSurface == null) continue;
                long distanceToSurface = whisker.getP0().distance(onSurface);
                SpringSet ss = this.createSpringsForWhisker(topstacle, whisker, distanceToSurface, angle);
                this.topToSpring.add((Object)topstacle, (Object)ss);
            }
        }
    }

    private void pullWiresThroughSpring(SpringSet ss, boolean exact) {
        this.pullWiresThroughSpring(ss, exact, false, 1.0);
    }

    private void pullWiresThroughSpring(SpringSet ss, boolean exact, boolean debug) {
        this.pullWiresThroughSpring(ss, exact, debug, 1.0);
    }

    private void pullWiresThroughSpring(SpringSet ss, boolean exact, boolean debug, double percent) {
        ALine span = new ALine(ss.l);
        long previousRequired = 0L;
        int ith = 0;
        for (Spring spring : ss.springs) {
            SortedIntersection si = (SortedIntersection)spring.o;
            int thisWireIndex = si.pathIndex.index;
            if (thisWireIndex == 0 || thisWireIndex == si.pathIndex.path.getPointCount() - 1) continue;
            Wire w = si.t.w;
            previousRequired += spring.minSlackFromLast();
            APoint2D p0 = si.pathIndex.path.getPoint(thisWireIndex - 1);
            APoint2D p1 = si.pathIndex.path.getPoint(thisWireIndex + 1);
            if (p0 != null && p1 != null) {
                APoint2D pSnap;
                APoint2D p;
                ALine l = new ALine(p0, p1);
                double alpha = span.dX() == 0L || span.dY() == 0L ? 1.0 : (Math.abs(span.dX()) > Math.abs(span.dY()) ? Math.abs(Math.cos(span.getAngleInRadians())) : Math.abs(Math.sin(span.getAngleInRadians())));
                ALine limitedSpan = span.shrink((long)((double)previousRequired * percent), 0L);
                long distanceFromStart = 0L;
                PushDir pushDir = this.fromAngle(limitedSpan.getAngle());
                ALine lineOfTrace = new ALine(l);
                ALine lineOfSpan = new ALine(limitedSpan);
                lineOfTrace.extendEnds(2L);
                lineOfSpan.extendEnds(2L);
                if (exact && lineOfTrace.intersects((AGeom)lineOfSpan)) {
                    p = lineOfTrace.getIntersectLines(lineOfSpan);
                    pSnap = this.snap(p, pushDir);
                    si.pathIndex.path.setPoint(thisWireIndex, pSnap);
                    distanceFromStart = Math.abs(pSnap.distance(span.getP0()));
                } else {
                    p = limitedSpan.pointOnMeClosestToLine(l);
                    pSnap = this.snap(p, pushDir);
                    si.pathIndex.path.setPoint(thisWireIndex, pSnap);
                    distanceFromStart = Math.abs(pSnap.distance(span.getP0()));
                    if (debug) {
                        APath seg = new APath();
                        seg.addPoint(si.pathIndex.path.getPoint(thisWireIndex - 1));
                        seg.addPoint(si.pathIndex.path.getPoint(thisWireIndex));
                        seg.addPoint(si.pathIndex.path.getPoint(thisWireIndex + 1));
                        this.pr.overlay.drawPath(limitedSpan.toPath(3L), Color.PINK);
                        this.pr.overlay.drawPath(seg, Color.WHITE);
                    }
                }
                previousRequired = distanceFromStart;
            }
            ++ith;
        }
    }

    protected Spring getNeighbor(Spring s, int offset) {
        SortedIntersection si = (SortedIntersection)s.o;
        PathIndex pi = si.pathIndex;
        APath myPath = pi.path;
        int neighborIndex = pi.index + offset;
        for (SpringSet as : SpringSet.world) {
            if (as.id == 16 && s.springSet.id == 44) {
                ALog.logInfo((String)"");
            }
            for (Spring aspring : as.springs) {
                SortedIntersection asi = (SortedIntersection)aspring.o;
                PathIndex api = asi.pathIndex;
                if (!api.path.equals((Object)myPath) || api.index != neighborIndex) continue;
                return aspring;
            }
        }
        return null;
    }

    protected Long getMyExcess(Spring s) {
        SpringSet ss = s.springSet;
        ALine l = ss.l;
        APoint2D lastSpringPos = l.getP0();
        for (Spring as : ss.springs) {
            SortedIntersection si = (SortedIntersection)as.o;
            if (as.equals(s)) {
                PathIndex pi = si.pathIndex;
                long slackToLast = pi.path.getPoint(pi.index).distance(lastSpringPos);
                long excess = slackToLast - s.minSlackFromLast();
                return excess;
            }
            lastSpringPos = si.pathIndex.path.getPoint(si.pathIndex.index);
        }
        return null;
    }

    protected void removeIrrelevantSprings() {
        LinkedList<Spring> toBeRemoved = new LinkedList<Spring>();
        for (SpringSet as : SpringSet.world) {
            ALine l = as.l;
            if (as.id == 44) {
                ALog.logInfo((String)"");
            }
            for (Spring s : as.springs) {
                long myExcess = this.getMyExcess(s);
                Spring prev = this.getNeighbor(s, -1);
                Spring next = this.getNeighbor(s, 1);
                if (prev == null || next == null || prev.springSet.l.getP0() == as.l.getP0() && next.springSet.l.getP0() == as.l.getP0()) continue;
                long prevSpringExcess = this.getMyExcess(prev);
                long nextSpringExcess = this.getMyExcess(next);
                if (myExcess <= prevSpringExcess || myExcess <= nextSpringExcess) continue;
                if (as.id == 137) {
                    ALog.logInfo((String)"");
                }
                toBeRemoved.add(s);
            }
        }
        for (Spring spring : toBeRemoved) {
            this.removeWireFromSpring(spring);
        }
    }

    protected void removeWireFromSpring(Spring spring) {
        SpringSet ss = spring.springSet;
        SortedIntersection si = (SortedIntersection)spring.o;
        ss.springs.remove(spring);
        PathIndex pi = si.pathIndex;
        pi.path.removePointAt(pi.index);
        for (SpringSet as : SpringSet.world) {
            for (Spring aSpring : as.springs) {
                SortedIntersection asi = (SortedIntersection)aSpring.o;
                PathIndex api = asi.pathIndex;
                if (!api.path.equals((Object)pi.path) || api.index <= pi.index) continue;
                --api.index;
            }
        }
    }

    protected void convertPathsToSpringJoints() {
        int wireNum = 0;
        for (TopologicalObject wTop : this.mFlexibleTopologicalSet) {
            ++wireNum;
            LinkedList<Info> springIntersections = new LinkedList<Info>();
            if (this.wireToSpring.get((Object)wTop) == null) continue;
            for (SpringSet ms : (LinkedList)this.wireToSpring.get((Object)wTop)) {
                for (Spring spring : ms.springs) {
                    SortedIntersection si = (SortedIntersection)spring.o;
                    if (si.t != wTop) continue;
                    Info info = new Info();
                    info.si = si;
                    info.ms = ms;
                    info.spring = spring;
                    springIntersections.add(info);
                    APoint2D p = ms.l.center();
                    spring.draw(this.pr, si.d, "" + ms.id);
                }
            }
            Collections.sort(springIntersections);
            APath xfer = new APath();
            xfer.addPoint(wTop.current.getFirstPoint());
            xfer.addPoint(wTop.current.getLastPoint());
            int index = 1;
            for (Info tight : springIntersections) {
                APoint2D newPoint = tight.ms.pointFromStart(tight.si.d);
                tight.spring.setCur(tight.si.d);
                xfer.insertPoint(index, newPoint);
                tight.si.pathIndex.path = xfer;
                tight.si.pathIndex.index = index++;
            }
            wTop.current = xfer;
        }
        SpringSet.sort();
        for (int pass = 0; pass < 3; ++pass) {
            for (int i = 0; i < 1; ++i) {
                for (SpringSet ss : SpringSet.world) {
                    ALog.logInfo((String)"");
                    this.pullWiresThroughSpring(ss, true, true);
                }
            }
        }
    }

    protected Topstacle getPin(String net) {
        for (Topstacle t : this.topToSpring.keySet()) {
            if (!t.net.getName().equals(net)) continue;
            return t;
        }
        return null;
    }

    protected void convertDbToTopologicalObjects() {
        this.convertWiresToTopologicalObjects();
        this.convertPinsToTopologicalObjects();
    }

    protected ArrayList<TopologicalObject> obstacleToOrderedWires(TopologicalObject obstacle) {
        return null;
    }

    protected static APath movePath(APath p, ALine v) {
        return null;
    }

    protected TopologicalObject netToMonotonicWire(Net n) {
        for (TopologicalObject wire : this.mFlexibleTopologicalSet) {
            if (!wire.net.equals(n)) continue;
            return wire;
        }
        return null;
    }

    public static class UniqueGeomSorter
    implements Comparator<TopologicalObject> {
        @Override
        public int compare(TopologicalObject m0, TopologicalObject m1) {
            if (m0.original.getFirstPoint().getY() < m1.original.getFirstPoint().getY()) {
                return 1;
            }
            if (m0.original.getFirstPoint().getY() > m1.original.getFirstPoint().getY()) {
                return -1;
            }
            if (m0.original.getFirstPoint().getX() < m1.original.getFirstPoint().getX()) {
                return 1;
            }
            if (m0.original.getFirstPoint().getX() > m1.original.getFirstPoint().getX()) {
                return -1;
            }
            return 0;
        }
    }

    protected static class TopologicalObject
    implements Comparable<TopologicalObject> {
        Frontier frontier = null;
        boolean flexible = false;
        double angleFace = 0.0;
        APath original = null;
        APath current = null;
        APoint2D c = null;
        Net net = null;
        Wire w = null;
        Topstacle t = null;
        int changes = 0;

        protected TopologicalObject() {
        }

        public void close() {
            this.current = this.original.copy();
        }

        public void setFrontier(Frontier frontierArea) {
            this.frontier = frontierArea;
        }

        public Frontier getFrontier() {
            return this.frontier;
        }

        @Override
        public int compareTo(TopologicalObject o) {
            return this.original.getFirstPoint().add(this.original.getLastPoint()).compareTo(o.original.getFirstPoint().add(o.original.getLastPoint()));
        }
    }

    protected static class PushFrontier {
        double angle;
        LinkedList<TopologicalObject> tos = new LinkedList();

        protected PushFrontier() {
        }
    }

    protected static class Neighborhood
    extends ArrayList<TopologicalObject> {
        protected Neighborhood() {
        }
    }

    static class Info
    implements Comparable<Info> {
        SortedIntersection si;
        SpringSet ms;
        Spring spring;
        boolean ok;

        Info() {
        }

        @Override
        public int compareTo(Info o) {
            if (o.si.index == this.si.index) {
                if (o.si.dFromVertex > this.si.dFromVertex) {
                    return -1;
                }
                return 1;
            }
            return this.si.index - o.si.index;
        }

        public String toString() {
            return "" + this.ms.id;
        }
    }

    public static class FloodableNodeSorter
    implements Comparator<FloodableNode> {
        @Override
        public int compare(FloodableNode o1, FloodableNode o2) {
            ALine p0 = o1.span;
            ALine p1 = o2.span;
            if (p0.getP0().getX() < p1.getP0().getX()) {
                return -1;
            }
            if (p0.getP0().getX() > p1.getP0().getX()) {
                return 1;
            }
            if (p0.getP0().getY() < p1.getP0().getY()) {
                return -1;
            }
            if (p0.getP0().getY() > p1.getP0().getY()) {
                return 1;
            }
            if (p0.getP1().getX() < p1.getP1().getX()) {
                return -1;
            }
            if (p0.getP1().getX() > p1.getP1().getX()) {
                return 1;
            }
            if (p0.getP1().getY() < p1.getP1().getY()) {
                return -1;
            }
            if (p0.getP1().getY() > p1.getP1().getY()) {
                return 1;
            }
            return 0;
        }
    }

    public static class PathSorter
    implements Comparator<TopologicalObject> {
        @Override
        public int compare(TopologicalObject o1, TopologicalObject o2) {
            APath p0 = o1.original;
            APath p1 = o2.original;
            if (p0.getFirstPoint().getX() < p1.getFirstPoint().getX()) {
                return -1;
            }
            if (p0.getFirstPoint().getX() > p1.getFirstPoint().getX()) {
                return 1;
            }
            if (p0.getFirstPoint().getY() < p1.getFirstPoint().getY()) {
                return -1;
            }
            if (p0.getFirstPoint().getY() > p1.getFirstPoint().getY()) {
                return 1;
            }
            return 0;
        }
    }

    protected class IntersectionSorter {
        LinkedList<Intersections> sets = new LinkedList();

        protected IntersectionSorter() {
        }

        public void add(Intersections list) {
            this.sets.add(list);
        }

        public Intersections sort() {
            Intersections combined = new Intersections();
            LinkedList wires = new LinkedList();
            Intersections best = null;
            int bestSize = 0;
            for (Intersections intersections : this.sets) {
                if (best != null && intersections.size() <= bestSize) continue;
                best = intersections;
                bestSize = intersections.size();
            }
            return best;
        }
    }

    static class Intersections
    extends LinkedList<SortedIntersection> {
        Intersections() {
        }
    }

    protected static class PushEdge {
        double angle;

        protected PushEdge() {
        }
    }

    protected class PushNode {
        protected TopologicalObject t;
        protected Frontier frontierTri;

        public PushNode(TopologicalObject t, Frontier frontierTri) {
            this.t = t;
            this.frontierTri = frontierTri;
        }

        protected APath extractInfluentialSection() {
            if (!this.t.flexible) {
                return this.t.original;
            }
            return this.t.original;
        }

        protected APath maxPath(Frontier frontier, APath above, APath below, double angle) {
            AffineTransform t = new AffineTransform();
            AffineTransform t0 = new AffineTransform();
            long cx = frontier.from.t.point.getX();
            long cy = frontier.from.t.point.getY();
            double incrAngle = 90.0 - angle;
            t.setToRotation(Math.toRadians(incrAngle), cx, cy);
            t0.setToRotation(Math.toRadians(-incrAngle), cx, cy);
            APath aboveT = above.transform(t);
            APath belowT = below.transform(t);
            APath pushedPath = PathUtil.moveAbove(aboveT, belowT);
            return pushedPath.transform(t0);
        }

        protected APath developPusherPath(Frontier frontier, APath belowPath, long separation) {
            boolean leftToRight;
            PathSection belowSection = PathSection.createPathSection2(belowPath, frontier.startSection, frontier.endSection);
            if (belowSection.getMid() == null) {
                return null;
            }
            AffineTransform t = new AffineTransform();
            AffineTransform t0 = new AffineTransform();
            long cx = frontier.from.t.point.getX();
            long cy = frontier.from.t.point.getY();
            double incrAngle = 90.0 - frontier.angle();
            t.setToRotation(Math.toRadians(incrAngle), cx, cy);
            t0.setToRotation(Math.toRadians(-incrAngle), cx, cy);
            APath below = belowSection.getMid().copy();
            below = below.cleanPath();
            APath transformed = below.transform(t);
            boolean bl = leftToRight = transformed.getFirstPoint().getX() < transformed.getLastPoint().getX();
            if (!leftToRight) {
                transformed.reverse();
            }
            ALine l = new ALine(transformed.getFirstPoint(), transformed.getLastPoint());
            double transformedAngle = l.getAngle();
            double pushDir0 = transformedAngle + 90.0;
            double pushDir1 = transformedAngle - 90.0;
            APath test0 = transformed.copy();
            APath test1 = transformed.copy();
            AVector push0 = new AVector(separation, Math.toRadians(pushDir0));
            AVector push1 = new AVector(separation, Math.toRadians(pushDir1));
            test0.movePathBy(push0);
            test1.movePathBy(push1);
            transformed = test0.distance(frontier.from.c) > test1.distance(frontier.from.c) ? test0 : test1;
            long s = separation;
            double a = NonMonotonicPusher.this.useRectangle(frontier.from.t) ? 45.0 : 22.5;
            s = (long)((double)s * Math.tan(Math.toRadians(a)));
            AVector end1 = new AVector(s, Math.toRadians(transformedAngle));
            transformed.insertPoint(0, transformed.getFirstPoint().sub(end1));
            transformed.addPoint(transformed.getLastPoint().add(end1));
            below = transformed.transform(t0);
            NonMonotonicPusher.this.snapPath(below, this.t.angleFace);
            return below;
        }

        protected APath moveAboveInSection(Frontier frontier, APath belowPath, APath abovePath, long separation, boolean debug, int ply) {
            APath pusherPath = this.developPusherPath(frontier, belowPath, separation);
            if (pusherPath == null) {
                return abovePath;
            }
            if (debug) {
                this.developPusherPath(frontier, belowPath, separation);
                NonMonotonicPusher.this.pr.overlay.drawPath(pusherPath, Color.RED);
                NonMonotonicPusher.this.pr.overlay.drawPath(frontier.startSection.toPath(1L), Color.PINK);
                NonMonotonicPusher.this.pr.overlay.drawPath(frontier.endSection.toPath(1L), Color.PINK);
            }
            Plunger p = new Plunger();
            p.develop(pusherPath, frontier.from.t.point, frontier.from.angleFace);
            if (debug) {
                // empty if block
            }
            PathSection ps = PathSection.createPathSection2(abovePath, p.test0, p.test1);
            if (ps.mid == null || ps.mid.getPointCount() < 2) {
                return abovePath;
            }
            ps = PathSection.createPathSection2(abovePath, p.l0, p.l1);
            if (debug) {
                NonMonotonicPusher.this.pr.overlay.drawPath(abovePath, Color.PINK);
                NonMonotonicPusher.this.pr.overlay.drawPath(p.l0.toPath(1L), Color.BLACK);
                NonMonotonicPusher.this.pr.overlay.drawPath(p.l1.toPath(1L), Color.BLACK);
            }
            if (ps.mid != null && ps.mid.getPointCount() > 1) {
                ps.setMid(ps.getMid().cleanPath());
                APath returnMidPath = this.maxPath(frontier, ps.getMid(), pusherPath, frontier.from.angleFace);
                if (debug) {
                    NonMonotonicPusher.this.pr.overlay.drawPath(ps.getMid(), Color.YELLOW);
                }
                ps.setMid(returnMidPath);
                APath returnPath = ps.assemble();
                if (debug) {
                    PathSection.createPathSection2(abovePath, p.l0, p.l1);
                }
                return returnPath;
            }
            return abovePath;
        }

        public void push(PushNode beingPushed, Frontier frontier, APath plunger, int ply, boolean debug) {
            SingleLayerRouter.RouteInformation r1;
            ++NonMonotonicPusher.this.debugCounter;
            debug = true;
            APath toPath = beingPushed.t.current.copy();
            toPath.setWidth(beingPushed.t.current.getWidth());
            long c0 = 0L;
            long c1 = 0L;
            SingleLayerRouter.RouteInformation r0 = NonMonotonicPusher.this.pr.mWireToRouteInformation.get(this.t.w);
            if (r0 != null) {
                c0 = r0.getClear();
            }
            if ((r1 = NonMonotonicPusher.this.pr.mWireToRouteInformation.get(beingPushed.t.w)) != null) {
                c1 = r1.getClear();
            }
            long clr = 0L;
            if (r0 == null) {
                ObstacleRelation r = NonMonotonicPusher.this.pinToWireRelation(this.t, beingPushed.t);
                if (r == ObstacleRelation.Connected) {
                    ALog.logInfo((String)"Problem");
                } else {
                    clr = r == ObstacleRelation.SameNet ? c1 : Math.max(c1, c0);
                }
            } else {
                clr = Math.max(c1, c0);
            }
            long separation = this.t.current.getWidth() / 2L + toPath.getWidth() / 2L;
            APath resultingPath = null;
            resultingPath = this.moveAboveInSection(frontier, plunger, toPath, separation + clr, debug, ply);
            if (resultingPath != null) {
                beingPushed.t.current = resultingPath;
                beingPushed.t.current.setWidth(toPath.getWidth());
                for (PushNode pnNext : NonMonotonicPusher.this.pushGraph.getSuccessors((Object)beingPushed)) {
                    beingPushed.push(pnNext, frontier, resultingPath, ply + 1, debug);
                }
            }
        }

        class Plunger {
            APath face;
            ALine l0;
            ALine l1;
            ALine test0;
            ALine test1;

            Plunger() {
            }

            public void develop(APath f, APoint2D c, double angle) {
                APoint2D p1;
                APoint2D p0;
                this.face = f.copy();
                AffineTransform t = new AffineTransform();
                AffineTransform t0 = new AffineTransform();
                long cx = c.getX();
                long cy = c.getY();
                double incrAngle = 90.0 - angle;
                t.setToRotation(Math.toRadians(incrAngle), cx, cy);
                t0.setToRotation(Math.toRadians(-incrAngle), cx, cy);
                APath faceT = this.face.transform(t);
                if (faceT.getFirstPoint().getX() > faceT.getLastPoint().getX()) {
                    APoint2D p12 = NonMonotonicPusher.this.snap(faceT.getFirstPoint(), PushDir.UpLeft);
                    APoint2D p02 = NonMonotonicPusher.this.snap(faceT.getLastPoint(), PushDir.UpRight);
                    this.l0 = new ALine(p12.getX(), cy, p12.getX(), p12.getY());
                    this.l1 = new ALine(p02.getX(), cy, p02.getX(), p02.getY());
                    this.test0 = new ALine(cx, cy, p12.getX(), p12.getY());
                    this.test1 = new ALine(cx, cy, p02.getX(), p02.getY());
                } else {
                    p0 = NonMonotonicPusher.this.snap(faceT.getFirstPoint(), PushDir.UpLeft);
                    p1 = NonMonotonicPusher.this.snap(faceT.getLastPoint(), PushDir.UpRight);
                    this.l0 = new ALine(p0.getX(), cy, p0.getX(), p0.getY());
                    this.l1 = new ALine(p1.getX(), cy, p1.getX(), p1.getY());
                    this.test0 = new ALine(cx, cy, p0.getX(), p0.getY());
                    this.test1 = new ALine(cx, cy, p1.getX(), p1.getY());
                }
                p0 = NonMonotonicPusher.this.snap(faceT.getFirstPoint(), PushDir.UpLeft);
                p1 = NonMonotonicPusher.this.snap(faceT.getLastPoint(), PushDir.UpRight);
                this.l0 = new ALine(p0.getX(), cy, p0.getX(), p0.getY());
                this.l1 = new ALine(p1.getX(), cy, p1.getX(), p1.getY());
                this.l0 = this.l0.transform(t0);
                this.l1 = this.l1.transform(t0);
                this.test0 = this.test0.transform(t0);
                this.test1 = this.test1.transform(t0);
            }
        }

        protected class AreaPusher {
            Frontier frontierArea;

            protected AreaPusher() {
            }
        }
    }

    static class PushSet
    extends LinkedList<TopologicalObject> {
        PushSet() {
        }
    }

    protected static class Frontier {
        protected ALine whisker;
        protected ALine startSection;
        protected ALine endSection;
        protected ALine startSectionExpanded;
        protected ALine endSectionExpanded;
        protected APath frontier;
        protected double cAngle;
        protected LinkedList<SortedIntersection> flexibleList = new LinkedList();
        protected LinkedList<PushNode> pushNodes = new LinkedList();
        protected TopologicalObject from;

        public Frontier(ALine whisker, double angle, APath frontier) {
            this.whisker = whisker;
            this.frontier = frontier;
            this.cAngle = angle;
            double a = whisker.getAngle();
            double a0 = a - this.cAngle / 2.0;
            double a1 = a0 + this.cAngle;
            this.startSection = new ALine();
            this.endSection = new ALine();
            this.startSection = whisker.getP0().makeVector(whisker.getLength(), a0);
            this.endSection = whisker.getP0().makeVector(whisker.getLength(), a1);
            AVector push0 = new AVector(500L, Math.toRadians(a0 - 90.0));
            this.startSectionExpanded = new ALine(this.startSection);
            this.startSectionExpanded.moveBy(push0.getX(), push0.getY());
            AVector push1 = new AVector(500L, Math.toRadians(a0 + 90.0));
            this.endSectionExpanded = new ALine(this.endSection);
            this.endSectionExpanded.moveBy(push1.getX(), push1.getY());
        }

        public double angle() {
            return this.whisker.getAngle();
        }

        public void setFlexibleList(LinkedList<SortedIntersection> intersections) {
            this.flexibleList = intersections;
        }

        public LinkedList<TopologicalObject> getFlexibleFrontier() {
            LinkedList<TopologicalObject> list = new LinkedList<TopologicalObject>();
            for (SortedIntersection intersection : this.flexibleList) {
                list.add(intersection.t);
            }
            return list;
        }
    }

    static class SortedIntersection
    implements Comparable<SortedIntersection> {
        long dFromVertex;
        long d;
        int index;
        TopologicalObject t;
        PathIndex pathIndex = new PathIndex();

        public SortedIntersection(long d, TopologicalObject t) {
            this.d = d;
            this.t = t;
        }

        public SortedIntersection(long d, TopologicalObject t, int index, long dFromVertex) {
            this.d = d;
            this.t = t;
            this.index = index;
            this.dFromVertex = dFromVertex;
        }

        @Override
        public int compareTo(SortedIntersection o) {
            if (this.d < o.d) {
                return -1;
            }
            if (this.d > o.d) {
                return 1;
            }
            return 0;
        }
    }

    static class PathIndex {
        APath path;
        int index;

        PathIndex() {
        }
    }

    static class IntersectionIndex {
        APoint2D intersection = null;
        int idx = -1;

        IntersectionIndex() {
        }
    }

    public static enum ObstacleRelation {
        DifferentNet,
        SameNet,
        Connected;

    }

    public static enum PushDir {
        Right,
        UpRight,
        Up,
        UpLeft,
        Left,
        DnLeft,
        Dn,
        DnRight,
        Unknown;

    }
}

