/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.PathUtil;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.automation.router.WireMap;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class OrthoWirePusher {
    public boolean justVertical = true;
    ArrayList<TopologicalObject> mTopologicalSet = new ArrayList();
    ArrayList<TopologicalObject> mFlexibleTopologicalSet = new ArrayList();
    ArrayList<TopologicalObject> mRigidTopologicalSet = new ArrayList();
    HashMap<DbObject, TopologicalObject> mDbToMo = new HashMap();
    protected PrettyRouter pr;
    protected boolean compactMode = false;
    int debugCounter = 0;
    HashMap<Topstacle, Whiskers> t2w = new HashMap();
    AHashCollection<Wire, Whisker> wire2whisker = new AHashCollection();

    public void setCompactMode(boolean mode) {
        this.compactMode = mode;
    }

    public OrthoWirePusher(PrettyRouter pr) {
        this.pr = pr;
    }

    public void setPrettyRouter(PrettyRouter pr) {
        this.pr = pr;
    }

    protected void developOrderedNearFlexibleObjects() {
        LinkedList<TopologicalObject> flexible = new LinkedList<TopologicalObject>();
        LinkedList<TopologicalObject> rigid = new LinkedList<TopologicalObject>();
        for (TopologicalObject t : this.mTopologicalSet) {
            if (t.flexible) {
                flexible.add(t);
                continue;
            }
            rigid.add(t);
        }
        HashSet<Topstacle> topstacles = new HashSet<Topstacle>();
        for (FloodableNode fn : this.pr.mFloodableNodes) {
            if (!fn.isChannel) continue;
            topstacles.add((Topstacle)fn.mChannel.getP1());
            topstacles.add((Topstacle)fn.mChannel.getP2());
        }
        for (TopologicalObject pin : rigid) {
            Topstacle topstacle = pin.t;
            ArrayList<FloodableNode> fns = this.pr.topstacleToFloodableNodes(topstacle);
            long maxLength = 0L;
            for (FloodableNode fn : fns) {
                long length = fn.getLength();
                maxLength = Math.max(length, maxLength);
            }
            double incAngle = 90.0;
            if (pin.t.toString().contains("Bump8")) {
                // empty if block
            }
            for (double angle = 0.0; angle < 360.0; angle += incAngle) {
                if (pin.angleFace != angle) continue;
                LinkedList<SortedIntersection> intersections = new LinkedList<SortedIntersection>();
                ALine whisker = topstacle.point.makeVector(maxLength, angle);
                FrontierArea frontierArea = new FrontierArea(whisker, pin.original);
                block5: for (TopologicalObject wireObject : flexible) {
                    Wire w = wireObject.w;
                    APath p = w.getPath();
                    for (ALine lOfPath : p.getLines()) {
                        lOfPath.extendEnds(2L);
                        if (!whisker.intersects((AGeom)lOfPath)) continue;
                        APoint2D intersection = whisker.getIntersectLines(lOfPath);
                        long d = Math.abs(whisker.getP0().distance(intersection));
                        intersections.add(new SortedIntersection(d, wireObject));
                        continue block5;
                    }
                }
                Collections.sort(intersections);
                frontierArea.setFlexibleList(intersections);
                pin.addFrontierArea(frontierArea);
            }
        }
    }

    protected void generateWhiskers() {
        this.pr.overlay.deletePaths();
        LinkedList<TopologicalObject> flexible = new LinkedList<TopologicalObject>();
        LinkedList<TopologicalObject> rigid = new LinkedList<TopologicalObject>();
        for (TopologicalObject t : this.mTopologicalSet) {
            if (t.flexible) {
                flexible.add(t);
                continue;
            }
            rigid.add(t);
        }
        HashSet<Topstacle> topstacles = new HashSet<Topstacle>();
        for (FloodableNode fn : this.pr.mFloodableNodes) {
            if (!fn.isChannel) continue;
            topstacles.add((Topstacle)fn.mChannel.getP1());
            topstacles.add((Topstacle)fn.mChannel.getP2());
        }
        for (Topstacle pin : topstacles) {
            ArrayList<FloodableNode> fns = this.pr.topstacleToFloodableNodes(pin);
            Whiskers ws = new Whiskers();
            this.t2w.put(pin, ws);
            long maxLength = 0L;
            for (FloodableNode fn : fns) {
                long length = fn.getLength();
                maxLength = Math.max(length, maxLength);
            }
            double incAngle = 90.0;
            for (double angle = 0.0; angle < 360.0; angle += incAngle) {
                ALine probe = pin.point.makeVector(maxLength, angle);
                for (TopologicalObject wireObject : flexible) {
                    Wire w = wireObject.w;
                    APath p = w.getPath();
                    int segment = 0;
                    for (ALine lOfPath : p.getLines()) {
                        lOfPath.extendEnds(2L);
                        if (probe.intersects((AGeom)lOfPath)) {
                            APoint2D intersection = probe.getIntersectLines(lOfPath);
                            probe.setP1(intersection);
                            Whisker whisker = new Whisker(angle, probe, w, segment);
                            ws.add(whisker);
                            whisker.draw();
                        }
                        ++segment;
                    }
                }
            }
        }
    }

    protected LinkedList<Whisker> getSortedWhiskers(Wire w) {
        LinkedList<Whisker> ret = new LinkedList<Whisker>();
        return ret;
    }

    protected void createTopologicalObjects() {
        for (Wire w : this.pr.mWiretoLastFn.keySet()) {
            w.clean();
            TopologicalObject tObject = new TopologicalObject();
            tObject.original = w.getPath().copy();
            long dx = Math.abs(tObject.original.getFirstPoint().getX() - tObject.original.getLastPoint().getX());
            long dy = Math.abs(tObject.original.getFirstPoint().getY() - tObject.original.getLastPoint().getY());
            tObject.horizontal = dx > dy;
            tObject.net = w.getNet();
            tObject.flexible = true;
            tObject.clr = this.pr.getRI(w).getClear();
            if (tObject.clr == 0L) {
                // empty if block
            }
            tObject.close();
            tObject.w = w;
            this.mFlexibleTopologicalSet.add(tObject);
            this.mTopologicalSet.add(tObject);
            this.mDbToMo.put((DbObject)w, tObject);
        }
        HashSet<Topstacle> topstacles = new HashSet<Topstacle>();
        for (FloodableNode fn : this.pr.mFloodableNodes) {
            if (!fn.isChannel) continue;
            topstacles.add((Topstacle)fn.mChannel.getP1());
            topstacles.add((Topstacle)fn.mChannel.getP2());
        }
        for (Topstacle topstacle : topstacles) {
            Net n = topstacle.net;
            if (n == null) continue;
            boolean iAmOrtho = false;
            if (topstacle.getShape() instanceof ARect) {
                iAmOrtho = true;
            }
            ArrayList<Neighborhood> neighborhoods = new ArrayList<Neighborhood>();
            ArrayList<FloodableNode> fns = this.pr.topstacleToFloodableNodes(topstacle);
            for (FloodableNode fn : fns) {
                Neighborhood nh = new Neighborhood();
                for (WireMap wm : fn.wireMaps) {
                    Wire wire = wm.wire;
                    TopologicalObject mo = this.mDbToMo.get(wire);
                    nh.add(mo);
                }
                if (fn.mChannel.getP2() == topstacle) {
                    Collections.reverse(nh);
                }
                Topstacle otherTopstacle = fn.mChannel.getP1() == topstacle ? (Topstacle)fn.mChannel.getP2() : (Topstacle)fn.mChannel.getP1();
                ArrayList<FloodableNode> fnOthers = this.pr.topstacleToFloodableNodes(otherTopstacle);
                for (FloodableNode fnOther : fnOthers) {
                    Wire nextWire = null;
                    if (fnOther.wireMaps.size() > 0) {
                        nextWire = fnOther.mChannel.getP1() == otherTopstacle ? fnOther.wireMaps.get((int)0).wire : fnOther.wireMaps.get((int)(fnOther.wireMaps.size() - 1)).wire;
                    }
                    if (nextWire == null) continue;
                    TopologicalObject mo = this.mDbToMo.get(nextWire);
                    nh.add(mo);
                }
                neighborhoods.add(nh);
            }
            ARect r = topstacle.getBounds();
            boolean useRectangle = true;
            if (useRectangle) {
                for (int i = 0; i < 4; ++i) {
                    TopologicalObject tObject = new TopologicalObject();
                    tObject.neighborhoods = neighborhoods;
                    tObject.net = n;
                    tObject.c = r.center();
                    tObject.flexible = false;
                    tObject.clr = 0L;
                    tObject.iAmOrtho = iAmOrtho;
                    tObject.t = topstacle;
                    if (i == 0) {
                        tObject.original = r.rightEdge().toPath(0L);
                        tObject.angleFace = 0.0;
                        tObject.horizontal = false;
                    } else if (i == 1) {
                        tObject.original = r.topEdge().toPath(0L);
                        tObject.angleFace = 90.0;
                        tObject.horizontal = true;
                    } else if (i == 2) {
                        tObject.original = r.leftEdge().toPath(0L);
                        tObject.angleFace = 180.0;
                        tObject.horizontal = false;
                    } else if (i == 3) {
                        tObject.original = r.bottomEdge().toPath(0L);
                        tObject.angleFace = 270.0;
                        tObject.horizontal = true;
                    }
                    tObject.close();
                    this.mTopologicalSet.add(tObject);
                    this.mRigidTopologicalSet.add(tObject);
                }
                continue;
            }
            long radius = r.width() / 2L;
            AOctagon oct = new AOctagon(radius);
            oct.moveCenterTo(r.center());
            for (ALine side : oct.getLines()) {
                TopologicalObject tObject = new TopologicalObject();
                tObject.neighborhoods = neighborhoods;
                tObject.net = n;
                tObject.c = r.center();
                tObject.flexible = false;
                tObject.clr = 0L;
                tObject.iAmOrtho = iAmOrtho;
                tObject.t = topstacle;
                tObject.original = side.toPath(0L);
                double normal = side.getAngle();
                tObject.angleFace = normal - 90.0;
                tObject.horizontal = normal == 90.0 || normal == 180.0;
                tObject.close();
                this.mTopologicalSet.add(tObject);
                this.mRigidTopologicalSet.add(tObject);
            }
        }
        Collections.sort(this.mTopologicalSet, new HorizontalMonotonicSorter());
    }

    protected int moveSegment(APath path, int index, long amount, long s0, long s1) {
        boolean pAFixed = false;
        boolean pBFixed = false;
        if (index == 0) {
            path.insertPoint(0, new APoint2D(path.getPoint(0)));
            ++index;
            pAFixed = true;
        } else if (index == path.getPointCount() - 2) {
            path.insertPoint(path.getPointCount() - 1, new APoint2D(path.getPoint(path.getPointCount() - 1)));
            pBFixed = true;
        }
        int insertPoint = index + 1;
        APoint2D pA = path.getPoint(index);
        APoint2D pB = path.getPoint(index + 1);
        if (pA.getX() == s1) {
            return -1;
        }
        if (pB.getX() == s0) {
            return -1;
        }
        long right = Math.max(s0, s1);
        long left = Math.min(s0, s1);
        if (pAFixed && pA.getX() >= left && pA.getX() <= right) {
            return path.getPointCount() - 1;
        }
        if (pBFixed && pB.getX() >= left && pB.getX() <= right) {
            return path.getPointCount() - 1;
        }
        APoint2D p0 = new APoint2D(Math.max(pA.getX(), left), pA.getY());
        if (left > pA.getX()) {
            path.insertPoint(insertPoint++, p0);
        }
        APoint2D p1 = new APoint2D(p0.getX(), p0.getY() + amount);
        path.insertPoint(insertPoint++, p1);
        APoint2D p2 = new APoint2D(Math.min(pB.getX(), right), p1.getY());
        path.insertPoint(insertPoint++, p2);
        if (right < pB.getX()) {
            APoint2D p3 = new APoint2D(p2.getX(), pB.getY());
            path.insertPoint(insertPoint++, p3);
        }
        return insertPoint - 1;
    }

    protected int moveSegmentFull(APath path, int index, long amount) {
        if (index == 0) {
            path.insertPoint(0, new APoint2D(path.getPoint(0)));
            ++index;
        } else if (index == path.getPointCount() - 2) {
            path.insertPoint(path.getPointCount() - 1, new APoint2D(path.getPoint(path.getPointCount() - 1)));
        }
        int insertPoint = index + 1;
        APoint2D pA = path.getPoint(index).add(0L, amount);
        APoint2D pB = path.getPoint(index + 1).add(0L, amount);
        path.setPoint(index, pA);
        path.setPoint(index + 1, pB);
        return insertPoint - 1;
    }

    protected int moveSegmentOneEnd(APath path, int index, long amount, long s0, long s1) {
        boolean pAFixed = false;
        boolean pBFixed = false;
        if (index == 0) {
            path.insertPoint(0, new APoint2D(path.getPoint(0)));
            ++index;
            pAFixed = true;
        } else if (index == path.getPointCount() - 2) {
            path.insertPoint(path.getPointCount() - 1, new APoint2D(path.getPoint(path.getPointCount() - 1)));
            pBFixed = true;
        }
        int insertPoint = index + 1;
        APoint2D pA = path.getPoint(index);
        APoint2D pB = path.getPoint(index + 1);
        if (pA.getX() == s1) {
            return -1;
        }
        if (pB.getX() == s0) {
            return -1;
        }
        long right = Math.max(s0, s1);
        long left = Math.min(s0, s1);
        if (pAFixed && pA.getX() >= left && pA.getX() <= right) {
            return path.getPointCount() - 1;
        }
        if (pBFixed && pB.getX() >= left && pB.getX() <= right) {
            return path.getPointCount() - 1;
        }
        APoint2D p1 = new APoint2D(pA.getX(), pA.getY() + amount);
        path.insertPoint(insertPoint++, p1);
        APoint2D p2 = new APoint2D(Math.min(pB.getX(), right), p1.getY());
        path.insertPoint(insertPoint++, p2);
        if (right < pB.getX()) {
            APoint2D p3 = new APoint2D(p2.getX(), pB.getY());
            path.insertPoint(insertPoint++, p3);
        }
        return insertPoint - 1;
    }

    protected ArrayList<TopologicalObject> obstacleToOrderedWires(TopologicalObject obstacle) {
        return null;
    }

    public void createSimpleTraces() {
        for (int i = 0; i < this.mTopologicalSet.size(); ++i) {
            TopologicalObject iMO = this.mTopologicalSet.get(i);
            if (!iMO.flexible) continue;
            APath path = new APath();
            path.addPoint(iMO.original.getFirstPoint());
            path.addPoint(iMO.original.getLastPoint());
            path.setWidth(iMO.original.getWidth());
            PathUtil.dogLeg(path, 0, 1);
            iMO.current = path;
        }
    }

    public void createLowBoundTraces() {
        for (int i = 0; i < this.mTopologicalSet.size(); ++i) {
            TopologicalObject iMO = this.mTopologicalSet.get(i);
            if (!iMO.flexible) continue;
            APath path = new APath();
            path.addPoint(iMO.original.getFirstPoint());
            path.addPoint(0L, iMO.original.getFirstPoint().getY());
            path.addPoint(0L, iMO.original.getLastPoint().getY());
            path.addPoint(iMO.original.getLastPoint());
            path.setWidth(iMO.original.getWidth());
            iMO.current = path;
        }
    }

    public void highPassFilter(long cutOff) {
        for (TopologicalObject iMO : this.mFlexibleTopologicalSet) {
            PathNormalizer pn = new PathNormalizer();
            APath path = pn.normalizePath(iMO.current);
            boolean changedAtAll = false;
            int i = 1;
            while (i < path.getPointCount() - 3) {
                ALine l3;
                ALine l2;
                boolean changedThisPass = false;
                APoint2D p0 = new APoint2D(path.getPoint(i));
                APoint2D p1 = new APoint2D(path.getPoint(i + 1));
                APoint2D p2 = new APoint2D(path.getPoint(i + 2));
                APoint2D p3 = new APoint2D(path.getPoint(i + 3));
                ALine l1 = new ALine(p0, p1);
                if (l1.isVertical() && (l2 = new ALine(p1, p2)).isHorizontal() && Math.abs(l2.getLength()) <= cutOff && (l3 = new ALine(p2, p3)).isVertical()) {
                    changedThisPass = true;
                    changedAtAll = true;
                    if (p3.getY() > p0.getY()) {
                        p1.setY(p3.getY());
                        path.removePointAt(i + 1);
                        path.removePointAt(i + 1);
                        path.setPoint(i + 1, p1);
                    } else {
                        p0.setX(p2.getX());
                        path.removePointAt(i + 1);
                        path.removePointAt(i + 1);
                        path.setPoint(i, p0);
                    }
                }
                if (changedThisPass) {
                    i = 1;
                    continue;
                }
                ++i;
            }
            if (!changedAtAll) continue;
            iMO.current = pn.deNormalizePath(path);
        }
    }

    public void verticalJogFilter() {
        for (TopologicalObject iMO : this.mFlexibleTopologicalSet) {
            PathNormalizer pn = new PathNormalizer();
            APath path = pn.normalizePath(iMO.current);
            boolean changedAtAll = false;
            int i = 1;
            while (i < path.getPointCount() - 4) {
                ALine l3;
                ALine l2;
                boolean changedThisPass = false;
                APoint2D p0 = new APoint2D(path.getPoint(i));
                APoint2D p1 = new APoint2D(path.getPoint(i + 1));
                APoint2D p2 = new APoint2D(path.getPoint(i + 2));
                APoint2D p3 = new APoint2D(path.getPoint(i + 3));
                ALine l1 = new ALine(p0, p1);
                if (l1.isVertical() && l1.dY() > 0L && (l2 = new ALine(p1, p2)).isHorizontal() && (l3 = new ALine(p2, p3)).isVertical() && l3.dY() < 0L) {
                    changedThisPass = true;
                    changedAtAll = true;
                    if (p3.getY() > p0.getY()) {
                        p1.setY(p3.getY());
                        path.removePointAt(i + 1);
                        path.removePointAt(i + 1);
                        path.setPoint(i + 1, p1);
                    } else {
                        p0.setX(p2.getX());
                        path.removePointAt(i + 1);
                        path.removePointAt(i + 1);
                        path.setPoint(i, p0);
                    }
                }
                if (changedThisPass) {
                    i = 1;
                    continue;
                }
                ++i;
            }
            if (!changedAtAll) continue;
            iMO.current = pn.deNormalizePath(path);
        }
    }

    public void stairFilter() {
        for (TopologicalObject iMO : this.mFlexibleTopologicalSet) {
            PathNormalizer pn = new PathNormalizer();
            APath path = pn.normalizePath(iMO.current);
            boolean changedAtAll = false;
            int i = 1;
            while (i < path.getPointCount() - 4) {
                ALine l3;
                ALine l2;
                boolean changedThisPass = false;
                APoint2D p0 = new APoint2D(path.getPoint(i));
                APoint2D p1 = new APoint2D(path.getPoint(i + 1));
                APoint2D p2 = new APoint2D(path.getPoint(i + 2));
                APoint2D p3 = new APoint2D(path.getPoint(i + 3));
                ALine l1 = new ALine(p0, p1);
                if (l1.isVertical() && l1.dY() < 0L && (l2 = new ALine(p1, p2)).isHorizontal() && (l3 = new ALine(p2, p3)).isVertical() && l3.dY() < 0L) {
                    changedThisPass = true;
                    changedAtAll = true;
                    p3.setX(p0.getX());
                    path.removePointAt(i + 1);
                    path.removePointAt(i + 1);
                    path.setPoint(i + 1, p3);
                }
                if (changedThisPass) {
                    i = 0;
                    continue;
                }
                ++i;
            }
            if (!changedAtAll) continue;
            iMO.current = pn.deNormalizePath(path);
        }
    }

    protected void influenceFilter() {
        for (TopologicalObject iMO : this.mFlexibleTopologicalSet) {
            PathNormalizer pn = new PathNormalizer();
            APath path = pn.normalizePath(iMO.current);
            InfluencedSegs iSegs = iMO.influencedSegs;
            for (int i = 1; i < path.getPointCount() - 2; ++i) {
                APoint2D p1;
                APoint2D p0 = new APoint2D(path.getPoint(i));
                ALine l1 = new ALine(p0, p1 = new APoint2D(path.getPoint(i + 1)));
                if (!l1.isHorizontal()) continue;
                boolean influenced = false;
                if (l1.dX() < 0L) {
                    l1.swap();
                }
                for (InfluencedSeg iseg : iSegs.influencedSegs) {
                    if (iseg.p0 != l1.getP0().getX() || iseg.p1 != l1.getP1().getX()) continue;
                    influenced = true;
                    break;
                }
                if (influenced) continue;
                path.setPoint(i, new APoint2D(path.getPoint(i - 1)));
                path.setPoint(i + 1, new APoint2D(path.getPoint(i + 1).getX(), path.getPoint(i).getY()));
            }
            iMO.current = pn.deNormalizePath(path);
        }
    }

    public void monotonicPush() {
        int i;
        this.createTopologicalObjects();
        this.createSimpleTraces();
        this.developOrderedNearFlexibleObjects();
        for (i = 0; i < 1; ++i) {
            this.pushAllFlexibleObjectsR(true, PushType.Notch, "Pushing", true);
            this.pushAllFlexibleObjectsR(false, PushType.Notch, "Pushing", true);
        }
        this.highPassFilter(12000L);
        for (i = 0; i < 1; ++i) {
            this.pushAllFlexibleObjectsR(true, PushType.Notch, "Pushing", true);
            this.pushAllFlexibleObjectsR(false, PushType.Notch, "Pushing", true);
        }
        this.highPassFilter(50000L);
        for (i = 0; i < 1; ++i) {
            this.pushAllFlexibleObjectsR(true, PushType.Notch, "Pushing", true);
            this.pushAllFlexibleObjectsR(false, PushType.Notch, "Pushing", true);
        }
        this.highPassFilter(12000L);
        for (i = 0; i < 1; ++i) {
            this.pushAllFlexibleObjectsR(true, PushType.Notch, "Pushing", true);
            this.pushAllFlexibleObjectsR(false, PushType.Notch, "Pushing", true);
        }
        for (i = 0; i < this.mTopologicalSet.size(); ++i) {
            TopologicalObject iMO = this.mTopologicalSet.get(i);
            if (iMO.w == null) continue;
            iMO.w.setPath(iMO.current);
        }
    }

    protected void pushThisWireOnOtherSideOfRigid(String netWire, String netPad, boolean above) {
        for (TopologicalObject wire : this.mFlexibleTopologicalSet) {
            if (!wire.net.getName().equals(netWire)) continue;
            for (TopologicalObject obstacle : this.mTopologicalSet) {
                if (!obstacle.net.getName().equals(netPad)) continue;
                long clr = Math.max(wire.clr, obstacle.clr);
                clr += wire.original.getWidth() / 2L;
                obstacle.push(wire, above, clr += obstacle.original.getWidth() / 2L, PushType.Notch);
            }
        }
    }

    protected void wireIs(String netFlexibleWire, boolean horizontal) {
        for (TopologicalObject wire : this.mFlexibleTopologicalSet) {
            if (!wire.net.getName().equals(netFlexibleWire)) continue;
            wire.horizontal = horizontal;
        }
    }

    protected void pushThisWireOnOtherSideOfWire(String netFlexibleWire, String netRigidWire, boolean above) {
        for (TopologicalObject wire : this.mFlexibleTopologicalSet) {
            if (!wire.net.getName().equals(netFlexibleWire)) continue;
            for (TopologicalObject obstacle : this.mFlexibleTopologicalSet) {
                if (!obstacle.net.getName().equals(netRigidWire) || (!above || !wire.amIAbove(obstacle)) && (above || !obstacle.amIAbove(wire))) continue;
                long clr = Math.max(wire.clr, obstacle.clr);
                clr += wire.original.getWidth() / 2L;
                obstacle.push(wire, above, clr += obstacle.original.getWidth() / 2L, PushType.Notch);
            }
        }
    }

    protected TopologicalObject netToMonotonicWire(Net n) {
        for (TopologicalObject wire : this.mFlexibleTopologicalSet) {
            if (!wire.net.equals(n)) continue;
            return wire;
        }
        return null;
    }

    protected void pushAway(TopologicalObject pinFacet) {
        for (Neighborhood neighborhood : pinFacet.neighborhoods) {
            TopologicalObject lastRigidObject = pinFacet;
            for (TopologicalObject flexibleObject : neighborhood) {
                if (!flexibleObject.net.equals(lastRigidObject.net)) continue;
                lastRigidObject = flexibleObject;
            }
        }
    }

    protected void pushAwayAll() {
        for (TopologicalObject padObject : this.mTopologicalSet) {
            if (padObject.flexible) continue;
            this.pushAway(padObject);
        }
    }

    protected void pushAllFlexibleObjectsR(boolean up, PushType entireSegments, String phase, boolean everything) {
        for (TopologicalObject padObject : this.mTopologicalSet) {
            if (padObject.flexible || !everything && !padObject.iAmOrtho) continue;
            if (padObject.t.id.contains("368__289")) {
                // empty if block
            }
            TopologicalObject wireAttachedToPad = this.netToMonotonicWire(padObject.net);
            for (Neighborhood neighborhood : padObject.neighborhoods) {
                for (int rigidObjectClass = 0; rigidObjectClass < 2; ++rigidObjectClass) {
                    TopologicalObject lastRigidObject = rigidObjectClass == 0 ? padObject : wireAttachedToPad;
                    if (lastRigidObject == null) continue;
                    for (TopologicalObject flexibleObject : neighborhood) {
                        if (flexibleObject.net.equals(lastRigidObject.net)) {
                            lastRigidObject = flexibleObject;
                            continue;
                        }
                        long clr = Math.max(flexibleObject.clr, lastRigidObject.clr);
                        clr += lastRigidObject.original.getWidth() / 2L;
                        clr += flexibleObject.original.getWidth() / 2L;
                        if (!flexibleObject.overlaps(lastRigidObject)) continue;
                        if (up) {
                            if (flexibleObject.amIAbove(lastRigidObject)) {
                                lastRigidObject.push(flexibleObject, up, clr, entireSegments);
                            }
                        } else if (lastRigidObject.amIAbove(flexibleObject)) {
                            lastRigidObject.push(flexibleObject, up, clr, entireSegments);
                        }
                        lastRigidObject = flexibleObject;
                    }
                }
            }
        }
    }

    public static class HorizontalMonotonicSorter
    implements Comparator<TopologicalObject> {
        @Override
        public int compare(TopologicalObject m0, TopologicalObject m1) {
            if (m0.horizontal == m1.horizontal && !m0.horizontal) {
                if (m0.original.getFirstPoint().getY() < m1.original.getFirstPoint().getY()) {
                    return 1;
                }
                if (m0.original.getFirstPoint().getY() > m1.original.getFirstPoint().getY()) {
                    return -1;
                }
            }
            return 0;
        }
    }

    protected class TopologicalObject
    implements Comparable<TopologicalObject> {
        LinkedList<FrontierArea> frontierAreas = new LinkedList();
        ArrayList<Neighborhood> neighborhoods = new ArrayList();
        InfluencedSegs influencedSegs = new InfluencedSegs();
        boolean horizontal = false;
        boolean flexible = false;
        boolean iAmOrtho = false;
        double angleFace = 0.0;
        long clr;
        public APath original = null;
        APath current = null;
        APoint2D c = null;
        Net net = null;
        Wire w = null;
        Topstacle t = null;
        int changes = 0;

        protected TopologicalObject() {
        }

        public void close() {
            this.current = this.original.copy();
        }

        public void addFrontierArea(FrontierArea frontierArea) {
            this.frontierAreas.add(frontierArea);
        }

        public ArrayList<TopologicalObject> newNeighborHood() {
            Neighborhood n = new Neighborhood();
            this.neighborhoods.add(n);
            return n;
        }

        public ArrayList<Neighborhood> getNeighborhoods() {
            return this.neighborhoods;
        }

        public boolean overlaps(TopologicalObject other) {
            if (this.horizontal != other.horizontal) {
                return false;
            }
            if (this.horizontal) {
                ALine thisLine = new ALine(this.original.getFirstPoint(), this.original.getLastPoint());
                ALine otherLine = new ALine(other.original.getFirstPoint(), other.original.getLastPoint());
                if (thisLine.getP0().getX() > thisLine.getP1().getX()) {
                    thisLine.swap();
                }
                if (otherLine.getP0().getX() > otherLine.getP1().getX()) {
                    otherLine.swap();
                }
                return thisLine.xShadows(otherLine);
            }
            ALine thisLine = new ALine(this.original.getFirstPoint(), this.original.getLastPoint());
            ALine otherLine = new ALine(other.original.getFirstPoint(), other.original.getLastPoint());
            if (thisLine.getP0().getY() > thisLine.getP1().getY()) {
                thisLine.swap();
            }
            if (otherLine.getP0().getY() > otherLine.getP1().getY()) {
                otherLine.swap();
            }
            return thisLine.yShadows(otherLine);
        }

        public boolean amIAbove(TopologicalObject other) {
            if (this.horizontal != other.horizontal) {
                ALog.logInfo((String)"route problem 1");
            }
            PathNormalizer pnThis = new PathNormalizer();
            PathNormalizer pnOther = new PathNormalizer();
            APath thisNorm = pnThis.normalizePath(this.original);
            APath otherNorm = pnOther.normalizePath(other.original);
            ArrayList<Long> xs = new ArrayList<Long>();
            APoint2D cNorm = new APoint2D();
            if (this.flexible) {
                for (APoint2D p : thisNorm.getPoints()) {
                    xs.add(p.getX());
                }
            } else {
                cNorm = pnThis.pointNormalizer(this.c);
                xs.add(cNorm.getX());
            }
            if (other.flexible) {
                for (APoint2D p : otherNorm.getPoints()) {
                    xs.add(p.getX());
                }
            } else {
                cNorm = pnOther.pointNormalizer(other.c);
                xs.add(cNorm.getX());
            }
            for (Long x : xs) {
                Long yOfOther = null;
                Long yOfThis = null;
                yOfOther = otherNorm.getMaxYAt(x.longValue());
                yOfThis = thisNorm.getMaxYAt(x.longValue());
                if (yOfOther == null || yOfThis == null) continue;
                if (!other.flexible) {
                    yOfOther = cNorm.getY();
                }
                if (!this.flexible) {
                    yOfThis = cNorm.getY();
                }
                if (yOfThis > yOfOther) {
                    return true;
                }
                if (yOfThis >= yOfOther) continue;
                return false;
            }
            return false;
        }

        public boolean push(TopologicalObject other, boolean positive, long clr, PushType pushType) {
            PathNormalizer pnThis = new PathNormalizer();
            PathNormalizer pnOther = new PathNormalizer();
            APath thisNorm = pnThis.normalizePath(this.current);
            APath otherNorm = pnOther.normalizePath(other.current);
            boolean changed = false;
            for (int i = 0; i < thisNorm.getPointCount() - 1; ++i) {
                ALine pusherLine = new ALine(thisNorm.getPoint(i), thisNorm.getPoint(i + 1));
                if (pusherLine.getLength() == 0L) continue;
                pusherLine.extendEnds(clr);
                for (int j = 0; j < otherNorm.getPointCount() - 1; ++j) {
                    int newJ;
                    long s1;
                    long s0;
                    ALine pusheeLine = new ALine(otherNorm.getPoint(j), otherNorm.getPoint(j + 1));
                    if (pusheeLine.getLength() == 0L || !pusherLine.xShadows(pusheeLine) || !pusheeLine.isHorizontal()) continue;
                    long dist = 0L;
                    dist = positive ? pusheeLine.getP0().getY() - pusherLine.getP0().getY() : pusherLine.getP0().getY() - pusheeLine.getP0().getY();
                    if (dist >= clr) continue;
                    long amount = clr - dist;
                    amount = positive ? Math.abs(amount) : -Math.abs(amount);
                    if (pushType.equals((Object)PushType.FirstEndOfSegement)) {
                        s0 = pusherLine.getP0().getX();
                        newJ = OrthoWirePusher.this.moveSegmentOneEnd(otherNorm, j, amount, s0, s1 = pusherLine.getP1().getX());
                        if (newJ <= 0) continue;
                        j = newJ - 1;
                        changed = true;
                        continue;
                    }
                    if (pushType.equals((Object)PushType.Notch)) {
                        s0 = pusherLine.getP0().getX();
                        newJ = OrthoWirePusher.this.moveSegment(otherNorm, j, amount, s0, s1 = pusherLine.getP1().getX());
                        if (newJ <= 0) continue;
                        j = newJ - 1;
                        changed = true;
                        other.influencedSegs.add(s0, s1);
                        continue;
                    }
                    if (!pushType.equals((Object)PushType.EntireSegment)) continue;
                    OrthoWirePusher.this.moveSegmentFull(otherNorm, j, amount);
                    changed = true;
                }
            }
            if (changed) {
                otherNorm.removeVSpikes();
                otherNorm = otherNorm.cleanPath();
                other.current = pnOther.deNormalizePath(otherNorm);
                ++other.changes;
            }
            return changed;
        }

        @Override
        public int compareTo(TopologicalObject o) {
            return this.original.getFirstPoint().add(this.original.getLastPoint()).compareTo(o.original.getFirstPoint().add(o.original.getLastPoint()));
        }
    }

    protected static class InfluencedSeg {
        long p0;
        long p1;

        protected InfluencedSeg() {
        }
    }

    protected class InfluencedSegs {
        ArrayList<InfluencedSeg> influencedSegs = new ArrayList();

        protected InfluencedSegs() {
        }

        public void add(long s0, long s1) {
            InfluencedSeg is = new InfluencedSeg();
            is.p0 = Math.min(s0, s1);
            is.p1 = Math.max(s0, s1);
            this.influencedSegs.add(is);
        }
    }

    protected static class PushFrontier {
        double angle;
        LinkedList<TopologicalObject> tos = new LinkedList();

        protected PushFrontier() {
        }
    }

    protected static class Neighborhood
    extends ArrayList<TopologicalObject> {
        protected Neighborhood() {
        }
    }

    protected static class PathNormalizer {
        APath incoming;
        boolean rotate = false;
        boolean reverse = false;
        AffineTransform t = new AffineTransform();

        protected PathNormalizer() {
        }

        public APath normalizePath(APath in) {
            long dx = in.getLastPoint().getX() - in.getFirstPoint().getX();
            long dy = in.getLastPoint().getY() - in.getFirstPoint().getY();
            if (Math.abs(dx) > Math.abs(dy)) {
                if (dx > 0L) {
                    return in.copy();
                }
                this.reverse = true;
                APath ret = in.copy();
                ret.reverse();
                return ret;
            }
            if (dy > 0L) {
                this.rotate = true;
                APath ret = in.copy();
                ret.rotate90();
                return ret;
            }
            this.rotate = true;
            this.reverse = true;
            APath ret = in.copy();
            ret.rotate90();
            ret.reverse();
            return ret;
        }

        public APoint2D pointNormalizer(APoint2D pIn) {
            if (this.rotate) {
                return pIn.rotate90();
            }
            return pIn;
        }

        public APath deNormalizePath(APath path) {
            APath ret = path.copy();
            if (this.rotate) {
                ret.rotate90();
            }
            if (this.reverse) {
                ret.reverse();
            }
            return ret;
        }
    }

    static class Whiskers {
        protected LinkedList<Whisker> whiskers = new LinkedList();

        Whiskers() {
        }

        public void add(Whisker w) {
            this.whiskers.add(w);
        }
    }

    class Whisker {
        protected double angle;
        protected ALine l;
        protected Wire w;
        int segment;

        public void draw() {
            OrthoWirePusher.this.pr.overlay.drawPath(this.l.toPath(1L), Color.blue);
        }

        public Whisker(double angle, ALine l, Wire w, int segment) {
            this.angle = angle;
            this.l = l;
            this.w = w;
            this.segment = segment;
        }

        public double getAngle() {
            return this.angle;
        }

        public void setAngle(double angle) {
            this.angle = angle;
        }

        public ALine getL() {
            return this.l;
        }

        public void setL(ALine l) {
            this.l = l;
        }

        public Wire getW() {
            return this.w;
        }

        public void setW(Wire w) {
            this.w = w;
        }

        public int getSegment() {
            return this.segment;
        }

        public void setSegment(int segment) {
            this.segment = segment;
        }
    }

    protected static class FrontierArea {
        protected ALine whisker;
        protected APath frontier;
        protected LinkedList<TopologicalObject> flexibleList = new LinkedList();
        protected TopologicalObject from;

        public FrontierArea(ALine whisker, APath frontier) {
            this.whisker = whisker;
            this.frontier = frontier;
        }

        public double angle() {
            return this.whisker.getAngle();
        }

        public void setFlexibleList(LinkedList<SortedIntersection> intersections) {
            for (SortedIntersection intersection : intersections) {
                this.flexibleList.add(intersection.t);
            }
        }
    }

    static class SortedIntersection
    implements Comparable<SortedIntersection> {
        long d;
        TopologicalObject t;

        public SortedIntersection(long d, TopologicalObject t) {
            this.d = d;
            this.t = t;
        }

        @Override
        public int compareTo(SortedIntersection o) {
            return Long.compare(this.d, o.d);
        }
    }

    public static enum PushType {
        EntireSegment,
        FirstEndOfSegement,
        Notch;

    }
}

