/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import java.util.ArrayList;

public class PathSection {
    protected APath pre = new APath();
    protected APath mid = new APath();
    protected APath post = new APath();

    public PathSection() {
    }

    public PathSection(APath pre, APath mid, APath post) {
        this.pre = pre;
        this.mid = mid;
        this.post = post;
    }

    public APath getPre() {
        return this.pre;
    }

    public void setPre(APath pre) {
        this.pre = pre;
    }

    public APath getMid() {
        return this.mid;
    }

    public void setMid(APath mid) {
        this.mid = mid;
    }

    public APath getPost() {
        return this.post;
    }

    public void setPost(APath post) {
        this.post = post;
    }

    public void removeDuplicateConnectingPts() {
        if (this.mid == null) {
            return;
        }
        if (this.pre.getPointCount() > 1 && this.pre.getPoint(this.pre.getPointCount() - 1).equals((Object)this.mid.getPoint(0))) {
            this.pre.removeLast();
        }
        if (this.post.getPointCount() > 1 && this.post.getPoint(0).equals((Object)this.mid.getPoint(this.mid.getPointCount() - 1))) {
            this.post.removeFirst();
        }
    }

    public APath assemble() {
        APath ret = new APath();
        for (APoint2D p : this.pre.getPoints()) {
            ret.addPoint(p);
        }
        if (this.mid != null) {
            for (APoint2D p : this.mid.getPoints()) {
                ret.addPoint(p);
            }
        }
        if (this.post != null) {
            for (APoint2D p : this.post.getPoints()) {
                ret.addPoint(p);
            }
        }
        ret = ret.cleanPath();
        return ret;
    }

    public static PathSection createPathSection2(APath path, ALine l1, ALine l2) {
        int intersections;
        PathSection aps = new PathSection();
        APath pre = new APath();
        APath mid = new APath();
        APath post = new APath();
        ALine first = null;
        ALine second = null;
        ALine ceiling = new ALine(l1.getP1(), l2.getP1());
        ALine floor = new ALine(l1.getP0(), l2.getP0());
        ALine la = new ALine(l1);
        ALine lb = new ALine(l2);
        if (IFact.intersects(path, la)) {
            first = new ALine(la);
        }
        if (IFact.intersects(path, lb)) {
            if (first == null) {
                first = new ALine(lb);
            } else {
                second = new ALine(lb);
            }
        }
        boolean intersectCeiling = false;
        APoint2D ceilingIntersection = null;
        APoint2D c1 = null;
        if (second == null) {
            intersectCeiling = true;
            if (IFact.intersects(path, ceiling)) {
                ArrayList<APoint2D> points = IFact.intersections(path, ceiling, null);
                ceilingIntersection = c1 = points.get(points.size() - 1);
                second = ceiling;
            }
        }
        if (second == null && IFact.intersects(path, floor)) {
            second = floor;
        }
        if ((intersections = first == null ? 0 : (second == null ? 1 : 2)) == 0) {
            aps.pre = path;
            aps.mid = null;
            aps.post = null;
            return aps;
        }
        if (intersections == 2) {
            if (!path.intersectsInOrder(first, second)) {
                ALine temp = new ALine(first);
                first = second;
                second = temp;
                ceilingIntersection = null;
            } else if (intersectCeiling) {
                ceilingIntersection = c1;
            }
        }
        APoint2D p1 = null;
        APoint2D p2 = null;
        int pts = path.getPointCount();
        boolean intFirst = false;
        boolean intSecond = false;
        int intCounted = 0;
        for (int i = 0; i < pts - 1; ++i) {
            ALine l = new ALine(path.getPoint(i), path.getPoint(i + 1));
            if (intCounted == 0) {
                pre.addPoint(path.getPoint(i));
            } else if (intCounted >= 2) {
                post.addPoint(path.getPoint(i));
            }
            p1 = IFact.intersection(l, first);
            if (p1 != null && !intFirst) {
                if (!APoint2D.isEqualPoint((APoint2D)pre.getLastPoint(), (APoint2D)p1)) {
                    pre.addPoint(p1);
                }
                mid.addPoint(p1);
                ++intCounted;
                intFirst = true;
            }
            if (second != null) {
                p2 = IFact.intersection(l, second);
            }
            if (second != null && p2 != null && !intSecond && (ceilingIntersection != null && p2.equals((Object)ceilingIntersection) || ceilingIntersection == null) && !p2.equals((Object)p1)) {
                if (!APoint2D.isEqualPoint((APoint2D)post.getLastPoint(), (APoint2D)p2)) {
                    post.addPoint(p2);
                }
                mid.addPoint(p2);
                ++intCounted;
                intSecond = true;
            }
            if (intCounted != 1) continue;
            mid.addPoint(path.getPoint(i + 1));
        }
        if (intCounted != intersections) {
            ALog.logInfo((String)"Problem");
        }
        if (intersections == 1) {
            mid.addPoint(path.getPoint(pts - 1));
            aps.setPre(pre);
            aps.setMid(mid);
            aps.setPost(null);
        } else if (intersections == 2) {
            post.addPoint(path.getPoint(pts - 1));
            aps.setPre(pre);
            aps.setMid(mid);
            aps.setPost(post);
        }
        return aps;
    }

    public static PathSection createPathSection(APath path, ALine l1, ALine l2) {
        int i;
        ALine second;
        ALine first;
        PathSection aps = new PathSection();
        APath pre = new APath();
        APath mid = new APath();
        APath post = new APath();
        if (path.intersectsInOrder(l1, l2)) {
            first = new ALine(l1);
            second = new ALine(l2);
        } else {
            first = new ALine(l2);
            second = new ALine(l1);
        }
        ALine ceiling = new ALine(l1.getP1(), l2.getP1());
        ceiling.extendEnds(2L);
        int cIntersectIndexOnPre = 0;
        int cIntersectIndexOnMid = 0;
        APoint2D p1 = null;
        APoint2D p2 = null;
        APoint2D cP = null;
        int pts = path.getPointCount();
        int intersections = 0;
        first.extendEnds(2L);
        second.extendEnds(2L);
        boolean iFirst = false;
        boolean iSecond = false;
        for (i = 0; i < pts - 1; ++i) {
            ALine l = new ALine(path.getPoint(i), path.getPoint(i + 1));
            l.extendEnds(2L);
            if (intersections == 0) {
                pre.addPoint(path.getPoint(i));
            } else if (intersections >= 2) {
                post.addPoint(path.getPoint(i));
            }
            if (l.intersects((AGeom)ceiling)) {
                cP = l.getIntersectLines(ceiling);
                cIntersectIndexOnPre = pre.getPointCount();
                cIntersectIndexOnMid = mid.getPointCount();
            }
            if (l.intersects((AGeom)first) && !iFirst) {
                p1 = l.getIntersectLines(first);
                if (!APoint2D.isEqualPoint((APoint2D)pre.getLastPoint(), (APoint2D)p1)) {
                    pre.addPoint(p1);
                }
                mid.addPoint(p1);
                ++intersections;
                iFirst = true;
            }
            if (l.intersects((AGeom)second) && !iSecond) {
                p2 = l.getIntersectLines(second);
                if (!APoint2D.isEqualPoint((APoint2D)post.getLastPoint(), (APoint2D)p2)) {
                    post.addPoint(p2);
                }
                mid.addPoint(p2);
                ++intersections;
                iSecond = true;
            }
            if (intersections != 1) continue;
            mid.addPoint(path.getPoint(i + 1));
        }
        if (intersections == 1) {
            if (cP == null) {
                aps.setMid(null);
                return aps;
            }
            if (path.intersectsInOrder(first, ceiling)) {
                aps.setPre(pre);
                post.addPoint(cP);
                for (i = cIntersectIndexOnMid; i < mid.getPointCount(); ++i) {
                    post.addPoint(mid.getPoint(i));
                }
                aps.setPost(post);
                APath newMid = new APath();
                newMid.addPoint(mid.getFirstPoint());
                for (int i2 = 0; i2 < cIntersectIndexOnMid; ++i2) {
                    newMid.addPoint(mid.getPoint(i2));
                }
                newMid.addPoint(cP);
                aps.setMid(newMid);
                return aps;
            }
            APath newPre = new APath();
            for (int i3 = 0; i3 < cIntersectIndexOnPre; ++i3) {
                newPre.addPoint(pre.getPoint(i3));
            }
            newPre.addPoint(cP);
            aps.setPre(newPre);
            APath newMid = new APath();
            newMid.addPoint(cP);
            for (int i4 = cIntersectIndexOnPre; i4 < pre.getPointCount(); ++i4) {
                newMid.addPoint(pre.getPoint(i4));
            }
            aps.setMid(newMid);
            aps.setPost(mid);
            return aps;
        }
        if (intersections != 2) {
            aps.setPre(path);
            aps.setMid(null);
            aps.setPost(null);
            return aps;
        }
        post.addPoint(path.getPoint(pts - 1));
        aps.setPre(pre);
        aps.setMid(mid);
        aps.setPost(post);
        return aps;
    }

    protected static enum SectionState {
        Pre,
        Mid,
        Post;

    }

    public static class IFact {
        static long LINEEXTENT = 2L;

        public static ArrayList<APoint2D> intersections(APath p0, APath p1) {
            ArrayList<APoint2D> ints = new ArrayList<APoint2D>();
            for (ALine p0Line : p0.getLines()) {
                p0Line.extendEnds(LINEEXTENT);
                for (ALine p1Line : p1.getLines()) {
                    p1Line.extendEnds(LINEEXTENT);
                    APoint2D pInt = IFact.findIntersection(p0Line, p1Line);
                    if (pInt == null) continue;
                    ints.add(pInt);
                }
            }
            return ints;
        }

        static ArrayList<APoint2D> intersections(APath p, ALine l, Integer max) {
            ArrayList<APoint2D> ints = new ArrayList<APoint2D>();
            ALine line = new ALine(l);
            line.extendEnds(LINEEXTENT);
            for (ALine pathLine : p.getLines()) {
                pathLine.extendEnds(LINEEXTENT);
                APoint2D pInt = IFact.findIntersection(line, pathLine);
                if (pInt == null) continue;
                ints.add(pInt);
                if (max == null || ints.size() < max) continue;
                return ints;
            }
            return ints;
        }

        static boolean intersects(APath p, ALine l) {
            ALine line = new ALine(l);
            line.extendEnds(LINEEXTENT);
            for (ALine pathLine : p.getLines()) {
                pathLine.extendEnds(LINEEXTENT);
                if (IFact.findIntersection(line, pathLine) == null) continue;
                return true;
            }
            return false;
        }

        static APoint2D intersection(ALine l1, ALine l2) {
            ALine line1 = new ALine(l1);
            ALine line2 = new ALine(l2);
            line1.extendEnds(LINEEXTENT);
            line2.extendEnds(LINEEXTENT);
            return IFact.findIntersection(line1, line2);
        }

        public static APoint2D findIntersection(ALine l1, ALine l2) {
            return IFact.findIntersection(l1.getP0(), l1.getP1(), l2.getP0(), l2.getP1());
        }

        public static APoint2D findIntersection(APoint2D p1, APoint2D p2, APoint2D p3, APoint2D p4) {
            double len2;
            double xD1 = p2.getX() - p1.getX();
            double xD2 = p4.getX() - p3.getX();
            double yD1 = p2.getY() - p1.getY();
            double yD2 = p4.getY() - p3.getY();
            double xD3 = p1.getX() - p3.getX();
            double yD3 = p1.getY() - p3.getY();
            double dot = xD1 * xD2 + yD1 * yD2;
            double len1 = Math.sqrt(xD1 * xD1 + yD1 * yD1);
            double deg = dot / (len1 * (len2 = Math.sqrt(xD2 * xD2 + yD2 * yD2)));
            if (Math.abs(deg) == 1.0) {
                return null;
            }
            APoint2D pt = new APoint2D(0L, 0L);
            double div = yD2 * xD1 - xD2 * yD1;
            double ua = (xD2 * yD3 - yD2 * xD3) / div;
            double ub = (xD1 * yD3 - yD1 * xD3) / div;
            pt.setX(Math.round((double)p1.getX() + ua * xD1));
            pt.setY(Math.round((double)p1.getY() + ua * yD1));
            xD1 = pt.getX() - p1.getX();
            xD2 = pt.getX() - p2.getX();
            yD1 = pt.getY() - p1.getY();
            yD2 = pt.getY() - p2.getY();
            double segmentLen1 = Math.sqrt(xD1 * xD1 + yD1 * yD1) + Math.sqrt(xD2 * xD2 + yD2 * yD2);
            xD1 = pt.getX() - p3.getX();
            xD2 = pt.getX() - p4.getX();
            yD1 = pt.getY() - p3.getY();
            yD2 = pt.getY() - p4.getY();
            double segmentLen2 = Math.sqrt(xD1 * xD1 + yD1 * yD1) + Math.sqrt(xD2 * xD2 + yD2 * yD2);
            if (Math.abs(len1 - segmentLen1) > 0.01 || Math.abs(len2 - segmentLen2) > 0.01) {
                return null;
            }
            return pt;
        }
    }

    public static class PathSectionStatus {
        protected PathSection pathSection;
        protected boolean reversed;

        public PathSection getPathSection() {
            return this.pathSection;
        }

        public void setPathSection(PathSection pathSection) {
            this.pathSection = pathSection;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean reversed) {
            this.reversed = reversed;
        }

        public PathSectionStatus(PathSection pathSection, boolean reversed) {
            this.pathSection = pathSection;
            this.reversed = reversed;
        }
    }
}

