/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.router.PathSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class PathUtil {
    public static APath maxSet(APath ref, APath pusher, APoint2D center) {
        int i;
        APath result = new APath();
        ArrayList<ClassifiedPoint> horizon = new ArrayList<ClassifiedPoint>();
        for (int i2 = 0; i2 < pusher.getPointCount(); ++i2) {
            horizon.add(new ClassifiedPoint(pusher.getPoint(i2), PointType.Pusher));
        }
        ArrayList ints = pusher.getIntersectionPoints(ref);
        for (i = 0; i < ints.size(); ++i) {
            horizon.add(new ClassifiedPoint((APoint2D)ints.get(i), PointType.Intersection));
        }
        for (i = 0; i < ref.getPointCount(); ++i) {
            horizon.add(new ClassifiedPoint(ref.getPoint(i), PointType.Pushee));
        }
        Collections.sort(horizon, new PolarSort(center, pusher));
        for (ClassifiedPoint horizonPt : horizon) {
            ALine v2;
            ALine v = new ALine(center, horizonPt.p);
            v.extendEnds(2L);
            if (horizonPt.type == PointType.Intersection) {
                result.addPoint(horizonPt.p);
                continue;
            }
            if (horizonPt.type == PointType.Pusher) {
                APoint2D pOfPushee;
                if (!v.intersects((AGeom)ref) || center.distance(pOfPushee = ref.getIntersectionPoint(v)) >= center.distance(horizonPt.p)) continue;
                result.addPoint(horizonPt.p);
                continue;
            }
            long maxRadius = center.distance(pusher.getFirstPoint()) * 2L;
            ALine v3 = center.makeVector(maxRadius, (v2 = new ALine(center, horizonPt.p)).getAngle());
            APoint2D pointOnPusher = pusher.getIntersectionPoint(v3);
            if (pointOnPusher != null) {
                if (center.distance(pointOnPusher) > center.distance(horizonPt.p)) {
                    result.addPoint(pointOnPusher);
                    continue;
                }
                result.addPoint(horizonPt.p);
                continue;
            }
            result.addPoint(horizonPt.p);
        }
        if (result.getPointCount() > 0 && result.getFirstPoint().distance(ref.getFirstPoint()) > result.getLastPoint().distance(ref.getFirstPoint())) {
            result.reverse();
        }
        return result;
    }

    public static APath maxSet1(APath ref, APath pusher, APoint2D center) {
        State state = State.Unknown;
        APath result = ref.copy();
        for (APoint2D pOnPusher : pusher.getPoints()) {
            ALine v = new ALine(center, pOnPusher);
            v.extendEnds(2L);
            if (v.intersects((AGeom)ref)) {
                int index = ref.getIntersectionIndex(v);
                APoint2D p = ref.getIntersectionPoint(v);
                result.insertPoint(index, p);
                state = State.Pusher;
                continue;
            }
            state = State.Pushee;
        }
        if (result.getPointCount() > 0 && result.getFirstPoint().distance(ref.getFirstPoint()) > result.getLastPoint().distance(ref.getFirstPoint())) {
            result.reverse();
        }
        return result;
    }

    public static APath moveAbove(APath ref, APath below) {
        int i;
        ArrayList<Long> xs = new ArrayList<Long>();
        APath original = ref.copy();
        boolean reversed = false;
        if (original.getFirstPoint().getX() > original.getLastPoint().getX()) {
            original.reverse();
            reversed = true;
        }
        APath result = new APath(ref.getWidth());
        for (int i2 = 0; i2 < below.getPointCount(); ++i2) {
            long x = below.getPoint(i2).getX();
            if (xs.contains(x)) continue;
            xs.add(x);
        }
        ArrayList<APoint2D> ints = PathSection.IFact.intersections(below, original);
        for (i = 0; i < ints.size(); ++i) {
            long x = ints.get(i).getX();
            if (xs.contains(x)) continue;
            xs.add(x);
        }
        for (i = 0; i < original.getPointCount(); ++i) {
            APoint2D aPoint = original.getPoint(i);
            if (xs.contains(aPoint.getX())) continue;
            xs.add(aPoint.getX());
        }
        Collections.sort(xs);
        for (Long x : xs) {
            Long yOfOriginal = original.getMinYAt(x.longValue());
            Long yOfBelow = below.getMaxYAt(x.longValue());
            if (yOfOriginal == null) continue;
            if (yOfBelow == null) {
                result.addPoint(new APoint2D(x.longValue(), yOfOriginal.longValue()));
                continue;
            }
            if (yOfBelow > yOfOriginal) {
                result.addPoint(new APoint2D(x.longValue(), yOfBelow.longValue()));
                continue;
            }
            result.addPoint(new APoint2D(x.longValue(), yOfOriginal.longValue()));
        }
        if (reversed) {
            result.reverse();
        }
        return result;
    }

    public static APath maxY(APath ref, APath below) {
        long x;
        int i;
        APath original = ref.copy();
        boolean reverse = false;
        if (original.getFirstPoint().getX() > original.getLastPoint().getX()) {
            original.reverse();
            reverse = true;
        }
        ArrayList<Long> xs = new ArrayList<Long>();
        for (int i2 = 0; i2 < below.getPointCount(); ++i2) {
            long x2 = below.getPoint(i2).getX();
            if (xs.contains(x2)) continue;
            xs.add(x2);
        }
        ArrayList ints = below.getIntersectionPoints(ref);
        for (i = 0; i < ints.size(); ++i) {
            x = ((APoint2D)ints.get(i)).getX();
            if (xs.contains(x)) continue;
            xs.add(x);
        }
        for (i = 0; i < ref.getPointCount(); ++i) {
            x = ref.getPoint(i).getX();
            if (xs.contains(x)) continue;
            xs.add(x);
        }
        Collections.sort(xs);
        APath result = new APath(ref.getWidth());
        boolean madeAChange = false;
        Iterator iterator = xs.iterator();
        while (iterator.hasNext()) {
            long x3 = (Long)iterator.next();
            Long yOriginal = original.getMaxYAt(x3);
            if (yOriginal == null) continue;
            Long yOfBelow = below.getMaxYAt(x3);
            if (yOfBelow == null) {
                result.addPoint(new APoint2D(x3, yOriginal.longValue()));
                continue;
            }
            if (yOfBelow > yOriginal) {
                madeAChange = true;
                result.addPoint(new APoint2D(x3, yOfBelow.longValue()));
                continue;
            }
            for (APoint2D p : original.getPoints()) {
                if (p.getX() != x3 || p.getY() < yOfBelow) continue;
                boolean atIntersection = false;
                for (APoint2D xTest : ints) {
                    if (xTest.getX() != x3) continue;
                    atIntersection = true;
                    break;
                }
                if (atIntersection) {
                    result.addPoint(x3, below.getMaxYAt(x3).longValue());
                }
                result.addPoint(new APoint2D(p));
            }
        }
        if (!madeAChange) {
            if (reverse) {
                original.reverse();
            }
            return original;
        }
        if (reverse) {
            result.reverse();
        }
        return result;
    }

    public static void oneBend(APath p) {
        APoint2D p0 = p.getPoint(1);
        APoint2D p1 = p.getPoint(0);
        long dx = p1.xDistance(p0);
        long dy = p1.yDistance(p0);
        if (dx == 0L || dy == 0L) {
            return;
        }
        APoint2D p01 = p0.add(new APoint2D(0L, dy));
        p.insertPoint(1, p01);
    }

    public static void dogLeg(APath p, int index0, int index1) {
        APoint2D p02;
        APoint2D p01;
        APoint2D p0 = p.getPoint(index0);
        APoint2D p1 = p.getPoint(index1);
        long dx = p1.xDistance(p0);
        long dy = p1.yDistance(p0);
        if (dx == 0L || dy == 0L) {
            return;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            p01 = p0.add(new APoint2D(dx / 2L, 0L));
            p02 = p01.add(new APoint2D(0L, dy));
        } else {
            p01 = p0.add(new APoint2D(0L, dy / 2L));
            p02 = p01.add(new APoint2D(dx, 0L));
        }
        p.insertPoint(index0 + 1, p01);
        p.insertPoint(index0 + 2, p02);
    }

    public static class PolarSort
    implements Comparator<ClassifiedPoint> {
        APoint2D c;
        double startAngle;

        PolarSort(APoint2D c, APath p) {
            this.c = c;
            ALine l = new ALine(c, p.getFirstPoint());
            double s = l.getAngle();
            l = new ALine(c, p.getLastPoint());
            double e = l.getAngle();
            this.startAngle = Math.min(e, s);
            this.startAngle = s;
        }

        @Override
        public int compare(ClassifiedPoint o1, ClassifiedPoint o2) {
            ALine l1 = new ALine(this.c, o1.p);
            ALine l2 = new ALine(this.c, o2.p);
            Double a1 = l1.getAngle();
            o1.angle = l1.getAngle();
            if (Math.abs(a1 = Double.valueOf(a1 - this.startAngle)) > 180.0) {
                a1 = a1 < 0.0 ? Double.valueOf(a1 + 360.0) : Double.valueOf(360.0 - a1);
            }
            Double a2 = l2.getAngle();
            o2.angle = l2.getAngle();
            if (Math.abs(a2 = Double.valueOf(a2 - this.startAngle)) > 180.0) {
                a2 = a2 < 0.0 ? Double.valueOf(a2 + 360.0) : Double.valueOf(360.0 - a2);
            }
            if (a1 < a2) {
                return -1;
            }
            if (a1 > a2) {
                return 1;
            }
            Long d1 = l1.getLength();
            Long d2 = l2.getLength();
            return d1.compareTo(d2);
        }
    }

    protected static class ClassifiedPoint {
        APoint2D p;
        PointType type;
        double angle;

        public ClassifiedPoint(APoint2D p, PointType t) {
            this.p = new APoint2D(p);
            this.type = t;
        }
    }

    protected static enum PointType {
        Pusher,
        Intersection,
        Pushee;

    }

    protected static enum State {
        Pusher,
        Pushee,
        Unknown;

    }
}

