/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitIO;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;

public class PrettyBundle {
    public static void doAll() {
        PrettyBundle pb = new PrettyBundle();
        pb.beutifyAll(OrbitIO.getCurDb(), "", false);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    protected void beutifyAll(Db db, String algo, boolean justSelected) {
        LinkedList<Bundle> bundlesInvolved = this.deriveBundles(db, justSelected);
        LinkedList<DeviceTemplate> templatesInvolved = this.deriveTemplatesInvolved(bundlesInvolved);
        Collections.sort(bundlesInvolved, new ShortToLongSorter());
        for (DeviceTemplate template : templatesInvolved) {
            this.doTemplate(template, bundlesInvolved);
        }
    }

    private void doTemplate(DeviceTemplate template, LinkedList<Bundle> bundles) {
        HashSet<Obstacle> obstacleCosts = this.deriveCosts(template);
        for (Bundle b : bundles) {
            if (b.getTemplate() != template) continue;
            this.doBundle(b, obstacleCosts);
        }
    }

    private void do90(Bundle b, HashSet<Obstacle> obstacleCosts) {
        if (b.getName().equals("bundle.28")) {
            ALog.logInfo((String)"");
        }
        LinkedList<APoint2D> pts = new LinkedList<APoint2D>();
        APath p = b.getPath().copy();
        for (int idx = 0; idx < p.getPointCount() - 1; ++idx) {
            APoint2D p0 = p.getPoint(idx);
            APoint2D p1 = p.getPoint(idx + 1);
            if (p0.getX() != p1.getX() || p0.getY() != p1.getY()) {
                long dy;
                APoint2D pn1 = new APoint2D(p0.getX(), p1.getY());
                APoint2D pn2 = new APoint2D(p1.getX(), p0.getY());
                if (idx == 0) {
                    long dx = p1.getX() - p0.getX();
                    dy = p1.getY() - p0.getY();
                    pts.add(p0);
                    if (Math.abs(dx) > Math.abs(dy)) {
                        pts.add(pn2);
                        continue;
                    }
                    pts.add(pn1);
                    continue;
                }
                if (idx == p.getPointCount() - 2) {
                    long dx = p1.getX() - p0.getX();
                    dy = p1.getY() - p0.getY();
                    pts.add(p0);
                    if (Math.abs(dx) > Math.abs(dy)) {
                        pts.add(pn1);
                        continue;
                    }
                    pts.add(pn2);
                    continue;
                }
                APoint2D cheaper = this.costPoint(pn1, pn2, obstacleCosts);
                pts.add(p0);
                pts.add(cheaper);
                continue;
            }
            pts.add(p0);
        }
        pts.add(p.getLastPoint());
        p.removeAllPoints();
        p.addPoints(pts);
        p = p.cleanPath();
        b.setPath(p);
        this.updateCosts(b, obstacleCosts);
    }

    private void doBundle(Bundle b, HashSet<Obstacle> obstacleCosts) {
        this.do90(b, obstacleCosts);
        this.removeHSteps(b, obstacleCosts);
    }

    private boolean removeHSteps(Bundle b, HashSet<Obstacle> obstacleCosts) {
        if (b.getName().equals("bundle.5")) {
            ALog.logInfo((String)"");
        }
        APath newPath = b.getPath().copy();
        for (int idx = 1; idx < newPath.getPointCount() - 3; ++idx) {
            double cn;
            double c1;
            APoint2D pn;
            APoint2D p0 = newPath.getPoint(idx);
            APoint2D p1 = newPath.getPoint(idx + 1);
            APoint2D p2 = newPath.getPoint(idx + 2);
            if (p0.getX() == p1.getX()) {
                pn = new APoint2D(p2.getX(), p0.getY());
                c1 = this.getCost(b, p1, obstacleCosts);
                cn = this.getCost(b, pn, obstacleCosts);
                if (!(cn <= c1)) continue;
                newPath.removePoint(idx);
                newPath.setPoint(idx, pn);
                newPath = newPath.cleanPath();
                b.setPath(newPath);
                return true;
            }
            if (p0.getY() != p1.getY()) continue;
            pn = new APoint2D(p0.getX(), p2.getY());
            c1 = this.getCost(b, p1, obstacleCosts);
            cn = this.getCost(b, pn, obstacleCosts);
            ALine l = new ALine(p0, new APoint2D(pn.getX(), p2.getY()));
            double c = this.costOfLine(l, obstacleCosts);
            if (!(c < 1.0) || !(cn <= c1)) continue;
            newPath.removePoint(idx);
            newPath.setPoint(idx, pn);
            newPath = newPath.cleanPath();
            b.setPath(newPath);
            return true;
        }
        return false;
    }

    private double costOfLine(ALine l, HashSet<Obstacle> obstacleCosts) {
        double c = 0.0;
        for (Obstacle o : obstacleCosts) {
            ARect r = o.r;
            if (!(o.o instanceof Device) || !l.intersects((AGeom)r)) continue;
            return 1.0;
        }
        return c;
    }

    private double getCost(Bundle b, APoint2D p, HashSet<Obstacle> obstacleCosts) {
        double c = 0.0;
        for (Obstacle o : obstacleCosts) {
            if (o.o == b) continue;
            if (o.r.contains(p)) {
                c += o.c;
            }
            if (!o.r.contains(p)) continue;
            c += o.c;
        }
        return c;
    }

    private void updateCosts(Bundle b, HashSet<Obstacle> obstacleCosts) {
        APath p = b.getPath();
        long hw = p.getWidth() / 2L;
        for (int idx = 0; idx < p.getPointCount() - 1; ++idx) {
            APoint2D p0 = p.getPoint(idx);
            APoint2D p1 = p.getPoint(idx + 1);
            ARect r = null;
            r = p0.getX() == p1.getX() ? new ARect(p0.getX() - hw, p0.getY(), p1.getX() + hw, p1.getY()) : new ARect(p0.getX(), p0.getY() - hw, p1.getX(), p1.getY() + hw);
            Obstacle o = new Obstacle(r, (DbObject)b, 0.2);
            obstacleCosts.add(o);
        }
    }

    private APoint2D costPoint(APoint2D pn1, APoint2D pn2, HashSet<Obstacle> obstacleCosts) {
        double c1 = 0.0;
        double c2 = 0.0;
        for (Obstacle o : obstacleCosts) {
            if (o.r.contains(pn1)) {
                c1 += o.c;
            }
            if (!o.r.contains(pn2)) continue;
            c2 += o.c;
        }
        if (c1 < c2) {
            return pn1;
        }
        return pn2;
    }

    private HashSet<Obstacle> deriveCosts(DeviceTemplate template) {
        Obstacle o;
        ARect r;
        HashSet<Obstacle> obstacleCosts = new HashSet<Obstacle>();
        for (Device d : template.getChildren()) {
            r = d.getBB();
            o = new Obstacle(r, (DbObject)d, 1.0);
            obstacleCosts.add(o);
        }
        for (PinTemplate pt : template.getPins()) {
            r = pt.getBounds();
            o = new Obstacle(r, (DbObject)pt, 0.01);
            obstacleCosts.add(o);
        }
        return obstacleCosts;
    }

    private LinkedList<Bundle> deriveBundles(Db db, boolean justSelected) {
        LinkedList<Bundle> bundlesInvolved = new LinkedList<Bundle>();
        if (justSelected) {
            Selection s = Selection.getCurrentSelectionForDb((Db)db);
            for (Bundle bundle : s.get(Bundle.class)) {
                bundlesInvolved.add(bundle);
            }
        } else {
            for (Bundle bundle : db.getObjects(Bundle.class)) {
                bundlesInvolved.add(bundle);
            }
        }
        return bundlesInvolved;
    }

    private LinkedList<DeviceTemplate> deriveTemplatesInvolved(LinkedList<Bundle> bundles) {
        LinkedList<DeviceTemplate> templatesInvolved = new LinkedList<DeviceTemplate>();
        for (Bundle bundle : bundles) {
            DeviceTemplate dt = bundle.getTemplate();
            if (templatesInvolved.contains(dt)) continue;
            templatesInvolved.add(dt);
        }
        return templatesInvolved;
    }

    public static class ShortToLongSorter
    implements Comparator<Bundle> {
        @Override
        public int compare(Bundle b0, Bundle b1) {
            return Long.compare(b0.getPath().getLength(), b1.getPath().getLength());
        }
    }

    static class Obstacle {
        protected ARect r;
        protected DbObject o;
        protected double c;

        public Obstacle(ARect r, DbObject o, double c) {
            this.r = r;
            this.o = o;
            this.c = c;
        }
    }
}

