/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AHashArray;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.AVector;
import com.sigrity.acl.topology.fUniverse.AForce;
import com.sigrity.acl.topology.fUniverse.AForceOverlay;
import com.sigrity.acl.topology.fUniverse.AForceUniverseDrawer;
import com.sigrity.acl.topology.fUniverse.AForceUpdateListener;
import com.sigrity.acl.topology.fUniverse.AParticlePoint;
import com.sigrity.acl.topology.fUniverse.ClearanceSpring;
import com.sigrity.acl.topology.fUniverse.ForceUniverse;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.DebugOverlay;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.automation.router.WireMap;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PrettyRouter
extends SingleLayerRouter {
    Constraint.RouteAngle angle;
    Constraint.FinishingFunction finishingFunction;
    RouteType routeType;
    boolean doneOnce = false;
    protected static PrettyRouter mCurrentPrettyRouter = null;
    HashSet<Wire> activeWires = new HashSet();
    HashMap<Wire, SingleLayerRouter.RouteInformation> mWireToRouteInformation = new HashMap();
    HashMap<Wire, FloodableNode> mWireToFn = new HashMap();
    HashMap<Wire, FloodableNode> mWiretoLastFn = new HashMap();
    HashMap<Topstacle, Wire> mTopToWire = new HashMap();
    AHashArray<Wire, FloodableNode> mWireToOrderedNodes = new AHashArray();
    protected HistoryListener mHL = null;
    protected final long diffPairGap = Design.micronToInternal((Db)this.mDb, (double)20.0);
    protected int numInternalErrors = 0;
    public static final String FLDNAME_CREATOR = "PrettyrRouter.Creator";
    protected RouteType mRouteType = RouteType.UNKNOWN;
    int dbgCount = 0;
    HashMap<APath, String> pathToOwner = new HashMap();
    protected static HashMap<Key, PrettyRouter> mRouters = new HashMap();

    public HashMap<Wire, FloodableNode> getmWiretoLastFn() {
        return this.mWiretoLastFn;
    }

    public void setmWiretoLastFn(HashMap<Wire, FloodableNode> mWiretoLastFn) {
        this.mWiretoLastFn = mWiretoLastFn;
    }

    public Constraint.RouteAngle getAngle() {
        return this.angle;
    }

    public void setAngle(Constraint.RouteAngle angle) {
        this.angle = angle;
    }

    public Constraint.FinishingFunction getFinishingFunction() {
        return this.finishingFunction;
    }

    public void setFinishingFunction(Constraint.FinishingFunction finishingFunction) {
        this.finishingFunction = finishingFunction;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public void setRouteType(RouteType routeType) {
        this.routeType = routeType;
    }

    public String getCreator(APath path) {
        String ret = this.pathToOwner.get(path);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public void setCreator(APath path, String owner) {
        this.pathToOwner.remove(path);
        this.pathToOwner.put(path, owner);
    }

    public void addCreator(APath path, String owner) {
        String newOwner = this.getCreator(path) + "." + owner;
        this.setCreator(path, newOwner);
    }

    public static void clearAllPrettyRouters() {
        mRouters.clear();
    }

    public static PrettyRouter getPrettyRouter(DeviceTemplate dt, Layer layer, boolean create) {
        Key key = new Key(dt, layer);
        PrettyRouter r = mRouters.get((Object)key);
        if (r == null && create) {
            r = new PrettyRouter();
            mRouters.put(key, r);
        }
        return r;
    }

    public static void releasePrettyRouter(PrettyRouter router) {
        Key key = new Key(router.getParent().getDeviceTemplate(), router.getLayer());
        mRouters.remove((Object)key);
        mCurrentPrettyRouter = null;
    }

    protected void createDelaunayRegion(FloodableNode fnA, FloodableNode fnB, FloodableNode fnC) {
        DelaunayRegion dr = new DelaunayRegion(fnA, fnB, fnC);
        dr.order();
        if (!this.regions.contains(dr)) {
            this.regions.add(dr);
        }
    }

    private PrettyRouter() {
        mCurrentPrettyRouter = this;
        if (this.mHL != null) {
            return;
        }
        DbHistory h = OrbitIO.getCurDb().getHistory();
        this.mHL = new HistoryListener();
        h.addListener((DbHistory.Listener)this.mHL);
    }

    public int getAttempts() {
        return this.mRouteInfo.size();
    }

    public int getCompletedCount() {
        int count = 0;
        for (SingleLayerRouter.RouteInformation ri : this.mRouteInfo) {
            if (!ri.getSucess()) continue;
            ++count;
        }
        return count;
    }

    protected void skinny() {
        for (SingleLayerRouter.RouteInformation ri : this.mRouteInfo) {
            Wire w = ri.getWire();
            if (w == null) continue;
            Db db = w.getDb();
            long curWidth = w.getWidth();
            if (curWidth <= ri.getWidth() + Design.micronToInternal((Db)db, (double)1.0)) continue;
            w.getPath().setWidth(curWidth - Design.micronToInternal((Db)db, (double)1.0));
        }
    }

    protected void fatten() {
        boolean didOne = true;
        while (didOne) {
            didOne = false;
            for (SingleLayerRouter.RouteInformation ri : this.mRouteInfo) {
                long maxWidth;
                long curWidth;
                Wire w = ri.getWire();
                if (w == null) continue;
                if (w.getNet().getName().equals("NET_261")) {
                    // empty if block
                }
                if ((curWidth = w.getWidth()) >= (maxWidth = ri.getMaxWidth())) continue;
                Long minSlack = null;
                for (FloodableNode fn : this.mWireToOrderedNodes.getCollection((Object)w)) {
                    long slack = fn.getLength();
                    SingleLayerRouter.RouteInformation lastRi = null;
                    for (Wire wireInFn : fn.getWires()) {
                        SingleLayerRouter.RouteInformation wireRi = this.getRI(wireInFn);
                        slack -= wireInFn.getWidth();
                        slack -= wireRi.getClear();
                        lastRi = wireRi;
                    }
                    slack -= lastRi.getClear();
                    if (minSlack == null) {
                        minSlack = slack;
                        continue;
                    }
                    minSlack = Math.min(minSlack, slack);
                }
                if (minSlack == null || minSlack <= 100L) continue;
                w.getPath().setWidth(w.getWidth() + 100L);
                didOne = true;
            }
        }
    }

    public void deriveUsedNodes() {
        for (FloodableNode fn : this.mFloodableNodes) {
            if (fn.mNumLoads > 0) {
                this.usedNodes.add(fn);
                continue;
            }
            if (fn.mStartBlocked) {
                this.usedNodes.add(fn);
                continue;
            }
            if (!fn.mEndBlocked) continue;
            this.usedNodes.add(fn);
        }
    }

    public void deriveDelaunayRegions() {
        for (FloodableNode fn : this.usedNodes) {
            if (!fn.isChannel) continue;
            Topstacle t1 = (Topstacle)fn.mChannel.getP1();
            Topstacle t2 = (Topstacle)fn.mChannel.getP2();
            this.deriveAllDelaunayRegionsUsing(t1);
            this.deriveAllDelaunayRegionsUsing(t2);
        }
    }

    public void deriveAllDelaunayRegionsUsing(Topstacle t) {
        ArrayList<SingleLayerRouter.Channel> rList = this.createRadialChannels(t);
        int size = rList.size();
        for (int i = 0; i < size - 1; ++i) {
            SingleLayerRouter.Channel cB;
            FloodableNode fnB;
            SingleLayerRouter.Channel cA = rList.get(i);
            FloodableNode fnA = (FloodableNode)this.mChannelToFloodNode.get((Object)cA);
            FloodableNode fnC = this.getThirdLeg(fnA, fnB = (FloodableNode)this.mChannelToFloodNode.get((Object)(cB = rList.get(i + 1))));
            if (fnC == null) continue;
            this.createDelaunayRegion(fnA, fnB, fnC);
        }
    }

    protected boolean sameRegion(ArrayList<FloodableNode> seq) {
        for (DelaunayRegion r : this.regions) {
            if (!r.containsAll(seq)) continue;
            return true;
        }
        return false;
    }

    protected void removeSameRegionWireSegments() {
        for (int i = 0; i < this.usedNodes.size(); ++i) {
            FloodableNode fn = (FloodableNode)this.usedNodes.get(i);
            ArrayList<WireMap> wm = fn.wireMaps;
            ArrayList<WireMap> toBeRemoved = new ArrayList<WireMap>();
            for (WireMap wmi : wm) {
                FloodableNode prev = wmi.prev;
                FloodableNode next = wmi.next;
                if (prev == null || next == null) continue;
                ArrayList<FloodableNode> seq = new ArrayList<FloodableNode>();
                seq.add(prev);
                seq.add(fn);
                seq.add(next);
                if (!this.sameRegion(seq)) continue;
                this.removeWirePt(wmi.wire, fn);
                toBeRemoved.add(wmi);
            }
            for (WireMap wmi : toBeRemoved) {
                wm.remove(wmi);
            }
        }
    }

    protected void fixupIOPadEnd() {
        for (SingleLayerRouter.RouteInformation ri : this.mRouteInfo) {
            FloodableNode start;
            Wire wire = ri.getWire();
            if (wire == null || (start = this.mWiretoLastFn.get(wire)) == null) continue;
            int index1 = start.getWireIndex(wire);
            WireMap wm1 = start.wireMaps.get(index1);
            FloodableNode firstChannel = wm1.prev;
            int index2 = firstChannel.getWireIndex(wire);
            WireMap wm2 = firstChannel.wireMaps.get(index2);
            FloodableNode secondChannel = wm2.prev;
            if (firstChannel == null || secondChannel == null || !firstChannel.isChannel || !secondChannel.isChannel || this.anchor(firstChannel, secondChannel) == null) continue;
            --firstChannel.mNumLoads;
            this.removeWirePt(wire, firstChannel);
        }
    }

    protected boolean validateChannelPoints() {
        for (int i = 0; i < this.usedNodes.size(); ++i) {
            FloodableNode fn = (FloodableNode)this.usedNodes.get(i);
            for (int j = 0; j < fn.wireMaps.size(); ++j) {
                boolean foundP = false;
                Wire w = fn.wireMaps.get((int)j).wire;
                APoint2D p = fn.wireMaps.get((int)j).point;
                APath path = w.getPath();
                for (int k = 0; k < path.getPointCount(); ++k) {
                    if (!path.getPoint(k).equals((Object)p)) continue;
                    foundP = true;
                    break;
                }
                if (foundP) continue;
                ALog.logWarn((String)("Validate can not find point in wire " + w.getNet().getName()));
                return false;
            }
        }
        return true;
    }

    protected void findChannelLocForShortestRoute() {
        PrettyRouter.updateProgress(true, 0.0, "Making traces straighter");
        for (int i = 0; i < this.usedNodes.size(); ++i) {
            this.pullWiresToGravity((FloodableNode)this.usedNodes.get(i), false);
        }
        for (int pass = 0; pass < 100; ++pass) {
            int i;
            for (i = 0; i < this.usedNodes.size(); ++i) {
                this.pullWiresToGravity((FloodableNode)this.usedNodes.get(i), true);
            }
            for (i = this.usedNodes.size() - 1; i >= 0; --i) {
                this.pullWiresToGravity((FloodableNode)this.usedNodes.get(i), true);
            }
        }
    }

    public void detailRoute() {
        if (this.mRouteInfo.size() == 0) {
            return;
        }
        PrettyRouter.updateProgress(true, 1.0, "Making traces pretty");
        this.buildWireToRIHash();
        this.deriveUsedNodes();
        this.buildWireToFirstFnHash();
        this.deriveDelaunayRegions();
        this.removeSameRegionWireSegments();
        this.fixupIOPadEnd();
        this.buildWireToOrderedFNs();
        this.buildWireTerminations();
        Constraint.FinishingFunction ff = this.getFinnishingFunction();
        if (ff.equals((Object)Constraint.FinishingFunction.Fatten)) {
            PrettyRouter.updateProgress(true, 1.0, "Making traces wider");
            this.fatten();
        }
        this.findChannelLocForShortestRoute();
        int total = 0;
        int totalBad = 0;
        for (SingleLayerRouter.RouteInformation ri : this.mRouteInfo) {
            ++total;
            if (ri.getSucess()) continue;
            ++totalBad;
        }
        String msg = null;
        msg = totalBad == 0 ? "All " + total + " routes completed!" : totalBad + " of " + total + " could not be routed";
        PrettyRouter.updateProgress(true, 1.0, msg);
    }

    public static int simpleDRC(String templateKeyStr, String layerName) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr);
        Substrate s = dt.getSubstrate();
        Layer l = s.getLayer(layerName);
        ArrayList<Wire> list = new ArrayList<Wire>();
        for (Wire w : db.getObjects(Wire.class)) {
            if (w.getDeviceTemplate() != dt || w.getLayer() != l) continue;
            list.add(w);
        }
        int viol = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Wire wi = (Wire)list.get(i);
            ARect ri = wi.getBB();
            APath pI = wi.getPath();
            for (int j = i + 1; j < list.size(); ++j) {
                Wire wj = (Wire)list.get(j);
                if (wj.getNet() == wi.getNet()) continue;
                ARect rj = wj.getBB();
                APath pJ = wj.getPath();
                if (!ri.intersects(rj) || !pI.centersCrossIntersect(pJ)) continue;
                ++viol;
            }
        }
        return viol;
    }

    protected long getWidthOfWireAtChannel(int jthWire, FloodableNode fn) {
        double diffAngle;
        Wire w = fn.wireMaps.get((int)jthWire).wire;
        APath path = w.getPath();
        APoint2D p = fn.wireMaps.get((int)jthWire).point;
        List pts = path.getIndicesOf(p);
        int index0 = (Integer)pts.get(0);
        int index1 = index0 - 1;
        if (index0 == 0) {
            index1 = 1;
        }
        ALine lineOfPath = new ALine(path.getPoint(index0), path.getPoint(index1));
        double angleOfPath = lineOfPath.getAngle();
        double angleOfChannel = fn.span.getAngle() - 90.0;
        if (angleOfPath >= 180.0) {
            angleOfPath -= 180.0;
        }
        if (angleOfChannel >= 180.0) {
            angleOfChannel -= 180.0;
        }
        if ((diffAngle = angleOfChannel - angleOfPath) < 0.0) {
            diffAngle = -diffAngle;
        }
        if (Math.abs(diffAngle - 90.0) < 1.0) {
            return w.getWidth() / 2L;
        }
        return Math.round((double)w.getWidth() / 2.0 / Math.cos(Math.toRadians(diffAngle)));
    }

    protected void spreadInChannels() {
        for (int i = 0; i < this.usedNodes.size(); ++i) {
            FloodableNode fn = (FloodableNode)this.usedNodes.get(i);
            ALine span = fn.span;
            if (span == null) continue;
            long extra = fn.getLength();
            long extraPer = extra / (long)(fn.wireMaps.size() + 1);
            for (int jth = 0; jth < fn.wireMaps.size(); ++jth) {
                if (jth == 0 && fn.mStartBlocked) continue;
                Wire w = fn.wireMaps.get((int)jth).wire;
                APoint2D p = fn.wireMaps.get((int)jth).point;
                APath path = w.getPath();
                List pts = path.getIndicesOf(p);
                if (pts.size() > 0) {
                    p = span.fromP1(extraPer * (long)(jth + 1));
                    this.setWirePt(fn, jth, p);
                    continue;
                }
                ALog.logWarn((String)"Problem with route");
            }
        }
    }

    protected int DRCMe() {
        ALog.logInfo((String)"start drc");
        ArrayList<Wire> list = new ArrayList<Wire>();
        for (Wire w : this.mWiretoLastFn.keySet()) {
            list.add(w);
        }
        int viol = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Wire wi = (Wire)list.get(i);
            ARect ri = wi.getBB();
            SingleLayerRouter.RouteInformation rI = this.getRI(wi);
            rI.drcOk = true;
            for (int j = i + 1; j < list.size(); ++j) {
                long dist;
                Wire wj = (Wire)list.get(j);
                ARect rj = wj.getBB();
                SingleLayerRouter.RouteInformation rJ = this.getRI(wj);
                rJ.drcOk = true;
                if (!ri.intersects(rj) || wj.getNet().equals(wi.getNet()) || (dist = this.wireToWireDist(wi, wj)) + 1L >= Math.max(rI.getClear(), rJ.getClear())) continue;
                ++viol;
                rI.drcOk = false;
                rJ.drcOk = false;
            }
        }
        for (FloodableNode fn : this.usedNodes) {
            if (!fn.isChannel) continue;
        }
        ALog.logInfo((String)("end drc " + viol));
        return viol;
    }

    protected long wireToWireDist(Wire wI, Wire wJ) {
        Long minDist = null;
        for (ALine lI : wI.getPath().getLines()) {
            for (ALine lJ : wJ.getPath().getLines()) {
                long dist = Math.abs(lI.distance(lJ));
                if (minDist == null) {
                    minDist = dist;
                    continue;
                }
                minDist = Math.min(dist, minDist);
            }
        }
        return minDist - (wI.getWidth() / 2L + wJ.getWidth() / 2L);
    }

    protected void make45sSimple() {
        for (Wire w : this.mWiretoLastFn.keySet()) {
            APath p = w.getPath();
            for (int i = 0; i < p.getPointCount() - 1; ++i) {
                APoint2D p0;
                ALine l = new ALine(p.getPoint(i), p.getPoint(i + 1));
                if (l.isHorizontal() || l.isVertical()) continue;
                long dx = l.dX();
                long dy = l.dY();
                if (Math.abs(dx) == Math.abs(dy)) continue;
                if (Math.abs(dx) > Math.abs(dy)) {
                    long ddx = Math.abs(dx) - Math.abs(dy);
                    if (dx < 0L) {
                        ddx = -ddx;
                    }
                    p0 = new APoint2D(ddx, 0L);
                    p.insertPoint(i + 1, p.getPoint(i).add(p0));
                    continue;
                }
                long ddy = Math.abs(dy) - Math.abs(dx);
                if (dy < 0L) {
                    ddy = -ddy;
                }
                p0 = new APoint2D(0L, ddy);
                p.insertPoint(i + 1, p.getPoint(i).add(p0));
            }
            p = p.cleanPath();
            w.setPath(p);
        }
    }

    protected Constraint.FinishingFunction getFinnishingFunction() {
        if (((SingleLayerRouter.RouteInformation)this.mRouteInfo.get(0)).getConn() instanceof SchedConn) {
            Constraint fc;
            SchedConn sc = (SchedConn)((SingleLayerRouter.RouteInformation)this.mRouteInfo.get(0)).getConn();
            if (sc.getOwner() instanceof DeviceTemplate) {
                return Constraint.FinishingFunction.Default;
            }
            Personality p = (Personality)sc.getOwner();
            if (p != null && (fc = Constraint.getConstraint((Db)this.mDb, (DbObject)p, (Constraint.Descriptor)Constraint.FINISHING_FUNCTION)) != null) {
                return (Constraint.FinishingFunction)fc.getValue();
            }
        }
        return Constraint.FinishingFunction.Default;
    }

    protected Constraint.FinishingFunction getFinnishingFunction(Wire w) {
        Net n = w.getNet();
        for (PinInstance candidate : NetMap.getConnectedPorts((Net)n, (DevicePath)this.mParent)) {
            Constraint fc;
            Personality p = candidate.getRouteGroup();
            if (p == null || (fc = Constraint.getConstraint((Db)this.mDb, (DbObject)p, (Constraint.Descriptor)Constraint.FINISHING_FUNCTION)) == null) continue;
            return (Constraint.FinishingFunction)fc.getValue();
        }
        return Constraint.FinishingFunction.Default;
    }

    protected void makeSimple() {
        for (Wire w : this.mWiretoLastFn.keySet()) {
            APath p = w.getPath();
            for (int i = 0; i < p.getPointCount() - 1; ++i) {
                ALine l = new ALine(p.getPoint(i), p.getPoint(i + 1));
                if (l.isHorizontal() || l.isVertical()) continue;
                this.dogLeg(w, i, i + 1);
            }
        }
    }

    protected void rdlEnds() {
        for (Wire w : this.mWiretoLastFn.keySet()) {
            long width = w.getWidth();
            APath p = w.getPath();
            if ((p = p.cleanPath()).getPointCount() < 3 || this.getAngle() != Constraint.RouteAngle.FortyFive) continue;
            APoint2D pStart = p.getFirstPoint();
            APoint2D pSecond = p.getPoint(1);
            ALine incomingLine = null;
            if (p.getPointCount() == 2) {
                incomingLine = new ALine(pStart, pSecond);
            } else {
                APoint2D pThird = p.getPoint(2);
                incomingLine = new ALine(pSecond, pThird);
            }
            ALine l0 = new ALine(pStart, pSecond);
            double angle = l0.getAngle();
            double bestAngle = AGeomUtil.closestAngle((double)angle, (double)45.0, (boolean)true);
            ALine v = pStart.makeVector(this.mParent.getDeviceTemplate().getBB().width(), bestAngle);
            if (incomingLine.isVertical()) {
                long x = incomingLine.getP0().getX();
                long y = v.yIntercept(x);
                p.setPoint(1, new APoint2D(x, y));
            } else if (incomingLine.isHorizontal()) {
                long y = incomingLine.getP0().getY();
                long x = v.xIntercept(y);
                p.setPoint(1, new APoint2D(x, y));
            } else {
                long x;
                long y;
                ALine falseIncomingLine;
                long dx = pSecond.getX() - pStart.getX();
                long dy = pSecond.getY() - pStart.getY();
                if (Math.abs(dx) < Math.abs(dy)) {
                    falseIncomingLine = new ALine(pSecond, new APoint2D(pSecond.getX(), pStart.getY()));
                    if (falseIncomingLine.isVertical()) {
                        long x2 = falseIncomingLine.getP0().getX();
                        long y2 = v.yIntercept(x2);
                        p.insertPoint(1, new APoint2D(x2, y2));
                    } else if (falseIncomingLine.isHorizontal()) {
                        y = falseIncomingLine.getP0().getY();
                        x = v.xIntercept(y);
                        p.insertPoint(1, new APoint2D(x, y));
                    }
                } else {
                    falseIncomingLine = new ALine(pSecond, new APoint2D(pStart.getX(), pSecond.getY()));
                    if (falseIncomingLine.isVertical()) {
                        y = falseIncomingLine.getP0().getY();
                        x = v.xIntercept(y);
                        p.insertPoint(1, new APoint2D(x, y));
                    } else if (falseIncomingLine.isHorizontal()) {
                        y = falseIncomingLine.getP0().getY();
                        x = v.xIntercept(y);
                        p.insertPoint(1, new APoint2D(x, y));
                    }
                }
            }
            p.setWidth(width);
            w.setPath(p);
        }
    }

    protected void buildWireToOrderedFNs() {
        for (Wire w : this.mWiretoLastFn.keySet()) {
            FloodableNode last = this.mWiretoLastFn.get(w);
            while (last != null) {
                WireMap thisWireMap;
                if (last.isChannel) {
                    this.mWireToOrderedNodes.add((Object)w, (Object)last);
                }
                if ((thisWireMap = this.getWireMap(last, w)) == null) break;
                last = thisWireMap.prev;
            }
            this.mWireToOrderedNodes.reverse((Object)w);
        }
    }

    protected Boolean inOrder(Wire w, FloodableNode from, FloodableNode to) {
        boolean foundFirst = false;
        boolean foundSecond = false;
        ArrayList orderedList = (ArrayList)this.mWireToOrderedNodes.get((Object)w);
        for (FloodableNode fn : orderedList) {
            if (fn == from) {
                foundFirst = true;
                if (!foundSecond) continue;
                return false;
            }
            if (fn == to) {
                foundSecond = true;
                if (!foundFirst) continue;
                return true;
            }
            if (foundFirst) {
                return null;
            }
            if (!foundSecond) continue;
            return null;
        }
        return null;
    }

    protected boolean wireGenerallyH(Wire w) {
        APath p = w.getPath();
        p = p.cleanPath();
        long pdx = p.getFirstPoint().getX() - p.getLastPoint().getX();
        long pdy = p.getFirstPoint().getY() - p.getLastPoint().getY();
        boolean traceGenerallyH = false;
        if (Math.abs(pdx) > Math.abs(pdy)) {
            traceGenerallyH = true;
        }
        return traceGenerallyH;
    }

    protected Boolean isLeftHandAwayFromPush(APath path, ALine pushDir) {
        ALine pathLine = path.getAIntersectionLine(pushDir);
        if (pathLine != null) {
            AVector v0 = new AVector(pathLine);
            AVector v1 = new AVector(pushDir);
            double cp = v0.cross(v1);
            if (cp > 0.0) {
                return true;
            }
            return false;
        }
        return null;
    }

    protected void unlockAll() {
        for (FloodableNode fn : this.usedNodes) {
            for (int i = 0; i < fn.wireMaps.size(); ++i) {
                WireMap wm = fn.wireMaps.get(i);
                wm.locked = false;
            }
        }
    }

    protected boolean isSingleChannelRoute(Wire w) {
        int count = 0;
        for (FloodableNode fn : (ArrayList)this.mWireToOrderedNodes.get((Object)w)) {
            if (!fn.isChannel) continue;
            ++count;
        }
        return count == 1;
    }

    protected void smartStraighten() {
        this.buildWireToFirstFnHash();
        this.unlockAll();
        ArrayList<Wire> sortedWires = new ArrayList<Wire>();
        for (Wire w : this.mWiretoLastFn.keySet()) {
            sortedWires.add(w);
        }
        Collections.sort(sortedWires, new WirePositionSorter());
        for (Wire w : sortedWires) {
            int ith = 0;
            w.removeDuplicates();
            FloodableNode lastFn = this.mWiretoLastFn.get(w);
            WireMap wireMap = this.getWireMap(lastFn, w);
            APoint2D lastPt = wireMap.point;
            APath newPath = new APath(w.getWidth(), new APoint2D[]{lastPt});
            for (FloodableNode nextFn = lastFn.prev(w); nextFn != null; nextFn = nextFn.prev(w)) {
                APoint2D pBest;
                ALine span;
                ++ith;
                wireMap = this.getWireMap(nextFn, w);
                APoint2D nextPt = wireMap.point;
                ALine nextTarget = nextFn.isChannel ? this.deriveUsableChannel(w, nextFn, true) : new ALine(nextPt, nextPt);
                long xDiff = nextTarget.xAway(lastPt);
                long yDiff = nextTarget.yAway(lastPt);
                if (ith == 5) {
                    ALog.logInfo((String)"");
                }
                if (Math.abs(xDiff) > Math.abs(yDiff)) {
                    long y = lastPt.getY();
                    span = nextFn.span;
                    if (span != null) {
                        pBest = this.bestXIntercept(w, nextFn, y, true);
                        this.setWirePt(nextFn, w, pBest);
                        this.overlay.drawPath(span.toPath(1L), Color.blue, "" + ith);
                        if (pBest != null) {
                            newPath.addPoint(pBest);
                            lastPt = pBest;
                        }
                    }
                } else {
                    long x = lastPt.getX();
                    span = nextFn.span;
                    if (span != null) {
                        this.overlay.drawPath(span.toPath(1L), Color.red, "" + ith);
                        pBest = this.bestYIntercept(w, nextFn, x, true);
                        this.setWirePt(nextFn, w, pBest);
                        if (pBest != null) {
                            if (pBest.getX() == lastPt.getX()) {
                                newPath.addPoint(pBest);
                                lastPt = pBest;
                            } else if (lastPt.getY() > pBest.getY()) {
                                Topstacle anchor = this.anchor(lastFn, nextFn);
                                if (anchor.point.getX() < pBest.getX()) {
                                    APoint2D pHorizontal = new APoint2D(pBest.getX(), lastPt.getY());
                                    APoint2D pVertical = new APoint2D(pBest.getX(), pBest.getY());
                                    newPath.addPoint(pHorizontal);
                                    newPath.addPoint(pVertical);
                                    lastPt = pVertical;
                                } else {
                                    newPath.addPoint(pBest);
                                    lastPt = pBest;
                                }
                            } else {
                                newPath.addPoint(pBest);
                                lastPt = pBest;
                            }
                        }
                    }
                }
                lastFn = nextFn;
            }
            w.setPath(newPath);
        }
    }

    protected boolean turningCW(FloodableNode from, FloodableNode to) {
        return true;
    }

    protected void straighten() {
        this.buildWireToFirstFnHash();
        this.unlockAll();
        ArrayList<Wire> sortedWires = new ArrayList<Wire>();
        for (Wire w : this.mWiretoLastFn.keySet()) {
            sortedWires.add(w);
        }
        Collections.sort(sortedWires, new WirePositionSorter());
        for (Wire w : sortedWires) {
            w.removeDuplicates();
            FloodableNode lastFn = this.mWiretoLastFn.get(w);
            WireMap wireMap = this.getWireMap(lastFn, w);
            APoint2D lastPt = wireMap.point;
            for (FloodableNode nextFn = lastFn.prev(w); nextFn != null; nextFn = nextFn.prev(w)) {
                wireMap = this.getWireMap(nextFn, w);
                boolean foundOne = false;
                APoint2D nextPt = wireMap.point;
                ALine nextTarget = nextFn.isChannel ? this.deriveUsableChannel(w, nextFn, true) : new ALine(nextPt, nextPt);
                ALine l = new ALine(lastPt, nextPt);
                long xDiff = nextTarget.xAway(lastPt);
                long yDiff = nextTarget.yAway(lastPt);
                ArrayList<CostedDirectionOption> options = new ArrayList<CostedDirectionOption>();
                options.add(new CostedDirectionOption(DirectionOption.Vertical, xDiff));
                options.add(new CostedDirectionOption(DirectionOption.Horizontal, yDiff));
                Collections.sort(options);
                if (nextFn.mId == 4180) {
                    ALog.logInfo((String)"");
                }
                block3: for (int pass = 0; pass < 2 && !foundOne; ++pass) {
                    for (int option = 0; option < 2; ++option) {
                        APoint2D pBest;
                        ALine span;
                        ALine span2;
                        if (((CostedDirectionOption)options.get((int)option)).option == DirectionOption.Diagonal && (span2 = nextFn.span) != null) {
                            double angle = l.getAngle();
                            double angle45 = AGeomUtil.closestAngle((double)angle, (double)45.0, (boolean)true);
                            ALine v = lastPt.makeVector(l.getLength() * 2L, angle45);
                            ALine v45 = new ALine(lastPt, v.getP1());
                            APoint2D pBest2 = this.bestDIntercept(w, nextFn, v45);
                            if (pBest2 != null) {
                                this.setWirePt(nextFn, w, pBest2, true);
                                foundOne = true;
                                continue block3;
                            }
                        }
                        if (((CostedDirectionOption)options.get((int)option)).option == DirectionOption.Horizontal) {
                            APoint2D pBest3;
                            long y = lastPt.getY();
                            span = nextFn.span;
                            if (span != null && (pBest3 = this.bestXIntercept(w, nextFn, y, pass == 1)) != null) {
                                this.setWirePt(nextFn, w, pBest3, true);
                                foundOne = true;
                                continue block3;
                            }
                        }
                        if (((CostedDirectionOption)options.get((int)option)).option != DirectionOption.Vertical) continue;
                        long x = lastPt.getX();
                        span = nextFn.span;
                        if (span == null || (pBest = this.bestYIntercept(w, nextFn, x, pass == 1)) == null) continue;
                        this.setWirePt(nextFn, w, pBest, true);
                        foundOne = true;
                        continue block3;
                    }
                }
                lastFn = nextFn;
                lastPt = this.getWirePt(nextFn, w);
            }
        }
    }

    protected void dogLeg(Wire w, FloodableNode f0, FloodableNode f1) {
        int index0 = this.getIndexOfPath(w, f0);
        int index1 = this.getIndexOfPath(w, f1);
        this.dogLeg(w, index0, index1);
    }

    protected void dogLeg(Wire w, int index0, int index1) {
        APoint2D p02;
        APoint2D p01;
        APath path = w.getPath();
        APoint2D p0 = path.getPoint(index0);
        APoint2D p1 = path.getPoint(index1);
        long dx = p1.xDistance(p0);
        long dy = p1.yDistance(p0);
        if (Math.abs(dx) > Math.abs(dy)) {
            p01 = p0.add(new APoint2D(dx / 2L, 0L));
            p02 = p01.add(new APoint2D(0L, dy));
        } else {
            p01 = p0.add(new APoint2D(0L, dy / 2L));
            p02 = p01.add(new APoint2D(dx, 0L));
        }
        path.insertPoint(index0 + 1, p01);
        path.insertPoint(index0 + 2, p02);
    }

    ALine deriveUsableChannel(Wire w, FloodableNode fn, boolean ortho) {
        ALine l = new ALine(fn.span);
        long dist0 = 0L;
        long dist1 = 0L;
        boolean before = true;
        for (WireMap wm : fn.wireMaps) {
            Wire thisWire = wm.wire;
            SingleLayerRouter.RouteInformation thisRI = this.getRI(thisWire);
            if (wm.wire == w) {
                before = false;
                long myWidth = ortho ? Math.round((double)w.getWidth() / 2.0) : Math.round((double)w.getWidth() / 2.0 * Math.sqrt(2.0));
                dist0 += myWidth;
                dist1 += myWidth;
                dist0 += thisRI.getClear();
                dist1 += thisRI.getClear();
                continue;
            }
            if (before) {
                if (!wm.locked) {
                    dist0 += thisRI.getClear();
                    dist0 += thisWire.getWidth();
                    continue;
                }
                dist0 = l.getP0().distance(wm.point);
                dist0 += thisWire.getWidth() / 2L;
                continue;
            }
            if (!wm.locked) {
                dist1 += thisRI.getClear();
                dist1 += thisWire.getWidth();
                continue;
            }
            dist1 = l.getP1().distance(wm.point);
            dist1 += thisWire.getWidth() / 2L;
        }
        ALine shrunkL = l.shrink(dist0, dist1);
        return shrunkL;
    }

    APoint2D bestXIntercept(Wire w, FloodableNode fn, long y, boolean force) {
        if (fn.mStartBlocked && w == fn.wireMaps.get((int)0).wire || fn.mEndBlocked && w == fn.wireMaps.get((int)(fn.wireMaps.size() - 1)).wire) {
            return this.getWirePt(fn, w);
        }
        ALine shrunkL = this.deriveUsableChannel(w, fn, true);
        Long xIntercept = shrunkL.xIntercept(y);
        if (xIntercept != null) {
            return new APoint2D(xIntercept.longValue(), y);
        }
        if (force) {
            long p1Dist;
            long x = shrunkL.xInterceptOfVector(y);
            APoint2D p = new APoint2D(x, y);
            long p0Dist = Math.abs(p.distance(shrunkL.getP0()));
            if (p0Dist < (p1Dist = Math.abs(p.distance(shrunkL.getP1())))) {
                return shrunkL.getP0();
            }
            return shrunkL.getP1();
        }
        return null;
    }

    APoint2D bestYIntercept(Wire w, FloodableNode fn, long x, boolean force) {
        if (fn.mStartBlocked && w == fn.wireMaps.get((int)0).wire || fn.mEndBlocked && w == fn.wireMaps.get((int)(fn.wireMaps.size() - 1)).wire) {
            return this.getWirePt(fn, w);
        }
        ALine shrunkL = this.deriveUsableChannel(w, fn, true);
        Long yIntercept = shrunkL.yIntercept(x);
        if (yIntercept != null) {
            return new APoint2D(x, yIntercept.longValue());
        }
        if (force) {
            long p1Dist;
            long y = shrunkL.yInterceptOfVector(x);
            APoint2D p = new APoint2D(x, y);
            long p0Dist = Math.abs(p.distance(shrunkL.getP0()));
            if (p0Dist < (p1Dist = Math.abs(p.distance(shrunkL.getP1())))) {
                return shrunkL.getP0();
            }
            return shrunkL.getP1();
        }
        return null;
    }

    APoint2D bestDIntercept(Wire w, FloodableNode fn, ALine v45) {
        if (fn.mStartBlocked && w == fn.wireMaps.get((int)0).wire || fn.mEndBlocked && w == fn.wireMaps.get((int)(fn.wireMaps.size() - 1)).wire) {
            return this.getWirePt(fn, w);
        }
        ALine shrunkL = this.deriveUsableChannel(w, fn, false);
        if (shrunkL.crossIntersects(v45)) {
            return shrunkL.getIntersectLines(v45);
        }
        return null;
    }

    protected void buildWireToFirstFnHash() {
        HashSet<Wire> processedWires = new HashSet<Wire>();
        for (FloodableNode fn : this.usedNodes) {
            for (int i = 0; i < fn.wireMaps.size(); ++i) {
                WireMap wm = fn.wireMaps.get(i);
                Wire wire = wm.wire;
                if (processedWires.contains(wire)) continue;
                processedWires.add(wire);
                FloodableNode first = this.getLast(wire, fn);
                this.mWiretoLastFn.put(wire, first);
            }
        }
    }

    protected void buildWireTerminations() {
        for (FloodableNode fn : this.usedNodes) {
            Wire w;
            WireMap wm;
            if (fn.mStartBlocked) {
                wm = fn.wireMaps.get(0);
                w = wm.wire;
                this.mTopToWire.put((Topstacle)fn.mChannel.getP1(), w);
                continue;
            }
            if (!fn.mEndBlocked) continue;
            wm = fn.wireMaps.get(fn.wireMaps.size() - 1);
            w = wm.wire;
            this.mTopToWire.put((Topstacle)fn.mChannel.getP2(), w);
        }
    }

    protected void buildWireToRIHash() {
        this.mWireToRouteInformation.clear();
        for (SingleLayerRouter.RouteInformation ri : this.mRouteInfo) {
            if (ri.getWire() == null) continue;
            this.mWireToRouteInformation.put(ri.getWire(), ri);
        }
    }

    protected SingleLayerRouter.RouteInformation getRI(Wire w) {
        return this.mWireToRouteInformation.get(w);
    }

    protected ALine wireSegCrossingChannel(FloodableNode fn, Wire w) {
        FloodableNode nextF = this.getWireMap((FloodableNode)fn, (Wire)w).next;
        FloodableNode prevF = this.getWireMap((FloodableNode)fn, (Wire)w).prev;
        ALine l = new ALine(this.findWirePt(prevF, w), this.findWirePt(nextF, w));
        return l;
    }

    protected ArrayList<ALine> segmentsInChannel(FloodableNode fn, Wire w) {
        ArrayList<ALine> lines = new ArrayList<ALine>();
        FloodableNode nextF = this.getWireMap((FloodableNode)fn, (Wire)w).next;
        FloodableNode prevF = this.getWireMap((FloodableNode)fn, (Wire)w).prev;
        ALine l = new ALine(this.findWirePt(prevF, w), this.findWirePt(fn, w));
        lines.add(l);
        l = new ALine(this.findWirePt(fn, w), this.findWirePt(nextF, w));
        lines.add(l);
        return lines;
    }

    protected Personality diffPairOfWire(Wire w) {
        boolean mlv;
        Personality p;
        Db db = w.getDb();
        Constraint ml = Constraint.getConstraint((Db)db, (DbObject)(p = w.getNet().getPersonality()), (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
        if (ml != null && (mlv = ((Boolean)ml.getValue()).booleanValue())) {
            return p;
        }
        return null;
    }

    protected void checkForDuplicatePoints() {
    }

    protected ArrayList<APair<FloodableNode, FloodableNode>> getFloodableNodePairs(DelaunayRegion r) {
        ArrayList<APair<FloodableNode, FloodableNode>> list = new ArrayList<APair<FloodableNode, FloodableNode>>();
        list.add(new APair((Object)((FloodableNode)r.get(0)), (Object)((FloodableNode)r.get(1))));
        list.add(new APair((Object)((FloodableNode)r.get(1)), (Object)((FloodableNode)r.get(2))));
        list.add(new APair((Object)((FloodableNode)r.get(2)), (Object)((FloodableNode)r.get(0))));
        return list;
    }

    protected int getIndexOfPath(Wire w, FloodableNode a) {
        int index = a.getWireIndex(w);
        APoint2D stored = a.wireMaps.get((int)index).point;
        for (int i = 0; i < w.getPath().getPointCount(); ++i) {
            APoint2D p = w.getPath().getPoint(i);
            if (!p.equals((Object)stored)) continue;
            if (i == 0 && w.getPath().getPointCount() > 1 && w.getPath().getPoint(1).equals((Object)stored)) {
                return 1;
            }
            return i;
        }
        ALog.logInfo((String)"Can not find point");
        return -1;
    }

    protected void traceWire(String netName) {
        ArrayList<Wire> sortedWires = new ArrayList<Wire>();
        for (Wire w : this.mWiretoLastFn.keySet()) {
            sortedWires.add(w);
        }
        Collections.sort(sortedWires, new WirePositionSorter());
        for (Wire w : sortedWires) {
            if (!w.getNet().getName().equals(netName)) continue;
            FloodableNode fn = this.mWiretoLastFn.get(w);
            block2: while (fn != null) {
                ALog.logInfo((String)("" + fn.mId));
                for (int i = 0; i < fn.wireMaps.size(); ++i) {
                    WireMap wm = fn.wireMaps.get(i);
                    if (!wm.wire.equals(w)) continue;
                    fn = wm.prev;
                    continue block2;
                }
            }
        }
    }

    protected void arrangeWiresByRegion() {
        ArrayList<RouteRegion> processList = new ArrayList<RouteRegion>();
        for (DelaunayRegion r : this.regions) {
            RouteRegion rr = new RouteRegion((FloodableNode)r.get(0), (FloodableNode)r.get(1), (FloodableNode)r.get(2));
            processList.add(rr);
        }
        Collections.sort(processList);
        int maxPass = 1;
        double total = processList.size() * maxPass;
        double i = 0.0;
        for (int pass = 0; pass < maxPass; ++pass) {
            for (RouteRegion rr : processList) {
                double percent = i / total;
                PrettyRouter.updateProgress(false, percent, "Pushing Traces " + pass);
                rr.pushWires();
                i += 1.0;
            }
        }
        PrettyRouter.updateProgress(true, 100.0, "");
    }

    protected boolean wireEndsAt(FloodableNode fn, Wire w) {
        return this.getStart(fn, w) == fn || this.getEnd(fn, w) == fn;
    }

    protected double getGeneralWireAngle(Wire w) {
        APath p = w.getPath();
        ALine l = new ALine(p.getFirstPoint(), p.getLastPoint());
        double angle = l.getAngle();
        angle = AGeomUtil.closestAngle((double)angle, (double)90.0, (boolean)false);
        return angle;
    }

    protected APath getContourOfPinOfRegion(FloodableNode a, FloodableNode b, boolean debug) {
        Topstacle centerT = null;
        centerT = a.mChannel.getP1() == b.mChannel.getP1() ? (Topstacle)a.mChannel.getP1() : (a.mChannel.getP1() == b.mChannel.getP2() ? (Topstacle)a.mChannel.getP1() : (Topstacle)a.mChannel.getP2());
        ALine aLine = a.line();
        ALine bLine = b.line();
        boolean start = true;
        if (a.mChannel.getP1() != centerT) {
            aLine.swap();
            start = false;
        }
        if (b.mChannel.getP1() != centerT) {
            bLine.swap();
        }
        ALine bisector = aLine.bisector(bLine);
        APath contour = this.getContourOfFloodableNode(a, start, aLine.getAngle(), bisector.getAngle(), bLine.getAngle(), debug);
        return contour;
    }

    protected ARect getRectOfPin(FloodableNode fn, boolean start) {
        AGeom shape = null;
        shape = start ? ((Topstacle)fn.mChannel.getP1()).getShape() : ((Topstacle)fn.mChannel.getP2()).getShape();
        ARect r = shape.getBounds();
        return r;
    }

    protected Net getNetOfPin(FloodableNode fn, boolean start) {
        Net net = null;
        net = start ? ((Topstacle)fn.mChannel.getP1()).net : ((Topstacle)fn.mChannel.getP2()).net;
        return net;
    }

    protected APath getContourOfFloodableNode(FloodableNode fn, boolean start, double startA, double midA, double endA, boolean debug) {
        ARect r;
        long radius;
        AGeom shape = null;
        shape = start ? ((Topstacle)fn.mChannel.getP1()).getShape() : ((Topstacle)fn.mChannel.getP2()).getShape();
        APoint2D center = null;
        APath pusherPath = APath.convertToPath((AGeom)shape);
        if (shape instanceof ACircle) {
            ACircle c = ((ACircle)shape).copy();
            radius = c.getR();
            center = c.getC();
        } else if (shape instanceof ARect) {
            r = ((ARect)shape).copy();
            radius = Math.max(r.width(), r.height());
            center = r.center();
        } else {
            r = shape.getBounds().copy();
            radius = Math.max(r.width(), r.height());
            center = r.center();
        }
        int w = pusherPath.windingNumber();
        if (w > 0) {
            pusherPath.reverse();
        }
        ALine fromLine = new APoint2D(center).makeVector(radius, startA);
        ALine midLine = new APoint2D(center).makeVector(radius, midA);
        ALine toLine = new APoint2D(center).makeVector(radius, endA);
        if (debug) {
            this.overlay.drawPath(pusherPath, Color.orange);
            this.overlay.drawPath(fromLine.toPath(1L), Color.orange);
        }
        APath apusherPath = pusherPath.slice(fromLine, midLine, toLine);
        return apusherPath;
    }

    boolean generallyMono(APath p) {
        long pdx = p.getLastPoint().getX() - p.getFirstPoint().getX();
        long pdy = p.getLastPoint().getY() - p.getFirstPoint().getY();
        boolean traceGenerallyH = false;
        if (Math.abs(pdx) > Math.abs(pdy)) {
            traceGenerallyH = true;
        }
        if (!traceGenerallyH) {
            for (int i = 0; i < p.getPointCount() - 1; ++i) {
                APoint2D pThis = p.getPoint(i);
                APoint2D pNext = p.getPoint(i + 1);
                if (!(pdy < 0L ? pThis.getY() < pNext.getY() : pThis.getY() > pNext.getY())) continue;
                return false;
            }
        }
        return true;
    }

    protected double getMaxWidthAtVertex(APath path, int i) {
        double angle;
        ALine l;
        double prevMul = 1.0;
        double nextMul = 1.0;
        if (i > 0) {
            l = new ALine(path.getPoint(i - 1), path.getPoint(i));
            if (l.isHorizontal() || l.isVertical()) {
                prevMul = 1.0;
            } else {
                angle = l.getAngleInRadians();
                prevMul = Math.max(1.0 / Math.sin(angle), 1.0 / Math.cos(angle));
                prevMul = 1.0;
            }
        }
        if (i < path.getPointCount() - 1) {
            l = new ALine(path.getPoint(i), path.getPoint(i + 1));
            if (l.isHorizontal() || l.isVertical()) {
                nextMul = 1.0;
            } else {
                angle = l.getAngleInRadians();
                nextMul = Math.max(1.0 / Math.sin(angle), 1.0 / Math.cos(angle));
                nextMul = 1.0;
            }
        }
        return Math.max(prevMul, nextMul);
    }

    protected APath aedgeOfPath(APath from, long amount, boolean leftHand) {
        APath ret = new APath();
        from = from.cleanPath();
        Double lastNormal = null;
        boolean first = true;
        for (ALine l : from.getLines()) {
            double angle = l.getAngle();
            double normalAngle = leftHand ? angle + 90.0 : angle - 90.0;
            if (first) {
                lastNormal = normalAngle;
                APoint2D p = from.getFirstPoint();
                ALine v = p.makeVector(amount, normalAngle);
                ret.addPoint(v.getP1());
                first = false;
                continue;
            }
            APoint2D p0 = new APoint2D(l.getP0());
            APoint2D p1 = new APoint2D(l.getP0());
            ALine v0 = p0.makeVector(amount, lastNormal.doubleValue());
            ALine v1 = p1.makeVector(amount, normalAngle);
            ALine v3 = v0.bisector(v1);
            long dx = Math.abs(v3.dX());
            long dy = Math.abs(v3.dY());
            long extension = amount - Math.max(dx, dy);
            v3.extendP1ByOrtho(extension);
            ret.addPoint(v3.getP1());
            lastNormal = normalAngle;
        }
        APoint2D p = from.getLastPoint();
        ALine v = p.makeVector(amount, lastNormal.doubleValue());
        ret.addPoint(v.getP1());
        ret = ret.cleanPath();
        return ret;
    }

    protected APath edgeOfPath(APath from, long amount, boolean leftHand) {
        ALine lastLine = null;
        APath ret = new APath();
        from = from.cleanPath();
        for (int i = 0; i < from.getPointCount() - 1; ++i) {
            long dy;
            long dx;
            ALine l = new ALine(from.getPoint(i), from.getPoint(i + 1));
            if (l.isHorizontal()) {
                dx = 0L;
                dy = l.getP0().getX() < l.getP1().getX() ? -amount : amount;
            } else if (l.isVertical()) {
                dx = l.getP0().getY() < l.getP1().getY() ? amount : -amount;
                dy = 0L;
            } else {
                double angle = l.getAngle();
                dy = Math.round(Math.sin(Math.toRadians(angle -= 90.0)) * (double)amount);
                dx = Math.round(Math.cos(Math.toRadians(angle)) * (double)amount);
            }
            if (leftHand) {
                dx = -dx;
                dy = -dy;
            }
            l.moveBy(dx, dy);
            APoint2D end = new APoint2D(l.getP1());
            if (i == 0) {
                ret.addPoint(new APoint2D(l.getP0()));
                l.extendEnds(amount * 4L + 2L);
            } else {
                l.extendEnds(amount * 4L + 2L);
                if (l.crossIntersects(lastLine)) {
                    APoint2D p = l.getIntersectLines(lastLine);
                    ret.addPoint(p);
                } else {
                    if (this.numInternalErrors < 100) {
                        from = from.cleanPath();
                        ALog.logInfo((String)("problem expanding path " + lastLine.getAngle() + " " + l.getAngle()));
                    }
                    ++this.numInternalErrors;
                }
            }
            if (i == from.getPointCount() - 2) {
                ret.addPoint(end);
            }
            lastLine = new ALine(l);
        }
        ret = ret.cleanPath();
        return ret;
    }

    public Long getYAtIn(APath path, long x, APolygon p, long xtra) {
        Long maxY = null;
        for (ALine l : path.getLines()) {
            APoint2D pp;
            Long yIntercept = l.yIntercept(x);
            if (yIntercept == null || !p.pointInside(pp = new APoint2D(x, yIntercept.longValue())) && p.distance(pp) >= xtra) continue;
            if (maxY == null) {
                maxY = yIntercept;
                continue;
            }
            maxY = Math.max(maxY, yIntercept);
        }
        return maxY;
    }

    protected void padEntry() {
        for (FloodableNode fn : this.usedNodes) {
            APoint2D p;
            Wire w;
            if (fn.mStartBlocked) {
                w = fn.wireMaps.get((int)0).wire;
                p = fn.mChannel.getV1();
                p = fn.span.getP1();
                this.setWirePt(fn, w, p);
                fn.wireMaps.get((int)0).padEntry = true;
            }
            if (!fn.mEndBlocked) continue;
            w = fn.wireMaps.get((int)(fn.wireMaps.size() - 1)).wire;
            p = fn.mChannel.getV2();
            this.setWirePt(fn, w, p);
            fn.wireMaps.get((int)(fn.wireMaps.size() - 1)).padEntry = true;
        }
    }

    protected APoint2D DogLeg(APoint2D p0, APoint2D p1, int n) {
        if (n == 0) {
            return new APoint2D(p0.getX(), p1.getY());
        }
        return new APoint2D(p1.getX(), p0.getY());
    }

    protected void padEntry90() {
        for (FloodableNode fn : this.usedNodes) {
            if (fn.mId == 770) {
                ALog.logInfo((String)"");
            }
            if (!fn.mStartBlocked || !fn.mEndBlocked) continue;
            Wire w = fn.wireMaps.get((int)0).wire;
            w.setPath(w.getPath().cleanPath());
            APoint2D p1 = w.getPath().getFirstPoint();
            APoint2D p2 = w.getPath().getLastPoint();
            APoint2D pDogLeg = this.DogLeg(p1, p2, 1);
            w.insertPt(p1, p2, pDogLeg);
        }
    }

    private FloodableNode getStart(FloodableNode seed, Wire w) {
        FloodableNode last = null;
        FloodableNode cur = seed;
        block0: while (cur.isChannel) {
            for (WireMap wm : cur.wireMaps) {
                if (wm.wire != w) continue;
                last = cur;
                cur = wm.prev;
                continue block0;
            }
        }
        return last;
    }

    private FloodableNode getEnd(FloodableNode seed, Wire w) {
        FloodableNode last = null;
        FloodableNode cur = seed;
        block0: while (cur.isChannel) {
            for (WireMap wm : cur.wireMaps) {
                if (wm.wire != w) continue;
                last = cur;
                cur = wm.next;
                continue block0;
            }
        }
        return last;
    }

    private void pullWiresToGravity(FloodableNode fn, boolean exact) {
        if (!fn.isChannel) {
            return;
        }
        int numLoads = fn.mNumLoads;
        if (fn.mStartBlocked) {
            --numLoads;
        }
        if (numLoads <= 0) {
            return;
        }
        int i = 0;
        if (fn.span == null) {
            return;
        }
        if (fn.mId == 83) {
            ALog.logInfo((String)"");
        }
        ALine workingSpan = new ALine(fn.span);
        long previousRequired = 0L;
        boolean first = true;
        int size = fn.wireMaps.size();
        for (WireMap wm : fn.wireMaps) {
            if (first && fn.mStartBlocked) {
                first = false;
                continue;
            }
            first = false;
            SingleLayerRouter.RouteInformation ri = this.getRI(wm.wire);
            if (ri == null) {
                ALog.logInfo((String)"");
            }
            long remainingRequired = wm.wire.getWidth() / 2L;
            remainingRequired += ri.getClear();
            long lastClear = 0L;
            for (int j = i + 1; j < numLoads; ++j) {
                if (j >= fn.wireMaps.size()) continue;
                Wire thisWire = fn.wireMaps.get((int)j).wire;
                SingleLayerRouter.RouteInformation thisRi = this.getRI(thisWire);
                lastClear = thisRi.getClear();
                remainingRequired += thisWire.getWidth() + lastClear;
            }
            if (wm.padEntry) continue;
            Wire wire = wm.wire;
            long thisRequired = 0L;
            thisRequired = ri.getClear();
            thisRequired += wm.wire.getWidth() / 2L;
            FloodableNode prev = wm.prev;
            FloodableNode next = wm.next;
            APoint2D p0 = this.findWirePt(prev, wire);
            APoint2D p1 = this.findWirePt(next, wire);
            long distFromP0 = 0L;
            if (p0 != null && p1 != null) {
                ALine l = new ALine(p0, p1);
                ALine span = new ALine(fn.span);
                double alpha = span.dX() == 0L || span.dY() == 0L ? 1.0 : (Math.abs(span.dX()) > Math.abs(span.dY()) ? Math.abs(Math.cos(span.getAngleInRadians())) : Math.abs(Math.sin(span.getAngleInRadians())));
                thisRequired = (long)((double)thisRequired / alpha);
                remainingRequired = (long)((double)remainingRequired / alpha);
                ALine limitedSpan = workingSpan.shrink(previousRequired += thisRequired, remainingRequired);
                if (exact && l.crossIntersects(limitedSpan)) {
                    APoint2D p = l.getIntersectLines(limitedSpan);
                    this.setWirePt(fn, wire, p);
                    distFromP0 = Math.abs(p.distance(workingSpan.getP0()));
                } else {
                    long p1Dist;
                    long p0Dist = l.distance(limitedSpan.getP0());
                    APoint2D p = p0Dist < (p1Dist = l.distance(limitedSpan.getP1())) ? limitedSpan.getP0() : limitedSpan.getP1();
                    if (fn.mEndBlocked && i == size - 1) {
                        p = fn.span.getP1();
                        this.setWirePt(fn, wire, p);
                    } else {
                        this.setWirePt(fn, wire, p);
                    }
                    distFromP0 = Math.abs(p.distance(workingSpan.getP0()));
                }
            } else {
                distFromP0 = Math.abs(wm.point.distance(workingSpan.getP0()));
            }
            previousRequired = distFromP0;
            previousRequired += wm.wire.getWidth() / 2L;
            ++i;
        }
    }

    protected APoint2D findWirePt(FloodableNode fn, Wire w) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            return wm.point;
        }
        return null;
    }

    protected FloodableNode getLast(Wire w, FloodableNode fn) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            FloodableNode next = wm.next;
            if (next != null) {
                return this.getLast(w, next);
            }
            return fn;
        }
        return null;
    }

    protected FloodableNode getFirst(Wire w, FloodableNode fn) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            FloodableNode prev = wm.prev;
            if (prev != null) {
                return this.getFirst(w, prev);
            }
            return fn;
        }
        return null;
    }

    protected ArrayList<FloodableNode> getAll(Wire w, FloodableNode fn) {
        ArrayList<FloodableNode> ret = new ArrayList<FloodableNode>();
        for (FloodableNode first = this.getFirst(w, fn); first != null; first = first.next(w)) {
            ret.add(first);
        }
        Collections.reverse(ret);
        return ret;
    }

    protected void removeWirePt(Wire w, FloodableNode fn) {
        block0: for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            APath path = w.getPath();
            path.removePt(this.findWirePt(fn, w));
            FloodableNode prev = wm.prev;
            FloodableNode next = wm.next;
            for (WireMap wmprev : prev.wireMaps) {
                if (wmprev.wire != w) continue;
                wmprev.next = next;
                break;
            }
            for (WireMap wmnext : next.wireMaps) {
                if (wmnext.wire != w) continue;
                wmnext.prev = prev;
                break block0;
            }
        }
    }

    protected APoint2D getWirePt(FloodableNode fn, int i) {
        WireMap wm = fn.wireMaps.get(i);
        return wm.point;
    }

    protected Wire getWire(FloodableNode fn, int i) {
        WireMap wm = fn.wireMaps.get(i);
        return wm.wire;
    }

    protected APoint2D getWirePt(FloodableNode fn, Wire w) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            return wm.point;
        }
        return null;
    }

    protected void setWirePt(FloodableNode fn, int i, APoint2D p) {
        WireMap wm = fn.wireMaps.get(i);
        Wire w = wm.wire;
        APath path = w.getPath();
        if (path.replacePtWith(wm.point, p)) {
            wm.point = new APoint2D(p);
            return;
        }
    }

    protected void setWirePt(FloodableNode fn, Wire w, APoint2D p) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            APath path = w.getPath();
            if (path.replacePtWith(wm.point, p)) {
                wm.point = new APoint2D(p);
                return;
            }
            return;
        }
    }

    protected void updateWirePoint(FloodableNode fn, Wire w, APoint2D p) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            wm.point = new APoint2D(p);
            return;
        }
    }

    protected void setWirePt(FloodableNode fn, int fnIndex, int pathIndex, APoint2D p) {
        WireMap wm = fn.wireMaps.get(fnIndex);
        Wire w = wm.wire;
        APath path = w.getPath();
        path.setPoint(pathIndex, p);
        wm.point = new APoint2D(p);
    }

    protected void setWirePt(FloodableNode fn, Wire w, APoint2D p, boolean locked) {
        for (WireMap wm : fn.wireMaps) {
            APath path;
            if (wm.wire != w || !(path = w.getPath()).replacePtWith(wm.point, p)) continue;
            wm.point = new APoint2D(p);
            wm.locked = locked;
            return;
        }
        ALog.logWarn((String)("Can not find point in wire " + w.getNet().getName()));
    }

    protected WireMap getWireMap(FloodableNode fn, Wire w) {
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            return wm;
        }
        return null;
    }

    protected void addWirePt(FloodableNode fn, Wire w, APoint2D p) {
        boolean lastWasOnIt = false;
        for (WireMap wm : fn.wireMaps) {
            if (wm.wire != w) continue;
            APath path = w.getPath();
            for (int i = 0; i < path.getPointCount(); ++i) {
                APoint2D pOnPath = path.getPoint(i);
                if (pOnPath.equals((Object)wm.point)) {
                    lastWasOnIt = true;
                    continue;
                }
                if (!lastWasOnIt) continue;
                path.insertPoint(i, p);
                return;
            }
        }
    }

    protected long centerToIntesectingEdge(FloodableNode fn, int side) {
        long centerToCenter = fn.line().getLength();
        long spanLength = fn.span.getLength();
        long extra = centerToCenter - spanLength;
        return extra / 2L;
    }

    protected void springWires() {
        ClearanceUniverse cu = new ClearanceUniverse();
        for (FloodableNode fn : this.usedNodes) {
            if (!fn.isChannel || fn.mId != 3680) continue;
            int first = 0;
            int last = fn.wireMaps.size() - 1;
            WireVertex wvFrom = new WireVertex(fn, -1);
            WireVertex wvTo = new WireVertex(fn, -2);
            wvFrom.addSU(cu);
            wvTo.addSU(cu);
            WireVertex wvFirst = new WireVertex(fn, first);
            wvFirst.addSU(cu);
            Wire w = fn.wireMaps.get((int)first).wire;
            SingleLayerRouter.RouteInformation ri = this.getRI(w);
            long inside = this.centerToIntesectingEdge(fn, 0);
            ClearanceSpring sFirst = new ClearanceSpring(inside + ri.getClear() + w.getWidth() / 2L);
            cu.addSpring(wvFrom, wvFirst, sFirst);
            WireVertex wvLast = new WireVertex(fn, last);
            wvLast.addSU(cu);
            w = fn.wireMaps.get((int)last).wire;
            ri = this.getRI(w);
            ClearanceSpring sLast = new ClearanceSpring(inside + ri.getClear() + w.getWidth() / 2L);
            cu.addSpring(wvTo, wvLast, sLast);
            for (int i = 0; i < last; ++i) {
                WireVertex wvA = new WireVertex(fn, i);
                wvA.addSU(cu);
                WireVertex wvB = new WireVertex(fn, i + 1);
                wvB.addSU(cu);
                Wire wA = fn.wireMaps.get((int)i).wire;
                Wire wB = fn.wireMaps.get((int)(i + 1)).wire;
                SingleLayerRouter.RouteInformation riA = this.getRI(wA);
                SingleLayerRouter.RouteInformation riB = this.getRI(wB);
                long clr = Math.max(riA.getClear(), riB.getClear()) * 2L + wA.getWidth() / 2L + wB.getWidth() / 2L;
                ClearanceSpring s = new ClearanceSpring(clr);
                cu.addSpring(wvA, wvB, s);
            }
        }
        cu.relax();
        cu.update();
    }

    class ClearanceUniverse
    extends ForceUniverse<WireVertex, ASpring>
    implements AForceUniverseDrawer<WireVertex, ASpring>,
    AForceUpdateListener {
        AForceOverlay<WireVertex, ASpring> overlay;

        ClearanceUniverse() {
        }

        public void debugView() {
            this.overlay = new AForceOverlay<WireVertex, ASpring>((DesignView2D)OrbitIO.getCurView(), this, this);
            this.addUpdater(this);
        }

        @Override
        public void update() {
            HashBiMap moves = this.getMove();
            for (WireVertex wv : moves.keySet()) {
                APoint2D newPoint;
                if (wv.index < 0) continue;
                AParticlePoint p = (AParticlePoint)moves.get((Object)wv);
                FloodableNode fn = wv.fn;
                APoint2D oldPoint = PrettyRouter.this.getWirePt(fn, wv.index);
                if (oldPoint.equals((Object)(newPoint = new APoint2D(p.x, p.y)))) continue;
                PrettyRouter.this.setWirePt(fn, wv.index, new APoint2D(p.x, p.y));
            }
        }

        @Override
        public void drawE(AForce<WireVertex, ASpring> e, Graphics2D g, DesignCanvas2D.XForm w2s) {
        }

        @Override
        public void drawV(WireVertex v, Graphics2D g, DesignCanvas2D.XForm w2s) {
        }
    }

    class ASpring {
        ASpring() {
        }
    }

    class WireVertex {
        FloodableNode fn;
        int index;

        public WireVertex(FloodableNode fn, int index) {
            this.fn = fn;
            this.index = index;
        }

        public void addSU(ForceUniverse<WireVertex, ASpring> su) {
            if (this.index >= 0) {
                su.addObject(this, this.fn.wireMaps.get((int)this.index).point.getX(), this.fn.wireMaps.get((int)this.index).point.getY());
            } else if (this.fn.isChannel) {
                if (this.index == -1) {
                    su.addObject(this, this.fn.mChannel.getV1().getX(), this.fn.mChannel.getV1().getY(), false);
                } else {
                    su.addObject(this, this.fn.mChannel.getV2().getX(), this.fn.mChannel.getV2().getY(), false);
                }
            }
        }
    }

    protected class RouteRegion
    implements Comparable<RouteRegion> {
        FloodableNode fnA;
        FloodableNode fnB;
        FloodableNode fnC;

        public RouteRegion(FloodableNode a, FloodableNode b, FloodableNode c) {
            this.fnA = a;
            this.fnB = b;
            this.fnC = c;
        }

        ArrayList<Wire> getWires(FloodableNode a) {
            ArrayList<Wire> wires = new ArrayList<Wire>();
            for (int i = 0; i < a.wireMaps.size(); ++i) {
                wires.add(a.wireMaps.get((int)i).wire);
            }
            return wires;
        }

        protected ArrayList<Wire> commonWires(FloodableNode a, FloodableNode b) {
            ArrayList<Wire> wires = new ArrayList<Wire>();
            for (int i = 0; i < a.wireMaps.size(); ++i) {
                Wire w = a.wireMaps.get((int)i).wire;
                if (a.wireMaps.get((int)i).next == b) {
                    wires.add(w);
                    continue;
                }
                if (a.wireMaps.get((int)i).prev != b) continue;
                wires.add(w);
            }
            if (a.mChannel.getP1() != b.mChannel.getP1()) {
                Collections.reverse(wires);
            }
            return wires;
        }

        protected ArrayList<WireInRegion> commonWiresIncludingTerminations(FloodableNode a, FloodableNode b) {
            Wire w;
            int i;
            ArrayList<WireInRegion> wires = new ArrayList<WireInRegion>();
            FloodableNode c = PrettyRouter.this.getThirdLeg(a, b);
            Topstacle ab = PrettyRouter.this.anchor(a, b);
            ArrayList<WireInRegion> abList = new ArrayList<WireInRegion>();
            ArrayList<WireInRegion> acList = new ArrayList<WireInRegion>();
            ArrayList<WireInRegion> cbList = new ArrayList<WireInRegion>();
            for (i = 0; i < a.wireMaps.size(); ++i) {
                w = a.wireMaps.get((int)i).wire;
                if (a.wireMaps.get((int)i).next == b) {
                    abList.add(new WireInRegion(w, a, b, false));
                    continue;
                }
                if (a.wireMaps.get((int)i).prev == b) {
                    abList.add(new WireInRegion(w, a, b, true));
                    continue;
                }
                if (a.wireMaps.get((int)i).next == c) {
                    acList.add(new WireInRegion(w, a, c, false));
                    continue;
                }
                if (a.wireMaps.get((int)i).prev != c) continue;
                acList.add(new WireInRegion(w, a, c, true));
            }
            if (!((Topstacle)a.mChannel.getP1()).equals(ab)) {
                Collections.reverse(abList);
                Collections.reverse(acList);
            }
            for (i = 0; i < b.wireMaps.size(); ++i) {
                w = b.wireMaps.get((int)i).wire;
                boolean wireAlreadyFound = false;
                for (WireInRegion wir : wires) {
                    if (!wir.w.equals(w)) continue;
                    wireAlreadyFound = true;
                    break;
                }
                if (wireAlreadyFound) continue;
                if (b.wireMaps.get((int)i).next == c) {
                    cbList.add(new WireInRegion(w, c, b, true));
                    continue;
                }
                if (b.wireMaps.get((int)i).prev != c) continue;
                cbList.add(new WireInRegion(w, c, b, false));
            }
            if (!((Topstacle)b.mChannel.getP1()).equals(ab)) {
                Collections.reverse(cbList);
            }
            wires.addAll(abList);
            wires.addAll(acList);
            wires.addAll(cbList);
            return wires;
        }

        protected APoint2D yIntercept(long x, FloodableNode a) {
            ALine span = new ALine(a.span);
            if (span.dX() < 0L) {
                span.swap();
            }
            if (x < span.getP0().getX()) {
                return null;
            }
            if (x > span.getP1().getX()) {
                return null;
            }
            long y = span.yIntercept(x);
            APoint2D p = new APoint2D(x, y);
            return p;
        }

        protected boolean hasEdges(FloodableNode a, FloodableNode b, int i, int j) {
            if (a.mId == i && b.mId == j) {
                return true;
            }
            return a.mId == j && b.mId == i;
        }

        protected APath buildRamp(FloodableNode from, FloodableNode to, long dist) {
            double totalAngle;
            APath ret = new APath();
            ALine vFrom = from.line();
            ALine vTo = to.line();
            if (!vFrom.getP0().equals((Object)vTo.getP0())) {
                if (vFrom.getP1().equals((Object)vTo.getP0())) {
                    vFrom.swap();
                } else if (vFrom.getP0().equals((Object)vTo.getP1())) {
                    vTo.swap();
                } else {
                    vFrom.swap();
                    vTo.swap();
                }
            }
            double fromAngle = vFrom.getAngle();
            double toAngle = vTo.getAngle();
            boolean cw = true;
            double da = fromAngle - toAngle;
            if (da < 0.0) {
                da = 360.0 + da;
            }
            if (da > 180.0) {
                cw = false;
            }
            if ((totalAngle = Math.abs(toAngle - fromAngle)) > 180.0) {
                totalAngle = 360.0 - totalAngle;
            }
            for (double angle = 0.0; angle < totalAngle; angle += 15.0) {
                double thisAngle = cw ? fromAngle - angle : fromAngle + angle;
                ALine v = vFrom.getP0().makeVector(dist, thisAngle);
                ret.addPoint(v.getP1());
            }
            ALine v = vTo.getP0().makeVector(dist, toAngle);
            ret.addPoint(v.getP1());
            ret = ret.cleanPath();
            return ret;
        }

        protected ArrayList<APath> pathInRegion(FloodableNode a, FloodableNode b, FloodableNode c) {
            ArrayList<Wire> wires = new ArrayList<Wire>();
            for (int i = 0; i < a.wireMaps.size(); ++i) {
                Wire w = a.wireMaps.get((int)i).wire;
                if (a.wireMaps.get((int)i).next == b) {
                    wires.add(w);
                    continue;
                }
                if (a.wireMaps.get((int)i).prev != b) continue;
                wires.add(w);
            }
            return null;
        }

        protected Wire getWireOnEdge(FloodableNode a) {
            if (a.mBothBlocked && a.wireMaps.size() == 1) {
                return a.wireMaps.get((int)0).wire;
            }
            return null;
        }

        protected void pushWiresFromEdge(FloodableNode a, FloodableNode b) {
            Wire w = this.getWireOnEdge(a);
            if (w != null) {
                ALog.logInfo((String)("Wire " + w.getNet().getName()));
            }
        }

        protected void pushWires(FloodableNode a, FloodableNode b) {
            boolean debug = false;
            if (this.hasEdges(a, b, 704, 706)) {
                debug = true;
            }
            ArrayList<WireInRegion> wires = this.commonWiresIncludingTerminations(a, b);
            long radius = 0L;
            if (wires.size() > 0) {
                Wire firstWire = wires.get((int)0).w;
                radius = 0L;
                radius += firstWire.getWidth() / 2L;
            } else {
                return;
            }
            Topstacle top = PrettyRouter.this.anchor(a, b);
            Net singularityNet = top.net;
            APoint2D center = top.point;
            boolean leftHand = true;
            APath contour = PrettyRouter.this.getContourOfPinOfRegion(a, b, debug);
            if (contour.getPointCount() == 0) {
                return;
            }
            if (debug) {
                PrettyRouter.this.overlay.drawPath(contour, Color.black, "pin");
            }
            APath loop = contour.copy();
            loop.addPoint(center);
            if (loop.windingNumber() > 0) {
                leftHand = false;
            }
            String id = a.mId + ":" + b.mId;
            radius = 0L;
            for (WireInRegion wir : wires) {
                Wire w = wir.w;
                if (w.getNet().equals(singularityNet)) continue;
                radius += w.getWidth() / 2L;
                APath frontier = PrettyRouter.this.aedgeOfPath(contour, radius += PrettyRouter.this.getRI(w).getClear(), leftHand);
                if (wir.reverse) {
                    frontier.reverse();
                }
                int start = PrettyRouter.this.getIndexOfPath(w, wir.start);
                int end = PrettyRouter.this.getIndexOfPath(w, wir.end);
                APath wirePath = new APath();
                for (int i = start; i <= end; ++i) {
                    wirePath.addPoint(w.getPath().getPoint(i));
                }
                ALine bisector = a.line().bisector(b.line());
                double angle = 90.0 - bisector.getAngle();
                APath pushedWirePath = this.maxSet(wirePath, frontier, angle, debug ? PrettyRouter.this.overlay : null, true);
                if (wirePath.getPointCount() == 0) {
                    debug = true;
                }
                if (w.getNet().getName().equals("SIMCLK")) {
                    debug = true;
                }
                pushedWirePath = pushedWirePath.cleanPath();
                id = id + " " + w.getNet().getName();
                if (debug) {
                    PrettyRouter.this.overlay.drawPath(frontier, Color.red, id);
                    PrettyRouter.this.overlay.drawPath(wirePath, Color.orange, id);
                    PrettyRouter.this.overlay.drawPath(pushedWirePath, Color.blue);
                }
                w.getPath().replaceSectionPath(start, end, pushedWirePath);
                PrettyRouter.this.updateWirePoint(wir.start, w, pushedWirePath.getFirstPoint());
                PrettyRouter.this.updateWirePoint(wir.end, w, pushedWirePath.getLastPoint());
                loop = new APath(pushedWirePath);
                loop.addPoint(center);
                leftHand = true;
                if (loop.windingNumber() > 0) {
                    leftHand = false;
                }
                radius = w.getWidth() / 2L;
                contour = pushedWirePath;
            }
        }

        public APath maxSet(APath initial, APath pusher, double angle, DebugOverlay overlay, boolean useMinOfBottom) {
            APoint2D aPoint;
            int i;
            double incrAngle = (float)angle;
            AffineTransform t = new AffineTransform();
            long cx = initial.getFirstPoint().getX();
            long cy = initial.getFirstPoint().getY();
            t.setToRotation(Math.toRadians(incrAngle), cx, cy);
            APath below = pusher.transform(t);
            APath a = initial.transform(t);
            APath result = new APath(initial.getWidth());
            boolean reversed = false;
            if (a.getFirstPoint().getX() > a.getLastPoint().getX()) {
                reversed = true;
                a.reverse();
            }
            APath above = a.copy();
            ArrayList<Long> xs = new ArrayList<Long>();
            for (int i2 = 0; i2 < below.getPointCount(); ++i2) {
                long x = below.getPoint(i2).getX();
                if (xs.contains(x)) continue;
                xs.add(x);
            }
            ArrayList ints = below.getIntersectionPoints(above);
            for (int i3 = 0; i3 < ints.size(); ++i3) {
                long x = ((APoint2D)ints.get(i3)).getX();
                if (xs.contains(x)) continue;
                xs.add(x);
            }
            boolean changed = false;
            Collections.sort(xs);
            long xFirst = (Long)xs.get(0);
            long xLast = (Long)xs.get(xs.size() - 1);
            for (i = 0; i < above.getPointCount(); ++i) {
                long x = above.getPoint(i).getX();
                if (x < xFirst || x > xLast || xs.contains(x)) continue;
                xs.add(x);
            }
            Collections.sort(xs);
            for (i = 0; i < a.getPointCount() && (aPoint = a.getPoint(i)).getX() <= xFirst; ++i) {
                result.addPoint(aPoint);
            }
            for (Long x : xs) {
                Long yOfAbove = above.getMinYAt(x.longValue());
                Long yOfBelow = null;
                yOfBelow = useMinOfBottom ? below.getMinYAt(x.longValue()) : below.getMaxYAt(x.longValue());
                if (yOfAbove == null || yOfBelow == null) continue;
                if (yOfBelow > yOfAbove) {
                    changed = true;
                    result.addPoint(new APoint2D(x.longValue(), yOfBelow.longValue()));
                    continue;
                }
                result.addPoint(new APoint2D(x.longValue(), yOfAbove.longValue()));
            }
            for (int i4 = 0; i4 < a.getPointCount(); ++i4) {
                APoint2D aPoint2 = a.getPoint(i4);
                if (aPoint2.getX() < xLast) continue;
                result.addPoint(aPoint2);
            }
            if (overlay != null) {
                overlay.drawPath(above, Color.blue, "above");
                overlay.drawPath(below, Color.RED, "below ");
                overlay.drawPath(result, Color.PINK, "result ");
            }
            if (changed) {
                AffineTransform tReverse = new AffineTransform();
                tReverse.setToRotation(Math.toRadians(-incrAngle), cx, cy);
                result = result.transform(tReverse);
                result = result.cleanPath();
                if (reversed) {
                    result.reverse();
                }
                return result;
            }
            return initial;
        }

        public void pushWires() {
            this.pushWires(this.fnA, this.fnB);
            this.pushWires(this.fnA, this.fnC);
            this.pushWires(this.fnB, this.fnC);
            this.pushWiresFromEdge(this.fnA, this.fnB);
            this.pushWiresFromEdge(this.fnA, this.fnC);
            this.pushWiresFromEdge(this.fnB, this.fnA);
            this.pushWiresFromEdge(this.fnB, this.fnC);
            this.pushWiresFromEdge(this.fnC, this.fnB);
            this.pushWiresFromEdge(this.fnC, this.fnA);
        }

        @Override
        public int compareTo(RouteRegion o) {
            return this.fnA.compareTo(o.fnA);
        }

        class WireInRegion {
            Wire w;
            boolean reverse = false;
            FloodableNode start;
            FloodableNode end;

            WireInRegion(Wire w, FloodableNode start, FloodableNode end, boolean reverse) {
                this.w = w;
                if (reverse) {
                    this.start = end;
                    this.end = start;
                } else {
                    this.start = start;
                    this.end = end;
                }
                this.reverse = reverse;
            }
        }
    }

    static class ProcessItem
    implements Comparable<ProcessItem> {
        Wire w;
        FloodableNode from;
        FloodableNode to;
        Topstacle common;
        int order;

        ProcessItem() {
        }

        @Override
        public int compareTo(ProcessItem other) {
            int compare = this.common.compareTo(other.common);
            if (compare == 0 && (compare = Integer.valueOf(this.from.mChannel.mId).compareTo(other.from.mChannel.mId)) == 0) {
                compare = Integer.valueOf(this.to.mChannel.mId).compareTo(other.to.mChannel.mId);
            }
            return compare;
        }
    }

    public static class WirePositionSorter
    implements Comparator<Wire> {
        @Override
        public int compare(Wire w0, Wire w1) {
            boolean w1IsH;
            APath p0 = w0.getPath();
            APath p1 = w1.getPath();
            long dx0 = Math.abs(p0.getFirstPoint().getX() - p0.getLastPoint().getX());
            long dx1 = Math.abs(p1.getFirstPoint().getX() - p1.getLastPoint().getX());
            long dy0 = Math.abs(p0.getFirstPoint().getY() - p0.getLastPoint().getY());
            long dy1 = Math.abs(p1.getFirstPoint().getY() - p1.getLastPoint().getY());
            boolean w0IsH = dx0 > dy0;
            boolean bl = w1IsH = dx1 > dy1;
            if (w0IsH) {
                if (w1IsH) {
                    if (p0.getLastPoint().getY() < p1.getLastPoint().getY()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (!w1IsH) {
                if (p0.getLastPoint().getX() < p1.getLastPoint().getX()) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }
    }

    class CostedDirectionOption
    implements Comparable<CostedDirectionOption> {
        DirectionOption option;
        long cost;

        public CostedDirectionOption(DirectionOption o, long c) {
            this.option = o;
            this.cost = c;
        }

        @Override
        public int compareTo(CostedDirectionOption o) {
            if (this.cost > o.cost) {
                return 1;
            }
            if (this.cost < o.cost) {
                return -1;
            }
            return 0;
        }
    }

    private static enum DirectionOption {
        Horizontal,
        Vertical,
        Diagonal;

    }

    public static class DelaunayRegion
    extends ArrayList<FloodableNode> {
        protected boolean processed;

        public DelaunayRegion(FloodableNode fnA, FloodableNode fnB, FloodableNode fnC) {
            this.clear();
            this.add(fnA);
            this.add(fnB);
            this.add(fnC);
        }

        @Override
        public int hashCode() {
            int hc = ((FloodableNode)this.get(0)).hashCode();
            hc ^= ((FloodableNode)this.get(1)).hashCode();
            return hc ^= ((FloodableNode)this.get(2)).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DelaunayRegion)) {
                return false;
            }
            DelaunayRegion d = (DelaunayRegion)o;
            boolean state = d.get(0) == this.get(0);
            state &= d.get(1) == this.get(1);
            return state &= d.get(2) == this.get(2);
        }

        public void order() {
            Collections.sort(this, new SingleLayerRouter.FNSort());
        }

        protected APolygon polygon() {
            APolygon poly = new APolygon();
            APoint2D v0 = ((FloodableNode)this.get((int)0)).mChannel.getV1();
            APoint2D v1 = ((FloodableNode)this.get((int)0)).mChannel.getV2();
            APoint2D v3 = ((FloodableNode)this.get((int)1)).mChannel.getV1();
            APoint2D v3P = ((FloodableNode)this.get((int)1)).mChannel.getV2();
            if (v3.equals((Object)v0) || v3.equals((Object)v1)) {
                poly.addPoint(v3P);
            } else {
                poly.addPoint(v3);
            }
            poly.addPoint(v0);
            poly.addPoint(v1);
            return poly;
        }

        protected ArrayList<FloodableNode> activeSideList() {
            ArrayList<FloodableNode> list = new ArrayList<FloodableNode>();
            for (int i = 0; i < 3; ++i) {
                if (((FloodableNode)this.get((int)i)).mNumLoads <= 0) continue;
                list.add((FloodableNode)this.get(i));
            }
            return list;
        }

        protected int activeSides() {
            int activeSides = 0;
            activeSides += ((FloodableNode)this.get((int)0)).mNumLoads;
            activeSides += ((FloodableNode)this.get((int)1)).mNumLoads;
            return activeSides += ((FloodableNode)this.get((int)2)).mNumLoads;
        }
    }

    protected static class Key
    extends APair<DeviceTemplate, Layer> {
        public Key(APair<DeviceTemplate, Layer> src) {
            super(src);
        }

        public Key(DeviceTemplate first, Layer second) {
            super((Object)first, (Object)second);
        }
    }

    protected class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void endUndoRedo(boolean isRedo) {
            mRouters.clear();
        }
    }

    public static enum RouteType {
        PACKAGEFC,
        PACKAGEWB,
        RDL,
        RDLCOMPACT,
        BOARD,
        UNKNOWN;

    }
}

