/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.google.common.collect.LinkedHashMultimap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Stats;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ui.wb_route.RoutePersonalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;

public class RouterConnectionOptimizer {
    protected LinkedList<HierPort> fromPins = new LinkedList();
    protected LinkedList<HierPort> toPins = new LinkedList();
    protected HashMap<Net, Integer> net2IOPads = new HashMap();
    protected HashMap<HierPort, Net> ioPad2Net = new HashMap();
    protected HashMap<HierPort, APoint2D> port2Loc = new HashMap();
    protected ArrayList<Individual> population = new ArrayList();
    protected static final long clockTick = 3141592L;
    protected Random mRandom = new Random(3141592L);
    Db db = OrbitIO.getCurDb();
    Personality personality;
    protected boolean userStop = false;
    protected boolean running = true;
    protected static long popSize = 1L;
    protected static long generations = 4000L;
    protected boolean mAllowSwapping = false;
    boolean verticalInterface;
    static EquivalentPersonalityFunction epf = null;
    protected static LinkedList<LoadListener> sLoadListener = new LinkedList();

    public static void setEquivalentPersonalityFunction(EquivalentPersonalityFunction f) {
        epf = f;
    }

    public void loadFromPad(HierPort io) {
        if (!this.fromPins.contains(io)) {
            this.fromPins.add(io);
        } else {
            ALog.logInfo((String)"ignoring duplicate io pad");
        }
    }

    public void loadToPad(HierPort bump) {
        if (!this.toPins.contains(bump)) {
            this.toPins.add(bump);
        } else {
            ALog.logInfo((String)"ignoring duplicate bump");
        }
    }

    public void allowSwapping(boolean allowSwapping) {
        this.mAllowSwapping = allowSwapping;
    }

    public void setPersonality(Personality personality) {
        this.personality = personality;
    }

    public void stop() {
        this.userStop = true;
    }

    public static void setParam(long p, long g) {
        popSize = p;
        generations = g;
    }

    public boolean go(RoutePersonalizer rp) {
        this.userStop = false;
        this.running = true;
        int numFrom = this.fromPins.size();
        int numTo = this.toPins.size();
        if (numFrom == 0) {
            ALog.logInfo((String)"No optimization possible, as there are no io pads");
            return false;
        }
        if (numTo == 0) {
            ALog.logInfo((String)"No optimization possible, as there are no bump pads");
            return false;
        }
        ALog.logInfo((String)"There are %d %ss and %d %ss", (Object[])new Object[]{numFrom, rp.getColumnFromName(), numTo, rp.getColumnToName()});
        Optimizer o = new Optimizer();
        o.run();
        this.shutMeDown();
        return true;
    }

    protected void shutMeDown() {
        RouterConnectionOptimizer.updateProgress(true, 1.0, "Optimization Finished");
    }

    protected void removeNetsOnBumps() {
        for (HierPort toPad : this.toPins) {
            Net parentNet = NetMap.getParentNet((Device)toPad.getPath().getLast(), (Net)toPad.getDPort().getPinTemplate().getNet());
            if (parentNet != null) {
                NetMap.unmap((Device)toPad.getPath().getLast(), (Net)toPad.getDPort().getPinTemplate().getNet(), (Net)parentNet);
            }
            toPad.getDPort().getPinTemplate().setNet(toPad.getPath().getDeviceTemplate().getNetUnused());
        }
    }

    public ArrayList<SchedConn> getBest(Personality schedConnOwner) {
        Collections.sort(this.population, new PopulationSorter());
        this.population.get(0).printMe();
        return this.population.get(0).results(schedConnOwner);
    }

    protected void determinePortLoc() {
        for (HierPort ioPad : this.fromPins) {
            this.port2Loc.put(ioPad, new APoint2D(ioPad.getWorldLoc()));
        }
        for (HierPort bump : this.toPins) {
            this.port2Loc.put(bump, new APoint2D(bump.getWorldLoc()));
        }
    }

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    protected static void firePercentUpdate(int percent, boolean done, String data) {
        for (LoadListener l : sLoadListener) {
            l.stats(percent, done, data);
        }
    }

    public static void updateProgress(boolean done, double percent, String data) {
        int iPercent = (int)(percent * 100.0);
        RouterConnectionOptimizer.firePercentUpdate(iPercent, done, data);
    }

    public class CandidateBumpSorter
    implements Comparator<HierPort> {
        final HierPort io;

        public CandidateBumpSorter(HierPort io) {
            this.io = io;
        }

        @Override
        public int compare(HierPort a, HierPort b) {
            IO2Bump ioa = new IO2Bump(this.io, a);
            IO2Bump iob = new IO2Bump(this.io, b);
            ALine va = ioa.getLine();
            ALine vb = iob.getLine();
            long aLength = Math.abs(va.getLength());
            long bLength = Math.abs(vb.getLength());
            return Long.compare(aLength, bLength);
        }
    }

    class Individual {
        int mutateAttempt = 0;
        int mutateAccept = 0;
        ArrayList<IO2Bump> bestMapping = new ArrayList();
        AHashToInteger<HierPort> numOnBump = new AHashToInteger();
        LinkedList<HierPort> fromPads = new LinkedList();
        LinkedList<HierPort> toPads = new LinkedList();
        LinkedHashMultimap<HierPort, HierPort> fromToCandidates = LinkedHashMultimap.create();
        LinkedHashMultimap<HierPort, HierPort> toFromCandidates = LinkedHashMultimap.create();
        boolean allowSwapping = false;
        double penalty;
        String myName;
        LinkedList<String> debugNets = new LinkedList();
        LinkedList<IO2Bump> mapsToBumpBeingSwapped = new LinkedList();
        IO2Bump oneToSwap = null;

        Individual() {
        }

        public void allowSwapping(boolean allowSwapping) {
            this.allowSwapping = allowSwapping;
        }

        public void populate(String myName, LinkedList<HierPort> fromPads, LinkedList<HierPort> toPads) {
            this.myName = myName;
            this.setSets(fromPads, toPads);
            this.setInitialConnections();
            this.determineScore();
        }

        protected void setSets(LinkedList<HierPort> ioPads, LinkedList<HierPort> bumps) {
            this.fromPads.addAll(ioPads);
            this.toPads.addAll(bumps);
        }

        public void printMe() {
            Stats stats = new Stats();
            for (IO2Bump io2Bump : this.bestMapping) {
                if (io2Bump.getLine() == null) continue;
                stats.add((double)Math.abs(io2Bump.getLine().getLength() / Design.getInternalPerMicron((Db)RouterConnectionOptimizer.this.db)));
            }
            stats.go();
            ALog.logInfo((String)stats.toString());
        }

        protected HierPort getBump(HierPort ioPad) {
            for (int i = 0; i < this.bestMapping.size(); ++i) {
                if (this.bestMapping.get((int)i).io != ioPad) continue;
                return this.bestMapping.get((int)i).bump;
            }
            return null;
        }

        protected HierPort getIO(HierPort bumpPad) {
            for (int i = 0; i < this.bestMapping.size(); ++i) {
                if (this.bestMapping.get((int)i).bump != bumpPad) continue;
                return this.bestMapping.get((int)i).io;
            }
            return null;
        }

        IO2Bump getMapping(HierPort ioPad) {
            for (int i = 0; i < this.bestMapping.size(); ++i) {
                if (this.bestMapping.get((int)i).io != ioPad) continue;
                return this.bestMapping.get(i);
            }
            return null;
        }

        protected void determinMapsToThisBump(HierPort bump) {
            this.mapsToBumpBeingSwapped.clear();
            for (IO2Bump io2Bump : this.bestMapping) {
                if (io2Bump.bump != bump) continue;
                this.mapsToBumpBeingSwapped.add(io2Bump);
            }
            this.determineTheOneToSwap(bump);
        }

        protected void determineTheOneToSwap(HierPort bump) {
            int maxWiresPerBump = this.getWiresPerNet(bump.getSubstrateNet());
            if (maxWiresPerBump == this.mapsToBumpBeingSwapped.size()) {
                int oneToMove = RouterConnectionOptimizer.this.mRandom.nextInt(this.mapsToBumpBeingSwapped.size());
                this.oneToSwap = this.mapsToBumpBeingSwapped.get(oneToMove);
            } else {
                this.oneToSwap = null;
            }
        }

        protected double proposeMove(HierPort ioA, HierPort bumpB) {
            double total = 0.0;
            IO2Bump mappingA = null;
            IO2Bump mappingB = null;
            this.determinMapsToThisBump(bumpB);
            for (IO2Bump io2Bump : this.bestMapping) {
                if (mappingA == null && io2Bump.io != null && io2Bump.io.equals((Object)ioA)) {
                    mappingA = io2Bump;
                    continue;
                }
                if (io2Bump.equals(this.oneToSwap)) {
                    mappingB = io2Bump;
                    continue;
                }
                total += (double)io2Bump.getPenalty();
            }
            IO2Bump t1 = new IO2Bump(ioA, bumpB);
            total += (double)t1.getPenalty();
            if (mappingB != null) {
                Objects.requireNonNull(mappingA);
                IO2Bump t2 = new IO2Bump(mappingB.io, mappingA.bump);
                total += (double)t2.getPenalty();
            }
            return total;
        }

        protected boolean validate() {
            for (IO2Bump io2Bump : this.bestMapping) {
                if (io2Bump.io == null || io2Bump.bump == null) continue;
                Net bumpNet = io2Bump.io.getSubstrateNet();
                for (IO2Bump other : this.bestMapping) {
                    if (other.io == null || other.bump == null || !other.bump.equals((Object)io2Bump.bump) || other.io.getSubstrateNet() == bumpNet) continue;
                    ALog.logInfo((String)"problem");
                }
            }
            for (IO2Bump io2Bump : this.bestMapping) {
                Personality pI;
                Personality pB;
                if (io2Bump.io == null || io2Bump.bump == null || this.samePersonality(pB = io2Bump.bump.getPin().getPersonality(), pI = io2Bump.io.getPin().getPersonality())) continue;
                ALog.logInfo((String)"problem");
            }
            return true;
        }

        protected void doMove(HierPort ioA, HierPort bumpB) {
            IO2Bump mappingA = null;
            for (IO2Bump io2Bump : this.bestMapping) {
                if (mappingA != null || io2Bump.io == null || !io2Bump.io.equals((Object)ioA)) continue;
                mappingA = io2Bump;
            }
            if (this.oneToSwap != null) {
                Objects.requireNonNull(mappingA);
                HierPort temp = mappingA.bump;
                mappingA.bump = this.oneToSwap.bump;
                this.oneToSwap.bump = temp;
            } else {
                Objects.requireNonNull(mappingA);
                mappingA.bump = bumpB;
            }
        }

        public Cost costOf(IO2Bump candidate, IO2Bump ignore) {
            Cost cost = new Cost();
            int num = 0;
            ALine l = candidate.getLine();
            if (l == null) {
                return cost;
            }
            long totalLength = 0L;
            for (int i = 0; i < this.bestMapping.size(); ++i) {
                ALine c;
                IO2Bump mapping = this.bestMapping.get(i);
                if (ignore.equals(mapping)) {
                    totalLength += l.getLength();
                }
                if ((c = mapping.getLine()) == null) continue;
                totalLength += c.getLength();
                if (!l.crossIntersects(c)) continue;
                ++num;
            }
            cost.crosses = num;
            cost.length = totalLength;
            return cost;
        }

        public boolean canSwap(IO2Bump a, IO2Bump b) {
            HierPort aIO = a.io;
            HierPort aBump = a.bump;
            HierPort bIO = b.io;
            HierPort bBump = b.bump;
            if (aIO != null && aBump != null) {
                if (bIO != null) {
                    return this.fromToCandidates.get((Object)aIO).contains(bBump);
                }
                if (bBump != null) {
                    return this.toFromCandidates.get((Object)bBump).contains(aIO);
                }
            }
            if (bIO != null && bBump != null) {
                if (aIO != null) {
                    return this.fromToCandidates.get((Object)aIO).contains(bBump);
                }
                if (aBump != null) {
                    return this.toFromCandidates.get((Object)aBump).contains(bIO);
                }
            }
            return true;
        }

        public int numConnected(HierPort bump) {
            return this.numOnBump.value(bump);
        }

        protected int doSwapsOnBumpContainingMultipleWires(IO2Bump a, IO2Bump b) {
            if (a.bump == null || b.bump == null) {
                return 0;
            }
            if (a.bump == b.bump) {
                return 0;
            }
            if (!this.samePersonality(a.bump.getPin().getPersonality(), b.bump.getPin().getPersonality())) {
                return 0;
            }
            double before = this.determineScoreByCrossing();
            HierPort aBump = new HierPort(a.bump);
            HierPort bBump = new HierPort(b.bump);
            HashSet<IO2Bump> toABuff = new HashSet<IO2Bump>(2);
            HashSet<IO2Bump> toBBuff = new HashSet<IO2Bump>(2);
            for (IO2Bump io2Bump : this.bestMapping) {
                if (io2Bump.bump == null) continue;
                if (io2Bump.bump.equals((Object)aBump)) {
                    toABuff.add(io2Bump);
                    continue;
                }
                if (!io2Bump.bump.equals((Object)bBump)) continue;
                toBBuff.add(io2Bump);
            }
            IO2Bump[] toA = toABuff.toArray(new IO2Bump[toABuff.size()]);
            IO2Bump[] toB = toBBuff.toArray(new IO2Bump[toBBuff.size()]);
            int onA = this.numConnected(a.bump);
            int onB = this.numConnected(b.bump);
            HierPort temp = a.bump;
            for (IO2Bump io2Bump : toA) {
                io2Bump.bump = b.bump;
            }
            for (IO2Bump io2Bump : toB) {
                io2Bump.bump = temp;
            }
            boolean better = false;
            long after = this.determineScoreByCrossingLimit((long)before);
            if ((double)after >= before) {
                HierPort temp1 = b.bump;
                HierPort temp2 = a.bump;
                for (IO2Bump io2Bump : toA) {
                    io2Bump.bump = temp1;
                }
                for (IO2Bump io2Bump : toB) {
                    io2Bump.bump = temp2;
                }
            } else {
                this.penalty = after;
                better = true;
                this.numOnBump.set(aBump, onB);
                this.numOnBump.set(bBump, onA);
            }
            if (better) {
                return 1;
            }
            return 0;
        }

        protected boolean everybodyOnSameNet(IO2Bump a, IO2Bump b) {
            Net aNet = null;
            for (IO2Bump io2Bump : this.bestMapping) {
                if (io2Bump.bump != a.bump || io2Bump.io == null) continue;
                aNet = io2Bump.io.getSubstrateNet();
                break;
            }
            if (aNet != null) {
                for (IO2Bump io2Bump : this.bestMapping) {
                    if (io2Bump.bump != b.bump || io2Bump.io == null) continue;
                    Net bNet = io2Bump.io.getSubstrateNet();
                    return bNet == aNet;
                }
            }
            return true;
        }

        protected void greedy() {
            int maxPass = 300;
            boolean lastPass = false;
            double totalImprove = 0.0;
            double lastImprove = 0.0;
            for (IO2Bump c : this.bestMapping) {
                if (c.bump == null) continue;
                this.numOnBump.incr(c.bump);
            }
            for (int pass = 0; pass < maxPass; ++pass) {
                double improve = 0.0;
                int size = this.bestMapping.size();
                for (int i = 0; i < size; ++i) {
                    for (int j = i + 1; j < size; ++j) {
                        IO2Bump b;
                        IO2Bump a;
                        if (i == j || !this.canSwap(a = this.bestMapping.get(i), b = this.bestMapping.get(j))) continue;
                        boolean canSwapIndividuals = true;
                        if (this.numConnected(a.bump) > 1 || this.numConnected(b.bump) > 1) {
                            canSwapIndividuals = false;
                            if (this.everybodyOnSameNet(this.bestMapping.get(i), this.bestMapping.get(j))) {
                                canSwapIndividuals = true;
                            } else if (this.doSwapsOnBumpContainingMultipleWires(this.bestMapping.get(i), this.bestMapping.get(j)) > 0) {
                                totalImprove += 1.0;
                                improve += 1.0;
                            }
                        }
                        if (canSwapIndividuals) {
                            ALine lA = a.getLine();
                            ALine lB = b.getLine();
                            if (lA == null && lB == null) continue;
                            if (lA == null || lB == null) {
                                HierPort temp;
                                Cost newC;
                                IO2Bump proposed;
                                Cost oldC;
                                if (lA != null) {
                                    oldC = this.costOf(a, a);
                                    if (b.bump != null) {
                                        proposed = new IO2Bump(a.io, b.bump);
                                        newC = this.costOf(proposed, a);
                                        if (newC.better(oldC)) {
                                            temp = a.bump;
                                            a.bump = b.bump;
                                            b.bump = temp;
                                            improve += 1.0;
                                            totalImprove += 1.0;
                                            this.numOnBump.incr(b.bump);
                                            this.numOnBump.decr(a.bump);
                                        }
                                    } else {
                                        proposed = new IO2Bump(b.io, a.bump);
                                        newC = this.costOf(proposed, a);
                                        if (newC.better(oldC)) {
                                            temp = a.io;
                                            a.io = b.io;
                                            b.io = temp;
                                            improve += 1.0;
                                            totalImprove += 1.0;
                                        }
                                    }
                                } else {
                                    oldC = this.costOf(b, b);
                                    if (a.bump != null) {
                                        proposed = new IO2Bump(b.io, a.bump);
                                        newC = this.costOf(proposed, b);
                                        if (newC.better(oldC)) {
                                            temp = b.bump;
                                            b.bump = a.bump;
                                            a.bump = temp;
                                            improve += 1.0;
                                            totalImprove += 1.0;
                                            this.numOnBump.incr(a.bump);
                                            this.numOnBump.decr(b.bump);
                                        }
                                    } else {
                                        proposed = new IO2Bump(a.io, b.bump);
                                        newC = this.costOf(proposed, b);
                                        if (newC.better(oldC)) {
                                            temp = b.io;
                                            b.io = a.io;
                                            a.io = temp;
                                            improve += 1.0;
                                            totalImprove += 1.0;
                                        }
                                    }
                                }
                            } else if (lA.crossIntersects(lB)) {
                                HierPort temp = a.bump;
                                a.bump = b.bump;
                                b.bump = temp;
                                improve += 1.0;
                                totalImprove += 1.0;
                            }
                        }
                        if (lastImprove != totalImprove) {
                            String percent = (int)((double)pass / (double)maxPass * 100.0) + "%";
                            RouterConnectionOptimizer.updateProgress(false, (double)pass / (double)maxPass, percent + " Accepted:" + totalImprove);
                        }
                        lastImprove = totalImprove;
                    }
                }
                if (lastPass) {
                    this.validate();
                    return;
                }
                if (improve != 0.0) continue;
                if (lastPass) {
                    RouterConnectionOptimizer.updateProgress(true, 1.0, "Found Solution");
                    this.validate();
                    return;
                }
                lastPass = true;
            }
        }

        public void mutate() {
            ++this.mutateAttempt;
            HierPort ioA = this.fromPads.get(RouterConnectionOptimizer.this.mRandom.nextInt(this.fromPads.size()));
            HierPort bumpA = this.getBump(ioA);
            if (this.fromToCandidates.get((Object)ioA).size() == 0) {
                return;
            }
            LinkedList list = AUtil.linkedList((Collection)this.fromToCandidates.get((Object)ioA));
            HierPort bumpB = (HierPort)list.get(RouterConnectionOptimizer.this.mRandom.nextInt(this.fromToCandidates.get((Object)ioA).size()));
            double beforePenalty = this.determineScoreByCrossing();
            if (bumpA != bumpB) {
                this.determinMapsToThisBump(bumpB);
                this.doMove(ioA, bumpB);
                double afterPenalty = this.determineScoreByCrossing();
                if (afterPenalty < beforePenalty) {
                    ++this.mutateAccept;
                } else {
                    this.doMove(ioA, bumpB);
                }
            }
        }

        public ArrayList<SchedConn> results(Personality owner) {
            ArrayList<SchedConn> ret = new ArrayList<SchedConn>();
            for (IO2Bump c : this.bestMapping) {
                SchedConn sc = new SchedConn();
                sc.setOwner((DbObject)owner);
                if (c.io != null) {
                    sc.setPortA(c.io.getPath(), c.io.getDPort());
                }
                if (c.bump != null) {
                    sc.setPortB(c.bump.getPath(), c.bump.getDPort());
                }
                ret.add(sc);
            }
            return ret;
        }

        protected boolean samePersonality(IO2Bump a, IO2Bump b) {
            Personality p1 = null;
            Personality p2 = null;
            if (a.bump != null) {
                p1 = a.bump.getPin().getPersonality();
            }
            if (b.bump != null) {
                p2 = b.bump.getPin().getPersonality();
            }
            return this.samePersonality(p1, p2);
        }

        protected boolean samePersonality(Personality p1, Personality p2) {
            return true;
        }

        protected void setInitialConnections() {
            int ioPadIdx = 0;
            int numIOPads = this.fromPads.size();
            for (HierPort ioPad : this.fromPads) {
                int p;
                Personality ioPadPersonality = ioPad.getPin().getPersonality();
                for (HierPort bumpPad : RouterConnectionOptimizer.this.toPins) {
                    if (this.allowSwapping) {
                        Personality bumpPadPersonality = bumpPad.getPin().getPersonality();
                        if (!this.samePersonality(bumpPadPersonality, ioPadPersonality)) continue;
                        this.fromToCandidates.put((Object)ioPad, (Object)bumpPad);
                        this.toFromCandidates.put((Object)bumpPad, (Object)ioPad);
                        continue;
                    }
                    if (!ioPad.getSubstrateNet().equals(bumpPad.getSubstrateNet())) continue;
                    this.fromToCandidates.put((Object)ioPad, (Object)bumpPad);
                    this.toFromCandidates.put((Object)bumpPad, (Object)ioPad);
                }
                if (this.fromToCandidates.get((Object)ioPad).isEmpty()) {
                    ALog.logInfo((String)(ioPad.getPin().getName() + " Can not find any bumps that are acceptable"));
                }
                if ((p = (int)((double)(++ioPadIdx) / (double)numIOPads * 100.0)) % 5 != 0) continue;
                String percent = p + " %";
                RouterConnectionOptimizer.updateProgress(false, (double)ioPadIdx / (double)numIOPads, percent + " Setting up Optimization");
            }
            AHashToInteger<HierPort> wiresOnBump = new AHashToInteger<HierPort>();
            HashMap<HierPort, Net> bumpToNet = new HashMap<HierPort, Net>();
            for (HierPort bump : this.toPads) {
                wiresOnBump.put(bump, 0);
                bumpToNet.put(bump, null);
            }
            RouterConnectionOptimizer.updateProgress(false, 0.0, "Determining Initial Results");
            int unmappedIO = 0;
            for (HierPort ioPad : this.fromPads) {
                Net ioPadNet = ioPad.getSubstrateNet();
                int wiresPerBumpNeeded = this.getWiresPerNet(ioPad);
                HierPort connectedBump = null;
                LinkedList candidates = AUtil.linkedList((Collection)this.fromToCandidates.get((Object)ioPad));
                Collections.sort(candidates, new CandidateBumpSorter(ioPad));
                HierPort bestBump = null;
                long bestDist = 0L;
                for (HierPort bump : candidates) {
                    Net currentNet;
                    int numOnBump = wiresOnBump.value(bump);
                    if (numOnBump >= wiresPerBumpNeeded || numOnBump > 0 && !ioPadNet.equals(currentNet = (Net)bumpToNet.get(bump))) continue;
                    long thisDist = Math.abs(ioPad.getWorldLoc().distance(bump.getWorldLoc()));
                    if (bestBump == null) {
                        bestBump = bump;
                        bestDist = thisDist;
                        continue;
                    }
                    if (thisDist >= bestDist) continue;
                    bestBump = bump;
                    bestDist = thisDist;
                }
                connectedBump = bestBump;
                if (connectedBump != null) {
                    wiresOnBump.incr(connectedBump);
                    bumpToNet.put(connectedBump, ioPad.getSubstrateNet());
                } else {
                    ++unmappedIO;
                }
                IO2Bump con = new IO2Bump(ioPad, connectedBump);
                this.bestMapping.add(con);
            }
            if (unmappedIO == 1) {
                ALog.logWarn((String)("There is " + unmappedIO + " IOPad that have no associated bump"));
            }
            if (unmappedIO > 1) {
                ALog.logWarn((String)("There are " + unmappedIO + " IOPads that have no associated bump"));
            }
            this.validate();
        }

        protected int getWiresPerNet(Net n) {
            for (HierPort ioPad : this.fromPads) {
                if (!RouterConnectionOptimizer.this.ioPad2Net.get(ioPad).equals(n)) continue;
                return this.getWiresPerNet(ioPad);
            }
            return 1;
        }

        protected int getWiresPerNet(HierPort ioPad) {
            int maxRoutesForNet = 1;
            RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)ioPad.getPin());
            Constraint.MaxRoutesPerBump mrp = rs == null ? Constraint.MaxRoutesPerBump.One : (Constraint.MaxRoutesPerBump)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.MAX_WIRE_PER_PIN, null);
            maxRoutesForNet = mrp == Constraint.MaxRoutesPerBump.All ? 100 : (mrp == Constraint.MaxRoutesPerBump.One ? 1 : (mrp == Constraint.MaxRoutesPerBump.Two ? 2 : (mrp == Constraint.MaxRoutesPerBump.Three ? 3 : (mrp == Constraint.MaxRoutesPerBump.Four ? 4 : 1))));
            return maxRoutesForNet;
        }

        protected void printNet(String prelude, Net n) {
            ArrayList<HierPort> thisNetsIOPads = new ArrayList<HierPort>();
            ArrayList<HierPort> thisNetsBumpPads = new ArrayList<HierPort>();
            for (HierPort io : this.fromPads) {
                if (!RouterConnectionOptimizer.this.ioPad2Net.get(io).equals(n)) continue;
                thisNetsIOPads.add(io);
            }
            for (IO2Bump m : this.bestMapping) {
                if (!thisNetsIOPads.contains(m.io) || thisNetsBumpPads.contains(m.bump)) continue;
                thisNetsBumpPads.add(m.bump);
            }
        }

        protected void addConnection(HierPort io, HierPort bump) {
            IO2Bump c = new IO2Bump(io, bump);
            this.bestMapping.add(c);
        }

        protected double determineScore() {
            this.penalty = 0.0;
            for (int i = 0; i < this.bestMapping.size(); ++i) {
                this.penalty += (double)this.bestMapping.get(i).getPenalty();
            }
            return this.penalty;
        }

        protected double determineScoreByCrossing() {
            ALine lI;
            int i;
            this.penalty = 0.0;
            ArrayList<ALine> lines = new ArrayList<ALine>(this.bestMapping.size());
            for (i = 0; i < this.bestMapping.size(); ++i) {
                lI = this.bestMapping.get(i).getLine();
                if (lI == null) continue;
                lines.add(lI);
            }
            for (i = 0; i < lines.size(); ++i) {
                lI = (ALine)lines.get(i);
                for (int j = i + 1; j < lines.size(); ++j) {
                    ALine lJ = (ALine)lines.get(j);
                    if (!lI.crossIntersects(lJ)) continue;
                    this.penalty += 1.0;
                }
            }
            return this.penalty;
        }

        protected long determineScoreByCrossingLimit(long before) {
            ALine lI;
            int i;
            long penalty = 0L;
            ArrayList<ALine> lines = new ArrayList<ALine>(this.bestMapping.size());
            for (i = 0; i < this.bestMapping.size(); ++i) {
                lI = this.bestMapping.get(i).getLine();
                if (lI == null) continue;
                lines.add(lI);
            }
            for (i = 0; i < lines.size(); ++i) {
                lI = (ALine)lines.get(i);
                for (int j = i + 1; j < lines.size(); ++j) {
                    ALine lJ = (ALine)lines.get(j);
                    if (!lI.crossIntersects(lJ) || ++penalty <= before) continue;
                    return penalty;
                }
            }
            return penalty;
        }

        protected double determineScoreByLength() {
            this.penalty = 0.0;
            for (int i = 0; i < this.bestMapping.size(); ++i) {
                ALine lI = this.bestMapping.get(i).getLine();
                if (lI == null) continue;
                this.penalty += (double)Math.abs(lI.getLength());
            }
            return this.penalty;
        }

        protected class Cost {
            int crosses = 0;
            double length = 0.0;

            public boolean better(Cost other) {
                if (this.crosses < other.crosses) {
                    return true;
                }
                return this.crosses == other.crosses && this.length < other.length;
            }
        }

        class AHashToInteger<T>
        extends HashMap<T, Integer> {
            AHashToInteger() {
            }

            public void incr(T t) {
                if (t != null) {
                    int num = this.value(t);
                    this.put(t, ++num);
                }
            }

            public void decr(T t) {
                int num = this.value(t);
                this.put(t, --num);
            }

            public int value(T t) {
                Integer num = (Integer)this.get(t);
                int aNum = 0;
                if (num != null) {
                    aNum = num;
                }
                return aNum;
            }

            public void set(T t, int num) {
                this.put(t, num);
            }
        }
    }

    public static interface LoadListener {
        public void stats(int var1, boolean var2, String var3);
    }

    class PopulationSorter
    implements Comparator<Individual> {
        PopulationSorter() {
        }

        @Override
        public int compare(Individual arg0, Individual arg1) {
            return Double.compare(arg0.penalty, arg1.penalty);
        }
    }

    public class Optimizer {
        public void run() {
            Stopwatch stopwatch = new Stopwatch();
            if (epf != null) {
                ALog.logInfo((String)"Optimizing using %s personalitity equivalence", (Object[])new Object[]{epf.description()});
            }
            ARect r = new ARect();
            boolean first = true;
            for (HierPort hp : RouterConnectionOptimizer.this.toPins) {
                APoint2D c = hp.getWorldLoc();
                if (first) {
                    r.setLL(c);
                    r.setUR(c);
                    first = false;
                    continue;
                }
                r.expand(c);
            }
            Collections.sort(RouterConnectionOptimizer.this.fromPins, new CentroidSort(r.center()));
            Collections.sort(RouterConnectionOptimizer.this.toPins, new CentroidSort(r.center()));
            Random rand = new Random(314L);
            Collections.shuffle(RouterConnectionOptimizer.this.fromPins, rand);
            Collections.shuffle(RouterConnectionOptimizer.this.toPins, rand);
            if (RouterConnectionOptimizer.this.mAllowSwapping) {
                RouterConnectionOptimizer.this.removeNetsOnBumps();
            }
            RouterConnectionOptimizer.this.determinePortLoc();
            RouterConnectionOptimizer.updateProgress(false, 0.0, "Starting Optimization");
            int i = 0;
            while ((long)i < popSize) {
                Individual ind = new Individual();
                ind.allowSwapping(RouterConnectionOptimizer.this.mAllowSwapping);
                RouterConnectionOptimizer.this.population.add(ind);
                ind.populate("", RouterConnectionOptimizer.this.fromPins, RouterConnectionOptimizer.this.toPins);
                ind.greedy();
                ++i;
            }
            stopwatch.stop();
            ALog.logInfo((String)("Optimization time: " + Stopwatch.formatTime((long)stopwatch.elapsed())));
            RouterConnectionOptimizer.this.running = false;
        }
    }

    static class CentroidSort
    implements Comparator<HierPort> {
        final APoint2D c;

        public CentroidSort(APoint2D c) {
            this.c = c;
        }

        @Override
        public int compare(HierPort arg0, HierPort arg1) {
            long d0 = arg0.getWorldLoc().distance(this.c);
            long d1 = arg1.getWorldLoc().distance(this.c);
            return Long.compare(d0, d1);
        }
    }

    class IO2Bump {
        HierPort io;
        HierPort bump;

        public IO2Bump(IO2Bump io2Bump) {
            this.io = io2Bump.io;
            this.bump = io2Bump.bump;
        }

        public IO2Bump(HierPort io, HierPort bump) {
            this.io = io;
            this.bump = bump;
        }

        protected ALine getLine() {
            ALine l = null;
            APoint2D p0 = RouterConnectionOptimizer.this.port2Loc.get(this.io);
            APoint2D p1 = RouterConnectionOptimizer.this.port2Loc.get(this.bump);
            l = p0 != null && p1 != null ? new ALine(p0, p1) : null;
            return l;
        }

        public long getPenalty() {
            if (this.io == null) {
                return 0L;
            }
            if (this.bump == null) {
                return 0L;
            }
            ALine l = new ALine(RouterConnectionOptimizer.this.port2Loc.get(this.io), RouterConnectionOptimizer.this.port2Loc.get(this.bump));
            if (RouterConnectionOptimizer.this.verticalInterface) {
                return Math.abs(l.dX());
            }
            return Math.abs(l.dY());
        }
    }

    public static interface EquivalentPersonalityFunction {
        public boolean equivalent(Personality var1, Personality var2);

        public String description();
    }
}

