/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class RouterReportWriter {
    ReportMode mode = ReportMode.Full;
    String fileName = "rr.csv";

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMode(ReportMode mode) {
        this.mode = mode;
    }

    public void write() {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        ArrayList<SingleLayerRouter.RouteInformation> sortedRis = new ArrayList<SingleLayerRouter.RouteInformation>();
        for (SingleLayerRouter.RouteInformation ri : SingleLayerRouter.getSingleLayerRouter().getRouteInformation()) {
            sortedRis.add(ri);
        }
        Collections.sort(sortedRis, new RiNetSorter());
        try (FileWriter mFileWriter = new FileWriter(new File(this.fileName));){
            mFileWriter.write("Net,Routed,DRCClean,Layer,Width,Angle");
            mFileWriter.write("\n");
            for (SingleLayerRouter.RouteInformation ri : sortedRis) {
                mFileWriter.write(ri.getFrom().getNet().getName() + ",");
                if (ri.getSucess()) {
                    mFileWriter.write("true,");
                } else {
                    mFileWriter.write("false,");
                }
                if (this.mode != ReportMode.JustCompletion) {
                    if (ri.drcOk) {
                        mFileWriter.write("true,");
                    } else {
                        mFileWriter.write("false,");
                    }
                    if (ri.getSucess()) {
                        mFileWriter.write(ri.getWire().getLayer().getName());
                    } else {
                        mFileWriter.write("NA");
                    }
                    mFileWriter.write(",");
                    if (ri.getSucess()) {
                        long width = ri.getWire().getPath().getWidth();
                        mFileWriter.write(unit.toUser(width) + ",");
                        int angle = ri.getWire().getPath().angle();
                        if (angle == 90) {
                            mFileWriter.write("90,");
                        } else if (angle == 45) {
                            mFileWriter.write("45,");
                        } else {
                            mFileWriter.write("Any,");
                        }
                    } else {
                        mFileWriter.write("NA,");
                        mFileWriter.write("NA,");
                    }
                    if (this.mode != ReportMode.Regression) {
                        long length = ri.getWire().getPath().getLength();
                        mFileWriter.write(unit.toUser(length) + ",");
                    }
                }
                mFileWriter.write("\n");
            }
        }
        catch (IOException e) {
            ALog.logError((String)("Can not open " + this.fileName + " for writing"));
        }
    }

    public static enum ReportMode {
        Full,
        Regression,
        JustCompletion;

    }

    public class RiNetSorter
    implements Comparator<SingleLayerRouter.RouteInformation> {
        @Override
        public int compare(SingleLayerRouter.RouteInformation ri0, SingleLayerRouter.RouteInformation ri1) {
            AAlphaNumComp c = AAlphaNumComp.get();
            return c.compare((Object)ri0.getFrom().getNet().getName(), (Object)ri1.getFrom().getNet().getName());
        }
    }
}

