/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.delaunay.ADelauneyEdge;
import com.sigrity.acl.optimizer.Flooder;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.DebugOverlay;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouterDelaunay;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.ui.core.DesignView2D;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class SingleLayerRouter {
    protected static long CHANNEL_ROUNDING = 1L;
    protected Layer mLayer;
    protected ArrayList<Topstacle> mObstacles = null;
    protected ArrayList<RouteInformation> mRouteInfo = null;
    protected DevicePath mParent;
    protected Db mDb;
    protected RouteInformation mCurrentRI;
    protected SingleLayerRouterDelaunay<Topstacle, Channel> mChannels = new SingleLayerRouterDelaunay(Channel.class);
    protected UndirectedSparseGraph<FloodableNode, FloodGraphEdge> mFloodGraph = new UndirectedSparseGraph();
    protected ArrayList<FloodableNode> mFloodableNodes = new ArrayList();
    protected FloodableNode mStart = null;
    protected FloodableNode mEnd = null;
    protected Flooder mFlood = null;
    protected HashMap<Channel, FloodableNode> mChannelToFloodNode = new HashMap();
    protected ArrayList<FloodGraphEdge> mThisRouteFloodPaths = new ArrayList();
    protected static SingleLayerRouter mCurrentSingleLayerRouter;
    protected boolean mDebug = false;
    DebugOverlay overlay;
    protected HashMap<FloodableNode, ArrayList<Aisle>> floodableNodeToAisles = new HashMap();
    protected static final double InfiniteCost = -1.0;
    protected int mDebugCross = 0;
    protected ArrayList<FloodableNode> usedNodes = new ArrayList();
    protected HashSet<PrettyRouter.DelaunayRegion> regions = new HashSet();
    protected boolean mDebugFlood = false;
    protected int mPass = 0;
    protected int mMaxPass;
    protected boolean channelsValid = false;
    protected HashMap<Topstacle, FloodableNode> tackToFn = new HashMap();
    protected boolean mAllowBackDoor = true;
    protected static LinkedList<LoadListener> sLoadListener;

    public ArrayList<FloodableNode> getmFloodableNodes() {
        return this.mFloodableNodes;
    }

    public void setmFloodableNodes(ArrayList<FloodableNode> mFloodableNodes) {
        this.mFloodableNodes = mFloodableNodes;
    }

    public void allowBackDoor(boolean backDoor) {
        this.mAllowBackDoor = backDoor;
    }

    public Aisle createAisle(FloodableNode fn, int index, APoint2D p) {
        ArrayList<Aisle> aisles = this.floodableNodeToAisles.get(fn);
        if (aisles == null) {
            aisles = new ArrayList();
        }
        Aisle a = new Aisle(fn, index, p);
        aisles.add(a);
        this.floodableNodeToAisles.put(fn, aisles);
        return a;
    }

    public void maxPass(int maxPass) {
        this.mMaxPass = maxPass;
    }

    public void clearRoutes() {
        this.mThisRouteFloodPaths.clear();
        this.floodableNodeToAisles.clear();
        for (RouteInformation ri : this.mRouteInfo) {
            ri.removeWireFromDb();
        }
        boolean rebuildGraph = false;
        if (rebuildGraph) {
            this.mFloodableNodes.clear();
            this.mChannelToFloodNode = new HashMap();
            this.mFloodGraph = new UndirectedSparseGraph();
            SingleLayerRouter.updateProgress(false, 0.0, "Rebuilding Flood Graph");
            this.createFloodPaths();
            SingleLayerRouter.updateProgress(false, 0.0, "Analyzing Channels");
            this.calcCapacity();
            this.addExistingEtch();
            this.classifyFNs();
            this.createDiffPairData();
        } else {
            ArrayList<FloodableNode> removeNodes = new ArrayList<FloodableNode>();
            for (FloodableNode fn : this.mFloodableNodes) {
                if (fn.isChannel) {
                    fn.mLoad = 0L;
                    fn.mNumLoads = 0;
                    fn.clearBlocked();
                    fn.wireMaps.clear();
                    continue;
                }
                removeNodes.add(fn);
            }
            for (FloodableNode fn : removeNodes) {
                this.mFloodableNodes.remove(fn);
                this.mFloodGraph.removeVertex((Object)fn);
            }
        }
    }

    public void removeWiresUpdate() {
        if (this.overlay == null) {
            return;
        }
        this.overlay.mView.removeOverlay(this.overlay.mOverlay);
    }

    public void globalRoute(boolean useCurrentChannels, boolean addToDb) {
        this.route(useCurrentChannels, -1, addToDb);
    }

    public void globalRoute(boolean useCurrentChannels) {
        this.route(useCurrentChannels, -1, true);
    }

    public void suggestRoutes(RouteInformation ri, PotentialPathListener l) {
        FloodGraphEdge e;
        if (!this.channelsValid) {
            this.buildValidChannels();
        }
        this.mCurrentRI = ri;
        this.addThisRouteFloodPath();
        FloodableNode fn = this.tackToFn.get(ri.getTo());
        if (fn != null) {
            e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
            this.mFloodGraph.addEdge((Object)e, (Object)this.mEnd, (Object)fn);
            this.mThisRouteFloodPaths.add(e);
        }
        if ((fn = this.tackToFn.get(ri.getFrom())) != null) {
            e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
            this.mFloodGraph.addEdge((Object)e, (Object)this.mStart, (Object)fn);
            this.mThisRouteFloodPaths.add(e);
        }
        this.floodAllPotentialPaths(l);
        this.removeThisRouteFloodPath();
    }

    protected Aisle floodAllPotentialPaths(PotentialPathListener l) {
        FloodableNode fn;
        FloodTree.FloodTreeNode ftn;
        Aisle a = null;
        this.debugView();
        Aisle start = this.createAisle(this.mStart, 0, this.mStart.mP);
        FloodTree floodTree = new FloodTree();
        floodTree.add(null, start, 0.0, 0.0);
        boolean success = false;
        while (!success && (ftn = floodTree.pop()) != null && ((fn = (a = ftn.me).getFloodableNode()) != this.mEnd || l.notifyPotentialPath(this.createAPath(ftn)))) {
            Collection frontierCollection = this.mFloodGraph.getNeighbors((Object)fn);
            ArrayList<FloodableNode> frontier = new ArrayList<FloodableNode>();
            for (FloodableNode f : frontierCollection) {
                frontier.add(f);
            }
            Collections.sort(frontier);
            for (FloodableNode f : frontier) {
                ArrayList<FloodCost> floodCosts = this.floodCost(a, f, false);
                for (FloodCost fc : floodCosts) {
                    if (fc.cost == -1.0) continue;
                    Aisle aisle = this.createAisle(f, fc.toIndex, fc.from);
                    floodTree.add(ftn, aisle, fc.cost, fc.remainingCost);
                }
            }
        }
        if (success) {
            return a;
        }
        return null;
    }

    protected void buildValidChannels() {
        Channel.EdgeId = 0;
        FloodableNode.resetID();
        SingleLayerRouter.updateProgress(false, 0.0, "Building Channels");
        this.createChannels();
        SingleLayerRouter.updateProgress(false, 0.0, "Building Flood Graph");
        this.createFloodPaths();
        SingleLayerRouter.updateProgress(false, 0.0, "Analyzing Channels");
        this.calcCapacity();
        this.classifyFNs();
        this.createDiffPairData();
        this.addExistingEtch();
        this.channelsValid = true;
    }

    public void route(boolean useCurrentChannels, int pass) {
        this.route(useCurrentChannels, pass, true);
    }

    public void route(boolean useCurrentChannels, int pass, boolean addToDb) {
        this.mPass = pass;
        if (!useCurrentChannels || !this.channelsValid) {
            this.buildValidChannels();
        }
        int total = this.mRouteInfo.size();
        int i = 0;
        int failures = 0;
        int debugIth = -1;
        for (RouteInformation ri : this.mRouteInfo) {
            double percent;
            int pInt;
            if (ri.getNet().isUnused()) {
                ri.setSucess(false);
                ALog.logWarn((String)("Route from " + ri.getFrom().toPinInstance().getName() + " is on NetUnused and can not be routed."));
                continue;
            }
            if (ri.getIgnore()) continue;
            DeviceTemplate dt = ri.getNet().getDeviceTemplate();
            DevicePath dp = dt.getPathToPresentUser();
            ri.setDiffPair(Net.isDiffPair((Net)ri.getNet(), (DevicePath)dp));
            if (++i == debugIth) {
                this.mDebug = true;
                OrbitIO.getApp().refreshCurrentView(true);
            } else {
                this.mDebug = false;
                this.mDebugFlood = false;
            }
            Net n = ri.getNet();
            if (this.mDebug) {
                ALog.logInfo((String)(n.getName() + " " + i));
            }
            if (this.mPass == -1 && (pInt = (int)((percent = (double)i / (double)total) * 100.0)) % 5 == 0) {
                SingleLayerRouter.updateProgress(false, percent, n.getName());
            }
            this.mCurrentRI = ri;
            ri.iTh = i;
            this.addThisRouteFloodPath1();
            Aisle endAisle = this.flood();
            ri.setSucess(endAisle != null);
            if (ri.getSucess()) {
                boolean reasonalblePath = this.createWires(endAisle, addToDb);
                if (!reasonalblePath) {
                    ++failures;
                    ri.setSucess(false);
                }
            } else {
                ++failures;
            }
            this.removeThisRouteFloodPath();
            if (i != debugIth) continue;
            OrbitIO.getApp().refreshCurrentView(true);
            this.mDebug = true;
        }
        if (this.mPass == -1) {
            SingleLayerRouter.updateProgress(true, 100.0, "Failed to complete " + failures + " of " + total);
        }
    }

    protected APath createAPath(FloodTree.FloodTreeNode end) {
        int i;
        ArrayList<Aisle> bestPath = new ArrayList<Aisle>();
        bestPath.add(end.me);
        FloodTree.FloodTreeNode node = end;
        while (node != null) {
            bestPath.add(node.me);
            node = node.parent;
        }
        for (i = 0; i < bestPath.size() - 1; ++i) {
            int j = i + 1;
            while (j < bestPath.size()) {
                if (((Aisle)bestPath.get((int)i)).fn == ((Aisle)bestPath.get((int)j)).fn) {
                    bestPath.remove(j);
                    continue;
                }
                ++j;
            }
        }
        for (i = 1; i < bestPath.size() - 1; ++i) {
            FloodableNode third;
            FloodableNode prev = ((Aisle)bestPath.get((int)(i - 1))).fn;
            FloodableNode thisNode = ((Aisle)bestPath.get((int)i)).fn;
            FloodableNode nextNode = ((Aisle)bestPath.get((int)(i + 1))).fn;
            if (!prev.isChannel || !thisNode.isChannel || nextNode != (third = this.getThirdLeg(prev, thisNode))) continue;
            bestPath.remove(i);
            --i;
        }
        if (bestPath.size() > 3) {
            bestPath.remove(bestPath.size() - 2);
            bestPath.remove(1);
        }
        if (this.mCurrentRI.bestPath == null) {
            this.mCurrentRI.bestPath = bestPath;
        }
        APath p = new APath();
        p.setWidth(this.mCurrentRI.getClear() + this.mCurrentRI.getWidth() + this.mCurrentRI.getClear());
        for (Aisle a : bestPath) {
            FloodableNode fn = a.getFloodableNode();
            p.addPoint(fn.mP);
        }
        return p;
    }

    protected PinInstance makeATemplateConnector(Device d, Net n, APoint2D p) {
        PinTemplate pt = PinTemplate.create((Net)n, (String)"c");
        PinInstance pi = PinInstance.getPinInstance((Device)d, (PinTemplate)pt);
        pt.setLoc(p);
        return pi;
    }

    protected boolean createAWireFromBestPath(ArrayList<Aisle> bestPath, boolean addToDb) {
        FloodableNode lastNode = null;
        FloodableNode nextNode = null;
        if (!this.validatePath(bestPath)) {
            return false;
        }
        int i = 0;
        APath p = new APath(this.mCurrentRI.getWidth());
        Net n = this.mCurrentRI.getNet();
        Wire w = new Wire(n, this.mLayer, p);
        for (Aisle a : bestPath) {
            FloodableNode fn = a.getFloodableNode();
            if (this.mDebugFlood) {
                ALog.logInfo((String)("flood path:" + fn.mId));
            }
            lastNode = i == 0 ? null : bestPath.get(i - 1).getFloodableNode();
            nextNode = i > bestPath.size() - 2 ? null : bestPath.get(i + 1).getFloodableNode();
            p.addPoint(fn.mP);
            fn.addWire(w, a.getIndex(), lastNode, nextNode, fn.mP);
            ++i;
        }
        DeviceTemplate wireDeviceTemplate = n.getDeviceTemplate();
        HierPin hPinA = this.mCurrentRI.getFrom().toDevicePathPort();
        w.setPinA(StoredPath.get((DevicePath)hPinA.getPath().getRelativePathFromAnchor(wireDeviceTemplate)), hPinA.getPinTemplate());
        HierPin hPinB = this.mCurrentRI.getTo().toDevicePathPort();
        w.setPinB(StoredPath.get((DevicePath)hPinB.getPath().getRelativePathFromAnchor(wireDeviceTemplate)), hPinB.getPinTemplate());
        if (this.mDebug) {
            ALog.logInfo((String)"Best Path");
            for (Aisle a : bestPath) {
                ALog.logInfo((String)a.fn.printNode());
            }
            ALog.logInfo((String)"Best Path");
        }
        FloodableNode startNode = bestPath.get(1).getFloodableNode();
        FloodableNode endNode = bestPath.get(bestPath.size() - 2).getFloodableNode();
        if (((Topstacle)startNode.mChannel.getP1()).sameOwner(this.mCurrentRI.getTo())) {
            startNode.mStartBlocked = true;
            startNode.startWires.add(w);
        }
        if (((Topstacle)startNode.mChannel.getP2()).sameOwner(this.mCurrentRI.getTo())) {
            startNode.mEndBlocked = true;
            startNode.endWires.add(w);
        }
        if (((Topstacle)endNode.mChannel.getP1()).sameOwner(this.mCurrentRI.getFrom())) {
            endNode.startWires.add(w);
            endNode.mStartBlocked = true;
        }
        if (((Topstacle)endNode.mChannel.getP2()).sameOwner(this.mCurrentRI.getFrom())) {
            endNode.endWires.add(w);
            endNode.mEndBlocked = true;
        }
        if (startNode == endNode) {
            startNode.mBothBlocked = true;
        }
        this.mCurrentRI.setWire(w);
        this.mCurrentRI.calcEfficiency();
        this.mCurrentRI.calcLoopiness();
        if (addToDb) {
            this.mDb.add((DbObject)w);
        }
        return true;
    }

    protected boolean createWires(Aisle endAisle, boolean addToDb) {
        ArrayList<Aisle> bestPath = new ArrayList<Aisle>();
        for (Flooder.FloodSpace fs : this.mFlood.getBestPath(endAisle)) {
            bestPath.add((Aisle)fs);
        }
        return this.createAWireFromBestPath(bestPath, addToDb);
    }

    protected void removeSameRegionVertices(ArrayList<Aisle> path) {
    }

    protected boolean validatePath(ArrayList<Aisle> path) {
        for (int i = 0; i < path.size(); ++i) {
            Aisle aI = path.get(i);
            for (int j = i + 1; j < path.size(); ++j) {
                Aisle aJ = path.get(j);
                if (aI.fn != aJ.fn) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isP1Common(Channel a, Channel b) {
        return a.getP1() == b.getP1();
    }

    protected boolean isP2Common(Channel a, Channel b) {
        return a.getP2() == b.getP2();
    }

    protected Topstacle anchor(FloodableNode e1, FloodableNode e2) {
        Channel c1 = e1.mChannel;
        Channel c2 = e2.mChannel;
        if (c1.getP1() == c2.getP1()) {
            return (Topstacle)c1.getP1();
        }
        if (c1.getP1() == c2.getP2()) {
            return (Topstacle)c1.getP1();
        }
        if (c1.getP2() == c2.getP1()) {
            return (Topstacle)c1.getP2();
        }
        if (c2.getP2() == c1.getP2()) {
            return (Topstacle)c2.getP2();
        }
        return null;
    }

    protected Integer anchorsIndex(Topstacle anchor, FloodableNode from, Integer index) {
        Integer outIndex = anchor == from.mChannel.getP1() ? index : Integer.valueOf(from.wireMaps.size() - index);
        if (outIndex < 0) {
            return 0;
        }
        return outIndex;
    }

    protected APair<ALine, ALine> getNormalizedChannels(FloodableNode one, FloodableNode two) {
        Topstacle anchor = this.anchor(one, two);
        if (anchor == null) {
            return null;
        }
        ALine from = new ALine(anchor.getPoint(), ((Topstacle)one.mChannel.getP1()).equals(anchor) ? ((Topstacle)one.mChannel.getP2()).getPoint() : ((Topstacle)one.mChannel.getP1()).getPoint());
        ALine to = new ALine(anchor.getPoint(), ((Topstacle)two.mChannel.getP1()).equals(anchor) ? ((Topstacle)two.mChannel.getP2()).getPoint() : ((Topstacle)two.mChannel.getP1()).getPoint());
        return new APair((Object)from, (Object)to);
    }

    protected FloodableNode getThirdLeg(FloodableNode one, FloodableNode two) {
        Topstacle anchor = this.anchor(one, two);
        Topstacle op1 = one.mChannel.getP1() == anchor ? (Topstacle)one.mChannel.getP2() : (Topstacle)one.mChannel.getP1();
        Topstacle op2 = two.mChannel.getP1() == anchor ? (Topstacle)two.mChannel.getP2() : (Topstacle)two.mChannel.getP1();
        for (Channel c : op1.getChannelList()) {
            if ((c.getP1() != op1 || c.getP2() != op2) && (c.getP2() != op1 || c.getP1() != op2)) continue;
            return this.mChannelToFloodNode.get((Object)c);
        }
        return null;
    }

    protected LinkedList<APoint2D> intersectionPoints(FloodableNode fn) {
        LinkedList<APoint2D> p = new LinkedList<APoint2D>();
        for (int i = 0; i < fn.wireMaps.size(); ++i) {
            p.add(fn.wireMaps.get((int)i).point);
        }
        return p;
    }

    protected ArrayList<Wire> getWires(FloodableNode from) {
        ArrayList<Wire> wires = new ArrayList<Wire>();
        for (int i = 0; i < from.wireMaps.size(); ++i) {
            wires.add(from.wireMaps.get((int)i).wire);
        }
        return wires;
    }

    protected ArrayList<Wire> getWires(Topstacle anchor, FloodableNode from) {
        ArrayList<Wire> wire = new ArrayList<Wire>();
        for (int i = 0; i < from.wireMaps.size(); ++i) {
            wire.add(from.wireMaps.get((int)i).wire);
        }
        if (from.mChannel.getP1() != anchor) {
            Collections.reverse(wire);
        }
        return wire;
    }

    protected boolean wireAttaches(Wire w, Topstacle anchor, FloodableNode from) {
        if (from.mChannel.getP1() == anchor) {
            return from.startWires.contains(w);
        }
        if (from.mChannel.getP2() == anchor) {
            return from.endWires.contains(w);
        }
        return false;
    }

    protected boolean wiresInOrder(Topstacle anchor, FloodableNode from) {
        return from.mChannel.getP1() == anchor;
    }

    protected boolean wireGoesFromTo(Wire w, FloodableNode from, FloodableNode to) {
        int fromIndex = from.getWireIndex(w);
        if (fromIndex < 0) {
            return false;
        }
        int toIndex = to.getWireIndex(w);
        if (toIndex < 0) {
            return false;
        }
        if (from.wireMaps.get((int)fromIndex).next == to) {
            return true;
        }
        return from.wireMaps.get((int)fromIndex).prev == to;
    }

    protected boolean wireGoesTo(Wire w, FloodableNode to) {
        return to.hasWire(w);
    }

    protected Wire attachedWire(FloodableNode node, Topstacle anchor) {
        if (anchor == node.mChannel.getP1() && node.mStartBlocked) {
            return node.wireMaps.get((int)0).wire;
        }
        if (anchor == node.mChannel.getP2() && node.mEndBlocked) {
            return node.wireMaps.get((int)(node.wireMaps.size() - 1)).wire;
        }
        return null;
    }

    protected Integer getToIndex(FloodableNode from, FloodableNode to, Integer fromIndex) {
        int debugCross = -1;
        ++this.mDebugCross;
        if (this.mDebugCross == debugCross) {
            ++this.mDebugCross;
            --this.mDebugCross;
        }
        Object dbgString = "";
        if (this.mDebug) {
            dbgString = (String)dbgString + "(" + this.mDebugCross + ")";
            dbgString = (String)dbgString + from.printNode();
            dbgString = (String)dbgString + " " + fromIndex + " ";
            dbgString = (String)dbgString + to.printNode() + " ";
        }
        if (!from.isChannel) {
            if (((Topstacle)to.mChannel.getP1()).sameOwner(this.mCurrentRI.getFrom())) {
                return this.anchorsIndex((Topstacle)to.mChannel.getP1(), to, 0);
            }
            if (((Topstacle)to.mChannel.getP2()).sameOwner(this.mCurrentRI.getFrom())) {
                return this.anchorsIndex((Topstacle)to.mChannel.getP2(), to, 0);
            }
            return fromIndex;
        }
        if (to.mChannel == null && from.numWires() > 0) {
            int i;
            ArrayList<Wire> wires = this.getWires(from);
            if (((Topstacle)from.mChannel.getP2()).sameOwner(this.mCurrentRI.getTo())) {
                for (i = fromIndex.intValue(); i < from.numWires() && i < wires.size(); ++i) {
                    if (wires.get(i).getNet() == this.mCurrentRI.getFrom().getNet()) continue;
                    return null;
                }
            } else {
                for (i = 0; i < fromIndex && i < wires.size(); ++i) {
                    if (wires.get(i).getNet() == this.mCurrentRI.getFrom().getNet()) continue;
                    return null;
                }
            }
        }
        if (!to.isChannel) {
            return to.mNumLoads;
        }
        FloodableNode other = this.getThirdLeg(from, to);
        if (other == null) {
            return null;
        }
        Topstacle anchor = this.anchor(from, to);
        Integer fromAnchorsOrder = this.anchorsIndex(anchor, from, fromIndex);
        Wire w1 = this.attachedWire(from, anchor);
        if (w1 != null && this.wireGoesFromTo(w1, from, other)) {
            dbgString = (String)dbgString + " tr";
            if (this.mDebug) {
                ALog.logInfo((String)dbgString);
            }
            return null;
        }
        Wire w2 = this.attachedWire(to, anchor);
        if (w2 != null && this.wireGoesFromTo(w2, to, other)) {
            dbgString = (String)dbgString + " tr";
            if (this.mDebug) {
                ALog.logInfo((String)dbgString);
            }
            return null;
        }
        ArrayList<Wire> wiresComingFrom = this.getWires(anchor, from);
        int i = 0;
        int toIndex = w2 != null ? 1 : 0;
        for (Wire w : wiresComingFrom) {
            if (i == fromAnchorsOrder) break;
            boolean toOther = this.wireGoesFromTo(w, from, other);
            if (toOther) {
                dbgString = (String)dbgString + " cross";
                if (this.mDebug) {
                    ALog.logInfo((String)dbgString);
                }
                return null;
            }
            ++i;
            if (!this.wireGoesFromTo(w, from, to)) continue;
            ++toIndex;
        }
        Integer aIndex = this.anchorsIndex(anchor, to, toIndex);
        if (w2 != null) {
            int index = 0;
            for (Wire w : wiresComingFrom) {
                if (index >= fromAnchorsOrder && w.equals(w2)) {
                    return null;
                }
                ++index;
            }
        }
        if (w1 != null) {
            int index = 0;
            for (Wire w : wiresComingFrom) {
                if (index >= fromAnchorsOrder && this.wireAttaches(w, anchor, from)) {
                    return null;
                }
                ++index;
            }
        }
        if (from.mEndBlocked) {
            int index = 0;
            for (Wire w : this.getWires(from)) {
                if (index < fromIndex && this.wireAttaches(w, (Topstacle)from.mChannel.getP2(), from)) {
                    return null;
                }
                ++index;
            }
        }
        if (from.mStartBlocked) {
            int index = 0;
            for (Wire w : this.getWires(from)) {
                if (index >= fromIndex && this.wireAttaches(w, (Topstacle)from.mChannel.getP1(), from)) {
                    return null;
                }
                ++index;
            }
        }
        if (this.mDebugFlood) {
            ALog.logInfo((String)(from.mId + "(" + fromIndex + ") -> " + to.mId + "(" + aIndex + ")"));
        }
        return aIndex;
    }

    protected boolean myPartnerInChannel(FloodableNode f, RouteInformation me) {
        Personality p = me.getDiffPair();
        if (p == null) {
            return false;
        }
        ArrayList<Wire> wires = f.getWires();
        for (Wire w : wires) {
            DeviceTemplate dt = w.getNet().getDeviceTemplate();
            DevicePath dp = dt.getPathToPresentUser();
            Personality thisWireDiffPair = Net.isDiffPair((Net)w.getNet(), (DevicePath)dp);
            if (thisWireDiffPair != p) continue;
            return true;
        }
        return false;
    }

    protected ArrayList<FloodCost> floodCost(Aisle fromA, FloodableNode to, boolean gettingStarted) {
        Integer toOrder;
        FloodableNode from = fromA.fn;
        int fromIndex = fromA.index;
        FloodCost fc = new FloodCost();
        fc.from = fromA.p;
        ArrayList<FloodCost> floodCosts = new ArrayList<FloodCost>();
        if (to.mBothBlocked) {
            fc.cost = -1.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        if (to.mHardWireBetween) {
            fc.cost = -1.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        if (to.mId == 8969) {
            // empty if block
        }
        if (to.isChannel && to.span == null) {
            fc.cost = -1.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        if (to.isChannel && !to.routeable) {
            fc.cost = -1.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        if (!this.mAllowBackDoor) {
            if (to.isChannel && (((Topstacle)to.mChannel.getP1()).net == null || ((Topstacle)to.mChannel.getP2()).net == null)) {
                fc.cost = -1.0;
                floodCosts.add(fc);
                return floodCosts;
            }
            if (from.isChannel && (((Topstacle)from.mChannel.getP1()).net == null || ((Topstacle)from.mChannel.getP2()).net == null)) {
                fc.cost = -1.0;
                floodCosts.add(fc);
                return floodCosts;
            }
        }
        double proposedPercentFull = 0.0;
        if (to.span != null) {
            long capacity;
            long load = 0L;
            load = gettingStarted ? to.deriveLoad(this.mCurrentRI, 0) : to.deriveLoad(this.mCurrentRI, 1);
            if (load > (capacity = to.getCapacity()) + CHANNEL_ROUNDING) {
                fc.cost = -1.0;
                floodCosts.add(fc);
                return floodCosts;
            }
        }
        double diffPairPenaltyFactor = 1.0;
        if (to.endsAreMatchedPairs && this.mCurrentRI.getNet() != ((Topstacle)to.mChannel.getP2()).net) {
            diffPairPenaltyFactor = 3.0;
        }
        if (this.myPartnerInChannel(to, this.mCurrentRI)) {
            diffPairPenaltyFactor = 0.0;
        }
        if ((toOrder = this.getToIndex(from, to, fromIndex)) == null) {
            fc.cost = -1.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        fc.toIndex = toOrder;
        long thisDist = 0L;
        if (!from.isChannel) {
            fc.cost = 0.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        if (!to.isChannel) {
            fc.cost = 0.0;
            floodCosts.add(fc);
            return floodCosts;
        }
        ALine thisLine = null;
        ALine optimumPath = new ALine(fromA.p, this.mEnd.mP);
        APoint2D closestPt = to.optimumPoint(optimumPath, this.mCurrentRI);
        thisLine = new ALine(fromA.p, closestPt);
        thisDist = Math.abs(thisLine.manhattanLength());
        ALine remainingLine = new ALine(closestPt, this.mEnd.mP);
        long remainingLength = Math.abs(remainingLine.manhattanLength());
        remainingLength = (long)((double)remainingLength * diffPairPenaltyFactor);
        fc.remainingCost = remainingLength;
        if (this.mDebugFlood && this.overlay != null) {
            this.overlay.addFloodLine(thisLine, thisDist);
        }
        fc.cost = thisDist;
        fc.from = closestPt;
        floodCosts.add(fc);
        return floodCosts;
    }

    protected Aisle flood() {
        if (this.mDebugFlood && this.overlay != null) {
            this.overlay.resetAs();
        }
        this.mFlood = new Flooder();
        Aisle a = null;
        Aisle start = this.createAisle(this.mStart, 0, this.mStart.mP);
        this.mFlood.add(null, start, 0.0, 0.0);
        boolean success = false;
        int ply = 0;
        while (!success && (a = (Aisle)this.mFlood.pop()) != null) {
            FloodableNode fn;
            ++ply;
            if (this.mDebugFlood) {
                Aisle pa = (Aisle)a.prevNode;
                Object list = "";
                while (pa != null) {
                    list = (String)list + pa.fn.mId;
                    pa = (Aisle)pa.prevNode;
                    if (pa == null) continue;
                    list = (String)list + ", ";
                }
                ALog.logInfo((String)("pop [" + a.fn.mId + "] @ " + a.cost + " from " + (String)list));
                if (a.fn.mId == 1072 || a.fn.mId != 1071 || this.mDebug) {
                    // empty if block
                }
            }
            if ((fn = a.getFloodableNode()) == this.mEnd) {
                success = true;
                break;
            }
            Collection frontierCollection = this.mFloodGraph.getNeighbors((Object)fn);
            ArrayList<FloodableNode> frontier = new ArrayList<FloodableNode>();
            for (FloodableNode f : frontierCollection) {
                frontier.add(f);
            }
            Collections.sort(frontier);
            for (FloodableNode f : frontier) {
                ArrayList<FloodCost> floodCosts = this.floodCost(a, f, ply == 1);
                for (FloodCost fc : floodCosts) {
                    Double toHereCost;
                    if (fc.cost == -1.0) continue;
                    Aisle aisle = this.createAisle(f, fc.toIndex, fc.from);
                    if (!this.mDebug || f.mId == 1071) {
                        // empty if block
                    }
                    if ((toHereCost = this.mFlood.add(a, aisle, fc.cost, fc.remainingCost)) == null || !this.mDebugFlood || this.overlay == null) continue;
                    ALog.logInfo((String)("push [" + f.mId + "] @ " + fc.cost + " Total " + toHereCost));
                    this.overlay.add(aisle, fc.cost + toHereCost);
                }
            }
        }
        if (success) {
            return a;
        }
        return null;
    }

    protected void createChannels() {
        Collections.sort(this.mObstacles);
        this.mChannels.clear();
        this.createBoundaryObstacles();
        for (Topstacle dp : this.mObstacles) {
            APoint2D p = dp.getPoint();
            this.mChannels.addVertex(p, dp);
        }
        this.mChannels.triangulate();
        for (Channel c : this.mChannels.getEdges()) {
            Topstacle p1 = (Topstacle)c.getP1();
            p1.addChannel(c);
            Topstacle p2 = (Topstacle)c.getP2();
            p2.addChannel(c);
        }
    }

    protected void calcCapacity() {
        for (FloodableNode fn : this.mFloodableNodes) {
            if (!fn.isChannel) continue;
            fn.updateSpan();
        }
    }

    protected void createNonFloodableChannelsForBundles() {
        for (FloodableNode fn : this.mFloodableNodes) {
            if (!fn.isChannel) continue;
        }
    }

    protected Personality diffPairHelper(Net net, DevicePath path, HashMap<Net, Personality> topnet2diff) {
        Net topnet = NetMap.getTopmostNet((Net)net, (DevicePath)path);
        Personality diffpair = null;
        if (!topnet2diff.containsKey(topnet)) {
            diffpair = Net.isDiffPair((Net)net, (DevicePath)path);
            topnet2diff.put(topnet, diffpair);
            return diffpair;
        }
        return topnet2diff.get(topnet);
    }

    protected void createDiffPairData() {
        HashMap<Net, Personality> topnet2diff = new HashMap<Net, Personality>();
        for (FloodableNode fn : this.mFloodableNodes) {
            if (!fn.isChannel || ((Topstacle)fn.mChannel.getP1()).net == null || ((Topstacle)fn.mChannel.getP2()).net == null) continue;
            HierPin hp1 = ((Topstacle)fn.mChannel.getP1()).toDevicePathPort();
            HierPin hp2 = ((Topstacle)fn.mChannel.getP2()).toDevicePathPort();
            if (hp1 == null || hp2 == null) continue;
            Personality p1 = this.diffPairHelper(((PinInstance)hp1.second).getNet(), hp1.getPath(), topnet2diff);
            Personality p2 = this.diffPairHelper(((PinInstance)hp2.second).getNet(), hp2.getPath(), topnet2diff);
            if (p1 != null && p2 != null && p1 == p2) {
                fn.endsAreMatchedPairs = true;
                continue;
            }
            fn.endsAreMatchedPairs = false;
        }
    }

    protected void addExistingEtch() {
        for (FloodableNode fn : this.mFloodableNodes) {
            if (!fn.isChannel) continue;
            if (fn.mId == 38) {
                // empty if block
            }
            HierPin hp1 = ((Topstacle)fn.mChannel.getP1()).toDevicePathPort();
            HierPin hp2 = ((Topstacle)fn.mChannel.getP2()).toDevicePathPort();
            if (hp1 == null || hp2 == null || Wire.connectsGeom((HierPin)hp1, (HierPin)hp2, (Layer)this.mLayer) == null) continue;
            fn.mHardWireBetween = true;
        }
    }

    protected void removeThisRouteFloodPath() {
        for (FloodGraphEdge e : this.mThisRouteFloodPaths) {
            this.mFloodGraph.removeEdge((Object)e);
        }
    }

    public void addWireFromPotentialPath(LinkedList<RouteInformation> ris) {
        ArrayList<Aisle> completeBestPath = new ArrayList<Aisle>();
        for (RouteInformation ri : ris) {
            ArrayList<Aisle> list = new ArrayList<Aisle>(ri.bestPath);
            Collections.reverse(list);
            completeBestPath.addAll(list);
        }
        this.mCurrentRI.setFrom(ris.get(0).getFrom());
        this.mCurrentRI.setTo(ris.getLast().getTo());
        this.createAWireFromBestPath(completeBestPath, true);
    }

    public Topstacle addTackPoint(APoint2D p) {
        for (Channel channel : this.mChannels.getEdges()) {
            FloodableNode fnTack = this.mChannelToFloodNode.get((Object)channel);
            if (!fnTack.mP.equals((Object)p)) continue;
            Topstacle tackTopstacle = new Topstacle(p, null, null);
            this.tackToFn.put(tackTopstacle, fnTack);
            return tackTopstacle;
        }
        return null;
    }

    public void removeTackPoint(Topstacle t) {
        this.tackToFn.remove(t);
    }

    protected void addThisRouteFloodPath() {
        FloodGraphEdge e;
        this.mStart = new FloodableNode(null, this.mCurrentRI.getFrom().getPoint());
        this.mFloodableNodes.add(this.mStart);
        this.mStart.special = this.mCurrentRI.getFrom();
        this.mEnd = new FloodableNode(null, this.mCurrentRI.getTo().getPoint());
        this.mFloodableNodes.add(this.mEnd);
        this.mEnd.special = this.mCurrentRI.getTo();
        this.mFloodGraph.addVertex((Object)this.mStart);
        this.mFloodGraph.addVertex((Object)this.mEnd);
        ALine conV = new ALine(this.mStart.mP, this.mEnd.mP);
        double angle = conV.getAngle();
        conV = new ALine(this.mEnd.mP, this.mStart.mP);
        double rAngle = conV.getAngle();
        Channel bestFromChannel = null;
        Double bestFromAngle = null;
        Channel bestToChannel = null;
        Double bestToAngle = null;
        for (Channel channel : this.mChannels.getEdges()) {
            if (((Topstacle)channel.getP1()).sameOwner(this.mCurrentRI.getFrom()) || ((Topstacle)channel.getP2()).sameOwner(this.mCurrentRI.getFrom())) {
                ALine thisExitV = new ALine(this.mStart.mP, this.mChannelToFloodNode.get((Object)((Object)channel)).mP);
                double thisAngle = thisExitV.getAngle();
                double diff = Math.abs(thisAngle - angle);
                diff = Math.min(diff, 360.0 - diff);
                if (bestFromAngle == null || diff < bestFromAngle) {
                    bestFromAngle = diff;
                    bestFromChannel = channel;
                }
            }
            if (!((Topstacle)channel.getP1()).sameOwner(this.mCurrentRI.getTo()) && !((Topstacle)channel.getP2()).sameOwner(this.mCurrentRI.getTo()) || !(this.mCurrentRI.getTo().getOwner() instanceof HierPin)) continue;
            HierPin hp = (HierPin)this.mCurrentRI.getTo().getOwner();
            if (hp.getPinTemplate().getType().equals((Object)PinTemplate.Type.VIA)) {
                FloodGraphEdge e2 = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
                this.mFloodGraph.addEdge((Object)e2, (Object)this.mEnd, (Object)this.mChannelToFloodNode.get((Object)channel));
                this.mThisRouteFloodPaths.add(e2);
                continue;
            }
            ALine thisExitV = new ALine(this.mEnd.mP, this.mChannelToFloodNode.get((Object)((Object)channel)).mP);
            double thisAngle = thisExitV.getAngle();
            double diff = Math.abs(thisAngle - rAngle);
            diff = Math.min(diff, 360.0 - diff);
            if (bestToChannel != null && !(diff < bestToAngle)) continue;
            bestToAngle = diff;
            bestToChannel = channel;
        }
        if (bestFromChannel != null) {
            e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
            this.mFloodGraph.addEdge((Object)e, (Object)this.mStart, (Object)this.mChannelToFloodNode.get((Object)bestFromChannel));
            this.mThisRouteFloodPaths.add(e);
        }
        if (bestToChannel != null) {
            e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
            this.mFloodGraph.addEdge((Object)e, (Object)this.mEnd, (Object)this.mChannelToFloodNode.get((Object)bestToChannel));
            this.mThisRouteFloodPaths.add(e);
        }
    }

    protected void addThisRouteFloodPath1() {
        this.mStart = new FloodableNode(null, this.mCurrentRI.getFrom().getPoint());
        this.mFloodableNodes.add(this.mStart);
        this.mStart.special = this.mCurrentRI.getFrom();
        this.mEnd = new FloodableNode(null, this.mCurrentRI.getTo().getPoint());
        this.mFloodableNodes.add(this.mEnd);
        this.mEnd.special = this.mCurrentRI.getTo();
        this.mFloodGraph.addVertex((Object)this.mStart);
        this.mFloodGraph.addVertex((Object)this.mEnd);
        ALine conV = new ALine(this.mEnd.mP, this.mStart.mP);
        double rAngle = conV.getAngle();
        Channel bestToChannel = null;
        Double bestToAngle = null;
        for (Channel channel : this.mChannels.getEdges()) {
            if (((Topstacle)channel.getP1()).sameOwner(this.mCurrentRI.getFrom()) || ((Topstacle)channel.getP2()).sameOwner(this.mCurrentRI.getFrom())) {
                FloodGraphEdge e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
                this.mFloodGraph.addEdge((Object)e, (Object)this.mStart, (Object)this.mChannelToFloodNode.get((Object)channel));
                this.mThisRouteFloodPaths.add(e);
            }
            if (!((Topstacle)channel.getP1()).sameOwner(this.mCurrentRI.getTo()) && !((Topstacle)channel.getP2()).sameOwner(this.mCurrentRI.getTo()) || !(this.mCurrentRI.getTo().getOwner() instanceof HierPin)) continue;
            HierPin hp = (HierPin)this.mCurrentRI.getTo().getOwner();
            if (hp.getPinTemplate().getType().equals((Object)PinTemplate.Type.VIA)) {
                FloodGraphEdge e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
                this.mFloodGraph.addEdge((Object)e, (Object)this.mEnd, (Object)this.mChannelToFloodNode.get((Object)channel));
                this.mThisRouteFloodPaths.add(e);
                continue;
            }
            ALine thisExitV = new ALine(this.mEnd.mP, this.mChannelToFloodNode.get((Object)((Object)channel)).mP);
            double thisAngle = thisExitV.getAngle();
            double diff = Math.abs(thisAngle - rAngle);
            diff = Math.min(diff, 360.0 - diff);
            if (bestToChannel != null && !(diff < bestToAngle)) continue;
            bestToAngle = diff;
            bestToChannel = channel;
        }
        if (bestToChannel != null) {
            FloodGraphEdge e = new FloodGraphEdge(FloodGraphEdge.Type.ESCAPE);
            this.mFloodGraph.addEdge((Object)e, (Object)this.mEnd, (Object)this.mChannelToFloodNode.get((Object)bestToChannel));
            this.mThisRouteFloodPaths.add(e);
        }
    }

    protected void classifyFNs() {
        for (Bundle b : this.mDb.getObjects(Bundle.class)) {
            for (PinTemplate pt : b.getFixedContacts()) {
                pt.setValue("bundleName", (Object)b.getName());
            }
            for (PinTemplate pt : b.getFreeContacts()) {
                pt.setValue("bundleName", (Object)b.getName());
            }
        }
        for (FloodableNode fn : this.mFloodableNodes) {
            if (!fn.isChannel) continue;
            HierPin p1 = (HierPin)((Topstacle)fn.mChannel.getP1()).owner;
            HierPin p2 = (HierPin)((Topstacle)fn.mChannel.getP2()).owner;
            if (p1 != null && p2 != null && p1.second != null && p2.second != null) {
                String b1 = (String)((PinInstance)p1.second).getPinTemplate().getValue("bundleName");
                String b2 = (String)((PinInstance)p2.second).getPinTemplate().getValue("bundleName");
                if (b1 != null && b2 != null && b1.equals(b2)) {
                    fn.routeable = false;
                }
            }
            if (p1 != null && ((PinInstance)p1.second).getPinTemplate().getIsVirtual() && ((Topstacle)fn.mChannel.getP2()).net == null) {
                fn.routeable = false;
            }
            if (p2 == null || !((PinInstance)p2.second).getPinTemplate().getIsVirtual() || ((Topstacle)fn.mChannel.getP1()).net != null) continue;
            fn.routeable = false;
        }
    }

    protected void createFloodPaths() {
        ArrayList<Channel> channels = this.getSortedChannels();
        for (Channel channel : channels) {
            if (channel.getP1() == null || channel.getP2() == null) continue;
            ALine l = new ALine(channel.getV1(), channel.getV2());
            APoint2D center = l.center();
            FloodableNode fn = new FloodableNode(channel, center);
            this.mFloodableNodes.add(fn);
            this.mChannelToFloodNode.put(channel, fn);
            this.mFloodGraph.addVertex((Object)fn);
        }
        int size = channels.size();
        int i = 0;
        for (Channel channel : channels) {
            if (++i % 100 == 0) {
                SingleLayerRouter.updateProgress(false, 0.0, "Building Flood Graph (" + i + " of " + size + ")");
            }
            FloodableNode fromNode = this.mChannelToFloodNode.get((Object)channel);
            Topstacle p1 = (Topstacle)channel.getP1();
            ArrayList<Channel> channelList1 = this.createRadialChannels(p1);
            Channel cCW1 = this.getNeighborChannel(channelList1, channel, p1, 1);
            Channel cCCW1 = this.getNeighborChannel(channelList1, channel, p1, -1);
            if (cCW1 != null && cCCW1 != null) {
                FloodableNode fn1 = this.mChannelToFloodNode.get((Object)cCW1);
                FloodableNode fn2 = this.mChannelToFloodNode.get((Object)cCCW1);
                if (this.mFloodGraph.findEdge((Object)fromNode, (Object)fn1) == null) {
                    this.mFloodGraph.addEdge((Object)new FloodGraphEdge(), (Object)fromNode, (Object)fn1);
                }
                if (this.mFloodGraph.findEdge((Object)fromNode, (Object)fn2) == null) {
                    this.mFloodGraph.addEdge((Object)new FloodGraphEdge(), (Object)fromNode, (Object)fn2);
                }
            }
            Topstacle p2 = (Topstacle)channel.getP2();
            ArrayList<Channel> channelList2 = this.createRadialChannels(p2);
            Channel cCW2 = this.getNeighborChannel(channelList2, channel, p2, 1);
            Channel cCCW2 = this.getNeighborChannel(channelList2, channel, p2, -1);
            if (cCW2 == null || cCCW2 == null) continue;
            FloodableNode fn1 = this.mChannelToFloodNode.get((Object)cCW2);
            FloodableNode fn2 = this.mChannelToFloodNode.get((Object)cCCW2);
            if (this.mFloodGraph.findEdge((Object)fromNode, (Object)fn1) == null) {
                this.mFloodGraph.addEdge((Object)new FloodGraphEdge(), (Object)fromNode, (Object)fn1);
            }
            if (this.mFloodGraph.findEdge((Object)fromNode, (Object)fn2) != null) continue;
            this.mFloodGraph.addEdge((Object)new FloodGraphEdge(), (Object)fromNode, (Object)fn2);
        }
    }

    protected Channel getNeighborChannel(ArrayList<Channel> l, Channel c, Topstacle p, int dir) {
        int size = l.size();
        if (size <= 1) {
            return null;
        }
        int index = l.indexOf((Object)c);
        if (index == -1) {
            return null;
        }
        if ((index += dir) >= size) {
            index = 0;
        }
        if (index < 0) {
            index = size - 1;
        }
        return l.get(index);
    }

    public ArrayList<FloodableNode> topstacleToFloodableNodes(Topstacle p) {
        ArrayList<FloodableNode> ret = new ArrayList<FloodableNode>();
        ArrayList<Channel> list = new ArrayList<Channel>(p.getChannelList());
        for (Channel c : list) {
            FloodableNode fn = this.mChannelToFloodNode.get((Object)c);
            ret.add(fn);
        }
        return ret;
    }

    protected ArrayList<Channel> createRadialChannels(Topstacle p) {
        ArrayList<Channel> list = new ArrayList<Channel>(p.getChannelList());
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                double aI = this.getAngle(list.get(i), p);
                double aJ = this.getAngle(list.get(j), p);
                if (!(aJ < aI)) continue;
                Channel temp = list.get(i);
                list.set(i, list.get(j));
                list.set(j, temp);
            }
        }
        return list;
    }

    protected double getAngle(Channel e, Topstacle from) {
        ALine l = new ALine(e.getV1(), e.getV2());
        if (e.getP1() != from) {
            l.swap();
        }
        return l.getAngle();
    }

    protected void createBoundaryObstacles() {
        ArrayList<Long> xList = new ArrayList<Long>();
        ArrayList<Long> yList = new ArrayList<Long>();
        for (Topstacle dp : this.mObstacles) {
            APoint2D p;
            if (dp.net.getName().contains("CPU_RX_A_1N")) {
                ALog.logInfo((String)"");
            }
            if (!xList.contains((p = dp.getPoint()).getX())) {
                xList.add(p.getX());
            }
            if (yList.contains(p.getY())) continue;
            yList.add(p.getY());
        }
        ARect r = this.mParent.getDeviceTemplate().getBB();
        for (Long x : xList) {
            APoint2D p1 = new APoint2D(x.longValue(), r.bottom() + 10L);
            Topstacle t1 = new Topstacle(p1, null, null, "boundary");
            t1.setShape((AGeom)new ACircle(p1, 0L));
            this.mChannels.addVertex(p1, t1);
            APoint2D p2 = new APoint2D(x.longValue(), r.top() - 10L);
            Topstacle t2 = new Topstacle(p2, null, null, "boundary");
            t2.setShape((AGeom)new ACircle(p2, 0L));
            this.mChannels.addVertex(p2, t2);
        }
        for (Long y : yList) {
            APoint2D p3 = new APoint2D(r.left() + 10L, y.longValue());
            Topstacle t3 = new Topstacle(p3, null, null, "boundary");
            t3.setShape((AGeom)new ACircle(p3, 0L));
            this.mChannels.addVertex(p3, t3);
            APoint2D p4 = new APoint2D(r.right() - 10L, y.longValue());
            Topstacle t4 = new Topstacle(p4, null, null, "boundary");
            t4.setShape((AGeom)new ACircle(p4, 0L));
            this.mChannels.addVertex(p4, t4);
        }
    }

    protected ArrayList<Channel> getSortedChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Channel channel : this.mChannels.getEdges()) {
            channels.add(channel);
        }
        Collections.sort(channels, new ChannelSort());
        return channels;
    }

    public UndirectedSparseGraph<FloodableNode, FloodGraphEdge> getFloodGraph() {
        return this.mFloodGraph;
    }

    public SingleLayerRouter() {
        mCurrentSingleLayerRouter = this;
    }

    public void setParent(DevicePath parent) {
        this.mParent = parent;
    }

    public DevicePath getParent() {
        return this.mParent;
    }

    public void setLayer(Layer l) {
        this.mLayer = l;
    }

    public Layer getLayer() {
        return this.mLayer;
    }

    public void setObstacles(ArrayList<Topstacle> obstacles) {
        this.mObstacles = obstacles;
    }

    public void setToBeRouted(ArrayList<RouteInformation> routeInformation) {
        this.mRouteInfo = routeInformation;
    }

    public ArrayList<RouteInformation> getRouteInformation() {
        return this.mRouteInfo;
    }

    public void setDB(Db db) {
        this.mDb = db;
    }

    public static SingleLayerRouter getSingleLayerRouter() {
        return mCurrentSingleLayerRouter;
    }

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    protected static void firePercentUpdate(int percent, boolean done, String data) {
        for (LoadListener l : sLoadListener) {
            l.stats(percent, done, data);
        }
    }

    public static void updateProgress(boolean done, double percent, String data) {
        int iPercent = (int)(percent * 100.0);
        SingleLayerRouter.firePercentUpdate(iPercent, done, data);
    }

    public void debugView() {
        this.overlay = new DebugOverlay((DesignView2D)OrbitIO.getCurView(), this);
    }

    static {
        sLoadListener = new LinkedList();
    }

    public static interface LoadListener {
        public void stats(int var1, boolean var2, String var3);
    }

    public static class FloodGraphEdge {
        protected Type type = Type.STANDARD;

        public FloodGraphEdge() {
            this.type = Type.STANDARD;
        }

        public FloodGraphEdge(Type t) {
            this.type = t;
        }

        public static enum Type {
            ESCAPE,
            STANDARD;

        }
    }

    public static class IntersectionSorter
    implements Comparator<FloodableNode> {
        ALine l;

        public IntersectionSorter(ALine l) {
            this.l = l;
        }

        @Override
        public int compare(FloodableNode fn0, FloodableNode fn1) {
            long d1;
            APoint2D int0 = this.l.getIntersectLines(fn0.span);
            APoint2D int1 = this.l.getIntersectLines(fn1.span);
            long d0 = this.l.getP0().distance(int0);
            if (d0 < (d1 = this.l.getP0().distance(int1))) {
                return -1;
            }
            if (d0 > d1) {
                return 1;
            }
            return 0;
        }
    }

    public static class FNSort
    implements Comparator<FloodableNode> {
        @Override
        public int compare(FloodableNode o1, FloodableNode o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static class Channel
    extends ADelauneyEdge<Topstacle> {
        static int EdgeId = 0;
        int mId = EdgeId++;

        public Channel(Topstacle pa, Topstacle pb, APoint2D va, APoint2D vb) {
            super((Object)pa, (Object)pb, va, vb);
        }
    }

    public static class ChannelSort
    implements Comparator<Channel> {
        @Override
        public int compare(Channel o1, Channel o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Topstacle)o1.getP1()).compareTo((Topstacle)o2.getP1());
        }
    }

    public static class RouteInformation {
        private Net net = null;
        private DbObject mConn = null;
        private Topstacle mFrom = null;
        private Topstacle mTo = null;
        private long mWidth = -1L;
        private long mClear = -1L;
        private long mMaxWidth = -1L;
        private long mTraceToPad = -1L;
        private boolean mSucess = false;
        protected int iTh = -1;
        private Wire wire = null;
        protected double efficiency = 0.0;
        protected double loopiness = 0.0;
        protected ArrayList<Aisle> bestPath = null;
        private boolean ignore = false;
        protected boolean drcOk = false;
        private Personality diffPair = null;
        private long mPinExitLength = -1L;
        private long numConnectionsICross = 0L;
        protected long inVirtualCount = 0L;
        protected RuleSet ruleSet;

        public RouteInformation() {
        }

        public RuleSet getRuleSet() {
            return this.ruleSet;
        }

        public void setRuleSet(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        public RouteInformation(RouteInformation from) {
            this.setFrom(from.getFrom());
            this.setTo(from.getTo());
            this.setWidth(from.getWidth());
            this.setClear(from.getClear());
            this.setSucess(from.getSucess());
            this.iTh = from.iTh;
            this.wire = from.wire;
            this.efficiency = from.efficiency;
            this.loopiness = from.loopiness;
            this.setDiffPair(from.getDiffPair());
            this.setPinExitLength(from.getPinExitLength());
            this.setNumConnectionsICross(from.getNumConnectionsICross());
            this.setIgnore(from.getIgnore());
            this.setConn(from.getConn());
        }

        public Wire getWire() {
            return this.wire;
        }

        public void setWire(Wire w) {
            this.wire = w;
        }

        public long length() {
            return Math.abs(this.getFrom().getPoint().distance(this.getTo().getPoint()));
        }

        public ALine line() {
            return new ALine(this.getFrom().getPoint(), this.getTo().getPoint());
        }

        public void calcEfficiency() {
            if (this.wire == null) {
                this.efficiency = 1.0;
                return;
            }
            APath path = this.wire.getPath();
            long length = this.getTo().getPoint().distance(this.getFrom().getPoint());
            this.efficiency = (double)length / (double)path.getLength();
        }

        public void calcLoopiness() {
        }

        public double getEfficiency() {
            return this.efficiency;
        }

        public double getLoopiness() {
            return this.loopiness;
        }

        public void removeWireFromDb() {
            if (this.wire != null) {
                this.wire.deleteFromDb();
            }
            this.wire = null;
        }

        public void removeWire() {
            this.wire = null;
        }

        public Topstacle getFrom() {
            return this.mFrom;
        }

        public void setFrom(Topstacle from) {
            this.mFrom = from;
        }

        public Topstacle getTo() {
            return this.mTo;
        }

        public void setTo(Topstacle to) {
            this.mTo = to;
        }

        public long getWidth() {
            return this.mWidth;
        }

        public void setWidth(long width) {
            this.mWidth = width;
        }

        public long getClear() {
            return this.mClear;
        }

        public void setClear(long clear) {
            this.mClear = clear;
        }

        public long getPinExitLength() {
            return this.mPinExitLength;
        }

        public void setPinExitLength(long pinExitLength) {
            this.mPinExitLength = pinExitLength;
        }

        public long getTraceToPad() {
            return this.mTraceToPad;
        }

        public void setTraceToPad(long traceToPad) {
            this.mTraceToPad = traceToPad;
        }

        public long getMaxWidth() {
            return this.mMaxWidth;
        }

        public void setMaxWidth(long maxWidth) {
            this.mMaxWidth = maxWidth;
        }

        public DbObject getConn() {
            return this.mConn;
        }

        public void setConn(DbObject conn) {
            if (!(conn instanceof SchedConn) && !(conn instanceof Connection)) {
                throw new IllegalArgumentException("Must be SchedConn or Connection");
            }
            this.mConn = conn;
        }

        public boolean getIgnore() {
            return this.ignore;
        }

        public void setIgnore(boolean ignore) {
            this.ignore = ignore;
        }

        public Net getNet() {
            return this.net;
        }

        public void setNet(Net net) {
            this.net = net;
        }

        public boolean getSucess() {
            return this.mSucess;
        }

        public void setSucess(boolean sucess) {
            this.mSucess = sucess;
        }

        public Personality getDiffPair() {
            return this.diffPair;
        }

        public void setDiffPair(Personality diffPair) {
            this.diffPair = diffPair;
        }

        public long getNumConnectionsICross() {
            return this.numConnectionsICross;
        }

        public void setNumConnectionsICross(long numConnectionsICross) {
            this.numConnectionsICross = numConnectionsICross;
        }
    }

    static class FloodTree {
        LinkedList<FloodTreeNode> frontier = new LinkedList();

        FloodTree() {
        }

        public void add(FloodTreeNode parent, Aisle child, double deltaCost, double remainingCost) {
            if (parent != null) {
                if (parent.me == child) {
                    return;
                }
                FloodTreeNode grandParent = parent.parent;
                while (grandParent != null) {
                    if (grandParent.me.fn.mId == child.fn.mId) {
                        return;
                    }
                    grandParent = grandParent.parent;
                }
            }
            FloodTreeNode childNode = new FloodTreeNode();
            childNode.me = child;
            childNode.parent = parent;
            FloodTreeEdge fe = new FloodTreeEdge();
            fe.parent = parent;
            fe.child = childNode;
            fe.cost = deltaCost;
            double parentCost = 0.0;
            if (parent != null) {
                parent.children.add(fe);
                parentCost = parent.costToHere;
            }
            childNode.costToHere = parentCost + deltaCost;
            childNode.remainingCostFromHere = remainingCost;
            this.insert(childNode);
        }

        protected void insert(FloodTreeNode node) {
            double totalCost = node.costToHere + node.remainingCostFromHere;
            for (int i = 0; i < this.frontier.size(); ++i) {
                FloodTreeNode candidate = this.frontier.get(i);
                if (!(totalCost < candidate.costToHere + candidate.remainingCostFromHere)) continue;
                this.frontier.add(i, node);
                return;
            }
            this.frontier.addLast(node);
        }

        public FloodTreeNode pop() {
            if (this.frontier.size() < 1) {
                return null;
            }
            FloodTreeNode ftn = this.frontier.getFirst();
            this.frontier.removeFirst();
            return ftn;
        }

        static class FloodTreeEdge {
            FloodTreeNode parent = null;
            FloodTreeNode child = null;
            double cost;

            FloodTreeEdge() {
            }
        }

        static class FloodTreeNode {
            double costToHere;
            double remainingCostFromHere;
            FloodTreeNode parent;
            Aisle me;
            ArrayList<FloodTreeEdge> children = new ArrayList();

            FloodTreeNode() {
            }
        }
    }

    protected static class FloodCost {
        double cost = -1.0;
        double remainingCost;
        Integer toIndex = 0;
        APoint2D from;
    }

    protected static class Aisle
    extends Flooder.FloodSpace {
        FloodableNode fn;
        int index;
        APoint2D p;

        Aisle(FloodableNode fn, int index, APoint2D p) {
            this.fn = fn;
            this.index = index;
            this.p = p;
        }

        FloodableNode getFloodableNode() {
            return this.fn;
        }

        int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return this.fn.mId ^ this.index;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Aisle)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Aisle other = (Aisle)o;
            return other.fn.mId == this.fn.mId && other.index == this.index;
        }
    }

    public static interface PotentialPathListener {
        public boolean notifyPotentialPath(APath var1);
    }
}

