/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.delaunay.ADelaunay;
import com.sigrity.acl.geom.delaunay.ADelauneyEdge;
import com.sigrity.orbit.automation.router.Topstacle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class SingleLayerRouterDelaunay<T, C extends ADelauneyEdge<T>>
extends ADelaunay<T> {
    private ArrayList<C> mEdges = null;
    private Class<C> mEdgeType;

    public void clear() {
        if (this.mEdges != null) {
            this.mEdges.clear();
        }
    }

    public SingleLayerRouterDelaunay(Class<C> type) {
        this.mEdgeType = type;
    }

    public void addVertex(APoint2D p, T owner) {
        this.addSite(p, owner);
    }

    public void outputEdge(T object0, T object1, APoint2D v0, APoint2D v1) {
        this.addEdge(object0, object1, v0, v1);
    }

    public C addEdge(T object0, T object1, APoint2D v0, APoint2D v1) {
        ADelauneyEdge e = null;
        try {
            Constructor<C> ctor = this.mEdgeType.getConstructor(Topstacle.class, Topstacle.class, APoint2D.class, APoint2D.class);
            e = (ADelauneyEdge)ctor.newInstance(object0, object1, v0, v1);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
            ALog.logError((Throwable)e1);
        }
        if (this.mEdges == null) {
            this.mEdges = new ArrayList();
        }
        this.mEdges.add(e);
        return (C)e;
    }

    public IterableIterator<C> getEdges() {
        if (this.mEdges == null) {
            return AEmptyItr.create();
        }
        return new AIterableItr(this.mEdges.iterator());
    }

    public ArrayList<C> getEdges(T object) {
        ArrayList<ADelauneyEdge> edges = new ArrayList<ADelauneyEdge>();
        for (ADelauneyEdge e : this.mEdges) {
            if (e.getP1() != object && e.getP2() != object) continue;
            edges.add(e);
        }
        return edges;
    }
}

