/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.router.NonMonotonicPusher;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SpringSet;
import java.awt.Color;

public class Spring {
    public Long min;
    public Long max;
    public Long cur;
    public Object o;
    public SpringSet springSet;
    static Color[] colors = new Color[]{Color.RED, Color.BLACK, Color.BLUE, Color.GREEN, Color.ORANGE, Color.yellow, Color.pink, Color.cyan, Color.magenta, Color.white};

    public long minSlack() {
        long slack = 0L;
        for (Spring spring : this.springSet.springs) {
            slack += spring.min.longValue();
            if (spring != this) continue;
            return slack;
        }
        return slack;
    }

    public long minSlackFromLast() {
        return this.min;
    }

    protected void setCur(long d) {
        this.cur = d;
    }

    protected void move(long distance) {
        this.cur = this.cur + distance;
        APoint2D newPoint = this.springSet.pointFromStart(this.cur);
        NonMonotonicPusher.SortedIntersection si = (NonMonotonicPusher.SortedIntersection)this.o;
        si.pathIndex.path.setPoint(si.pathIndex.index, newPoint);
    }

    protected int ithSpring() {
        int ith = 0;
        for (Spring spring : this.springSet.springs) {
            if (spring == this) {
                return ith;
            }
            ++ith;
        }
        return -1;
    }

    public APoint2D canMoveX(long x) {
        ALine l = this.springSet.l;
        Long yInt = l.yIntercept(x);
        if (yInt == null) {
            return null;
        }
        APoint2D p = new APoint2D(x, yInt.longValue());
        long d = l.getP0().distance(p);
        if (d + 2L < this.minSlack()) {
            return null;
        }
        return p;
    }

    public APoint2D canMoveY(long y) {
        ALine l = this.springSet.l;
        Long xInt = l.yIntercept(y);
        if (xInt == null) {
            return null;
        }
        APoint2D p = new APoint2D(xInt.longValue(), y);
        long d = l.getP0().distance(p);
        if (d + 2L < this.minSlack()) {
            return null;
        }
        return p;
    }

    public APoint2D moveToX(long x) {
        ALine l = this.springSet.l;
        Long yInt = l.yIntercept(x);
        if (yInt == null) {
            return null;
        }
        APoint2D p = new APoint2D(x, yInt.longValue());
        return p;
    }

    public void draw(PrettyRouter pr, long d, String message) {
        ALine l = this.springSet.l.extract(d);
        int ith = this.ithSpring();
        if (ith >= colors.length - 1) {
            ith = 0;
        }
        pr.overlay.drawPath(l.toPath(1L), colors[ith], message);
    }

    public void draw(PrettyRouter pr, APoint2D p, String message) {
        ALine l = new ALine(this.springSet.l.getP0(), p);
        l.swap();
        int ith = this.ithSpring();
        if (ith >= colors.length - 1) {
            ith = 0;
        }
        pr.overlay.drawPath(l.toPath(1L), colors[ith], message);
    }
}

