/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.AVector;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.PathUtil;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Spring;
import com.sigrity.orbit.automation.router.SpringSet;
import com.sigrity.orbit.automation.router.Topstacle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class SpringRouter {
    double mMinAngle = 90.0;
    HashSet<Topstacle> topstacleSet = new HashSet();
    ArrayList<TopologicalObject> mTopologicalSet = new ArrayList();
    ArrayList<TopologicalObject> mFlexibleTopologicalSet = new ArrayList();
    ArrayList<TopologicalObject> mRigidTopologicalSet = new ArrayList();
    HashMap<DbObject, TopologicalObject> mDbToMo = new HashMap();
    AGrid snapGrid = null;
    protected PrettyRouter pr;
    int debugCounter = 0;
    AHashCollection<TopologicalObject, SpringSet> wireToSpring = new AHashCollection();
    AHashCollection<Topstacle, SpringSet> topToSpring = new AHashCollection();

    protected PushDir fromAngle(double angle) {
        int a = (int)angle;
        switch (a) {
            case 0: {
                return PushDir.Right;
            }
            case 45: {
                return PushDir.UpRight;
            }
            case 90: {
                return PushDir.Up;
            }
            case 135: {
                return PushDir.UpLeft;
            }
            case 180: {
                return PushDir.Left;
            }
            case 225: {
                return PushDir.DnLeft;
            }
            case 270: {
                return PushDir.Dn;
            }
            case 315: {
                return PushDir.DnRight;
            }
        }
        return PushDir.Up;
    }

    protected void snapPath(APath p, double angle) {
        PushDir dir = this.fromAngle(angle);
        for (int i = 0; i < p.getPointCount(); ++i) {
            p.setPoint(i, this.snap(p.getPoint(i), dir));
        }
    }

    protected boolean isUp(PushDir dir) {
        return dir == PushDir.Up || dir == PushDir.UpLeft || dir == PushDir.UpRight;
    }

    protected boolean isDn(PushDir dir) {
        return dir == PushDir.Dn || dir == PushDir.DnLeft || dir == PushDir.DnRight;
    }

    protected boolean isLeft(PushDir dir) {
        return dir == PushDir.Left || dir == PushDir.UpLeft || dir == PushDir.DnLeft;
    }

    protected boolean isRight(PushDir dir) {
        return dir == PushDir.Right || dir == PushDir.UpRight || dir == PushDir.DnRight;
    }

    protected APoint2D snap(APoint2D p, PushDir dir) {
        APoint2D newP = new APoint2D(p);
        if (this.snapGrid != null) {
            long dx;
            long dy;
            if (this.isUp(dir)) {
                dy = AGridUtil.snapDS((long)p.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY(), (boolean)true);
                newP = newP.add(0L, dy);
            }
            if (this.isDn(dir)) {
                dy = AGridUtil.snapDS((long)p.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY(), (boolean)false);
                newP = newP.add(0L, dy);
            }
            if (this.isRight(dir)) {
                dx = AGridUtil.snapDS((long)p.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX(), (boolean)true);
                newP = newP.add(dx, 0L);
            }
            if (this.isLeft(dir)) {
                dx = AGridUtil.snapDS((long)p.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX(), (boolean)false);
                newP = newP.add(dx, 0L);
            }
        }
        return newP;
    }

    public void setMinAngle(double angle) {
        this.mMinAngle = angle;
    }

    public void setPrettyRouter(PrettyRouter pr) {
        this.pr = pr;
    }

    public void makeDRCCompliant() {
        this.determineGrid();
        this.convertDbToTopologicalObjects();
        this.relaxSprings2();
        this.convertTopologicalObjectsToDb();
    }

    protected boolean adjustInRegion(APath p, FloodableNode from, FloodableNode to) {
        long d1;
        IntersectionIndex pFrom = this.getIntersectionOfPathAndFN(p, from);
        IntersectionIndex pTo = this.getIntersectionOfPathAndFN(p, to);
        if (pFrom == null || pTo == null) {
            return false;
        }
        ALine l = new ALine(pFrom.intersection, pTo.intersection);
        if (l.isHorizontal() || l.isVertical()) {
            return false;
        }
        Topstacle anchor = this.pr.anchor(from, to);
        APoint2D center = anchor.getPoint();
        APoint2D option0 = new APoint2D(pFrom.intersection.getX(), pTo.intersection.getY());
        APoint2D option1 = new APoint2D(pTo.intersection.getX(), pFrom.intersection.getY());
        long d0 = center.distance(option0);
        if (d0 > (d1 = center.distance(option1))) {
            p.insertPoint(pTo.idx + 1, option0);
            p.insertPoint(pTo.idx + 2, pTo.intersection);
        } else {
            p.insertPoint(pTo.idx + 1, option1);
            p.insertPoint(pTo.idx + 2, pTo.intersection);
        }
        return true;
    }

    protected IntersectionIndex getIntersectionOfPathAndFN(APath p, FloodableNode fn) {
        IntersectionIndex returnPt = new IntersectionIndex();
        ALine fnLine = new ALine(fn.span);
        fnLine.extendEnds(2L);
        for (int i = 0; i < p.getPointCount() - 1; ++i) {
            ALine l = new ALine(p.getPoint(i), p.getPoint(i + 1));
            l.extendEnds(2L);
            if (!l.intersects((AGeom)fnLine)) continue;
            returnPt.idx = i;
            APoint2D s = l.getIntersectLines(fnLine);
            long x = AGridUtil.snap((long)s.getX(), (long)this.snapGrid.getOrignX(), (long)this.snapGrid.getDeltaX());
            long y = AGridUtil.snap((long)s.getY(), (long)this.snapGrid.getOrignY(), (long)this.snapGrid.getDeltaY());
            returnPt.intersection = new APoint2D(x, y);
            return returnPt;
        }
        return null;
    }

    protected void cleanAll() {
        this.inGridAll();
        this.orthoAll();
    }

    protected void inGridAll() {
        for (TopologicalObject w : this.mFlexibleTopologicalSet) {
            APath path = w.current;
            APath newPath = new APath();
            for (int i = 0; i < path.getPointCount(); ++i) {
                newPath.addPoint(this.snapGrid.snapToGrid(path.getPoint(i)));
            }
            w.current = newPath.cleanPath();
        }
    }

    protected void orthoAll() {
        for (TopologicalObject w : this.mFlexibleTopologicalSet) {
            APath path = w.current;
            APath newPath = new APath();
            for (int i = 0; i < path.getPointCount() - 1; ++i) {
                newPath.addPoint(path.getPoint(i));
                long dx = path.getPoint(i + 1).xDistance(path.getPoint(i));
                long dy = path.getPoint(i + 1).yDistance(path.getPoint(i));
                if (Math.abs(dx) == Math.abs(dy) && dx != 0L && dy != 0L) continue;
                newPath.addPoint(path.getPoint(i + 1).getX(), path.getPoint(i).getY());
            }
            newPath.addPoint(path.getLastPoint());
            w.current = newPath;
        }
    }

    protected void determineGrid() {
        NamedGrid ngGrid = NamedGrid.get((Substrate)this.pr.mParent.getLast().getSubstrate(), (String)"Manufacturing Grid");
        this.snapGrid = ngGrid != null ? ngGrid.getGrid() : new AGrid(5L, 5L, 0L, 0L);
    }

    protected void convertTopologicalObjectsToDb() {
        for (int i = 0; i < this.mTopologicalSet.size(); ++i) {
            TopologicalObject iMO = this.mTopologicalSet.get(i);
            if (iMO.w == null) continue;
            long w = iMO.w.getPath().getWidth();
            iMO.current.setWidth(w);
            iMO.w.setPath(iMO.current);
        }
    }

    protected LinkedList<SortedIntersection> cleanIntersections(LinkedList<SortedIntersection> intersections) {
        LinkedList<SortedIntersection> clean = new LinkedList<SortedIntersection>();
        HashSet<TopologicalObject> processed = new HashSet<TopologicalObject>();
        for (int i = 0; i < intersections.size(); ++i) {
            if (processed.contains(intersections.get((int)i).t)) continue;
            processed.add(intersections.get((int)i).t);
            int best = i;
            for (int j = i + i; j < intersections.size(); ++j) {
                if (!intersections.get((int)i).t.equals(intersections.get((int)j).t) || intersections.get((int)j).d >= intersections.get((int)best).d) continue;
                best = j;
            }
            clean.add(intersections.get(best));
        }
        return clean;
    }

    protected ObstacleRelation pinToWireRelation(Topstacle topstacle, TopologicalObject wireT) {
        if (topstacle == null) {
            return ObstacleRelation.DifferentNet;
        }
        if (topstacle.net != wireT.net) {
            return ObstacleRelation.DifferentNet;
        }
        Wire w = wireT.w;
        if (w.getPath() == null) {
            return ObstacleRelation.DifferentNet;
        }
        if (topstacle.point == null) {
            return ObstacleRelation.DifferentNet;
        }
        if (topstacle.point.equals((Object)w.getPath().getFirstPoint())) {
            return ObstacleRelation.Connected;
        }
        if (topstacle.point.equals((Object)w.getPath().getLastPoint())) {
            return ObstacleRelation.Connected;
        }
        return ObstacleRelation.SameNet;
    }

    protected void convertWiresToTopologicalObjects() {
        for (Wire w : this.pr.mWiretoLastFn.keySet()) {
            w.clean();
            TopologicalObject tObject = new TopologicalObject();
            tObject.original = w.getPath().copy();
            tObject.net = w.getNet();
            tObject.flexible = true;
            tObject.close();
            tObject.w = w;
            this.mFlexibleTopologicalSet.add(tObject);
            this.mTopologicalSet.add(tObject);
            this.mDbToMo.put((DbObject)w, tObject);
        }
        Collections.sort(this.mFlexibleTopologicalSet, new PathSorter());
    }

    protected void convertPinsToTopologicalObjects() {
        for (FloodableNode fn : this.pr.mFloodableNodes) {
            if (!fn.isChannel) continue;
            this.topstacleSet.add((Topstacle)fn.mChannel.getP1());
            this.topstacleSet.add((Topstacle)fn.mChannel.getP2());
        }
        for (Topstacle topstacle : this.topstacleSet) {
            Net n = topstacle.net;
            if (n == null) continue;
            ARect r = topstacle.getBounds();
            boolean useRectangle = true;
            if (this.mMinAngle == 45.0) {
                if (topstacle.getShape() instanceof AOctagon) {
                    useRectangle = false;
                } else {
                    APolygon poly = topstacle.getShape().toPoly();
                    if (poly.getPointCount() >= 8 && r.width() == r.height()) {
                        useRectangle = false;
                    }
                }
            }
            if (useRectangle) {
                for (int i = 0; i < 4; ++i) {
                    TopologicalObject tObject = new TopologicalObject();
                    tObject.net = n;
                    tObject.c = r.center();
                    tObject.flexible = false;
                    tObject.t = topstacle;
                    if (i == 0) {
                        tObject.original = r.rightEdge().toPath(0L);
                        tObject.angleFace = 0.0;
                    } else if (i == 1) {
                        tObject.original = r.topEdge().toPath(0L);
                        tObject.angleFace = 90.0;
                    } else if (i == 2) {
                        tObject.original = r.leftEdge().toPath(0L);
                        tObject.angleFace = 180.0;
                    } else if (i == 3) {
                        tObject.original = r.bottomEdge().toPath(0L);
                        tObject.angleFace = 270.0;
                    }
                    tObject.close();
                    this.mTopologicalSet.add(tObject);
                    this.mRigidTopologicalSet.add(tObject);
                }
                continue;
            }
            long radius = r.width() / 2L;
            AOctagon oct = new AOctagon(radius);
            oct.moveCenterTo(r.center());
            for (ALine side : oct.getLines()) {
                TopologicalObject tObject = new TopologicalObject();
                tObject.net = n;
                tObject.c = r.center();
                tObject.flexible = false;
                tObject.t = topstacle;
                tObject.original = side.toPath(0L);
                double normal = side.getAngle();
                tObject.angleFace = normal - 90.0;
                if (tObject.angleFace < 0.0) {
                    tObject.angleFace += 360.0;
                }
                tObject.close();
                this.mTopologicalSet.add(tObject);
                this.mRigidTopologicalSet.add(tObject);
            }
        }
        Collections.sort(this.mTopologicalSet, new UniqueGeomSorter());
    }

    protected LinkedList<SortedIntersection> findIntersections(Topstacle pin, ALine whisker) {
        LinkedList<SortedIntersection> intersections = new LinkedList<SortedIntersection>();
        for (TopologicalObject wireObject : this.mFlexibleTopologicalSet) {
            if (this.pinToWireRelation(pin, wireObject) == ObstacleRelation.Connected) continue;
            APath p = wireObject.current;
            Long minD = null;
            int minIndex = 0;
            long minDistFromVertex = -1L;
            for (int i = 0; i < p.getPointCount() - 1; ++i) {
                ALine lOfpath = new ALine(p.getPoint(i), p.getPoint(i + 1));
                lOfpath.extendEnds(2L);
                if (!whisker.intersects((AGeom)lOfpath)) continue;
                APoint2D intersection = whisker.getIntersectLines(lOfpath);
                long d = Math.abs(whisker.getP0().distance(intersection));
                if (minD != null && d >= minD) continue;
                minD = d;
                minIndex = i;
                minDistFromVertex = intersection.distance(p.getPoint(i));
            }
            if (minD == null) continue;
            intersections.add(new SortedIntersection(minD, wireObject, minIndex, minDistFromVertex));
        }
        Collections.sort(intersections);
        return this.cleanIntersections(intersections);
    }

    protected APoint2D surface(APolygon p, ALine l) {
        ALine v = new ALine(l);
        v.extendEnds(2L);
        for (ALine pLine : p.getLines()) {
            pLine.extendEnds(2L);
            if (!pLine.intersects((AGeom)v)) continue;
            return pLine.getIntersectLines(v);
        }
        return null;
    }

    protected SpringSet createSpringsForWhisker(Topstacle topstacle, ALine whisker, long distanceToSurface, double angle) {
        LinkedList<SortedIntersection> intersections = this.findIntersections(topstacle, whisker);
        if (intersections.size() == 0) {
            return null;
        }
        SpringSet ms = SpringSet.create(whisker, topstacle);
        Wire lastWire = null;
        for (SortedIntersection si : intersections) {
            SingleLayerRouter.RouteInformation r1;
            Wire w = si.t.w;
            long c0 = 0L;
            long c1 = 0L;
            SingleLayerRouter.RouteInformation r0 = this.pr.mWireToRouteInformation.get(lastWire);
            if (r0 != null) {
                c0 = r0.getClear();
            }
            if ((r1 = this.pr.mWireToRouteInformation.get(w)) != null) {
                c1 = r1.getClear();
            }
            long clr = 0L;
            if (r0 == null) {
                ObstacleRelation r = this.pinToWireRelation(topstacle, si.t);
                if (r == ObstacleRelation.Connected) {
                    ALog.logInfo((String)"Problem");
                } else {
                    clr = r == ObstacleRelation.SameNet ? c1 : Math.max(c1, c0);
                }
            } else {
                clr = Math.max(c1, c0);
            }
            long separation = w.getWidth() / 2L;
            if (lastWire != null) {
                separation += lastWire.getWidth() / 2L;
            }
            separation += clr;
            if (angle % 90.0 != 0.0) {
                separation = (long)((double)separation / Math.cos(Math.toRadians(22.5)));
            }
            if (lastWire == null) {
                separation += distanceToSurface;
            }
            ms.addSpring(separation, null, si);
            this.wireToSpring.add((Object)si.t, (Object)ms);
            lastWire = w;
        }
        return ms;
    }

    protected void developSpringForThisPin(Topstacle topstacle) {
        ARect bound = topstacle.getBounds();
        ArrayList<FloodableNode> fns = this.pr.topstacleToFloodableNodes(topstacle);
        Collections.sort(fns, new FloodableNodeSorter());
        long maxLength = 0L;
        for (FloodableNode fn : fns) {
            for (APoint2D intersection : this.pr.intersectionPoints(fn)) {
                long length = topstacle.point.distance(intersection) + 2L;
                maxLength = Math.max(length, maxLength);
            }
        }
        if (maxLength == 0L) {
            return;
        }
        for (double angle = 0.0; angle < 360.0; angle += this.mMinAngle / 2.0) {
            APoint2D start = new APoint2D(topstacle.point);
            long min = Math.min(bound.width(), bound.height());
            min /= 2L;
            if (angle == 45.0) {
                start.setX(bound.getUR().getX() - min);
                start.setY(bound.getUR().getY() - min);
            } else if (angle == 135.0) {
                start.setX(bound.getUL().getX() + min);
                start.setY(bound.getUL().getY() - min);
            } else if (angle == 225.0) {
                start.setX(bound.getLL().getX() + min);
                start.setY(bound.getLL().getY() + min);
            } else if (angle == 315.0) {
                start.setX(bound.getLR().getX() - min);
                start.setY(bound.getLR().getY() + min);
            }
            long distanceToEdge = topstacle.getBounds().height() / 2L;
            ALine whisker = start.makeVector(maxLength + distanceToEdge, angle);
            APoint2D onSurface = this.surface(topstacle.getShape().toPoly(), whisker);
            if (onSurface == null) continue;
            long distanceToSurface = whisker.getP0().distance(onSurface);
            SpringSet ss = this.createSpringsForWhisker(topstacle, whisker, distanceToSurface, angle);
            this.topToSpring.add((Object)topstacle, (Object)ss);
        }
    }

    private boolean relaxThisSpring(SpringSet ss, boolean exact, boolean debug) {
        return this.pushAwayFromThisSpring(ss, debug);
    }

    private boolean pushAwayFromThisSpring(SpringSet ss, boolean debug) {
        ALine span = new ALine(ss.l);
        boolean changed = false;
        long previousRequired = 0L;
        for (Spring spring : ss.springs) {
            SortedIntersection si = (SortedIntersection)spring.o;
            int thisWireIndex = si.pathIndex.index;
            if (thisWireIndex == 0 || thisWireIndex == si.pathIndex.path.getPointCount() - 1) continue;
            long distanceFromStart = 0L;
            APoint2D curPoint = si.pathIndex.path.getPoint(thisWireIndex);
            distanceFromStart = Math.abs(curPoint.distance(span.getP0()));
            if (distanceFromStart < (previousRequired += spring.minSlackFromLast())) {
                APoint2D newPoint = span.fromP1(previousRequired);
                si.pathIndex.path.setPoint(thisWireIndex, newPoint);
                distanceFromStart = previousRequired;
                changed = true;
            }
            previousRequired = distanceFromStart;
        }
        return changed;
    }

    protected Spring getNeighbor(Spring s, int offset) {
        SortedIntersection si = (SortedIntersection)s.o;
        PathIndex pi = si.pathIndex;
        APath myPath = pi.path;
        int neighborIndex = pi.index + offset;
        for (SpringSet as : SpringSet.world) {
            if (as.id == 16 && s.springSet.id == 44) {
                ALog.logInfo((String)"");
            }
            for (Spring aspring : as.springs) {
                SortedIntersection asi = (SortedIntersection)aspring.o;
                PathIndex api = asi.pathIndex;
                if (!api.path.equals((Object)myPath) || api.index != neighborIndex) continue;
                return aspring;
            }
        }
        return null;
    }

    protected Long getMyExcess(Spring s) {
        SpringSet ss = s.springSet;
        ALine l = ss.l;
        APoint2D lastSpringPos = l.getP0();
        for (Spring as : ss.springs) {
            SortedIntersection si = (SortedIntersection)as.o;
            if (as.equals(s)) {
                PathIndex pi = si.pathIndex;
                long slackToLast = pi.path.getPoint(pi.index).distance(lastSpringPos);
                long excess = slackToLast - s.minSlackFromLast();
                return excess;
            }
            lastSpringPos = si.pathIndex.path.getPoint(si.pathIndex.index);
        }
        return null;
    }

    protected void relaxSprings2() {
        LinkedList<Topstacle> sortedTopstacles = new LinkedList<Topstacle>();
        sortedTopstacles.addAll(this.topstacleSet);
        Collections.sort(sortedTopstacles, new TopstacleSorter());
        for (int pass = 0; pass < 1; ++pass) {
            int t = 0;
            for (Topstacle topstacle : sortedTopstacles) {
                SpringSet.restart();
                this.wireToSpring.clear();
                this.developSpringForThisPin(topstacle);
                this.relaxSprings(t);
                ++t;
            }
        }
    }

    protected void relaxSprings(int t) {
        for (TopologicalObject wTop : this.mFlexibleTopologicalSet) {
            LinkedList<Info> springIntersections = new LinkedList<Info>();
            if (this.wireToSpring.get((Object)wTop) == null) continue;
            for (SpringSet springSet : (LinkedList)this.wireToSpring.get((Object)wTop)) {
                for (Spring spring : springSet.springs) {
                    SortedIntersection si = (SortedIntersection)spring.o;
                    if (si.t != wTop) continue;
                    Info info = new Info();
                    info.si = si;
                    info.springSet = springSet;
                    info.spring = spring;
                    springIntersections.add(info);
                    spring.draw(this.pr, si.d, "" + springSet.id);
                }
            }
            Collections.sort(springIntersections);
            APath xfer = new APath();
            int firstIndex = ((Info)springIntersections.getFirst()).si.index;
            int lastIndex = ((Info)springIntersections.getLast()).si.index;
            APath pre = new APath();
            for (int index = 0; index <= firstIndex; ++index) {
                pre.addPoint(wTop.current.getPoint(index));
            }
            APath post = new APath();
            for (int index = lastIndex + 1; index < wTop.current.getPointCount(); ++index) {
                post.addPoint(wTop.current.getPoint(index));
            }
            xfer.addAll(pre);
            int thisIndex = xfer.getSize();
            for (Info intersectionInfo : springIntersections) {
                APoint2D newPoint = intersectionInfo.springSet.pointFromStart(intersectionInfo.si.d);
                intersectionInfo.spring.setCur(intersectionInfo.si.d);
                xfer.addPoint(newPoint);
                intersectionInfo.si.pathIndex.path = xfer;
                intersectionInfo.si.pathIndex.index = thisIndex++;
            }
            xfer.addAll(post);
            wTop.current = xfer;
        }
        SpringSet.sort();
        for (SpringSet ss : SpringSet.world) {
            this.relaxThisSpring(ss, true, true);
        }
    }

    protected void convertDbToTopologicalObjects() {
        this.convertWiresToTopologicalObjects();
        this.convertPinsToTopologicalObjects();
    }

    protected static APath movePath(APath p, ALine v) {
        return null;
    }

    public class TopstacleSorter
    implements Comparator<Topstacle> {
        @Override
        public int compare(Topstacle m0, Topstacle m1) {
            if (m0.point.getX() < m1.point.getX()) {
                return 1;
            }
            if (m0.point.getX() > m1.point.getX()) {
                return -1;
            }
            return 0;
        }
    }

    public class UniqueGeomSorter
    implements Comparator<TopologicalObject> {
        @Override
        public int compare(TopologicalObject m0, TopologicalObject m1) {
            if (m0.original.getFirstPoint().getY() < m1.original.getFirstPoint().getY()) {
                return 1;
            }
            if (m0.original.getFirstPoint().getY() > m1.original.getFirstPoint().getY()) {
                return -1;
            }
            if (m0.original.getFirstPoint().getX() < m1.original.getFirstPoint().getX()) {
                return 1;
            }
            if (m0.original.getFirstPoint().getX() > m1.original.getFirstPoint().getX()) {
                return -1;
            }
            return 0;
        }
    }

    protected static class TopologicalObject
    implements Comparable<TopologicalObject> {
        Frontier frontier = null;
        boolean flexible = false;
        double angleFace = 0.0;
        APath original = null;
        APath current = null;
        APath save = null;
        APoint2D c = null;
        Net net = null;
        Wire w = null;
        Topstacle t = null;
        int changes = 0;

        protected TopologicalObject() {
        }

        public void close() {
            this.current = this.original.copy();
        }

        public void setFrontier(Frontier frontierArea) {
            this.frontier = frontierArea;
        }

        public Frontier getFrontier() {
            return this.frontier;
        }

        @Override
        public int compareTo(TopologicalObject o) {
            return this.original.getFirstPoint().add(this.original.getLastPoint()).compareTo(o.original.getFirstPoint().add(o.original.getLastPoint()));
        }
    }

    static class Info
    implements Comparable<Info> {
        SortedIntersection si;
        SpringSet springSet;
        Spring spring;
        boolean ok;

        Info() {
        }

        @Override
        public int compareTo(Info o) {
            if (o.si.index == this.si.index) {
                if (o.si.dFromVertex > this.si.dFromVertex) {
                    return -1;
                }
                return 1;
            }
            return this.si.index - o.si.index;
        }

        public String toString() {
            return "" + this.springSet.id;
        }
    }

    public static class FloodableNodeSorter
    implements Comparator<FloodableNode> {
        @Override
        public int compare(FloodableNode o1, FloodableNode o2) {
            ALine p0 = o1.span;
            ALine p1 = o2.span;
            return p0.compareTo((AGeom)p1);
        }
    }

    public static class PathSorter
    implements Comparator<TopologicalObject> {
        @Override
        public int compare(TopologicalObject o1, TopologicalObject o2) {
            APath p0 = o1.original;
            APath p1 = o2.original;
            return p0.getFirstPoint().compareTo(p1.getFirstPoint());
        }
    }

    protected class PushNode {
        protected TopologicalObject t;
        protected Frontier frontierTri;

        public PushNode(TopologicalObject t, Frontier frontierTri) {
            this.t = t;
            this.frontierTri = frontierTri;
        }

        protected APath extractInfluentialSection() {
            if (!this.t.flexible) {
                return this.t.original;
            }
            return this.t.original;
        }

        protected APath maxPath(Frontier frontier, APath above, APath below, double angle) {
            AffineTransform t = new AffineTransform();
            AffineTransform t0 = new AffineTransform();
            long cx = frontier.from.t.point.getX();
            long cy = frontier.from.t.point.getY();
            double incrAngle = 90.0 - angle;
            t.setToRotation(Math.toRadians(incrAngle), cx, cy);
            t0.setToRotation(Math.toRadians(-incrAngle), cx, cy);
            APath aboveT = above.transform(t);
            APath belowT = below.transform(t);
            APath pushedPath = PathUtil.moveAbove(aboveT, belowT);
            return pushedPath.transform(t0);
        }

        class Plunger {
            APath face;
            ALine l0;
            ALine l1;
            ALine test0;
            ALine test1;

            Plunger() {
            }

            public void develop(APath f, APoint2D c, double angle) {
                APoint2D p1;
                APoint2D p0;
                this.face = f.copy();
                AffineTransform t = new AffineTransform();
                AffineTransform t0 = new AffineTransform();
                long cx = c.getX();
                long cy = c.getY();
                double incrAngle = 90.0 - angle;
                t.setToRotation(Math.toRadians(incrAngle), cx, cy);
                t0.setToRotation(Math.toRadians(-incrAngle), cx, cy);
                APath faceT = this.face.transform(t);
                if (faceT.getFirstPoint().getX() > faceT.getLastPoint().getX()) {
                    APoint2D p12 = SpringRouter.this.snap(faceT.getFirstPoint(), PushDir.UpLeft);
                    APoint2D p02 = SpringRouter.this.snap(faceT.getLastPoint(), PushDir.UpRight);
                    this.l0 = new ALine(p12.getX(), cy, p12.getX(), p12.getY());
                    this.l1 = new ALine(p02.getX(), cy, p02.getX(), p02.getY());
                    this.test0 = new ALine(cx, cy, p12.getX(), p12.getY());
                    this.test1 = new ALine(cx, cy, p02.getX(), p02.getY());
                } else {
                    p0 = SpringRouter.this.snap(faceT.getFirstPoint(), PushDir.UpLeft);
                    p1 = SpringRouter.this.snap(faceT.getLastPoint(), PushDir.UpRight);
                    this.l0 = new ALine(p0.getX(), cy, p0.getX(), p0.getY());
                    this.l1 = new ALine(p1.getX(), cy, p1.getX(), p1.getY());
                    this.test0 = new ALine(cx, cy, p0.getX(), p0.getY());
                    this.test1 = new ALine(cx, cy, p1.getX(), p1.getY());
                }
                p0 = SpringRouter.this.snap(faceT.getFirstPoint(), PushDir.UpLeft);
                p1 = SpringRouter.this.snap(faceT.getLastPoint(), PushDir.UpRight);
                this.l0 = new ALine(p0.getX(), cy, p0.getX(), p0.getY());
                this.l1 = new ALine(p1.getX(), cy, p1.getX(), p1.getY());
                this.l0 = this.l0.transform(t0);
                this.l1 = this.l1.transform(t0);
                this.test0 = this.test0.transform(t0);
                this.test1 = this.test1.transform(t0);
            }
        }

        protected class AreaPusher {
            Frontier frontierArea;

            protected AreaPusher() {
            }
        }
    }

    static class PushSet
    extends LinkedList<TopologicalObject> {
        PushSet() {
        }
    }

    protected class Frontier {
        protected ALine whisker;
        protected ALine startSection;
        protected ALine endSection;
        protected ALine startSectionExpanded;
        protected ALine endSectionExpanded;
        protected APath frontier;
        protected double cAngle;
        protected LinkedList<SortedIntersection> flexibleList = new LinkedList();
        protected LinkedList<PushNode> pushNodes = new LinkedList();
        protected TopologicalObject from;

        public Frontier(ALine whisker, double angle, APath frontier) {
            this.whisker = whisker;
            this.frontier = frontier;
            this.cAngle = angle;
            double a = whisker.getAngle();
            double a0 = a - this.cAngle / 2.0;
            double a1 = a0 + this.cAngle;
            this.startSection = new ALine();
            this.endSection = new ALine();
            this.startSection = whisker.getP0().makeVector(whisker.getLength(), a0);
            this.endSection = whisker.getP0().makeVector(whisker.getLength(), a1);
            AVector push0 = new AVector(500L, Math.toRadians(a0 - 90.0));
            this.startSectionExpanded = new ALine(this.startSection);
            this.startSectionExpanded.moveBy(push0.getX(), push0.getY());
            AVector push1 = new AVector(500L, Math.toRadians(a0 + 90.0));
            this.endSectionExpanded = new ALine(this.endSection);
            this.endSectionExpanded.moveBy(push1.getX(), push1.getY());
        }

        public double angle() {
            return this.whisker.getAngle();
        }

        public void setFlexibleList(LinkedList<SortedIntersection> intersections) {
            this.flexibleList = intersections;
            LinkedList<SortedIntersection> clean = new LinkedList<SortedIntersection>();
            HashSet<TopologicalObject> processed = new HashSet<TopologicalObject>();
            for (int i = 0; i < intersections.size(); ++i) {
                if (processed.contains(intersections.get((int)i).t)) continue;
                processed.add(intersections.get((int)i).t);
                int best = i;
                for (int j = i + i; j < intersections.size(); ++j) {
                    if (!intersections.get((int)i).t.equals(intersections.get((int)j).t) || intersections.get((int)j).d >= intersections.get((int)best).d) continue;
                    best = j;
                }
                clean.add(intersections.get(best));
            }
        }

        public LinkedList<TopologicalObject> getFlexibleFrontier() {
            LinkedList<TopologicalObject> list = new LinkedList<TopologicalObject>();
            for (SortedIntersection intersection : this.flexibleList) {
                list.add(intersection.t);
            }
            return list;
        }
    }

    static class SortedIntersection
    implements Comparable<SortedIntersection> {
        long dFromVertex;
        long d;
        int index;
        TopologicalObject t;
        PathIndex pathIndex = new PathIndex();

        public SortedIntersection(long d, TopologicalObject t) {
            this.d = d;
            this.t = t;
        }

        public SortedIntersection(long d, TopologicalObject t, int index, long dFromVertex) {
            this.d = d;
            this.t = t;
            this.index = index;
            this.dFromVertex = dFromVertex;
        }

        @Override
        public int compareTo(SortedIntersection o) {
            return Long.compare(this.d, o.d);
        }
    }

    static class PathIndex {
        APath path;
        int index;

        PathIndex() {
        }
    }

    static class IntersectionIndex {
        APoint2D intersection = null;
        int idx = -1;

        IntersectionIndex() {
        }
    }

    public static enum ObstacleRelation {
        DifferentNet,
        SameNet,
        Connected;

    }

    public static enum PushDir {
        Right,
        UpRight,
        Up,
        UpLeft,
        Left,
        DnLeft,
        Dn,
        DnRight,
        Unknown;

    }
}

