/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.router.NonMonotonicPusher;
import com.sigrity.orbit.automation.router.Spring;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class SpringSet {
    protected ALine l;
    public LinkedList<Spring> springs = new LinkedList();
    static LinkedList<SpringSet> world = new LinkedList();
    Object owner;
    protected int id = nextIndex++;
    static int nextIndex = 0;

    public static void restart() {
        nextIndex = 0;
        world.clear();
    }

    protected SpringSet() {
    }

    public int id() {
        return this.id;
    }

    public static SpringSet create(ALine l, Object owner) {
        ALine extendedLine = new ALine(l);
        extendedLine.extendP1ByOrtho(l.getLength());
        SpringSet ms = new SpringSet();
        ms.l = extendedLine;
        ms.owner = owner;
        world.add(ms);
        return ms;
    }

    public ALine getLine() {
        return this.l;
    }

    public Object owner() {
        return this.owner;
    }

    public Spring addSpring(Long min, Long max, Object o) {
        Spring s = new Spring();
        s.min = min;
        s.max = max;
        s.o = o;
        s.springSet = this;
        this.springs.add(s);
        return s;
    }

    public void relax() {
        long required = 0L;
        long last = 0L;
        for (Spring spring : this.springs) {
            if (spring == null || spring.cur == null || spring.min == null) {
                return;
            }
            long d = spring.cur - last - spring.min;
            if (d < 0L) {
                required += -d;
            }
            last = spring.cur;
        }
        if (required == 0L) {
            return;
        }
        last = 0L;
        for (Spring spring : this.springs) {
            long move = 0L;
            long excess = spring.cur - last - spring.min;
            if (excess < 0L) {
                move = -excess;
            } else if (required > 0L) {
                move = Math.min(excess, required);
                move = -move;
            }
            if (move != 0L) {
                spring.move(move);
                required -= move;
            }
            last = spring.cur;
        }
    }

    public static void spread(int id) {
        for (SpringSet ss : world) {
            if (ss.id != id) continue;
            ss.spread();
            break;
        }
    }

    protected APoint2D myPoint(Spring s) {
        NonMonotonicPusher.SortedIntersection si = (NonMonotonicPusher.SortedIntersection)s.o;
        int index = si.pathIndex.index;
        APoint2D p = si.pathIndex.path.getPoint(index);
        return new APoint2D(p);
    }

    public void spread() {
        for (Spring spring : this.springs) {
            if (spring != null && spring.cur != null && spring.min != null) continue;
            return;
        }
        APoint2D lastP = this.l.getP0();
        for (Spring spring : this.springs) {
            NonMonotonicPusher.SortedIntersection si = (NonMonotonicPusher.SortedIntersection)spring.o;
            int index = si.pathIndex.index;
            APoint2D p = this.myPoint(spring);
            long thisDist = p.distance(lastP);
            if (thisDist < spring.min) {
                Spring sBefore;
                APoint2D lastPB = this.l.getP0();
                Iterator iterator = this.springs.iterator();
                while (iterator.hasNext() && !(sBefore = (Spring)iterator.next()).equals(spring)) {
                    long iCanMove = p.distance(lastPB);
                    if (iCanMove <= 0L) continue;
                    sBefore.move(-iCanMove);
                }
            }
            lastP = si.pathIndex.path.getPoint(index);
        }
    }

    public APoint2D pointFromStart(long distance) {
        ALine v = this.l.getP0().makeVector(distance, this.l.getAngle());
        return v.getP1();
    }

    public static void relax(int id) {
        for (SpringSet ss : world) {
            if (ss.id != id) continue;
            ss.relax();
            break;
        }
    }

    public static void relaxSet(HashSet<SpringSet> set) {
        for (SpringSet ss : set) {
            ss.relax();
        }
    }

    public static void relaxWorld() {
        for (SpringSet ss : world) {
            ss.relax();
        }
    }

    public static void sort() {
        Collections.sort(world, new AngleSorter());
    }

    public static class AngleSorter
    implements Comparator<SpringSet> {
        @Override
        public int compare(SpringSet ss1, SpringSet ss2) {
            return (int)(ss1.l.getAngle() - ss2.l.getAngle());
        }
    }
}

