/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class Topstacle
implements Comparable<Topstacle> {
    protected AGeom shape;
    protected APoint2D point;
    protected Net net;
    protected Object owner;
    protected String id;
    protected ArrayList<SingleLayerRouter.Channel> cList = new ArrayList();
    protected long maxWhisker;

    public Topstacle(APoint2D p, Object o, Net n) {
        this(p, o, n, "");
    }

    public Topstacle(APoint2D p, Object o, Net n, String s) {
        this.point = p;
        this.net = n;
        this.owner = o;
        this.id = s;
    }

    public void setPoint(APoint2D point) {
        this.point = point;
    }

    public void moveBy(APoint2D ds) {
        this.point.moveBy(ds);
        this.shape.moveBy(ds.getX(), ds.getY());
    }

    public void setShape(AGeom s) {
        this.shape = s.copy();
    }

    public AGeom getShape() {
        return this.shape;
    }

    public void setMaxWhisker(long w) {
        this.maxWhisker = w;
    }

    public long getMaxWhisker() {
        return this.maxWhisker;
    }

    public boolean sameOwner(Topstacle other) {
        long distance = this.point.distance(other.point);
        return distance == 0L;
    }

    public APoint2D getPoint() {
        return this.point;
    }

    public Net getNet() {
        return this.net;
    }

    public String toString() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public Object getOwner() {
        return this.owner;
    }

    public PinInstance toPinInstance() {
        PinInstance dp = ((HierPin)this.owner).getPin();
        return dp;
    }

    public HierPin toDevicePathPort() {
        HierPin dpp = (HierPin)this.owner;
        return dpp;
    }

    public static Topstacle fromDevicePathPort(DevicePath dPath, PinInstance dPort) {
        HierPin dpp = new HierPin(dPath, dPort);
        return Topstacle.fromDevicePathPort(dpp);
    }

    public static Topstacle fromDevicePathPort(HierPin dpp) {
        DeviceTemplate substrateTemplate = dpp.getPath().pathToSubstrate().getDeviceTemplate();
        APoint2D p = dpp.getSubstrateLoc();
        Net n = NetMap.getNetAt((Net)dpp.getDbObject().getNet(), (DevicePath)dpp.getPath(), (DeviceTemplate)substrateTemplate);
        Topstacle topstacle = new Topstacle(p, dpp, n);
        topstacle.setId(dpp.getPath().toString() + "/" + dpp.getDbObject().getName());
        return topstacle;
    }

    public static Topstacle fromDevicePathPort(HierPin dpp, Layer l) {
        DeviceTemplate substrateTemplate = dpp.getPath().pathToSubstrate() != null ? dpp.getPath().pathToSubstrate().getDeviceTemplate() : dpp.getPath().getDeviceTemplate();
        APoint2D p = dpp.getSubstrateLoc();
        Net n = NetMap.getNetAt((Net)dpp.getDbObject().getNet(), (DevicePath)dpp.getPath(), (DeviceTemplate)substrateTemplate);
        Topstacle topstacle = new Topstacle(p, dpp, n);
        topstacle.setId(dpp.getPath().toString() + "/" + dpp.getDbObject().getName());
        return topstacle;
    }

    public static Topstacle fromDevicePathPort(HierPin dpp, Layer l, HierPin via) {
        DeviceTemplate substrateTemplate = dpp.getPath().pathToSubstrate().getDeviceTemplate();
        APoint2D p = via.getSubstrateLoc();
        Net n = NetMap.getNetAt((Net)dpp.getDbObject().getNet(), (DevicePath)dpp.getPath(), (DeviceTemplate)substrateTemplate);
        Topstacle topstacle = new Topstacle(p, dpp, n);
        topstacle.setId(dpp.getPath().toString() + "/" + dpp.getDbObject().getName());
        return topstacle;
    }

    public static Topstacle fromBlockage(Obstacle o, DevicePath devicePathOfGeom, AGeom geom, Layer l) {
        AffineTransform t = devicePathOfGeom.getTransform();
        APoint2D p = geom.getBounds().center();
        p = p.transform(t);
        AGeom g = geom.transform(t);
        Net n = devicePathOfGeom.getDeviceTemplate().getNetUnused();
        Topstacle topstacle = new Topstacle(p, o, n);
        topstacle.setId("Obstacle");
        topstacle.setShape(g);
        return topstacle;
    }

    @Override
    public int compareTo(Topstacle other) {
        long compare = this.getPoint().getX() - other.getPoint().getX();
        if (compare == 0L) {
            compare = this.getPoint().getY() - other.getPoint().getY();
        }
        if (compare > 0L) {
            return 1;
        }
        if (compare < 0L) {
            return -1;
        }
        return 0;
    }

    public ARect getBounds() {
        return this.shape.getBounds();
    }

    public void addChannel(SingleLayerRouter.Channel c) {
        this.cList.add(c);
    }

    public ArrayList<SingleLayerRouter.Channel> getChannelList() {
        return this.cList;
    }
}

