/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import java.util.Collections;
import java.util.LinkedList;

public class WireInsertRemove {
    SingleLayerRouter slr;
    SingleLayerRouter.Aisle a;

    public void setSingleLayerRouter(SingleLayerRouter slr) {
        this.slr = slr;
    }

    public void addWire(Wire w) {
        APath path = w.getPath();
        LinkedList<FloodableNode> allFns = new LinkedList<FloodableNode>();
        ALog.logInfo((String)"after");
        for (ALine l : path.getLines()) {
            l.extendEnds(2L);
            LinkedList<FloodableNode> thisLinesFns = new LinkedList<FloodableNode>();
            for (FloodableNode fn : this.slr.mFloodableNodes) {
                ALine span;
                fn.deriveSpan();
                if (fn.mId == 1116) {
                    // empty if block
                }
                if ((span = fn.span) == null || !span.intersects((AGeom)l)) continue;
                thisLinesFns.add(fn);
            }
            Collections.sort(thisLinesFns, new SingleLayerRouter.IntersectionSorter(l));
            for (FloodableNode fn : thisLinesFns) {
                if (allFns.contains(fn)) continue;
                allFns.add(fn);
            }
        }
        int size = allFns.size();
        for (int idx = 0; idx < size; ++idx) {
            FloodableNode fn = (FloodableNode)allFns.get(idx);
            FloodableNode lastNode = idx > 0 ? (FloodableNode)allFns.get(idx - 1) : null;
            FloodableNode nextNode = idx < size - 1 ? (FloodableNode)allFns.get(idx + 1) : null;
            ALog.logInfo((String)(idx + " " + fn.mId));
        }
    }
}

